import * as VScript from "vscript";
import * as VAPI from "./index.js";
import { split_sdp } from "./toplevel/sdp.js";
export var Audio;
(function (Audio) {
    Audio.lift = {
        Essence: (_raw) => (new Essence(_raw)),
        TimedSource: (_raw, _socket) => {
            return {
                source: _raw[0] === null ? null : new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                switch_time: _raw[1] === null ? null : VScript.VAPIHelpers.liftTimestamp(_raw[1], _socket)
            };
        },
    };
    Audio.lower = {
        Essence: (_x) => _x.raw.kwl,
        TimedSource: (_x, _socket) => [
            _x.source === null ? null : _x.source.raw.kwl,
            _x.switch_time === null ? null : VScript.VAPIHelpers.lowerTimestamp(_x.switch_time, _socket)
        ],
    };
    class Essence {
        raw;
        type_identifier = "Audio::Data::Essence";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get sop_dt_node() {
            return new VScript.rKeyword(this, "sop_dt_node", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get channels() {
            return new VScript.rKeywordReferenceable(this, "channels", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel)),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel))
            });
        }
        /**
          some signal sources, such as RTP audio/video streams, include a
          well-defined offset to the PTP epoch (as seen by the sender). During
          processing, these 'media clocks' may shift (e.g., as signals pass through
          delay elements) or broaden into finite intervals (e.g., as audio channels
          at different offsets to the PTP epoch are combined into a single audio
          essence). Using the `media_clock` keyword, such changes are tracked
          explicitly and forwarded to audio/video transmitters.
        */
        get media_clock() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "media_clock"));
        }
    }
    Audio.Essence = Essence;
})(Audio || (Audio = {}));
export var AudioGain;
(function (AudioGain) {
    AudioGain.lift = {
        All: (_raw) => (new All(_raw)),
        Levels: (_raw) => (new Levels(_raw)),
    };
    AudioGain.lower = {
        All: (_x) => _x.raw.kwl,
        Levels: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "AudioGain::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get instances() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "instances"), (raw) => new VAPI.AT1101.AudioGain.LevelsAsNamedTableRow(raw));
        }
    }
    AudioGain.All = All;
    class Levels {
        raw;
        type_identifier = "AudioGain::Data::Levels";
        constructor(raw) {
            this.raw = raw;
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get levels() {
            return new VScript.rwKeyword(this, "levels", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftMaybeSparseArray((x /* FIXME */, _) => x),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftMaybeSparseArray((x /* FIXME */, _) => x),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get output() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "output"));
        }
    }
    AudioGain.Levels = Levels;
    class LevelsAsNamedTableRow extends Levels {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioGain.LevelsAsNamedTableRow = LevelsAsNamedTableRow;
})(AudioGain || (AudioGain = {}));
export var AudioMixer;
(function (AudioMixer) {
    AudioMixer.lift = {
        All: (_raw) => (new All(_raw)),
        ChannelMono: (_raw) => (new ChannelMono(_raw)),
        ChannelSelection: (_raw) => (new ChannelSelection(_raw)),
        ChannelStereo: (_raw) => (new ChannelStereo(_raw)),
        Downmixes: (_raw) => (new Downmixes(_raw)),
        Mode51: (_raw) => (new Mode51(_raw)),
        Mode71: (_raw) => (new Mode71(_raw)),
        Monos: (_raw) => (new Monos(_raw)),
        Source: (_raw) => (new Source(_raw)),
        SourceStereo: (_raw) => (new SourceStereo(_raw)),
        Stereos: (_raw) => (new Stereos(_raw)),
        StereosOutput: (_raw) => (new StereosOutput(_raw)),
    };
    AudioMixer.lower = {
        All: (_x) => _x.raw.kwl,
        ChannelMono: (_x) => _x.raw.kwl,
        ChannelSelection: (_x) => _x.raw.kwl,
        ChannelStereo: (_x) => _x.raw.kwl,
        Downmixes: (_x) => _x.raw.kwl,
        Mode51: (_x) => _x.raw.kwl,
        Mode71: (_x) => _x.raw.kwl,
        Monos: (_x) => _x.raw.kwl,
        Source: (_x) => _x.raw.kwl,
        SourceStereo: (_x) => _x.raw.kwl,
        Stereos: (_x) => _x.raw.kwl,
        StereosOutput: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "AudioMixer::Data::All";
        get runtime_constants() {
            return {
                num_audio_mixer_fader: this.raw.backing_store.get_runtime_constant("AudioMixer::num_audio_mixer_fader"),
                num_audio_mixer_outputs: this.raw.backing_store.get_runtime_constant("AudioMixer::num_audio_mixer_outputs")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        /**
          @brief Defragment
          @desc Repeated allocation and deallocation of differently sized mixers
          can cause fader fragmentation. Press this button to defragment, but
          please note that _this will temporarily interrupt all outputs currently
          in use_.
        */
        get reorder_output() {
            return new VScript.wKeyword(this, "reorder_output", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get mono_mixes() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "mono_mixes"), (raw) => new VAPI.AT1101.AudioMixer.MonosAsNamedTableRow(raw));
        }
        get stereo_mixes() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 2, "stereo_mixes"), (raw) => new VAPI.AT1101.AudioMixer.StereosAsNamedTableRow(raw));
        }
        get down_mixes() {
            return VAPI.AT1101.AudioMixer.lift.Downmixes(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "down_mixes"));
        }
        get resource_status() {
            return VAPI.AudioMixer.lift.ResourceStatus(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "resource_status"));
        }
        get audio_source_slices() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 5, "audio_source_slices"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
    }
    AudioMixer.All = All;
    class ChannelMono {
        raw;
        type_identifier = "AudioMixer::Data::ChannelMono";
        constructor(raw) {
            this.raw = raw;
        }
        get gain() {
            return new VScript.rwKeyword(this, "gain", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get mute() {
            return new VScript.rwKeyword(this, "mute", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get pan() {
            return new VScript.rwKeyword(this, "pan", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get source() {
            return VAPI.AT1101.AudioMixer.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "source"));
        }
    }
    AudioMixer.ChannelMono = ChannelMono;
    class ChannelMonoAsNamedTableRow extends ChannelMono {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioMixer.ChannelMonoAsNamedTableRow = ChannelMonoAsNamedTableRow;
    class ChannelSelection {
        raw;
        type_identifier = "AudioMixer::Data::ChannelSelection";
        constructor(raw) {
            this.raw = raw;
        }
        get gain() {
            return new VScript.rwKeyword(this, "gain", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get mute() {
            return new VScript.rwKeyword(this, "mute", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get source() {
            return VAPI.AT1101.AudioMixer.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "source"));
        }
    }
    AudioMixer.ChannelSelection = ChannelSelection;
    class ChannelSelectionAsNamedTableRow extends ChannelSelection {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioMixer.ChannelSelectionAsNamedTableRow = ChannelSelectionAsNamedTableRow;
    class ChannelStereo {
        raw;
        type_identifier = "AudioMixer::Data::ChannelStereo";
        constructor(raw) {
            this.raw = raw;
        }
        get gain() {
            return new VScript.rwKeyword(this, "gain", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get mute() {
            return new VScript.rwKeyword(this, "mute", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get balance() {
            return new VScript.rwKeyword(this, "balance", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get source() {
            return VAPI.AT1101.AudioMixer.lift.SourceStereo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "source"));
        }
    }
    AudioMixer.ChannelStereo = ChannelStereo;
    class ChannelStereoAsNamedTableRow extends ChannelStereo {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioMixer.ChannelStereoAsNamedTableRow = ChannelStereoAsNamedTableRow;
    class Downmixes {
        raw;
        type_identifier = "AudioMixer::Data::Downmixes";
        constructor(raw) {
            this.raw = raw;
        }
        get mode_5_1() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "mode_5_1"), (raw) => new VAPI.AT1101.AudioMixer.Mode51AsNamedTableRow(raw));
        }
        get mode_7_1() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "mode_7_1"), (raw) => new VAPI.AT1101.AudioMixer.Mode71AsNamedTableRow(raw));
        }
    }
    AudioMixer.Downmixes = Downmixes;
    class Mode51 {
        raw;
        type_identifier = "AudioMixer::Data::Mode51";
        constructor(raw) {
            this.raw = raw;
        }
        get front_left() {
            return VAPI.AT1101.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "front_left"));
        }
        get front_right() {
            return VAPI.AT1101.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "front_right"));
        }
        get center() {
            return VAPI.AT1101.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "center"));
        }
        get lfe() {
            return VAPI.AT1101.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "lfe"));
        }
        get rear_surround_left() {
            return VAPI.AT1101.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "rear_surround_left"));
        }
        get rear_surround_right() {
            return VAPI.AT1101.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "rear_surround_right"));
        }
        get output() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "output"));
        }
    }
    AudioMixer.Mode51 = Mode51;
    class Mode51AsNamedTableRow extends Mode51 {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioMixer.Mode51AsNamedTableRow = Mode51AsNamedTableRow;
    class Mode71 {
        raw;
        type_identifier = "AudioMixer::Data::Mode71";
        constructor(raw) {
            this.raw = raw;
        }
        get front_left() {
            return VAPI.AT1101.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "front_left"));
        }
        get front_right() {
            return VAPI.AT1101.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "front_right"));
        }
        get center() {
            return VAPI.AT1101.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "center"));
        }
        get surround_left() {
            return VAPI.AT1101.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "surround_left"));
        }
        get surround_right() {
            return VAPI.AT1101.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "surround_right"));
        }
        get lfe() {
            return VAPI.AT1101.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "lfe"));
        }
        get rear_surround_left() {
            return VAPI.AT1101.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "rear_surround_left"));
        }
        get rear_surround_right() {
            return VAPI.AT1101.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "rear_surround_right"));
        }
        get output() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "output"));
        }
    }
    AudioMixer.Mode71 = Mode71;
    class Mode71AsNamedTableRow extends Mode71 {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioMixer.Mode71AsNamedTableRow = Mode71AsNamedTableRow;
    class Monos {
        raw;
        type_identifier = "AudioMixer::Data::Monos";
        constructor(raw) {
            this.raw = raw;
        }
        get channels() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "channels"), (raw) => new VAPI.AT1101.AudioMixer.ChannelSelectionAsNamedTableRow(raw));
        }
        get output() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "output"));
        }
    }
    AudioMixer.Monos = Monos;
    class MonosAsNamedTableRow extends Monos {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioMixer.MonosAsNamedTableRow = MonosAsNamedTableRow;
    class Source {
        raw;
        type_identifier = "AudioMixer::Data::Source";
        constructor(raw) {
            this.raw = raw;
        }
        get channel() {
            return new VScript.dKeyword(this, "channel", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
    }
    AudioMixer.Source = Source;
    class SourceStereo {
        raw;
        type_identifier = "AudioMixer::Data::SourceStereo";
        constructor(raw) {
            this.raw = raw;
        }
        get channel_left() {
            return new VScript.dKeyword(this, "channel_left", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get channel_right() {
            return new VScript.dKeyword(this, "channel_right", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
    }
    AudioMixer.SourceStereo = SourceStereo;
    class Stereos {
        raw;
        type_identifier = "AudioMixer::Data::Stereos";
        constructor(raw) {
            this.raw = raw;
        }
        get mono_channels() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "mono_channels"), (raw) => new VAPI.AT1101.AudioMixer.ChannelMonoAsNamedTableRow(raw));
        }
        get stereo_pairs() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "stereo_pairs"), (raw) => new VAPI.AT1101.AudioMixer.ChannelStereoAsNamedTableRow(raw));
        }
        get output() {
            return VAPI.AT1101.AudioMixer.lift.StereosOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "output"));
        }
    }
    AudioMixer.Stereos = Stereos;
    class StereosAsNamedTableRow extends Stereos {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioMixer.StereosAsNamedTableRow = StereosAsNamedTableRow;
    class StereosOutput {
        raw;
        type_identifier = "AudioMixer::Data::Stereos::Output";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          Reset to default
        */
        get reset_to_default() {
            return new VScript.wKeyword(this, "reset_to_default", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get gain() {
            return new VScript.rwKeyword(this, "gain", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get output() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "output"));
        }
    }
    AudioMixer.StereosOutput = StereosOutput;
})(AudioMixer || (AudioMixer = {}));
export var AudioRePlay;
(function (AudioRePlay) {
    AudioRePlay.lift = {
        Audio: (_raw) => (new Audio(_raw)),
        Buffer: (_raw) => (new Buffer(_raw)),
        Delay: (_raw) => (new Delay(_raw)),
        DelayOutput: (_raw) => (new DelayOutput(_raw)),
        Player: (_raw) => (new Player(_raw)),
        PlayerOutput: (_raw) => (new PlayerOutput(_raw)),
        RelationAudio: (_raw) => (new RelationAudio(_raw)),
        RelationVideo: (_raw) => (new RelationVideo(_raw)),
        Relations: (_raw) => (new Relations(_raw)),
        Time: (_raw) => (new Time(_raw)),
        RelationAudioFollowers: (_raw) => (new RelationAudioFollowers(_raw)),
        RelationVideoFollowers: (_raw) => (new RelationVideoFollowers(_raw)),
        DelayInputs: (_raw) => (new DelayInputs(_raw)),
    };
    AudioRePlay.lower = {
        Audio: (_x) => _x.raw.kwl,
        Buffer: (_x) => _x.raw.kwl,
        Delay: (_x) => _x.raw.kwl,
        DelayOutput: (_x) => _x.raw.kwl,
        Player: (_x) => _x.raw.kwl,
        PlayerOutput: (_x) => _x.raw.kwl,
        RelationAudio: (_x) => _x.raw.kwl,
        RelationVideo: (_x) => _x.raw.kwl,
        Relations: (_x) => _x.raw.kwl,
        Time: (_x) => _x.raw.kwl,
        RelationAudioFollowers: (_x) => _x.raw.kwl,
        RelationVideoFollowers: (_x) => _x.raw.kwl,
        DelayInputs: (_x) => _x.raw.kwl,
    };
    class Audio {
        raw;
        type_identifier = "AudioRePlay::Data::Audio";
        constructor(raw) {
            this.raw = raw;
        }
        get info() {
            return VAPI.DataRePlay.lift.MemoryInfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "info"));
        }
        get players() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "players"), (raw) => new VAPI.AT1101.AudioRePlay.PlayerAsNamedTableRow(raw));
        }
        get delays() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 2, "delays"), (raw) => new VAPI.AT1101.AudioRePlay.DelayAsNamedTableRow(raw));
        }
        get statistics() {
            return VAPI.DataRePlay.lift.Statistic(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "statistics"));
        }
        get ecc() {
            return VAPI.Memory.lift.ECCMuxStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "ecc"));
        }
        get audio_source_slices() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 5, "audio_source_slices"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
    }
    AudioRePlay.Audio = Audio;
    class Buffer {
        raw;
        type_identifier = "AudioRePlay::Data::Buffer";
        constructor(raw) {
            this.raw = raw;
        }
        get offset() {
            return new VScript.dKeyword(this, "offset", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lift.AllocationMode),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lower.AllocationMode)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lift.AllocationMode),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lower.AllocationMode)
            }, (parent, command) => (void parent, void command, { criterion: "status", validator: (status) => (command === null && status === null) || (command !== null && status !== null) && ((command.variant === 'Samples' && status.variant === 'Samples' && status.value.samples >= command.value.samples) || (command.variant === 'Time' && status.variant === 'Time' && status.value.time.s() >= command.value.time.s())) }));
        }
        get audio_follow_video() {
            return new VScript.dKeyword(this, "audio_follow_video", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get auto_dolby_e_aligner() {
            return new VScript.dKeyword(this, "auto_dolby_e_aligner", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get measurement_reference() {
            return new VScript.dKeyword(this, "measurement_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get current_delay() {
            return new VScript.rKeyword(this, "current_delay", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lift.BufferCurrentDelay),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lower.BufferCurrentDelay)
            });
        }
    }
    AudioRePlay.Buffer = Buffer;
    class Delay {
        raw;
        type_identifier = "AudioRePlay::Data::Delay";
        constructor(raw) {
            this.raw = raw;
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    buffer_allocation_not_large_enough: (x & 1) !== 0,
                    delay_irq: (x & 2) !== 0,
                    memory_exceed: (x & 4) !== 0,
                    memory_page: (x & 8) !== 0,
                    missing_buffer_allocation: (x & 16) !== 0,
                    missing_sample_setting: (x & 32) !== 0,
                    missing_time_setting: (x & 64) !== 0,
                    missing_timesource: (x & 128) !== 0,
                    number_of_output_exceed: (x & 256) !== 0,
                    number_of_reader_exceed: (x & 512) !== 0,
                    number_of_writer_exceed: (x & 1024) !== 0
                }),
                lower: (x, _) => ((x.buffer_allocation_not_large_enough ? 1 : 0) |
                    (x.delay_irq ? 2 : 0) |
                    (x.memory_exceed ? 4 : 0) |
                    (x.memory_page ? 8 : 0) |
                    (x.missing_buffer_allocation ? 16 : 0) |
                    (x.missing_sample_setting ? 32 : 0) |
                    (x.missing_time_setting ? 64 : 0) |
                    (x.missing_timesource ? 128 : 0) |
                    (x.number_of_output_exceed ? 256 : 0) |
                    (x.number_of_reader_exceed ? 512 : 0) |
                    (x.number_of_writer_exceed ? 1024 : 0))
            });
        }
        get capabilities() {
            return VAPI.AudioRePlay.lift.BufferInput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "capabilities"));
        }
        get num_outputs() {
            return new VScript.rwKeyword(this, "num_outputs", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Restart writer and reader
        */
        get restart() {
            return new VScript.wKeyword(this, "restart", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get dolby_e() {
            return VAPI.AudioRePlay.lift.DolbyE(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "dolby_e"));
        }
        get inputs() {
            return VAPI.AT1101.AudioRePlay.lift.DelayInputs(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "inputs"));
        }
        get outputs() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 6, "outputs"), (raw, _) => VAPI.AT1101.AudioRePlay.lift.DelayOutput(raw));
        }
    }
    AudioRePlay.Delay = Delay;
    class DelayAsNamedTableRow extends Delay {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioRePlay.DelayAsNamedTableRow = DelayAsNamedTableRow;
    class DelayOutput {
        raw;
        type_identifier = "AudioRePlay::Data::DelayOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get delay() {
            return VAPI.AT1101.AudioRePlay.lift.Buffer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "delay"));
        }
        get afv() {
            return VAPI.AudioRePlay.lift.AFVRef(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "afv"));
        }
        get dolby_e() {
            return VAPI.AudioRePlay.lift.DolbyERef(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "dolby_e"));
        }
        get reader() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "reader"), (raw, _) => VAPI.AudioRePlay.lift.Reader(raw));
        }
        get audio() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "audio"));
        }
    }
    AudioRePlay.DelayOutput = DelayOutput;
    class Player {
        raw;
        type_identifier = "AudioRePlay::Data::Player";
        constructor(raw) {
            this.raw = raw;
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    memory_exceed: (x & 1) !== 0,
                    memory_page: (x & 2) !== 0,
                    missing_timesource: (x & 4) !== 0,
                    number_of_reader_exceed: (x & 8) !== 0
                }),
                lower: (x, _) => ((x.memory_exceed ? 1 : 0) |
                    (x.memory_page ? 2 : 0) |
                    (x.missing_timesource ? 4 : 0) |
                    (x.number_of_reader_exceed ? 8 : 0))
            });
        }
        get upload_header() {
            return VAPI.AudioRePlay.lift.UploadHeader(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "upload_header"));
        }
        get capabilities() {
            return VAPI.AudioRePlay.lift.BufferInput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "capabilities"));
        }
        get gang() {
            return VAPI.AT1101.AudioRePlay.lift.Relations(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "gang"));
        }
        /**
          Restart writer and reader
        */
        get restart() {
            return new VScript.wKeyword(this, "restart", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get output() {
            return VAPI.AT1101.AudioRePlay.lift.PlayerOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "output"));
        }
    }
    AudioRePlay.Player = Player;
    class PlayerAsNamedTableRow extends Player {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioRePlay.PlayerAsNamedTableRow = PlayerAsNamedTableRow;
    class PlayerOutput {
        raw;
        type_identifier = "AudioRePlay::Data::PlayerOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get control() {
            return VAPI.AudioRePlay.lift.Control(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "control"));
        }
        get reader() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "reader"), (raw, _) => VAPI.AudioRePlay.lift.Reader(raw));
        }
        get audio() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "audio"));
        }
    }
    AudioRePlay.PlayerOutput = PlayerOutput;
    class RelationAudio {
        raw;
        type_identifier = "AudioRePlay::Data::RelationAudio";
        constructor(raw) {
            this.raw = raw;
        }
        get leader() {
            return new VScript.dKeyword(this, "leader", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.AudioRePlay.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.AudioRePlay.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get followers() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "followers"), (raw, _) => VAPI.AT1101.AudioRePlay.lift.RelationAudioFollowers(raw));
        }
    }
    AudioRePlay.RelationAudio = RelationAudio;
    class RelationVideo {
        raw;
        type_identifier = "AudioRePlay::Data::RelationVideo";
        constructor(raw) {
            this.raw = raw;
        }
        get leader() {
            return new VScript.dKeyword(this, "leader", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.VideoPlayer.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.VideoPlayer.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get followers() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "followers"), (raw, _) => VAPI.AT1101.AudioRePlay.lift.RelationVideoFollowers(raw));
        }
    }
    AudioRePlay.RelationVideo = RelationVideo;
    class Relations {
        raw;
        type_identifier = "AudioRePlay::Data::Relations";
        constructor(raw) {
            this.raw = raw;
        }
        get video() {
            return VAPI.AT1101.AudioRePlay.lift.RelationVideo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "video"));
        }
        get audio() {
            return VAPI.AT1101.AudioRePlay.lift.RelationAudio(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "audio"));
        }
    }
    AudioRePlay.Relations = Relations;
    class Time {
        raw;
        type_identifier = "AudioRePlay::Data::Time";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
    }
    AudioRePlay.Time = Time;
    class RelationAudioFollowers {
        raw;
        type_identifier = "AudioRePlay::Data::RelationAudio::Followers";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          TODO:
        */
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.AudioRePlay.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    AudioRePlay.RelationAudioFollowers = RelationAudioFollowers;
    class RelationVideoFollowers {
        raw;
        type_identifier = "AudioRePlay::Data::RelationVideo::Followers";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          TODO:
        */
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.VideoPlayer.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    AudioRePlay.RelationVideoFollowers = RelationVideoFollowers;
    class DelayInputs {
        raw;
        type_identifier = "AudioRePlay::Data::Delay::Inputs";
        constructor(raw) {
            this.raw = raw;
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get writer() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "writer"), (raw, _) => VAPI.AudioRePlay.lift.Writer(raw));
        }
    }
    AudioRePlay.DelayInputs = DelayInputs;
})(AudioRePlay || (AudioRePlay = {}));
export var AudioShuffler;
(function (AudioShuffler) {
    AudioShuffler.lift = {
        All: (_raw) => (new All(_raw)),
        Shuffler: (_raw) => (new Shuffler(_raw)),
    };
    AudioShuffler.lower = {
        All: (_x) => _x.raw.kwl,
        Shuffler: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "AudioShuffler::Data::All";
        get runtime_constants() {
            return {
                num_shuffler_instances: this.raw.backing_store.get_runtime_constant("AudioShuffler::num_shuffler_instances")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get global_cross_fade() {
            return new VScript.rwKeyword(this, "global_cross_fade", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            }, null);
        }
        get instances() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "instances"), (raw) => new VAPI.AT1101.AudioShuffler.ShufflerAsNamedTableRow(raw));
        }
    }
    AudioShuffler.All = All;
    class Shuffler {
        raw;
        type_identifier = "AudioShuffler::Data::Shuffler";
        constructor(raw) {
            this.raw = raw;
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftMaybeSparseArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get cross_fade() {
            return new VScript.rwKeyword(this, "cross_fade", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            }, null);
        }
        get output() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "output"));
        }
    }
    AudioShuffler.Shuffler = Shuffler;
    class ShufflerAsNamedTableRow extends Shuffler {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioShuffler.ShufflerAsNamedTableRow = ShufflerAsNamedTableRow;
})(AudioShuffler || (AudioShuffler = {}));
export var AudioSignalGenerator;
(function (AudioSignalGenerator) {
    AudioSignalGenerator.lift = {
        All: (_raw) => (new All(_raw)),
        OUT: (_raw) => (new OUT(_raw)),
    };
    AudioSignalGenerator.lower = {
        All: (_x) => _x.raw.kwl,
        OUT: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "AudioSignalGenerator::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get signal_aggregate() {
            return VAPI.AT1101.AudioSignalGenerator.lift.OUT(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "signal_aggregate"));
        }
        get signal_silence() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "signal_silence"));
        }
        get signal_400hz() {
            return VAPI.AT1101.AudioSignalGenerator.lift.OUT(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "signal_400hz"));
        }
        get signal_440hz() {
            return VAPI.AT1101.AudioSignalGenerator.lift.OUT(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "signal_440hz"));
        }
        get signal_1000hz() {
            return VAPI.AT1101.AudioSignalGenerator.lift.OUT(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "signal_1000hz"));
        }
        get source_slice() {
            return VAPI.Audio.lift.SignalSourceSlice(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "source_slice"));
        }
        get output_alsa() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "output_alsa"));
        }
        get source_slice_alsa() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 7, "source_slice_alsa"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
    }
    AudioSignalGenerator.All = All;
    class OUT {
        raw;
        type_identifier = "AudioSignalGenerator::Data::OUT";
        constructor(raw) {
            this.raw = raw;
        }
        get level() {
            return new VScript.dKeyword(this, "level", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get output() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "output"));
        }
    }
    AudioSignalGenerator.OUT = OUT;
})(AudioSignalGenerator || (AudioSignalGenerator = {}));
export var Cluster;
(function (Cluster) {
    Cluster.lift = {
        All: (_raw) => (new All(_raw)),
        ClusterGlobal: (_raw) => (new ClusterGlobal(_raw)),
        ClusterGlobalRuntime: (_raw) => (new ClusterGlobalRuntime(_raw)),
        ClusterLocal: (_raw) => (new ClusterLocal(_raw)),
        ClusterLocalRuntime: (_raw) => (new ClusterLocalRuntime(_raw)),
    };
    Cluster.lower = {
        All: (_x) => _x.raw.kwl,
        ClusterGlobal: (_x) => _x.raw.kwl,
        ClusterGlobalRuntime: (_x) => _x.raw.kwl,
        ClusterLocal: (_x) => _x.raw.kwl,
        ClusterLocalRuntime: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "Cluster::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get global() {
            return VAPI.AT1101.Cluster.lift.ClusterGlobal(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "global"));
        }
        get local() {
            return VAPI.AT1101.Cluster.lift.ClusterLocal(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "local"));
        }
    }
    Cluster.All = All;
    class ClusterGlobal {
        raw;
        type_identifier = "Cluster::Data::ClusterGlobal";
        constructor(raw) {
            this.raw = raw;
        }
        get configuration() {
            return VAPI.Cluster.lift.ClusterGlobalConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "configuration"));
        }
        get runtime() {
            return VAPI.AT1101.Cluster.lift.ClusterGlobalRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "runtime"));
        }
    }
    Cluster.ClusterGlobal = ClusterGlobal;
    class ClusterGlobalRuntime {
        raw;
        type_identifier = "Cluster::Data::ClusterGlobalRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get connected_to_myself() {
            return new VScript.rKeyword(this, "connected_to_myself", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get nodes() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "nodes"), (raw, _) => VAPI.ClusterNodes.lift.ClusterNodeGlobalRuntime(raw));
        }
        get sources() {
            return VAPI.AT1101.ClusterSources.lift.ClusterSourcesGlobalRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "sources"));
        }
        get outputs() {
            return VAPI.ClusterOutputs.lift.ClusterOutputsGlobalRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "outputs"));
        }
        get monitoring_objects() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "monitoring_objects"), (raw, _) => VAPI.AT1101.ClusterMonitoringObjects.lift.ClusterMonitoringObjectGlobalRuntime(raw));
        }
    }
    Cluster.ClusterGlobalRuntime = ClusterGlobalRuntime;
    class ClusterLocal {
        raw;
        type_identifier = "Cluster::Data::ClusterLocal";
        constructor(raw) {
            this.raw = raw;
        }
        get runtime() {
            return VAPI.AT1101.Cluster.lift.ClusterLocalRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "runtime"));
        }
    }
    Cluster.ClusterLocal = ClusterLocal;
    class ClusterLocalRuntime {
        raw;
        type_identifier = "Cluster::Data::ClusterLocalRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get processors() {
            return VAPI.AT1101.ClusterProcessors.lift.ClusterProcessorsLocalRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "processors"));
        }
        get statistics() {
            return VAPI.Cluster.lift.ClusterStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "statistics"));
        }
    }
    Cluster.ClusterLocalRuntime = ClusterLocalRuntime;
})(Cluster || (Cluster = {}));
export var ClusterMonitoringObjects;
(function (ClusterMonitoringObjects) {
    ClusterMonitoringObjects.lift = {
        ClusterAudioMonitoringObjectRuntime: (_raw) => (new ClusterAudioMonitoringObjectRuntime(_raw)),
        ClusterMetadataMonitoringObjectRuntime: (_raw) => (new ClusterMetadataMonitoringObjectRuntime(_raw)),
        ClusterMonitoringObjectGlobalRuntime: (_raw) => (new ClusterMonitoringObjectGlobalRuntime(_raw)),
        ClusterVideoMonitoringObjectRuntime: (_raw) => (new ClusterVideoMonitoringObjectRuntime(_raw)),
    };
    ClusterMonitoringObjects.lower = {
        ClusterAudioMonitoringObjectRuntime: (_x) => _x.raw.kwl,
        ClusterMetadataMonitoringObjectRuntime: (_x) => _x.raw.kwl,
        ClusterMonitoringObjectGlobalRuntime: (_x) => _x.raw.kwl,
        ClusterVideoMonitoringObjectRuntime: (_x) => _x.raw.kwl,
    };
    class ClusterAudioMonitoringObjectRuntime {
        raw;
        type_identifier = "ClusterMonitoringObjects::Data::ClusterAudioMonitoringObjectRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get source() {
            return new VScript.rKeyword(this, "source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.ClusterSources.ClusterAudioSourceRuntime(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get alarms() {
            return new VScript.rKeyword(this, "alarms", {
                lift: VAPI.ClusterMonitoringObjects.lift.ClusterAudioMonitoringObjectRuntimeAlarms,
                lower: VAPI.ClusterMonitoringObjects.lower.ClusterAudioMonitoringObjectRuntimeAlarms
            });
        }
    }
    ClusterMonitoringObjects.ClusterAudioMonitoringObjectRuntime = ClusterAudioMonitoringObjectRuntime;
    class ClusterMetadataMonitoringObjectRuntime {
        raw;
        type_identifier = "ClusterMonitoringObjects::Data::ClusterMetadataMonitoringObjectRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get source() {
            return new VScript.rKeyword(this, "source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.ClusterSources.ClusterMetadataSourceRuntime(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get alarms() {
            return new VScript.rKeyword(this, "alarms", {
                lift: VAPI.ClusterMonitoringObjects.lift.ClusterMetadataMonitoringObjectRuntimeAlarms,
                lower: VAPI.ClusterMonitoringObjects.lower.ClusterMetadataMonitoringObjectRuntimeAlarms
            });
        }
    }
    ClusterMonitoringObjects.ClusterMetadataMonitoringObjectRuntime = ClusterMetadataMonitoringObjectRuntime;
    class ClusterMonitoringObjectGlobalRuntime {
        raw;
        type_identifier = "ClusterMonitoringObjects::Data::ClusterMonitoringObjectGlobalRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get alarm() {
            return new VScript.rKeyword(this, "alarm", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get alarm_severity_level() {
            return new VScript.rKeyword(this, "alarm_severity_level", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get video() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 2, "video"), (st, _) => VAPI.AT1101.ClusterMonitoringObjects.lift.ClusterVideoMonitoringObjectRuntime(st));
        }
        get audio() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 3, "audio"), (st, _) => VAPI.AT1101.ClusterMonitoringObjects.lift.ClusterAudioMonitoringObjectRuntime(st));
        }
        get metadata() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 4, "metadata"), (st, _) => VAPI.AT1101.ClusterMonitoringObjects.lift.ClusterMetadataMonitoringObjectRuntime(st));
        }
        get user_labels() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 5, "user_labels"), (st, _) => VAPI.ClusterSources.lift.ClusterSourceLabelDual(st));
        }
        get configuration() {
            return new VScript.rKeyword(this, "configuration", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    ClusterMonitoringObjects.ClusterMonitoringObjectGlobalRuntime = ClusterMonitoringObjectGlobalRuntime;
    class ClusterVideoMonitoringObjectRuntime {
        raw;
        type_identifier = "ClusterMonitoringObjects::Data::ClusterVideoMonitoringObjectRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get source() {
            return new VScript.rKeyword(this, "source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.ClusterSources.ClusterVideoSourceRuntime(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get alarms() {
            return new VScript.rKeyword(this, "alarms", {
                lift: VAPI.ClusterMonitoringObjects.lift.ClusterVideoMonitoringObjectRuntimeAlarms,
                lower: VAPI.ClusterMonitoringObjects.lower.ClusterVideoMonitoringObjectRuntimeAlarms
            });
        }
        get tally_mask() {
            return new VScript.rwKeyword(this, "tally_mask", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get label() {
            return VAPI.ClusterSources.lift.ClusterSourceLabelDual(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "label"));
        }
    }
    ClusterMonitoringObjects.ClusterVideoMonitoringObjectRuntime = ClusterVideoMonitoringObjectRuntime;
})(ClusterMonitoringObjects || (ClusterMonitoringObjects = {}));
export var ClusterProcessors;
(function (ClusterProcessors) {
    ClusterProcessors.lift = {
        ClusterProcessorMipMapsDualOutputRuntime: (_raw) => (new ClusterProcessorMipMapsDualOutputRuntime(_raw)),
        ClusterProcessorMipMapsDualOutputRuntimeSource: (_raw) => (new ClusterProcessorMipMapsDualOutputRuntimeSource(_raw)),
        ClusterProcessorsLocalRuntime: (_raw) => (new ClusterProcessorsLocalRuntime(_raw)),
        ClusterProcessorsMetadataRuntime: (_raw) => (new ClusterProcessorsMetadataRuntime(_raw)),
        ClusterProcessorsMipMapsRuntime: (_raw) => (new ClusterProcessorsMipMapsRuntime(_raw)),
    };
    ClusterProcessors.lower = {
        ClusterProcessorMipMapsDualOutputRuntime: (_x) => _x.raw.kwl,
        ClusterProcessorMipMapsDualOutputRuntimeSource: (_x) => _x.raw.kwl,
        ClusterProcessorsLocalRuntime: (_x) => _x.raw.kwl,
        ClusterProcessorsMetadataRuntime: (_x) => _x.raw.kwl,
        ClusterProcessorsMipMapsRuntime: (_x) => _x.raw.kwl,
    };
    class ClusterProcessorMipMapsDualOutputRuntime {
        raw;
        type_identifier = "ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get local_sources() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 0, "local_sources"), (st, _) => VAPI.AT1101.ClusterProcessors.lift.ClusterProcessorMipMapsDualOutputRuntimeSource(st));
        }
    }
    ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntime = ClusterProcessorMipMapsDualOutputRuntime;
    class ClusterProcessorMipMapsDualOutputRuntimeSource {
        raw;
        type_identifier = "ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntimeSource";
        constructor(raw) {
            this.raw = raw;
        }
        get full_size() {
            return new VScript.rKeyword(this, "full_size", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get source() {
            return new VScript.rKeyword(this, "source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.ClusterSources.ClusterVideoSourceRuntime(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get source_sdp() {
            return new VScript.rKeyword(this, "source_sdp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get input_primary_port() {
            return new VScript.rKeyword(this, "input_primary_port", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get input_secondary_port() {
            return new VScript.rKeyword(this, "input_secondary_port", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get output_primary_port() {
            return new VScript.rKeyword(this, "output_primary_port", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get output_secondary_port() {
            return new VScript.rKeyword(this, "output_secondary_port", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          IP address of the mipmap RTP stream
        */
        get output_src_ip_address() {
            return new VScript.rKeyword(this, "output_src_ip_address", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          IP address of the secondary mipmap RTP stream
        */
        get output_secondary_src_ip_address() {
            return new VScript.rKeyword(this, "output_secondary_src_ip_address", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get crossbar_select() {
            return new VScript.rKeyword(this, "crossbar_select", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource = ClusterProcessorMipMapsDualOutputRuntimeSource;
    class ClusterProcessorsLocalRuntime {
        raw;
        type_identifier = "ClusterProcessors::Data::ClusterProcessorsLocalRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get mipmaps() {
            return VAPI.AT1101.ClusterProcessors.lift.ClusterProcessorsMipMapsRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "mipmaps"));
        }
        get metadata() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "metadata"), (raw, _) => VAPI.AT1101.ClusterProcessors.lift.ClusterProcessorsMetadataRuntime(raw));
        }
        get ppms() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "ppms"), (raw, _) => VAPI.ClusterProcessors.lift.ClusterProcessorsPPMSRuntime(raw));
        }
    }
    ClusterProcessors.ClusterProcessorsLocalRuntime = ClusterProcessorsLocalRuntime;
    class ClusterProcessorsMetadataRuntime {
        raw;
        type_identifier = "ClusterProcessors::Data::ClusterProcessorsMetadataRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get source() {
            return new VScript.rKeyword(this, "source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.ClusterSources.ClusterMetadataSourceRuntime(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    ClusterProcessors.ClusterProcessorsMetadataRuntime = ClusterProcessorsMetadataRuntime;
    class ClusterProcessorsMipMapsRuntime {
        raw;
        type_identifier = "ClusterProcessors::Data::ClusterProcessorsMipMapsRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get outputs() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "outputs"), (raw, _) => VAPI.AT1101.ClusterProcessors.lift.ClusterProcessorMipMapsDualOutputRuntime(raw));
        }
        get inputs() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "inputs"), (raw, _) => VAPI.ClusterProcessors.lift.ClusterProcessorMipMapsInputRuntime(raw));
        }
    }
    ClusterProcessors.ClusterProcessorsMipMapsRuntime = ClusterProcessorsMipMapsRuntime;
})(ClusterProcessors || (ClusterProcessors = {}));
export var ClusterSources;
(function (ClusterSources) {
    ClusterSources.lift = {
        ClusterAudioSourceRuntime: (_raw) => (new ClusterAudioSourceRuntime(_raw)),
        ClusterAudioSourceRuntimeLocal: (_raw) => (new ClusterAudioSourceRuntimeLocal(_raw)),
        ClusterMetadataSourceLocalRuntime: (_raw) => (new ClusterMetadataSourceLocalRuntime(_raw)),
        ClusterMetadataSourceRuntime: (_raw) => (new ClusterMetadataSourceRuntime(_raw)),
        ClusterSourcesGlobalRuntime: (_raw) => (new ClusterSourcesGlobalRuntime(_raw)),
        ClusterVideoSourceRuntime: (_raw) => (new ClusterVideoSourceRuntime(_raw)),
        ClusterVideoSourceRuntimeLocal: (_raw) => (new ClusterVideoSourceRuntimeLocal(_raw)),
    };
    ClusterSources.lower = {
        ClusterAudioSourceRuntime: (_x) => _x.raw.kwl,
        ClusterAudioSourceRuntimeLocal: (_x) => _x.raw.kwl,
        ClusterMetadataSourceLocalRuntime: (_x) => _x.raw.kwl,
        ClusterMetadataSourceRuntime: (_x) => _x.raw.kwl,
        ClusterSourcesGlobalRuntime: (_x) => _x.raw.kwl,
        ClusterVideoSourceRuntime: (_x) => _x.raw.kwl,
        ClusterVideoSourceRuntimeLocal: (_x) => _x.raw.kwl,
    };
    class ClusterAudioSourceRuntime {
        raw;
        type_identifier = "ClusterSources::Data::ClusterAudioSourceRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get transport_format() {
            return new VScript.rKeyword(this, "transport_format", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get num_channels() {
            return new VScript.rKeyword(this, "num_channels", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get peak_meters() {
            return new VScript.rKeyword(this, "peak_meters", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
            });
        }
        get ip_configuration() {
            return new VScript.rKeyword(this, "ip_configuration", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.ClusterSources.ClusterIPSourceConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get local() {
            return VAPI.AT1101.ClusterSources.lift.ClusterAudioSourceRuntimeLocal(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "local"));
        }
        get tally_mask() {
            return new VScript.rwKeyword(this, "tally_mask", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get label() {
            return VAPI.ClusterSources.lift.ClusterSourceLabelDual(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "label"));
        }
        get lifeness_count() {
            return new VScript.rKeyword(this, "lifeness_count", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get bytes_per_second() {
            return new VScript.rKeyword(this, "bytes_per_second", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    ClusterSources.ClusterAudioSourceRuntime = ClusterAudioSourceRuntime;
    class ClusterAudioSourceRuntimeLocal {
        raw;
        type_identifier = "ClusterSources::Data::ClusterAudioSourceRuntimeLocal";
        constructor(raw) {
            this.raw = raw;
        }
        get audio_essence() {
            return new VScript.rKeyword(this, "audio_essence", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get bad_sdp() {
            return new VScript.rKeyword(this, "bad_sdp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get used_channel_id_start() {
            return new VScript.rKeyword(this, "used_channel_id_start", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get used_channels_num() {
            return new VScript.rKeyword(this, "used_channels_num", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    ClusterSources.ClusterAudioSourceRuntimeLocal = ClusterAudioSourceRuntimeLocal;
    class ClusterMetadataSourceLocalRuntime {
        raw;
        type_identifier = "ClusterSources::Data::ClusterMetadataSourceLocalRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get bad_sdp() {
            return new VScript.rKeyword(this, "bad_sdp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get time_source() {
            return new VScript.rKeyword(this, "time_source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get closed_caption() {
            return new VScript.rKeyword(this, "closed_caption", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.Video.ClosedCaption(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    ClusterSources.ClusterMetadataSourceLocalRuntime = ClusterMetadataSourceLocalRuntime;
    class ClusterMetadataSourceRuntime {
        raw;
        type_identifier = "ClusterSources::Data::ClusterMetadataSourceRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get global_source_id() {
            return new VScript.rKeyword(this, "global_source_id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get transport_format() {
            return new VScript.rKeyword(this, "transport_format", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Source IP address of the metadata RTP stream
        */
        get src_ip_address() {
            return new VScript.rKeyword(this, "src_ip_address", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Source IP address of the metadata RTP stream
        */
        get secondary_src_ip_address() {
            return new VScript.rKeyword(this, "secondary_src_ip_address", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Destination IP address of the metadata RTP stream
        */
        get dest_ip_address() {
            return new VScript.rKeyword(this, "dest_ip_address", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Destination IP address of the metadata RTP stream
        */
        get secondary_dest_ip_address() {
            return new VScript.rKeyword(this, "secondary_dest_ip_address", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get ip_configuration() {
            return new VScript.rKeyword(this, "ip_configuration", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.ClusterSources.ClusterIPSourceConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get local() {
            return VAPI.AT1101.ClusterSources.lift.ClusterMetadataSourceLocalRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "local"));
        }
        get lifeness_count() {
            return new VScript.rKeyword(this, "lifeness_count", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get time_code() {
            return new VScript.rKeyword(this, "time_code", {
                lift: VAPI.ClusterSources.lift.TimestampedTimecode,
                lower: VAPI.ClusterSources.lower.TimestampedTimecode
            });
        }
        get closed_caption() {
            return VAPI.ClusterSources.lift.ClusterMetadataSourceCC(VScript.VAPIHelpers.subtree_child_checked(this.raw, 11, "closed_caption"));
        }
    }
    ClusterSources.ClusterMetadataSourceRuntime = ClusterMetadataSourceRuntime;
    class ClusterSourcesGlobalRuntime {
        raw;
        type_identifier = "ClusterSources::Data::ClusterSourcesGlobalRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get video() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "video"), (raw, _) => VAPI.AT1101.ClusterSources.lift.ClusterVideoSourceRuntime(raw));
        }
        get audio() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "audio"), (raw, _) => VAPI.AT1101.ClusterSources.lift.ClusterAudioSourceRuntime(raw));
        }
        get metadata() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "metadata"), (raw, _) => VAPI.AT1101.ClusterSources.lift.ClusterMetadataSourceRuntime(raw));
        }
    }
    ClusterSources.ClusterSourcesGlobalRuntime = ClusterSourcesGlobalRuntime;
    class ClusterVideoSourceRuntime {
        raw;
        type_identifier = "ClusterSources::Data::ClusterVideoSourceRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get global_source_id() {
            return new VScript.rKeyword(this, "global_source_id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get transport_format() {
            return new VScript.rKeyword(this, "transport_format", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get video_standard() {
            return new VScript.rKeyword(this, "video_standard", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get ip_configuration() {
            return new VScript.rKeyword(this, "ip_configuration", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.ClusterSources.ClusterIPSourceConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        /**
          Source IP address of the mipmap RTP stream
        */
        get resolution_levels_src_ip_address() {
            return new VScript.rKeyword(this, "resolution_levels_src_ip_address", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Source IP address of the mipmap RTP stream
        */
        get secondary_resolution_levels_src_ip_address() {
            return new VScript.rKeyword(this, "secondary_resolution_levels_src_ip_address", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get resolution_levels() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 7, "resolution_levels"), (st, _) => VAPI.ClusterSources.lift.ClusterVideoSourceRuntimeResolutionLevel(st));
        }
        get local() {
            return VAPI.AT1101.ClusterSources.lift.ClusterVideoSourceRuntimeLocal(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "local"));
        }
        get tally_mask() {
            return new VScript.rwKeyword(this, "tally_mask", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get label() {
            return VAPI.ClusterSources.lift.ClusterSourceLabelDual(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "label"));
        }
        get lifeness_count() {
            return new VScript.rKeyword(this, "lifeness_count", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    ClusterSources.ClusterVideoSourceRuntime = ClusterVideoSourceRuntime;
    class ClusterVideoSourceRuntimeLocal {
        raw;
        type_identifier = "ClusterSources::Data::ClusterVideoSourceRuntimeLocal";
        constructor(raw) {
            this.raw = raw;
        }
        get video_essence() {
            return new VScript.rKeyword(this, "video_essence", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get bad_sdp() {
            return new VScript.rKeyword(this, "bad_sdp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    ClusterSources.ClusterVideoSourceRuntimeLocal = ClusterVideoSourceRuntimeLocal;
})(ClusterSources || (ClusterSources = {}));
export var ColorCorrection;
(function (ColorCorrection) {
    ColorCorrection.lift = {
        All: (_raw) => (new All(_raw)),
        CC1D: (_raw) => (new CC1D(_raw)),
        CC3D: (_raw) => (new CC3D(_raw)),
    };
    ColorCorrection.lower = {
        All: (_x) => _x.raw.kwl,
        CC1D: (_x) => _x.raw.kwl,
        CC3D: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "ColorCorrection::Data::All";
        get runtime_constants() {
            return {
                num_color_correction: this.raw.backing_store.get_runtime_constant("ColorCorrection::num_color_correction"),
                num_3d_color_correction: this.raw.backing_store.get_runtime_constant("ColorCorrection::num_3d_color_correction")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get cc1d() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "cc1d"), (raw) => new VAPI.AT1101.ColorCorrection.CC1DAsNamedTableRow(raw));
        }
        get cc3d() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "cc3d"), (raw) => new VAPI.AT1101.ColorCorrection.CC3DAsNamedTableRow(raw));
        }
    }
    ColorCorrection.All = All;
    class CC1D {
        raw;
        type_identifier = "ColorCorrection::Data::CC1D";
        constructor(raw) {
            this.raw = raw;
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1101.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "output"));
        }
        get reserve_uhd_resources() {
            return new VScript.dKeyword(this, "reserve_uhd_resources", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Selects which parameter sets are used to control this color correction
        */
        get color_schema() {
            return new VScript.rwKeyword(this, "color_schema", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          When set changes the output color space to the specified one
        */
        get output_cs() {
            return new VScript.rwKeyword(this, "output_cs", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        get yuv() {
            return VAPI.ColorCorrection.lift.YUV(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "yuv"));
        }
        get rgb() {
            return VAPI.ColorCorrection.lift.CC1DRgb(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "rgb"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    missing_input_mapper: (x & 1) !== 0,
                    no_hw_resources_available: (x & 2) !== 0,
                    no_uhd_resources_allocated: (x & 4) !== 0
                }),
                lower: (x, _) => ((x.missing_input_mapper ? 1 : 0) |
                    (x.no_hw_resources_available ? 2 : 0) |
                    (x.no_uhd_resources_allocated ? 4 : 0))
            });
        }
    }
    ColorCorrection.CC1D = CC1D;
    class CC1DAsNamedTableRow extends CC1D {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    ColorCorrection.CC1DAsNamedTableRow = CC1DAsNamedTableRow;
    class CC3D {
        raw;
        type_identifier = "ColorCorrection::Data::CC3D";
        constructor(raw) {
            this.raw = raw;
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1101.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "output"));
        }
        get reserve_uhd_resources() {
            return new VScript.dKeyword(this, "reserve_uhd_resources", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Selects which parameter sets are used to control this color correction
        */
        get color_schema() {
            return new VScript.rwKeyword(this, "color_schema", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get yuv() {
            return VAPI.ColorCorrection.lift.YUV(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "yuv"));
        }
        get lut_name() {
            return new VScript.dKeyword(this, "lut_name", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get lut_info() {
            return VAPI.ColorCorrection.lift.CC3DLutInfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "lut_info"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    missing_input_mapper: (x & 1) !== 0,
                    no_hw_resources_available: (x & 2) !== 0,
                    no_uhd_resources_allocated: (x & 4) !== 0
                }),
                lower: (x, _) => ((x.missing_input_mapper ? 1 : 0) |
                    (x.no_hw_resources_available ? 2 : 0) |
                    (x.no_uhd_resources_allocated ? 4 : 0))
            });
        }
    }
    ColorCorrection.CC3D = CC3D;
    class CC3DAsNamedTableRow extends CC3D {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    ColorCorrection.CC3DAsNamedTableRow = CC3DAsNamedTableRow;
})(ColorCorrection || (ColorCorrection = {}));
export var Definitions;
(function (Definitions) {
    Definitions.lift = {
        AudioControl: (_raw) => (new AudioControl(_raw)),
        TimecodeInserterGenerator: (_raw, _socket) => {
            return {
                enable: VAPI.Definitions.lift.TimecodeInserterGeneratorEnable(_raw[0], _socket),
                t_src: _raw[1] === null ? null : new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, _raw[1]))
            };
        },
        TimecodeInserter: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "Passthrough", value: VAPI.Definitions.lift.TimecodeInserterPassthrough(_raw[1], _socket) };
                case 1: return { variant: "Blank", value: VAPI.Definitions.lift.TimecodeInserterBlank(_raw[1], _socket) };
                case 2: return { variant: "Freerun", value: VAPI.Definitions.lift.TimecodeInserterFreerun(_raw[1], _socket) };
                case 3: return { variant: "Generator", value: VAPI.AT1101.Definitions.lift.TimecodeInserterGenerator(_raw[1], _socket) };
            }
            ;
        },
        VancControl: (_raw) => (new VancControl(_raw)),
    };
    Definitions.lower = {
        AudioControl: (_x) => _x.raw.kwl,
        TimecodeInserterGenerator: (_x, _socket) => [
            VAPI.Definitions.lower.TimecodeInserterGeneratorEnable(_x.enable, _socket),
            _x.t_src === null ? null : _x.t_src.raw.kwl
        ],
        TimecodeInserter: (_x, _socket) => {
            switch (_x.variant) {
                case "Passthrough": return [0, VAPI.Definitions.lower.TimecodeInserterPassthrough(_x.value, _socket)];
                case "Blank": return [1, VAPI.Definitions.lower.TimecodeInserterBlank(_x.value, _socket)];
                case "Freerun": return [2, VAPI.Definitions.lower.TimecodeInserterFreerun(_x.value, _socket)];
                case "Generator": return [3, VAPI.AT1101.Definitions.lower.TimecodeInserterGenerator(_x.value, _socket)];
            }
        },
        VancControl: (_x) => _x.raw.kwl,
    };
    class AudioControl {
        raw;
        type_identifier = "Definitions::Data::AudioControl";
        constructor(raw) {
            this.raw = raw;
        }
        get group_enable() {
            return new VScript.dKeyword(this, "group_enable", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftMaybeSparseArray((x /* FIXME */, _) => x),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get source() {
            return new VScript.dKeyword(this, "source", {
                lift: VAPI.AT1101.Audio.lift.TimedSource,
                lower: VAPI.AT1101.Audio.lower.TimedSource
            }, {
                lift: VAPI.AT1101.Audio.lift.TimedSource,
                lower: VAPI.AT1101.Audio.lower.TimedSource
            }, null);
        }
    }
    Definitions.AudioControl = AudioControl;
    class VancControl {
        raw;
        type_identifier = "Definitions::Data::VancControl";
        constructor(raw) {
            this.raw = raw;
        }
        get passthrough_c_y_0() {
            return new VScript.dKeyword(this, "passthrough_c_y_0", {
                lift: VAPI.Definitions.lift.BypassReplaceFlags,
                lower: VAPI.Definitions.lower.BypassReplaceFlags
            }, {
                lift: VAPI.Definitions.lift.BypassReplaceFlags,
                lower: VAPI.Definitions.lower.BypassReplaceFlags
            }, null);
        }
        get timecode_inserter() {
            return new VScript.dKeyword(this, "timecode_inserter", {
                lift: VAPI.AT1101.Definitions.lift.TimecodeInserter,
                lower: VAPI.AT1101.Definitions.lower.TimecodeInserter
            }, {
                lift: VAPI.AT1101.Definitions.lift.TimecodeInserter,
                lower: VAPI.AT1101.Definitions.lower.TimecodeInserter
            }, null);
        }
        get afd_inserter() {
            return new VScript.rwKeyword(this, "afd_inserter", {
                lift: VAPI.Definitions.lift.VANCAfdInserter,
                lower: VAPI.Definitions.lower.VANCAfdInserter
            }, {
                lift: VAPI.Definitions.lift.VANCAfdInserter,
                lower: VAPI.Definitions.lower.VANCAfdInserter
            }, null);
        }
        get override_smpte_352_payload() {
            return new VScript.rwKeyword(this, "override_smpte_352_payload", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
    }
    Definitions.VancControl = VancControl;
})(Definitions || (Definitions = {}));
export var EthernetStats;
(function (EthernetStats) {
    EthernetStats.lift = {
        PortStatistics: (_raw) => (new PortStatistics(_raw)),
    };
    EthernetStats.lower = {
        PortStatistics: (_x) => _x.raw.kwl,
    };
    class PortStatistics {
        raw;
        type_identifier = "EthernetStats::Data::PortStatistics";
        constructor(raw) {
            this.raw = raw;
        }
        get tx_cpu() {
            return new VScript.rKeyword(this, "tx_cpu", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            });
        }
        get rx_unicast() {
            return new VScript.rKeyword(this, "rx_unicast", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            });
        }
        get rx_broadcast() {
            return new VScript.rKeyword(this, "rx_broadcast", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            });
        }
        get rx_multicast() {
            return new VScript.rKeyword(this, "rx_multicast", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            });
        }
        get rx_crc_error() {
            return new VScript.rKeyword(this, "rx_crc_error", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            });
        }
        get rx_wrong_vlan() {
            return new VScript.rKeyword(this, "rx_wrong_vlan", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            });
        }
        get rx_error() {
            return new VScript.rKeyword(this, "rx_error", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            });
        }
        get rx_too_long() {
            return new VScript.rKeyword(this, "rx_too_long", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            });
        }
        get rx_too_short() {
            return new VScript.rKeyword(this, "rx_too_short", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            });
        }
    }
    EthernetStats.PortStatistics = PortStatistics;
})(EthernetStats || (EthernetStats = {}));
export var Genlock;
(function (Genlock) {
    Genlock.lift = {
        All: (_raw) => (new All(_raw)),
    };
    Genlock.lower = { All: (_x) => _x.raw.kwl, };
    class All {
        raw;
        type_identifier = "Genlock::Data::All";
        get runtime_constants() {
            return {
                num_physical_audio_genlocks: this.raw.backing_store.get_runtime_constant("Genlock::num_physical_audio_genlocks"),
                num_physical_video_genlocks: this.raw.backing_store.get_runtime_constant("Genlock::num_physical_video_genlocks"),
                num_video_genlocks: this.raw.backing_store.get_runtime_constant("Genlock::num_video_genlocks"),
                num_audio_genlocks: this.raw.backing_store.get_runtime_constant("Genlock::num_audio_genlocks"),
                num_genlocks: this.raw.backing_store.get_runtime_constant("Genlock::num_genlocks")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get state() {
            return new VScript.rKeyword(this, "state", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          TODO: use this in IOModule (requires AnalogRefTracker/GrainTracker
          cleanup)
        */
        get analog_ref_mgmt() {
            return VAPI.AT1101.Time.lift.AnalogReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "analog_ref_mgmt"));
        }
        get output() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "ptp_traits"));
        }
    }
    Genlock.All = All;
})(Genlock || (Genlock = {}));
export var IOModule;
(function (IOModule) {
    IOModule.lift = {
        All: (_raw) => (new All(_raw)),
        TimingAsynchronous: (_raw, _socket) => {
            return {};
        },
        HwStatus: (_raw) => (new HwStatus(_raw)),
        MADIInput: (_raw) => (new MADIInput(_raw)),
        SDIPayload: (_raw) => (new SDIPayload(_raw)),
        SDIInput: (_raw) => (new SDIInput(_raw)),
        SDIOutput: (_raw) => (new SDIOutput(_raw)),
        TimingSynchronousOrSyntonous: (_raw, _socket) => {
            return {};
        },
        Timing: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "SynchronousOrSyntonous", value: VAPI.AT1101.IOModule.lift.TimingSynchronousOrSyntonous(_raw[1], _socket) };
                case 1: return { variant: "Asynchronous", value: VAPI.AT1101.IOModule.lift.TimingAsynchronous(_raw[1], _socket) };
            }
            ;
        },
        HwStatusEye: (_raw) => (new HwStatusEye(_raw)),
        Input: (_raw) => (new Input(_raw)),
        Merger: (_raw) => (new Merger(_raw)),
        Output: (_raw) => (new Output(_raw)),
        MergerOutput: (_raw) => (new MergerOutput(_raw)),
        SyncOutput: (_raw) => (new SyncOutput(_raw)),
    };
    IOModule.lower = {
        All: (_x) => _x.raw.kwl,
        TimingAsynchronous: (_x, _socket) => [],
        HwStatus: (_x) => _x.raw.kwl,
        MADIInput: (_x) => _x.raw.kwl,
        SDIPayload: (_x) => _x.raw.kwl,
        SDIInput: (_x) => _x.raw.kwl,
        SDIOutput: (_x) => _x.raw.kwl,
        TimingSynchronousOrSyntonous: (_x, _socket) => [],
        Timing: (_x, _socket) => {
            switch (_x.variant) {
                case "SynchronousOrSyntonous": return [0, VAPI.AT1101.IOModule.lower.TimingSynchronousOrSyntonous(_x.value, _socket)];
                case "Asynchronous": return [1, VAPI.AT1101.IOModule.lower.TimingAsynchronous(_x.value, _socket)];
            }
        },
        HwStatusEye: (_x) => _x.raw.kwl,
        Input: (_x) => _x.raw.kwl,
        Merger: (_x) => _x.raw.kwl,
        Output: (_x) => _x.raw.kwl,
        MergerOutput: (_x) => _x.raw.kwl,
        SyncOutput: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "IOModule::Data::All";
        get runtime_constants() {
            return {
                should_deembed_all_metadata: this.raw.backing_store.get_runtime_constant("IOModule::should_deembed_all_metadata"),
                num_sdi_tx_plls: this.raw.backing_store.get_runtime_constant("IOModule::num_sdi_tx_plls"),
                num_metadata_extractors_per_sdi_input: this.raw.backing_store.get_runtime_constant("IOModule::num_metadata_extractors_per_sdi_input")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get info() {
            return VAPI.IOModule.lift.BncMode(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "info"));
        }
        get analog_ref() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "analog_ref"), (raw, _) => VAPI.AT1101.Time.lift.Source(raw));
        }
        get analog_ref_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "analog_ref_traits"));
        }
        get configuration() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 3, "configuration"), (raw, _) => VAPI.IOModule.lift.Configuration(raw));
        }
        get merger() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "merger"), (raw, _) => VAPI.AT1101.IOModule.lift.Merger(raw));
        }
        get output() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 5, "output"), (raw, _) => VAPI.AT1101.IOModule.lift.Output(raw));
        }
        get input() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 6, "input"), (raw, _) => VAPI.AT1101.IOModule.lift.Input(raw));
        }
        get sync_output() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 7, "sync_output"), (raw, _) => VAPI.AT1101.IOModule.lift.SyncOutput(raw));
        }
    }
    IOModule.All = All;
    class HwStatus {
        raw;
        type_identifier = "IOModule::Data::HwStatus";
        constructor(raw) {
            this.raw = raw;
        }
        get timestamped_signature() {
            return new VScript.rKeyword(this, "timestamped_signature", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lift.TimestampedSignature),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lower.TimestampedSignature)
            });
        }
        get irq_index() {
            return new VScript.rKeyword(this, "irq_index", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get deemb_read_overflow() {
            return new VScript.rKeyword(this, "deemb_read_overflow", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get deemb_read_underflow() {
            return new VScript.rKeyword(this, "deemb_read_underflow", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get deemb_read_running() {
            return new VScript.rKeyword(this, "deemb_read_running", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get phy_rx_locked_status() {
            return new VScript.rKeyword(this, "phy_rx_locked_status", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get phy_rx_ready() {
            return new VScript.rKeyword(this, "phy_rx_ready", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get phy_rx_calibrate_busy() {
            return new VScript.rKeyword(this, "phy_rx_calibrate_busy", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get phy_rx_locked_status_changed() {
            return new VScript.rKeyword(this, "phy_rx_locked_status_changed", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get phy_rx_ready_changed() {
            return new VScript.rKeyword(this, "phy_rx_ready_changed", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get smpte_352_c() {
            return new VScript.rKeyword(this, "smpte_352_c", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get smpte_352_y() {
            return new VScript.rKeyword(this, "smpte_352_y", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get h_blank() {
            return new VScript.rKeyword(this, "h_blank", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get h_blank_changed() {
            return new VScript.rKeyword(this, "h_blank_changed", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get h_active() {
            return new VScript.rKeyword(this, "h_active", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get h_active_changed() {
            return new VScript.rKeyword(this, "h_active_changed", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get f_period() {
            return new VScript.rKeyword(this, "f_period", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            });
        }
        get interlace() {
            return new VScript.rKeyword(this, "interlace", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get standard() {
            return new VScript.rKeyword(this, "standard", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get substream_2_s_i() {
            return new VScript.rKeyword(this, "substream_2_s_i", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get input_substream() {
            return new VScript.rKeyword(this, "input_substream", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get eye() {
            return VAPI.AT1101.IOModule.lift.HwStatusEye(VScript.VAPIHelpers.subtree_child_checked(this.raw, 21, "eye"));
        }
    }
    IOModule.HwStatus = HwStatus;
    class MADIInput {
        raw;
        type_identifier = "IOModule::Data::MADIInput";
        constructor(raw) {
            this.raw = raw;
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get fifo_underflow_counter() {
            return new VScript.rKeyword(this, "fifo_underflow_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get fifo_overflow_counter() {
            return new VScript.rKeyword(this, "fifo_overflow_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get clear_fifo_error_counters() {
            return new VScript.wKeyword(this, "clear_fifo_error_counters", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get output() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "output"));
        }
    }
    IOModule.MADIInput = MADIInput;
    class SDIPayload {
        raw;
        type_identifier = "IOModule::Data::SDIPayload";
        constructor(raw) {
            this.raw = raw;
        }
        get video() {
            return VAPI.AT1101.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "video"));
        }
        get audio() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "audio"));
        }
        get afd() {
            return new VScript.rKeyword(this, "afd", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lift.AFD),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lower.AFD)
            });
        }
        get cc() {
            return VAPI.Video.lift.ClosedCaption(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "cc"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "ptp_traits"));
        }
    }
    IOModule.SDIPayload = SDIPayload;
    class SDIInput {
        raw;
        type_identifier = "IOModule::Data::SDIInput";
        constructor(raw) {
            this.raw = raw;
        }
        get override_pixel_format() {
            return new VScript.rwKeyword(this, "override_pixel_format", {
                lift: VAPI.Video.lift.OverridePixelFormat,
                lower: VAPI.Video.lower.OverridePixelFormat
            }, {
                lift: VAPI.Video.lift.OverridePixelFormat,
                lower: VAPI.Video.lower.OverridePixelFormat
            }, null);
        }
        get sub_stream() {
            return new VScript.dKeyword(this, "sub_stream", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        /**
          How to deembed audio from 12G SDI inputs
        */
        get audio_12g_mode() {
            return new VScript.rwKeyword(this, "audio_12g_mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Which closed caption format to decode on input
        */
        get cc_mode() {
            return new VScript.rwKeyword(this, "cc_mode", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        /**
          Which line 21 field to decode in CEA708 mode
        */
        get cc_field() {
            return new VScript.rwKeyword(this, "cc_field", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get cc_channel() {
            return new VScript.rwKeyword(this, "cc_channel", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        get hw_status() {
            return VAPI.AT1101.IOModule.lift.HwStatus(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "hw_status"));
        }
        get output() {
            return VAPI.AT1101.IOModule.lift.SDIPayload(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "output"));
        }
        get mode() {
            return new VScript.rKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get supports_12g() {
            return new VScript.rKeyword(this, "supports_12g", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          All audio groups which are part of the gang mode are started / stopped
          together. This ensures consistent audio phase for all these groups. All
          enabled groups must be present before de-embedding starts, and when one
          group encounters errors all are reset.
        */
        get deembedder_gang() {
            return new VScript.rwKeyword(this, "deembedder_gang", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftMaybeSparseArray((x /* FIXME */, _) => x),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        /**
          @brief restart deembedder
          @desc Restart audio deembedder to synchronize the groups
        */
        get restart_deembedder() {
            return new VScript.wKeyword(this, "restart_deembedder", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get metadata_extractor() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 12, "metadata_extractor"), (raw, _) => VAPI.AT1101.MetadataProcessor.lift.MetadataExtractor(raw));
        }
        /**
          This keyword is used for the DMV application only. It is used to set the
          video standard for the DMV.
        */
        get constraints() {
            return VAPI.IOModule.lift.Constraints(VScript.VAPIHelpers.subtree_child_checked(this.raw, 13, "constraints"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    missmatching_constraint_standard: (x & 1) !== 0
                }),
                lower: (x, _) => ((x.missmatching_constraint_standard ? 1 : 0))
            });
        }
    }
    IOModule.SDIInput = SDIInput;
    class SDIOutput {
        raw;
        type_identifier = "IOModule::Data::SDIOutput";
        async set_video_source(x, pars) {
            const options = pars?.timeout !== undefined ? { timeout: pars.timeout } : {};
            if (x === null || x instanceof VAPI.AT1101.Video.Essence) {
                await this.v_src.command.write({
                    source: x, // FIXME: do we really need this cast?
                    switch_time: null,
                }, options);
            }
            else {
                await this.v_src.command.write(x, options);
            }
        }
        constructor(raw) {
            this.raw = raw;
        }
        get constraints() {
            return VAPI.IOModule.lift.Constraints(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "constraints"));
        }
        get sub_stream() {
            return new VScript.rKeyword(this, "sub_stream", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get standard() {
            return new VScript.rKeyword(this, "standard", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get supports_12g() {
            return new VScript.rKeyword(this, "supports_12g", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VAPI.AT1101.Video.lift.TimedSource,
                lower: VAPI.AT1101.Video.lower.TimedSource
            }, {
                lift: VAPI.AT1101.Video.lift.TimedSource,
                lower: VAPI.AT1101.Video.lower.TimedSource
            }, null);
        }
        get phase_target() {
            return new VScript.dKeyword(this, "phase_target", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get in_phase() {
            return new VScript.rKeyword(this, "in_phase", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            });
        }
        get phase_rst_counter() {
            return new VScript.rKeyword(this, "phase_rst_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    input_out_of_linephaser_range: (x & 1) !== 0,
                    no_12g_support: (x & 2) !== 0,
                    std_mismatch: (x & 4) !== 0
                }),
                lower: (x, _) => ((x.input_out_of_linephaser_range ? 1 : 0) |
                    (x.no_12g_support ? 2 : 0) |
                    (x.std_mismatch ? 4 : 0))
            });
        }
        get vanc_control() {
            return VAPI.AT1101.Definitions.lift.VancControl(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "vanc_control"));
        }
        get embedded_audio() {
            return new VScript.dKeyword(this, "embedded_audio", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftMaybeSparseArray((x /* FIXME */, _) => x),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        /**
          Time when the SDI output was last enabled. Changing the standards or
          disconnecting the video source counts as disabling.
        */
        get last_enable_time() {
            return new VScript.rKeyword(this, "last_enable_time", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftTimestamp),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerTimestamp)
            });
        }
    }
    IOModule.SDIOutput = SDIOutput;
    class HwStatusEye {
        raw;
        type_identifier = "IOModule::Data::HwStatus::Eye";
        constructor(raw) {
            this.raw = raw;
        }
        get eye_measure_time() {
            return new VScript.rwKeyword(this, "eye_measure_time", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        /**
          Generate eye diagram
        */
        get generate() {
            return new VScript.wKeyword(this, "generate", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get progress() {
            return new VScript.rKeyword(this, "progress", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          @brief URL of the eye diagram
          @desc An update to this keyword signals a new eye diagram has been
          generated
        */
        get url() {
            return new VScript.rKeyword(this, "url", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          @brief Measure eye opening only
          @desc Only measure horizontal eye opening (much faster than a full eye)
        */
        get measure_ui() {
            return new VScript.wKeyword(this, "measure_ui", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get ui_measure_time() {
            return new VScript.rwKeyword(this, "ui_measure_time", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get ui() {
            return new VScript.rKeyword(this, "ui", {
                lift: VAPI.IOModule.lift.EyeShape,
                lower: VAPI.IOModule.lower.EyeShape
            });
        }
    }
    IOModule.HwStatusEye = HwStatusEye;
    class Input {
        raw;
        type_identifier = "IOModule::Data::Input";
        constructor(raw) {
            this.raw = raw;
        }
        get mode() {
            return new VScript.dKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get audio_timing() {
            return new VScript.dKeyword(this, "audio_timing", {
                lift: VAPI.AT1101.IOModule.lift.Timing,
                lower: VAPI.AT1101.IOModule.lower.Timing
            }, {
                lift: VAPI.AT1101.IOModule.lift.Timing,
                lower: VAPI.AT1101.IOModule.lower.Timing
            }, null);
        }
        get sdi() {
            return VAPI.AT1101.IOModule.lift.SDIInput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "sdi"));
        }
        get madi() {
            return VAPI.AT1101.IOModule.lift.MADIInput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "madi"));
        }
        get audio_source_slices() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 4, "audio_source_slices"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
    }
    IOModule.Input = Input;
    class Merger {
        raw;
        type_identifier = "IOModule::Data::Merger";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          Merger: combines quad-link-2si signals to a single-link UHD signal. The
          corresponding SDI inputs are declared in `connected_to`. The order of the
          substream is adjusted by the information of the payload identifier. To
          set or reorder the substream, use the `sub_stream` parameter
        */
        get substream_2_s_i() {
            return new VScript.rwKeyword(this, "substream_2_s_i", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get connected_to() {
            return VAPI.IOModule.lift.MergerConnectedTo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "connected_to"));
        }
        get output() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "output"), (raw, _) => VAPI.AT1101.IOModule.lift.MergerOutput(raw));
        }
    }
    IOModule.Merger = Merger;
    class Output {
        raw;
        type_identifier = "IOModule::Data::Output";
        constructor(raw) {
            this.raw = raw;
        }
        get mode() {
            return new VScript.dKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Number of times since last enable the output FIFO had to resync (sampled
          only every 100ms)
        */
        get resync_counter() {
            return new VScript.rKeyword(this, "resync_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Output FIFO latency
        */
        get fifo_latency() {
            return new VScript.rKeyword(this, "fifo_latency", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
            });
        }
        get sdi() {
            return VAPI.AT1101.IOModule.lift.SDIOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "sdi"));
        }
        get madi() {
            return VAPI.IOModule.lift.MADIOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "madi"));
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VAPI.AT1101.Audio.lift.TimedSource,
                lower: VAPI.AT1101.Audio.lower.TimedSource
            }, {
                lift: VAPI.AT1101.Audio.lift.TimedSource,
                lower: VAPI.AT1101.Audio.lower.TimedSource
            }, null);
        }
        get peak_meter() {
            return new VScript.rKeyword(this, "peak_meter", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
            });
        }
    }
    IOModule.Output = Output;
    class MergerOutput {
        raw;
        type_identifier = "IOModule::Data::Merger::Output";
        constructor(raw) {
            this.raw = raw;
        }
        get video() {
            return VAPI.AT1101.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "video"));
        }
        get audio() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 1, "audio"), (st, _) => VAPI.AT1101.Audio.lift.Essence(st));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "ptp_traits"));
        }
    }
    IOModule.MergerOutput = MergerOutput;
    class SyncOutput {
        raw;
        type_identifier = "IOModule::Data::SyncOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get standard() {
            return new VScript.rwKeyword(this, "standard", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get phase_rst_counter() {
            return new VScript.rKeyword(this, "phase_rst_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Number of times since last enable the output FIFO had to resync (sampled
          only every 100ms)
        */
        get resync_counter() {
            return new VScript.rKeyword(this, "resync_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Output FIFO latency
        */
        get fifo_latency() {
            return new VScript.rKeyword(this, "fifo_latency", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
            });
        }
    }
    IOModule.SyncOutput = SyncOutput;
})(IOModule || (IOModule = {}));
export var J2KDecoder;
(function (J2KDecoder) {
    J2KDecoder.lift = {
        All: (_raw) => (new All(_raw)),
        J2KDecoderChannel: (_raw) => (new J2KDecoderChannel(_raw)),
        J2KDecoderRuntime: (_raw) => (new J2KDecoderRuntime(_raw)),
        J2KDecoderVideoRuntime: (_raw) => (new J2KDecoderVideoRuntime(_raw)),
    };
    J2KDecoder.lower = {
        All: (_x) => _x.raw.kwl,
        J2KDecoderChannel: (_x) => _x.raw.kwl,
        J2KDecoderRuntime: (_x) => _x.raw.kwl,
        J2KDecoderVideoRuntime: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "J2KDecoder::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get decoders() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "decoders"), (raw) => new VAPI.AT1101.J2KDecoder.J2KDecoderChannelAsNamedTableRow(raw));
        }
        get statistics() {
            return VAPI.J2KDecoder.lift.J2KDecoderStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "statistics"));
        }
    }
    J2KDecoder.All = All;
    class J2KDecoderChannel {
        raw;
        type_identifier = "J2KDecoder::Data::J2KDecoderChannel";
        constructor(raw) {
            this.raw = raw;
        }
        get configuration() {
            return VAPI.J2KDecoder.lift.J2KDecoderConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "configuration"));
        }
        get runtime() {
            return VAPI.AT1101.J2KDecoder.lift.J2KDecoderRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "runtime"));
        }
    }
    J2KDecoder.J2KDecoderChannel = J2KDecoderChannel;
    class J2KDecoderChannelAsNamedTableRow extends J2KDecoderChannel {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    J2KDecoder.J2KDecoderChannelAsNamedTableRow = J2KDecoderChannelAsNamedTableRow;
    class J2KDecoderRuntime {
        raw;
        type_identifier = "J2KDecoder::Data::J2KDecoderRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get rtp() {
            return VAPI.J2KDecoder.lift.J2KDecoderRTPRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "rtp"));
        }
        get mpt2() {
            return VAPI.J2KDecoder.lift.J2KDecoderMPT2Runtime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "mpt2"));
        }
        get j2k() {
            return VAPI.J2KDecoder.lift.J2KDecoderJ2KRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "j2k"));
        }
        get video() {
            return VAPI.AT1101.J2KDecoder.lift.J2KDecoderVideoRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "video"));
        }
        get audio() {
            return VAPI.J2KDecoder.lift.J2KDecoderAudioRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "audio"));
        }
        get metadata() {
            return VAPI.J2KDecoder.lift.J2KDecoderMetadataRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "metadata"));
        }
    }
    J2KDecoder.J2KDecoderRuntime = J2KDecoderRuntime;
    class J2KDecoderVideoRuntime {
        raw;
        type_identifier = "J2KDecoder::Data::J2KDecoderVideoRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get video_standard() {
            return new VScript.rKeyword(this, "video_standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get signal() {
            return VAPI.AT1101.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "signal"));
        }
    }
    J2KDecoder.J2KDecoderVideoRuntime = J2KDecoderVideoRuntime;
})(J2KDecoder || (J2KDecoder = {}));
export var MasterClock;
(function (MasterClock) {
    MasterClock.lift = {
        All: (_raw) => (new All(_raw)),
        GPSReceiver: (_raw) => (new GPSReceiver(_raw)),
        LTCGenerator: (_raw) => (new LTCGenerator(_raw)),
    };
    MasterClock.lower = {
        All: (_x) => _x.raw.kwl,
        GPSReceiver: (_x) => _x.raw.kwl,
        LTCGenerator: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "MasterClock::Data::All";
        get runtime_constants() {
            return {
                num_ltc_generators: this.raw.backing_store.get_runtime_constant("MasterClock::num_ltc_generators")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get gps_receivers() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "gps_receivers"), (raw, _) => VAPI.AT1101.MasterClock.lift.GPSReceiver(raw));
        }
        get ltc_generators() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "ltc_generators"), (raw) => new VAPI.AT1101.MasterClock.LTCGeneratorAsNamedTableRow(raw));
        }
        get ltc_slice() {
            return VAPI.Audio.lift.SignalSourceSlice(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "ltc_slice"));
        }
    }
    MasterClock.All = All;
    class GPSReceiver {
        raw;
        type_identifier = "MasterClock::Data::GPSReceiver";
        constructor(raw) {
            this.raw = raw;
        }
        get date() {
            return new VScript.rKeyword(this, "date", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MasterClock.lift.GPSReceiverDate),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MasterClock.lower.GPSReceiverDate)
            });
        }
        get time_of_day() {
            return new VScript.rKeyword(this, "time_of_day", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MasterClock.lift.GPSReceiverTimeOfDay),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MasterClock.lower.GPSReceiverTimeOfDay)
            });
        }
        get num_satellites() {
            return new VScript.rKeyword(this, "num_satellites", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get used_satellites() {
            return new VScript.rKeyword(this, "used_satellites", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get removed_satellites() {
            return new VScript.rKeyword(this, "removed_satellites", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "ptp_traits"));
        }
        get output() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "output"));
        }
    }
    MasterClock.GPSReceiver = GPSReceiver;
    class LTCGenerator {
        raw;
        type_identifier = "MasterClock::Data::LTCGenerator";
        constructor(raw) {
            this.raw = raw;
        }
        get timezone() {
            return new VScript.dKeyword(this, "timezone", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get custom_timezone_offset() {
            return new VScript.dKeyword(this, "custom_timezone_offset", {
                lift: VAPI.MasterClock.lift.TimezoneOffset,
                lower: VAPI.MasterClock.lower.TimezoneOffset
            }, {
                lift: VAPI.MasterClock.lift.TimezoneOffset,
                lower: VAPI.MasterClock.lower.TimezoneOffset
            }, null);
        }
        get frame_rate() {
            return new VScript.dKeyword(this, "frame_rate", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          * `UTC` (Universal Time, Coordinated) is the standard for wall clock
          time. It is the standard that all timezones are based on. UTC has leap
          seconds to account for differences in the Earth's rotational speed. *When
          in doubt, always use `UTC`*
          
          * `TAI` (International Atomic Time) is the time standard used by PTP. It
          is a linear time standard that does not have leap seconds. TAI is
          currently ahead of UTC by 37 seconds.
        */
        get time_standard() {
            return new VScript.dKeyword(this, "time_standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get reset_counter() {
            return new VScript.rKeyword(this, "reset_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "output"));
        }
    }
    MasterClock.LTCGenerator = LTCGenerator;
    class LTCGeneratorAsNamedTableRow extends LTCGenerator {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    MasterClock.LTCGeneratorAsNamedTableRow = LTCGeneratorAsNamedTableRow;
})(MasterClock || (MasterClock = {}));
export var MetadataProcessor;
(function (MetadataProcessor) {
    MetadataProcessor.lift = {
        All: (_raw) => (new All(_raw)),
        MetadataExtractor: (_raw) => (new MetadataExtractor(_raw)),
        MetadataInserter: (_raw) => (new MetadataInserter(_raw)),
        Request: (_raw) => (new Request(_raw)),
        Response: (_raw) => (new Response(_raw)),
    };
    MetadataProcessor.lower = {
        All: (_x) => _x.raw.kwl,
        MetadataExtractor: (_x) => _x.raw.kwl,
        MetadataInserter: (_x) => _x.raw.kwl,
        Request: (_x) => _x.raw.kwl,
        Response: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "MetadataProcessor::Data::All";
        get runtime_constants() {
            return {
                num_metadata_inserters: this.raw.backing_store.get_runtime_constant("MetadataProcessor::num_metadata_inserters"),
                num_metadata_extractors: this.raw.backing_store.get_runtime_constant("MetadataProcessor::num_metadata_extractors")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get rtp_channel() {
            return new VScript.rKeyword(this, "rtp_channel", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get responses() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "responses"), (raw, _) => VAPI.AT1101.MetadataProcessor.lift.Response(raw));
        }
    }
    MetadataProcessor.All = All;
    class MetadataExtractor {
        raw;
        type_identifier = "MetadataProcessor::Data::MetadataExtractor";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get extractor_type() {
            return new VScript.rKeyword(this, "extractor_type", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get bnc_node() {
            return new VScript.rKeyword(this, "bnc_node", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get media_clock() {
            return new VScript.rKeyword(this, "media_clock", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get standard() {
            return new VScript.rKeyword(this, "standard", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get rtp_requested() {
            return new VScript.rKeyword(this, "rtp_requested", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get rtp_index() {
            return new VScript.rKeyword(this, "rtp_index", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
    }
    MetadataProcessor.MetadataExtractor = MetadataExtractor;
    class MetadataInserter {
        raw;
        type_identifier = "MetadataProcessor::Data::MetadataInserter";
        constructor(raw) {
            this.raw = raw;
        }
        get video_dt_node() {
            return new VScript.rKeyword(this, "video_dt_node", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get media_clock() {
            return new VScript.rKeyword(this, "media_clock", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get src() {
            return new VScript.dKeyword(this, "src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.MetadataProcessor.MetadataExtractor(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.MetadataProcessor.MetadataExtractor(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get filter() {
            return new VScript.dKeyword(this, "filter", {
                lift: VAPI.MetadataProcessor.lift.Filter,
                lower: VAPI.MetadataProcessor.lower.Filter
            }, {
                lift: VAPI.MetadataProcessor.lift.Filter,
                lower: VAPI.MetadataProcessor.lower.Filter
            }, null);
        }
        get vanc_locations() {
            return new VScript.dKeyword(this, "vanc_locations", {
                lift: VAPI.MetadataProcessor.lift.VANCEmbedderLocations,
                lower: VAPI.MetadataProcessor.lower.VANCEmbedderLocations
            }, {
                lift: VAPI.MetadataProcessor.lift.VANCEmbedderLocations,
                lower: VAPI.MetadataProcessor.lower.VANCEmbedderLocations
            }, null);
        }
        get fine_print() {
            return new VScript.dKeyword(this, "fine_print", {
                lift: VAPI.MetadataProcessor.lift.FinePrint,
                lower: VAPI.MetadataProcessor.lower.FinePrint
            }, {
                lift: VAPI.MetadataProcessor.lift.FinePrint,
                lower: VAPI.MetadataProcessor.lower.FinePrint
            }, null);
        }
    }
    MetadataProcessor.MetadataInserter = MetadataInserter;
    class Request {
        raw;
        type_identifier = "MetadataProcessor::Data::Request";
        constructor(raw) {
            this.raw = raw;
        }
        get inserter_standard() {
            return new VScript.rKeyword(this, "inserter_standard", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get src() {
            return new VScript.rKeyword(this, "src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.MetadataProcessor.MetadataExtractor(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get dst() {
            return new VScript.rKeyword(this, "dst", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.MetadataProcessor.MetadataInserter(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get filter() {
            return new VScript.rKeyword(this, "filter", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lift.Filter),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lower.Filter)
            });
        }
        get vanc_locations() {
            return new VScript.rKeyword(this, "vanc_locations", {
                lift: VAPI.MetadataProcessor.lift.VANCEmbedderLocations,
                lower: VAPI.MetadataProcessor.lower.VANCEmbedderLocations
            });
        }
        get fine_print() {
            return new VScript.rKeyword(this, "fine_print", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lift.FinePrint),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lower.FinePrint)
            });
        }
    }
    MetadataProcessor.Request = Request;
    class Response {
        raw;
        type_identifier = "MetadataProcessor::Data::Response";
        constructor(raw) {
            this.raw = raw;
        }
        get extractor_standard() {
            return new VScript.rKeyword(this, "extractor_standard", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get inserter_standard() {
            return new VScript.rKeyword(this, "inserter_standard", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get src() {
            return new VScript.rKeyword(this, "src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.MetadataProcessor.MetadataExtractor(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get dst() {
            return new VScript.rKeyword(this, "dst", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.MetadataProcessor.MetadataInserter(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get filter() {
            return new VScript.rKeyword(this, "filter", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lift.Filter),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lower.Filter)
            });
        }
        get vanc_locations() {
            return new VScript.rKeyword(this, "vanc_locations", {
                lift: VAPI.MetadataProcessor.lift.VANCEmbedderLocations,
                lower: VAPI.MetadataProcessor.lower.VANCEmbedderLocations
            });
        }
        get fine_print() {
            return new VScript.rKeyword(this, "fine_print", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lift.FinePrint),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lower.FinePrint)
            });
        }
        get statistics() {
            return new VScript.rKeyword(this, "statistics", {
                lift: VAPI.MetadataProcessor.lift.ResponseStatistics,
                lower: VAPI.MetadataProcessor.lower.ResponseStatistics
            });
        }
        /**
          Metadata inserters generally attempt to match their video stream's
          underlying media clock by delaying the supplied ANC streams accordingly.
          If the desired media clock offset cannot be met because, e.g., the ANC
          stream is already coming in too late, or Timecode/AFD continuity
          requirements force the inserter to soften its mediaclock criterion,
          packets may either be discarded or embedded out-of-phase. In the latter
          case, the mismatch between the embedded ANC stream's de-facto mediaclock
          and its target value is represented by `phase_mismatch`, with negative
          values corresponding to late ANC streams.
        */
        get phase_mismatch() {
            return new VScript.rKeyword(this, "phase_mismatch", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lift.TimestampedOffset),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lower.TimestampedOffset)
            });
        }
    }
    MetadataProcessor.Response = Response;
})(MetadataProcessor || (MetadataProcessor = {}));
export var Monitoring;
(function (Monitoring) {
    Monitoring.lift = {
        All: (_raw) => (new All(_raw)),
        AudioLoudness: (_raw) => (new AudioLoudness(_raw)),
        AudioPhaseCorrelation: (_raw) => (new AudioPhaseCorrelation(_raw)),
        LiveView: (_raw) => (new LiveView(_raw)),
    };
    Monitoring.lower = {
        All: (_x) => _x.raw.kwl,
        AudioLoudness: (_x) => _x.raw.kwl,
        AudioPhaseCorrelation: (_x) => _x.raw.kwl,
        LiveView: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "Monitoring::Data::All";
        get runtime_constants() {
            return {
                num_audio_phase_correlation: this.raw.backing_store.get_runtime_constant("Monitoring::num_audio_phase_correlation"),
                num_audio_loudness_instances: this.raw.backing_store.get_runtime_constant("Monitoring::num_audio_loudness_instances")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get audio() {
            return VAPI.Monitoring.lift.Audio(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "audio"));
        }
        get video() {
            return VAPI.Monitoring.lift.Video(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "video"));
        }
        get live_view() {
            return VAPI.AT1101.Monitoring.lift.LiveView(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "live_view"));
        }
        get correlation() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 3, "correlation"), (raw) => new VAPI.AT1101.Monitoring.AudioPhaseCorrelationAsNamedTableRow(raw));
        }
        get loudness() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 4, "loudness"), (raw) => new VAPI.AT1101.Monitoring.AudioLoudnessAsNamedTableRow(raw));
        }
    }
    Monitoring.All = All;
    class AudioLoudness {
        raw;
        type_identifier = "Monitoring::Data::AudioLoudness";
        constructor(raw) {
            this.raw = raw;
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get channels() {
            return VAPI.Monitoring.lift.AudioLoudnessChannels(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "channels"));
        }
        get mode() {
            return new VScript.dKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Set to false to pause gated_loudness measurement and back to true to
          resume
        */
        get active() {
            return new VScript.dKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          True peak meters
          
          Order: left, right, center, surround_left, surround_right,
          rear_surround_left, rear_surround_right
        */
        get true_peak_meter() {
            return new VScript.rKeyword(this, "true_peak_meter", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
            });
        }
        /**
          Measured over the last 400 ms
        */
        get momentary_loudness() {
            return new VScript.rKeyword(this, "momentary_loudness", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Measured over the last 3 s
        */
        get short_term_loudness() {
            return new VScript.rKeyword(this, "short_term_loudness", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get gated_loudness() {
            return new VScript.rKeyword(this, "gated_loudness", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          How much data has been recorded for the gated loudness measurement so far
        */
        get gated_loudness_recorded() {
            return new VScript.rKeyword(this, "gated_loudness_recorded", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            });
        }
        /**
          Reset
        */
        get reset() {
            return new VScript.wKeyword(this, "reset", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    Monitoring.AudioLoudness = AudioLoudness;
    class AudioLoudnessAsNamedTableRow extends AudioLoudness {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    Monitoring.AudioLoudnessAsNamedTableRow = AudioLoudnessAsNamedTableRow;
    class AudioPhaseCorrelation {
        raw;
        type_identifier = "Monitoring::Data::AudioPhaseCorrelation";
        constructor(raw) {
            this.raw = raw;
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get pairs() {
            return new VScript.dKeyword(this, "pairs", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get peak_meter() {
            return new VScript.rKeyword(this, "peak_meter", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
            });
        }
        get correlation() {
            return new VScript.rKeyword(this, "correlation", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
            });
        }
    }
    Monitoring.AudioPhaseCorrelation = AudioPhaseCorrelation;
    class AudioPhaseCorrelationAsNamedTableRow extends AudioPhaseCorrelation {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    Monitoring.AudioPhaseCorrelationAsNamedTableRow = AudioPhaseCorrelationAsNamedTableRow;
    class LiveView {
        raw;
        type_identifier = "Monitoring::Data::LiveView";
        constructor(raw) {
            this.raw = raw;
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get timestamped_signature() {
            return new VScript.rKeyword(this, "timestamped_signature", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lift.TimestampedSignature),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lower.TimestampedSignature)
            });
        }
    }
    Monitoring.LiveView = LiveView;
})(Monitoring || (Monitoring = {}));
export var MultiviewerIO;
(function (MultiviewerIO) {
    MultiviewerIO.lift = {
        All: (_raw) => (new All(_raw)),
    };
    MultiviewerIO.lower = { All: (_x) => _x.raw.kwl, };
    class All {
        raw;
        type_identifier = "MultiviewerIO::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get distributed() {
            return VAPI.MultiviewerIO.lift.DistributedMultiviewer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "distributed"));
        }
        get cores() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 1, "cores"), (st, _) => VAPI.MultiviewerIO.lift.ManifoldCore(st));
        }
        get outputs() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 2, "outputs"), (st, _) => VAPI.AT1101.Video.lift.Essence(st));
        }
    }
    MultiviewerIO.All = All;
})(MultiviewerIO || (MultiviewerIO = {}));
export var NetworkInterfaces;
(function (NetworkInterfaces) {
    NetworkInterfaces.lift = {
        All: (_raw) => (new All(_raw)),
        LaneStatistics: (_raw) => (new LaneStatistics(_raw)),
        Port: (_raw) => (new Port(_raw)),
    };
    NetworkInterfaces.lower = {
        All: (_x) => _x.raw.kwl,
        LaneStatistics: (_x) => _x.raw.kwl,
        Port: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "NetworkInterfaces::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          Save all interfaces
        */
        get save_config() {
            return new VScript.wKeyword(this, "save_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Revert all interfaces
        */
        get revert_config() {
            return new VScript.wKeyword(this, "revert_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Save all syslog settings
        */
        get save_syslog_config() {
            return new VScript.wKeyword(this, "save_syslog_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Revert all syslog settings
        */
        get revert_syslog_config() {
            return new VScript.wKeyword(this, "revert_syslog_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get ports() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "ports"), (raw, _) => VAPI.AT1101.NetworkInterfaces.lift.Port(raw));
        }
        get hostname() {
            return VAPI.NetworkInterfaces.lift.HostnameConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "hostname"));
        }
        get current_veth_configuration() {
            return VAPI.NetworkInterfaces.lift.CurrentVirtualEthernetConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "current_veth_configuration"));
        }
        get desired_veth_configuration() {
            return VAPI.NetworkInterfaces.lift.DesiredVirtualEthernetConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "desired_veth_configuration"));
        }
    }
    NetworkInterfaces.All = All;
    class LaneStatistics {
        raw;
        type_identifier = "NetworkInterfaces::Data::LaneStatistics";
        constructor(raw) {
            this.raw = raw;
        }
        get lane() {
            return new VScript.rKeyword(this, "lane", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          maximum throughput (per direction)
        */
        get max_throughput() {
            return new VScript.rKeyword(this, "max_throughput", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get tx_streams() {
            return new VScript.rKeywordReferenceable(this, "tx_streams", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            }, {
                lift: VScript.VAPIHelpers.liftArray(VAPI.EthernetStats.lift.Counter),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.EthernetStats.lower.Counter)
            });
        }
        get tx_all_streams() {
            return new VScript.rKeyword(this, "tx_all_streams", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            });
        }
        get locked_to_data() {
            return new VScript.rKeyword(this, "locked_to_data", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get block_lock() {
            return new VScript.rKeyword(this, "block_lock", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get high_ber() {
            return new VScript.rKeyword(this, "high_ber", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get bip_errors() {
            return new VScript.rKeyword(this, "bip_errors", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get eye() {
            return VAPI.NetworkInterfaces.lift.EyeDiagram(VScript.VAPIHelpers.subtree_child_checked(this.raw, 9, "eye"));
        }
    }
    NetworkInterfaces.LaneStatistics = LaneStatistics;
    class Port {
        raw;
        type_identifier = "NetworkInterfaces::Data::Port";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get port_id() {
            return new VScript.rKeyword(this, "port_id", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get device_name() {
            return new VScript.rKeyword(this, "device_name", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          maximum throughput (per direction)
        */
        get max_throughput() {
            return new VScript.rKeyword(this, "max_throughput", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get port_mode() {
            return new VScript.dKeyword(this, "port_mode", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        get fault_status() {
            return new VScript.rKeyword(this, "fault_status", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get health() {
            return VAPI.NetworkInterfaces.lift.Health(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "health"));
        }
        get link_up() {
            return new VScript.rKeyword(this, "link_up", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          System runtime since boot
        */
        get link_up_last_changed() {
            return new VScript.rKeyword(this, "link_up_last_changed", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            });
        }
        /**
          How often link_up has changed since boot
        */
        get link_up_changed_count() {
            return new VScript.rKeyword(this, "link_up_changed_count", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          MAC address, stored in big-endian order.
        */
        get mac_address() {
            return new VScript.rKeyword(this, "mac_address", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
            });
        }
        get supports_ptp() {
            return new VScript.rKeyword(this, "supports_ptp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get supports_rtp() {
            return new VScript.rKeyword(this, "supports_rtp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          To execute shell commands on this interface, you will first need to enter
          its hosting network namespace. E.g., if `network_namespace` reads
          `ns_eth0.2`, the following command lists its IP addresses: `ip netns exec
          ns_eth0.2 ip addr show`
        */
        get network_namespace() {
            return new VScript.rKeyword(this, "network_namespace", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get current_configuration() {
            return VAPI.NetworkInterfaces.lift.CurrentPortConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 14, "current_configuration"));
        }
        /**
          Save interface
        */
        get save_config() {
            return new VScript.wKeyword(this, "save_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Revert interface
        */
        get revert_config() {
            return new VScript.wKeyword(this, "revert_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get desired_configuration() {
            return VAPI.NetworkInterfaces.lift.DesiredPortConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 17, "desired_configuration"));
        }
        /**
          Save syslog settings
        */
        get save_syslog_config() {
            return new VScript.wKeyword(this, "save_syslog_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Revert syslog settings
        */
        get revert_syslog_config() {
            return new VScript.wKeyword(this, "revert_syslog_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get current_syslog_configuration() {
            return VAPI.NetworkInterfaces.lift.CurrentSyslogConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 20, "current_syslog_configuration"));
        }
        get desired_syslog_configuration() {
            return VAPI.NetworkInterfaces.lift.DesiredSyslogConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 21, "desired_syslog_configuration"));
        }
        get virtual_interfaces() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 22, "virtual_interfaces"), (raw, _) => VAPI.NetworkInterfaces.lift.VirtualInterface(raw));
        }
        /**
          Updated every time a virtual interface is added, removed, or has its list
          of ip addresses changed (not necessarily monotonic, since PTP-derived).
        */
        get last_vifc_change() {
            return new VScript.rKeyword(this, "last_vifc_change", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftTimestamp),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerTimestamp)
            });
        }
        get fpga_lane_statistics() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 24, "fpga_lane_statistics"), (raw, _) => VAPI.AT1101.NetworkInterfaces.lift.LaneStatistics(raw));
        }
        /**
          aggregate statistics as obtained by summing over all of a
          (FPGA-connected) port's internal lanes. Note that management ports never
          report traffic statistics, regardless of their actual activity
        */
        get aggregate_traffic_statistics() {
            return VAPI.AT1101.EthernetStats.lift.PortStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 25, "aggregate_traffic_statistics"));
        }
        get lldp_neighbors() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 26, "lldp_neighbors"), (raw, _) => VAPI.NetworkInterfaces.lift.LLDPNeighbor(raw));
        }
    }
    NetworkInterfaces.Port = Port;
    NetworkInterfaces.Enums = {
        PortMode: ["eth1g", "eth10g", "eth40g"],
        Lane: ["P1_0", "P1_1", "P1_2", "P1_3", "P2_0", "P2_1", "P2_2", "P2_3"]
    };
})(NetworkInterfaces || (NetworkInterfaces = {}));
export var PCap;
(function (PCap) {
    PCap.lift = {
        All: (_raw) => (new All(_raw)),
        Instance: (_raw) => (new Instance(_raw)),
        Mode: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "Store", value: VAPI.PCap.lift.ModeStore(_raw[1], _socket) };
                case 1: return { variant: "StoreAndForward", value: VAPI.AT1101.PCap.lift.ModeStoreAndForward(_raw[1], _socket) };
            }
            ;
        },
        ModeStoreAndForward: (_raw, _socket) => {
            return {
                min_delay: VScript.VAPIHelpers.liftNanoseconds(_raw[0], _socket),
                packet_loss_rate: _raw[1]
            };
        },
    };
    PCap.lower = {
        All: (_x) => _x.raw.kwl,
        Instance: (_x) => _x.raw.kwl,
        Mode: (_x, _socket) => {
            switch (_x.variant) {
                case "Store": return [0, VAPI.PCap.lower.ModeStore(_x.value, _socket)];
                case "StoreAndForward": return [1, VAPI.AT1101.PCap.lower.ModeStoreAndForward(_x.value, _socket)];
            }
        },
        ModeStoreAndForward: (_x, _socket) => [
            VScript.VAPIHelpers.lowerNanoseconds(_x.min_delay, _socket),
            _x.packet_loss_rate
        ],
    };
    class All {
        raw;
        type_identifier = "PCap::Data::All";
        get runtime_constants() {
            return {
                num_instances: this.raw.backing_store.get_runtime_constant("PCap::num_instances")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get instances() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 0, "instances"), (st, _) => VAPI.AT1101.PCap.lift.Instance(st));
        }
    }
    PCap.All = All;
    class Instance {
        raw;
        type_identifier = "PCap::Data::Instance";
        constructor(raw) {
            this.raw = raw;
        }
        get ingress() {
            return new VScript.rKeyword(this, "ingress", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.NetworkInterfaces.Port(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get egress() {
            return new VScript.rKeyword(this, "egress", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.NetworkInterfaces.Port(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get mode() {
            return new VScript.dKeyword(this, "mode", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.PCap.lift.Mode),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.PCap.lower.Mode)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.PCap.lift.Mode),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.PCap.lower.Mode)
            }, null);
        }
        /**
          Memory area currently holding valid pcap data
        */
        get cur_range() {
            return new VScript.rKeyword(this, "cur_range", {
                lift: VAPI.PCap.lift.MemoryRange,
                lower: VAPI.PCap.lower.MemoryRange
            });
        }
        /**
          number of packets discarded because of FIFO overflow, or RX errors. Does
          not include packet losses introduced by a nonzero value of
          `packet_loss_rate`.
        */
        get packets_discarded() {
            return new VScript.rKeyword(this, "packets_discarded", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get pending_dma_transfers() {
            return new VScript.rKeyword(this, "pending_dma_transfers", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get capacity_at_cur_rate() {
            return new VScript.rKeyword(this, "capacity_at_cur_rate", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            });
        }
        get igmp_memberships() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 7, "igmp_memberships"), (raw) => new VAPI.PCap.IGMPMembershipAsNamedTableRow(raw));
        }
    }
    PCap.Instance = Instance;
})(PCap || (PCap = {}));
export var PTPClock;
(function (PTPClock) {
    PTPClock.lift = {
        All: (_raw) => (new All(_raw)),
    };
    PTPClock.lower = { All: (_x) => _x.raw.kwl, };
    class All {
        raw;
        type_identifier = "PTPClock::Data::All";
        get runtime_constants() {
            return {
                allows_clock_randomization: this.raw.backing_store.get_runtime_constant("PTPClock::allows_clock_randomization")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get state() {
            return new VScript.rKeyword(this, "state", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          when `mode` is set to `LockToInput`, the PTP clock will attempt to
          synchronize with the external time source designated by `input`. This is
          the default setting and typically the only option suitable for production
          use.
          
          When `mode` is set to `UseInternalOscillator`, the PTP clock will first
          reset its speed to the nominal clock rate generated by its internal
          oscillator, and in the following suspend all clock control operations.
          Likewise, `Disconnect` suspends all clock control operations but in
          contrast to `UseInternalOscillator` continues to run at the current value
          of `relative_clock_speed`
        */
        get mode() {
            return new VScript.rwKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get statistics() {
            return VAPI.PTPClock.lift.AllStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "statistics"));
        }
        get relative_clock_speed() {
            return new VScript.rKeyword(this, "relative_clock_speed", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get parameters() {
            return VAPI.PTPClock.lift.AllParameters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "parameters"));
        }
        get micro_epochs() {
            return new VScript.rKeyword(this, "micro_epochs", {
                lift: VAPI.PTPClock.lift.MicroEpochs,
                lower: VAPI.PTPClock.lower.MicroEpochs
            });
        }
        get output() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "ptp_traits"));
        }
        /**
          @brief Randomize clock
          @desc Do not push this button
        */
        get randomize_clock() {
            return new VScript.rwKeyword(this, "randomize_clock", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    PTPClock.All = All;
})(PTPClock || (PTPClock = {}));
export var PTPFlows;
(function (PTPFlows) {
    PTPFlows.lift = {
        Agent: (_raw) => (new Agent(_raw)),
        All: (_raw) => (new All(_raw)),
        Master: (_raw) => (new Master(_raw)),
        MasterSettings: (_raw) => (new MasterSettings(_raw)),
        Port: (_raw) => (new Port(_raw)),
        PortBestMasters: (_raw) => (new PortBestMasters(_raw)),
        MasterVisibleVia: (_raw) => (new MasterVisibleVia(_raw)),
    };
    PTPFlows.lower = {
        Agent: (_x) => _x.raw.kwl,
        All: (_x) => _x.raw.kwl,
        Master: (_x) => _x.raw.kwl,
        MasterSettings: (_x) => _x.raw.kwl,
        Port: (_x) => _x.raw.kwl,
        PortBestMasters: (_x) => _x.raw.kwl,
        MasterVisibleVia: (_x) => _x.raw.kwl,
    };
    class Agent {
        raw;
        type_identifier = "PTPFlows::Data::Agent";
        constructor(raw) {
            this.raw = raw;
        }
        get mode() {
            return new VScript.rwKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get state() {
            return new VScript.rKeyword(this, "state", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get domain() {
            return new VScript.dKeyword(this, "domain", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get hosting_port() {
            return new VScript.dKeyword(this, "hosting_port", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.PTPFlows.Port(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.PTPFlows.Port(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        /**
          best (as defined by the Best Master Clock algorithm) PTP master visible
          on this interface and within this PTP domain, excluding this agent
          itself.
        */
        get best_foreign_master() {
            return new VScript.rKeyword(this, "best_foreign_master", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.PTPFlows.Master(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get slave_settings() {
            return VAPI.PTPFlows.lift.SlaveSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "slave_settings"));
        }
        get master_settings() {
            return VAPI.AT1101.PTPFlows.lift.MasterSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "master_settings"));
        }
        get slave_statistics() {
            return VAPI.PTPFlows.lift.AgentSlaveStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "slave_statistics"));
        }
        get master_statistics() {
            return VAPI.PTPFlows.lift.AgentMasterStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "master_statistics"));
        }
        get output() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 9, "output"));
        }
    }
    PTPFlows.Agent = Agent;
    class AgentAsNamedTableRow extends Agent {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    PTPFlows.AgentAsNamedTableRow = AgentAsNamedTableRow;
    class All {
        raw;
        type_identifier = "PTPFlows::Data::All";
        get runtime_constants() {
            return {
                supports_delayresp_in_hardware: this.raw.backing_store.get_runtime_constant("PTPFlows::supports_delayresp_in_hardware")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get general_settings() {
            return VAPI.PTPFlows.lift.AllGeneralSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "general_settings"));
        }
        get agents() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "agents"), (raw) => new VAPI.AT1101.PTPFlows.AgentAsNamedTableRow(raw));
        }
        get ports() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "ports"), (raw, _) => VAPI.AT1101.PTPFlows.lift.Port(raw));
        }
        get visible_masters() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 3, "visible_masters"), (raw, _) => VAPI.AT1101.PTPFlows.lift.Master(raw));
        }
    }
    PTPFlows.All = All;
    class Master {
        raw;
        type_identifier = "PTPFlows::Data::Master";
        constructor(raw) {
            this.raw = raw;
        }
        get gen_address() {
            return new VScript.rKeyword(this, "gen_address", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get evt_address() {
            return new VScript.rKeyword(this, "evt_address", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get visible_via() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "visible_via"), (raw, _) => VAPI.AT1101.PTPFlows.lift.MasterVisibleVia(raw));
        }
        /**
          PTP traits as extracted from the most recently received announce message
        */
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "ptp_traits"));
        }
    }
    PTPFlows.Master = Master;
    class MasterSettings {
        raw;
        type_identifier = "PTPFlows::Data::MasterSettings";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          base-2 logarithm of the announce interval in seconds. E.g., a setting of
          -2 will cause this agent to emit announce messages 4 times a second; 2
          times a second if this is set to -1.
        */
        get log2_announce_interval() {
            return new VScript.dKeyword(this, "log2_announce_interval", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          base-2 logarithm of the sync interval in seconds. E.g., a setting of -3
          will cause this agent to emit sync and followup messages 8 times a
          second; 4 times a second if this is set to -2.
        */
        get log2_sync_interval() {
            return new VScript.dKeyword(this, "log2_sync_interval", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get delay_decimation_factor() {
            return new VScript.rKeyword(this, "delay_decimation_factor", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get grandmaster() {
            return VAPI.PTPFlows.lift.MasterSettingsGrandmaster(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "grandmaster"));
        }
        /**
          unlike sync and follow-up messages, which contain no client-dependent
          information and are thus useful to all clients within their PTP domain,
          delay request/response messages are useful only to the inquiring client
          (and perhaps to the master if it wishes to monitor its clients' timing
          properties). Exchanging these messages via unicast reduces both network
          traffic and local workload but yields otherwise identical results (this
          mode may also be called `Hybrid` on other products). If
          `delay_resp_routing` is set to `Multicast`, all delay responses emitted
          by this agent will be sent to the PTP multicast address `224.0.1.129`
        */
        get delay_resp_routing() {
            return new VScript.dKeyword(this, "delay_resp_routing", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
    }
    PTPFlows.MasterSettings = MasterSettings;
    class Port {
        raw;
        type_identifier = "PTPFlows::Data::Port";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get hosting_interface() {
            return new VScript.rKeyword(this, "hosting_interface", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.VirtualInterface(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get lane() {
            return new VScript.rKeyword(this, "lane", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get port_identity() {
            return new VScript.rKeyword(this, "port_identity", {
                lift: VAPI.PTP.lift.PortIdentity,
                lower: VAPI.PTP.lower.PortIdentity
            });
        }
        get best_masters() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 5, "best_masters"), (st, _) => VAPI.AT1101.PTPFlows.lift.PortBestMasters(st));
        }
        /**
          use this TTL value for all multicast event messages (UDP port 319) sent
          out from this PTP port
        */
        get multicast_event_ttl() {
            return new VScript.dKeyword(this, "multicast_event_ttl", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          use this TTL value for all general multicast messages (UDP port 320) sent
          out from this PTP port
        */
        get multicast_general_ttl() {
            return new VScript.dKeyword(this, "multicast_general_ttl", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    PTPFlows.Port = Port;
    class PortBestMasters {
        raw;
        type_identifier = "PTPFlows::Data::Port::BestMasters";
        constructor(raw) {
            this.raw = raw;
        }
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.PTPFlows.Master(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    PTPFlows.PortBestMasters = PortBestMasters;
    class MasterVisibleVia {
        raw;
        type_identifier = "PTPFlows::Data::Master::VisibleVia";
        constructor(raw) {
            this.raw = raw;
        }
        get port() {
            return new VScript.rKeyword(this, "port", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.PTPFlows.Port(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        /**
          time at which an announce message from this master had last been received
          via the referenced port, measured relative to process initialization time
        */
        get announced_at() {
            return new VScript.rKeyword(this, "announced_at", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            });
        }
    }
    PTPFlows.MasterVisibleVia = MasterVisibleVia;
})(PTPFlows || (PTPFlows = {}));
export var Primitives;
(function (Primitives) {
    Primitives.Enums = {
        NetworkPortID: ["FRONT_MANAGEMENT", "REAR_MANAGEMENT", "PORT1", "PORT1_0", "PORT1_1", "PORT1_2", "PORT1_3", "PORT2", "PORT2_0", "PORT2_1", "PORT2_2", "PORT2_3"]
    };
})(Primitives || (Primitives = {}));
export var RTPReceiver;
(function (RTPReceiver) {
    RTPReceiver.lift = {
        AffineNetworkSource: (_raw, _socket) => {
            return {
                source: _raw[0] === null ? null : new VAPI.AT1101.RTPReceiver.NetworkSource(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                seqnr_offset: _raw[1]
            };
        },
        All: (_raw) => (new All(_raw)),
        AncBurstReceiver: (_raw) => (new AncBurstReceiver(_raw)),
        AssociatedStream: (_raw, _socket) => {
            return {
                stream: _raw[0] === null ? null : new VAPI.AT1101.RTPReceiver.PacketStream(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                subflow_index: _raw[1],
                read_delay: _raw[2] === null ? null : VAPI.Time.lift.TimestampedOffset(_raw[2], _socket)
            };
        },
        AudioBackend: (_raw, _socket) => {
            return {
                group: _raw[0],
                instance: _raw[1],
                servo: _raw[2] === null ? null : new VAPI.AT1101.RTPReceiver.AudioServo(VScript.VAPIHelpers.get_subtree(_socket, _raw[2])),
                slices: _raw[3].map(el => el === null ? null : el),
                channel: _raw[4]
            };
        },
        AudioCapabilities: (_raw, _socket) => {
            return {
                channel_capacity: _raw[0],
                supports_clean_switching: _raw[1],
                read_speed: VAPI.AT1101.RTPReceiver.lift.ReadSpeed(_raw[2], _socket)
            };
        },
        AudioFlowPartition: (_raw) => (new AudioFlowPartition(_raw)),
        AudioReceiver: (_raw) => (new AudioReceiver(_raw)),
        AudioServo: (_raw) => (new AudioServo(_raw)),
        BufferProfile: (_raw, _socket) => {
            return {
                channel: _raw[0],
                pseudo_channel: _raw[1],
                blockcount: _raw[2]
            };
        },
        BufferSizes: (_raw, _socket) => {
            return {
                for_audio: _raw[0],
                for_2022_6: _raw[1],
                for_2110_20_uhd_singlelink: _raw[2],
                for_2110_20_other: _raw[3],
                for_2042_2: _raw[4],
                for_jpeg_xs: _raw[5],
                for_passthrough: _raw[6]
            };
        },
        TimingTargetForeignMediaClock: (_raw, _socket) => {
            return {
                foreign_receiver: _raw[0] === null ? null : new VAPI.AT1101.RTPReceiver.MediaReceiver(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                extra_delay: VScript.VAPIHelpers.liftSeconds(_raw[1], _socket),
                on_backpressure: _raw[2]
            };
        },
        TimingTargetForeignReadDelay: (_raw, _socket) => {
            return {
                foreign_receiver: _raw[0] === null ? null : new VAPI.AT1101.RTPReceiver.MediaReceiver(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                extra_delay: VScript.VAPIHelpers.liftSeconds(_raw[1], _socket),
                on_backpressure: _raw[2]
            };
        },
        JpegXsVideoBackend: (_raw, _socket) => {
            return {
                group: _raw[0],
                instances: _raw[1].map(el => el === null ? null : el),
                channel: _raw[2],
                metadata: _raw[3] === null ? null : VAPI.AT1101.RTPReceiver.lift.MetadataBackend(_raw[3], _socket)
            };
        },
        ReadSpeedLockToGenlock: (_raw, _socket) => {
            return {};
        },
        MediaReceiver: (_raw) => (new MediaReceiver(_raw)),
        MetadataBackend: (_raw, _socket) => {
            return {
                group: _raw[0],
                instance: _raw[1],
                stats_id: VAPI.RTPReceiver.lift.StatsID(_raw[2], _socket),
                read_id: _raw[3],
                channel: _raw[4]
            };
        },
        NativeVideoBackend: (_raw, _socket) => {
            return {
                group: _raw[0],
                instances: _raw[1].map(el => el === null ? null : el),
                channel: _raw[2],
                metadata: _raw[3] === null ? null : VAPI.AT1101.RTPReceiver.lift.MetadataBackend(_raw[3], _socket)
            };
        },
        NetworkSource: (_raw) => (new NetworkSource(_raw)),
        PacketStream: (_raw) => (new PacketStream(_raw)),
        PacketTracer: (_raw) => (new PacketTracer(_raw)),
        PassthroughEssence: (_raw) => (new PassthroughEssence(_raw)),
        PassthroughFlowPartition: (_raw) => (new PassthroughFlowPartition(_raw)),
        PassthroughReceiver: (_raw) => (new PassthroughReceiver(_raw)),
        ReadSpeed: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "LockToGenlock", value: VAPI.AT1101.RTPReceiver.lift.ReadSpeedLockToGenlock(_raw[1], _socket) };
                case 1: return { variant: "Adaptive", value: VAPI.RTPReceiver.lift.ReadSpeedAdaptive(_raw[1], _socket) };
            }
            ;
        },
        ReserveAudioBackend: (_raw, _socket) => {
            return {
                group: _raw[0],
                instance: _raw[1],
                slices: _raw[2].map(el => el === null ? null : el),
                channel: _raw[3],
                fence: _raw[4] === null ? null : _raw[4]
            };
        },
        Session: (_raw) => (new Session(_raw)),
        TimingTargetTimeSource: (_raw, _socket) => {
            return {
                t_src: _raw[0] === null ? null : new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                use_rtp_timestamp: _raw[1]
            };
        },
        Timing: (_raw) => (new Timing(_raw)),
        TimingTarget: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "IngressPlusX", value: VAPI.RTPReceiver.lift.TimingTargetIngressPlusX(_raw[1], _socket) };
                case 1: return { variant: "EgressPlusX", value: VAPI.RTPReceiver.lift.TimingTargetEgressPlusX(_raw[1], _socket) };
                case 2: return { variant: "TimeSource", value: VAPI.AT1101.RTPReceiver.lift.TimingTargetTimeSource(_raw[1], _socket) };
                case 3: return { variant: "BufferMidpoint", value: VAPI.RTPReceiver.lift.TimingTargetBufferMidpoint(_raw[1], _socket) };
                case 4: return { variant: "ForeignReadDelay", value: VAPI.AT1101.RTPReceiver.lift.TimingTargetForeignReadDelay(_raw[1], _socket) };
                case 5: return { variant: "ForeignMediaClock", value: VAPI.AT1101.RTPReceiver.lift.TimingTargetForeignMediaClock(_raw[1], _socket) };
            }
            ;
        },
        VideoBackend: (_raw, _socket) => {
            return {
                native: _raw[0] === null ? null : VAPI.AT1101.RTPReceiver.lift.NativeVideoBackend(_raw[0], _socket),
                jpeg_xs: _raw[1] === null ? null : VAPI.AT1101.RTPReceiver.lift.JpegXsVideoBackend(_raw[1], _socket),
                servo: _raw[2] === null ? null : new VAPI.AT1101.RTPReceiver.VideoServo(VScript.VAPIHelpers.get_subtree(_socket, _raw[2]))
            };
        },
        VideoCapabilities: (_raw, _socket) => {
            return {
                supports_2022_6: _raw[0],
                supports_uhd_sample_interleaved: _raw[1],
                st2110_20_caliber: _raw[2] === null ? null : _raw[2],
                st2042_2_caliber: _raw[3] === null ? null : _raw[3],
                jpeg_xs_caliber: _raw[4] === null ? null : _raw[4],
                supports_2110_40: _raw[5],
                supports_clean_switching: _raw[6],
                read_speed: VAPI.AT1101.RTPReceiver.lift.ReadSpeed(_raw[7], _socket)
            };
        },
        VideoFlowPartition: (_raw) => (new VideoFlowPartition(_raw)),
        VideoReceiver: (_raw) => (new VideoReceiver(_raw)),
        VideoServo: (_raw) => (new VideoServo(_raw)),
        AllDiagnostics: (_raw) => (new AllDiagnostics(_raw)),
        PassthroughReceiverFlowPartitions: (_raw, _socket) => {
            return {
                sdp_a: _raw[0] === null ? null : new VAPI.AT1101.RTPReceiver.PassthroughFlowPartition(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                sdp_b: _raw[1] === null ? null : new VAPI.AT1101.RTPReceiver.PassthroughFlowPartition(VScript.VAPIHelpers.get_subtree(_socket, _raw[1]))
            };
        },
        AudioReceiverMediaSpecificFlowPartitions: (_raw, _socket) => {
            return {
                sdp_a: _raw[0] === null ? null : new VAPI.AT1101.RTPReceiver.AudioFlowPartition(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                sdp_b: _raw[1] === null ? null : new VAPI.AT1101.RTPReceiver.AudioFlowPartition(VScript.VAPIHelpers.get_subtree(_socket, _raw[1]))
            };
        },
        VideoReceiverMediaSpecificFlowPartitions: (_raw, _socket) => {
            return {
                sdp_a: _raw[0] === null ? null : new VAPI.AT1101.RTPReceiver.VideoFlowPartition(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                sdp_b: _raw[1] === null ? null : new VAPI.AT1101.RTPReceiver.VideoFlowPartition(VScript.VAPIHelpers.get_subtree(_socket, _raw[1]))
            };
        },
        AllDiagnosticsIgmpPerformanceMetricsIgmpLatency: (_raw, _socket) => {
            return {
                port: _raw[0] === null ? null : _raw[0],
                src: _raw[1] === null ? null : _raw[1],
                dst: _raw[2] === null ? null : _raw[2],
                time_to_first_mpacket: _raw[3] === null ? null : VScript.VAPIHelpers.liftSeconds(_raw[3], _socket),
                first_rtp_timestamp: _raw[4] === null ? null : _raw[4],
                first_rtp_seqnr: _raw[5] === null ? null : _raw[5],
                mpacket_interval: _raw[6] === null ? null : VScript.VAPIHelpers.liftSeconds(_raw[6], _socket)
            };
        },
        AllDiagnosticsIgmpPerformanceMetrics: (_raw) => (new AllDiagnosticsIgmpPerformanceMetrics(_raw)),
        AncBurstReceiverMediaClock: (_raw) => (new AncBurstReceiverMediaClock(_raw)),
        AudioReceiverMediaSpecific: (_raw) => (new AudioReceiverMediaSpecific(_raw)),
        VideoReceiverMediaSpecific: (_raw) => (new VideoReceiverMediaSpecific(_raw)),
        PassthroughEssenceMemoryBlocks: (_raw, _socket) => {
            return {
                channel: _raw[0],
                blocks: _raw[1].map(el => el === null ? null : el)
            };
        },
        AudioReceiverMediaSpecificOutput: (_raw) => (new AudioReceiverMediaSpecificOutput(_raw)),
        VideoReceiverMediaSpecificOutput: (_raw) => (new VideoReceiverMediaSpecificOutput(_raw)),
        MediaReceiverPacketStreams: (_raw) => (new MediaReceiverPacketStreams(_raw)),
        AllDiagnosticsRtpInput: (_raw, _socket) => {
            return {
                input_oom: _raw[0].map(el => el),
                queue_full: _raw[1],
                lowest_memfree: _raw[2],
                memfree: _raw[3],
                highest_fifo_usedw: _raw[4],
                fifo_usedw: _raw[5]
            };
        },
        AllSettings: (_raw) => (new AllSettings(_raw)),
    };
    RTPReceiver.lower = {
        AffineNetworkSource: (_x, _socket) => [
            _x.source === null ? null : _x.source.raw.kwl,
            _x.seqnr_offset
        ],
        All: (_x) => _x.raw.kwl,
        AncBurstReceiver: (_x) => _x.raw.kwl,
        AssociatedStream: (_x, _socket) => [
            _x.stream === null ? null : _x.stream.raw.kwl,
            _x.subflow_index,
            _x.read_delay === null ? null : VAPI.Time.lower.TimestampedOffset(_x.read_delay, _socket)
        ],
        AudioBackend: (_x, _socket) => [
            _x.group,
            _x.instance,
            _x.servo === null ? null : _x.servo.raw.kwl,
            _x.slices.map(el => el === null ? null : el),
            _x.channel
        ],
        AudioCapabilities: (_x, _socket) => [
            _x.channel_capacity,
            _x.supports_clean_switching,
            VAPI.AT1101.RTPReceiver.lower.ReadSpeed(_x.read_speed, _socket)
        ],
        AudioFlowPartition: (_x) => _x.raw.kwl,
        AudioReceiver: (_x) => _x.raw.kwl,
        AudioServo: (_x) => _x.raw.kwl,
        BufferProfile: (_x, _socket) => [
            _x.channel,
            _x.pseudo_channel,
            _x.blockcount
        ],
        BufferSizes: (_x, _socket) => [
            _x.for_audio,
            _x.for_2022_6,
            _x.for_2110_20_uhd_singlelink,
            _x.for_2110_20_other,
            _x.for_2042_2,
            _x.for_jpeg_xs,
            _x.for_passthrough
        ],
        TimingTargetForeignMediaClock: (_x, _socket) => [
            _x.foreign_receiver === null ? null : _x.foreign_receiver.raw.kwl,
            VScript.VAPIHelpers.lowerSeconds(_x.extra_delay, _socket),
            _x.on_backpressure
        ],
        TimingTargetForeignReadDelay: (_x, _socket) => [
            _x.foreign_receiver === null ? null : _x.foreign_receiver.raw.kwl,
            VScript.VAPIHelpers.lowerSeconds(_x.extra_delay, _socket),
            _x.on_backpressure
        ],
        JpegXsVideoBackend: (_x, _socket) => [
            _x.group,
            _x.instances.map(el => el === null ? null : el),
            _x.channel,
            _x.metadata === null ? null : VAPI.AT1101.RTPReceiver.lower.MetadataBackend(_x.metadata, _socket)
        ],
        ReadSpeedLockToGenlock: (_x, _socket) => [],
        MediaReceiver: (_x) => _x.raw.kwl,
        MetadataBackend: (_x, _socket) => [
            _x.group,
            _x.instance,
            VAPI.RTPReceiver.lower.StatsID(_x.stats_id, _socket),
            _x.read_id,
            _x.channel
        ],
        NativeVideoBackend: (_x, _socket) => [
            _x.group,
            _x.instances.map(el => el === null ? null : el),
            _x.channel,
            _x.metadata === null ? null : VAPI.AT1101.RTPReceiver.lower.MetadataBackend(_x.metadata, _socket)
        ],
        NetworkSource: (_x) => _x.raw.kwl,
        PacketStream: (_x) => _x.raw.kwl,
        PacketTracer: (_x) => _x.raw.kwl,
        PassthroughEssence: (_x) => _x.raw.kwl,
        PassthroughFlowPartition: (_x) => _x.raw.kwl,
        PassthroughReceiver: (_x) => _x.raw.kwl,
        ReadSpeed: (_x, _socket) => {
            switch (_x.variant) {
                case "LockToGenlock": return [0, VAPI.AT1101.RTPReceiver.lower.ReadSpeedLockToGenlock(_x.value, _socket)];
                case "Adaptive": return [1, VAPI.RTPReceiver.lower.ReadSpeedAdaptive(_x.value, _socket)];
            }
        },
        ReserveAudioBackend: (_x, _socket) => [
            _x.group,
            _x.instance,
            _x.slices.map(el => el === null ? null : el),
            _x.channel,
            _x.fence === null ? null : _x.fence
        ],
        Session: (_x) => _x.raw.kwl,
        TimingTargetTimeSource: (_x, _socket) => [
            _x.t_src === null ? null : _x.t_src.raw.kwl,
            _x.use_rtp_timestamp
        ],
        Timing: (_x) => _x.raw.kwl,
        TimingTarget: (_x, _socket) => {
            switch (_x.variant) {
                case "IngressPlusX": return [0, VAPI.RTPReceiver.lower.TimingTargetIngressPlusX(_x.value, _socket)];
                case "EgressPlusX": return [1, VAPI.RTPReceiver.lower.TimingTargetEgressPlusX(_x.value, _socket)];
                case "TimeSource": return [2, VAPI.AT1101.RTPReceiver.lower.TimingTargetTimeSource(_x.value, _socket)];
                case "BufferMidpoint": return [3, VAPI.RTPReceiver.lower.TimingTargetBufferMidpoint(_x.value, _socket)];
                case "ForeignReadDelay": return [4, VAPI.AT1101.RTPReceiver.lower.TimingTargetForeignReadDelay(_x.value, _socket)];
                case "ForeignMediaClock": return [5, VAPI.AT1101.RTPReceiver.lower.TimingTargetForeignMediaClock(_x.value, _socket)];
            }
        },
        VideoBackend: (_x, _socket) => [
            _x.native === null ? null : VAPI.AT1101.RTPReceiver.lower.NativeVideoBackend(_x.native, _socket),
            _x.jpeg_xs === null ? null : VAPI.AT1101.RTPReceiver.lower.JpegXsVideoBackend(_x.jpeg_xs, _socket),
            _x.servo === null ? null : _x.servo.raw.kwl
        ],
        VideoCapabilities: (_x, _socket) => [
            _x.supports_2022_6,
            _x.supports_uhd_sample_interleaved,
            _x.st2110_20_caliber === null ? null : _x.st2110_20_caliber,
            _x.st2042_2_caliber === null ? null : _x.st2042_2_caliber,
            _x.jpeg_xs_caliber === null ? null : _x.jpeg_xs_caliber,
            _x.supports_2110_40,
            _x.supports_clean_switching,
            VAPI.AT1101.RTPReceiver.lower.ReadSpeed(_x.read_speed, _socket)
        ],
        VideoFlowPartition: (_x) => _x.raw.kwl,
        VideoReceiver: (_x) => _x.raw.kwl,
        VideoServo: (_x) => _x.raw.kwl,
        AllDiagnostics: (_x) => _x.raw.kwl,
        PassthroughReceiverFlowPartitions: (_x, _socket) => [
            _x.sdp_a === null ? null : _x.sdp_a.raw.kwl,
            _x.sdp_b === null ? null : _x.sdp_b.raw.kwl
        ],
        AudioReceiverMediaSpecificFlowPartitions: (_x, _socket) => [
            _x.sdp_a === null ? null : _x.sdp_a.raw.kwl,
            _x.sdp_b === null ? null : _x.sdp_b.raw.kwl
        ],
        VideoReceiverMediaSpecificFlowPartitions: (_x, _socket) => [
            _x.sdp_a === null ? null : _x.sdp_a.raw.kwl,
            _x.sdp_b === null ? null : _x.sdp_b.raw.kwl
        ],
        AllDiagnosticsIgmpPerformanceMetricsIgmpLatency: (_x, _socket) => [
            _x.port === null ? null : _x.port,
            _x.src === null ? null : _x.src,
            _x.dst === null ? null : _x.dst,
            _x.time_to_first_mpacket === null ? null : VScript.VAPIHelpers.lowerSeconds(_x.time_to_first_mpacket, _socket),
            _x.first_rtp_timestamp === null ? null : _x.first_rtp_timestamp,
            _x.first_rtp_seqnr === null ? null : _x.first_rtp_seqnr,
            _x.mpacket_interval === null ? null : VScript.VAPIHelpers.lowerSeconds(_x.mpacket_interval, _socket)
        ],
        AllDiagnosticsIgmpPerformanceMetrics: (_x) => _x.raw.kwl,
        AncBurstReceiverMediaClock: (_x) => _x.raw.kwl,
        AudioReceiverMediaSpecific: (_x) => _x.raw.kwl,
        VideoReceiverMediaSpecific: (_x) => _x.raw.kwl,
        PassthroughEssenceMemoryBlocks: (_x, _socket) => [
            _x.channel,
            _x.blocks.map(el => el === null ? null : el)
        ],
        AudioReceiverMediaSpecificOutput: (_x) => _x.raw.kwl,
        VideoReceiverMediaSpecificOutput: (_x) => _x.raw.kwl,
        MediaReceiverPacketStreams: (_x) => _x.raw.kwl,
        AllDiagnosticsRtpInput: (_x, _socket) => [
            _x.input_oom.map(el => el),
            _x.queue_full,
            _x.lowest_memfree,
            _x.memfree,
            _x.highest_fifo_usedw,
            _x.fifo_usedw
        ],
        AllSettings: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "RTPReceiver::Data::All";
        get runtime_constants() {
            return {
                total_2022_6_audio_slices: this.raw.backing_store.get_runtime_constant("RTPReceiver::total_2022_6_audio_slices"),
                supports_2110_40_in_software: this.raw.backing_store.get_runtime_constant("RTPReceiver::supports_2110_40_in_software"),
                max_audio_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_audio_receivers"),
                uhd_packsize_2042_2: this.raw.backing_store.get_runtime_constant("RTPReceiver::uhd_packsize_2042_2"),
                uhd_packsize_2110_20: this.raw.backing_store.get_runtime_constant("RTPReceiver::uhd_packsize_2110_20"),
                supports_2110_40_in_hardware: this.raw.backing_store.get_runtime_constant("RTPReceiver::supports_2110_40_in_hardware"),
                max_metadata_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_metadata_receivers"),
                video_memory_channels: this.raw.backing_store.get_runtime_constant("RTPReceiver::video_memory_channels"),
                num_native_video_receiver_blocks: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_native_video_receiver_blocks"),
                audio_memory_channels: this.raw.backing_store.get_runtime_constant("RTPReceiver::audio_memory_channels"),
                total_2110_30_audio_slices: this.raw.backing_store.get_runtime_constant("RTPReceiver::total_2110_30_audio_slices"),
                num_metadata_extractors_per_video_receiver: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_metadata_extractors_per_video_receiver"),
                blocks_per_memory_channel: this.raw.backing_store.get_runtime_constant("RTPReceiver::blocks_per_memory_channel"),
                max_st2042_2_uhd_video_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_st2042_2_uhd_video_receivers"),
                max_sessions: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_sessions"),
                num_jpeg_xs_video_receiver_blocks: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_jpeg_xs_video_receiver_blocks"),
                max_passthrough_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_passthrough_receivers"),
                max_video_buffers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_video_buffers"),
                num_packet_tracers: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_packet_tracers"),
                max_anc_burst_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_anc_burst_receivers"),
                max_metadata_streams: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_metadata_streams"),
                max_st2110_20_uhd_video_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_st2110_20_uhd_video_receivers"),
                max_native_video_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_native_video_receivers"),
                num_audio_receiver_blocks: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_audio_receiver_blocks"),
                max_video_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_video_receivers"),
                max_metadata_buffers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_metadata_buffers"),
                max_jpeg_xs_video_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_jpeg_xs_video_receivers"),
                num_metadata_receiver_blocks: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_metadata_receiver_blocks"),
                num_audio_servos: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_audio_servos"),
                num_video_servos: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_video_servos"),
                max_st2042_2_video_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_st2042_2_video_receivers"),
                uhd_packsize_2si: this.raw.backing_store.get_runtime_constant("RTPReceiver::uhd_packsize_2si")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get license_information() {
            return VAPI.RTPReceiver.lift.AllLicenseInformation(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "license_information"));
        }
        get diagnostics() {
            return VAPI.AT1101.RTPReceiver.lift.AllDiagnostics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "diagnostics"));
        }
        get settings() {
            return VAPI.AT1101.RTPReceiver.lift.AllSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "settings"));
        }
        get latest_allocation_id() {
            return new VScript.rKeyword(this, "latest_allocation_id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get sessions() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 4, "sessions"), (raw) => new VAPI.AT1101.RTPReceiver.SessionAsNamedTableRow(raw));
        }
        get audio_receivers() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 5, "audio_receivers"), (raw) => new VAPI.AT1101.RTPReceiver.AudioReceiverAsNamedTableRow(raw));
        }
        get passthrough_receivers() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 6, "passthrough_receivers"), (raw) => new VAPI.AT1101.RTPReceiver.PassthroughReceiverAsNamedTableRow(raw));
        }
        get video_receivers() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 7, "video_receivers"), (raw) => new VAPI.AT1101.RTPReceiver.VideoReceiverAsNamedTableRow(raw));
        }
        get anc_burst_receivers() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 8, "anc_burst_receivers"), (raw) => new VAPI.AT1101.RTPReceiver.AncBurstReceiverAsNamedTableRow(raw));
        }
        get signal_slices_2110_30() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 9, "signal_slices_2110_30"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
        get signal_slices_2022_6() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 10, "signal_slices_2022_6"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
        get packet_streams() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 11, "packet_streams"), (raw, _) => VAPI.AT1101.RTPReceiver.lift.PacketStream(raw));
        }
        get network_sources() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 12, "network_sources"), (raw, _) => VAPI.AT1101.RTPReceiver.lift.NetworkSource(raw));
        }
        get audio_flow_partitions() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 13, "audio_flow_partitions"), (raw, _) => VAPI.AT1101.RTPReceiver.lift.AudioFlowPartition(raw));
        }
        get passthrough_flow_partitions() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 14, "passthrough_flow_partitions"), (raw, _) => VAPI.AT1101.RTPReceiver.lift.PassthroughFlowPartition(raw));
        }
        get video_flow_partitions() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 15, "video_flow_partitions"), (raw, _) => VAPI.AT1101.RTPReceiver.lift.VideoFlowPartition(raw));
        }
        get derived_ptp_traits() {
            return VAPI.RTPReceiver.lift.AllDerivedPtpTraits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 16, "derived_ptp_traits"));
        }
        get audio_servos() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 17, "audio_servos"), (st, _) => VAPI.AT1101.RTPReceiver.lift.AudioServo(st));
        }
        get video_servos() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 18, "video_servos"), (st, _) => VAPI.AT1101.RTPReceiver.lift.VideoServo(st));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    out_of_bandwidth: (x & 1) !== 0,
                    required_port_down: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.out_of_bandwidth ? 1 : 0) |
                    (x.required_port_down ? 2 : 0))
            });
        }
    }
    RTPReceiver.All = All;
    class AncBurstReceiver {
        raw;
        type_identifier = "RTPReceiver::Data::AncBurstReceiver";
        constructor(raw) {
            this.raw = raw;
        }
        get generic() {
            return VAPI.AT1101.RTPReceiver.lift.MediaReceiver(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "generic"));
        }
        get media_clock() {
            return VAPI.AT1101.RTPReceiver.lift.AncBurstReceiverMediaClock(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "media_clock"));
        }
    }
    RTPReceiver.AncBurstReceiver = AncBurstReceiver;
    class AncBurstReceiverAsNamedTableRow extends AncBurstReceiver {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPReceiver.AncBurstReceiverAsNamedTableRow = AncBurstReceiverAsNamedTableRow;
    class AudioFlowPartition {
        raw;
        type_identifier = "RTPReceiver::Data::AudioFlowPartition";
        constructor(raw) {
            this.raw = raw;
        }
        get id() {
            return new VScript.rKeyword(this, "id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get format() {
            return new VScript.rKeyword(this, "format", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get frequency() {
            return new VScript.rKeyword(this, "frequency", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get channelcount() {
            return new VScript.rKeyword(this, "channelcount", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get samplecount() {
            return new VScript.rKeyword(this, "samplecount", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Network sources feeding this flow partition; if more than 8 sources feed
          into a single partition, surplus sources will not be published via the
          web interface
        */
        get sources() {
            return new VScript.rKeyword(this, "sources", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AT1101.RTPReceiver.lift.AffineNetworkSource),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AT1101.RTPReceiver.lower.AffineNetworkSource)
            });
        }
    }
    RTPReceiver.AudioFlowPartition = AudioFlowPartition;
    class AudioReceiver {
        raw;
        type_identifier = "RTPReceiver::Data::AudioReceiver";
        constructor(raw) {
            this.raw = raw;
        }
        get generic() {
            return VAPI.AT1101.RTPReceiver.lift.MediaReceiver(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "generic"));
        }
        get media_specific() {
            return VAPI.AT1101.RTPReceiver.lift.AudioReceiverMediaSpecific(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "media_specific"));
        }
    }
    RTPReceiver.AudioReceiver = AudioReceiver;
    class AudioReceiverAsNamedTableRow extends AudioReceiver {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPReceiver.AudioReceiverAsNamedTableRow = AudioReceiverAsNamedTableRow;
    class AudioServo {
        raw;
        type_identifier = "RTPReceiver::Data::AudioServo";
        constructor(raw) {
            this.raw = raw;
        }
        get relative_speed() {
            return new VScript.rKeyword(this, "relative_speed", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get max_relative_speed() {
            return new VScript.rwKeyword(this, "max_relative_speed", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get max_acceleration() {
            return new VScript.rwKeyword(this, "max_acceleration", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get prioritize() {
            return new VScript.rKeyword(this, "prioritize", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get dt_node() {
            return new VScript.rKeyword(this, "dt_node", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get sop_dt_node() {
            return new VScript.rKeyword(this, "sop_dt_node", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
    }
    RTPReceiver.AudioServo = AudioServo;
    class MediaReceiver {
        raw;
        type_identifier = "RTPReceiver::Data::MediaReceiver";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get tracks() {
            return new VScript.rKeyword(this, "tracks", {
                lift: VAPI.RTPReceiver.lift.UsedReceiverTracks,
                lower: VAPI.RTPReceiver.lower.UsedReceiverTracks
            });
        }
        get main_region_holds() {
            return new VScript.rKeyword(this, "main_region_holds", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get hosting_session() {
            return new VScript.dKeyword(this, "hosting_session", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPReceiver.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPReceiver.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get ingress() {
            return new VScript.rKeyword(this, "ingress", {
                lift: VAPI.RTPReceiver.lift.Ingress,
                lower: VAPI.RTPReceiver.lower.Ingress
            });
        }
        get egress() {
            return new VScript.rKeyword(this, "egress", {
                lift: VAPI.RTPReceiver.lift.Egress,
                lower: VAPI.RTPReceiver.lower.Egress
            });
        }
        get expecting() {
            return new VScript.rKeyword(this, "expecting", {
                lift: VAPI.RTPReceiver.lift.Expectations,
                lower: VAPI.RTPReceiver.lower.Expectations
            });
        }
        /**
          Clear error counters
        */
        get clear_error_counters() {
            return new VScript.wKeyword(this, "clear_error_counters", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Clear event counters
        */
        get clear_event_counters() {
            return new VScript.wKeyword(this, "clear_event_counters", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    impossible_clean_switch_request: (x & 1) !== 0,
                    missing_or_uncalibrated_t_src: (x & 2) !== 0,
                    missing_streams: (x & 4) !== 0,
                    phase_mismatch: (x & 8) !== 0,
                    uncalibrated_genlock: (x & 16) !== 0,
                    undersized_timing_window: (x & 32) !== 0,
                    unsatisfied_capability_request: (x & 64) !== 0,
                    useless_capability_assignment: (x & 128) !== 0
                }),
                lower: (x, _) => ((x.impossible_clean_switch_request ? 1 : 0) |
                    (x.missing_or_uncalibrated_t_src ? 2 : 0) |
                    (x.missing_streams ? 4 : 0) |
                    (x.phase_mismatch ? 8 : 0) |
                    (x.uncalibrated_genlock ? 16 : 0) |
                    (x.undersized_timing_window ? 32 : 0) |
                    (x.unsatisfied_capability_request ? 64 : 0) |
                    (x.useless_capability_assignment ? 128 : 0))
            });
        }
        /**
          Ideally, this keyword shouldn't exist. In practice however, capability
          requests are currently processed eagerly, s.t. the outcome of a
          capability allocation attempt may depend on the order in which individual
          receivers are serviced. To ensure full state recovery across reboots, we
          thus store this ordering explicitly
        */
        get capability_request() {
            return new VScript.rKeyword(this, "capability_request", {
                lift: VAPI.RTPReceiver.lift.CapabilityRequestIDs,
                lower: VAPI.RTPReceiver.lower.CapabilityRequestIDs
            });
        }
        get flight_permit() {
            return VAPI.RTPReceiver.lift.MediaReceiverFlightPermit(VScript.VAPIHelpers.subtree_child_checked(this.raw, 11, "flight_permit"));
        }
        get error_counters() {
            return VAPI.RTPReceiver.lift.MediaReceiverErrorCounters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 12, "error_counters"));
        }
        get event_counters() {
            return VAPI.RTPReceiver.lift.MediaReceiverEventCounters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 13, "event_counters"));
        }
        get preparation_time() {
            return new VScript.dKeyword(this, "preparation_time", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get cooldown_time() {
            return new VScript.dKeyword(this, "cooldown_time", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get timing() {
            return VAPI.AT1101.RTPReceiver.lift.Timing(VScript.VAPIHelpers.subtree_child_checked(this.raw, 16, "timing"));
        }
        get packet_streams() {
            return VAPI.AT1101.RTPReceiver.lift.MediaReceiverPacketStreams(VScript.VAPIHelpers.subtree_child_checked(this.raw, 17, "packet_streams"));
        }
        get required_redundancy_level() {
            return new VScript.rKeyword(this, "required_redundancy_level", {
                lift: VAPI.RTPReceiver.lift.MediaReceiverRequiredRedundancyLevel,
                lower: VAPI.RTPReceiver.lower.MediaReceiverRequiredRedundancyLevel
            });
        }
        get redundancy_levels() {
            return VAPI.RTPReceiver.lift.MediaReceiverRedundancyLevels(VScript.VAPIHelpers.subtree_child_checked(this.raw, 19, "redundancy_levels"));
        }
        get latency_spread() {
            return VAPI.RTPReceiver.lift.MediaReceiverLatencySpread(VScript.VAPIHelpers.subtree_child_checked(this.raw, 20, "latency_spread"));
        }
        /**
          when set to `FirstStreamPresent`, the first packet stream to provide this
          receiver with valid format and timing characteristics will be used as the
          basis for the ensuing readout attempt. When set to `AllStreamsPresent`,
          the receiver will stall until all packet streams have been registered at
          their respective network interfaces. Whereas `FirstStreamPresent` may
          slightly reduce the time to readout, `AllStreamsPresent` is safer as it
          ensures immediate SPS protection (if so configured), and allows the
          receiver to correctly pick a rearguard stream if different network paths
          exhibit different transmission delays. In both cases, the set of packet
          streams considered encompasses only those flows directly referenced by
          this receiver's media description, not the auxiliary flows that may be
          routed to the receiver through stream sharing.
        */
        get initiate_readout_on() {
            return new VScript.dKeyword(this, "initiate_readout_on", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    RTPReceiver.MediaReceiver = MediaReceiver;
    class NetworkSource {
        raw;
        type_identifier = "RTPReceiver::Data::NetworkSource";
        constructor(raw) {
            this.raw = raw;
        }
        get packet_stream() {
            return new VScript.rKeyword(this, "packet_stream", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPReceiver.PacketStream(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPReceiver.NetworkSource = NetworkSource;
    class PacketStream {
        raw;
        type_identifier = "RTPReceiver::Data::PacketStream";
        constructor(raw) {
            this.raw = raw;
        }
        get stream_parameters() {
            return new VScript.rKeyword(this, "stream_parameters", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lift.PacketStreamStreamParameters),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lower.PacketStreamStreamParameters)
            });
        }
        /**
          no. of m-packets received since the last stream start (for audio streams,
          this refers to virtual m-packets). Note that for interlaced video
          streams, this number only includes lower field m-packets, i.e., a 50i
          2110 stream should report 25 m-packets per second.
        */
        get mpackets_received() {
            return new VScript.rKeyword(this, "mpackets_received", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get traffic_stats() {
            return new VScript.rKeyword(this, "traffic_stats", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            });
        }
        get media_clock() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "media_clock"));
        }
    }
    RTPReceiver.PacketStream = PacketStream;
    class PacketTracer {
        raw;
        type_identifier = "RTPReceiver::Data::PacketTracer";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          Set to true to enable realtime packet tracing in one of various modes.
          Note that packet tracing is CPU-intensive, and hence will always come up
          disabled after reboots.
        */
        get active() {
            return new VScript.dKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get mode() {
            return new VScript.dKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Set this to `Store` to have the packet tracer store packet details (up to
          some limited maximum log file size) that can later be downloaded via
          HTTP.
        */
        get packet_details() {
            return new VScript.dKeyword(this, "packet_details", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get filters() {
            return VAPI.RTPReceiver.lift.PacketTracerFilters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "filters"));
        }
        /**
          Reorder up to this many consecutive RTP packets before trying to check
          for missing sequence numbers
        */
        get reordering_depth() {
            return new VScript.dKeyword(this, "reordering_depth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get port() {
            return new VScript.dKeyword(this, "port", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.NetworkInterfaces.Port(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.NetworkInterfaces.Port(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cannot_activate_while_downloading: (x & 1) !== 0,
                    cannot_reconfigure_while_active: (x & 2) !== 0,
                    invalid_port_assignment: (x & 4) !== 0,
                    missing_port_assignment: (x & 8) !== 0,
                    non_ipv4_dst_address: (x & 16) !== 0,
                    non_multicast_dst_address: (x & 32) !== 0,
                    unordered_port_range: (x & 64) !== 0
                }),
                lower: (x, _) => ((x.cannot_activate_while_downloading ? 1 : 0) |
                    (x.cannot_reconfigure_while_active ? 2 : 0) |
                    (x.invalid_port_assignment ? 4 : 0) |
                    (x.missing_port_assignment ? 8 : 0) |
                    (x.non_ipv4_dst_address ? 16 : 0) |
                    (x.non_multicast_dst_address ? 32 : 0) |
                    (x.unordered_port_range ? 64 : 0))
            });
        }
        get cur_run() {
            return new VScript.rKeyword(this, "cur_run", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lift.PacketTracerRun),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lower.PacketTracerRun)
            });
        }
        get prev_run() {
            return new VScript.rKeyword(this, "prev_run", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lift.PacketTracerRun),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lower.PacketTracerRun)
            });
        }
        get num_pending_downloads() {
            return new VScript.rKeyword(this, "num_pending_downloads", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    RTPReceiver.PacketTracer = PacketTracer;
    class PassthroughEssence {
        raw;
        type_identifier = "RTPReceiver::Data::PassthroughEssence";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get stream_id() {
            return new VScript.rKeyword(this, "stream_id", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get memory_blocks() {
            return new VScript.rKeyword(this, "memory_blocks", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lift.PassthroughEssenceMemoryBlocks),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lower.PassthroughEssenceMemoryBlocks)
            });
        }
        get sdp() {
            return new VScript.rKeyword(this, "sdp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    RTPReceiver.PassthroughEssence = PassthroughEssence;
    class PassthroughFlowPartition {
        raw;
        type_identifier = "RTPReceiver::Data::PassthroughFlowPartition";
        constructor(raw) {
            this.raw = raw;
        }
        get id() {
            return new VScript.rKeyword(this, "id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Network sources feeding this flow partition; if more than 8 sources feed
          into a single partition, surplus sources will not be published via the
          web interface
        */
        get sources() {
            return new VScript.rKeyword(this, "sources", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AT1101.RTPReceiver.lift.AffineNetworkSource),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AT1101.RTPReceiver.lower.AffineNetworkSource)
            });
        }
    }
    RTPReceiver.PassthroughFlowPartition = PassthroughFlowPartition;
    class PassthroughReceiver {
        raw;
        type_identifier = "RTPReceiver::Data::PassthroughReceiver";
        constructor(raw) {
            this.raw = raw;
        }
        get tracks() {
            return new VScript.rKeyword(this, "tracks", {
                lift: VAPI.RTPReceiver.lift.UsedReceiverTracks,
                lower: VAPI.RTPReceiver.lower.UsedReceiverTracks
            });
        }
        get hosting_session() {
            return new VScript.dKeyword(this, "hosting_session", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPReceiver.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPReceiver.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get ingress() {
            return new VScript.rKeyword(this, "ingress", {
                lift: VAPI.RTPReceiver.lift.Ingress,
                lower: VAPI.RTPReceiver.lower.Ingress
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    subscription_failed: (x & 1) !== 0
                }),
                lower: (x, _) => ((x.subscription_failed ? 1 : 0))
            });
        }
        get output() {
            return VAPI.AT1101.RTPReceiver.lift.PassthroughEssence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "output"));
        }
        get reserved_buffer_id() {
            return new VScript.rKeyword(this, "reserved_buffer_id", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Ideally, this keyword shouldn't exist. In practice however, capability
          requests are currently processed eagerly, s.t. the outcome of a
          capability allocation attempt may depend on the order in which individual
          receivers are serviced. To ensure full state recovery across reboots, we
          thus store this ordering explicitly
        */
        get capability_request() {
            return new VScript.rKeyword(this, "capability_request", {
                lift: VAPI.RTPReceiver.lift.CapabilityRequestIDs,
                lower: VAPI.RTPReceiver.lower.CapabilityRequestIDs
            });
        }
        get flow_partitions() {
            return new VScript.rKeyword(this, "flow_partitions", {
                lift: VAPI.AT1101.RTPReceiver.lift.PassthroughReceiverFlowPartitions,
                lower: VAPI.AT1101.RTPReceiver.lower.PassthroughReceiverFlowPartitions
            });
        }
    }
    RTPReceiver.PassthroughReceiver = PassthroughReceiver;
    class PassthroughReceiverAsNamedTableRow extends PassthroughReceiver {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPReceiver.PassthroughReceiverAsNamedTableRow = PassthroughReceiverAsNamedTableRow;
    class Session {
        raw;
        type_identifier = "RTPReceiver::Data::Session";
        async set_sdp(track, sdp, pars) {
            // set to something != 0, so sending an unversioned request to a freshly
            // initialized session won't inadvertently come back with the correct
            // response version
            const INIT_VERSION = 10;
            const target_version = ((await this.last_accepted_track.read())?.controller_version ?? INIT_VERSION) + 1;
            let resolved = false;
            // FIXME: should have another write variant that allows event-driven external resolution, so we
            // could explicitly have watcher's callback declare success on the ensuing write call. The current
            // implementation of set_sdp will perform one unneeded write/check cycle instead
            const watcher = await this.last_accepted_track.watch((new_lat) => {
                if (new_lat?.controller_version === target_version)
                    resolved = true;
            });
            const transformed_sdp = (() => {
                const trimmed = (sdp ?? "").trim();
                if (trimmed.length === 0)
                    return `v=0\no=- 0 0 IN IP4 0.0.0.0\ns=empty\nt=0 0\na=controller-version:${target_version}`;
                const split = split_sdp(trimmed);
                return (split.header +
                    `\na=controller-version:${target_version}\n` +
                    split.media_descriptions.map((md) => md.text).join("\n"));
            })();
            try {
                // FIXME: apparently the RTPReceiverDriver doesn't like trailing newlines??
                await (track === "A" ? this.sdp_a : this.sdp_b).command.write(transformed_sdp.trim(), {
                    retry_until: {
                        criterion: "custom",
                        validator: async () => resolved,
                    },
                    ...(pars ?? {}),
                });
            }
            finally {
                watcher.unwatch();
            }
        }
        constructor(raw) {
            this.raw = raw;
        }
        /**
          A session only supports clean switching if all of its media receivers do
          (see
          `{audio,video}_receivers[*].media_specific.capabilities.supports_clean_switching`)
        */
        get supports_clean_switching() {
            return new VScript.rKeyword(this, "supports_clean_switching", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get switch_type() {
            return new VScript.dKeyword(this, "switch_type", {
                lift: VAPI.RTPReceiver.lift.SwitchType,
                lower: VAPI.RTPReceiver.lower.SwitchType
            }, {
                lift: VAPI.RTPReceiver.lift.SwitchType,
                lower: VAPI.RTPReceiver.lower.SwitchType
            }, null);
        }
        get video_receivers() {
            return new VScript.rKeyword(this, "video_receivers", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPReceiver.VideoReceiver(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get audio_receivers() {
            return new VScript.rKeyword(this, "audio_receivers", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPReceiver.AudioReceiver(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get anc_burst_receivers() {
            return new VScript.rKeyword(this, "anc_burst_receivers", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPReceiver.AncBurstReceiver(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get passthrough_receivers() {
            return new VScript.rKeyword(this, "passthrough_receivers", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPReceiver.PassthroughReceiver(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get active() {
            return new VScript.dKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get sdp_a() {
            return new VScript.dKeyword(this, "sdp_a", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get sdp_b() {
            return new VScript.dKeyword(this, "sdp_b", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get interfaces() {
            return new VScript.dKeyword(this, "interfaces", {
                lift: VAPI.RTPReceiver.lift.SessionInterfaces,
                lower: VAPI.RTPReceiver.lower.SessionInterfaces
            }, {
                lift: VAPI.RTPReceiver.lift.SessionInterfaces,
                lower: VAPI.RTPReceiver.lower.SessionInterfaces
            }, null);
        }
        get used_tracks() {
            return new VScript.rKeyword(this, "used_tracks", {
                lift: VAPI.RTPReceiver.lift.UsedSessionTracks,
                lower: VAPI.RTPReceiver.lower.UsedSessionTracks
            });
        }
        get last_accepted_track() {
            return new VScript.rKeyword(this, "last_accepted_track", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lift.SessionLastAcceptedTrack),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lower.SessionLastAcceptedTrack)
            });
        }
        get event_counters() {
            return VAPI.RTPReceiver.lift.SessionEventCounters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 12, "event_counters"));
        }
        get version_window() {
            return VAPI.RTPReceiver.lift.SessionVersionWindow(VScript.VAPIHelpers.subtree_child_checked(this.raw, 13, "version_window"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    switch_type_request_blocked: (x & 1) !== 0
                }),
                lower: (x, _) => ((x.switch_type_request_blocked ? 1 : 0))
            });
        }
    }
    RTPReceiver.Session = Session;
    class SessionAsNamedTableRow extends Session {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPReceiver.SessionAsNamedTableRow = SessionAsNamedTableRow;
    class Timing {
        raw;
        type_identifier = "RTPReceiver::Data::Timing";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          If possible, maintain at least this much distance from both buffer ends.
          Note that JPEG XS receivers will always enforce a safety margin of at
          least 4ms.
        */
        get safety_margin() {
            return new VScript.dKeyword(this, "safety_margin", {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, null);
        }
        /**
          Capacity of the receive buffer, as dictated by buffer settings, packet
          rates and limitations of the statistics engine
        */
        get buffer_capacity() {
            return new VScript.rKeyword(this, "buffer_capacity", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
            });
        }
        get target() {
            return new VScript.dKeyword(this, "target", {
                lift: VAPI.AT1101.RTPReceiver.lift.TimingTarget,
                lower: VAPI.AT1101.RTPReceiver.lower.TimingTarget
            }, {
                lift: VAPI.AT1101.RTPReceiver.lift.TimingTarget,
                lower: VAPI.AT1101.RTPReceiver.lower.TimingTarget
            }, null);
        }
        /**
          estimated time until |distance to buffer boundary| < 0.5 *
          `safety_margin`
        */
        get expected_time_to_collision() {
            return new VScript.rKeyword(this, "expected_time_to_collision", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
            });
        }
        get read_delay() {
            return VAPI.RTPReceiver.lift.TimingReadDelay(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "read_delay"));
        }
        get read_delay_bounds() {
            return new VScript.dKeyword(this, "read_delay_bounds", {
                lift: VAPI.RTPReceiver.lift.TimingReadDelayBounds,
                lower: VAPI.RTPReceiver.lower.TimingReadDelayBounds
            }, {
                lift: VAPI.RTPReceiver.lift.TimingReadDelayBounds,
                lower: VAPI.RTPReceiver.lower.TimingReadDelayBounds
            }, null);
        }
        get current_phase() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "current_phase"));
        }
        get safety_mismatch() {
            return new VScript.rKeyword(this, "safety_mismatch", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
            });
        }
        get phase_control() {
            return VAPI.RTPReceiver.lift.TimingPhaseControl(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "phase_control"));
        }
        /**
          delay readout of newly incoming streams until at least this many mpackets
          have been received. While this increases readout latency, this may also
          improve robustness if there is reason to believe that stream setup may
          sometimes be 'dirty' (e.g., with gaps within the first few received video
          frames)
        */
        get mpackets_warmup() {
            return new VScript.rwKeyword(this, "mpackets_warmup", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    RTPReceiver.Timing = Timing;
    class VideoFlowPartition {
        raw;
        type_identifier = "RTPReceiver::Data::VideoFlowPartition";
        constructor(raw) {
            this.raw = raw;
        }
        get id() {
            return new VScript.rKeyword(this, "id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get sdp_standard() {
            return new VScript.rKeyword(this, "sdp_standard", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get fmt_standard() {
            return new VScript.rKeyword(this, "fmt_standard", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get transport_format() {
            return new VScript.rKeyword(this, "transport_format", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Network sources feeding this flow partition; if more than 8 sources feed
          into a single partition, surplus sources will not be published via the
          web interface
        */
        get sources() {
            return new VScript.rKeyword(this, "sources", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AT1101.RTPReceiver.lift.AffineNetworkSource),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AT1101.RTPReceiver.lower.AffineNetworkSource)
            });
        }
    }
    RTPReceiver.VideoFlowPartition = VideoFlowPartition;
    class VideoReceiver {
        raw;
        type_identifier = "RTPReceiver::Data::VideoReceiver";
        constructor(raw) {
            this.raw = raw;
        }
        get generic() {
            return VAPI.AT1101.RTPReceiver.lift.MediaReceiver(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "generic"));
        }
        get media_specific() {
            return VAPI.AT1101.RTPReceiver.lift.VideoReceiverMediaSpecific(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "media_specific"));
        }
    }
    RTPReceiver.VideoReceiver = VideoReceiver;
    class VideoReceiverAsNamedTableRow extends VideoReceiver {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPReceiver.VideoReceiverAsNamedTableRow = VideoReceiverAsNamedTableRow;
    class VideoServo {
        raw;
        type_identifier = "RTPReceiver::Data::VideoServo";
        constructor(raw) {
            this.raw = raw;
        }
        get relative_speed() {
            return new VScript.rKeyword(this, "relative_speed", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get max_relative_speed() {
            return new VScript.rwKeyword(this, "max_relative_speed", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get max_acceleration() {
            return new VScript.rwKeyword(this, "max_acceleration", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get dt_node() {
            return new VScript.rKeyword(this, "dt_node", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
    }
    RTPReceiver.VideoServo = VideoServo;
    class AllDiagnostics {
        raw;
        type_identifier = "RTPReceiver::Data::All::Diagnostics";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          Clear traffic statistics
        */
        get clear_traffic_stats() {
            return new VScript.wKeyword(this, "clear_traffic_stats", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Clear input stage statistics
        */
        get clear_input_statistics() {
            return new VScript.wKeyword(this, "clear_input_statistics", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get aggregate_traffic_stats() {
            return new VScript.rKeyword(this, "aggregate_traffic_stats", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            });
        }
        /**
          if RAM calibration failed and rebooting does not fix the issue, please
          contact customer support
        */
        get ram_calibration() {
            return new VScript.rKeyword(this, "ram_calibration", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get memory_statistics() {
            return VAPI.Memory.lift.ECCMuxStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "memory_statistics"));
        }
        get rtp_input() {
            return new VScript.rKeyword(this, "rtp_input", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lift.AllDiagnosticsRtpInput)),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lower.AllDiagnosticsRtpInput))
            });
        }
        get mpacket_tracer() {
            return VAPI.RTPReceiver.lift.AllDiagnosticsMpacketTracer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "mpacket_tracer"));
        }
        get packet_tracers() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 7, "packet_tracers"), (st, _) => VAPI.AT1101.RTPReceiver.lift.PacketTracer(st));
        }
        get igmp_performance_metrics() {
            return VAPI.AT1101.RTPReceiver.lift.AllDiagnosticsIgmpPerformanceMetrics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "igmp_performance_metrics"));
        }
        /**
          Enable this option to have the receiver log every readout attempt to
          syslog. Potentially useful for debugging but very verbose, so you'll
          probably want to keep this disabled in production.
        */
        get log_readout_requests() {
            return new VScript.rwKeyword(this, "log_readout_requests", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Enable this option to have the receiver log every IGMP join/leave request
          to syslog. Potentially useful for debugging but very verbose, so you'll
          probably want to keep this disabled in production.
        */
        get log_igmp_requests() {
            return new VScript.rwKeyword(this, "log_igmp_requests", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    RTPReceiver.AllDiagnostics = AllDiagnostics;
    class AllDiagnosticsIgmpPerformanceMetrics {
        raw;
        type_identifier = "RTPReceiver::Data::All::Diagnostics::IgmpPerformanceMetrics";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          emit warning message if the time elapsed between an outgoing IGMP join
          request and the arrival of the first corresponding packet (estimated
          conservatively as `time_to_first_mpacket - mpacket_interval`) exceeds
          `warning_threshold`. Note that for interlaced 2110/2042 streams,
          upper-field mpackets are not considered.
        */
        get warning_threshold() {
            return new VScript.rwKeyword(this, "warning_threshold", {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, null);
        }
        get igmp_latency() {
            return new VScript.rKeyword(this, "igmp_latency", {
                lift: VAPI.AT1101.RTPReceiver.lift.AllDiagnosticsIgmpPerformanceMetricsIgmpLatency,
                lower: VAPI.AT1101.RTPReceiver.lower.AllDiagnosticsIgmpPerformanceMetricsIgmpLatency
            });
        }
    }
    RTPReceiver.AllDiagnosticsIgmpPerformanceMetrics = AllDiagnosticsIgmpPerformanceMetrics;
    class AncBurstReceiverMediaClock {
        raw;
        type_identifier = "RTPReceiver::Data::AncBurstReceiver::MediaClock";
        constructor(raw) {
            this.raw = raw;
        }
        get ingress() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "ingress"));
        }
        get egress() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "egress"));
        }
    }
    RTPReceiver.AncBurstReceiverMediaClock = AncBurstReceiverMediaClock;
    class AudioReceiverMediaSpecific {
        raw;
        type_identifier = "RTPReceiver::Data::AudioReceiver::MediaSpecific";
        constructor(raw) {
            this.raw = raw;
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lift.AudioCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lower.AudioCapabilities)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lift.AudioCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lower.AudioCapabilities)
            }, null);
        }
        get backend() {
            return new VScript.rKeyword(this, "backend", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lift.AudioBackend),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lower.AudioBackend)
            });
        }
        get flow_partitions() {
            return new VScript.rKeyword(this, "flow_partitions", {
                lift: VAPI.AT1101.RTPReceiver.lift.AudioReceiverMediaSpecificFlowPartitions,
                lower: VAPI.AT1101.RTPReceiver.lower.AudioReceiverMediaSpecificFlowPartitions
            });
        }
        get output() {
            return VAPI.AT1101.RTPReceiver.lift.AudioReceiverMediaSpecificOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "output"));
        }
    }
    RTPReceiver.AudioReceiverMediaSpecific = AudioReceiverMediaSpecific;
    class VideoReceiverMediaSpecific {
        raw;
        type_identifier = "RTPReceiver::Data::VideoReceiver::MediaSpecific";
        constructor(raw) {
            this.raw = raw;
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lift.VideoCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lower.VideoCapabilities)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lift.VideoCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lower.VideoCapabilities)
            }, null);
        }
        get backend() {
            return new VScript.rKeyword(this, "backend", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lift.VideoBackend),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1101.RTPReceiver.lower.VideoBackend)
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    audio_deembedder_errors: (x & 1) !== 0,
                    drop_repeat_frames: (x & 2) !== 0,
                    misaligned_anc_data: (x & 4) !== 0,
                    no_bbm_capabilities: (x & 8) !== 0,
                    video_decoding_errors: (x & 16) !== 0
                }),
                lower: (x, _) => ((x.audio_deembedder_errors ? 1 : 0) |
                    (x.drop_repeat_frames ? 2 : 0) |
                    (x.misaligned_anc_data ? 4 : 0) |
                    (x.no_bbm_capabilities ? 8 : 0) |
                    (x.video_decoding_errors ? 16 : 0))
            });
        }
        get error_counters() {
            return VAPI.RTPReceiver.lift.VideoReceiverMediaSpecificErrorCounters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "error_counters"));
        }
        get event_counters() {
            return VAPI.RTPReceiver.lift.VideoReceiverMediaSpecificEventCounters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "event_counters"));
        }
        /**
          Reset 2022-6 audio deembedder
        */
        get reset_audio_deembedder() {
            return new VScript.wKeyword(this, "reset_audio_deembedder", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get flow_partitions() {
            return new VScript.rKeyword(this, "flow_partitions", {
                lift: VAPI.AT1101.RTPReceiver.lift.VideoReceiverMediaSpecificFlowPartitions,
                lower: VAPI.AT1101.RTPReceiver.lower.VideoReceiverMediaSpecificFlowPartitions
            });
        }
        get output() {
            return VAPI.AT1101.RTPReceiver.lift.VideoReceiverMediaSpecificOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "output"));
        }
        /**
          when this is set to true, a timestamped CRC32 signature of every emitted
          video frame will be published via `signature`
        */
        get publish_signature() {
            return new VScript.rwKeyword(this, "publish_signature", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get timestamped_signature() {
            return new VScript.rKeyword(this, "timestamped_signature", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lift.TimestampedSignature),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lower.TimestampedSignature)
            });
        }
        get hard_metadata_decoder() {
            return VAPI.RTPReceiver.lift.VideoReceiverMediaSpecificHardMetadataDecoder(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "hard_metadata_decoder"));
        }
        get soft_metadata_decoder() {
            return VAPI.RTPReceiver.lift.VideoReceiverMediaSpecificSoftMetadataDecoder(VScript.VAPIHelpers.subtree_child_checked(this.raw, 11, "soft_metadata_decoder"));
        }
        get soft_metadata_extractor() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 12, "soft_metadata_extractor"), (raw, _) => VAPI.AT1101.MetadataProcessor.lift.MetadataExtractor(raw));
        }
        /**
          Single video substreams pertaining to a quadlink UHD flow may be
          subscribed to independently, and used as separate 3G streams instead. By
          default, the resulting 3G video essences will be stripped of their
          substream attributes, which affects SDPs generated on retransmission, as
          well as 352 payloads. If you wish to retain original substream
          attributes, set this setting to `PropagateSubstreamAttribute` (but note
          that this setting only takes effect on readout).
        */
        get on_isolated_substream() {
            return new VScript.dKeyword(this, "on_isolated_substream", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        /**
          When non-null, this keyword holds decoder state as inferred from
          currently received streams, or as obtained from the underlying hardware
          decoder at runtime.
        */
        get cur_decoder_ws() {
            return new VScript.rKeyword(this, "cur_decoder_ws", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lift.SingleVideoDecoderWorkingSet),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lower.SingleVideoDecoderWorkingSet)
            });
        }
    }
    RTPReceiver.VideoReceiverMediaSpecific = VideoReceiverMediaSpecific;
    class AudioReceiverMediaSpecificOutput {
        raw;
        type_identifier = "RTPReceiver::Data::AudioReceiver::MediaSpecific::Output";
        constructor(raw) {
            this.raw = raw;
        }
        get audio() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "audio"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "ptp_traits"));
        }
    }
    RTPReceiver.AudioReceiverMediaSpecificOutput = AudioReceiverMediaSpecificOutput;
    class VideoReceiverMediaSpecificOutput {
        raw;
        type_identifier = "RTPReceiver::Data::VideoReceiver::MediaSpecific::Output";
        constructor(raw) {
            this.raw = raw;
        }
        get cc_channel() {
            return new VScript.dKeyword(this, "cc_channel", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        get video() {
            return VAPI.AT1101.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "video"));
        }
        get start_of_frame() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "start_of_frame"));
        }
        get cc() {
            return VAPI.Video.lift.ClosedCaption(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "cc"));
        }
        get deembedded_audio() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "deembedded_audio"), (raw, _) => VAPI.AT1101.Audio.lift.Essence(raw));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "ptp_traits"));
        }
    }
    RTPReceiver.VideoReceiverMediaSpecificOutput = VideoReceiverMediaSpecificOutput;
    class MediaReceiverPacketStreams {
        raw;
        type_identifier = "RTPReceiver::Data::MediaReceiver::PacketStreams";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          for every subflow index, the first entry to appear in this list
          represents its rear guard
        */
        get sdp_a() {
            return new VScript.rKeyword(this, "sdp_a", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AT1101.RTPReceiver.lift.AssociatedStream),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AT1101.RTPReceiver.lower.AssociatedStream)
            });
        }
        /**
          for every subflow index, the first entry to appear in this list
          represents its rear guard
        */
        get sdp_b() {
            return new VScript.rKeyword(this, "sdp_b", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AT1101.RTPReceiver.lift.AssociatedStream),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AT1101.RTPReceiver.lower.AssociatedStream)
            });
        }
    }
    RTPReceiver.MediaReceiverPacketStreams = MediaReceiverPacketStreams;
    class AllSettings {
        raw;
        type_identifier = "RTPReceiver::Data::All::Settings";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          if `clean_switching_policy` is set to `Tolerant`, packet rates and ST2042
          compression ratios may change across switching boundaries. This ensures
          interoperability between a wider range of transmitters but comes at a
          slight performance penalty, as the receiver first has to determine the
          current packet rate before a switch can be effected. When set to
          `Whatever`, impossible clean switching requests will silently be
          converted into patching operations. Please only use this option as a
          measure of last resort, if at all.
        */
        get clean_switching_policy() {
            return new VScript.rwKeyword(this, "clean_switching_policy", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          limits IGMP stream subscriptions such that there remains an esimated
          `reserved_bandwidth` % of headroom on every RTP port (non-media traffic
          such as PTP or JSON/WS is not taken into account)
        */
        get reserved_bandwidth() {
            return new VScript.rwKeyword(this, "reserved_bandwidth", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        get max_concurrent_mpacket_irq_boosts() {
            return new VScript.rwKeyword(this, "max_concurrent_mpacket_irq_boosts", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get concurrent_mpacket_irq_boosts() {
            return new VScript.rKeyword(this, "concurrent_mpacket_irq_boosts", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          set this to modern to have generated 2042-raw/2022-6 streams state their
          respective rtp clock rates
        */
        get sdp_format() {
            return new VScript.rwKeyword(this, "sdp_format", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          determines how SDP files entered into `sdp_a_command` or `sdp_b_command`
          translate into their respective `status` counterparts. If
          `sdp_generation` is set to `Verbatim`, accepted SDP files are copied to
          `status` unmodified, even if some or all of the media descriptions within
          could not be serviced due to resource exhaustion. If `sdp_generation` is
          set to `Semantic`, only operationally effective parts of the SDP will be
          emitted.
        */
        get sdp_generation() {
            return new VScript.rwKeyword(this, "sdp_generation", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get num_audio_reserve_receivers() {
            return new VScript.dKeyword(this, "num_audio_reserve_receivers", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get rx_error() {
            return VAPI.RTPReceiver.lift.CountableErrorHandler(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "rx_error"));
        }
        get mpacket_error() {
            return VAPI.RTPReceiver.lift.CountableErrorHandler(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "mpacket_error"));
        }
        get offset_2110_error() {
            return VAPI.RTPReceiver.lift.CountableErrorHandler(VScript.VAPIHelpers.subtree_child_checked(this.raw, 9, "offset_2110_error"));
        }
        get linenr_2110_error() {
            return VAPI.RTPReceiver.lift.CountableErrorHandler(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "linenr_2110_error"));
        }
        /**
          time after which countable error events (such as RX errors or m-packet
          errors) are automatically cleared. Error accumulators are left unchanged
          until cleared explicitly by the user
        */
        get error_signalling_timeout() {
            return new VScript.dKeyword(this, "error_signalling_timeout", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        /**
          TODO
        */
        get flight_permit_timeout() {
            return new VScript.dKeyword(this, "flight_permit_timeout", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        /**
          when in clean-switching mode (i.e., if `switch_time` is neither 0 nor 1),
          SDP writes to `current_target` are rejected, followed by an informational
          error message. Set `on_sdp_collision` to `RejectSilently` to suppress
          this error message.
        */
        get on_sdp_collision() {
            return new VScript.rwKeyword(this, "on_sdp_collision", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          some configuration attempts cannot be executed completely. For example, a
          session containing 3 audio receivers will not be able to service a
          connection request if the corresponding SDP contains 4 or more audio
          essences. In these cases, the receiver may either set up as many
          connections as possible and discard the rest (`BestEffort`), or refuse
          the configuration attempt and raise an error message instead (`Refuse`).
        */
        get exhaustion_policy() {
            return new VScript.rwKeyword(this, "exhaustion_policy", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get backend_liveness() {
            return VAPI.RTPReceiver.lift.CountableErrorHandler(VScript.VAPIHelpers.subtree_child_checked(this.raw, 15, "backend_liveness"));
        }
        get premature_read() {
            return VAPI.RTPReceiver.lift.CountableErrorHandler(VScript.VAPIHelpers.subtree_child_checked(this.raw, 16, "premature_read"));
        }
        /**
          Single video substreams pertaining to a quadlink UHD flow may be
          subscribed to independently, and used as separate 3G streams instead. By
          default, the resulting 3G video essences will be stripped of their
          substream attributes, which affects SDPs generated on retransmission, as
          well as 352 payloads. If you wish to retain original substream
          attributes, set this setting to `PropagateSubstreamAttribute` (but note
          that this setting only takes effect on readout).
        */
        get on_isolated_substream() {
            return new VScript.dKeyword(this, "on_isolated_substream", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get buffer_sizes() {
            return new VScript.dKeyword(this, "buffer_sizes", {
                lift: VAPI.AT1101.RTPReceiver.lift.BufferSizes,
                lower: VAPI.AT1101.RTPReceiver.lower.BufferSizes
            }, {
                lift: VAPI.AT1101.RTPReceiver.lift.BufferSizes,
                lower: VAPI.AT1101.RTPReceiver.lower.BufferSizes
            }, null);
        }
    }
    RTPReceiver.AllSettings = AllSettings;
    RTPReceiver.Enums = {
        BufferSize: ["UpTo4KiPackets", "UpTo8KiPackets", "UpTo16KiPackets", "UpTo32KiPackets", "UpTo64KiPackets"]
    };
})(RTPReceiver || (RTPReceiver = {}));
export var RTPTransmitter;
(function (RTPTransmitter) {
    RTPTransmitter.lift = {
        All: (_raw) => (new All(_raw)),
        AudioEncoder: (_raw) => (new AudioEncoder(_raw)),
        AudioEncoderStatus: (_raw) => (new AudioEncoderStatus(_raw)),
        AudioFlowReference: (_raw) => (new AudioFlowReference(_raw)),
        AudioStreamHardware: (_raw) => (new AudioStreamHardware(_raw)),
        AudioStreamer: (_raw) => (new AudioStreamer(_raw)),
        EncoderHWDataEncoderClassic: (_raw, _socket) => {
            return {
                tr: _raw[0],
                interlace: _raw[1],
                line_skip: _raw[2],
                bpm_mode: _raw[3],
                bits: _raw[4],
                enabled: _raw[5],
                out_ts_target: _raw[6],
                mpkt_wordcounter: _raw[7],
                vtotal: _raw[8],
                vstart: _raw[9],
                hactive: _raw[10],
                sts_select: _raw[11]
            };
        },
        EncoderHWData: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "EncoderClassic", value: VAPI.AT1101.RTPTransmitter.lift.EncoderHWDataEncoderClassic(_raw[1], _socket) };
                case 1: return { variant: "EncoderVC2", value: VAPI.AT1101.RTPTransmitter.lift.EncoderHWDataEncoderVC2(_raw[1], _socket) };
                case 2: return { variant: "EncoderJxsCodec", value: VAPI.AT1101.RTPTransmitter.lift.EncoderHWDataEncoderJxsCodec(_raw[1], _socket) };
            }
            ;
        },
        EncoderHWDataEncoderJxsCodec: (_raw, _socket) => {
            return {
                width: _raw[0] === null ? null : _raw[0],
                height: _raw[1] === null ? null : _raw[1],
                mode: _raw[2] === null ? null : _raw[2],
                budget_per_frame: _raw[3] === null ? null : _raw[3],
                vld: _raw[4] === null ? null : _raw[4],
                number_of_images: _raw[5] === null ? null : _raw[5],
                video_depth: _raw[6] === null ? null : _raw[6],
                play_mode: _raw[7] === null ? null : _raw[7],
                level_weights: _raw[8] === null ? null : _raw[8].map(el => el),
                profile: _raw[9] === null ? null : _raw[9]
            };
        },
        EncoderHWDataEncoderVC2: (_raw, _socket) => {
            return {
                interlace: _raw[0],
                enabled: _raw[1],
                is_uhd: _raw[2],
                target_bytes_per_slice: _raw[3],
                last_slice: _raw[4]
            };
        },
        FlowReference: (_raw) => (new FlowReference(_raw)),
        GroupOutput: (_raw) => (new GroupOutput(_raw)),
        HDRAudio: (_raw) => (new HDRAudio(_raw)),
        HDRGeneral: (_raw) => (new HDRGeneral(_raw)),
        HDRMipmap: (_raw) => (new HDRMipmap(_raw)),
        HDRVideo: (_raw) => (new HDRVideo(_raw)),
        HardwareStatus: (_raw) => (new HardwareStatus(_raw)),
        HeaderReference: (_raw) => (new HeaderReference(_raw)),
        LaneHeader: (_raw) => (new LaneHeader(_raw)),
        LaneStatistic: (_raw, _socket) => {
            return {
                reserved_tdm_output_bandwidth: _raw[0],
                max_tdm_output_bandwidth: _raw[1],
                reserved_bus_bandwidth: _raw[2],
                maxbus_bandwidth: _raw[3],
                fpga_lane_statistic: _raw[4] === null ? null : new VAPI.AT1101.NetworkInterfaces.LaneStatistics(VScript.VAPIHelpers.get_subtree(_socket, _raw[4]))
            };
        },
        MediaClock: (_raw) => (new MediaClock(_raw)),
        MediaClockControl: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "Timesource", value: VAPI.AT1101.RTPTransmitter.lift.MediaClockControlTimesource(_raw[1], _socket) };
                case 1: return { variant: "Propagate", value: VAPI.RTPTransmitter.lift.MediaClockControlPropagate(_raw[1], _socket) };
            }
            ;
        },
        MediaStreamer: (_raw) => (new MediaStreamer(_raw)),
        MediaStreamerVideo: (_raw) => (new MediaStreamerVideo(_raw)),
        MipMapOutput: (_raw) => (new MipMapOutput(_raw)),
        MipMapStreamHardware: (_raw) => (new MipMapStreamHardware(_raw)),
        MipMapStreamer: (_raw) => (new MipMapStreamer(_raw)),
        PortStatistic: (_raw) => (new PortStatistic(_raw)),
        ReStreamer: (_raw) => (new ReStreamer(_raw)),
        RouterEncoder: (_raw) => (new RouterEncoder(_raw)),
        RouterOutput: (_raw) => (new RouterOutput(_raw)),
        ST2110Settings: (_raw, _socket) => {
            return {
                packing_mode: _raw[0],
                add_st2110_40: _raw[1]
            };
        },
        Session: (_raw) => (new Session(_raw)),
        MediaClockControlTimesource: (_raw, _socket) => {
            return {
                t_src: _raw[0] === null ? null : new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, _raw[0]))
            };
        },
        VideoConfigurationContainer: (_raw) => (new VideoConfigurationContainer(_raw)),
        VideoFormat: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "ST2022_6", value: VAPI.RTPTransmitter.lift.ST20226Settings(_raw[1], _socket) };
                case 1: return { variant: "ST2110_20", value: VAPI.AT1101.RTPTransmitter.lift.ST2110Settings(_raw[1], _socket) };
                case 2: return { variant: "ST2042", value: VAPI.RTPTransmitter.lift.ST2042Settings(_raw[1], _socket) };
                case 3: return { variant: "JPEG_XS", value: VAPI.RTPTransmitter.lift.JpegXsSettings(_raw[1], _socket) };
            }
            ;
        },
        VideoStreamHardware: (_raw) => (new VideoStreamHardware(_raw)),
        VideoStreamer: (_raw) => (new VideoStreamer(_raw)),
        XbarEncoder: (_raw) => (new XbarEncoder(_raw)),
        AudioStreamHardwareAudioEncoder: (_raw) => (new AudioStreamHardwareAudioEncoder(_raw)),
        AudioEncoderError: (_raw) => (new AudioEncoderError(_raw)),
        RouterEncoderError: (_raw) => (new RouterEncoderError(_raw)),
        RouterOutputError: (_raw, _socket) => {
            return {
                queue_overflow: _raw[0],
                queue_full: _raw[1]
            };
        },
        GroupOutputHwCapability: (_raw, _socket) => {
            return {
                num_encoder: _raw[0]
            };
        },
        MipMapOutputHwCapability: (_raw, _socket) => {
            return {
                num_encoder: _raw[0]
            };
        },
        RouterOutputHwCapability: (_raw, _socket) => {
            return {
                num_encoder: _raw[0]
            };
        },
        PortStatisticInterfaces: (_raw) => (new PortStatisticInterfaces(_raw)),
        PortStatisticLane: (_raw) => (new PortStatisticLane(_raw)),
        MipMapStreamHardwareRouterEncoder: (_raw) => (new MipMapStreamHardwareRouterEncoder(_raw)),
        VideoStreamHardwareRouterEncoder: (_raw) => (new VideoStreamHardwareRouterEncoder(_raw)),
        VideoStreamHardwareXbarEncoder: (_raw) => (new VideoStreamHardwareXbarEncoder(_raw)),
    };
    RTPTransmitter.lower = {
        All: (_x) => _x.raw.kwl,
        AudioEncoder: (_x) => _x.raw.kwl,
        AudioEncoderStatus: (_x) => _x.raw.kwl,
        AudioFlowReference: (_x) => _x.raw.kwl,
        AudioStreamHardware: (_x) => _x.raw.kwl,
        AudioStreamer: (_x) => _x.raw.kwl,
        EncoderHWDataEncoderClassic: (_x, _socket) => [
            _x.tr,
            _x.interlace,
            _x.line_skip,
            _x.bpm_mode,
            _x.bits,
            _x.enabled,
            _x.out_ts_target,
            _x.mpkt_wordcounter,
            _x.vtotal,
            _x.vstart,
            _x.hactive,
            _x.sts_select
        ],
        EncoderHWData: (_x, _socket) => {
            switch (_x.variant) {
                case "EncoderClassic": return [0, VAPI.AT1101.RTPTransmitter.lower.EncoderHWDataEncoderClassic(_x.value, _socket)];
                case "EncoderVC2": return [1, VAPI.AT1101.RTPTransmitter.lower.EncoderHWDataEncoderVC2(_x.value, _socket)];
                case "EncoderJxsCodec": return [2, VAPI.AT1101.RTPTransmitter.lower.EncoderHWDataEncoderJxsCodec(_x.value, _socket)];
            }
        },
        EncoderHWDataEncoderJxsCodec: (_x, _socket) => [
            _x.width === null ? null : _x.width,
            _x.height === null ? null : _x.height,
            _x.mode === null ? null : _x.mode,
            _x.budget_per_frame === null ? null : _x.budget_per_frame,
            _x.vld === null ? null : _x.vld,
            _x.number_of_images === null ? null : _x.number_of_images,
            _x.video_depth === null ? null : _x.video_depth,
            _x.play_mode === null ? null : _x.play_mode,
            _x.level_weights === null ? null : _x.level_weights.map(el => el),
            _x.profile === null ? null : _x.profile
        ],
        EncoderHWDataEncoderVC2: (_x, _socket) => [
            _x.interlace,
            _x.enabled,
            _x.is_uhd,
            _x.target_bytes_per_slice,
            _x.last_slice
        ],
        FlowReference: (_x) => _x.raw.kwl,
        GroupOutput: (_x) => _x.raw.kwl,
        HDRAudio: (_x) => _x.raw.kwl,
        HDRGeneral: (_x) => _x.raw.kwl,
        HDRMipmap: (_x) => _x.raw.kwl,
        HDRVideo: (_x) => _x.raw.kwl,
        HardwareStatus: (_x) => _x.raw.kwl,
        HeaderReference: (_x) => _x.raw.kwl,
        LaneHeader: (_x) => _x.raw.kwl,
        LaneStatistic: (_x, _socket) => [
            _x.reserved_tdm_output_bandwidth,
            _x.max_tdm_output_bandwidth,
            _x.reserved_bus_bandwidth,
            _x.maxbus_bandwidth,
            _x.fpga_lane_statistic === null ? null : _x.fpga_lane_statistic.raw.kwl
        ],
        MediaClock: (_x) => _x.raw.kwl,
        MediaClockControl: (_x, _socket) => {
            switch (_x.variant) {
                case "Timesource": return [0, VAPI.AT1101.RTPTransmitter.lower.MediaClockControlTimesource(_x.value, _socket)];
                case "Propagate": return [1, VAPI.RTPTransmitter.lower.MediaClockControlPropagate(_x.value, _socket)];
            }
        },
        MediaStreamer: (_x) => _x.raw.kwl,
        MediaStreamerVideo: (_x) => _x.raw.kwl,
        MipMapOutput: (_x) => _x.raw.kwl,
        MipMapStreamHardware: (_x) => _x.raw.kwl,
        MipMapStreamer: (_x) => _x.raw.kwl,
        PortStatistic: (_x) => _x.raw.kwl,
        ReStreamer: (_x) => _x.raw.kwl,
        RouterEncoder: (_x) => _x.raw.kwl,
        RouterOutput: (_x) => _x.raw.kwl,
        ST2110Settings: (_x, _socket) => [
            _x.packing_mode,
            _x.add_st2110_40
        ],
        Session: (_x) => _x.raw.kwl,
        MediaClockControlTimesource: (_x, _socket) => [
            _x.t_src === null ? null : _x.t_src.raw.kwl
        ],
        VideoConfigurationContainer: (_x) => _x.raw.kwl,
        VideoFormat: (_x, _socket) => {
            switch (_x.variant) {
                case "ST2022_6": return [0, VAPI.RTPTransmitter.lower.ST20226Settings(_x.value, _socket)];
                case "ST2110_20": return [1, VAPI.AT1101.RTPTransmitter.lower.ST2110Settings(_x.value, _socket)];
                case "ST2042": return [2, VAPI.RTPTransmitter.lower.ST2042Settings(_x.value, _socket)];
                case "JPEG_XS": return [3, VAPI.RTPTransmitter.lower.JpegXsSettings(_x.value, _socket)];
            }
        },
        VideoStreamHardware: (_x) => _x.raw.kwl,
        VideoStreamer: (_x) => _x.raw.kwl,
        XbarEncoder: (_x) => _x.raw.kwl,
        AudioStreamHardwareAudioEncoder: (_x) => _x.raw.kwl,
        AudioEncoderError: (_x) => _x.raw.kwl,
        RouterEncoderError: (_x) => _x.raw.kwl,
        RouterOutputError: (_x, _socket) => [
            _x.queue_overflow,
            _x.queue_full
        ],
        GroupOutputHwCapability: (_x, _socket) => [
            _x.num_encoder
        ],
        MipMapOutputHwCapability: (_x, _socket) => [
            _x.num_encoder
        ],
        RouterOutputHwCapability: (_x, _socket) => [
            _x.num_encoder
        ],
        PortStatisticInterfaces: (_x) => _x.raw.kwl,
        PortStatisticLane: (_x) => _x.raw.kwl,
        MipMapStreamHardwareRouterEncoder: (_x) => _x.raw.kwl,
        VideoStreamHardwareRouterEncoder: (_x) => _x.raw.kwl,
        VideoStreamHardwareXbarEncoder: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "RTPTransmitter::Data::All";
        get runtime_constants() {
            return {
                num_mipmaptransmitters: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_mipmaptransmitters"),
                num_transmitter_video_lane: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_transmitter_video_lane"),
                has_2042_uhd: this.raw.backing_store.get_runtime_constant("RTPTransmitter::has_2042_uhd"),
                num_hdr_flows: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_hdr_flows"),
                num_xbar_encoder: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_xbar_encoder"),
                num_ports: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_ports"),
                num_audio_group_control: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_audio_group_control"),
                max_st2110_20_uhd_transmitters: this.raw.backing_store.get_runtime_constant("RTPTransmitter::max_st2110_20_uhd_transmitters"),
                max_2042: this.raw.backing_store.get_runtime_constant("RTPTransmitter::max_2042"),
                has_2042: this.raw.backing_store.get_runtime_constant("RTPTransmitter::has_2042"),
                num_encoder_mux: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_encoder_mux"),
                num_videotransmitters: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_videotransmitters"),
                num_audiotransmitters: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_audiotransmitters"),
                max_2042_uhd: this.raw.backing_store.get_runtime_constant("RTPTransmitter::max_2042_uhd"),
                num_jpegxs: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_jpegxs"),
                num_transmitter_mipmap_lane: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_transmitter_mipmap_lane"),
                num_transmitter_audio_lane: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_transmitter_audio_lane"),
                num_hdr_flows_port: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_hdr_flows_port"),
                num_transmitters: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_transmitters"),
                num_passthroughtransmitters: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_passthroughtransmitters")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get license_information() {
            return VAPI.RTPTransmitter.lift.AllLicenseInformation(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "license_information"));
        }
        get hardware_status() {
            return VAPI.AT1101.RTPTransmitter.lift.HardwareStatus(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "hardware_status"));
        }
        get settings() {
            return VAPI.RTPTransmitter.lift.AllSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "settings"));
        }
        get sessions() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 3, "sessions"), (raw) => new VAPI.AT1101.RTPTransmitter.SessionAsNamedTableRow(raw));
        }
        get video_transmitters() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 4, "video_transmitters"), (raw) => new VAPI.AT1101.RTPTransmitter.VideoStreamerAsNamedTableRow(raw));
        }
        get audio_transmitters() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 5, "audio_transmitters"), (raw) => new VAPI.AT1101.RTPTransmitter.AudioStreamerAsNamedTableRow(raw));
        }
        get passthrough_transmitters() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 6, "passthrough_transmitters"), (raw) => new VAPI.AT1101.RTPTransmitter.ReStreamerAsNamedTableRow(raw));
        }
        get mipmap_transmitters() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 7, "mipmap_transmitters"), (raw, _) => VAPI.AT1101.RTPTransmitter.lift.MipMapStreamer(raw));
        }
    }
    RTPTransmitter.All = All;
    class AudioEncoder {
        raw;
        type_identifier = "RTPTransmitter::Data::AudioEncoder";
        constructor(raw) {
            this.raw = raw;
        }
        get allocated_blocks() {
            return new VScript.rKeyword(this, "allocated_blocks", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get block_addr() {
            return new VScript.rKeyword(this, "block_addr", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
            });
        }
        get last_sample() {
            return new VScript.rKeyword(this, "last_sample", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get write_disabled() {
            return new VScript.rKeyword(this, "write_disabled", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get mode() {
            return new VScript.rKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get header_fifo_select() {
            return new VScript.rKeyword(this, "header_fifo_select", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get sequence_number() {
            return new VScript.rKeyword(this, "sequence_number", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get error() {
            return VAPI.AT1101.RTPTransmitter.lift.AudioEncoderError(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "error"));
        }
    }
    RTPTransmitter.AudioEncoder = AudioEncoder;
    class AudioEncoderStatus {
        raw;
        type_identifier = "RTPTransmitter::Data::AudioEncoderStatus";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          reference to router encoder hardware
        */
        get wrapped_reference_encoder() {
            return new VScript.rKeyword(this, "wrapped_reference_encoder", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPTransmitter.HDRAudio(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        /**
          reference to group control hardware
        */
        get wrapped_reference_group_control() {
            return new VScript.rKeyword(this, "wrapped_reference_group_control", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.RTPTransmitter.AudioGroupControl(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPTransmitter.AudioEncoderStatus = AudioEncoderStatus;
    class AudioFlowReference {
        raw;
        type_identifier = "RTPTransmitter::Data::AudioFlowReference";
        constructor(raw) {
            this.raw = raw;
        }
        get hdr_ref() {
            return new VScript.rKeyword(this, "hdr_ref", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPTransmitter.HDRAudio(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get hdr_index() {
            return new VScript.rKeyword(this, "hdr_index", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get hdr_port() {
            return new VScript.rKeyword(this, "hdr_port", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
    }
    RTPTransmitter.AudioFlowReference = AudioFlowReference;
    class AudioStreamHardware {
        raw;
        type_identifier = "RTPTransmitter::Data::AudioStreamHardware";
        constructor(raw) {
            this.raw = raw;
        }
        get possible_sps_source() {
            return new VScript.rKeyword(this, "possible_sps_source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get group_control_status() {
            return VAPI.RTPTransmitter.lift.AudioGroupControlStatus(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "group_control_status"));
        }
        get audio_encoder() {
            return VAPI.AT1101.RTPTransmitter.lift.AudioStreamHardwareAudioEncoder(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "audio_encoder"));
        }
    }
    RTPTransmitter.AudioStreamHardware = AudioStreamHardware;
    class AudioStreamer {
        raw;
        type_identifier = "RTPTransmitter::Data::AudioStreamer";
        constructor(raw) {
            this.raw = raw;
        }
        get generic() {
            return VAPI.AT1101.RTPTransmitter.lift.MediaStreamer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "generic"));
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VAPI.AT1101.Audio.lift.TimedSource,
                lower: VAPI.AT1101.Audio.lower.TimedSource
            }, {
                lift: VAPI.AT1101.Audio.lift.TimedSource,
                lower: VAPI.AT1101.Audio.lower.TimedSource
            }, null);
        }
        get configuration() {
            return VAPI.RTPTransmitter.lift.AudioConfigurationContainer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "configuration"));
        }
        get stream_name() {
            return VAPI.Definitions.lift.NAME(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "stream_name"));
        }
        get connected_hardware() {
            return VAPI.AT1101.RTPTransmitter.lift.AudioStreamHardware(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "connected_hardware"));
        }
    }
    RTPTransmitter.AudioStreamer = AudioStreamer;
    class AudioStreamerAsNamedTableRow extends AudioStreamer {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPTransmitter.AudioStreamerAsNamedTableRow = AudioStreamerAsNamedTableRow;
    class FlowReference {
        raw;
        type_identifier = "RTPTransmitter::Data::FlowReference";
        constructor(raw) {
            this.raw = raw;
        }
        get hdr_ref() {
            return new VScript.rKeyword(this, "hdr_ref", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPTransmitter.HDRVideo(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get hdr_index() {
            return new VScript.rKeyword(this, "hdr_index", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
    }
    RTPTransmitter.FlowReference = FlowReference;
    class GroupOutput {
        raw;
        type_identifier = "RTPTransmitter::Data::GroupOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get traffic_shaper_interval() {
            return new VScript.rKeyword(this, "traffic_shaper_interval", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
            });
        }
        get hw_capability() {
            return new VScript.rKeyword(this, "hw_capability", {
                lift: VAPI.AT1101.RTPTransmitter.lift.GroupOutputHwCapability,
                lower: VAPI.AT1101.RTPTransmitter.lower.GroupOutputHwCapability
            });
        }
        get group_control_encoder_header() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "group_control_encoder_header"), (raw, _) => VAPI.AT1101.RTPTransmitter.lift.HDRAudio(raw));
        }
    }
    RTPTransmitter.GroupOutput = GroupOutput;
    class HDRAudio {
        raw;
        type_identifier = "RTPTransmitter::Data::HDRAudio";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_port_bandwidth() {
            return new VScript.rKeyword(this, "reserved_port_bandwidth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get related_references() {
            return VAPI.AT1101.RTPTransmitter.lift.HeaderReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "related_references"));
        }
        get audio_encoder_hw() {
            return VAPI.AT1101.RTPTransmitter.lift.AudioEncoder(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "audio_encoder_hw"));
        }
    }
    RTPTransmitter.HDRAudio = HDRAudio;
    class HDRGeneral {
        raw;
        type_identifier = "RTPTransmitter::Data::HDRGeneral";
        constructor(raw) {
            this.raw = raw;
        }
        get audio() {
            return VAPI.AT1101.RTPTransmitter.lift.HDRAudio(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "audio"));
        }
        get video() {
            return VAPI.AT1101.RTPTransmitter.lift.HDRVideo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "video"));
        }
        get mipmap() {
            return VAPI.AT1101.RTPTransmitter.lift.HDRMipmap(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "mipmap"));
        }
    }
    RTPTransmitter.HDRGeneral = HDRGeneral;
    class HDRMipmap {
        raw;
        type_identifier = "RTPTransmitter::Data::HDRMipmap";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_port_bandwidth() {
            return new VScript.rKeyword(this, "reserved_port_bandwidth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get related_references() {
            return VAPI.AT1101.RTPTransmitter.lift.HeaderReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "related_references"));
        }
        get mipmap_encoder_hw() {
            return VAPI.RTPTransmitter.lift.MipMapEncoder(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "mipmap_encoder_hw"));
        }
    }
    RTPTransmitter.HDRMipmap = HDRMipmap;
    class HDRVideo {
        raw;
        type_identifier = "RTPTransmitter::Data::HDRVideo";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_tdm_output_bandwidth() {
            return new VScript.rKeyword(this, "reserved_tdm_output_bandwidth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_bandwidth() {
            return new VScript.rKeyword(this, "reserved_bandwidth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_port_bandwidth() {
            return new VScript.rKeyword(this, "reserved_port_bandwidth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get related_references() {
            return VAPI.AT1101.RTPTransmitter.lift.HeaderReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "related_references"));
        }
        get router_encoder_hw() {
            return VAPI.AT1101.RTPTransmitter.lift.RouterEncoder(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "router_encoder_hw"));
        }
    }
    RTPTransmitter.HDRVideo = HDRVideo;
    class HardwareStatus {
        raw;
        type_identifier = "RTPTransmitter::Data::HardwareStatus";
        constructor(raw) {
            this.raw = raw;
        }
        get lane() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 0, "lane"), (st, _) => VAPI.AT1101.RTPTransmitter.lift.LaneHeader(st));
        }
        get ports() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "ports"), (raw, _) => VAPI.AT1101.RTPTransmitter.lift.PortStatistic(raw));
        }
        get xbar_encoder() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "xbar_encoder"), (raw, _) => VAPI.AT1101.RTPTransmitter.lift.XbarEncoder(raw));
        }
        get router_error() {
            return VAPI.RTPTransmitter.lift.RouterError(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "router_error"));
        }
        get audio_tx_group_control() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "audio_tx_group_control"), (raw, _) => VAPI.RTPTransmitter.lift.AudioGroupControl(raw));
        }
    }
    RTPTransmitter.HardwareStatus = HardwareStatus;
    class HeaderReference {
        raw;
        type_identifier = "RTPTransmitter::Data::HeaderReference";
        constructor(raw) {
            this.raw = raw;
        }
        get tx_stream_counter() {
            return new VScript.rKeyword(this, "tx_stream_counter", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1101.NetworkInterfaces.LaneStatistics(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "tx_streams", {
                    lift: VAPI.EthernetStats.lift.Counter,
                    lower: VAPI.EthernetStats.lower.Counter
                })),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference())
            });
        }
    }
    RTPTransmitter.HeaderReference = HeaderReference;
    class LaneHeader {
        raw;
        type_identifier = "RTPTransmitter::Data::LaneHeader";
        constructor(raw) {
            this.raw = raw;
        }
        get statistic() {
            return new VScript.rKeyword(this, "statistic", {
                lift: VAPI.AT1101.RTPTransmitter.lift.LaneStatistic,
                lower: VAPI.AT1101.RTPTransmitter.lower.LaneStatistic
            });
        }
        get video() {
            return VAPI.AT1101.RTPTransmitter.lift.RouterOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "video"));
        }
        get audio() {
            return VAPI.AT1101.RTPTransmitter.lift.GroupOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "audio"));
        }
        get mipmap() {
            return VAPI.AT1101.RTPTransmitter.lift.MipMapOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "mipmap"));
        }
    }
    RTPTransmitter.LaneHeader = LaneHeader;
    class MediaClock {
        raw;
        type_identifier = "RTPTransmitter::Data::MediaClock";
        constructor(raw) {
            this.raw = raw;
        }
        get clock_mode() {
            return new VScript.dKeyword(this, "clock_mode", {
                lift: VAPI.AT1101.RTPTransmitter.lift.MediaClockControl,
                lower: VAPI.AT1101.RTPTransmitter.lower.MediaClockControl
            }, {
                lift: VAPI.AT1101.RTPTransmitter.lift.MediaClockControl,
                lower: VAPI.AT1101.RTPTransmitter.lower.MediaClockControl
            }, null);
        }
        get offset() {
            return new VScript.dKeyword(this, "offset", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get latch_control() {
            return VAPI.Definitions.lift.LatchControl(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "latch_control"));
        }
        get latched_timestamp() {
            return new VScript.rKeyword(this, "latched_timestamp", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            });
        }
        get hw_latched_timestamp() {
            return new VScript.rKeyword(this, "hw_latched_timestamp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    RTPTransmitter.MediaClock = MediaClock;
    class MediaStreamer {
        raw;
        type_identifier = "RTPTransmitter::Data::MediaStreamer";
        constructor(raw) {
            this.raw = raw;
        }
        get hosting_session() {
            return new VScript.dKeyword(this, "hosting_session", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPTransmitter.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPTransmitter.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get mediaclock() {
            return VAPI.AT1101.RTPTransmitter.lift.MediaClock(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "mediaclock"));
        }
        get ip_configuration() {
            return VAPI.RTPTransmitter.lift.MediaStreamerIpConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "ip_configuration"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    missmatching_dst_and_src_ip_class: (x & 1) !== 0
                }),
                lower: (x, _) => ((x.missmatching_dst_and_src_ip_class ? 1 : 0))
            });
        }
    }
    RTPTransmitter.MediaStreamer = MediaStreamer;
    class MediaStreamerVideo {
        raw;
        type_identifier = "RTPTransmitter::Data::MediaStreamerVideo";
        constructor(raw) {
            this.raw = raw;
        }
        get hosting_session() {
            return new VScript.dKeyword(this, "hosting_session", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPTransmitter.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPTransmitter.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get mediaclock() {
            return VAPI.AT1101.RTPTransmitter.lift.MediaClock(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "mediaclock"));
        }
        get ip_configuration() {
            return VAPI.RTPTransmitter.lift.MediaStreamerVideoIpConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "ip_configuration"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    missing_input_dt_node: (x & 1) !== 0,
                    missmatching_dst_and_src_ip_class: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.missing_input_dt_node ? 1 : 0) |
                    (x.missmatching_dst_and_src_ip_class ? 2 : 0))
            });
        }
    }
    RTPTransmitter.MediaStreamerVideo = MediaStreamerVideo;
    class MipMapOutput {
        raw;
        type_identifier = "RTPTransmitter::Data::MipMapOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get hw_capability() {
            return new VScript.rKeyword(this, "hw_capability", {
                lift: VAPI.AT1101.RTPTransmitter.lift.MipMapOutputHwCapability,
                lower: VAPI.AT1101.RTPTransmitter.lower.MipMapOutputHwCapability
            });
        }
        get mipmap_encoder_header() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "mipmap_encoder_header"), (raw, _) => VAPI.AT1101.RTPTransmitter.lift.HDRMipmap(raw));
        }
    }
    RTPTransmitter.MipMapOutput = MipMapOutput;
    class MipMapStreamHardware {
        raw;
        type_identifier = "RTPTransmitter::Data::MipMapStreamHardware";
        constructor(raw) {
            this.raw = raw;
        }
        get router_encoder() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "router_encoder"), (raw, _) => VAPI.AT1101.RTPTransmitter.lift.MipMapStreamHardwareRouterEncoder(raw));
        }
    }
    RTPTransmitter.MipMapStreamHardware = MipMapStreamHardware;
    class MipMapStreamer {
        raw;
        type_identifier = "RTPTransmitter::Data::MipMapStreamer";
        constructor(raw) {
            this.raw = raw;
        }
        get ip_configuration() {
            return VAPI.RTPTransmitter.lift.MipMapStreamerIpConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "ip_configuration"));
        }
        get stream_name() {
            return VAPI.Definitions.lift.NAME(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "stream_name"));
        }
        get connected_hardware() {
            return VAPI.AT1101.RTPTransmitter.lift.MipMapStreamHardware(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "connected_hardware"));
        }
    }
    RTPTransmitter.MipMapStreamer = MipMapStreamer;
    class PortStatistic {
        raw;
        type_identifier = "RTPTransmitter::Data::PortStatistic";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_output_bandwidth() {
            return new VScript.rKeyword(this, "reserved_output_bandwidth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          maximum throughput (per direction), measured in bits/second
        */
        get max_throughput() {
            return new VScript.rKeyword(this, "max_throughput", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get interfaces() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "interfaces"), (raw, _) => VAPI.AT1101.RTPTransmitter.lift.PortStatisticInterfaces(raw));
        }
        get lane() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 3, "lane"), (raw, _) => VAPI.AT1101.RTPTransmitter.lift.PortStatisticLane(raw));
        }
    }
    RTPTransmitter.PortStatistic = PortStatistic;
    class ReStreamer {
        raw;
        type_identifier = "RTPTransmitter::Data::ReStreamer";
        constructor(raw) {
            this.raw = raw;
        }
        get fill_it_up() {
            return new VScript.rKeyword(this, "fill_it_up", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get generic() {
            return VAPI.AT1101.RTPTransmitter.lift.MediaStreamer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "generic"));
        }
    }
    RTPTransmitter.ReStreamer = ReStreamer;
    class ReStreamerAsNamedTableRow extends ReStreamer {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPTransmitter.ReStreamerAsNamedTableRow = ReStreamerAsNamedTableRow;
    class RouterEncoder {
        raw;
        type_identifier = "RTPTransmitter::Data::RouterEncoder";
        constructor(raw) {
            this.raw = raw;
        }
        get allocated_blocks() {
            return new VScript.rKeyword(this, "allocated_blocks", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get block_addr() {
            return new VScript.rKeyword(this, "block_addr", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
            });
        }
        get sequence_number() {
            return new VScript.rKeyword(this, "sequence_number", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get sequence_add_eol() {
            return new VScript.rKeyword(this, "sequence_add_eol", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get no_m_packet() {
            return new VScript.rKeyword(this, "no_m_packet", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get timestamp_offset() {
            return new VScript.rKeyword(this, "timestamp_offset", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get error() {
            return VAPI.AT1101.RTPTransmitter.lift.RouterEncoderError(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "error"));
        }
    }
    RTPTransmitter.RouterEncoder = RouterEncoder;
    class RouterOutput {
        raw;
        type_identifier = "RTPTransmitter::Data::RouterOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get error() {
            return new VScript.rKeyword(this, "error", {
                lift: VAPI.AT1101.RTPTransmitter.lift.RouterOutputError,
                lower: VAPI.AT1101.RTPTransmitter.lower.RouterOutputError
            });
        }
        get hw_capability() {
            return new VScript.rKeyword(this, "hw_capability", {
                lift: VAPI.AT1101.RTPTransmitter.lift.RouterOutputHwCapability,
                lower: VAPI.AT1101.RTPTransmitter.lower.RouterOutputHwCapability
            });
        }
        get router_encoder_header() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "router_encoder_header"), (raw, _) => VAPI.AT1101.RTPTransmitter.lift.HDRVideo(raw));
        }
    }
    RTPTransmitter.RouterOutput = RouterOutput;
    class Session {
        raw;
        type_identifier = "RTPTransmitter::Data::Session";
        constructor(raw) {
            this.raw = raw;
        }
        get active() {
            return new VScript.dKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get reserve_resources() {
            return new VScript.dKeyword(this, "reserve_resources", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get sdp_a() {
            return new VScript.rKeyword(this, "sdp_a", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get session_name() {
            return VAPI.Definitions.lift.NAME(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "session_name"));
        }
        get video_transmitters() {
            return new VScript.rKeyword(this, "video_transmitters", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPTransmitter.VideoStreamer(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get audio_transmitters() {
            return new VScript.rKeyword(this, "audio_transmitters", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPTransmitter.AudioStreamer(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get passthrough_transmitters() {
            return new VScript.rKeyword(this, "passthrough_transmitters", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPTransmitter.ReStreamer(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get mipmap_transmitters() {
            return new VScript.rKeyword(this, "mipmap_transmitters", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPTransmitter.MipMapStreamer(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get interfaces() {
            return new VScript.dKeyword(this, "interfaces", {
                lift: VAPI.RTPTransmitter.lift.SessionInterfaces,
                lower: VAPI.RTPTransmitter.lower.SessionInterfaces
            }, {
                lift: VAPI.RTPTransmitter.lift.SessionInterfaces,
                lower: VAPI.RTPTransmitter.lower.SessionInterfaces
            }, null);
        }
    }
    RTPTransmitter.Session = Session;
    class SessionAsNamedTableRow extends Session {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPTransmitter.SessionAsNamedTableRow = SessionAsNamedTableRow;
    class VideoConfigurationContainer {
        raw;
        type_identifier = "RTPTransmitter::Data::VideoConfigurationContainer";
        constructor(raw) {
            this.raw = raw;
        }
        get transport_format() {
            return new VScript.dKeyword(this, "transport_format", {
                lift: VAPI.AT1101.RTPTransmitter.lift.VideoFormat,
                lower: VAPI.AT1101.RTPTransmitter.lower.VideoFormat
            }, {
                lift: VAPI.AT1101.RTPTransmitter.lift.VideoFormat,
                lower: VAPI.AT1101.RTPTransmitter.lower.VideoFormat
            }, null);
        }
        get vanc() {
            return VAPI.AT1101.Definitions.lift.VancControl(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "vanc"));
        }
        get embedded_audio() {
            return new VScript.dKeyword(this, "embedded_audio", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftMaybeSparseArray((x /* FIXME */, _) => x),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VAPI.AT1101.Audio.lift.TimedSource,
                lower: VAPI.AT1101.Audio.lower.TimedSource
            }, {
                lift: VAPI.AT1101.Audio.lift.TimedSource,
                lower: VAPI.AT1101.Audio.lower.TimedSource
            }, null);
        }
    }
    RTPTransmitter.VideoConfigurationContainer = VideoConfigurationContainer;
    class VideoStreamHardware {
        raw;
        type_identifier = "RTPTransmitter::Data::VideoStreamHardware";
        constructor(raw) {
            this.raw = raw;
        }
        get xbar_encoder() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "xbar_encoder"), (raw, _) => VAPI.AT1101.RTPTransmitter.lift.VideoStreamHardwareXbarEncoder(raw));
        }
        get router_encoder() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "router_encoder"), (raw, _) => VAPI.AT1101.RTPTransmitter.lift.VideoStreamHardwareRouterEncoder(raw));
        }
    }
    RTPTransmitter.VideoStreamHardware = VideoStreamHardware;
    class VideoStreamer {
        raw;
        type_identifier = "RTPTransmitter::Data::VideoStreamer";
        constructor(raw) {
            this.raw = raw;
        }
        get generic() {
            return VAPI.AT1101.RTPTransmitter.lift.MediaStreamerVideo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "generic"));
        }
        get constraints() {
            return VAPI.RTPTransmitter.lift.Constraints(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "constraints"));
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VAPI.AT1101.Video.lift.TimedSource,
                lower: VAPI.AT1101.Video.lower.TimedSource
            }, {
                lift: VAPI.AT1101.Video.lift.TimedSource,
                lower: VAPI.AT1101.Video.lower.TimedSource
            }, null);
        }
        get configuration() {
            return VAPI.AT1101.RTPTransmitter.lift.VideoConfigurationContainer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "configuration"));
        }
        get stream_name() {
            return VAPI.Definitions.lift.NAME(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "stream_name"));
        }
        get connected_hardware() {
            return VAPI.AT1101.RTPTransmitter.lift.VideoStreamHardware(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "connected_hardware"));
        }
    }
    RTPTransmitter.VideoStreamer = VideoStreamer;
    class VideoStreamerAsNamedTableRow extends VideoStreamer {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPTransmitter.VideoStreamerAsNamedTableRow = VideoStreamerAsNamedTableRow;
    class XbarEncoder {
        raw;
        type_identifier = "RTPTransmitter::Data::XbarEncoder";
        constructor(raw) {
            this.raw = raw;
        }
        get st2110_40_capable() {
            return new VScript.rKeyword(this, "st2110_40_capable", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get st2110_40_in_use() {
            return new VScript.rKeyword(this, "st2110_40_in_use", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get debug() {
            return new VScript.rKeyword(this, "debug", {
                lift: VAPI.AT1101.RTPTransmitter.lift.EncoderHWData,
                lower: VAPI.AT1101.RTPTransmitter.lower.EncoderHWData
            });
        }
    }
    RTPTransmitter.XbarEncoder = XbarEncoder;
    class AudioStreamHardwareAudioEncoder {
        raw;
        type_identifier = "RTPTransmitter::Data::AudioStreamHardware::AudioEncoder";
        constructor(raw) {
            this.raw = raw;
        }
        get primary() {
            return VAPI.AT1101.RTPTransmitter.lift.AudioEncoderStatus(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "primary"));
        }
        get secondary() {
            return VAPI.AT1101.RTPTransmitter.lift.AudioEncoderStatus(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "secondary"));
        }
    }
    RTPTransmitter.AudioStreamHardwareAudioEncoder = AudioStreamHardwareAudioEncoder;
    class AudioEncoderError {
        raw;
        type_identifier = "RTPTransmitter::Data::AudioEncoder::Error";
        constructor(raw) {
            this.raw = raw;
        }
        get queue_overflow() {
            return new VScript.rKeyword(this, "queue_overflow", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get queue_full() {
            return new VScript.rKeyword(this, "queue_full", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    RTPTransmitter.AudioEncoderError = AudioEncoderError;
    class RouterEncoderError {
        raw;
        type_identifier = "RTPTransmitter::Data::RouterEncoder::Error";
        constructor(raw) {
            this.raw = raw;
        }
        get queue_overflow() {
            return new VScript.rKeyword(this, "queue_overflow", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get queue_full() {
            return new VScript.rKeyword(this, "queue_full", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    RTPTransmitter.RouterEncoderError = RouterEncoderError;
    class PortStatisticInterfaces {
        raw;
        type_identifier = "RTPTransmitter::Data::PortStatistic::Interfaces";
        constructor(raw) {
            this.raw = raw;
        }
        get interface() {
            return new VScript.rKeyword(this, "interface", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.VirtualInterface(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPTransmitter.PortStatisticInterfaces = PortStatisticInterfaces;
    class PortStatisticLane {
        raw;
        type_identifier = "RTPTransmitter::Data::PortStatistic::Lane";
        constructor(raw) {
            this.raw = raw;
        }
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPTransmitter.LaneHeader(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPTransmitter.PortStatisticLane = PortStatisticLane;
    class MipMapStreamHardwareRouterEncoder {
        raw;
        type_identifier = "RTPTransmitter::Data::MipMapStreamHardware::RouterEncoder";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          reference to router encoder hardware
        */
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPTransmitter.HDRMipmap(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPTransmitter.MipMapStreamHardwareRouterEncoder = MipMapStreamHardwareRouterEncoder;
    class VideoStreamHardwareRouterEncoder {
        raw;
        type_identifier = "RTPTransmitter::Data::VideoStreamHardware::RouterEncoder";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          reference to router encoder hardware
        */
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPTransmitter.HDRVideo(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPTransmitter.VideoStreamHardwareRouterEncoder = VideoStreamHardwareRouterEncoder;
    class VideoStreamHardwareXbarEncoder {
        raw;
        type_identifier = "RTPTransmitter::Data::VideoStreamHardware::XbarEncoder";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          reference to xbar encoder hardware
        */
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.RTPTransmitter.XbarEncoder(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPTransmitter.VideoStreamHardwareXbarEncoder = VideoStreamHardwareXbarEncoder;
})(RTPTransmitter || (RTPTransmitter = {}));
export var RePlay;
(function (RePlay) {
    RePlay.lift = {
        All: (_raw) => (new All(_raw)),
    };
    RePlay.lower = { All: (_x) => _x.raw.kwl, };
    class All {
        raw;
        type_identifier = "RePlay::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get video() {
            return VAPI.AT1101.VideoRePlay.lift.Video(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "video"));
        }
        get audio() {
            return VAPI.AT1101.AudioRePlay.lift.Audio(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "audio"));
        }
    }
    RePlay.All = All;
})(RePlay || (RePlay = {}));
export var SampleRateConverter;
(function (SampleRateConverter) {
    SampleRateConverter.lift = {
        AUDIOSRCSTATUS: (_raw) => (new AUDIOSRCSTATUS(_raw)),
        All: (_raw) => (new All(_raw)),
        INPUTSTATUS: (_raw) => (new INPUTSTATUS(_raw)),
        RESOURCE: (_raw) => (new RESOURCE(_raw)),
        RESOURCES: (_raw) => (new RESOURCES(_raw)),
        SRC: (_raw) => (new SRC(_raw)),
        SRCHardware: (_raw) => (new SRCHardware(_raw)),
        Time: (_raw) => (new Time(_raw)),
        AUDIOSRCSTATUSHwSettings: (_raw) => (new AUDIOSRCSTATUSHwSettings(_raw)),
        SRCSettings: (_raw) => (new SRCSettings(_raw)),
    };
    SampleRateConverter.lower = {
        AUDIOSRCSTATUS: (_x) => _x.raw.kwl,
        All: (_x) => _x.raw.kwl,
        INPUTSTATUS: (_x) => _x.raw.kwl,
        RESOURCE: (_x) => _x.raw.kwl,
        RESOURCES: (_x) => _x.raw.kwl,
        SRC: (_x) => _x.raw.kwl,
        SRCHardware: (_x) => _x.raw.kwl,
        Time: (_x) => _x.raw.kwl,
        AUDIOSRCSTATUSHwSettings: (_x) => _x.raw.kwl,
        SRCSettings: (_x) => _x.raw.kwl,
    };
    class AUDIOSRCSTATUS {
        raw;
        type_identifier = "SampleRateConverter::Data::AUDIOSRCSTATUS";
        constructor(raw) {
            this.raw = raw;
        }
        get hw_settings() {
            return VAPI.AT1101.SampleRateConverter.lift.AUDIOSRCSTATUSHwSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "hw_settings"));
        }
        get hw_resource_mux() {
            return VAPI.AT1101.SampleRateConverter.lift.RESOURCE(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "hw_resource_mux"));
        }
    }
    SampleRateConverter.AUDIOSRCSTATUS = AUDIOSRCSTATUS;
    class All {
        raw;
        type_identifier = "SampleRateConverter::Data::All";
        get runtime_constants() {
            return {
                num_srcs: this.raw.backing_store.get_runtime_constant("SampleRateConverter::num_srcs"),
                num_src_inputs: this.raw.backing_store.get_runtime_constant("SampleRateConverter::num_src_inputs"),
                num_srcs_x24: this.raw.backing_store.get_runtime_constant("SampleRateConverter::num_srcs_x24")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get instances() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "instances"), (raw) => new VAPI.AT1101.SampleRateConverter.SRCAsNamedTableRow(raw));
        }
        get hardware_resources() {
            return VAPI.AT1101.SampleRateConverter.lift.RESOURCES(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "hardware_resources"));
        }
    }
    SampleRateConverter.All = All;
    class INPUTSTATUS {
        raw;
        type_identifier = "SampleRateConverter::Data::INPUTSTATUS";
        constructor(raw) {
            this.raw = raw;
        }
        get hw_value() {
            return new VScript.rKeyword(this, "hw_value", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          index of the selected input channel based on 64
        */
        get audio_src() {
            return new VScript.rKeyword(this, "audio_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get sop_src() {
            return new VScript.rKeyword(this, "sop_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get enable() {
            return new VScript.rKeyword(this, "enable", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
    }
    SampleRateConverter.INPUTSTATUS = INPUTSTATUS;
    class RESOURCE {
        raw;
        type_identifier = "SampleRateConverter::Data::RESOURCE";
        constructor(raw) {
            this.raw = raw;
        }
        get mux() {
            return VAPI.AT1101.SampleRateConverter.lift.INPUTSTATUS(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "mux"));
        }
        get read_status() {
            return VAPI.SampleRateConverter.lift.READSTATUS(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "read_status"));
        }
        get audio_source_slices() {
            return VAPI.Audio.lift.SignalSourceSlice(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "audio_source_slices"));
        }
        get related_mux() {
            return new VScript.rKeyword(this, "related_mux", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.SampleRateConverter.RESOURCE(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
    }
    SampleRateConverter.RESOURCE = RESOURCE;
    class RESOURCES {
        raw;
        type_identifier = "SampleRateConverter::Data::RESOURCES";
        constructor(raw) {
            this.raw = raw;
        }
        get hw_resource_x24() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "hw_resource_x24"), (raw, _) => VAPI.AT1101.SampleRateConverter.lift.AUDIOSRCSTATUS(raw));
        }
    }
    SampleRateConverter.RESOURCES = RESOURCES;
    class SRC {
        raw;
        type_identifier = "SampleRateConverter::Data::SRC";
        constructor(raw) {
            this.raw = raw;
        }
        get active() {
            return new VScript.dKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get settings() {
            return VAPI.AT1101.SampleRateConverter.lift.SRCSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "settings"));
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "output"));
        }
        get connected_hardware() {
            return VAPI.AT1101.SampleRateConverter.lift.SRCHardware(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "connected_hardware"));
        }
    }
    SampleRateConverter.SRC = SRC;
    class SRCAsNamedTableRow extends SRC {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    SampleRateConverter.SRCAsNamedTableRow = SRCAsNamedTableRow;
    class SRCHardware {
        raw;
        type_identifier = "SampleRateConverter::Data::SRCHardware";
        constructor(raw) {
            this.raw = raw;
        }
        get hw() {
            return new VScript.rKeyword(this, "hw", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.SampleRateConverter.AUDIOSRCSTATUS(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get hw_mux() {
            return new VScript.rKeyword(this, "hw_mux", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.SampleRateConverter.INPUTSTATUS(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
    }
    SampleRateConverter.SRCHardware = SRCHardware;
    class Time {
        raw;
        type_identifier = "SampleRateConverter::Data::Time";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
    }
    SampleRateConverter.Time = Time;
    class AUDIOSRCSTATUSHwSettings {
        raw;
        type_identifier = "SampleRateConverter::Data::AUDIOSRCSTATUS::HwSettings";
        constructor(raw) {
            this.raw = raw;
        }
        get pairs() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 0, "pairs"), (st, _) => VAPI.SampleRateConverter.lift.PAIRCOM(st));
        }
    }
    SampleRateConverter.AUDIOSRCSTATUSHwSettings = AUDIOSRCSTATUSHwSettings;
    class SRCSettings {
        raw;
        type_identifier = "SampleRateConverter::Data::SRC::Settings";
        constructor(raw) {
            this.raw = raw;
        }
        get channel_capacity() {
            return new VScript.dKeyword(this, "channel_capacity", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    SampleRateConverter.SRCSettings = SRCSettings;
})(SampleRateConverter || (SampleRateConverter = {}));
export var Splitter;
(function (Splitter) {
    Splitter.lift = {
        All: (_raw) => (new All(_raw)),
        SP: (_raw) => (new SP(_raw)),
        SPOutputs: (_raw) => (new SPOutputs(_raw)),
    };
    Splitter.lower = {
        All: (_x) => _x.raw.kwl,
        SP: (_x) => _x.raw.kwl,
        SPOutputs: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "Splitter::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get instances() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "instances"), (raw) => new VAPI.AT1101.Splitter.SPAsNamedTableRow(raw));
        }
    }
    Splitter.All = All;
    class SP {
        raw;
        type_identifier = "Splitter::Data::SP";
        constructor(raw) {
            this.raw = raw;
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get outputs() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "outputs"), (raw, _) => VAPI.AT1101.Splitter.lift.SPOutputs(raw));
        }
    }
    Splitter.SP = SP;
    class SPAsNamedTableRow extends SP {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    Splitter.SPAsNamedTableRow = SPAsNamedTableRow;
    class SPOutputs {
        raw;
        type_identifier = "Splitter::Data::SP::Outputs";
        constructor(raw) {
            this.raw = raw;
        }
        get output() {
            return VAPI.AT1101.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "output"));
        }
    }
    Splitter.SPOutputs = SPOutputs;
})(Splitter || (Splitter = {}));
export var System;
(function (System) {
    System.lift = {
        All: (_raw) => (new All(_raw)),
        InternalHW: (_raw) => (new InternalHW(_raw)),
        MEMORY: (_raw) => (new MEMORY(_raw)),
        Partitions: (_raw) => (new Partitions(_raw)),
        Power: (_raw) => (new Power(_raw)),
        Temperature: (_raw) => (new Temperature(_raw)),
        InternalHWSgmii: (_raw) => (new InternalHWSgmii(_raw)),
        AllSysinfo: (_raw) => (new AllSysinfo(_raw)),
    };
    System.lower = {
        All: (_x) => _x.raw.kwl,
        InternalHW: (_x) => _x.raw.kwl,
        MEMORY: (_x) => _x.raw.kwl,
        Partitions: (_x) => _x.raw.kwl,
        Power: (_x) => _x.raw.kwl,
        Temperature: (_x) => _x.raw.kwl,
        InternalHWSgmii: (_x) => _x.raw.kwl,
        AllSysinfo: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "System::Data::All";
        get runtime_constants() {
            return {
                is_udx: this.raw.backing_store.get_runtime_constant("System::is_udx"),
                is_no_pcap: this.raw.backing_store.get_runtime_constant("System::is_no_pcap"),
                is_multiviewer: this.raw.backing_store.get_runtime_constant("System::is_multiviewer"),
                is_j2kdecoder: this.raw.backing_store.get_runtime_constant("System::is_j2kdecoder"),
                has_replay: this.raw.backing_store.get_runtime_constant("System::has_replay"),
                has_audio_mixer: this.raw.backing_store.get_runtime_constant("System::has_audio_mixer"),
                has_color_correction: this.raw.backing_store.get_runtime_constant("System::has_color_correction"),
                has_video_mixer: this.raw.backing_store.get_runtime_constant("System::has_video_mixer"),
                has_audio_gain: this.raw.backing_store.get_runtime_constant("System::has_audio_gain"),
                supports_metadata_extraction: this.raw.backing_store.get_runtime_constant("System::supports_metadata_extraction"),
                is_pcap: this.raw.backing_store.get_runtime_constant("System::is_pcap"),
                has_passthrough_transmitters: this.raw.backing_store.get_runtime_constant("System::has_passthrough_transmitters"),
                is_jpegxs: this.raw.backing_store.get_runtime_constant("System::is_jpegxs")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get temperature() {
            return VAPI.AT1101.System.lift.Temperature(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "temperature"));
        }
        get power() {
            return VAPI.AT1101.System.lift.Power(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "power"));
        }
        get fan_speed() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "fan_speed"), (raw, _) => VAPI.System.lift.FanSpeed(raw));
        }
        get barebox_version() {
            return new VScript.rKeyword(this, "barebox_version", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get barebox_state() {
            return new VScript.rKeyword(this, "barebox_state", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get booted_partition() {
            return new VScript.rKeyword(this, "booted_partition", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get partitions() {
            return VAPI.AT1101.System.lift.Partitions(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "partitions"));
        }
        get watchdog_version() {
            return new VScript.rKeyword(this, "watchdog_version", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.System.lift.Revision),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.System.lower.Revision)
            });
        }
        get sysinfo() {
            return VAPI.AT1101.System.lift.AllSysinfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "sysinfo"));
        }
        get usrinfo() {
            return VAPI.System.lift.AllUsrinfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 9, "usrinfo"));
        }
        get neighborhood_watch() {
            return VAPI.System.lift.NeighborhoodWatch(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "neighborhood_watch"));
        }
        get psu() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 11, "psu"), (raw, _) => VAPI.System.lift.PSU(raw));
        }
        get qsfp() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 12, "qsfp"), (raw, _) => VAPI.System.lift.QSFP(raw));
        }
        get ecc() {
            return VAPI.System.lift.AllEcc(VScript.VAPIHelpers.subtree_child_checked(this.raw, 13, "ecc"));
        }
        get unique_id() {
            return new VScript.rKeyword(this, "unique_id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get fpga() {
            return VAPI.System.lift.CompileInfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 15, "fpga"));
        }
        get device() {
            return VAPI.System.lift.Device(VScript.VAPIHelpers.subtree_child_checked(this.raw, 16, "device"));
        }
        get io_board() {
            return VAPI.System.lift.AllIoBoard(VScript.VAPIHelpers.subtree_child_checked(this.raw, 17, "io_board"));
        }
        get fan_board() {
            return VAPI.System.lift.Device(VScript.VAPIHelpers.subtree_child_checked(this.raw, 18, "fan_board"));
        }
        get frame() {
            return VAPI.System.lift.Device(VScript.VAPIHelpers.subtree_child_checked(this.raw, 19, "frame"));
        }
        get memory() {
            return VAPI.AT1101.System.lift.MEMORY(VScript.VAPIHelpers.subtree_child_checked(this.raw, 20, "memory"));
        }
        get internal_hw() {
            return VAPI.AT1101.System.lift.InternalHW(VScript.VAPIHelpers.subtree_child_checked(this.raw, 21, "internal_hw"));
        }
        /**
          FPGA debug bus at last reboot
        */
        get previous_dbg_bus() {
            return new VScript.rKeyword(this, "previous_dbg_bus", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Watchdog event log - contains boot reason and times
        */
        get watchdog_event_log() {
            return new VScript.rKeyword(this, "watchdog_event_log", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get board_location() {
            return new VScript.rKeyword(this, "board_location", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get frontpanel_led_brightness() {
            return new VScript.rwKeyword(this, "frontpanel_led_brightness", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Blink the front panel LED in blue to help locating this blade
        */
        get frontpanel_blink_blue() {
            return new VScript.rwKeyword(this, "frontpanel_blink_blue", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get slots() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 27, "slots"), (raw, _) => VAPI.System.lift.SlotInformation(raw));
        }
        get services() {
            return VAPI.System.lift.AllServices(VScript.VAPIHelpers.subtree_child_checked(this.raw, 28, "services"));
        }
        /**
          Currently loaded FPGA
        */
        get selected_fpga() {
            return new VScript.rKeyword(this, "selected_fpga", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Change which FPGA to load on next reboot
        */
        get select_fpga() {
            return new VScript.dKeyword(this, "select_fpga", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        /**
          @brief Perform a reboot of the blade
          @desc Type in 'reboot' to reboot the current partition. Type in 'system0'
          or 'system1' to reboot to the respective partition.
        */
        get reboot() {
            return new VScript.rwKeyword(this, "reboot", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          @brief Perform a power cycle
          @desc Interrupt blade power for 3 seconds
        */
        get powercycle() {
            return new VScript.rwKeyword(this, "powercycle", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          @brief Reset NVRAM
          @desc Enter /reset/ to clear all settings and reboot
        */
        get reset() {
            return new VScript.rwKeyword(this, "reset", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get command_logging() {
            return VAPI.System.lift.AllCommandLogging(VScript.VAPIHelpers.subtree_child_checked(this.raw, 34, "command_logging"));
        }
        get nmos() {
            return VAPI.System.lift.AllNmos(VScript.VAPIHelpers.subtree_child_checked(this.raw, 35, "nmos"));
        }
    }
    System.All = All;
    class InternalHW {
        raw;
        type_identifier = "System::Data::InternalHW";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          Active PCIe lanes - should be 4
        */
        get pcie_lanes() {
            return new VScript.rKeyword(this, "pcie_lanes", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Active PCIe speed - should be GT_5_0
        */
        get pcie_speed() {
            return new VScript.rKeyword(this, "pcie_speed", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get sgmii() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 2, "sgmii"), (st, _) => VAPI.AT1101.System.lift.InternalHWSgmii(st));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    wrong_pcie_speed_or_lanecount: (x & 1) !== 0
                }),
                lower: (x, _) => ((x.wrong_pcie_speed_or_lanecount ? 1 : 0))
            });
        }
    }
    System.InternalHW = InternalHW;
    class MEMORY {
        raw;
        type_identifier = "System::Data::MEMORY";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          if RAM calibration failed and rebooting does not fix the issue, please
          contact customer support
        */
        get ram_sodimm1() {
            return new VScript.rKeyword(this, "ram_sodimm1", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          if RAM calibration failed and rebooting does not fix the issue, please
          contact customer support
        */
        get ram_sodimm2() {
            return new VScript.rKeyword(this, "ram_sodimm2", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          if RAM calibration failed and rebooting does not fix the issue, please
          contact customer support
        */
        get ram_u16() {
            return new VScript.rKeyword(this, "ram_u16", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          J101
        */
        get spd_sodimm1() {
            return VAPI.System.lift.SPD(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "spd_sodimm1"));
        }
        /**
          J111
        */
        get spd_sodimm2() {
            return VAPI.System.lift.SPD(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "spd_sodimm2"));
        }
        get spd_cpu() {
            return VAPI.System.lift.SPD(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "spd_cpu"));
        }
    }
    System.MEMORY = MEMORY;
    class Partitions {
        raw;
        type_identifier = "System::Data::Partitions";
        constructor(raw) {
            this.raw = raw;
        }
        get booted() {
            return new VScript.rKeyword(this, "booted", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.System.SWVersion(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get recovery() {
            return VAPI.System.lift.SWVersion(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "recovery"));
        }
        get system0() {
            return VAPI.System.lift.SWVersion(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "system0"));
        }
        get system1() {
            return VAPI.System.lift.SWVersion(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "system1"));
        }
    }
    System.Partitions = Partitions;
    class Power {
        raw;
        type_identifier = "System::Data::Power";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          Power usage for P0V95
        */
        get p0v95() {
            return new VScript.rKeyword(this, "p0v95", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Power usage for P1V1 and P1V2
        */
        get p1v1_1v2() {
            return new VScript.rKeyword(this, "p1v1_1v2", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Power usage for P1V8
        */
        get p1v8() {
            return new VScript.rKeyword(this, "p1v8", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
    }
    System.Power = Power;
    class Temperature {
        raw;
        type_identifier = "System::Data::Temperature";
        constructor(raw) {
            this.raw = raw;
        }
        get fpga_int() {
            return new VScript.rKeyword(this, "fpga_int", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get fpga_ext() {
            return new VScript.rKeyword(this, "fpga_ext", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get cpu() {
            return new VScript.rKeyword(this, "cpu", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get u21() {
            return new VScript.rKeyword(this, "u21", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get u22() {
            return new VScript.rKeyword(this, "u22", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Temperature of Fan-Controller (U24)
        */
        get fan_controller() {
            return new VScript.rKeyword(this, "fan_controller", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Temperature of U42
        */
        get p0v95_t1() {
            return new VScript.rKeyword(this, "p0v95_t1", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Temperature of U43
        */
        get p0v95_t2() {
            return new VScript.rKeyword(this, "p0v95_t2", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Temperature of U45
        */
        get p1v1_p1v2() {
            return new VScript.rKeyword(this, "p1v1_p1v2", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Temperature of U44
        */
        get p1v8() {
            return new VScript.rKeyword(this, "p1v8", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get ioboard() {
            return new VScript.rKeyword(this, "ioboard", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Temperature of FPGA-SODIMM 1 (J101)
        */
        get fpga_sodimm1() {
            return new VScript.rKeyword(this, "fpga_sodimm1", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Temperature of FPGA-SODIMM 2 (J111)
        */
        get fpga_sodimm2() {
            return new VScript.rKeyword(this, "fpga_sodimm2", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Temperature of CPU-SODIMM (J71)
        */
        get cpu_sodimm() {
            return new VScript.rKeyword(this, "cpu_sodimm", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Temperature of U2
        */
        get mgmt_phy() {
            return new VScript.rKeyword(this, "mgmt_phy", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          Total minutes spent at overtemperature, where overtemperature is defined
          as follows:
          
          `CPU`: 100 °C
          
          `CPU_SODIMM`: 75 °C
          
          `MGMT_PHY`: 125 °C
          
          `FPGA_SODIMM1`: 75 °C
          
          `FPGA_SODIMM2`: 75 °C
          
          `FAN_CONTROLLER`: 70 °C
          
          `FPGA_EXT`: 100 °C
          
          `FPGA_INT`: 105 °C
          
          `P0V95_T1`: 125 °C
          
          `P0V95_T2`: 125 °C
          
          `P1V1_P1V2` 125 °C
          
          `P1V8`: 125 °C
          
          `U21`: 85 °C
          
          `U22`: 70 °C
        */
        get accumulated_overtemperature_time() {
            return new VScript.rKeyword(this, "accumulated_overtemperature_time", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get current_fanspeed_profile() {
            return new VScript.rKeyword(this, "current_fanspeed_profile", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cpu_sodimm_temperature_above_critical: (x & 1) !== 0,
                    cpu_sodimm_temperature_high: (x & 2) !== 0,
                    cpu_temperature_above_critical: (x & 4) !== 0,
                    cpu_temperature_high: (x & 8) !== 0,
                    fan_controller_temperature_above_critical: (x & 16) !== 0,
                    fan_controller_temperature_high: (x & 32) !== 0,
                    fpga_ext_temperature_above_critical: (x & 64) !== 0,
                    fpga_ext_temperature_high: (x & 128) !== 0,
                    fpga_int_temperature_above_critical: (x & 256) !== 0,
                    fpga_int_temperature_high: (x & 512) !== 0,
                    fpga_sodimm1_temperature_above_critical: (x & 1024) !== 0,
                    fpga_sodimm1_temperature_high: (x & 2048) !== 0,
                    fpga_sodimm2_temperature_above_critical: (x & 4096) !== 0,
                    fpga_sodimm2_temperature_high: (x & 8192) !== 0,
                    ioboard_temperature_above_critical: (x & 16384) !== 0,
                    ioboard_temperature_high: (x & 32768) !== 0,
                    mgmt_phy_temperature_above_critical: (x & 65536) !== 0,
                    mgmt_phy_temperature_high: (x & 131072) !== 0,
                    missing_data: (x & 262144) !== 0,
                    p0v95_t1_temperature_above_critical: (x & 524288) !== 0,
                    p0v95_t1_temperature_high: (x & 1048576) !== 0,
                    p0v95_t2_temperature_above_critical: (x & 2097152) !== 0,
                    p0v95_t2_temperature_high: (x & 4194304) !== 0,
                    p1v1_p1v2_temperature_above_critical: (x & 8388608) !== 0,
                    p1v1_p1v2_temperature_high: (x & 16777216) !== 0,
                    p1v8_temperature_above_critical: (x & 33554432) !== 0,
                    p1v8_temperature_high: (x & 67108864) !== 0,
                    u21_temperature_above_critical: (x & 134217728) !== 0,
                    u21_temperature_high: (x & 268435456) !== 0,
                    u22_temperature_above_critical: (x & 536870912) !== 0,
                    u22_temperature_high: (x & 1073741824) !== 0
                }),
                lower: (x, _) => ((x.cpu_sodimm_temperature_above_critical ? 1 : 0) |
                    (x.cpu_sodimm_temperature_high ? 2 : 0) |
                    (x.cpu_temperature_above_critical ? 4 : 0) |
                    (x.cpu_temperature_high ? 8 : 0) |
                    (x.fan_controller_temperature_above_critical ? 16 : 0) |
                    (x.fan_controller_temperature_high ? 32 : 0) |
                    (x.fpga_ext_temperature_above_critical ? 64 : 0) |
                    (x.fpga_ext_temperature_high ? 128 : 0) |
                    (x.fpga_int_temperature_above_critical ? 256 : 0) |
                    (x.fpga_int_temperature_high ? 512 : 0) |
                    (x.fpga_sodimm1_temperature_above_critical ? 1024 : 0) |
                    (x.fpga_sodimm1_temperature_high ? 2048 : 0) |
                    (x.fpga_sodimm2_temperature_above_critical ? 4096 : 0) |
                    (x.fpga_sodimm2_temperature_high ? 8192 : 0) |
                    (x.ioboard_temperature_above_critical ? 16384 : 0) |
                    (x.ioboard_temperature_high ? 32768 : 0) |
                    (x.mgmt_phy_temperature_above_critical ? 65536 : 0) |
                    (x.mgmt_phy_temperature_high ? 131072 : 0) |
                    (x.missing_data ? 262144 : 0) |
                    (x.p0v95_t1_temperature_above_critical ? 524288 : 0) |
                    (x.p0v95_t1_temperature_high ? 1048576 : 0) |
                    (x.p0v95_t2_temperature_above_critical ? 2097152 : 0) |
                    (x.p0v95_t2_temperature_high ? 4194304 : 0) |
                    (x.p1v1_p1v2_temperature_above_critical ? 8388608 : 0) |
                    (x.p1v1_p1v2_temperature_high ? 16777216 : 0) |
                    (x.p1v8_temperature_above_critical ? 33554432 : 0) |
                    (x.p1v8_temperature_high ? 67108864 : 0) |
                    (x.u21_temperature_above_critical ? 134217728 : 0) |
                    (x.u21_temperature_high ? 268435456 : 0) |
                    (x.u22_temperature_above_critical ? 536870912 : 0) |
                    (x.u22_temperature_high ? 1073741824 : 0))
            });
        }
    }
    System.Temperature = Temperature;
    class InternalHWSgmii {
        raw;
        type_identifier = "System::Data::InternalHW::Sgmii";
        constructor(raw) {
            this.raw = raw;
        }
        get link_up() {
            return new VScript.rKeyword(this, "link_up", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get crc_errors() {
            return new VScript.rKeyword(this, "crc_errors", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get pcs_errors() {
            return new VScript.rKeyword(this, "pcs_errors", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    crc_errors: (x & 1) !== 0,
                    link_down: (x & 2) !== 0,
                    pcs_errors: (x & 4) !== 0
                }),
                lower: (x, _) => ((x.crc_errors ? 1 : 0) |
                    (x.link_down ? 2 : 0) |
                    (x.pcs_errors ? 4 : 0))
            });
        }
    }
    System.InternalHWSgmii = InternalHWSgmii;
    class AllSysinfo {
        raw;
        type_identifier = "System::Data::All::Sysinfo";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          System runtime since boot
        */
        get uptime() {
            return new VScript.rKeyword(this, "uptime", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            });
        }
        /**
          Load average for 1, 5 and 15 minutes
        */
        get load_avg() {
            return new VScript.rKeyword(this, "load_avg", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
            });
        }
        /**
          Free memory
        */
        get freeram() {
            return new VScript.rKeyword(this, "freeram", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Number of running processes
        */
        get procs() {
            return new VScript.rKeyword(this, "procs", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Number of currently active CPU cores
        */
        get num_cores() {
            return new VScript.rKeyword(this, "num_cores", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          CPU-SAR Register (Sample At Reset)
        */
        get cpu_sar() {
            return new VScript.rKeyword(this, "cpu_sar", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          CPU-Frequency
        */
        get cpu_freq() {
            return new VScript.rKeyword(this, "cpu_freq", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get services() {
            return VAPI.ServicesList.lift.ServicesList(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "services"));
        }
    }
    System.AllSysinfo = AllSysinfo;
    System.Enums = {
        FPGASelection: ["AVP", "AVP_40GbE", "CC3D_40GbE", "DMV_40GbE", "JPEGXS_40GbE", "PCAP_40GbE", "UDX_40GbE"],
        FPGA: ["AVP", "AVP_40GbE", "DMV_40GbE", "UDX_40GbE", "J2KD", "J2KD_40GbE", "CC3D_40GbE", "JPEGXS_40GbE", "PCAP_40GbE"]
    };
})(System || (System = {}));
export var SystemClock;
(function (SystemClock) {
    SystemClock.lift = {
        All: (_raw) => (new All(_raw)),
    };
    SystemClock.lower = { All: (_x) => _x.raw.kwl, };
    class All {
        raw;
        type_identifier = "SystemClock::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.rwKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        /**
          Determines the time standard the SystemClock will be set to.
          
          * `UTC` (Universal Time, Coordinated) is the standard for wall clock
          time. It is the standard that all timezones are based on. UTC has leap
          seconds to account for differences in the Earth's rotational speed. *When
          in doubt, always use `UTC`*
          
          * `TAI` (International Atomic Time) is the time standard used by PTP. It
          is a linear time standard that does not have leap seconds. TAI is
          currently ahead of UTC by 37 seconds.
        */
        get time_standard() {
            return new VScript.dKeyword(this, "time_standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    inaccurate_input: (x & 1) !== 0,
                    missing_offset: (x & 2) !== 0,
                    missing_utc_offset: (x & 4) !== 0,
                    out_of_bounds: (x & 8) !== 0,
                    unable_to_read_system_time: (x & 16) !== 0,
                    unable_to_set_system_time: (x & 32) !== 0
                }),
                lower: (x, _) => ((x.inaccurate_input ? 1 : 0) |
                    (x.missing_offset ? 2 : 0) |
                    (x.missing_utc_offset ? 4 : 0) |
                    (x.out_of_bounds ? 8 : 0) |
                    (x.unable_to_read_system_time ? 16 : 0) |
                    (x.unable_to_set_system_time ? 32 : 0))
            });
        }
        get system_time_updates() {
            return new VScript.rKeyword(this, "system_time_updates", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get system_time() {
            return new VScript.rKeyword(this, "system_time", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftTimestamp),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerTimestamp)
            });
        }
        /**
          use this to override `output.characteristics.offset_type`; may be useful
          to, e.g., redistribute BlackBurst-derived local time as (absolute) PTP
          time
        */
        get offset_type_override() {
            return new VScript.rwKeyword(this, "offset_type_override", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        get output() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "ptp_traits"));
        }
    }
    SystemClock.All = All;
})(SystemClock || (SystemClock = {}));
export var Time;
(function (Time) {
    Time.lift = {
        AnalogReference: (_raw) => (new AnalogReference(_raw)),
        Source: (_raw) => (new Source(_raw)),
    };
    Time.lower = {
        AnalogReference: (_x) => _x.raw.kwl,
        Source: (_x) => _x.raw.kwl,
    };
    class AnalogReference {
        raw;
        type_identifier = "Time::Data::AnalogReference";
        constructor(raw) {
            this.raw = raw;
        }
        get output() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "ptp_traits"));
        }
    }
    Time.AnalogReference = AnalogReference;
    class Source {
        raw;
        type_identifier = "Time::Data::Source";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get characteristics() {
            return new VScript.rKeyword(this, "characteristics", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lift.SourceCharacteristics),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lower.SourceCharacteristics)
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cycle_detected: (x & 1) !== 0
                }),
                lower: (x, _) => ((x.cycle_detected ? 1 : 0))
            });
        }
        get drift() {
            return new VScript.rKeyword(this, "drift", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lift.TimestampedDrift),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lower.TimestampedDrift)
            });
        }
        get offset() {
            return new VScript.rKeyword(this, "offset", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lift.TimestampedOffset),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lower.TimestampedOffset)
            });
        }
        get time_code() {
            return new VScript.rKeyword(this, "time_code", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lift.TimestampedTimecode),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lower.TimestampedTimecode)
            });
        }
        get ptp_traits() {
            return new VScript.rKeyword(this, "ptp_traits", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.PTP.Traits(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    Time.Source = Source;
})(Time || (Time = {}));
export var TimeFlows;
(function (TimeFlows) {
    TimeFlows.lift = {
        Aligner: (_raw) => (new Aligner(_raw)),
        All: (_raw) => (new All(_raw)),
        Combinator: (_raw) => (new Combinator(_raw)),
        Detonator: (_raw) => (new Detonator(_raw)),
        DriftConverter: (_raw) => (new DriftConverter(_raw)),
        Impostor: (_raw) => (new Impostor(_raw)),
        Selector: (_raw) => (new Selector(_raw)),
        Shifter: (_raw) => (new Shifter(_raw)),
        Stretcher: (_raw) => (new Stretcher(_raw)),
    };
    TimeFlows.lower = {
        Aligner: (_x) => _x.raw.kwl,
        All: (_x) => _x.raw.kwl,
        Combinator: (_x) => _x.raw.kwl,
        Detonator: (_x) => _x.raw.kwl,
        DriftConverter: (_x) => _x.raw.kwl,
        Impostor: (_x) => _x.raw.kwl,
        Selector: (_x) => _x.raw.kwl,
        Shifter: (_x) => _x.raw.kwl,
        Stretcher: (_x) => _x.raw.kwl,
    };
    class Aligner {
        raw;
        type_identifier = "TimeFlows::Data::Aligner";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src_absolute() {
            return new VScript.dKeyword(this, "t_src_absolute", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get t_src_grain_accurate() {
            return new VScript.dKeyword(this, "t_src_grain_accurate", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get warning_threshold() {
            return new VScript.dKeyword(this, "warning_threshold", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get holdover_grains() {
            return new VScript.dKeyword(this, "holdover_grains", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get output() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "ptp_traits"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    above_warning_threshold: (x & 1) !== 0,
                    holdover_due_to_frequency_change: (x & 2) !== 0,
                    holdover_due_to_input_jump: (x & 4) !== 0
                }),
                lower: (x, _) => ((x.above_warning_threshold ? 1 : 0) |
                    (x.holdover_due_to_frequency_change ? 2 : 0) |
                    (x.holdover_due_to_input_jump ? 4 : 0))
            });
        }
    }
    TimeFlows.Aligner = Aligner;
    class AlignerAsNamedTableRow extends Aligner {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.AlignerAsNamedTableRow = AlignerAsNamedTableRow;
    class All {
        raw;
        type_identifier = "TimeFlows::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get aligners() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "aligners"), (raw) => new VAPI.AT1101.TimeFlows.AlignerAsNamedTableRow(raw));
        }
        get combinators() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "combinators"), (raw) => new VAPI.AT1101.TimeFlows.CombinatorAsNamedTableRow(raw));
        }
        get detonators() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 2, "detonators"), (raw) => new VAPI.AT1101.TimeFlows.DetonatorAsNamedTableRow(raw));
        }
        get drift_converters() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 3, "drift_converters"), (raw) => new VAPI.AT1101.TimeFlows.DriftConverterAsNamedTableRow(raw));
        }
        get impostors() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 4, "impostors"), (raw) => new VAPI.AT1101.TimeFlows.ImpostorAsNamedTableRow(raw));
        }
        get selectors() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 5, "selectors"), (raw) => new VAPI.AT1101.TimeFlows.SelectorAsNamedTableRow(raw));
        }
        get shifters() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 6, "shifters"), (raw) => new VAPI.AT1101.TimeFlows.ShifterAsNamedTableRow(raw));
        }
        /**
          stretchers shift their input source's measured drift by a user-defined
          amount (note that this demotes `Absolute` and `GrainAccurate` time
          sources to class `FrequencyOnly`). Stretchers are probably useless in a
          production setting, but can be helpful in simulating failure scenarios.
        */
        get stretchers() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 7, "stretchers"), (raw) => new VAPI.AT1101.TimeFlows.StretcherAsNamedTableRow(raw));
        }
    }
    TimeFlows.All = All;
    class Combinator {
        raw;
        type_identifier = "TimeFlows::Data::Combinator";
        constructor(raw) {
            this.raw = raw;
        }
        get required_offset_type() {
            return new VScript.rwKeyword(this, "required_offset_type", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        get required_ptp_source_type() {
            return new VScript.rwKeyword(this, "required_ptp_source_type", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        get drift_reference() {
            return new VScript.rwKeyword(this, "drift_reference", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get min_drift_tolerance() {
            return new VScript.rwKeyword(this, "min_drift_tolerance", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get min_offset_tolerance() {
            return new VScript.rwKeyword(this, "min_offset_tolerance", {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, null);
        }
        get quorum() {
            return new VScript.dKeyword(this, "quorum", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get session_length() {
            return new VScript.dKeyword(this, "session_length", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get selected() {
            return new VScript.rKeyword(this, "selected", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
            });
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftMaybeSparseArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get output() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 9, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "ptp_traits"));
        }
    }
    TimeFlows.Combinator = Combinator;
    class CombinatorAsNamedTableRow extends Combinator {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.CombinatorAsNamedTableRow = CombinatorAsNamedTableRow;
    class Detonator {
        raw;
        type_identifier = "TimeFlows::Data::Detonator";
        constructor(raw) {
            this.raw = raw;
        }
        get max_drift_blast() {
            return new VScript.rwKeyword(this, "max_drift_blast", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get max_offset_blast() {
            return new VScript.rwKeyword(this, "max_offset_blast", {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, null);
        }
        /**
          Discharge
        */
        get discharge() {
            return new VScript.wKeyword(this, "discharge", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Realign
        */
        get realign() {
            return new VScript.wKeyword(this, "realign", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get friction() {
            return new VScript.rwKeyword(this, "friction", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get stiffness() {
            return new VScript.rwKeyword(this, "stiffness", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "ptp_traits"));
        }
    }
    TimeFlows.Detonator = Detonator;
    class DetonatorAsNamedTableRow extends Detonator {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.DetonatorAsNamedTableRow = DetonatorAsNamedTableRow;
    class DriftConverter {
        raw;
        type_identifier = "TimeFlows::Data::DriftConverter";
        constructor(raw) {
            this.raw = raw;
        }
        get drift_reference() {
            return new VScript.rwKeyword(this, "drift_reference", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          ideally, all inputs to a clock combinator should use the same reference
          frame as the clock combinator itself. If this is not the case,
          mismatching inputs will be discarded by default. By setting
          `on_reference_frame_mismatch` to `Convert`, inputs can also be converted
          to the combinator's own reference frame. Note, however, that this
          generally incurs a loss in precision
        */
        get on_drift_reference_mismatch() {
            return new VScript.rwKeyword(this, "on_drift_reference_mismatch", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "ptp_traits"));
        }
    }
    TimeFlows.DriftConverter = DriftConverter;
    class DriftConverterAsNamedTableRow extends DriftConverter {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.DriftConverterAsNamedTableRow = DriftConverterAsNamedTableRow;
    class Impostor {
        raw;
        type_identifier = "TimeFlows::Data::Impostor";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        /**
          Insert specified `grain_rate`, or upgrade input to absolute time source
          if null
        */
        get grain_rate() {
            return new VScript.rwKeyword(this, "grain_rate", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        get output() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "output"));
        }
    }
    TimeFlows.Impostor = Impostor;
    class ImpostorAsNamedTableRow extends Impostor {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.ImpostorAsNamedTableRow = ImpostorAsNamedTableRow;
    class Selector {
        raw;
        type_identifier = "TimeFlows::Data::Selector";
        constructor(raw) {
            this.raw = raw;
        }
        get selected() {
            return new VScript.rKeyword(this, "selected", {
                lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
            });
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftMaybeSparseArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get required_offset_type() {
            return new VScript.rwKeyword(this, "required_offset_type", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        get required_drift_reference() {
            return new VScript.rwKeyword(this, "required_drift_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        get required_ptp_source_type() {
            return new VScript.rwKeyword(this, "required_ptp_source_type", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            }, null);
        }
        get output() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "ptp_traits"));
        }
    }
    TimeFlows.Selector = Selector;
    class SelectorAsNamedTableRow extends Selector {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.SelectorAsNamedTableRow = SelectorAsNamedTableRow;
    class Shifter {
        raw;
        type_identifier = "TimeFlows::Data::Shifter";
        constructor(raw) {
            this.raw = raw;
        }
        get shift() {
            return new VScript.rwKeyword(this, "shift", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "ptp_traits"));
        }
    }
    TimeFlows.Shifter = Shifter;
    class ShifterAsNamedTableRow extends Shifter {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.ShifterAsNamedTableRow = ShifterAsNamedTableRow;
    class Stretcher {
        raw;
        type_identifier = "TimeFlows::Data::Stretcher";
        constructor(raw) {
            this.raw = raw;
        }
        get frequency_shift() {
            return new VScript.rwKeyword(this, "frequency_shift", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "ptp_traits"));
        }
    }
    TimeFlows.Stretcher = Stretcher;
    class StretcherAsNamedTableRow extends Stretcher {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.StretcherAsNamedTableRow = StretcherAsNamedTableRow;
})(TimeFlows || (TimeFlows = {}));
export var UDX;
(function (UDX) {
    UDX.lift = {
        All: (_raw) => (new All(_raw)),
        UDXOutput: (_raw) => (new UDXOutput(_raw)),
    };
    UDX.lower = {
        All: (_x) => _x.raw.kwl,
        UDXOutput: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "UDX::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get outputs() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "outputs"), (raw, _) => VAPI.AT1101.UDX.lift.UDXOutput(raw));
        }
        get statistics() {
            return VAPI.UDX.lift.UDXStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "statistics"));
        }
    }
    UDX.All = All;
    class UDXOutput {
        raw;
        type_identifier = "UDX::Data::UDXOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get video_source() {
            return new VScript.rwKeyword(this, "video_source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get video_standard() {
            return new VScript.rwKeyword(this, "video_standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get aspect_ratio() {
            return new VScript.dKeyword(this, "aspect_ratio", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get sd_active_pixels() {
            return new VScript.rwKeyword(this, "sd_active_pixels", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get video_full_range() {
            return new VScript.rwKeyword(this, "video_full_range", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get on_video_source_lost() {
            return new VScript.rwKeyword(this, "on_video_source_lost", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get crop() {
            return VAPI.UDX.lift.UDXVideoCrop(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "crop"));
        }
        get transform() {
            return VAPI.UDX.lift.UDXTransform(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "transform"));
        }
        get filter() {
            return VAPI.UDX.lift.UDXFilter(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "filter"));
        }
        get signal() {
            return VAPI.AT1101.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 9, "signal"));
        }
        get metadata_inserter() {
            return VAPI.AT1101.MetadataProcessor.lift.MetadataInserter(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "metadata_inserter"));
        }
    }
    UDX.UDXOutput = UDXOutput;
})(UDX || (UDX = {}));
export var UDXMetadataRequests;
(function (UDXMetadataRequests) {
    UDXMetadataRequests.lift = {
        All: (_raw) => (new All(_raw)),
    };
    UDXMetadataRequests.lower = { All: (_x) => _x.raw.kwl, };
    class All {
        raw;
        type_identifier = "UDXMetadataRequests::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get requests() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "requests"), (raw, _) => VAPI.AT1101.MetadataProcessor.lift.Request(raw));
        }
    }
    UDXMetadataRequests.All = All;
})(UDXMetadataRequests || (UDXMetadataRequests = {}));
export var Video;
(function (Video) {
    Video.lift = {
        Essence: (_raw) => (new Essence(_raw)),
        TimedSource: (_raw, _socket) => {
            return {
                source: _raw[0] === null ? null : new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                switch_time: _raw[1] === null ? null : VScript.VAPIHelpers.liftTimestamp(_raw[1], _socket)
            };
        },
    };
    Video.lower = {
        Essence: (_x) => _x.raw.kwl,
        TimedSource: (_x, _socket) => [
            _x.source === null ? null : _x.source.raw.kwl,
            _x.switch_time === null ? null : VScript.VAPIHelpers.lowerTimestamp(_x.switch_time, _socket)
        ],
    };
    class Essence {
        raw;
        type_identifier = "Video::Data::Essence";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get standard() {
            return new VScript.rKeyword(this, "standard", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get pixel_format() {
            return new VScript.rKeyword(this, "pixel_format", {
                lift: VAPI.Video.lift.PixelFormat,
                lower: VAPI.Video.lower.PixelFormat
            });
        }
        get substream() {
            return new VScript.rKeyword(this, "substream", {
                lift: VAPI.Video.lift.EssenceSubstream,
                lower: VAPI.Video.lower.EssenceSubstream
            });
        }
        get frozen() {
            return new VScript.rKeyword(this, "frozen", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get black() {
            return new VScript.rKeyword(this, "black", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get dt_node() {
            return new VScript.rKeyword(this, "dt_node", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          some signal sources, such as RTP audio/video streams, include a
          well-defined offset to the PTP epoch (as seen by the sender). During
          processing, these 'media clocks' may shift (e.g., as signals pass through
          delay elements) or broaden into finite intervals (e.g., as audio channels
          at different offsets to the PTP epoch are combined into a single audio
          essence). Using the `media_clock` keyword, such changes are tracked
          explicitly and forwarded to audio/video transmitters.
        */
        get media_clock() {
            return VAPI.AT1101.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "media_clock"));
        }
        get afd() {
            return new VScript.rKeyword(this, "afd", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lift.AFD),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lower.AFD)
            });
        }
        get cc() {
            return new VScript.rKeyword(this, "cc", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.Video.ClosedCaption(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    Video.Essence = Essence;
})(Video || (Video = {}));
export var VideoMixer;
(function (VideoMixer) {
    VideoMixer.lift = {
        All: (_raw) => (new All(_raw)),
        BSLK: (_raw) => (new BSLK(_raw)),
        BSLKLumaKeyer: (_raw) => (new BSLKLumaKeyer(_raw)),
    };
    VideoMixer.lower = {
        All: (_x) => _x.raw.kwl,
        BSLK: (_x) => _x.raw.kwl,
        BSLKLumaKeyer: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "VideoMixer::Data::All";
        get runtime_constants() {
            return {
                num_instances: this.raw.backing_store.get_runtime_constant("VideoMixer::num_instances")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get instances() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "instances"), (raw) => new VAPI.AT1101.VideoMixer.BSLKAsNamedTableRow(raw));
        }
    }
    VideoMixer.All = All;
    class BSLK {
        raw;
        type_identifier = "VideoMixer::Data::BSLK";
        constructor(raw) {
            this.raw = raw;
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    luma_keyer_v_src_out_of_range: (x & 1) !== 0,
                    mismatching_standards: (x & 2) !== 0,
                    missing_input: (x & 4) !== 0,
                    no_background: (x & 8) !== 0,
                    no_hw_resources: (x & 16) !== 0,
                    uhd_resources_required: (x & 32) !== 0,
                    v_src0_out_of_range: (x & 64) !== 0,
                    v_src1_out_of_range: (x & 128) !== 0
                }),
                lower: (x, _) => ((x.luma_keyer_v_src_out_of_range ? 1 : 0) |
                    (x.mismatching_standards ? 2 : 0) |
                    (x.missing_input ? 4 : 0) |
                    (x.no_background ? 8 : 0) |
                    (x.no_hw_resources ? 16 : 0) |
                    (x.uhd_resources_required ? 32 : 0) |
                    (x.v_src0_out_of_range ? 64 : 0) |
                    (x.v_src1_out_of_range ? 128 : 0))
            });
        }
        get v_src0() {
            return new VScript.dKeyword(this, "v_src0", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get v_src1() {
            return new VScript.dKeyword(this, "v_src1", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get phase_target() {
            return new VScript.dKeyword(this, "phase_target", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get in_phase() {
            return new VScript.rKeyword(this, "in_phase", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds)),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds))
            });
        }
        get phase_rst_counter() {
            return new VScript.rKeyword(this, "phase_rst_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get output() {
            return VAPI.AT1101.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "output"));
        }
        get reserve_uhd_resources() {
            return new VScript.dKeyword(this, "reserve_uhd_resources", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get hw_resources() {
            return new VScript.rKeyword(this, "hw_resources", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get mode() {
            return new VScript.rwKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get luma_keyer() {
            return VAPI.AT1101.VideoMixer.lift.BSLKLumaKeyer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 11, "luma_keyer"));
        }
        get mixer() {
            return VAPI.VideoMixer.lift.BSLKMixer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 12, "mixer"));
        }
    }
    VideoMixer.BSLK = BSLK;
    class BSLKAsNamedTableRow extends BSLK {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    VideoMixer.BSLKAsNamedTableRow = BSLKAsNamedTableRow;
    class BSLKLumaKeyer {
        raw;
        type_identifier = "VideoMixer::Data::BSLK::LumaKeyer";
        constructor(raw) {
            this.raw = raw;
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        /**
          Luminance level at and below which everything is transparent
        */
        get clip() {
            return new VScript.rwKeyword(this, "clip", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Luminance range above clip to reach full opacity
        */
        get gain() {
            return new VScript.rwKeyword(this, "gain", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get opacity() {
            return VAPI.VideoMixer.lift.AutoFader(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "opacity"));
        }
        /**
          Invert the transparent / opaque ends of the output range
        */
        get invert() {
            return new VScript.rwKeyword(this, "invert", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    VideoMixer.BSLKLumaKeyer = BSLKLumaKeyer;
})(VideoMixer || (VideoMixer = {}));
export var VideoPlayer;
(function (VideoPlayer) {
    VideoPlayer.lift = {
        Player: (_raw) => (new Player(_raw)),
        PlayerOutput: (_raw) => (new PlayerOutput(_raw)),
        RelationAudio: (_raw) => (new RelationAudio(_raw)),
        RelationVideo: (_raw) => (new RelationVideo(_raw)),
        Relations: (_raw) => (new Relations(_raw)),
        Time: (_raw) => (new Time(_raw)),
        RelationAudioFollowers: (_raw) => (new RelationAudioFollowers(_raw)),
        RelationVideoFollowers: (_raw) => (new RelationVideoFollowers(_raw)),
    };
    VideoPlayer.lower = {
        Player: (_x) => _x.raw.kwl,
        PlayerOutput: (_x) => _x.raw.kwl,
        RelationAudio: (_x) => _x.raw.kwl,
        RelationVideo: (_x) => _x.raw.kwl,
        Relations: (_x) => _x.raw.kwl,
        Time: (_x) => _x.raw.kwl,
        RelationAudioFollowers: (_x) => _x.raw.kwl,
        RelationVideoFollowers: (_x) => _x.raw.kwl,
    };
    class Player {
        raw;
        type_identifier = "VideoPlayer::Data::Player";
        constructor(raw) {
            this.raw = raw;
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    memory_exceed: (x & 1) !== 0,
                    missing_timesource: (x & 2) !== 0,
                    number_of_reader_exceed: (x & 4) !== 0,
                    number_of_writer_exceed: (x & 8) !== 0
                }),
                lower: (x, _) => ((x.memory_exceed ? 1 : 0) |
                    (x.missing_timesource ? 2 : 0) |
                    (x.number_of_reader_exceed ? 4 : 0) |
                    (x.number_of_writer_exceed ? 8 : 0))
            });
        }
        get upload_header() {
            return VAPI.VideoPlayer.lift.UploadHeader(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "upload_header"));
        }
        get memory_usage() {
            return new VScript.rKeyword(this, "memory_usage", {
                lift: VAPI.VideoPlayer.lift.MemoryCapacity,
                lower: VAPI.VideoPlayer.lower.MemoryCapacity
            });
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VAPI.VideoPlayer.lift.Capabilities,
                lower: VAPI.VideoPlayer.lower.Capabilities
            }, {
                lift: VAPI.VideoPlayer.lift.Capabilities,
                lower: VAPI.VideoPlayer.lower.Capabilities
            }, null);
        }
        get gang() {
            return VAPI.AT1101.VideoPlayer.lift.Relations(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "gang"));
        }
        /**
          Restart writer and reader
        */
        get restart() {
            return new VScript.wKeyword(this, "restart", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get output() {
            return VAPI.AT1101.VideoPlayer.lift.PlayerOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "output"));
        }
    }
    VideoPlayer.Player = Player;
    class PlayerAsNamedTableRow extends Player {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    VideoPlayer.PlayerAsNamedTableRow = PlayerAsNamedTableRow;
    class PlayerOutput {
        raw;
        type_identifier = "VideoPlayer::Data::PlayerOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get time() {
            return VAPI.AT1101.VideoPlayer.lift.Time(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "time"));
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get control() {
            return VAPI.VideoPlayer.lift.Control(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "control"));
        }
        get deembedded_audio() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 3, "deembedded_audio"), (st, _) => VAPI.VideoPlayer.lift.GroupSelections(st));
        }
        get reader() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "reader"), (raw, _) => VAPI.VideoPlayer.lift.Reader(raw));
        }
        get video() {
            return VAPI.AT1101.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "video"));
        }
        get audio() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "audio"));
        }
    }
    VideoPlayer.PlayerOutput = PlayerOutput;
    class RelationAudio {
        raw;
        type_identifier = "VideoPlayer::Data::RelationAudio";
        constructor(raw) {
            this.raw = raw;
        }
        get leader() {
            return new VScript.dKeyword(this, "leader", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.AudioRePlay.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.AudioRePlay.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get followers() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "followers"), (raw, _) => VAPI.AT1101.VideoPlayer.lift.RelationAudioFollowers(raw));
        }
    }
    VideoPlayer.RelationAudio = RelationAudio;
    class RelationVideo {
        raw;
        type_identifier = "VideoPlayer::Data::RelationVideo";
        constructor(raw) {
            this.raw = raw;
        }
        get leader() {
            return new VScript.dKeyword(this, "leader", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.VideoPlayer.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.VideoPlayer.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get followers() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "followers"), (raw, _) => VAPI.AT1101.VideoPlayer.lift.RelationVideoFollowers(raw));
        }
    }
    VideoPlayer.RelationVideo = RelationVideo;
    class Relations {
        raw;
        type_identifier = "VideoPlayer::Data::Relations";
        constructor(raw) {
            this.raw = raw;
        }
        get video() {
            return VAPI.AT1101.VideoPlayer.lift.RelationVideo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "video"));
        }
        get audio() {
            return VAPI.AT1101.VideoPlayer.lift.RelationAudio(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "audio"));
        }
    }
    VideoPlayer.Relations = Relations;
    class Time {
        raw;
        type_identifier = "VideoPlayer::Data::Time";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
    }
    VideoPlayer.Time = Time;
    class RelationAudioFollowers {
        raw;
        type_identifier = "VideoPlayer::Data::RelationAudio::Followers";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          TODO:
        */
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.AudioRePlay.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    VideoPlayer.RelationAudioFollowers = RelationAudioFollowers;
    class RelationVideoFollowers {
        raw;
        type_identifier = "VideoPlayer::Data::RelationVideo::Followers";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          TODO:
        */
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.VideoPlayer.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    VideoPlayer.RelationVideoFollowers = RelationVideoFollowers;
})(VideoPlayer || (VideoPlayer = {}));
export var VideoRePlay;
(function (VideoRePlay) {
    VideoRePlay.lift = {
        Delay: (_raw) => (new Delay(_raw)),
        DelayOutput: (_raw) => (new DelayOutput(_raw)),
        Time: (_raw) => (new Time(_raw)),
        Video: (_raw) => (new Video(_raw)),
        DelayInputs: (_raw) => (new DelayInputs(_raw)),
    };
    VideoRePlay.lower = {
        Delay: (_x) => _x.raw.kwl,
        DelayOutput: (_x) => _x.raw.kwl,
        Time: (_x) => _x.raw.kwl,
        Video: (_x) => _x.raw.kwl,
        DelayInputs: (_x) => _x.raw.kwl,
    };
    class Delay {
        raw;
        type_identifier = "VideoRePlay::Data::Delay";
        url(pars) {
            const vm = this.raw.backing_store;
            const store = pars?.frame_index !== undefined ? `frame&frame_index=${pars.frame_index}` : "clip_single_file";
            return `${vm.protocol === "ws" ? "http" : "https"}://${this.raw.backing_store.ip}/replay/video?action=read&handler=${VScript.enforce_nonnull(VScript.path_index(this.raw.kwl))}&store=${store}`;
        }
        async stop_and_download(pars) {
            const url = this.url(pars);
            await this.dma.http.setup_handler.write("Stop");
            const rsp = await fetch(url);
            if (!rsp.ok)
                throw new Error(`Unable to download ${url}: ${rsp.statusText}`);
            return rsp.arrayBuffer();
        }
        constructor(raw) {
            this.raw = raw;
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    memory_exceed: (x & 1) !== 0,
                    missing_input_standard: (x & 2) !== 0,
                    missing_latched_standard: (x & 4) !== 0,
                    missing_timesource: (x & 8) !== 0,
                    number_of_reader_exceed: (x & 16) !== 0,
                    number_of_writer_exceed: (x & 32) !== 0
                }),
                lower: (x, _) => ((x.memory_exceed ? 1 : 0) |
                    (x.missing_input_standard ? 2 : 0) |
                    (x.missing_latched_standard ? 4 : 0) |
                    (x.missing_timesource ? 8 : 0) |
                    (x.number_of_reader_exceed ? 16 : 0) |
                    (x.number_of_writer_exceed ? 32 : 0))
            });
        }
        get memory_usage() {
            return new VScript.rKeyword(this, "memory_usage", {
                lift: VAPI.VideoRePlay.lift.MemoryCapacity,
                lower: VAPI.VideoRePlay.lower.MemoryCapacity
            });
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VAPI.VideoRePlay.lift.Capabilities,
                lower: VAPI.VideoRePlay.lower.Capabilities
            }, {
                lift: VAPI.VideoRePlay.lift.Capabilities,
                lower: VAPI.VideoRePlay.lower.Capabilities
            }, null);
        }
        /**
          Restart writer and reader
        */
        get restart() {
            return new VScript.wKeyword(this, "restart", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get dma() {
            return VAPI.VideoRePlay.lift.DMA(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "dma"));
        }
        get inputs() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 5, "inputs"), (raw, _) => VAPI.AT1101.VideoRePlay.lift.DelayInputs(raw));
        }
        get outputs() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 6, "outputs"), (raw) => new VAPI.AT1101.VideoRePlay.DelayOutputAsNamedTableRow(raw));
        }
    }
    VideoRePlay.Delay = Delay;
    class DelayAsNamedTableRow extends Delay {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    VideoRePlay.DelayAsNamedTableRow = DelayAsNamedTableRow;
    class DelayOutput {
        raw;
        type_identifier = "VideoRePlay::Data::DelayOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get time() {
            return VAPI.AT1101.VideoRePlay.lift.Time(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "time"));
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get delay() {
            return VAPI.VideoRePlay.lift.Buffer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "delay"));
        }
        get deembedded_audio() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 4, "deembedded_audio"), (st, _) => VAPI.VideoRePlay.lift.GroupSelections(st));
        }
        get reader() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 5, "reader"), (raw, _) => VAPI.VideoRePlay.lift.Reader(raw));
        }
        get video() {
            return VAPI.AT1101.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "video"));
        }
        get audio() {
            return VAPI.AT1101.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "audio"));
        }
    }
    VideoRePlay.DelayOutput = DelayOutput;
    class DelayOutputAsNamedTableRow extends DelayOutput {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    VideoRePlay.DelayOutputAsNamedTableRow = DelayOutputAsNamedTableRow;
    class Time {
        raw;
        type_identifier = "VideoRePlay::Data::Time";
        constructor(raw) {
            this.raw = raw;
        }
        get phaser_range() {
            return new VScript.rwKeyword(this, "phaser_range", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get restart_phaser() {
            return new VScript.rwKeyword(this, "restart_phaser", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    VideoRePlay.Time = Time;
    class Video {
        raw;
        type_identifier = "VideoRePlay::Data::Video";
        constructor(raw) {
            this.raw = raw;
        }
        get info() {
            return VAPI.DataRePlay.lift.MemoryInfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "info"));
        }
        get players() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "players"), (raw) => new VAPI.AT1101.VideoPlayer.PlayerAsNamedTableRow(raw));
        }
        get delays() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 2, "delays"), (raw) => new VAPI.AT1101.VideoRePlay.DelayAsNamedTableRow(raw));
        }
        get statistic() {
            return VAPI.DataRePlay.lift.Statistic(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "statistic"));
        }
        get ecc() {
            return VAPI.Memory.lift.ECCMuxStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "ecc"));
        }
        get audio_source_slices() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 5, "audio_source_slices"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
    }
    VideoRePlay.Video = Video;
    class DelayInputs {
        raw;
        type_identifier = "VideoRePlay::Data::Delay::Inputs";
        constructor(raw) {
            this.raw = raw;
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get latest_running_standard() {
            return new VScript.rKeyword(this, "latest_running_standard", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get writer() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 3, "writer"), (raw, _) => VAPI.VideoRePlay.lift.Writer(raw));
        }
    }
    VideoRePlay.DelayInputs = DelayInputs;
})(VideoRePlay || (VideoRePlay = {}));
export var VideoSignalGenerator;
(function (VideoSignalGenerator) {
    VideoSignalGenerator.lift = {
        All: (_raw) => (new All(_raw)),
        VSG: (_raw) => (new VSG(_raw)),
    };
    VideoSignalGenerator.lower = {
        All: (_x) => _x.raw.kwl,
        VSG: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "VideoSignalGenerator::Data::All";
        get runtime_constants() {
            return {
                num_video_signal_generators: this.raw.backing_store.get_runtime_constant("VideoSignalGenerator::num_video_signal_generators")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get instances() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 0, "instances"), (st, _) => VAPI.AT1101.VideoSignalGenerator.lift.VSG(st));
        }
    }
    VideoSignalGenerator.All = All;
    class VSG {
        raw;
        type_identifier = "VideoSignalGenerator::Data::VSG";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1101.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1101.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "output"));
        }
        get standard() {
            return new VScript.dKeyword(this, "standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get pattern() {
            return new VScript.rwKeyword(this, "pattern", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get cnt0_full() {
            return new VScript.rwKeyword(this, "cnt0_full", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get cnt1_full() {
            return new VScript.rwKeyword(this, "cnt1_full", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get cnt0_horz() {
            return new VScript.rwKeyword(this, "cnt0_horz", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get cnt1_horz() {
            return new VScript.rwKeyword(this, "cnt1_horz", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get phase() {
            return new VScript.rKeyword(this, "phase", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            });
        }
        get phase_rst_counter() {
            return new VScript.rKeyword(this, "phase_rst_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    genlock_not_locked: (x & 1) !== 0,
                    missing_t_src: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.genlock_not_locked ? 1 : 0) |
                    (x.missing_t_src ? 2 : 0))
            });
        }
    }
    VideoSignalGenerator.VSG = VSG;
})(VideoSignalGenerator || (VideoSignalGenerator = {}));
export class Root {
    raw;
    audio_gain;
    audio_mixer;
    audio_shuffler;
    audio_signal_generator;
    clos_x_bar;
    cluster;
    color_correction;
    genlock;
    i_o_module;
    j2_k_decoder;
    master_clock;
    metadata_processor;
    monitoring;
    multiviewer;
    multiviewer_i_o;
    network_interfaces;
    p_cap;
    p_t_p_clock;
    p_t_p_flows;
    r_t_p_metadata_channel;
    r_t_p_receiver;
    r_t_p_transmitter;
    re_play;
    sample_rate_converter;
    software_update;
    splitter;
    system;
    system_clock;
    time_flows;
    u_d_x;
    u_d_x_metadata_requests;
    video_mixer;
    video_signal_generator;
    constructor(raw) {
        this.raw = raw;
        const maybe_audio_gain = VScript.VAPIHelpers.component_checked(this.raw, "audio_gain");
        if (maybe_audio_gain)
            this.audio_gain = new VAPI.AT1101.AudioGain.All(maybe_audio_gain);
        const maybe_audio_mixer = VScript.VAPIHelpers.component_checked(this.raw, "audio_mixer");
        if (maybe_audio_mixer)
            this.audio_mixer = new VAPI.AT1101.AudioMixer.All(maybe_audio_mixer);
        const maybe_audio_shuffler = VScript.VAPIHelpers.component_checked(this.raw, "audio_shuffler");
        if (maybe_audio_shuffler)
            this.audio_shuffler = new VAPI.AT1101.AudioShuffler.All(maybe_audio_shuffler);
        const maybe_audio_signal_generator = VScript.VAPIHelpers.component_checked(this.raw, "audio_signal_generator");
        if (maybe_audio_signal_generator)
            this.audio_signal_generator = new VAPI.AT1101.AudioSignalGenerator.All(maybe_audio_signal_generator);
        const maybe_clos_x_bar = VScript.VAPIHelpers.component_checked(this.raw, "clos_x_bar");
        if (maybe_clos_x_bar)
            this.clos_x_bar = new VAPI.ClosXBar.All(maybe_clos_x_bar);
        const maybe_cluster = VScript.VAPIHelpers.component_checked(this.raw, "cluster");
        if (maybe_cluster)
            this.cluster = new VAPI.AT1101.Cluster.All(maybe_cluster);
        const maybe_color_correction = VScript.VAPIHelpers.component_checked(this.raw, "color_correction");
        if (maybe_color_correction)
            this.color_correction = new VAPI.AT1101.ColorCorrection.All(maybe_color_correction);
        const maybe_genlock = VScript.VAPIHelpers.component_checked(this.raw, "genlock");
        if (maybe_genlock)
            this.genlock = new VAPI.AT1101.Genlock.All(maybe_genlock);
        const maybe_i_o_module = VScript.VAPIHelpers.component_checked(this.raw, "i_o_module");
        if (maybe_i_o_module)
            this.i_o_module = new VAPI.AT1101.IOModule.All(maybe_i_o_module);
        const maybe_j2_k_decoder = VScript.VAPIHelpers.component_checked(this.raw, "j2_k_decoder");
        if (maybe_j2_k_decoder)
            this.j2_k_decoder = new VAPI.AT1101.J2KDecoder.All(maybe_j2_k_decoder);
        this.master_clock = new VAPI.AT1101.MasterClock.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "master_clock")));
        const maybe_metadata_processor = VScript.VAPIHelpers.component_checked(this.raw, "metadata_processor");
        if (maybe_metadata_processor)
            this.metadata_processor = new VAPI.AT1101.MetadataProcessor.All(maybe_metadata_processor);
        const maybe_monitoring = VScript.VAPIHelpers.component_checked(this.raw, "monitoring");
        if (maybe_monitoring)
            this.monitoring = new VAPI.AT1101.Monitoring.All(maybe_monitoring);
        const maybe_multiviewer = VScript.VAPIHelpers.component_checked(this.raw, "multiviewer");
        if (maybe_multiviewer)
            this.multiviewer = new VAPI.Multiviewer.All(maybe_multiviewer);
        const maybe_multiviewer_i_o = VScript.VAPIHelpers.component_checked(this.raw, "multiviewer_i_o");
        if (maybe_multiviewer_i_o)
            this.multiviewer_i_o = new VAPI.AT1101.MultiviewerIO.All(maybe_multiviewer_i_o);
        this.network_interfaces = new VAPI.AT1101.NetworkInterfaces.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "network_interfaces")));
        const maybe_p_cap = VScript.VAPIHelpers.component_checked(this.raw, "p_cap");
        if (maybe_p_cap)
            this.p_cap = new VAPI.AT1101.PCap.All(maybe_p_cap);
        this.p_t_p_clock = new VAPI.AT1101.PTPClock.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "p_t_p_clock")));
        this.p_t_p_flows = new VAPI.AT1101.PTPFlows.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "p_t_p_flows")));
        const maybe_r_t_p_metadata_channel = VScript.VAPIHelpers.component_checked(this.raw, "r_t_p_metadata_channel");
        if (maybe_r_t_p_metadata_channel)
            this.r_t_p_metadata_channel = new VAPI.RTPMetadataChannel.All(maybe_r_t_p_metadata_channel);
        const maybe_r_t_p_receiver = VScript.VAPIHelpers.component_checked(this.raw, "r_t_p_receiver");
        if (maybe_r_t_p_receiver)
            this.r_t_p_receiver = new VAPI.AT1101.RTPReceiver.All(maybe_r_t_p_receiver);
        const maybe_r_t_p_transmitter = VScript.VAPIHelpers.component_checked(this.raw, "r_t_p_transmitter");
        if (maybe_r_t_p_transmitter)
            this.r_t_p_transmitter = new VAPI.AT1101.RTPTransmitter.All(maybe_r_t_p_transmitter);
        const maybe_re_play = VScript.VAPIHelpers.component_checked(this.raw, "re_play");
        if (maybe_re_play)
            this.re_play = new VAPI.AT1101.RePlay.All(maybe_re_play);
        const maybe_sample_rate_converter = VScript.VAPIHelpers.component_checked(this.raw, "sample_rate_converter");
        if (maybe_sample_rate_converter)
            this.sample_rate_converter = new VAPI.AT1101.SampleRateConverter.All(maybe_sample_rate_converter);
        this.software_update = new VAPI.SoftwareUpdate.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "software_update")));
        const maybe_splitter = VScript.VAPIHelpers.component_checked(this.raw, "splitter");
        if (maybe_splitter)
            this.splitter = new VAPI.AT1101.Splitter.All(maybe_splitter);
        this.system = new VAPI.AT1101.System.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "system")));
        this.system_clock = new VAPI.AT1101.SystemClock.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "system_clock")));
        this.time_flows = new VAPI.AT1101.TimeFlows.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "time_flows")));
        const maybe_u_d_x = VScript.VAPIHelpers.component_checked(this.raw, "u_d_x");
        if (maybe_u_d_x)
            this.u_d_x = new VAPI.AT1101.UDX.All(maybe_u_d_x);
        const maybe_u_d_x_metadata_requests = VScript.VAPIHelpers.component_checked(this.raw, "u_d_x_metadata_requests");
        if (maybe_u_d_x_metadata_requests)
            this.u_d_x_metadata_requests = new VAPI.AT1101.UDXMetadataRequests.All(maybe_u_d_x_metadata_requests);
        const maybe_video_mixer = VScript.VAPIHelpers.component_checked(this.raw, "video_mixer");
        if (maybe_video_mixer)
            this.video_mixer = new VAPI.AT1101.VideoMixer.All(maybe_video_mixer);
        const maybe_video_signal_generator = VScript.VAPIHelpers.component_checked(this.raw, "video_signal_generator");
        if (maybe_video_signal_generator)
            this.video_signal_generator = new VAPI.AT1101.VideoSignalGenerator.All(maybe_video_signal_generator);
    }
    static adopt(socket) { return new Root(socket); }
    async close() { await this.raw.close(); }
}
