import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    Channel: (_raw, _socket) => {
        return {
            signal: _raw[0] === null ? null : VScript.VAPIHelpers.liftRefinedIndexedMutatingReference((kwl, _socket) => new VAPI.Audio.SignalSourceSlice(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "signal_status", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            })(_raw[0], _socket),
            gain: _raw[1],
            phase_invert: _raw[2],
            fade_request: VAPI.Audio.lift.FadeRequest(_raw[3], _socket)
        };
    },
    FadeRequest: (_raw, _socket) => {
        return {
            start: _raw[0],
            downto: _raw[1],
            upfrom: _raw[2],
            end: _raw[3],
            micro_epoch_index: _raw[4]
        };
    },
    SignalSourceSlice: (_raw) => (new SignalSourceSlice(_raw)),
};
export const lower = {
    Channel: (_x, _socket) => [
        _x.signal === null ? null : VScript.VAPIHelpers.lowerRefinedIndexedReference()(_x.signal, _socket),
        _x.gain,
        _x.phase_invert,
        VAPI.Audio.lower.FadeRequest(_x.fade_request, _socket)
    ],
    FadeRequest: (_x, _socket) => [
        _x.start,
        _x.downto,
        _x.upfrom,
        _x.end,
        _x.micro_epoch_index
    ],
    SignalSourceSlice: (_x) => _x.raw.kwl,
};
export class SignalSourceSlice {
    raw;
    type_identifier = "Audio::Data::SignalSourceSlice";
    constructor(raw) {
        this.raw = raw;
    }
    get frequency() {
        return new VScript.rKeyword(this, "frequency", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get peak_meter() {
        return new VScript.rKeyword(this, "peak_meter", {
            lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
        });
    }
    get signal_status() {
        return new VScript.rKeywordReferenceable(this, "signal_status", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
        });
    }
    get dt_node() {
        return new VScript.rKeyword(this, "dt_node", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
}
export const Enums = {
    SignalStatus: ["NoSignal", "Silence", "Signal"],
    PacketTime: ["p1", "p0_666", "p0_500", "p0_333", "p0_250", "p0_125"],
    Level: ["set_6dbfs", "set_18dbfs", "set_20dbfs"],
    Frequency: ["F48000", "F96000"],
    Format: ["AM824", "L24", "L16"]
};
