import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly ClusterGlobalAddressesParameters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Cluster.ClusterGlobalAddressesParameters;
    readonly ClusterGlobalConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Cluster.ClusterGlobalConfiguration;
    readonly ClusterGlobalMasterRedundancyParameters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Cluster.ClusterGlobalMasterRedundancyParameters;
    readonly ClusterGlobalMiscParameters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Cluster.ClusterGlobalMiscParameters;
    readonly ClusterGlobalOffsetstParameters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Cluster.ClusterGlobalOffsetstParameters;
    readonly ClusterGlobalParameters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Cluster.ClusterGlobalParameters;
    readonly ClusterGlobalRoutingParameters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Cluster.ClusterGlobalRoutingParameters;
    readonly ClusterStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Cluster.ClusterStatistics;
};
export declare const lower: {
    readonly ClusterGlobalAddressesParameters: (_x: ClusterGlobalAddressesParameters) => string;
    readonly ClusterGlobalConfiguration: (_x: ClusterGlobalConfiguration) => string;
    readonly ClusterGlobalMasterRedundancyParameters: (_x: ClusterGlobalMasterRedundancyParameters) => string;
    readonly ClusterGlobalMiscParameters: (_x: ClusterGlobalMiscParameters) => string;
    readonly ClusterGlobalOffsetstParameters: (_x: ClusterGlobalOffsetstParameters) => string;
    readonly ClusterGlobalParameters: (_x: ClusterGlobalParameters) => string;
    readonly ClusterGlobalRoutingParameters: (_x: ClusterGlobalRoutingParameters) => string;
    readonly ClusterStatistics: (_x: ClusterStatistics) => string;
};
export declare class ClusterGlobalAddressesParameters implements VScript.Referenceable<"Cluster::Data::ClusterGlobalAddressesParameters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Cluster::Data::ClusterGlobalAddressesParameters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Cluster control multicast address
    */
    get ctrl_mcast_addr(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | string, null | string, VAPI.Cluster.ClusterGlobalAddressesParameters>;
    /**
      Cluster mipmaps streams first multicast address
    */
    get mipmaps_mcast_addr_first(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | string, null | string, VAPI.Cluster.ClusterGlobalAddressesParameters>;
    /**
      Pattern how to generate multicast addresses.
    */
    get mipmaps_mcast_addr_inc(): VScript.rwKeyword<VScript.VSocket, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.ClusterGlobalAddressesParameters>;
    /**
      Cluster heads streams first multicast address
    */
    get multiviewers_heads_addr_first(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | string, null | string, VAPI.Cluster.ClusterGlobalAddressesParameters>;
    /**
      Pattern how to generate multicast addresses.
    */
    get multiviewers_heads_addr_inc(): VScript.rwKeyword<VScript.VSocket, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.ClusterGlobalAddressesParameters>;
    /**
      Secondary Cluster mipmaps streams first multicast address
    */
    get secondary_mipmaps_mcast_addr_first(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | string, null | string, VAPI.Cluster.ClusterGlobalAddressesParameters>;
    /**
      Pattern how to generate multicast addresses.
    */
    get secondary_mipmaps_mcast_addr_inc(): VScript.rwKeyword<VScript.VSocket, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.ClusterGlobalAddressesParameters>;
    /**
      Secondary Cluster heads streams first multicast address
    */
    get secondary_multiviewers_heads_addr_first(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | string, null | string, VAPI.Cluster.ClusterGlobalAddressesParameters>;
    /**
      Pattern how to generate multicast addresses.
    */
    get secondary_multiviewers_heads_addr_inc(): VScript.rwKeyword<VScript.VSocket, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.IPADDRESSINCREMENT, VAPI.Cluster.ClusterGlobalAddressesParameters>;
}
export declare class ClusterGlobalConfiguration implements VScript.Referenceable<"Cluster::Data::ClusterGlobalConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Cluster::Data::ClusterGlobalConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get lock(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.Cluster.ClusterGlobalConfiguration>;
    get parameters(): VAPI.Cluster.ClusterGlobalParameters;
    get nodes(): VScript.StronglyTypedNamedTable<VScript.VSocket, "ClusterNodes::Data::ClusterNodeGlobalConfiguration", VAPI.ClusterNodes.ClusterNodeGlobalConfigurationAsNamedTableRow>;
    get sources(): VAPI.ClusterSources.ClusterSourcesGlobalConfiguration;
    get outputs(): VAPI.ClusterOutputs.ClusterOutputsGlobalConfiguration;
    get monitoring_objects(): VScript.StronglyTypedNamedTable<VScript.VSocket, "ClusterMonitoringObjects::Data::ClusterMonitoringObjectGlobalConfiguration", VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalConfigurationAsNamedTableRow>;
}
export declare class ClusterGlobalMasterRedundancyParameters implements VScript.Referenceable<"Cluster::Data::ClusterGlobalMasterRedundancyParameters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Cluster::Data::ClusterGlobalMasterRedundancyParameters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get active_after_boot(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.Cluster.ClusterGlobalMasterRedundancyParameters>;
}
export declare class ClusterGlobalMiscParameters implements VScript.Referenceable<"Cluster::Data::ClusterGlobalMiscParameters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Cluster::Data::ClusterGlobalMiscParameters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get graphics_update_throttle(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Cluster.ClusterGlobalMiscParameters>;
}
export declare class ClusterGlobalOffsetstParameters implements VScript.Referenceable<"Cluster::Data::ClusterGlobalOffsetstParameters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Cluster::Data::ClusterGlobalOffsetstParameters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get srcs_i_p_2110(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Cluster.ClusterGlobalOffsetstParameters>;
    get srcs_i_p_2022(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Cluster.ClusterGlobalOffsetstParameters>;
    get srcs_external_mipmaps(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Cluster.ClusterGlobalOffsetstParameters>;
    get srcs_multiviewers_heads(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Cluster.ClusterGlobalOffsetstParameters>;
    get srcs_s_d_i(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Cluster.ClusterGlobalOffsetstParameters>;
    get srcs_per_node_s_d_i(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Cluster.ClusterGlobalOffsetstParameters>;
    get outs_per_node_s_d_i(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Cluster.ClusterGlobalOffsetstParameters>;
}
export declare class ClusterGlobalParameters implements VScript.Referenceable<"Cluster::Data::ClusterGlobalParameters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Cluster::Data::ClusterGlobalParameters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get addresses(): VAPI.Cluster.ClusterGlobalAddressesParameters;
    get routing(): VAPI.Cluster.ClusterGlobalRoutingParameters;
    get offsets(): VAPI.Cluster.ClusterGlobalOffsetstParameters;
    get monitoring_objects(): VAPI.ClusterMonitoringObjects.ClusterGlobalMonitoringObjectsParameters;
    get misc(): VAPI.Cluster.ClusterGlobalMiscParameters;
    get master_redundancy(): VAPI.Cluster.ClusterGlobalMasterRedundancyParameters;
}
export declare class ClusterGlobalRoutingParameters implements VScript.Referenceable<"Cluster::Data::ClusterGlobalRoutingParameters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Cluster::Data::ClusterGlobalRoutingParameters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get mipmaps_ins_ports(): VScript.rwKeyword<VScript.VSocket, VAPI.ClusterSources.Ports, VAPI.ClusterSources.Ports, VAPI.ClusterSources.Ports, VAPI.ClusterSources.Ports, VAPI.Cluster.ClusterGlobalRoutingParameters>;
    get mipmaps_outs_ports(): VScript.rwKeyword<VScript.VSocket, VAPI.ClusterSources.Ports, VAPI.ClusterSources.Ports, VAPI.ClusterSources.Ports, VAPI.ClusterSources.Ports, VAPI.Cluster.ClusterGlobalRoutingParameters>;
    get ip_srcs_ports(): VScript.rwKeyword<VScript.VSocket, VAPI.ClusterSources.Ports, VAPI.ClusterSources.Ports, VAPI.ClusterSources.Ports, VAPI.ClusterSources.Ports, VAPI.Cluster.ClusterGlobalRoutingParameters>;
    get ip_outs_ports(): VScript.rwKeyword<VScript.VSocket, VAPI.ClusterSources.Ports, VAPI.ClusterSources.Ports, VAPI.ClusterSources.Ports, VAPI.ClusterSources.Ports, VAPI.Cluster.ClusterGlobalRoutingParameters>;
    get mipmaps_outs_throttle_pause(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Cluster.ClusterGlobalRoutingParameters>;
}
export declare class ClusterStatistics implements VScript.Referenceable<"Cluster::Data::ClusterStatistics"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Cluster::Data::ClusterStatistics";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get prev_sync_length(): VScript.rKeyword<VScript.VSocket, number, VAPI.Cluster.TUnsignedMax, VAPI.Cluster.ClusterStatistics>;
    get prev_sync_kwls(): VScript.rKeyword<VScript.VSocket, number, VAPI.Cluster.TUnsignedMax, VAPI.Cluster.ClusterStatistics>;
    get prev_sync_tables(): VScript.rKeyword<VScript.VSocket, number, VAPI.Cluster.TUnsignedMax, VAPI.Cluster.ClusterStatistics>;
}
export type IPADDRESSINCREMENT = "X_X_1_1" | "X_1_1_X" | "X_1_X_1" | "X_RL_1_1";
export type TUnsignedMax = number;
export declare const Enums: {
    readonly IPADDRESSINCREMENT: IPADDRESSINCREMENT[];
};
