import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    ClusterGlobalAddressesParameters: (_raw) => (new ClusterGlobalAddressesParameters(_raw)),
    ClusterGlobalConfiguration: (_raw) => (new ClusterGlobalConfiguration(_raw)),
    ClusterGlobalMasterRedundancyParameters: (_raw) => (new ClusterGlobalMasterRedundancyParameters(_raw)),
    ClusterGlobalMiscParameters: (_raw) => (new ClusterGlobalMiscParameters(_raw)),
    ClusterGlobalOffsetstParameters: (_raw) => (new ClusterGlobalOffsetstParameters(_raw)),
    ClusterGlobalParameters: (_raw) => (new ClusterGlobalParameters(_raw)),
    ClusterGlobalRoutingParameters: (_raw) => (new ClusterGlobalRoutingParameters(_raw)),
    ClusterStatistics: (_raw) => (new ClusterStatistics(_raw)),
};
export const lower = {
    ClusterGlobalAddressesParameters: (_x) => _x.raw.kwl,
    ClusterGlobalConfiguration: (_x) => _x.raw.kwl,
    ClusterGlobalMasterRedundancyParameters: (_x) => _x.raw.kwl,
    ClusterGlobalMiscParameters: (_x) => _x.raw.kwl,
    ClusterGlobalOffsetstParameters: (_x) => _x.raw.kwl,
    ClusterGlobalParameters: (_x) => _x.raw.kwl,
    ClusterGlobalRoutingParameters: (_x) => _x.raw.kwl,
    ClusterStatistics: (_x) => _x.raw.kwl,
};
export class ClusterGlobalAddressesParameters {
    raw;
    type_identifier = "Cluster::Data::ClusterGlobalAddressesParameters";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Cluster control multicast address
    */
    get ctrl_mcast_addr() {
        return new VScript.rwKeyword(this, "ctrl_mcast_addr", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    /**
      Cluster mipmaps streams first multicast address
    */
    get mipmaps_mcast_addr_first() {
        return new VScript.rwKeyword(this, "mipmaps_mcast_addr_first", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    /**
      Pattern how to generate multicast addresses.
    */
    get mipmaps_mcast_addr_inc() {
        return new VScript.rwKeyword(this, "mipmaps_mcast_addr_inc", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Cluster heads streams first multicast address
    */
    get multiviewers_heads_addr_first() {
        return new VScript.rwKeyword(this, "multiviewers_heads_addr_first", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    /**
      Pattern how to generate multicast addresses.
    */
    get multiviewers_heads_addr_inc() {
        return new VScript.rwKeyword(this, "multiviewers_heads_addr_inc", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Secondary Cluster mipmaps streams first multicast address
    */
    get secondary_mipmaps_mcast_addr_first() {
        return new VScript.rwKeyword(this, "secondary_mipmaps_mcast_addr_first", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    /**
      Pattern how to generate multicast addresses.
    */
    get secondary_mipmaps_mcast_addr_inc() {
        return new VScript.rwKeyword(this, "secondary_mipmaps_mcast_addr_inc", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Secondary Cluster heads streams first multicast address
    */
    get secondary_multiviewers_heads_addr_first() {
        return new VScript.rwKeyword(this, "secondary_multiviewers_heads_addr_first", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    /**
      Pattern how to generate multicast addresses.
    */
    get secondary_multiviewers_heads_addr_inc() {
        return new VScript.rwKeyword(this, "secondary_multiviewers_heads_addr_inc", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ClusterGlobalConfiguration {
    raw;
    type_identifier = "Cluster::Data::ClusterGlobalConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get lock() {
        return new VScript.rwKeyword(this, "lock", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get parameters() {
        return VAPI.Cluster.lift.ClusterGlobalParameters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "parameters"));
    }
    get nodes() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 2, "nodes"), (raw) => new VAPI.ClusterNodes.ClusterNodeGlobalConfigurationAsNamedTableRow(raw));
    }
    get sources() {
        return VAPI.ClusterSources.lift.ClusterSourcesGlobalConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "sources"));
    }
    get outputs() {
        return VAPI.ClusterOutputs.lift.ClusterOutputsGlobalConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "outputs"));
    }
    get monitoring_objects() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 5, "monitoring_objects"), (raw) => new VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalConfigurationAsNamedTableRow(raw));
    }
}
export class ClusterGlobalMasterRedundancyParameters {
    raw;
    type_identifier = "Cluster::Data::ClusterGlobalMasterRedundancyParameters";
    constructor(raw) {
        this.raw = raw;
    }
    get active_after_boot() {
        return new VScript.rwKeyword(this, "active_after_boot", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ClusterGlobalMiscParameters {
    raw;
    type_identifier = "Cluster::Data::ClusterGlobalMiscParameters";
    constructor(raw) {
        this.raw = raw;
    }
    get graphics_update_throttle() {
        return new VScript.rwKeyword(this, "graphics_update_throttle", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ClusterGlobalOffsetstParameters {
    raw;
    type_identifier = "Cluster::Data::ClusterGlobalOffsetstParameters";
    constructor(raw) {
        this.raw = raw;
    }
    get srcs_i_p_2110() {
        return new VScript.rwKeyword(this, "srcs_i_p_2110", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get srcs_i_p_2022() {
        return new VScript.rwKeyword(this, "srcs_i_p_2022", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get srcs_external_mipmaps() {
        return new VScript.rwKeyword(this, "srcs_external_mipmaps", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get srcs_multiviewers_heads() {
        return new VScript.rwKeyword(this, "srcs_multiviewers_heads", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get srcs_s_d_i() {
        return new VScript.rwKeyword(this, "srcs_s_d_i", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get srcs_per_node_s_d_i() {
        return new VScript.rwKeyword(this, "srcs_per_node_s_d_i", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get outs_per_node_s_d_i() {
        return new VScript.rwKeyword(this, "outs_per_node_s_d_i", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ClusterGlobalParameters {
    raw;
    type_identifier = "Cluster::Data::ClusterGlobalParameters";
    constructor(raw) {
        this.raw = raw;
    }
    get addresses() {
        return VAPI.Cluster.lift.ClusterGlobalAddressesParameters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "addresses"));
    }
    get routing() {
        return VAPI.Cluster.lift.ClusterGlobalRoutingParameters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "routing"));
    }
    get offsets() {
        return VAPI.Cluster.lift.ClusterGlobalOffsetstParameters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "offsets"));
    }
    get monitoring_objects() {
        return VAPI.ClusterMonitoringObjects.lift.ClusterGlobalMonitoringObjectsParameters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "monitoring_objects"));
    }
    get misc() {
        return VAPI.Cluster.lift.ClusterGlobalMiscParameters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "misc"));
    }
    get master_redundancy() {
        return VAPI.Cluster.lift.ClusterGlobalMasterRedundancyParameters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "master_redundancy"));
    }
}
export class ClusterGlobalRoutingParameters {
    raw;
    type_identifier = "Cluster::Data::ClusterGlobalRoutingParameters";
    constructor(raw) {
        this.raw = raw;
    }
    get mipmaps_ins_ports() {
        return new VScript.rwKeyword(this, "mipmaps_ins_ports", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get mipmaps_outs_ports() {
        return new VScript.rwKeyword(this, "mipmaps_outs_ports", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get ip_srcs_ports() {
        return new VScript.rwKeyword(this, "ip_srcs_ports", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get ip_outs_ports() {
        return new VScript.rwKeyword(this, "ip_outs_ports", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get mipmaps_outs_throttle_pause() {
        return new VScript.rwKeyword(this, "mipmaps_outs_throttle_pause", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ClusterStatistics {
    raw;
    type_identifier = "Cluster::Data::ClusterStatistics";
    constructor(raw) {
        this.raw = raw;
    }
    get prev_sync_length() {
        return new VScript.rKeyword(this, "prev_sync_length", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get prev_sync_kwls() {
        return new VScript.rKeyword(this, "prev_sync_kwls", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get prev_sync_tables() {
        return new VScript.rKeyword(this, "prev_sync_tables", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export const Enums = {
    IPADDRESSINCREMENT: ["X_X_1_1", "X_1_1_X", "X_1_X_1", "X_RL_1_1"]
};
