import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly ClusterNodeGlobalConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterNodes.ClusterNodeGlobalConfiguration;
    readonly ClusterNodeGlobalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterNodes.ClusterNodeGlobalRuntime;
    readonly ClusterNodeGlobalRuntimeConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterNodes.ClusterNodeGlobalRuntimeConfiguration;
    readonly ClusterNodeGlobalRuntimeMcastCtrlStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics;
    readonly ClusterNodeGlobalRuntimeStreamingPortConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterNodes.ClusterNodeGlobalRuntimeStreamingPortConfiguration;
    readonly ClusterNodePortEgress: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterNodes.ClusterNodePortEgress;
    readonly ClusterNodePortIngress: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterNodes.ClusterNodePortIngress;
    readonly ClusterNodePortLLDPInfo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterNodes.ClusterNodePortLLDPInfo;
};
export declare const lower: {
    readonly ClusterNodeGlobalConfiguration: (_x: ClusterNodeGlobalConfiguration) => string;
    readonly ClusterNodeGlobalRuntime: (_x: ClusterNodeGlobalRuntime) => string;
    readonly ClusterNodeGlobalRuntimeConfiguration: (_x: ClusterNodeGlobalRuntimeConfiguration) => string;
    readonly ClusterNodeGlobalRuntimeMcastCtrlStatistics: (_x: ClusterNodeGlobalRuntimeMcastCtrlStatistics) => string;
    readonly ClusterNodeGlobalRuntimeStreamingPortConfiguration: (_x: ClusterNodeGlobalRuntimeStreamingPortConfiguration) => string;
    readonly ClusterNodePortEgress: (_x: ClusterNodePortEgress) => string;
    readonly ClusterNodePortIngress: (_x: ClusterNodePortIngress) => string;
    readonly ClusterNodePortLLDPInfo: (_x: ClusterNodePortLLDPInfo) => string;
};
export declare class ClusterNodeGlobalConfiguration implements VScript.Referenceable<"ClusterNodes::Data::ClusterNodeGlobalConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterNodes::Data::ClusterNodeGlobalConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get mode(): VScript.rwKeyword<VScript.VSocket, VAPI.ClusterNodes.NODEMODE, VAPI.ClusterNodes.NODEMODE, VAPI.ClusterNodes.NODEMODE, VAPI.ClusterNodes.NODEMODE, VAPI.ClusterNodes.ClusterNodeGlobalConfiguration>;
    /**
      IP address of the cluster node control
    */
    get ctrl_ip_address(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | string, null | string, VAPI.ClusterNodes.ClusterNodeGlobalConfiguration>;
    get route_outputs_enable(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.ClusterNodes.ClusterNodeGlobalConfiguration>;
}
export declare class ClusterNodeGlobalConfigurationAsNamedTableRow extends ClusterNodeGlobalConfiguration {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export declare class ClusterNodeGlobalRuntime implements VScript.Referenceable<"ClusterNodes::Data::ClusterNodeGlobalRuntime"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterNodes::Data::ClusterNodeGlobalRuntime";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get connection_status(): VScript.rKeyword<VScript.VSocket, VAPI.ClusterNodes.NODECONNECTIONSTATUS, VAPI.ClusterNodes.NODECONNECTIONSTATUS, VAPI.ClusterNodes.ClusterNodeGlobalRuntime>;
    get multicast_connection_status(): VScript.rKeyword<VScript.VSocket, VAPI.ClusterNodes.NODECONNECTIONSTATUS, VAPI.ClusterNodes.NODECONNECTIONSTATUS, VAPI.ClusterNodes.ClusterNodeGlobalRuntime>;
    get configuration(): VAPI.ClusterNodes.ClusterNodeGlobalRuntimeConfiguration;
    get routed_sources(): VAPI.ClusterSources.ClusterSourcesLocalRuntime;
    get routed_processors(): VAPI.ClusterProcessors.ClusterProcessorsLocalConfiguration;
    get streaming_ports(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterNodes::Data::ClusterNodeGlobalRuntimeStreamingPortConfiguration", VAPI.ClusterNodes.ClusterNodeGlobalRuntimeStreamingPortConfiguration>;
    get mcast_ctrl_sequence_number_error(): VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics;
}
export declare class ClusterNodeGlobalRuntimeConfiguration implements VScript.Referenceable<"ClusterNodes::Data::ClusterNodeGlobalRuntimeConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterNodes::Data::ClusterNodeGlobalRuntimeConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get sdi_inputs_num(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeConfiguration>;
    get sdi_outputs_num(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeConfiguration>;
    get mipmaps_dual_input_stages_num(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeConfiguration>;
}
export declare class ClusterNodeGlobalRuntimeMcastCtrlStatistics implements VScript.Referenceable<"ClusterNodes::Data::ClusterNodeGlobalRuntimeMcastCtrlStatistics"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterNodes::Data::ClusterNodeGlobalRuntimeMcastCtrlStatistics";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get video_alarms(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics>;
    get video_standard(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics>;
    get video_mip_maps_src_i_p_addresses(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics>;
    get video_tally(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics>;
    get video_lifeness(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics>;
    get video_routing(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics>;
    get audio_alarms(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics>;
    get audio_p_p_ms(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics>;
    get audio_tally(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics>;
    get audio_lifeness(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics>;
    get metadata_alarms(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics>;
    get metadata_lifeness(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics>;
    get metadata_time_code(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics>;
    get metadata_closed_caption(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics>;
    /**
      Clear
    */
    get clear(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeMcastCtrlStatistics>;
}
export declare class ClusterNodeGlobalRuntimeStreamingPortConfiguration implements VScript.Referenceable<"ClusterNodes::Data::ClusterNodeGlobalRuntimeStreamingPortConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterNodes::Data::ClusterNodeGlobalRuntimeStreamingPortConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get max_bandwidth(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeStreamingPortConfiguration>;
    /**
      Streaming Port IP address
    */
    get ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.ClusterNodes.ClusterNodeGlobalRuntimeStreamingPortConfiguration>;
    get lldp_info(): VAPI.ClusterNodes.ClusterNodePortLLDPInfo;
    get ingress(): VAPI.ClusterNodes.ClusterNodePortIngress;
    get egress(): VAPI.ClusterNodes.ClusterNodePortEgress;
}
export declare class ClusterNodePortEgress implements VScript.Referenceable<"ClusterNodes::Data::ClusterNodePortEgress"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterNodes::Data::ClusterNodePortEgress";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get video(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterSources::Data::ClusterVideoSourceID", VAPI.ClusterSources.ClusterVideoSourceID>;
}
export declare class ClusterNodePortIngress implements VScript.Referenceable<"ClusterNodes::Data::ClusterNodePortIngress"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterNodes::Data::ClusterNodePortIngress";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get video(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterSources::Data::ClusterVideoSourceID", VAPI.ClusterSources.ClusterVideoSourceID>;
    get audio(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterSources::Data::ClusterAudioSourceID", VAPI.ClusterSources.ClusterAudioSourceID>;
    get metadata(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterSources::Data::ClusterMetadataSourceID", VAPI.ClusterSources.ClusterMetadataSourceID>;
}
export declare class ClusterNodePortLLDPInfo implements VScript.Referenceable<"ClusterNodes::Data::ClusterNodePortLLDPInfo"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterNodes::Data::ClusterNodePortLLDPInfo";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      MAC address, stored in big-endian order.
    */
    get chassis_id(): VScript.rKeyword<VScript.VSocket, Array<number>, VAPI.NetworkInterfaces.MacAddress, VAPI.ClusterNodes.ClusterNodePortLLDPInfo>;
    /**
      MAC address, stored in big-endian order.
    */
    get port_id(): VScript.rKeyword<VScript.VSocket, Array<number>, VAPI.NetworkInterfaces.MacAddress, VAPI.ClusterNodes.ClusterNodePortLLDPInfo>;
    get interface_name(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.ClusterNodes.ClusterNodePortLLDPInfo>;
}
export type NODECONNECTIONSTATUS = "CONNECTED" | "DISCONNECTED";
export type NODEMODE = "MASTER" | "SLAVE";
export declare const Enums: {
    readonly NODEMODE: NODEMODE[];
    readonly NODECONNECTIONSTATUS: NODECONNECTIONSTATUS[];
};
