import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    ClusterIPOutputConfiguration: (_raw) => (new ClusterIPOutputConfiguration(_raw)),
    ClusterOutputsGlobalConfiguration: (_raw) => (new ClusterOutputsGlobalConfiguration(_raw)),
    ClusterOutputsGlobalRuntime: (_raw) => (new ClusterOutputsGlobalRuntime(_raw)),
    ClusterSDIOutputCrossbar: (_raw) => (new ClusterSDIOutputCrossbar(_raw)),
};
export const lower = {
    ClusterIPOutputConfiguration: (_x) => _x.raw.kwl,
    ClusterOutputsGlobalConfiguration: (_x) => _x.raw.kwl,
    ClusterOutputsGlobalRuntime: (_x) => _x.raw.kwl,
    ClusterSDIOutputCrossbar: (_x) => _x.raw.kwl,
};
export class ClusterIPOutputConfiguration {
    raw;
    type_identifier = "ClusterOutputs::Data::ClusterIPOutputConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get sdp() {
        return new VScript.rKeyword(this, "sdp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class ClusterOutputsGlobalConfiguration {
    raw;
    type_identifier = "ClusterOutputs::Data::ClusterOutputsGlobalConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get sdi() {
        return VAPI.ClusterOutputs.lift.ClusterSDIOutputCrossbar(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "sdi"));
    }
}
export class ClusterOutputsGlobalRuntime {
    raw;
    type_identifier = "ClusterOutputs::Data::ClusterOutputsGlobalRuntime";
    constructor(raw) {
        this.raw = raw;
    }
    get ip() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "ip"), (raw, _) => VAPI.ClusterOutputs.lift.ClusterIPOutputConfiguration(raw));
    }
}
export class ClusterSDIOutputCrossbar {
    raw;
    type_identifier = "ClusterOutputs::Data::ClusterSDIOutputCrossbar";
    constructor(raw) {
        this.raw = raw;
    }
    get crossbar() {
        return new VScript.rwKeyword(this, "crossbar", {
            lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
            lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
        }, {
            lift: VScript.VAPIHelpers.liftMaybeSparseArray((x /* FIXME */, _) => x),
            lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
        }, null);
    }
}
