import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    ClusterAudioSourceID: (_raw) => (new ClusterAudioSourceID(_raw)),
    ClusterAudioSourceLocalConfiguration: (_raw) => (new ClusterAudioSourceLocalConfiguration(_raw)),
    ClusterIPSourceConfiguration: (_raw) => (new ClusterIPSourceConfiguration(_raw)),
    ClusterIPSourcesGlobalConfiguration: (_raw) => (new ClusterIPSourcesGlobalConfiguration(_raw)),
    ClusterMetadataSourceCC: (_raw) => (new ClusterMetadataSourceCC(_raw)),
    ClusterMetadataSourceID: (_raw) => (new ClusterMetadataSourceID(_raw)),
    ClusterMetadataSourceLocalConfiguration: (_raw) => (new ClusterMetadataSourceLocalConfiguration(_raw)),
    ClusterSourceLabelDual: (_raw) => (new ClusterSourceLabelDual(_raw)),
    ClusterSourcesGlobalConfiguration: (_raw) => (new ClusterSourcesGlobalConfiguration(_raw)),
    ClusterSourcesLocalRuntime: (_raw) => (new ClusterSourcesLocalRuntime(_raw)),
    ClusterVideoSourceID: (_raw) => (new ClusterVideoSourceID(_raw)),
    ClusterVideoSourceIDInfo: (_raw, _socket) => {
        return {
            source_id: _raw[0],
            rl_mask: _raw[1]
        };
    },
    ClusterVideoSourceLocalConfiguration: (_raw) => (new ClusterVideoSourceLocalConfiguration(_raw)),
    ClusterVideoSourceRuntimeResolutionLevel: (_raw) => (new ClusterVideoSourceRuntimeResolutionLevel(_raw)),
    TimestampedTimecode: (_raw, _socket) => {
        return {
            ltc: _raw[0] === null ? null : _raw[0],
            vtc1: _raw[1] === null ? null : _raw[1],
            vtc2: _raw[2] === null ? null : _raw[2]
        };
    },
};
export const lower = {
    ClusterAudioSourceID: (_x) => _x.raw.kwl,
    ClusterAudioSourceLocalConfiguration: (_x) => _x.raw.kwl,
    ClusterIPSourceConfiguration: (_x) => _x.raw.kwl,
    ClusterIPSourcesGlobalConfiguration: (_x) => _x.raw.kwl,
    ClusterMetadataSourceCC: (_x) => _x.raw.kwl,
    ClusterMetadataSourceID: (_x) => _x.raw.kwl,
    ClusterMetadataSourceLocalConfiguration: (_x) => _x.raw.kwl,
    ClusterSourceLabelDual: (_x) => _x.raw.kwl,
    ClusterSourcesGlobalConfiguration: (_x) => _x.raw.kwl,
    ClusterSourcesLocalRuntime: (_x) => _x.raw.kwl,
    ClusterVideoSourceID: (_x) => _x.raw.kwl,
    ClusterVideoSourceIDInfo: (_x, _socket) => [
        _x.source_id,
        _x.rl_mask
    ],
    ClusterVideoSourceLocalConfiguration: (_x) => _x.raw.kwl,
    ClusterVideoSourceRuntimeResolutionLevel: (_x) => _x.raw.kwl,
    TimestampedTimecode: (_x, _socket) => [
        _x.ltc === null ? null : _x.ltc,
        _x.vtc1 === null ? null : _x.vtc1,
        _x.vtc2 === null ? null : _x.vtc2
    ],
};
export class ClusterAudioSourceID {
    raw;
    type_identifier = "ClusterSources::Data::ClusterAudioSourceID";
    constructor(raw) {
        this.raw = raw;
    }
    get source_id() {
        return new VScript.rKeyword(this, "source_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class ClusterAudioSourceLocalConfiguration {
    raw;
    type_identifier = "ClusterSources::Data::ClusterAudioSourceLocalConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get source_id() {
        return new VScript.rwKeyword(this, "source_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ClusterAudioSourceLocalConfigurationAsNamedTableRow extends ClusterAudioSourceLocalConfiguration {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export class ClusterIPSourceConfiguration {
    raw;
    type_identifier = "ClusterSources::Data::ClusterIPSourceConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get sdp() {
        return new VScript.rwKeyword(this, "sdp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ClusterIPSourceConfigurationAsNamedTableRow extends ClusterIPSourceConfiguration {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export class ClusterIPSourcesGlobalConfiguration {
    raw;
    type_identifier = "ClusterSources::Data::ClusterIPSourcesGlobalConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get video() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "video"), (raw) => new VAPI.ClusterSources.ClusterIPSourceConfigurationAsNamedTableRow(raw));
    }
    get audio() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "audio"), (raw) => new VAPI.ClusterSources.ClusterIPSourceConfigurationAsNamedTableRow(raw));
    }
    get metadata() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 2, "metadata"), (raw) => new VAPI.ClusterSources.ClusterIPSourceConfigurationAsNamedTableRow(raw));
    }
}
export class ClusterMetadataSourceCC {
    raw;
    type_identifier = "ClusterSources::Data::ClusterMetadataSourceCC";
    constructor(raw) {
        this.raw = raw;
    }
    get screen() {
        return new VScript.rKeyword(this, "screen", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class ClusterMetadataSourceID {
    raw;
    type_identifier = "ClusterSources::Data::ClusterMetadataSourceID";
    constructor(raw) {
        this.raw = raw;
    }
    get source_id() {
        return new VScript.rKeyword(this, "source_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class ClusterMetadataSourceLocalConfiguration {
    raw;
    type_identifier = "ClusterSources::Data::ClusterMetadataSourceLocalConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get source_id() {
        return new VScript.rwKeyword(this, "source_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ClusterMetadataSourceLocalConfigurationAsNamedTableRow extends ClusterMetadataSourceLocalConfiguration {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export class ClusterSourceLabelDual {
    raw;
    type_identifier = "ClusterSources::Data::ClusterSourceLabelDual";
    constructor(raw) {
        this.raw = raw;
    }
    get string_default() {
        return new VScript.rwKeyword(this, "string_default", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get string_user() {
        return new VScript.rwKeyword(this, "string_user", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ClusterSourcesGlobalConfiguration {
    raw;
    type_identifier = "ClusterSources::Data::ClusterSourcesGlobalConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get ip() {
        return VAPI.ClusterSources.lift.ClusterIPSourcesGlobalConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "ip"));
    }
}
export class ClusterSourcesLocalRuntime {
    raw;
    type_identifier = "ClusterSources::Data::ClusterSourcesLocalRuntime";
    constructor(raw) {
        this.raw = raw;
    }
    get video() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "video"), (raw) => new VAPI.ClusterSources.ClusterVideoSourceLocalConfigurationAsNamedTableRow(raw));
    }
    get audio() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "audio"), (raw) => new VAPI.ClusterSources.ClusterAudioSourceLocalConfigurationAsNamedTableRow(raw));
    }
    get metadata() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 2, "metadata"), (raw) => new VAPI.ClusterSources.ClusterMetadataSourceLocalConfigurationAsNamedTableRow(raw));
    }
    get video_full_size() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 3, "video_full_size"), (raw) => new VAPI.ClusterSources.ClusterVideoSourceLocalConfigurationAsNamedTableRow(raw));
    }
}
export class ClusterVideoSourceID {
    raw;
    type_identifier = "ClusterSources::Data::ClusterVideoSourceID";
    constructor(raw) {
        this.raw = raw;
    }
    get info() {
        return new VScript.rKeyword(this, "info", {
            lift: VAPI.ClusterSources.lift.ClusterVideoSourceIDInfo,
            lower: VAPI.ClusterSources.lower.ClusterVideoSourceIDInfo
        });
    }
}
export class ClusterVideoSourceLocalConfiguration {
    raw;
    type_identifier = "ClusterSources::Data::ClusterVideoSourceLocalConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get source_id() {
        return new VScript.rwKeyword(this, "source_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ClusterVideoSourceLocalConfigurationAsNamedTableRow extends ClusterVideoSourceLocalConfiguration {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export class ClusterVideoSourceRuntimeResolutionLevel {
    raw;
    type_identifier = "ClusterSources::Data::ClusterVideoSourceRuntimeResolutionLevel";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Destination IP address of the mipmap RTP stream
    */
    get dest_ip_address() {
        return new VScript.rKeyword(this, "dest_ip_address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    /**
      Destination IP address of the mipmap RTP stream
    */
    get secondary_dest_ip_address() {
        return new VScript.rKeyword(this, "secondary_dest_ip_address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get width() {
        return new VScript.rKeyword(this, "width", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get height() {
        return new VScript.rKeyword(this, "height", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get bytes_per_second() {
        return new VScript.rKeyword(this, "bytes_per_second", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get sdp() {
        return new VScript.rKeyword(this, "sdp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export const Enums = {
    SourceTransportFormat: ["IP_2022", "IP_2110", "SDI", "INTERNAL", "EXTERNAL_MIPMAPS"],
    Ports: ["PORT_1", "PORT_2", "PORTS_ALL_SPS", "PORTS_ALL"]
};
