import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly ColorSpaceInfo: (_raw: [VAPI.Video.ColorSpace, VAPI.Video.ColorSpace, VAPI.ColorCorrection.LutRange, VAPI.ColorCorrection.LutRange], _socket: VScript.VSocket) => ColorSpaceInfo;
    readonly LutComponent: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ColorCorrection.LutComponent;
    readonly ProcAmpComponent: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ColorCorrection.ProcAmpComponent;
    readonly YUV: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ColorCorrection.YUV;
    readonly CC3DLutInfo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ColorCorrection.CC3DLutInfo;
    readonly CC1DRgb: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ColorCorrection.CC1DRgb;
};
export declare const lower: {
    readonly ColorSpaceInfo: (_x: {
        input_cs: VAPI.Video.ColorSpace;
        output_cs: VAPI.Video.ColorSpace;
        lut_input_range: VAPI.ColorCorrection.LutRange;
        lut_output_range: VAPI.ColorCorrection.LutRange;
    }, _socket: VScript.VSocket) => [VAPI.Video.ColorSpace, VAPI.Video.ColorSpace, VAPI.ColorCorrection.LutRange, VAPI.ColorCorrection.LutRange];
    readonly LutComponent: (_x: LutComponent) => string;
    readonly ProcAmpComponent: (_x: ProcAmpComponent) => string;
    readonly YUV: (_x: YUV) => string;
    readonly CC3DLutInfo: (_x: CC3DLutInfo) => string;
    readonly CC1DRgb: (_x: CC1DRgb) => string;
};
export type ColorSchema = "BRIGHTNESS_CONTRAST" | "BLACK_GAIN";
export interface ColorSpaceInfo {
    input_cs: VAPI.Video.ColorSpace;
    output_cs: VAPI.Video.ColorSpace;
    lut_input_range: VAPI.ColorCorrection.LutRange;
    lut_output_range: VAPI.ColorCorrection.LutRange;
}
export declare class LutComponent implements VScript.Referenceable<"ColorCorrection::Data::LutComponent"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ColorCorrection::Data::LutComponent";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      in BLACK_GAIN mode this parameter is the black value
    */
    get brightness(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.ColorCorrection.LutComponent>;
    /**
      in BLACK_GAIN mode this parameter is ignored
    */
    get contrast(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.ColorCorrection.LutComponent>;
    /**
      in BRIGHTNESS_CONTRAST mode this parameter is ignored
    */
    get gain(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.ColorCorrection.LutComponent>;
    get gamma(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.ColorCorrection.LutComponent>;
}
export type LutRange = "NORMAL" | "EXTENDED";
export type OffGamut = "CLIP_TO_0" | "SYMMETRIC" | "LINEAR";
export declare class ProcAmpComponent implements VScript.Referenceable<"ColorCorrection::Data::ProcAmpComponent"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ColorCorrection::Data::ProcAmpComponent";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      in BLACK_GAIN mode this parameter is the black value
    */
    get brightness(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.ColorCorrection.ProcAmpComponent>;
    /**
      in BLACK_GAIN mode this parameter is ignored
    */
    get contrast(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.ColorCorrection.ProcAmpComponent>;
    /**
      in BRIGHTNESS_CONTRAST mode this parameter is ignored
    */
    get gain(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.ColorCorrection.ProcAmpComponent>;
}
export declare class YUV implements VScript.Referenceable<"ColorCorrection::Data::YUV"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ColorCorrection::Data::YUV";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get active(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.ColorCorrection.YUV>;
    get hue_offset(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.ColorCorrection.YUV>;
    get saturation(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.ColorCorrection.YUV>;
    get y(): VAPI.ColorCorrection.ProcAmpComponent;
    get cb(): VAPI.ColorCorrection.ProcAmpComponent;
    get cr(): VAPI.ColorCorrection.ProcAmpComponent;
}
export type CC1DIssues = {
    missing_input_mapper: boolean;
    no_hw_resources_available: boolean;
    no_uhd_resources_allocated: boolean;
};
export type CC3DIssues = {
    missing_input_mapper: boolean;
    no_hw_resources_available: boolean;
    no_uhd_resources_allocated: boolean;
};
export declare class CC3DLutInfo implements VScript.Referenceable<"ColorCorrection::Data::CC3D::LutInfo"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ColorCorrection::Data::CC3D::LutInfo";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get title(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.ColorCorrection.CC3DLutInfo>;
    get comments(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.ColorCorrection.CC3DLutInfo>;
    get colorspace(): VScript.rKeyword<VScript.VSocket, null | [
        VAPI.Video.ColorSpace,
        VAPI.Video.ColorSpace,
        VAPI.ColorCorrection.LutRange,
        VAPI.ColorCorrection.LutRange
    ], null | VAPI.ColorCorrection.ColorSpaceInfo, VAPI.ColorCorrection.CC3DLutInfo>;
}
export declare class CC1DRgb implements VScript.Referenceable<"ColorCorrection::Data::CC1D::Rgb"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ColorCorrection::Data::CC1D::Rgb";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get active(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.ColorCorrection.CC1DRgb>;
    get off_gamut(): VScript.rwKeyword<VScript.VSocket, VAPI.ColorCorrection.OffGamut, VAPI.ColorCorrection.OffGamut, VAPI.ColorCorrection.OffGamut, VAPI.ColorCorrection.OffGamut, VAPI.ColorCorrection.CC1DRgb>;
    get global(): VAPI.ColorCorrection.LutComponent;
    get red(): VAPI.ColorCorrection.LutComponent;
    get green(): VAPI.ColorCorrection.LutComponent;
    get blue(): VAPI.ColorCorrection.LutComponent;
}
export declare const Enums: {
    readonly OffGamut: OffGamut[];
    readonly LutRange: LutRange[];
    readonly ColorSchema: ColorSchema[];
};
