import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    ColorSpaceInfo: (_raw, _socket) => {
        return {
            input_cs: _raw[0],
            output_cs: _raw[1],
            lut_input_range: _raw[2],
            lut_output_range: _raw[3]
        };
    },
    LutComponent: (_raw) => (new LutComponent(_raw)),
    ProcAmpComponent: (_raw) => (new ProcAmpComponent(_raw)),
    YUV: (_raw) => (new YUV(_raw)),
    CC3DLutInfo: (_raw) => (new CC3DLutInfo(_raw)),
    CC1DRgb: (_raw) => (new CC1DRgb(_raw)),
};
export const lower = {
    ColorSpaceInfo: (_x, _socket) => [
        _x.input_cs,
        _x.output_cs,
        _x.lut_input_range,
        _x.lut_output_range
    ],
    LutComponent: (_x) => _x.raw.kwl,
    ProcAmpComponent: (_x) => _x.raw.kwl,
    YUV: (_x) => _x.raw.kwl,
    CC3DLutInfo: (_x) => _x.raw.kwl,
    CC1DRgb: (_x) => _x.raw.kwl,
};
export class LutComponent {
    raw;
    type_identifier = "ColorCorrection::Data::LutComponent";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      in BLACK_GAIN mode this parameter is the black value
    */
    get brightness() {
        return new VScript.rwKeyword(this, "brightness", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      in BLACK_GAIN mode this parameter is ignored
    */
    get contrast() {
        return new VScript.rwKeyword(this, "contrast", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      in BRIGHTNESS_CONTRAST mode this parameter is ignored
    */
    get gain() {
        return new VScript.rwKeyword(this, "gain", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get gamma() {
        return new VScript.rwKeyword(this, "gamma", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ProcAmpComponent {
    raw;
    type_identifier = "ColorCorrection::Data::ProcAmpComponent";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      in BLACK_GAIN mode this parameter is the black value
    */
    get brightness() {
        return new VScript.rwKeyword(this, "brightness", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      in BLACK_GAIN mode this parameter is ignored
    */
    get contrast() {
        return new VScript.rwKeyword(this, "contrast", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      in BRIGHTNESS_CONTRAST mode this parameter is ignored
    */
    get gain() {
        return new VScript.rwKeyword(this, "gain", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class YUV {
    raw;
    type_identifier = "ColorCorrection::Data::YUV";
    constructor(raw) {
        this.raw = raw;
    }
    get active() {
        return new VScript.dKeyword(this, "active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get hue_offset() {
        return new VScript.rwKeyword(this, "hue_offset", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get saturation() {
        return new VScript.rwKeyword(this, "saturation", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get y() {
        return VAPI.ColorCorrection.lift.ProcAmpComponent(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "y"));
    }
    get cb() {
        return VAPI.ColorCorrection.lift.ProcAmpComponent(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "cb"));
    }
    get cr() {
        return VAPI.ColorCorrection.lift.ProcAmpComponent(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "cr"));
    }
}
export class CC3DLutInfo {
    raw;
    type_identifier = "ColorCorrection::Data::CC3D::LutInfo";
    constructor(raw) {
        this.raw = raw;
    }
    get title() {
        return new VScript.rKeyword(this, "title", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get comments() {
        return new VScript.rKeyword(this, "comments", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get colorspace() {
        return new VScript.rKeyword(this, "colorspace", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.ColorCorrection.lift.ColorSpaceInfo),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.ColorCorrection.lower.ColorSpaceInfo)
        });
    }
}
export class CC1DRgb {
    raw;
    type_identifier = "ColorCorrection::Data::CC1D::Rgb";
    constructor(raw) {
        this.raw = raw;
    }
    get active() {
        return new VScript.dKeyword(this, "active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get off_gamut() {
        return new VScript.rwKeyword(this, "off_gamut", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get global() {
        return VAPI.ColorCorrection.lift.LutComponent(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "global"));
    }
    get red() {
        return VAPI.ColorCorrection.lift.LutComponent(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "red"));
    }
    get green() {
        return VAPI.ColorCorrection.lift.LutComponent(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "green"));
    }
    get blue() {
        return VAPI.ColorCorrection.lift.LutComponent(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "blue"));
    }
}
export const Enums = {
    OffGamut: ["CLIP_TO_0", "SYMMETRIC", "LINEAR"],
    LutRange: ["NORMAL", "EXTENDED"],
    ColorSchema: ["BRIGHTNESS_CONTRAST", "BLACK_GAIN"]
};
