import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    BncMode: (_raw) => (new BncMode(_raw)),
    Constraints: (_raw) => (new Constraints(_raw)),
    EyeShape: (_raw, _socket) => {
        return {
            width: _raw[0] === null ? null : _raw[0],
            height: _raw[1] === null ? null : _raw[1]
        };
    },
    MADIOutput: (_raw) => (new MADIOutput(_raw)),
    BncModeBnc: (_raw) => (new BncModeBnc(_raw)),
    Configuration: (_raw) => (new Configuration(_raw)),
    MergerConnectedTo: (_raw) => (new MergerConnectedTo(_raw)),
};
export const lower = {
    BncMode: (_x) => _x.raw.kwl,
    Constraints: (_x) => _x.raw.kwl,
    EyeShape: (_x, _socket) => [
        _x.width === null ? null : _x.width,
        _x.height === null ? null : _x.height
    ],
    MADIOutput: (_x) => _x.raw.kwl,
    BncModeBnc: (_x) => _x.raw.kwl,
    Configuration: (_x) => _x.raw.kwl,
    MergerConnectedTo: (_x) => _x.raw.kwl,
};
export class BncMode {
    raw;
    type_identifier = "IOModule::Data::BncMode";
    constructor(raw) {
        this.raw = raw;
    }
    get version() {
        return new VScript.rKeyword(this, "version", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get bnc() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 1, "bnc"), (st, _) => VAPI.IOModule.lift.BncModeBnc(st));
    }
    get install_version() {
        return new VScript.rKeyword(this, "install_version", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class Constraints {
    raw;
    type_identifier = "IOModule::Data::Constraints";
    constructor(raw) {
        this.raw = raw;
    }
    get standard() {
        return new VScript.dKeyword(this, "standard", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
}
export class MADIOutput {
    raw;
    type_identifier = "IOModule::Data::MADIOutput";
    constructor(raw) {
        this.raw = raw;
    }
    get channels() {
        return new VScript.dKeyword(this, "channels", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class BncModeBnc {
    raw;
    type_identifier = "IOModule::Data::BncMode::Bnc";
    constructor(raw) {
        this.raw = raw;
    }
    get board() {
        return new VScript.rKeyword(this, "board", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get chip_type() {
        return new VScript.rKeyword(this, "chip_type", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get direction() {
        return new VScript.rKeyword(this, "direction", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get frequency() {
        return new VScript.rKeyword(this, "frequency", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class Configuration {
    raw;
    type_identifier = "IOModule::Data::Configuration";
    constructor(raw) {
        this.raw = raw;
    }
    get direction() {
        return new VScript.rwKeyword(this, "direction", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class MergerConnectedTo {
    raw;
    type_identifier = "IOModule::Data::Merger::ConnectedTo";
    constructor(raw) {
        this.raw = raw;
    }
    get inputs() {
        return new VScript.rKeyword(this, "inputs", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get input_identifier() {
        return new VScript.rKeyword(this, "input_identifier", {
            lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
        });
    }
}
export const Enums = {
    SyncOutputStandard: ["PAL", "NTSC", "HD720p50", "HD720p59_94", "HD720p60", "HD1080p23_98", "HD1080p24", "HD1080p25", "HD1080p29_97", "HD1080p30", "HD1080i50", "HD1080i59_94", "HD1080i60"],
    SDIMADIMode: ["SDI", "MADI"],
    MADIChannels: ["CH28", "CH32", "CH56", "CH64"],
    DecoderGroupPhyRxReady: ["ceNotReady", "ceReady"],
    DecoderGroupPhyRxLockedStatus: ["Unlocked", "LockedToRef", "LockedToData"],
    DecoderGroupPhyRxCalibrateBusy: ["cePhyRxNormal", "cePhyRxCalibrate"],
    ConfigDirection: ["Input", "Output"],
    ClosedCaptionDeembedMode: ["CEA708", "OP47"],
    BNCDirection: ["ceDisable", "ceIn", "ceOut", "ceInOut"],
    Audio12GMode: ["st299_2_stream_0", "st299_1_stream_0_1"]
};
