export const lift = {
    TimezoneOffset: (_raw, _socket) => {
        return { hours: _raw[0], minutes: _raw[1] };
    },
    GPSReceiverDate: (_raw, _socket) => {
        return {
            year: _raw[0],
            month: _raw[1],
            day: _raw[2]
        };
    },
    GPSReceiverTimeOfDay: (_raw, _socket) => {
        return {
            hours: _raw[0],
            minutes: _raw[1],
            seconds: _raw[2]
        };
    },
};
export const lower = {
    TimezoneOffset: (_x, _socket) => [
        _x.hours,
        _x.minutes
    ],
    GPSReceiverDate: (_x, _socket) => [
        _x.year,
        _x.month,
        _x.day
    ],
    GPSReceiverTimeOfDay: (_x, _socket) => [
        _x.hours,
        _x.minutes,
        _x.seconds
    ],
};
export const Enums = {
    Timezone: ["UTC", "UserDefined", "UTC_W_01_00_Azores", "UTC_W_02_00_MidAtlantic", "UTC_W_03_00_BuenosAires", "UTC_W_04_00_Halifax", "UTC_W_05_00_NewYork", "UTC_W_06_00_Chicago", "UTC_W_07_00_Denver", "UTC_W_08_00_LosAngeles", "UTC_W_09_00_Alaska", "UTC_W_10_00_Hawaii", "UTC_W_11_00_MidwayIsland", "UTC_W_12_00_Kwaialein", "UTC_E_12_00_NewZealand", "UTC_E_11_00_SolomonIslands", "UTC_E_10_00_Guam", "UTC_E_09_00_Tokyo", "UTC_E_08_00_Beijing", "UTC_E_07_00_Bangkok", "UTC_E_06_00_Dhaka", "UTC_E_05_00_Islamabad", "UTC_E_04_00_AbuDhabi", "UTC_E_03_00_Moscow", "UTC_E_02_00_EasternEurope", "UTC_E_01_00_CentralEurope", "UTC_W_00_30", "UTC_W_01_30", "UTC_W_02_30", "UTC_W_03_30_Newfoundland", "UTC_W_04_30", "UTC_W_05_30", "UTC_W_06_30", "UTC_W_07_30", "UTC_W_08_30", "UTC_W_09_30_MarquesaIslands", "UTC_W_10_30", "UTC_W_11_30", "UTC_E_11_30_NorfolkIsland", "UTC_E_10_30_LordHoweIsland", "UTC_E_09_30_Darwin", "UTC_E_08_30", "UTC_E_07_30", "UTC_E_06_30_Rangoon", "UTC_E_05_30_Bombay", "UTC_E_04_30_Kabul", "UTC_E_03_30_Tehran", "UTC_E_02_30", "UTC_E_01_30", "UTC_E_00_30", "UTC_E_12_45_ChathamIsland"],
    TimecodeRate: ["f24", "f25", "f29_97", "f30"]
};
