import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly Audio: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Monitoring.Audio;
    readonly Video: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Monitoring.Video;
    readonly VideoBlackDetect: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Monitoring.VideoBlackDetect;
    readonly AudioLoudnessChannels: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Monitoring.AudioLoudnessChannels;
};
export declare const lower: {
    readonly Audio: (_x: Audio) => string;
    readonly Video: (_x: Video) => string;
    readonly VideoBlackDetect: (_x: VideoBlackDetect) => string;
    readonly AudioLoudnessChannels: (_x: AudioLoudnessChannels) => string;
};
export declare class Audio implements VScript.Referenceable<"Monitoring::Data::Audio"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Monitoring::Data::Audio";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get active(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.Monitoring.Audio>;
    get silence_detect_duration(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.Monitoring.Audio>;
    get non_silence_detect_duration(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.Monitoring.Audio>;
    get detect_level(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.Monitoring.Audio>;
}
export type LoudnessMode = "DISABLED" | "MONO" | "STEREO" | "SURROUND_5_1" | "SURROUND_7_1";
export declare class Video implements VScript.Referenceable<"Monitoring::Data::Video"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Monitoring::Data::Video";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get active(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.Monitoring.Video>;
    get freeze_detect_duration(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.Monitoring.Video>;
    get black_detect(): VAPI.Monitoring.VideoBlackDetect;
}
export declare class VideoBlackDetect implements VScript.Referenceable<"Monitoring::Data::Video::BlackDetect"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Monitoring::Data::Video::BlackDetect";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Luminance threshold for black detect
    */
    get threshold_y(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.Monitoring.VideoBlackDetect>;
    /**
      Chrominance threshold for black detect
    */
    get threshold_c(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.Monitoring.VideoBlackDetect>;
    /**
      How many pixels can be above the threshold for black to be detected
    */
    get threshold_pixels(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.Monitoring.VideoBlackDetect>;
    /**
      How long the video must be black before it is signaled as black
    */
    get attack(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.Monitoring.VideoBlackDetect>;
    /**
      How long the video must be none black before it is signaled as not black
    */
    get release(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.Monitoring.VideoBlackDetect>;
}
export declare class AudioLoudnessChannels implements VScript.Referenceable<"Monitoring::Data::AudioLoudness::Channels"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Monitoring::Data::AudioLoudness::Channels";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get left(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.Monitoring.AudioLoudnessChannels>;
    get right(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.Monitoring.AudioLoudnessChannels>;
    get center(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.Monitoring.AudioLoudnessChannels>;
    get surround_left(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.Monitoring.AudioLoudnessChannels>;
    get surround_right(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.Monitoring.AudioLoudnessChannels>;
    get rear_surround_left(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.Monitoring.AudioLoudnessChannels>;
    get rear_surround_right(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.Monitoring.AudioLoudnessChannels>;
}
export declare const Enums: {
    readonly LoudnessMode: LoudnessMode[];
};
