import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly IGMPMembership: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.PCap.IGMPMembership;
    readonly MemoryRange: (_raw: [number, number, number], _socket: VScript.VSocket) => MemoryRange;
    readonly SrcDstPair: (_raw: [null | string, null | string], _socket: VScript.VSocket) => SrcDstPair;
    readonly ModeStore: (_raw: [], _socket: VScript.VSocket) => ModeStore;
};
export declare const lower: {
    readonly IGMPMembership: (_x: IGMPMembership) => string;
    readonly MemoryRange: (_x: {
        start: VAPI.PCap.MemoryAddress;
        stop: VAPI.PCap.MemoryAddress;
        fill_level: number;
    }, _socket: VScript.VSocket) => [number, number, number];
    readonly SrcDstPair: (_x: {
        src: null | string;
        dst: null | string;
    }, _socket: VScript.VSocket) => [null | string, null | string];
    readonly ModeStore: (_x: {}, _socket: VScript.VSocket) => [];
};
export type Delay = VScript.Duration;
export type FileFormat = "PCap" | "Raw";
export declare class IGMPMembership implements VScript.Referenceable<"PCap::Data::IGMPMembership"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "PCap::Data::IGMPMembership";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get addresses(): VScript.dKeyword<VScript.VSocket, [
        null | string,
        null | string
    ], [
        null | string,
        null | string
    ], VAPI.PCap.SrcDstPair, VAPI.PCap.SrcDstPair, VAPI.PCap.IGMPMembership>;
}
export declare class IGMPMembershipAsNamedTableRow extends IGMPMembership {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export type MemoryAddress = number;
/**
  Memory area currently holding valid pcap data
*/
export interface MemoryRange {
    start: VAPI.PCap.MemoryAddress;
    stop: VAPI.PCap.MemoryAddress;
    fill_level: number;
}
export interface SrcDstPair {
    src: null | string;
    dst: null | string;
}
export interface ModeStore {
}
export declare const Enums: {
    readonly FileFormat: FileFormat[];
};
