import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    IGMPMembership: (_raw) => (new IGMPMembership(_raw)),
    MemoryRange: (_raw, _socket) => {
        return {
            start: _raw[0],
            stop: _raw[1],
            fill_level: _raw[2]
        };
    },
    SrcDstPair: (_raw, _socket) => {
        return {
            src: _raw[0] === null ? null : _raw[0],
            dst: _raw[1] === null ? null : _raw[1]
        };
    },
    ModeStore: (_raw, _socket) => {
        return {};
    },
};
export const lower = {
    IGMPMembership: (_x) => _x.raw.kwl,
    MemoryRange: (_x, _socket) => [
        _x.start,
        _x.stop,
        _x.fill_level
    ],
    SrcDstPair: (_x, _socket) => [
        _x.src === null ? null : _x.src,
        _x.dst === null ? null : _x.dst
    ],
    ModeStore: (_x, _socket) => [],
};
export class IGMPMembership {
    raw;
    type_identifier = "PCap::Data::IGMPMembership";
    constructor(raw) {
        this.raw = raw;
    }
    get addresses() {
        return new VScript.dKeyword(this, "addresses", {
            lift: VAPI.PCap.lift.SrcDstPair,
            lower: VAPI.PCap.lower.SrcDstPair
        }, {
            lift: VAPI.PCap.lift.SrcDstPair,
            lower: VAPI.PCap.lower.SrcDstPair
        }, null);
    }
}
export class IGMPMembershipAsNamedTableRow extends IGMPMembership {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export const Enums = {
    FileFormat: ["PCap", "Raw"]
};
