import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    ClockQuality: (_raw, _socket) => {
        return {
            clock_class: _raw[0],
            clock_accuracy: _raw[1],
            offset_scaled_log_variance: _raw[2]
        };
    },
    PortIdentity: (_raw, _socket) => {
        return {
            clock_identity: _raw[0].map(el => el),
            port_number: _raw[1]
        };
    },
    Traits: (_raw) => (new Traits(_raw)),
};
export const lower = {
    ClockQuality: (_x, _socket) => [
        _x.clock_class,
        _x.clock_accuracy,
        _x.offset_scaled_log_variance
    ],
    PortIdentity: (_x, _socket) => [
        _x.clock_identity.map(el => el),
        _x.port_number
    ],
    Traits: (_x) => _x.raw.kwl,
};
export class Traits {
    raw;
    type_identifier = "PTP::Data::Traits";
    constructor(raw) {
        this.raw = raw;
    }
    get domain() {
        return new VScript.rKeyword(this, "domain", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get alternate_master() {
        return new VScript.rKeyword(this, "alternate_master", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get leap61() {
        return new VScript.rKeyword(this, "leap61", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get leap59() {
        return new VScript.rKeyword(this, "leap59", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get ptp_timescale() {
        return new VScript.rKeyword(this, "ptp_timescale", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get traceability() {
        return new VScript.rKeyword(this, "traceability", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get utc_offset_seconds() {
        return new VScript.rKeyword(this, "utc_offset_seconds", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get source_type() {
        return new VScript.rKeyword(this, "source_type", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get port_identity() {
        return new VScript.rKeyword(this, "port_identity", {
            lift: VAPI.PTP.lift.PortIdentity,
            lower: VAPI.PTP.lower.PortIdentity
        });
    }
    get grandmaster_priority_1() {
        return new VScript.rKeyword(this, "grandmaster_priority_1", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get grandmaster_clock_quality() {
        return new VScript.rKeyword(this, "grandmaster_clock_quality", {
            lift: VAPI.PTP.lift.ClockQuality,
            lower: VAPI.PTP.lower.ClockQuality
        });
    }
    get grandmaster_priority_2() {
        return new VScript.rKeyword(this, "grandmaster_priority_2", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    /**
      ClockIdentity as defined by the PTP standard, stored in big-endian order.
    */
    get grandmaster_identity() {
        return new VScript.rKeyword(this, "grandmaster_identity", {
            lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
        });
    }
    get steps_removed() {
        return new VScript.rKeyword(this, "steps_removed", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export const Enums = {
    Traceability: ["NotTraceable", "FrequencyTraceable", "Traceable"],
    TimeScale: ["PTP", "Arbitrary"],
    SourceType: ["AtomicClock", "GPS", "TerrestrialRadio", "PTP", "NTP", "HandSet", "Other", "InternalOscillator", "ProfileSpecific", "Reserved"],
    ClockClass: ["Reserved", "SynchronizedToPrimary", "WasSynchronizedToPrimaryNowInHoldOver", "SynchronizedToAppSpecific", "WasSynchronizedToAppSpecificNowInHoldOver", "WasSynchronizedToPrimaryDegradAlternativeA", "WasSynchronizedToAppSpecificDegradAlternativeA", "ProfileSpecific", "WasSynchronizedToPrimaryDegradAlternativeB", "WasSynchronizedToAppSpecificDegradAlternativeB", "Default", "ReservedForV1Compatibility", "SlaveOnly"],
    ClockAccuracy: ["Reserved", "AccurateToWithin25ns", "AccurateToWithin100ns", "AccurateToWithin250ns", "AccurateToWithin1000ns", "AccurateToWithin2500ns", "AccurateToWithin10us", "AccurateToWithin25us", "AccurateToWithin100us", "AccurateToWithin250us", "AccurateToWithin1000us", "AccurateToWithin2500us", "AccurateToWithin10ms", "AccurateToWithin25ms", "AccurateToWithin100ms", "AccurateToWithin250ms", "AccurateToWithin1s", "AccurateToWithin10s", "AccuracyBelow10s", "ProfileSpecific", "Unknown"]
};
