import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    SlaveSettings: (_raw) => (new SlaveSettings(_raw)),
    AllGeneralSettings: (_raw) => (new AllGeneralSettings(_raw)),
    MasterSettingsGrandmaster: (_raw) => (new MasterSettingsGrandmaster(_raw)),
    AgentSlaveStatisticsInstantaneousEstimate: (_raw, _socket) => {
        return {
            type: _raw[0],
            slave_time: VScript.VAPIHelpers.liftTimestamp(_raw[1], _socket),
            master_time: VScript.VAPIHelpers.liftTimestamp(_raw[2], _socket),
            accepted: _raw[3]
        };
    },
    AgentMasterStatistics: (_raw) => (new AgentMasterStatistics(_raw)),
    AgentSlaveStatisticsOneWayDelay: (_raw, _socket) => {
        return {
            mean: VScript.VAPIHelpers.liftSeconds(_raw[0], _socket),
            error: VScript.VAPIHelpers.liftSeconds(_raw[1], _socket)
        };
    },
    AgentSlaveStatistics: (_raw) => (new AgentSlaveStatistics(_raw)),
};
export const lower = {
    SlaveSettings: (_x) => _x.raw.kwl,
    AllGeneralSettings: (_x) => _x.raw.kwl,
    MasterSettingsGrandmaster: (_x) => _x.raw.kwl,
    AgentSlaveStatisticsInstantaneousEstimate: (_x, _socket) => [
        _x.type,
        VScript.VAPIHelpers.lowerTimestamp(_x.slave_time, _socket),
        VScript.VAPIHelpers.lowerTimestamp(_x.master_time, _socket),
        _x.accepted
    ],
    AgentMasterStatistics: (_x) => _x.raw.kwl,
    AgentSlaveStatisticsOneWayDelay: (_x, _socket) => [
        VScript.VAPIHelpers.lowerSeconds(_x.mean, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.error, _socket)
    ],
    AgentSlaveStatistics: (_x) => _x.raw.kwl,
};
export class SlaveSettings {
    raw;
    type_identifier = "PTPFlows::Data::SlaveSettings";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      base-2 logarithm of the delay request interval in seconds. E.g., a
      setting of -3 will cause this agent to emit delay requests 8 times a
      second; 4 times a second if this is set to -2. Delay request intervals
      may not be shorter than the minimum delay request interval set by the
      currently active master.
    */
    get log2_delayreq_interval() {
        return new VScript.dKeyword(this, "log2_delayreq_interval", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get log2_master_sync_interval() {
        return new VScript.rKeyword(this, "log2_master_sync_interval", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    /**
      minimum delay request interval as set by the most recently received delay
      response message
    */
    get relative_min_log2_delayreq_interval() {
        return new VScript.rKeyword(this, "relative_min_log2_delayreq_interval", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    /**
      unlike sync and follow-up messages, which contain no client-dependent
      information and are thus useful to all clients within their PTP domain,
      delay request/response messages are useful only to the inquiring client
      (and perhaps to the master if it wishes to monitor its clients' timing
      properties). Exchanging these messages via unicast reduces both network
      traffic and local workload but yields otherwise identical results (this
      mode may also be called `Hybrid` on other products). If
      `delay_req_routing` is set to `Multicast`, this optimization is disabled
      and all delay requests emitted by this agent will be sent to the PTP
      multicast event address `224.0.1.129:319`
    */
    get delay_req_routing() {
        return new VScript.dKeyword(this, "delay_req_routing", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class AllGeneralSettings {
    raw;
    type_identifier = "PTPFlows::Data::All::GeneralSettings";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      remove visible masters if the time elapsed since their last Announce
      message exceeds *master_timeout*
    */
    get master_timeout() {
        return new VScript.dKeyword(this, "master_timeout", {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, null);
    }
    /**
      if `best_master_selection` is set to `Eager`, an incoming Announce
      message will immediately register its sender as the currently accepted
      PTP master if all previously registered masters are deemed inferior by
      the BMC algorithm. Conversely, if `Cautious` is selected, and if the
      PTPClock is currently calibrated, a previously selected PTP master will
      be retained until it times out
    */
    get best_master_selection() {
        return new VScript.rwKeyword(this, "best_master_selection", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      offload DelayResponse generation to hardware if supported by the
      currently active FPGA build
    */
    get hardware_offload() {
        return new VScript.dKeyword(this, "hardware_offload", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      if DelayResponse hardware offloading is available, delay requests will by
      default not be forwarded to the CPU. If you wish to do so to, e.g.,
      analyze incoming traffic using `tcpdump`, set this option to `false`
    */
    get absorb_delayrequests() {
        return new VScript.dKeyword(this, "absorb_delayrequests", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class MasterSettingsGrandmaster {
    raw;
    type_identifier = "PTPFlows::Data::MasterSettings::Grandmaster";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      this value will be used as `priority_1` if this agent is set to act as a
      PTP master
    */
    get priority_1() {
        return new VScript.dKeyword(this, "priority_1", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    /**
      this value will be used as `priority_2` if this agent is set to act as a
      PTP master
    */
    get priority_2() {
        return new VScript.dKeyword(this, "priority_2", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    /**
      this value will be used as `clock_quality` if this agent is set to act as
      a PTP master
    */
    get clock_quality() {
        return new VScript.dKeyword(this, "clock_quality", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.PTP.lift.ClockQuality),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.PTP.lower.ClockQuality)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.PTP.lift.ClockQuality),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.PTP.lower.ClockQuality)
        }, null);
    }
    /**
      ClockIdentity as defined by the PTP standard, stored in big-endian order.
    */
    get clock_identity() {
        return new VScript.rKeyword(this, "clock_identity", {
            lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
        });
    }
}
export class AgentMasterStatistics {
    raw;
    type_identifier = "PTPFlows::Data::Agent::MasterStatistics";
    constructor(raw) {
        this.raw = raw;
    }
    get num_announces_sent() {
        return new VScript.rKeyword(this, "num_announces_sent", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get num_syncs_sent() {
        return new VScript.rKeyword(this, "num_syncs_sent", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get num_followups_sent() {
        return new VScript.rKeyword(this, "num_followups_sent", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get num_delayreqs_received() {
        return new VScript.rKeyword(this, "num_delayreqs_received", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get num_delayresps_sent() {
        return new VScript.rKeyword(this, "num_delayresps_sent", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class AgentSlaveStatistics {
    raw;
    type_identifier = "PTPFlows::Data::Agent::SlaveStatistics";
    constructor(raw) {
        this.raw = raw;
    }
    get num_syncs_received() {
        return new VScript.rKeyword(this, "num_syncs_received", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get num_followups_received() {
        return new VScript.rKeyword(this, "num_followups_received", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      number of measurements performed on the basis of incoming sync/followup
      messages. May be smaller than the number of received sync messages due
      to, e.g., missing followup messages
    */
    get num_sync_measurements() {
        return new VScript.rKeyword(this, "num_sync_measurements", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      number of delay request messages handed off to the operating system. The
      actual number of transmitted messages may be lower in case of network
      configuration issues; check `num_delay_measurements` if you suspect this
      to be the case
    */
    get num_delayreqs_sent() {
        return new VScript.rKeyword(this, "num_delayreqs_sent", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get num_delayresps_received() {
        return new VScript.rKeyword(this, "num_delayresps_received", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      number of delay response messages considered for further processing. May
      be smaller than the number of received delay response messages due to,
      e.g., mismatching requesting source port identities (especially when
      operating in multicast routing mode)
    */
    get num_delayresps_considered() {
        return new VScript.rKeyword(this, "num_delayresps_considered", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      number of delay response messages that were considered for processing,
      but later discarded for other reasons
    */
    get num_delayresps_discarded() {
        return new VScript.rKeyword(this, "num_delayresps_discarded", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      number of measurements performed on the basis of delay request/response
      messages. May be both smaller than the number of dispatched delay request
      messages (perhaps due to network configuration issues), and smaller than
      the number of received delay response messages (especially when operating
      in multicast routing mode, where most incoming delay response messages
      are typically intended for other PTP clients)
    */
    get num_delay_measurements() {
        return new VScript.rKeyword(this, "num_delay_measurements", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get one_way_delay() {
        return new VScript.rKeyword(this, "one_way_delay", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.PTPFlows.lift.AgentSlaveStatisticsOneWayDelay),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.PTPFlows.lower.AgentSlaveStatisticsOneWayDelay)
        });
    }
    get estimated_jitter() {
        return new VScript.rKeyword(this, "estimated_jitter", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
        });
    }
    get publish_instantaneous_estimates() {
        return new VScript.rwKeyword(this, "publish_instantaneous_estimates", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get instantaneous_estimate() {
        return new VScript.rKeyword(this, "instantaneous_estimate", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.PTPFlows.lift.AgentSlaveStatisticsInstantaneousEstimate),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.PTPFlows.lower.AgentSlaveStatisticsInstantaneousEstimate)
        });
    }
}
export const Enums = {
    Routing: ["Unicast", "Multicast"],
    QualityAssessment: ["Convergent", "Normal", "Divergent", "None"],
    MessageType: ["Sync", "Delay_Req", "Pdelay_Req", "Pdelay_Resp", "Follow_Up", "Delay_Resp", "Pdelay_Resp_Follow_Up", "Announce", "Signaling", "Management", "Invalid"],
    MessageClass: ["Event", "General"],
    MeasurementFamily: ["SyncFollowUp", "DelayRespReq"]
};
