import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly ReadSpeedAdaptive: (_raw: [], _socket: VScript.VSocket) => ReadSpeedAdaptive;
    readonly PhaseControlSettingsAuto: (_raw: [], _socket: VScript.VSocket) => PhaseControlSettingsAuto;
    readonly JpegXsCaptureStateAwaitingCSCapture: (_raw: [], _socket: VScript.VSocket) => JpegXsCaptureStateAwaitingCSCapture;
    readonly JpegXsCaptureStateAwaitingCSCaptureTrigger: (_raw: [], _socket: VScript.VSocket) => JpegXsCaptureStateAwaitingCSCaptureTrigger;
    readonly SwitchTypeBreakBeforeMake: (_raw: [number | string], _socket: VScript.VSocket) => SwitchTypeBreakBeforeMake;
    readonly TimingTargetBufferMidpoint: (_raw: [], _socket: VScript.VSocket) => TimingTargetBufferMidpoint;
    readonly CapabilityRequestIDs: (_raw: [null | number, null | number], _socket: VScript.VSocket) => CapabilityRequestIDs;
    readonly CountableErrorHandler: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.CountableErrorHandler;
    readonly CurrentRedundancyLevels: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.CurrentRedundancyLevels;
    readonly Egress: (_raw: [Array<null | [boolean, null | number]>], _socket: VScript.VSocket) => Egress;
    readonly TimingTargetEgressPlusX: (_raw: [number], _socket: VScript.VSocket) => TimingTargetEgressPlusX;
    readonly ErrorCounter: (_raw: [null | number, number, number], _socket: VScript.VSocket) => ErrorCounter;
    readonly Expectations: (_raw: [boolean, [boolean, boolean]], _socket: VScript.VSocket) => Expectations;
    readonly FreezeState: (_raw: [boolean, null | number], _socket: VScript.VSocket) => FreezeState;
    readonly Ingress: (_raw: [VAPI.RTPReceiver.IngressTrackState, VAPI.RTPReceiver.IngressTrackState], _socket: VScript.VSocket) => Ingress;
    readonly TimingTargetIngressPlusX: (_raw: [number], _socket: VScript.VSocket) => TimingTargetIngressPlusX;
    readonly InternalBufferSizes: (_raw: [number, number, number, number, number, number], _socket: VScript.VSocket) => InternalBufferSizes;
    readonly JpegXsCaptureState: (_raw: ([0, []] | [1, []] | [2, [Array<number>]]), _socket: VScript.VSocket) => JpegXsCaptureState;
    readonly MPacket: (_raw: [number, number, number], _socket: VScript.VSocket) => MPacket;
    readonly MPacketDebugInfo: (_raw: [number, boolean, number, number, number, number, number, number], _socket: VScript.VSocket) => MPacketDebugInfo;
    readonly SwitchTypeMakeBeforeBreak: (_raw: [number | string], _socket: VScript.VSocket) => SwitchTypeMakeBeforeBreak;
    readonly PhaseControlSettingsManual: (_raw: [null | number, null | number, boolean, [boolean, number, number], null | [number, number], null | number], _socket: VScript.VSocket) => PhaseControlSettingsManual;
    readonly PacketTracerRun: (_raw: [number, number | string, number | string, number, number, number, number, number, number, VAPI.RTPReceiver.PacketTracerRunPacketDetails, VAPI.RTPReceiver.PacketTracerMode], _socket: VScript.VSocket) => PacketTracerRun;
    readonly SwitchTypePatch: (_raw: [], _socket: VScript.VSocket) => SwitchTypePatch;
    readonly PhaseControlSettings: (_raw: ([0, []] | [1, [null | number, null | number, boolean, [boolean, number, number], null | [number, number], null | number]]), _socket: VScript.VSocket) => PhaseControlSettings;
    readonly SingleVideoDecoderWorkingSet: (_raw: ([0, []] | [1, [([0, []] | [1, []] | [2, [Array<number>]]), number]]), _socket: VScript.VSocket) => SingleVideoDecoderWorkingSet;
    readonly SoftMetadataStatistics: (_raw: [number, number, number, number, number, number, number, number, number, number, number, number], _socket: VScript.VSocket) => SoftMetadataStatistics;
    readonly StatsID: (_raw: [number, number], _socket: VScript.VSocket) => StatsID;
    readonly JpegXsCaptureStateSteadyState: (_raw: [Array<number>], _socket: VScript.VSocket) => JpegXsCaptureStateSteadyState;
    readonly SwitchType: (_raw: ([0, []] | [1, [number | string]] | [2, [number | string]]), _socket: VScript.VSocket) => SwitchType;
    readonly TaggedNetworkSourceID: (_raw: [number, VAPI.RTPReceiver.NetworkSourceType, number], _socket: VScript.VSocket) => TaggedNetworkSourceID;
    readonly UsedReceiverTracks: (_raw: [VAPI.RTPReceiver.TrackSet, VAPI.RTPReceiver.OrderedTrackSet, null | VAPI.RTPReceiver.Track, null | VAPI.RTPReceiver.Track, null | VAPI.RTPReceiver.Track, null | VAPI.RTPReceiver.Track], _socket: VScript.VSocket) => UsedReceiverTracks;
    readonly UsedSessionTracks: (_raw: [VAPI.RTPReceiver.TrackSet, VAPI.RTPReceiver.TrackSet, VAPI.RTPReceiver.TrackSet, VAPI.RTPReceiver.TrackSet], _socket: VScript.VSocket) => UsedSessionTracks;
    readonly SingleVideoDecoderWorkingSetWSJpegXS: (_raw: [([0, []] | [1, []] | [2, [Array<number>]]), number], _socket: VScript.VSocket) => SingleVideoDecoderWorkingSetWSJpegXS;
    readonly SingleVideoDecoderWorkingSetWSOther: (_raw: [], _socket: VScript.VSocket) => SingleVideoDecoderWorkingSetWSOther;
    readonly AllDerivedPtpTraits: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.AllDerivedPtpTraits;
    readonly PhaseControlSettingsManualDriftSensitivity: (_raw: [boolean, number, number], _socket: VScript.VSocket) => PhaseControlSettingsManualDriftSensitivity;
    readonly MediaReceiverErrorCounters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.MediaReceiverErrorCounters;
    readonly VideoReceiverMediaSpecificErrorCounters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.VideoReceiverMediaSpecificErrorCounters;
    readonly MediaReceiverEventCounters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.MediaReceiverEventCounters;
    readonly SessionEventCounters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.SessionEventCounters;
    readonly VideoReceiverMediaSpecificEventCounters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.VideoReceiverMediaSpecificEventCounters;
    readonly PacketTracerFilters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.PacketTracerFilters;
    readonly MediaReceiverFlightPermit: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.MediaReceiverFlightPermit;
    readonly VideoReceiverMediaSpecificHardMetadataDecoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.VideoReceiverMediaSpecificHardMetadataDecoder;
    readonly SessionInterfaces: (_raw: [null | string, null | string], _socket: VScript.VSocket) => SessionInterfaces;
    readonly SessionLastAcceptedTrack: (_raw: [VAPI.RTPReceiver.Track, number, number, Array<number>], _socket: VScript.VSocket) => SessionLastAcceptedTrack;
    readonly MediaReceiverLatencySpread: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.MediaReceiverLatencySpread;
    readonly AllLicenseInformation: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.AllLicenseInformation;
    readonly ExpectationsMpacketFrom: (_raw: [boolean, boolean], _socket: VScript.VSocket) => ExpectationsMpacketFrom;
    readonly AllDiagnosticsMpacketTracer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.AllDiagnosticsMpacketTracer;
    readonly SessionEventCountersNumRejectedSdps: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.SessionEventCountersNumRejectedSdps;
    readonly TimingPhaseControl: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.TimingPhaseControl;
    readonly PhaseControlSettingsManualPhaseSensitivity: (_raw: [number, number], _socket: VScript.VSocket) => PhaseControlSettingsManualPhaseSensitivity;
    readonly TimingReadDelay: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.TimingReadDelay;
    readonly TimingReadDelayBounds: (_raw: [null | number, null | number], _socket: VScript.VSocket) => TimingReadDelayBounds;
    readonly MediaReceiverRedundancyLevels: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.MediaReceiverRedundancyLevels;
    readonly MediaReceiverRequiredRedundancyLevel: (_raw: [number, number], _socket: VScript.VSocket) => MediaReceiverRequiredRedundancyLevel;
    readonly VideoReceiverMediaSpecificSoftMetadataDecoderRtpChannelStatistics: (_raw: [number, number], _socket: VScript.VSocket) => VideoReceiverMediaSpecificSoftMetadataDecoderRtpChannelStatistics;
    readonly VideoReceiverMediaSpecificSoftMetadataDecoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.VideoReceiverMediaSpecificSoftMetadataDecoder;
    readonly VideoReceiverMediaSpecificHardMetadataDecoderStatistics: (_raw: [number, number, number, number], _socket: VScript.VSocket) => VideoReceiverMediaSpecificHardMetadataDecoderStatistics;
    readonly PacketStreamStreamParameters: (_raw: [number, null | string, null | string, null | string, VAPI.RTPReceiver.PacketStreamType, VAPI.RTPReceiver.PacketStreamStreamParametersIrqRate], _socket: VScript.VSocket) => PacketStreamStreamParameters;
    readonly PacketTracerFiltersUdpDstPortRange: (_raw: [number, number], _socket: VScript.VSocket) => PacketTracerFiltersUdpDstPortRange;
    readonly SessionVersionWindow: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPReceiver.SessionVersionWindow;
};
export declare const lower: {
    readonly ReadSpeedAdaptive: (_x: {}, _socket: VScript.VSocket) => [];
    readonly PhaseControlSettingsAuto: (_x: {}, _socket: VScript.VSocket) => [];
    readonly JpegXsCaptureStateAwaitingCSCapture: (_x: {}, _socket: VScript.VSocket) => [];
    readonly JpegXsCaptureStateAwaitingCSCaptureTrigger: (_x: {}, _socket: VScript.VSocket) => [];
    readonly SwitchTypeBreakBeforeMake: (_x: {
        switch_time: VAPI.Primitives.Timestamp;
    }, _socket: VScript.VSocket) => [number | string];
    readonly TimingTargetBufferMidpoint: (_x: {}, _socket: VScript.VSocket) => [];
    readonly CapabilityRequestIDs: (_x: {
        request_id: null | VAPI.RTPReceiver.CapabilityRequestID;
        grant_id: null | VAPI.RTPReceiver.CapabilityRequestID;
    }, _socket: VScript.VSocket) => [null | number, null | number];
    readonly CountableErrorHandler: (_x: CountableErrorHandler) => string;
    readonly CurrentRedundancyLevels: (_x: CurrentRedundancyLevels) => string;
    readonly Egress: (_x: {
        freeze_state: Array<null | VAPI.RTPReceiver.FreezeState>;
    }, _socket: VScript.VSocket) => [Array<null | [boolean, null | number]>];
    readonly TimingTargetEgressPlusX: (_x: {
        /**
          Read out every packet this late after egress at the sender (if
          sender and receiver are in sync, and RTP timestamps are not
          modified via `rtp_timestamp_override`)
        */
        read_delay: VScript.Duration;
    }, _socket: VScript.VSocket) => [number];
    readonly ErrorCounter: (_x: {
        /**
          internal timestamp, initialized to zero at process startup
        */
        last_seen_at: null | VAPI.RTPReceiver.DriverTime;
        consec_err_count: VAPI.Primitives.SaturatingCounter16;
        err_acc: VAPI.Primitives.SaturatingCounter16;
    }, _socket: VScript.VSocket) => [null | number, number, number];
    readonly Expectations: (_x: {
        sof: boolean;
        mpacket_from: VAPI.RTPReceiver.ExpectationsMpacketFrom;
    }, _socket: VScript.VSocket) => [boolean, [boolean, boolean]];
    readonly FreezeState: (_x: {
        frozen: boolean;
        fence: null | VAPI.Time.FreeRunningCounter;
    }, _socket: VScript.VSocket) => [boolean, null | number];
    readonly Ingress: (_x: {
        sdp_a: VAPI.RTPReceiver.IngressTrackState;
        sdp_b: VAPI.RTPReceiver.IngressTrackState;
    }, _socket: VScript.VSocket) => [VAPI.RTPReceiver.IngressTrackState, VAPI.RTPReceiver.IngressTrackState];
    readonly TimingTargetIngressPlusX: (_x: {
        /**
          Read out every packet this late after arrival at the receiving
          network interface (if `use_rtp_timestamp` is set to `false`) or
          after egress at the sender (if `use_rtp_timestamp` is set to
          `true`, sender and receiver are in sync, and RTP timestamps are not
          modified via `rtp_timestamp_override`)
        */
        read_delay: VScript.Duration;
    }, _socket: VScript.VSocket) => [number];
    readonly InternalBufferSizes: (_x: {
        for_audio: number;
        for_2022_6: number;
        for_2110_20_uhd_singlelink: number;
        for_2110_20_other: number;
        for_2042_2: number;
        for_passthrough: number;
    }, _socket: VScript.VSocket) => [number, number, number, number, number, number];
    readonly JpegXsCaptureState: (_x: ({
        variant: "AwaitingCSCaptureTrigger";
        value: VAPI.RTPReceiver.JpegXsCaptureStateAwaitingCSCaptureTrigger;
    } | {
        variant: "AwaitingCSCapture";
        value: VAPI.RTPReceiver.JpegXsCaptureStateAwaitingCSCapture;
    } | {
        variant: "SteadyState";
        value: VAPI.RTPReceiver.JpegXsCaptureStateSteadyState;
    }), _socket: VScript.VSocket) => ([0, []] | [1, []] | [2, [Array<number>]]);
    readonly MPacket: (_x: {
        extended_frc: VAPI.RTPReceiver.ExtendedFRC;
        seqnr: VAPI.RTPReceiver.Seqnr;
        format: VAPI.RTPReceiver.MPacketFormat;
    }, _socket: VScript.VSocket) => [number, number, number];
    readonly MPacketDebugInfo: (_x: {
        packet_stream_index: VAPI.RTPReceiver.PacketStreamIndex;
        m_flag: boolean;
        seqnr: VAPI.RTPReceiver.Seqnr;
        last_word: number;
        empty: number;
        rtp_timestamp: VAPI.Primitives.Unsigned32;
        frc: VAPI.Time.FreeRunningCounter;
        misc: VAPI.Primitives.Unsigned32;
    }, _socket: VScript.VSocket) => [number, boolean, number, number, number, number, number, number];
    readonly SwitchTypeMakeBeforeBreak: (_x: {
        switch_time: VAPI.Primitives.Timestamp;
    }, _socket: VScript.VSocket) => [number | string];
    readonly PhaseControlSettingsManual: (_x: {
        /**
          only permit corrective jumps (audio) or drop/repeat frames (video)
          after this many consecutive `phase_mismatch` errors. Set to `null`
          to disallow jumping entirely. Note that audio jumps require a
          nonzero number of reserve decoders, as defined under
          `settings.num_audio_reserve_receivers`.
        */
        jump_threshold: null | number;
        /**
          only permit corrective receiver restarts after this many
          consecutive `phase_mismatch` errors. Set to `null` to disallow
          entirely.
        */
        restart_threshold: null | number;
        /**
          If this is set to true, any phase mismatch closer than
          `safety_margin - current_phase.error` to the buffer boundary will
          be interpreted as a phase error.
        */
        protect_safety_margin: boolean;
        /**
          Interpret phase as asynchronous if `|current_phase.drift.value| >
          drift_sensitivity.value`, and if `current_phase.drift.error <
          drift_sensitivity.error × |current_phase.drift.value|`
        */
        drift_sensitivity: VAPI.RTPReceiver.PhaseControlSettingsManualDriftSensitivity;
        /**
          interpret `current_phase` as a phase error if
          `|current_phase.offset.value| > phase_sensitivity.value` and
          `current_phase.offset.error < phase_sensitivity.error ×
          |current_phase.offset.value|`
        */
        phase_sensitivity: null | VAPI.RTPReceiver.PhaseControlSettingsManualPhaseSensitivity;
        /**
          interpret current trajectory as a phase error if
          `expected_time_to_collision` < `auto_eject_threshold`; set to
          `null` to disable.
        */
        auto_eject_threshold: null | VScript.Duration;
    }, _socket: VScript.VSocket) => [null | number, null | number, boolean, [boolean, number, number], null | [number, number], null | number];
    readonly PacketTracerRun: (_x: {
        n_run: VAPI.Primitives.Unsigned64;
        ts_start: VAPI.Primitives.Timestamp;
        ts_end: VAPI.Primitives.Timestamp;
        num_streams_detected: VAPI.Primitives.Unsigned32;
        mean_packets_per_second: number;
        num_warnings_generated: VAPI.Primitives.Unsigned32;
        num_events_captured: VAPI.Primitives.Unsigned64;
        num_data_flags_lost: VAPI.Primitives.Unsigned64;
        num_irq_packets_lost: VAPI.Primitives.Unsigned64;
        packet_details: VAPI.RTPReceiver.PacketTracerRunPacketDetails;
        mode: VAPI.RTPReceiver.PacketTracerMode;
    }, _socket: VScript.VSocket) => [number, number | string, number | string, number, number, number, number, number, number, VAPI.RTPReceiver.PacketTracerRunPacketDetails, VAPI.RTPReceiver.PacketTracerMode];
    readonly SwitchTypePatch: (_x: {}, _socket: VScript.VSocket) => [];
    readonly PhaseControlSettings: (_x: ({
        variant: "Auto";
        value: VAPI.RTPReceiver.PhaseControlSettingsAuto;
    } | {
        variant: "Manual";
        value: VAPI.RTPReceiver.PhaseControlSettingsManual;
    }), _socket: VScript.VSocket) => ([0, []] | [1, [null | number, null | number, boolean, [boolean, number, number], null | [number, number], null | number]]);
    readonly SingleVideoDecoderWorkingSet: (_x: ({
        variant: "WSOther";
        value: VAPI.RTPReceiver.SingleVideoDecoderWorkingSetWSOther;
    } | {
        variant: "WSJpegXS";
        value: VAPI.RTPReceiver.SingleVideoDecoderWorkingSetWSJpegXS;
    }), _socket: VScript.VSocket) => ([0, []] | [1, [([0, []] | [1, []] | [2, [Array<number>]]), number]]);
    readonly SoftMetadataStatistics: (_x: {
        packets_received: VAPI.Primitives.CyclicCounter32;
        packets_too_old: VAPI.Primitives.CyclicCounter32;
        packets_considered: VAPI.Primitives.CyclicCounter32;
        packets_missing: VAPI.Primitives.CyclicCounter32;
        parse_errors: VAPI.Primitives.CyclicCounter32;
        type_unknown: VAPI.Primitives.CyclicCounter32;
        parsed_as_empty_cea708: VAPI.Primitives.CyclicCounter32;
        parsed_as_proper_cea708: VAPI.Primitives.CyclicCounter32;
        parsed_as_empty_op47: VAPI.Primitives.CyclicCounter32;
        parsed_as_proper_op47: VAPI.Primitives.CyclicCounter32;
        parsed_as_empty_st12: VAPI.Primitives.CyclicCounter32;
        parsed_as_proper_st12: VAPI.Primitives.CyclicCounter32;
    }, _socket: VScript.VSocket) => [number, number, number, number, number, number, number, number, number, number, number, number];
    readonly StatsID: (_x: {
        irq_number: number;
        id: number;
    }, _socket: VScript.VSocket) => [number, number];
    readonly JpegXsCaptureStateSteadyState: (_x: {
        cs_capture_data: Array<VAPI.Primitives.Unsigned8>;
    }, _socket: VScript.VSocket) => [Array<number>];
    readonly SwitchType: (_x: ({
        variant: "Patch";
        value: VAPI.RTPReceiver.SwitchTypePatch;
    } | {
        variant: "MakeBeforeBreak";
        value: VAPI.RTPReceiver.SwitchTypeMakeBeforeBreak;
    } | {
        variant: "BreakBeforeMake";
        value: VAPI.RTPReceiver.SwitchTypeBreakBeforeMake;
    }), _socket: VScript.VSocket) => ([0, []] | [1, [number | string]] | [2, [number | string]]);
    readonly TaggedNetworkSourceID: (_x: {
        /**
          lower 16 bits designate UDP port, upper 16 bits designate portless
          part
        */
        source_id: VAPI.RTPReceiver.NetworkSourceID;
        intended_use: VAPI.RTPReceiver.NetworkSourceType;
        /**
          measured in units of Kibit/s
        */
        estimated_bandwidth: number;
    }, _socket: VScript.VSocket) => [number, VAPI.RTPReceiver.NetworkSourceType, number];
    readonly UsedReceiverTracks: (_x: {
        ingress: VAPI.RTPReceiver.TrackSet;
        egress: VAPI.RTPReceiver.OrderedTrackSet;
        hard_metadata: null | VAPI.RTPReceiver.Track;
        soft_metadata: null | VAPI.RTPReceiver.Track;
        current_target: null | VAPI.RTPReceiver.Track;
        next_target: null | VAPI.RTPReceiver.Track;
    }, _socket: VScript.VSocket) => [VAPI.RTPReceiver.TrackSet, VAPI.RTPReceiver.OrderedTrackSet, null | VAPI.RTPReceiver.Track, null | VAPI.RTPReceiver.Track, null | VAPI.RTPReceiver.Track, null | VAPI.RTPReceiver.Track];
    readonly UsedSessionTracks: (_x: {
        ingress: VAPI.RTPReceiver.TrackSet;
        egress: VAPI.RTPReceiver.TrackSet;
        current_target: VAPI.RTPReceiver.TrackSet;
        next_target: VAPI.RTPReceiver.TrackSet;
    }, _socket: VScript.VSocket) => [VAPI.RTPReceiver.TrackSet, VAPI.RTPReceiver.TrackSet, VAPI.RTPReceiver.TrackSet, VAPI.RTPReceiver.TrackSet];
    readonly SingleVideoDecoderWorkingSetWSJpegXS: (_x: {
        cs_capture_state: VAPI.RTPReceiver.JpegXsCaptureState;
        soc_offset: number;
    }, _socket: VScript.VSocket) => [([0, []] | [1, []] | [2, [Array<number>]]), number];
    readonly SingleVideoDecoderWorkingSetWSOther: (_x: {}, _socket: VScript.VSocket) => [];
    readonly AllDerivedPtpTraits: (_x: AllDerivedPtpTraits) => string;
    readonly PhaseControlSettingsManualDriftSensitivity: (_x: {
        /**
          set this to `true` to suppress phase errors if the receiver's
          output phase is classified as asynchronous. This way,
          asynchronous streams can be received with a minimum of signal
          disturbances even when running in `LockToGenlock` mode (note that
          `auto_eject_threshold` remains in effect, so safety-violating
          phase errors will still give rise to drop/repeat frame events or
          audio jumps)
        */
        suppress_phase_error_on_drift: boolean;
        value: number;
        error: number;
    }, _socket: VScript.VSocket) => [boolean, number, number];
    readonly MediaReceiverErrorCounters: (_x: MediaReceiverErrorCounters) => string;
    readonly VideoReceiverMediaSpecificErrorCounters: (_x: VideoReceiverMediaSpecificErrorCounters) => string;
    readonly MediaReceiverEventCounters: (_x: MediaReceiverEventCounters) => string;
    readonly SessionEventCounters: (_x: SessionEventCounters) => string;
    readonly VideoReceiverMediaSpecificEventCounters: (_x: VideoReceiverMediaSpecificEventCounters) => string;
    readonly PacketTracerFilters: (_x: PacketTracerFilters) => string;
    readonly MediaReceiverFlightPermit: (_x: MediaReceiverFlightPermit) => string;
    readonly VideoReceiverMediaSpecificHardMetadataDecoder: (_x: VideoReceiverMediaSpecificHardMetadataDecoder) => string;
    readonly SessionInterfaces: (_x: {
        primary: null | VAPI.NetworkInterfaces.VirtualInterface;
        secondary: null | VAPI.NetworkInterfaces.VirtualInterface;
    }, _socket: VScript.VSocket) => [null | string, null | string];
    readonly SessionLastAcceptedTrack: (_x: {
        track: VAPI.RTPReceiver.Track;
        fc: VAPI.Time.FreeRunningCounter;
        controller_version: VAPI.SDP.ControllerVersion;
        /**
          Currently set to all zeroes if the given SDP does
          not specify a `controller-id`; in version 2.0
          this will be replaced by a proper optional.
        */
        controller_id: VAPI.SDP.ControllerID;
    }, _socket: VScript.VSocket) => [VAPI.RTPReceiver.Track, number, number, Array<number>];
    readonly MediaReceiverLatencySpread: (_x: MediaReceiverLatencySpread) => string;
    readonly AllLicenseInformation: (_x: AllLicenseInformation) => string;
    readonly ExpectationsMpacketFrom: (_x: {
        sdp_a: boolean;
        sdp_b: boolean;
    }, _socket: VScript.VSocket) => [boolean, boolean];
    readonly AllDiagnosticsMpacketTracer: (_x: AllDiagnosticsMpacketTracer) => string;
    readonly SessionEventCountersNumRejectedSdps: (_x: SessionEventCountersNumRejectedSdps) => string;
    readonly TimingPhaseControl: (_x: TimingPhaseControl) => string;
    readonly PhaseControlSettingsManualPhaseSensitivity: (_x: {
        value: VScript.Duration;
        error: number;
    }, _socket: VScript.VSocket) => [number, number];
    readonly TimingReadDelay: (_x: TimingReadDelay) => string;
    readonly TimingReadDelayBounds: (_x: {
        min: null | VScript.Duration;
        max: null | VScript.Duration;
    }, _socket: VScript.VSocket) => [null | number, null | number];
    readonly MediaReceiverRedundancyLevels: (_x: MediaReceiverRedundancyLevels) => string;
    readonly MediaReceiverRequiredRedundancyLevel: (_x: {
        /**
          number of packet streams referenced
          by this receiver's media
          description at track A that must
          have been registered at their
          respective network interfaces for
          the receiver to attempt readout
        */
        sdp_a: VAPI.RTPReceiver.RedundancyLevel;
        /**
          number of packet streams referenced
          by this receiver's media
          description at track B that must
          have been registered at their
          respective network interfaces for
          the receiver to attempt readout
        */
        sdp_b: VAPI.RTPReceiver.RedundancyLevel;
    }, _socket: VScript.VSocket) => [number, number];
    readonly VideoReceiverMediaSpecificSoftMetadataDecoderRtpChannelStatistics: (_x: {
        packets_lost: VAPI.Primitives.CyclicCounter32;
        packets_sent: VAPI.Primitives.CyclicCounter32;
    }, _socket: VScript.VSocket) => [number, number];
    readonly VideoReceiverMediaSpecificSoftMetadataDecoder: (_x: VideoReceiverMediaSpecificSoftMetadataDecoder) => string;
    readonly VideoReceiverMediaSpecificHardMetadataDecoderStatistics: (_x: {
        num_relocations: number;
        num_embedded_packets: number;
        fc: VAPI.Time.FreeRunningCounter;
        micro_epoch_index: VAPI.Time.MicroEpochIndex;
    }, _socket: VScript.VSocket) => [number, number, number, number];
    readonly PacketStreamStreamParameters: (_x: {
        /**
          Seqnr offset relative to other
          packet streams mapped to the same
          memory region. N packet streams
          hence define N-1 meaningful
          offsets.
        */
        seqnr_offset: VAPI.RTPReceiver.SeqnrDifference;
        /**
          IP (unicast) address of the RTP
          stream sender
        */
        src_address: null | string;
        /**
          IP (multicast) destination
          address of the RTP stream
        */
        dst_address: null | string;
        interface: null | VAPI.NetworkInterfaces.VirtualInterface;
        type: VAPI.RTPReceiver.PacketStreamType;
        irq_rate: VAPI.RTPReceiver.PacketStreamStreamParametersIrqRate;
    }, _socket: VScript.VSocket) => [number, null | string, null | string, null | string, VAPI.RTPReceiver.PacketStreamType, VAPI.RTPReceiver.PacketStreamStreamParametersIrqRate];
    readonly PacketTracerFiltersUdpDstPortRange: (_x: {
        min: VAPI.Primitives.Unsigned16;
        max: VAPI.Primitives.Unsigned16;
    }, _socket: VScript.VSocket) => [number, number];
    readonly SessionVersionWindow: (_x: SessionVersionWindow) => string;
};
export interface ReadSpeedAdaptive {
}
export type AudioBlockIndex = number;
export type AudioInstanceIndex = number;
export interface PhaseControlSettingsAuto {
}
export interface JpegXsCaptureStateAwaitingCSCapture {
}
export interface JpegXsCaptureStateAwaitingCSCaptureTrigger {
}
export type BackpressurePolicy = "Yield" | "Resist";
export type BlockCount = number;
export interface SwitchTypeBreakBeforeMake {
    switch_time: VAPI.Primitives.Timestamp;
}
export type BufferID = number;
export interface TimingTargetBufferMidpoint {
}
export type CapabilityRequestID = number;
/**
  Ideally, this keyword shouldn't exist. In practice however, capability
  requests are currently processed eagerly, s.t. the outcome of a capability
  allocation attempt may depend on the order in which individual receivers
  are serviced. To ensure full state recovery across reboots, we thus store
  this ordering explicitly
*/
export interface CapabilityRequestIDs {
    request_id: null | VAPI.RTPReceiver.CapabilityRequestID;
    grant_id: null | VAPI.RTPReceiver.CapabilityRequestID;
}
export type ChannelCapacity = number;
/**
  if `clean_switching_policy` is set to `Tolerant`, packet rates and ST2042
  compression ratios may change across switching boundaries. This ensures
  interoperability between a wider range of transmitters but comes at a
  slight performance penalty, as the receiver first has to determine the
  current packet rate before a switch can be effected. When set to
  `Whatever`, impossible clean switching requests will silently be converted
  into patching operations. Please only use this option as a measure of last
  resort, if at all.
*/
export type CleanSwitchingPolicy = "Strict" | "Tolerant" | "Whatever";
export type CoarseGrainingLevel = number;
export declare class CountableErrorHandler implements VScript.Referenceable<"RTPReceiver::Data::CountableErrorHandler"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::CountableErrorHandler";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get threshold(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.RTPReceiver.CountableErrorHandler>;
    get above_threshold_do(): VScript.rwKeyword<VScript.VSocket, VAPI.RTPReceiver.ErrorHandler, VAPI.RTPReceiver.ErrorHandler, VAPI.RTPReceiver.ErrorHandler, VAPI.RTPReceiver.ErrorHandler, VAPI.RTPReceiver.CountableErrorHandler>;
}
export declare class CurrentRedundancyLevels implements VScript.Referenceable<"RTPReceiver::Data::CurrentRedundancyLevels"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::CurrentRedundancyLevels";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Number of streams referenced by this receiver's SDP that are actually
      present, indexed by subflow number. The latter is typically 0, but for
      quad-link video receivers can range from 0 to 3, and is 4 for 2110-40
      flows routed into a 2110-20 video receiver.
    */
    get per_subflow(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Primitives.Unsigned8>, VAPI.RTPReceiver.CurrentRedundancyLevels>;
    get overall(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.RedundancyLevel, VAPI.RTPReceiver.CurrentRedundancyLevels>;
}
/**
  internal timestamp, initialized to zero at process startup
*/
export type DriverTime = VScript.Duration;
export interface Egress {
    freeze_state: Array<null | VAPI.RTPReceiver.FreezeState>;
}
export interface TimingTargetEgressPlusX {
    /**
      Read out every packet this late after egress at the sender (if sender and
      receiver are in sync, and RTP timestamps are not modified via
      `rtp_timestamp_override`)
    */
    read_delay: VScript.Duration;
}
export type ErrorCondition = "RXErrors" | "PrematureRead" | "LivenessTimeout" | "MPacketError" | "OffsetError2110" | "LinenrError2110";
export interface ErrorCounter {
    /**
      internal timestamp, initialized to zero at process startup
    */
    last_seen_at: null | VAPI.RTPReceiver.DriverTime;
    consec_err_count: VAPI.Primitives.SaturatingCounter16;
    err_acc: VAPI.Primitives.SaturatingCounter16;
}
export type ErrorHandler = "Ignore" | "RestartReceiver";
export interface Expectations {
    sof: boolean;
    mpacket_from: VAPI.RTPReceiver.ExpectationsMpacketFrom;
}
export type ExtendedFRC = number;
/**
  TODO: reintroduce this (?)
*/
export type FrameShiftPolicy = "Prohibit" | "PermitFrameShifts" | "PermitSubframeShifts";
export interface FreezeState {
    frozen: boolean;
    fence: null | VAPI.Time.FreeRunningCounter;
}
export type HashtableMetadata = number;
export interface Ingress {
    sdp_a: VAPI.RTPReceiver.IngressTrackState;
    sdp_b: VAPI.RTPReceiver.IngressTrackState;
}
export interface TimingTargetIngressPlusX {
    /**
      Read out every packet this late after arrival at the receiving network
      interface (if `use_rtp_timestamp` is set to `false`) or after egress at
      the sender (if `use_rtp_timestamp` is set to `true`, sender and receiver
      are in sync, and RTP timestamps are not modified via
      `rtp_timestamp_override`)
    */
    read_delay: VScript.Duration;
}
export type IngressTrackState = "Inactive" | "Activating" | "Active";
export interface InternalBufferSizes {
    for_audio: number;
    for_2022_6: number;
    for_2110_20_uhd_singlelink: number;
    for_2110_20_other: number;
    for_2042_2: number;
    for_passthrough: number;
}
export type JpegXsBlockIndex = number;
export type JpegXsCaptureState = ({
    variant: "AwaitingCSCaptureTrigger";
    value: VAPI.RTPReceiver.JpegXsCaptureStateAwaitingCSCaptureTrigger;
} | {
    variant: "AwaitingCSCapture";
    value: VAPI.RTPReceiver.JpegXsCaptureStateAwaitingCSCapture;
} | {
    variant: "SteadyState";
    value: VAPI.RTPReceiver.JpegXsCaptureStateSteadyState;
});
export type JpegXsDecoderInstance = number;
export type JumpResponse = "Pending" | "Refused";
export type LocalSliceIndex = number;
export type LogicalSwitchTime = "Patch" | "Past" | "WithinCooldownTime" | "WithinPreparationTime" | "Future";
/**
  TODO: should have dynamic, dts-derived bounds
*/
export type MMUReadIndex = number;
export interface MPacket {
    extended_frc: VAPI.RTPReceiver.ExtendedFRC;
    seqnr: VAPI.RTPReceiver.Seqnr;
    format: VAPI.RTPReceiver.MPacketFormat;
}
export interface MPacketDebugInfo {
    packet_stream_index: VAPI.RTPReceiver.PacketStreamIndex;
    m_flag: boolean;
    seqnr: VAPI.RTPReceiver.Seqnr;
    last_word: number;
    empty: number;
    rtp_timestamp: VAPI.Primitives.Unsigned32;
    frc: VAPI.Time.FreeRunningCounter;
    misc: VAPI.Primitives.Unsigned32;
}
export interface SwitchTypeMakeBeforeBreak {
    switch_time: VAPI.Primitives.Timestamp;
}
export interface PhaseControlSettingsManual {
    /**
      only permit corrective jumps (audio) or drop/repeat frames (video) after
      this many consecutive `phase_mismatch` errors. Set to `null` to disallow
      jumping entirely. Note that audio jumps require a nonzero number of
      reserve decoders, as defined under
      `settings.num_audio_reserve_receivers`.
    */
    jump_threshold: null | number;
    /**
      only permit corrective receiver restarts after this many consecutive
      `phase_mismatch` errors. Set to `null` to disallow entirely.
    */
    restart_threshold: null | number;
    /**
      If this is set to true, any phase mismatch closer than `safety_margin -
      current_phase.error` to the buffer boundary will be interpreted as a
      phase error.
    */
    protect_safety_margin: boolean;
    /**
      Interpret phase as asynchronous if `|current_phase.drift.value| >
      drift_sensitivity.value`, and if `current_phase.drift.error <
      drift_sensitivity.error × |current_phase.drift.value|`
    */
    drift_sensitivity: VAPI.RTPReceiver.PhaseControlSettingsManualDriftSensitivity;
    /**
      interpret `current_phase` as a phase error if
      `|current_phase.offset.value| > phase_sensitivity.value` and
      `current_phase.offset.error < phase_sensitivity.error ×
      |current_phase.offset.value|`
    */
    phase_sensitivity: null | VAPI.RTPReceiver.PhaseControlSettingsManualPhaseSensitivity;
    /**
      interpret current trajectory as a phase error if
      `expected_time_to_collision` < `auto_eject_threshold`; set to `null` to
      disable.
    */
    auto_eject_threshold: null | VScript.Duration;
}
export type MediaReceiverType = "AncBurst" | "Audio" | "Video";
export type MemoryRegion = "Main" | "Alternate";
export type MetadataStreamID = number;
export type NativeVideoBlockIndex = number;
export type NativeVideoDecoderInstance = number;
/**
  lower 16 bits designate UDP port, upper 16 bits designate portless part
*/
export type NetworkSourceID = number;
export type NetworkSourceType = "Audio" | "Video2042_2" | "Video2110_20" | "Video2110_20_UHD" | "VideoJpegXs" | "Video2022_6" | "Video2110_40_SoftMetadata" | "Video2110_40_NativeMetadata" | "Video2110_40_JpegXSMetadata" | "Video2110_40_AncBurst" | "MipMap" | "J2K" | "Passthrough";
export type NumDownloads = number;
/**
  Single video substreams pertaining to a quadlink UHD flow may be subscribed
  to independently, and used as separate 3G streams instead. By default, the
  resulting 3G video essences will be stripped of their substream attributes,
  which affects SDPs generated on retransmission, as well as 352 payloads. If
  you wish to retain original substream attributes, set this setting to
  `PropagateSubstreamAttribute` (but note that this setting only takes effect
  on readout).
*/
export type OnIsolatedSubstream = "PropagateSubstreamAttribute" | "StripSubstreamAttribute";
export type OrderedTrackSet = "X" | "A" | "B" | "AB" | "BA" | "XA" | "XB";
export type PacketCapacity = number;
export type PacketStreamIndex = number;
export type PacketStreamType = "Audio" | "Video2022_6" | "VideoOther" | "Video2110_40_Metadata" | "VideoJpegXs" | "MipMap" | "J2K" | "Passthrough";
export type PacketTracerMode = "Seqnr" | "DstPort_Delta" | "Frc_Seqnr" | "SrcIp_DstIp_DstPort" | "Frc_Seqnr_DstPort_Timestamp";
export interface PacketTracerRun {
    n_run: VAPI.Primitives.Unsigned64;
    ts_start: VAPI.Primitives.Timestamp;
    ts_end: VAPI.Primitives.Timestamp;
    num_streams_detected: VAPI.Primitives.Unsigned32;
    mean_packets_per_second: number;
    num_warnings_generated: VAPI.Primitives.Unsigned32;
    num_events_captured: VAPI.Primitives.Unsigned64;
    num_data_flags_lost: VAPI.Primitives.Unsigned64;
    num_irq_packets_lost: VAPI.Primitives.Unsigned64;
    packet_details: VAPI.RTPReceiver.PacketTracerRunPacketDetails;
    mode: VAPI.RTPReceiver.PacketTracerMode;
}
export type PartitionID = number;
export interface SwitchTypePatch {
}
export type PhaseControlSettings = ({
    variant: "Auto";
    value: VAPI.RTPReceiver.PhaseControlSettingsAuto;
} | {
    variant: "Manual";
    value: VAPI.RTPReceiver.PhaseControlSettingsManual;
});
export type PhaseMismatchSeverity = "TargetViolation" | "SafetyViolation";
/**
  0 and 1 are never used
*/
export type PortlessNetworkSourceID = number;
export type RedundancyLevel = number;
/**
  some configuration attempts cannot be executed completely. For example, a
  session containing 3 audio receivers will not be able to service a
  connection request if the corresponding SDP contains 4 or more audio
  essences. In these cases, the receiver may either set up as many
  connections as possible and discard the rest (`BestEffort`), or refuse the
  configuration attempt and raise an error message instead (`Refuse`).
*/
export type ResourceExhaustionPolicy = "Refuse" | "BestEffort";
export type SSRC = number;
export type SamplingStructure = "Interlaced" | "Progressive";
export type Seqnr = number;
/**
  Seqnr offset relative to other packet streams mapped to the same memory
  region. N packet streams hence define N-1 meaningful offsets.
*/
export type SeqnrDifference = number;
/**
  TODO: add support for quadlink working sets
*/
export type SingleVideoDecoderWorkingSet = ({
    variant: "WSOther";
    value: VAPI.RTPReceiver.SingleVideoDecoderWorkingSetWSOther;
} | {
    variant: "WSJpegXS";
    value: VAPI.RTPReceiver.SingleVideoDecoderWorkingSetWSJpegXS;
});
export interface SoftMetadataStatistics {
    packets_received: VAPI.Primitives.CyclicCounter32;
    packets_too_old: VAPI.Primitives.CyclicCounter32;
    packets_considered: VAPI.Primitives.CyclicCounter32;
    packets_missing: VAPI.Primitives.CyclicCounter32;
    parse_errors: VAPI.Primitives.CyclicCounter32;
    type_unknown: VAPI.Primitives.CyclicCounter32;
    parsed_as_empty_cea708: VAPI.Primitives.CyclicCounter32;
    parsed_as_proper_cea708: VAPI.Primitives.CyclicCounter32;
    parsed_as_empty_op47: VAPI.Primitives.CyclicCounter32;
    parsed_as_proper_op47: VAPI.Primitives.CyclicCounter32;
    parsed_as_empty_st12: VAPI.Primitives.CyclicCounter32;
    parsed_as_proper_st12: VAPI.Primitives.CyclicCounter32;
}
export interface StatsID {
    irq_number: number;
    id: number;
}
export type StatsSubscriptionType = "InsertNew" | "ReplaceOld";
export interface JpegXsCaptureStateSteadyState {
    cs_capture_data: Array<VAPI.Primitives.Unsigned8>;
}
export type SubflowIndex = number;
export type SwitchType = ({
    variant: "Patch";
    value: VAPI.RTPReceiver.SwitchTypePatch;
} | {
    variant: "MakeBeforeBreak";
    value: VAPI.RTPReceiver.SwitchTypeMakeBeforeBreak;
} | {
    variant: "BreakBeforeMake";
    value: VAPI.RTPReceiver.SwitchTypeBreakBeforeMake;
});
export interface TaggedNetworkSourceID {
    /**
      lower 16 bits designate UDP port, upper 16 bits designate portless part
    */
    source_id: VAPI.RTPReceiver.NetworkSourceID;
    intended_use: VAPI.RTPReceiver.NetworkSourceType;
    /**
      measured in units of Kibit/s
    */
    estimated_bandwidth: number;
}
export type Track = "A" | "B";
export type TrackSet = "Empty" | "A" | "B" | "AB";
export interface UsedReceiverTracks {
    ingress: VAPI.RTPReceiver.TrackSet;
    egress: VAPI.RTPReceiver.OrderedTrackSet;
    hard_metadata: null | VAPI.RTPReceiver.Track;
    soft_metadata: null | VAPI.RTPReceiver.Track;
    current_target: null | VAPI.RTPReceiver.Track;
    next_target: null | VAPI.RTPReceiver.Track;
}
export interface UsedSessionTracks {
    ingress: VAPI.RTPReceiver.TrackSet;
    egress: VAPI.RTPReceiver.TrackSet;
    current_target: VAPI.RTPReceiver.TrackSet;
    next_target: VAPI.RTPReceiver.TrackSet;
}
/**
  SMPTE 2022-6 video streams should advertise their video format within the
  m-packet header. Additionally, the video format may be specified in advance
  using the `fmtp` SDP attribute (for SMPTE 2110 and ST 2042 streams, this is
  the only way to specify video standards). Should the standard extracted
  from an incoming m-packet disagree with a previously specified `fmtp`
  attribute, this setting determines which one takes precedence.
*/
export type VidStd20226Authority = "SDPFmtpAttribute" | "MPacketMetadata";
/**
  TODO: add support for quadlink working sets
*/
export interface SingleVideoDecoderWorkingSetWSJpegXS {
    cs_capture_state: VAPI.RTPReceiver.JpegXsCaptureState;
    soc_offset: number;
}
/**
  TODO: add support for quadlink working sets
*/
export interface SingleVideoDecoderWorkingSetWSOther {
}
export declare class AllDerivedPtpTraits implements VScript.Referenceable<"RTPReceiver::Data::All::DerivedPtpTraits"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::All::DerivedPtpTraits";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get packet_stream_media_clock(): VAPI.PTP.Traits;
    get video_sof(): VAPI.PTP.Traits;
}
/**
  Interpret phase as asynchronous if `|current_phase.drift.value| >
  drift_sensitivity.value`, and if `current_phase.drift.error <
  drift_sensitivity.error × |current_phase.drift.value|`
*/
export interface PhaseControlSettingsManualDriftSensitivity {
    /**
      set this to `true` to suppress phase errors if the receiver's output
      phase is classified as asynchronous. This way, asynchronous streams can
      be received with a minimum of signal disturbances even when running in
      `LockToGenlock` mode (note that `auto_eject_threshold` remains in effect,
      so safety-violating phase errors will still give rise to drop/repeat
      frame events or audio jumps)
    */
    suppress_phase_error_on_drift: boolean;
    value: number;
    error: number;
}
export declare class MediaReceiverErrorCounters implements VScript.Referenceable<"RTPReceiver::Data::MediaReceiver::ErrorCounters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::MediaReceiver::ErrorCounters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get rx_error(): VScript.rKeyword<VScript.VSocket, [
        null | number,
        number,
        number
    ], VAPI.RTPReceiver.ErrorCounter, VAPI.RTPReceiver.MediaReceiverErrorCounters>;
    /**
      premature read errors are signalled when the decoder attempts to process
      data that has not yet been delivered by the memory controller
    */
    get premature_read(): VScript.rKeyword<VScript.VSocket, [
        null | number,
        number,
        number
    ], VAPI.RTPReceiver.ErrorCounter, VAPI.RTPReceiver.MediaReceiverErrorCounters>;
    get liveness_timeout(): VScript.rKeyword<VScript.VSocket, [
        null | number,
        number,
        number
    ], VAPI.RTPReceiver.ErrorCounter, VAPI.RTPReceiver.MediaReceiverErrorCounters>;
    get phase_mismatch(): VScript.rKeyword<VScript.VSocket, [
        null | number,
        number,
        number
    ], VAPI.RTPReceiver.ErrorCounter, VAPI.RTPReceiver.MediaReceiverErrorCounters>;
}
export declare class VideoReceiverMediaSpecificErrorCounters implements VScript.Referenceable<"RTPReceiver::Data::VideoReceiver::MediaSpecific::ErrorCounters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::VideoReceiver::MediaSpecific::ErrorCounters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get mpacket_error(): VScript.rKeyword<VScript.VSocket, [
        null | number,
        number,
        number
    ], VAPI.RTPReceiver.ErrorCounter, VAPI.RTPReceiver.VideoReceiverMediaSpecificErrorCounters>;
    get offset_2110_error(): VScript.rKeyword<VScript.VSocket, [
        null | number,
        number,
        number
    ], VAPI.RTPReceiver.ErrorCounter, VAPI.RTPReceiver.VideoReceiverMediaSpecificErrorCounters>;
    get linenr_2110_error(): VScript.rKeyword<VScript.VSocket, [
        null | number,
        number,
        number
    ], VAPI.RTPReceiver.ErrorCounter, VAPI.RTPReceiver.VideoReceiverMediaSpecificErrorCounters>;
    /**
      raised on audio deembedder overflow; only applies in 2022-6 mode
    */
    get audio_2022_6_deemb_read_overflow(): VScript.rKeyword<VScript.VSocket, [
        null | number,
        number,
        number
    ], VAPI.RTPReceiver.ErrorCounter, VAPI.RTPReceiver.VideoReceiverMediaSpecificErrorCounters>;
    /**
      raised on audio deembedder underflow; only applies in 2022-6 mode
    */
    get audio_2022_6_deemb_read_underflow(): VScript.rKeyword<VScript.VSocket, [
        null | number,
        number,
        number
    ], VAPI.RTPReceiver.ErrorCounter, VAPI.RTPReceiver.VideoReceiverMediaSpecificErrorCounters>;
}
export declare class MediaReceiverEventCounters implements VScript.Referenceable<"RTPReceiver::Data::MediaReceiver::EventCounters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::MediaReceiver::EventCounters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      increased by 1 on every start attempt targeting SDP A
    */
    get start_a(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.RTPReceiver.MediaReceiverEventCounters>;
    /**
      increased by 1 on every start attempt targeting SDP B
    */
    get start_b(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.RTPReceiver.MediaReceiverEventCounters>;
    /**
      increased by 1 on every A → B switch attempt
    */
    get switch_ab(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.RTPReceiver.MediaReceiverEventCounters>;
    /**
      increased by 1 on every B → A switch attempt
    */
    get switch_ba(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.RTPReceiver.MediaReceiverEventCounters>;
    /**
      increased by 1 on every receiver stop
    */
    get stop(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.RTPReceiver.MediaReceiverEventCounters>;
    /**
      increased by 1 on every error-induced receiver restart
    */
    get restart(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.RTPReceiver.MediaReceiverEventCounters>;
    /**
      increased by 1 every time an accepted SDP request evicts another SDP
      currently targeted by the decoder backend
    */
    get stop_evicted(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.RTPReceiver.MediaReceiverEventCounters>;
    /**
      BBM video receivers that have their RX buffer supplied by other
      receivers' network streams do not attempt to freeze their decoder
      backends at switch time. If these foreign streams are withdrawn before
      the BBM switch has completed, the BBM receiver's decoder backend will be
      stopped, and `stop_abandoned` will increase by 1
    */
    get stop_abandoned(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.RTPReceiver.MediaReceiverEventCounters>;
    /**
      if, during SDP request processing, the completion of a previously issued
      start command has not been verified conclusively, the decoder backend may
      be stopped, in which case `stop_unfinished_start_attempt` will increase
      by 1
    */
    get stop_unfinished_start_attempt(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.RTPReceiver.MediaReceiverEventCounters>;
    /**
      if `clean_switching_policy` is set to `Whatever`, impossible
      clean-switching requests are silently converted to patch requests, thus
      causing loss-of-signal events at switch time
    */
    get downgraded_switch_requests(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.RTPReceiver.MediaReceiverEventCounters>;
    /**
      increased by 1 every time the receiver formally switches between
      identical media flows on tracks A and B
    */
    get elided_switch_requests(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.RTPReceiver.MediaReceiverEventCounters>;
}
export declare class SessionEventCounters implements VScript.Referenceable<"RTPReceiver::Data::Session::EventCounters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::Session::EventCounters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get num_rejected_sdps(): VAPI.RTPReceiver.SessionEventCountersNumRejectedSdps;
}
export declare class VideoReceiverMediaSpecificEventCounters implements VScript.Referenceable<"RTPReceiver::Data::VideoReceiver::MediaSpecific::EventCounters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::VideoReceiver::MediaSpecific::EventCounters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get frame_drop_repeat_events(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.RTPReceiver.VideoReceiverMediaSpecificEventCounters>;
}
export declare class PacketTracerFilters implements VScript.Referenceable<"RTPReceiver::Data::PacketTracer::Filters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::PacketTracer::Filters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get udp_dst_port_range(): VScript.dKeyword<VScript.VSocket, null | [
        number,
        number
    ], null | [
        number,
        number
    ], null | VAPI.RTPReceiver.PacketTracerFiltersUdpDstPortRange, null | VAPI.RTPReceiver.PacketTracerFiltersUdpDstPortRange, VAPI.RTPReceiver.PacketTracerFilters>;
    get vlan_id(): VScript.dKeyword<VScript.VSocket, null | number, null | number, null | VAPI.Primitives.VlanID, null | VAPI.Primitives.VlanID, VAPI.RTPReceiver.PacketTracerFilters>;
    get dst_address(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | string, null | string, VAPI.RTPReceiver.PacketTracerFilters>;
}
export declare class MediaReceiverFlightPermit implements VScript.Referenceable<"RTPReceiver::Data::MediaReceiver::FlightPermit"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::MediaReceiver::FlightPermit";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get denied(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.RTPReceiver.MediaReceiverFlightPermit>;
    get remaining_patience(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.RTPReceiver.MediaReceiverFlightPermit>;
    /**
      internal timestamp, initialized to zero at process startup
    */
    get prev_request_at(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.RTPReceiver.DriverTime, VAPI.RTPReceiver.MediaReceiverFlightPermit>;
}
export type MPacketFormat = number;
export type MetadataBackendGroup = number;
export declare class VideoReceiverMediaSpecificHardMetadataDecoder implements VScript.Referenceable<"RTPReceiver::Data::VideoReceiver::MediaSpecific::HardMetadataDecoder"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::VideoReceiver::MediaSpecific::HardMetadataDecoder";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get statistics(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        number,
        number,
        number
    ], null | VAPI.RTPReceiver.VideoReceiverMediaSpecificHardMetadataDecoderStatistics, VAPI.RTPReceiver.VideoReceiverMediaSpecificHardMetadataDecoder>;
}
/**
  when set to `FirstStreamPresent`, the first packet stream to provide this
  receiver with valid format and timing characteristics will be used as the
  basis for the ensuing readout attempt. When set to `AllStreamsPresent`, the
  receiver will stall until all packet streams have been registered at their
  respective network interfaces. Whereas `FirstStreamPresent` may slightly
  reduce the time to readout, `AllStreamsPresent` is safer as it ensures
  immediate SPS protection (if so configured), and allows the receiver to
  correctly pick a rearguard stream if different network paths exhibit
  different transmission delays. In both cases, the set of packet streams
  considered encompasses only those flows directly referenced by this
  receiver's media description, not the auxiliary flows that may be routed to
  the receiver through stream sharing.
*/
export type MediaReceiverInitiateReadoutOn = "FirstStreamPresent" | "AllStreamsPresent";
export type MetadataBackendInstance = number;
export interface SessionInterfaces {
    primary: null | VAPI.NetworkInterfaces.VirtualInterface;
    secondary: null | VAPI.NetworkInterfaces.VirtualInterface;
}
export type PacketStreamStreamParametersIrqRate = "Standard" | "Increased";
export type AllIssues = {
    out_of_bandwidth: boolean;
    required_port_down: boolean;
};
export type MediaReceiverIssues = {
    impossible_clean_switch_request: boolean;
    missing_or_uncalibrated_t_src: boolean;
    missing_streams: boolean;
    phase_mismatch: boolean;
    uncalibrated_genlock: boolean;
    undersized_timing_window: boolean;
    unsatisfied_capability_request: boolean;
    useless_capability_assignment: boolean;
};
export type PacketTracerIssues = {
    cannot_activate_while_downloading: boolean;
    cannot_reconfigure_while_active: boolean;
    invalid_port_assignment: boolean;
    missing_port_assignment: boolean;
    non_ipv4_dst_address: boolean;
    non_multicast_dst_address: boolean;
    unordered_port_range: boolean;
};
export type PassthroughReceiverIssues = {
    subscription_failed: boolean;
};
export type SessionIssues = {
    switch_type_request_blocked: boolean;
};
export type VideoReceiverMediaSpecificIssues = {
    audio_deembedder_errors: boolean;
    drop_repeat_frames: boolean;
    misaligned_anc_data: boolean;
    no_bbm_capabilities: boolean;
    video_decoding_errors: boolean;
};
export type VideoCapabilitiesJpegXsCaliber = "JPEG_XS_upto_3G" | "JPEG_XS_singlelink_uhd";
export interface SessionLastAcceptedTrack {
    track: VAPI.RTPReceiver.Track;
    fc: VAPI.Time.FreeRunningCounter;
    controller_version: VAPI.SDP.ControllerVersion;
    /**
      Currently set to all zeroes if the given SDP does not specify a
      `controller-id`; in version 2.0 this will be replaced by a proper
      optional.
    */
    controller_id: VAPI.SDP.ControllerID;
}
export declare class MediaReceiverLatencySpread implements VScript.Referenceable<"RTPReceiver::Data::MediaReceiver::LatencySpread"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::MediaReceiver::LatencySpread";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get per_subflow(): VScript.rKeyword<VScript.VSocket, Array<null | number>, Array<null | VScript.Duration>, VAPI.RTPReceiver.MediaReceiverLatencySpread>;
    get overall(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.RTPReceiver.MediaReceiverLatencySpread>;
}
export declare class AllLicenseInformation implements VScript.Referenceable<"RTPReceiver::Data::All::LicenseInformation"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::All::LicenseInformation";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get num_jpeg_xs_receivers(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned16, VAPI.RTPReceiver.AllLicenseInformation>;
}
export interface ExpectationsMpacketFrom {
    sdp_a: boolean;
    sdp_b: boolean;
}
export declare class AllDiagnosticsMpacketTracer implements VScript.Referenceable<"RTPReceiver::Data::All::Diagnostics::MpacketTracer"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::All::Diagnostics::MpacketTracer";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      write m-packet characteristics to `prev_mpacket`. Note that this may
      cause noticeable processing overhead, and thus will not be retained
      across reboots
    */
    get active(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.RTPReceiver.AllDiagnosticsMpacketTracer>;
    get prev_mpacket(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        boolean,
        number,
        number,
        number,
        number,
        number,
        number
    ], null | VAPI.RTPReceiver.MPacketDebugInfo, VAPI.RTPReceiver.AllDiagnosticsMpacketTracer>;
}
export declare class SessionEventCountersNumRejectedSdps implements VScript.Referenceable<"RTPReceiver::Data::Session::EventCounters::NumRejectedSdps"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::Session::EventCounters::NumRejectedSdps";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      increased by 1 every time a SDP command sent to track A is rejected
    */
    get sdp_a(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.RTPReceiver.SessionEventCountersNumRejectedSdps>;
    /**
      increased by 1 every time a SDP command sent to track B is rejected
    */
    get sdp_b(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.RTPReceiver.SessionEventCountersNumRejectedSdps>;
}
/**
  when in clean-switching mode (i.e., if `switch_time` is neither 0 nor 1),
  SDP writes to `current_target` are rejected, followed by an informational
  error message. Set `on_sdp_collision` to `RejectSilently` to suppress this
  error message.
*/
export type AllSettingsOnSdpCollision = "RejectAndInform" | "RejectSilently";
/**
  Set this to `Store` to have the packet tracer store packet details (up to
  some limited maximum log file size) that can later be downloaded via HTTP.
*/
export type PacketTracerPacketDetails = "Discard" | "Store";
export type PacketTracerRunPacketDetails = "Omitted" | "Stored" | "PartiallyStored";
export declare class TimingPhaseControl implements VScript.Referenceable<"RTPReceiver::Data::Timing::PhaseControl"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::Timing::PhaseControl";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get settings(): VScript.dKeyword<VScript.VSocket, ([0, []] | [
        1,
        [
            null | number,
            null | number,
            boolean,
            [
                boolean,
                number,
                number
            ],
            null | [
                number,
                number
            ],
            null | number
        ]
    ]), ([0, []] | [
        1,
        [
            null | number,
            null | number,
            boolean,
            [
                boolean,
                number,
                number
            ],
            null | [
                number,
                number
            ],
            null | number
        ]
    ]), VAPI.RTPReceiver.PhaseControlSettings, VAPI.RTPReceiver.PhaseControlSettings, VAPI.RTPReceiver.TimingPhaseControl>;
    /**
      estimated time until |distance to buffer boundary| < 0.5 *
      `safety_margin`
    */
    get expected_time_to_collision(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.RTPReceiver.TimingPhaseControl>;
    /**
      This receiver's output phase is currently drifting, as defined by
      `settings.status.drift_tolerance`. Defaults to `true` if `current_phase`
      fails to supply a drift estimate
    */
    get drifting_phase(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.RTPReceiver.TimingPhaseControl>;
}
/**
  interpret `current_phase` as a phase error if `|current_phase.offset.value|
  > phase_sensitivity.value` and `current_phase.offset.error <
  phase_sensitivity.error × |current_phase.offset.value|`
*/
export interface PhaseControlSettingsManualPhaseSensitivity {
    value: VScript.Duration;
    error: number;
}
export type AudioServoPrioritize = "Quality" | "Responsiveness";
export declare class TimingReadDelay implements VScript.Referenceable<"RTPReceiver::Data::Timing::ReadDelay"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::Timing::ReadDelay";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get overall(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        number,
        number,
        number
    ], null | VAPI.Time.TimestampedOffset, VAPI.RTPReceiver.TimingReadDelay>;
    get rearguard(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        number,
        number,
        number
    ], null | VAPI.Time.TimestampedOffset, VAPI.RTPReceiver.TimingReadDelay>;
}
export interface TimingReadDelayBounds {
    min: null | VScript.Duration;
    max: null | VScript.Duration;
}
export declare class MediaReceiverRedundancyLevels implements VScript.Referenceable<"RTPReceiver::Data::MediaReceiver::RedundancyLevels"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::MediaReceiver::RedundancyLevels";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get nominally_present(): VAPI.RTPReceiver.CurrentRedundancyLevels;
    get within_safe_bounds(): VAPI.RTPReceiver.CurrentRedundancyLevels;
}
export interface MediaReceiverRequiredRedundancyLevel {
    /**
      number of packet streams referenced by this receiver's media description
      at track A that must have been registered at their respective network
      interfaces for the receiver to attempt readout
    */
    sdp_a: VAPI.RTPReceiver.RedundancyLevel;
    /**
      number of packet streams referenced by this receiver's media description
      at track B that must have been registered at their respective network
      interfaces for the receiver to attempt readout
    */
    sdp_b: VAPI.RTPReceiver.RedundancyLevel;
}
export interface VideoReceiverMediaSpecificSoftMetadataDecoderRtpChannelStatistics {
    packets_lost: VAPI.Primitives.CyclicCounter32;
    packets_sent: VAPI.Primitives.CyclicCounter32;
}
/**
  determines how SDP files entered into `sdp_a_command` or `sdp_b_command`
  translate into their respective `status` counterparts. If `sdp_generation`
  is set to `Verbatim`, accepted SDP files are copied to `status` unmodified,
  even if some or all of the media descriptions within could not be serviced
  due to resource exhaustion. If `sdp_generation` is set to `Semantic`, only
  operationally effective parts of the SDP will be emitted.
*/
export type AllSettingsSdpGeneration = "Semantic" | "Verbatim";
export declare class VideoReceiverMediaSpecificSoftMetadataDecoder implements VScript.Referenceable<"RTPReceiver::Data::VideoReceiver::MediaSpecific::SoftMetadataDecoder"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::VideoReceiver::MediaSpecific::SoftMetadataDecoder";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get statistics(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number
    ], null | VAPI.RTPReceiver.SoftMetadataStatistics, VAPI.RTPReceiver.VideoReceiverMediaSpecificSoftMetadataDecoder>;
    get rtp_channel_statistics(): VScript.rKeyword<VScript.VSocket, [
        number,
        number
    ], VAPI.RTPReceiver.VideoReceiverMediaSpecificSoftMetadataDecoderRtpChannelStatistics, VAPI.RTPReceiver.VideoReceiverMediaSpecificSoftMetadataDecoder>;
}
export type VideoCapabilitiesSt20422Caliber = "ST2042_2_upto_3G" | "ST2042_2_singlelink_uhd";
export type VideoCapabilitiesSt211020Caliber = "ST2110_upto_3G" | "ST2110_singlelink_uhd";
export interface VideoReceiverMediaSpecificHardMetadataDecoderStatistics {
    num_relocations: number;
    num_embedded_packets: number;
    fc: VAPI.Time.FreeRunningCounter;
    micro_epoch_index: VAPI.Time.MicroEpochIndex;
}
export interface PacketStreamStreamParameters {
    /**
      Seqnr offset relative to other packet streams mapped to the same memory
      region. N packet streams hence define N-1 meaningful offsets.
    */
    seqnr_offset: VAPI.RTPReceiver.SeqnrDifference;
    /**
      IP (unicast) address of the RTP stream sender
    */
    src_address: null | string;
    /**
      IP (multicast) destination address of the RTP stream
    */
    dst_address: null | string;
    interface: null | VAPI.NetworkInterfaces.VirtualInterface;
    type: VAPI.RTPReceiver.PacketStreamType;
    irq_rate: VAPI.RTPReceiver.PacketStreamStreamParametersIrqRate;
}
export interface PacketTracerFiltersUdpDstPortRange {
    min: VAPI.Primitives.Unsigned16;
    max: VAPI.Primitives.Unsigned16;
}
export type Unsigned12 = number;
export declare class SessionVersionWindow implements VScript.Referenceable<"RTPReceiver::Data::Session::VersionWindow"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPReceiver::Data::Session::VersionWindow";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Reject incoming SDPs unless their version (specified using a
      session-level `a=controller-version:` attribute) exceeds the most
      recently accepted version by at least this much, using cyclic 32-bit
      arithmetic
    */
    get min_delta(): VScript.dKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.RTPReceiver.SessionVersionWindow>;
    /**
      Reject incoming SDPs unless their version (specified using a
      session-level `a=controller-version:` attribute) exceeds the most
      recently accepted version by no more than this much, using cyclic 32-bit
      arithmetic
    */
    get max_delta(): VScript.dKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.RTPReceiver.SessionVersionWindow>;
}
export declare const Enums: {
    readonly VidStd20226Authority: VidStd20226Authority[];
    readonly TrackSet: TrackSet[];
    readonly Track: Track[];
    readonly StatsSubscriptionType: StatsSubscriptionType[];
    readonly SamplingStructure: SamplingStructure[];
    readonly ResourceExhaustionPolicy: ResourceExhaustionPolicy[];
    readonly PhaseMismatchSeverity: PhaseMismatchSeverity[];
    readonly PacketTracerMode: PacketTracerMode[];
    readonly PacketStreamType: PacketStreamType[];
    readonly OrderedTrackSet: OrderedTrackSet[];
    readonly OnIsolatedSubstream: OnIsolatedSubstream[];
    readonly NetworkSourceType: NetworkSourceType[];
    readonly MemoryRegion: MemoryRegion[];
    readonly MediaReceiverType: MediaReceiverType[];
    readonly LogicalSwitchTime: LogicalSwitchTime[];
    readonly JumpResponse: JumpResponse[];
    readonly IngressTrackState: IngressTrackState[];
    readonly FrameShiftPolicy: FrameShiftPolicy[];
    readonly ErrorHandler: ErrorHandler[];
    readonly ErrorCondition: ErrorCondition[];
    readonly CleanSwitchingPolicy: CleanSwitchingPolicy[];
    readonly BackpressurePolicy: BackpressurePolicy[];
};
