import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    ReadSpeedAdaptive: (_raw, _socket) => {
        return {};
    },
    PhaseControlSettingsAuto: (_raw, _socket) => {
        return {};
    },
    JpegXsCaptureStateAwaitingCSCapture: (_raw, _socket) => {
        return {};
    },
    JpegXsCaptureStateAwaitingCSCaptureTrigger: (_raw, _socket) => {
        return {};
    },
    SwitchTypeBreakBeforeMake: (_raw, _socket) => {
        return {
            switch_time: VScript.VAPIHelpers.liftTimestamp(_raw[0], _socket)
        };
    },
    TimingTargetBufferMidpoint: (_raw, _socket) => {
        return {};
    },
    CapabilityRequestIDs: (_raw, _socket) => {
        return {
            request_id: _raw[0] === null ? null : _raw[0],
            grant_id: _raw[1] === null ? null : _raw[1]
        };
    },
    CountableErrorHandler: (_raw) => (new CountableErrorHandler(_raw)),
    CurrentRedundancyLevels: (_raw) => (new CurrentRedundancyLevels(_raw)),
    Egress: (_raw, _socket) => {
        return {
            freeze_state: _raw[0].map(el => el === null ? null : VAPI.RTPReceiver.lift.FreezeState(el, _socket))
        };
    },
    TimingTargetEgressPlusX: (_raw, _socket) => {
        return {
            read_delay: VScript.VAPIHelpers.liftSeconds(_raw[0], _socket)
        };
    },
    ErrorCounter: (_raw, _socket) => {
        return {
            last_seen_at: _raw[0] === null ? null : VScript.VAPIHelpers.liftNanoseconds(_raw[0], _socket),
            consec_err_count: _raw[1],
            err_acc: _raw[2]
        };
    },
    Expectations: (_raw, _socket) => {
        return {
            sof: _raw[0],
            mpacket_from: VAPI.RTPReceiver.lift.ExpectationsMpacketFrom(_raw[1], _socket)
        };
    },
    FreezeState: (_raw, _socket) => {
        return {
            frozen: _raw[0],
            fence: _raw[1] === null ? null : _raw[1]
        };
    },
    Ingress: (_raw, _socket) => {
        return {
            sdp_a: _raw[0],
            sdp_b: _raw[1]
        };
    },
    TimingTargetIngressPlusX: (_raw, _socket) => {
        return {
            read_delay: VScript.VAPIHelpers.liftSeconds(_raw[0], _socket)
        };
    },
    InternalBufferSizes: (_raw, _socket) => {
        return {
            for_audio: _raw[0],
            for_2022_6: _raw[1],
            for_2110_20_uhd_singlelink: _raw[2],
            for_2110_20_other: _raw[3],
            for_2042_2: _raw[4],
            for_passthrough: _raw[5]
        };
    },
    JpegXsCaptureState: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "AwaitingCSCaptureTrigger", value: VAPI.RTPReceiver.lift.JpegXsCaptureStateAwaitingCSCaptureTrigger(_raw[1], _socket) };
            case 1: return { variant: "AwaitingCSCapture", value: VAPI.RTPReceiver.lift.JpegXsCaptureStateAwaitingCSCapture(_raw[1], _socket) };
            case 2: return { variant: "SteadyState", value: VAPI.RTPReceiver.lift.JpegXsCaptureStateSteadyState(_raw[1], _socket) };
        }
        ;
    },
    MPacket: (_raw, _socket) => {
        return {
            extended_frc: _raw[0],
            seqnr: _raw[1],
            format: _raw[2]
        };
    },
    MPacketDebugInfo: (_raw, _socket) => {
        return {
            packet_stream_index: _raw[0],
            m_flag: _raw[1],
            seqnr: _raw[2],
            last_word: _raw[3],
            empty: _raw[4],
            rtp_timestamp: _raw[5],
            frc: _raw[6],
            misc: _raw[7]
        };
    },
    SwitchTypeMakeBeforeBreak: (_raw, _socket) => {
        return {
            switch_time: VScript.VAPIHelpers.liftTimestamp(_raw[0], _socket)
        };
    },
    PhaseControlSettingsManual: (_raw, _socket) => {
        return {
            jump_threshold: _raw[0] === null ? null : _raw[0],
            restart_threshold: _raw[1] === null ? null : _raw[1],
            protect_safety_margin: _raw[2],
            drift_sensitivity: VAPI.RTPReceiver.lift.PhaseControlSettingsManualDriftSensitivity(_raw[3], _socket),
            phase_sensitivity: _raw[4] === null ? null : VAPI.RTPReceiver.lift.PhaseControlSettingsManualPhaseSensitivity(_raw[4], _socket),
            auto_eject_threshold: _raw[5] === null ? null : VScript.VAPIHelpers.liftSeconds(_raw[5], _socket)
        };
    },
    PacketTracerRun: (_raw, _socket) => {
        return {
            n_run: _raw[0],
            ts_start: VScript.VAPIHelpers.liftTimestamp(_raw[1], _socket),
            ts_end: VScript.VAPIHelpers.liftTimestamp(_raw[2], _socket),
            num_streams_detected: _raw[3],
            mean_packets_per_second: _raw[4],
            num_warnings_generated: _raw[5],
            num_events_captured: _raw[6],
            num_data_flags_lost: _raw[7],
            num_irq_packets_lost: _raw[8],
            packet_details: _raw[9],
            mode: _raw[10]
        };
    },
    SwitchTypePatch: (_raw, _socket) => {
        return {};
    },
    PhaseControlSettings: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "Auto", value: VAPI.RTPReceiver.lift.PhaseControlSettingsAuto(_raw[1], _socket) };
            case 1: return { variant: "Manual", value: VAPI.RTPReceiver.lift.PhaseControlSettingsManual(_raw[1], _socket) };
        }
        ;
    },
    SingleVideoDecoderWorkingSet: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "WSOther", value: VAPI.RTPReceiver.lift.SingleVideoDecoderWorkingSetWSOther(_raw[1], _socket) };
            case 1: return { variant: "WSJpegXS", value: VAPI.RTPReceiver.lift.SingleVideoDecoderWorkingSetWSJpegXS(_raw[1], _socket) };
        }
        ;
    },
    SoftMetadataStatistics: (_raw, _socket) => {
        return {
            packets_received: _raw[0],
            packets_too_old: _raw[1],
            packets_considered: _raw[2],
            packets_missing: _raw[3],
            parse_errors: _raw[4],
            type_unknown: _raw[5],
            parsed_as_empty_cea708: _raw[6],
            parsed_as_proper_cea708: _raw[7],
            parsed_as_empty_op47: _raw[8],
            parsed_as_proper_op47: _raw[9],
            parsed_as_empty_st12: _raw[10],
            parsed_as_proper_st12: _raw[11]
        };
    },
    StatsID: (_raw, _socket) => {
        return {
            irq_number: _raw[0],
            id: _raw[1]
        };
    },
    JpegXsCaptureStateSteadyState: (_raw, _socket) => {
        return {
            cs_capture_data: _raw[0].map(el => el)
        };
    },
    SwitchType: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "Patch", value: VAPI.RTPReceiver.lift.SwitchTypePatch(_raw[1], _socket) };
            case 1: return { variant: "MakeBeforeBreak", value: VAPI.RTPReceiver.lift.SwitchTypeMakeBeforeBreak(_raw[1], _socket) };
            case 2: return { variant: "BreakBeforeMake", value: VAPI.RTPReceiver.lift.SwitchTypeBreakBeforeMake(_raw[1], _socket) };
        }
        ;
    },
    TaggedNetworkSourceID: (_raw, _socket) => {
        return {
            source_id: _raw[0],
            intended_use: _raw[1],
            estimated_bandwidth: _raw[2]
        };
    },
    UsedReceiverTracks: (_raw, _socket) => {
        return {
            ingress: _raw[0],
            egress: _raw[1],
            hard_metadata: _raw[2] === null ? null : _raw[2],
            soft_metadata: _raw[3] === null ? null : _raw[3],
            current_target: _raw[4] === null ? null : _raw[4],
            next_target: _raw[5] === null ? null : _raw[5]
        };
    },
    UsedSessionTracks: (_raw, _socket) => {
        return {
            ingress: _raw[0],
            egress: _raw[1],
            current_target: _raw[2],
            next_target: _raw[3]
        };
    },
    SingleVideoDecoderWorkingSetWSJpegXS: (_raw, _socket) => {
        return {
            cs_capture_state: VAPI.RTPReceiver.lift.JpegXsCaptureState(_raw[0], _socket),
            soc_offset: _raw[1]
        };
    },
    SingleVideoDecoderWorkingSetWSOther: (_raw, _socket) => {
        return {};
    },
    AllDerivedPtpTraits: (_raw) => (new AllDerivedPtpTraits(_raw)),
    PhaseControlSettingsManualDriftSensitivity: (_raw, _socket) => {
        return {
            suppress_phase_error_on_drift: _raw[0],
            value: _raw[1],
            error: _raw[2]
        };
    },
    MediaReceiverErrorCounters: (_raw) => (new MediaReceiverErrorCounters(_raw)),
    VideoReceiverMediaSpecificErrorCounters: (_raw) => (new VideoReceiverMediaSpecificErrorCounters(_raw)),
    MediaReceiverEventCounters: (_raw) => (new MediaReceiverEventCounters(_raw)),
    SessionEventCounters: (_raw) => (new SessionEventCounters(_raw)),
    VideoReceiverMediaSpecificEventCounters: (_raw) => (new VideoReceiverMediaSpecificEventCounters(_raw)),
    PacketTracerFilters: (_raw) => (new PacketTracerFilters(_raw)),
    MediaReceiverFlightPermit: (_raw) => (new MediaReceiverFlightPermit(_raw)),
    VideoReceiverMediaSpecificHardMetadataDecoder: (_raw) => (new VideoReceiverMediaSpecificHardMetadataDecoder(_raw)),
    SessionInterfaces: (_raw, _socket) => {
        return {
            primary: _raw[0] === null ? null : new VAPI.NetworkInterfaces.VirtualInterface(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
            secondary: _raw[1] === null ? null : new VAPI.NetworkInterfaces.VirtualInterface(VScript.VAPIHelpers.get_subtree(_socket, _raw[1]))
        };
    },
    SessionLastAcceptedTrack: (_raw, _socket) => {
        return {
            track: _raw[0],
            fc: _raw[1],
            controller_version: _raw[2],
            controller_id: _raw[3].map(el => el)
        };
    },
    MediaReceiverLatencySpread: (_raw) => (new MediaReceiverLatencySpread(_raw)),
    AllLicenseInformation: (_raw) => (new AllLicenseInformation(_raw)),
    ExpectationsMpacketFrom: (_raw, _socket) => {
        return {
            sdp_a: _raw[0],
            sdp_b: _raw[1]
        };
    },
    AllDiagnosticsMpacketTracer: (_raw) => (new AllDiagnosticsMpacketTracer(_raw)),
    SessionEventCountersNumRejectedSdps: (_raw) => (new SessionEventCountersNumRejectedSdps(_raw)),
    TimingPhaseControl: (_raw) => (new TimingPhaseControl(_raw)),
    PhaseControlSettingsManualPhaseSensitivity: (_raw, _socket) => {
        return {
            value: VScript.VAPIHelpers.liftSeconds(_raw[0], _socket),
            error: _raw[1]
        };
    },
    TimingReadDelay: (_raw) => (new TimingReadDelay(_raw)),
    TimingReadDelayBounds: (_raw, _socket) => {
        return {
            min: _raw[0] === null ? null : VScript.VAPIHelpers.liftSeconds(_raw[0], _socket),
            max: _raw[1] === null ? null : VScript.VAPIHelpers.liftSeconds(_raw[1], _socket)
        };
    },
    MediaReceiverRedundancyLevels: (_raw) => (new MediaReceiverRedundancyLevels(_raw)),
    MediaReceiverRequiredRedundancyLevel: (_raw, _socket) => {
        return {
            sdp_a: _raw[0],
            sdp_b: _raw[1]
        };
    },
    VideoReceiverMediaSpecificSoftMetadataDecoderRtpChannelStatistics: (_raw, _socket) => {
        return {
            packets_lost: _raw[0],
            packets_sent: _raw[1]
        };
    },
    VideoReceiverMediaSpecificSoftMetadataDecoder: (_raw) => (new VideoReceiverMediaSpecificSoftMetadataDecoder(_raw)),
    VideoReceiverMediaSpecificHardMetadataDecoderStatistics: (_raw, _socket) => {
        return {
            num_relocations: _raw[0],
            num_embedded_packets: _raw[1],
            fc: _raw[2],
            micro_epoch_index: _raw[3]
        };
    },
    PacketStreamStreamParameters: (_raw, _socket) => {
        return {
            seqnr_offset: _raw[0],
            src_address: _raw[1] === null ? null : _raw[1],
            dst_address: _raw[2] === null ? null : _raw[2],
            interface: _raw[3] === null ? null : new VAPI.NetworkInterfaces.VirtualInterface(VScript.VAPIHelpers.get_subtree(_socket, _raw[3])),
            type: _raw[4],
            irq_rate: _raw[5]
        };
    },
    PacketTracerFiltersUdpDstPortRange: (_raw, _socket) => {
        return {
            min: _raw[0],
            max: _raw[1]
        };
    },
    SessionVersionWindow: (_raw) => (new SessionVersionWindow(_raw)),
};
export const lower = {
    ReadSpeedAdaptive: (_x, _socket) => [],
    PhaseControlSettingsAuto: (_x, _socket) => [],
    JpegXsCaptureStateAwaitingCSCapture: (_x, _socket) => [],
    JpegXsCaptureStateAwaitingCSCaptureTrigger: (_x, _socket) => [],
    SwitchTypeBreakBeforeMake: (_x, _socket) => [
        VScript.VAPIHelpers.lowerTimestamp(_x.switch_time, _socket)
    ],
    TimingTargetBufferMidpoint: (_x, _socket) => [],
    CapabilityRequestIDs: (_x, _socket) => [
        _x.request_id === null ? null : _x.request_id,
        _x.grant_id === null ? null : _x.grant_id
    ],
    CountableErrorHandler: (_x) => _x.raw.kwl,
    CurrentRedundancyLevels: (_x) => _x.raw.kwl,
    Egress: (_x, _socket) => [
        _x.freeze_state.map(el => el === null ? null : VAPI.RTPReceiver.lower.FreezeState(el, _socket))
    ],
    TimingTargetEgressPlusX: (_x, _socket) => [
        VScript.VAPIHelpers.lowerSeconds(_x.read_delay, _socket)
    ],
    ErrorCounter: (_x, _socket) => [
        _x.last_seen_at === null ? null : VScript.VAPIHelpers.lowerNanoseconds(_x.last_seen_at, _socket),
        _x.consec_err_count,
        _x.err_acc
    ],
    Expectations: (_x, _socket) => [
        _x.sof,
        VAPI.RTPReceiver.lower.ExpectationsMpacketFrom(_x.mpacket_from, _socket)
    ],
    FreezeState: (_x, _socket) => [
        _x.frozen,
        _x.fence === null ? null : _x.fence
    ],
    Ingress: (_x, _socket) => [
        _x.sdp_a,
        _x.sdp_b
    ],
    TimingTargetIngressPlusX: (_x, _socket) => [
        VScript.VAPIHelpers.lowerSeconds(_x.read_delay, _socket)
    ],
    InternalBufferSizes: (_x, _socket) => [
        _x.for_audio,
        _x.for_2022_6,
        _x.for_2110_20_uhd_singlelink,
        _x.for_2110_20_other,
        _x.for_2042_2,
        _x.for_passthrough
    ],
    JpegXsCaptureState: (_x, _socket) => {
        switch (_x.variant) {
            case "AwaitingCSCaptureTrigger": return [0, VAPI.RTPReceiver.lower.JpegXsCaptureStateAwaitingCSCaptureTrigger(_x.value, _socket)];
            case "AwaitingCSCapture": return [1, VAPI.RTPReceiver.lower.JpegXsCaptureStateAwaitingCSCapture(_x.value, _socket)];
            case "SteadyState": return [2, VAPI.RTPReceiver.lower.JpegXsCaptureStateSteadyState(_x.value, _socket)];
        }
    },
    MPacket: (_x, _socket) => [
        _x.extended_frc,
        _x.seqnr,
        _x.format
    ],
    MPacketDebugInfo: (_x, _socket) => [
        _x.packet_stream_index,
        _x.m_flag,
        _x.seqnr,
        _x.last_word,
        _x.empty,
        _x.rtp_timestamp,
        _x.frc,
        _x.misc
    ],
    SwitchTypeMakeBeforeBreak: (_x, _socket) => [
        VScript.VAPIHelpers.lowerTimestamp(_x.switch_time, _socket)
    ],
    PhaseControlSettingsManual: (_x, _socket) => [
        _x.jump_threshold === null ? null : _x.jump_threshold,
        _x.restart_threshold === null ? null : _x.restart_threshold,
        _x.protect_safety_margin,
        VAPI.RTPReceiver.lower.PhaseControlSettingsManualDriftSensitivity(_x.drift_sensitivity, _socket),
        _x.phase_sensitivity === null ? null : VAPI.RTPReceiver.lower.PhaseControlSettingsManualPhaseSensitivity(_x.phase_sensitivity, _socket),
        _x.auto_eject_threshold === null ? null : VScript.VAPIHelpers.lowerSeconds(_x.auto_eject_threshold, _socket)
    ],
    PacketTracerRun: (_x, _socket) => [
        _x.n_run,
        VScript.VAPIHelpers.lowerTimestamp(_x.ts_start, _socket),
        VScript.VAPIHelpers.lowerTimestamp(_x.ts_end, _socket),
        _x.num_streams_detected,
        _x.mean_packets_per_second,
        _x.num_warnings_generated,
        _x.num_events_captured,
        _x.num_data_flags_lost,
        _x.num_irq_packets_lost,
        _x.packet_details,
        _x.mode
    ],
    SwitchTypePatch: (_x, _socket) => [],
    PhaseControlSettings: (_x, _socket) => {
        switch (_x.variant) {
            case "Auto": return [0, VAPI.RTPReceiver.lower.PhaseControlSettingsAuto(_x.value, _socket)];
            case "Manual": return [1, VAPI.RTPReceiver.lower.PhaseControlSettingsManual(_x.value, _socket)];
        }
    },
    SingleVideoDecoderWorkingSet: (_x, _socket) => {
        switch (_x.variant) {
            case "WSOther": return [0, VAPI.RTPReceiver.lower.SingleVideoDecoderWorkingSetWSOther(_x.value, _socket)];
            case "WSJpegXS": return [1, VAPI.RTPReceiver.lower.SingleVideoDecoderWorkingSetWSJpegXS(_x.value, _socket)];
        }
    },
    SoftMetadataStatistics: (_x, _socket) => [
        _x.packets_received,
        _x.packets_too_old,
        _x.packets_considered,
        _x.packets_missing,
        _x.parse_errors,
        _x.type_unknown,
        _x.parsed_as_empty_cea708,
        _x.parsed_as_proper_cea708,
        _x.parsed_as_empty_op47,
        _x.parsed_as_proper_op47,
        _x.parsed_as_empty_st12,
        _x.parsed_as_proper_st12
    ],
    StatsID: (_x, _socket) => [
        _x.irq_number,
        _x.id
    ],
    JpegXsCaptureStateSteadyState: (_x, _socket) => [
        _x.cs_capture_data.map(el => el)
    ],
    SwitchType: (_x, _socket) => {
        switch (_x.variant) {
            case "Patch": return [0, VAPI.RTPReceiver.lower.SwitchTypePatch(_x.value, _socket)];
            case "MakeBeforeBreak": return [1, VAPI.RTPReceiver.lower.SwitchTypeMakeBeforeBreak(_x.value, _socket)];
            case "BreakBeforeMake": return [2, VAPI.RTPReceiver.lower.SwitchTypeBreakBeforeMake(_x.value, _socket)];
        }
    },
    TaggedNetworkSourceID: (_x, _socket) => [
        _x.source_id,
        _x.intended_use,
        _x.estimated_bandwidth
    ],
    UsedReceiverTracks: (_x, _socket) => [
        _x.ingress,
        _x.egress,
        _x.hard_metadata === null ? null : _x.hard_metadata,
        _x.soft_metadata === null ? null : _x.soft_metadata,
        _x.current_target === null ? null : _x.current_target,
        _x.next_target === null ? null : _x.next_target
    ],
    UsedSessionTracks: (_x, _socket) => [
        _x.ingress,
        _x.egress,
        _x.current_target,
        _x.next_target
    ],
    SingleVideoDecoderWorkingSetWSJpegXS: (_x, _socket) => [
        VAPI.RTPReceiver.lower.JpegXsCaptureState(_x.cs_capture_state, _socket),
        _x.soc_offset
    ],
    SingleVideoDecoderWorkingSetWSOther: (_x, _socket) => [],
    AllDerivedPtpTraits: (_x) => _x.raw.kwl,
    PhaseControlSettingsManualDriftSensitivity: (_x, _socket) => [
        _x.suppress_phase_error_on_drift,
        _x.value,
        _x.error
    ],
    MediaReceiverErrorCounters: (_x) => _x.raw.kwl,
    VideoReceiverMediaSpecificErrorCounters: (_x) => _x.raw.kwl,
    MediaReceiverEventCounters: (_x) => _x.raw.kwl,
    SessionEventCounters: (_x) => _x.raw.kwl,
    VideoReceiverMediaSpecificEventCounters: (_x) => _x.raw.kwl,
    PacketTracerFilters: (_x) => _x.raw.kwl,
    MediaReceiverFlightPermit: (_x) => _x.raw.kwl,
    VideoReceiverMediaSpecificHardMetadataDecoder: (_x) => _x.raw.kwl,
    SessionInterfaces: (_x, _socket) => [
        _x.primary === null ? null : _x.primary.raw.kwl,
        _x.secondary === null ? null : _x.secondary.raw.kwl
    ],
    SessionLastAcceptedTrack: (_x, _socket) => [
        _x.track,
        _x.fc,
        _x.controller_version,
        _x.controller_id.map(el => el)
    ],
    MediaReceiverLatencySpread: (_x) => _x.raw.kwl,
    AllLicenseInformation: (_x) => _x.raw.kwl,
    ExpectationsMpacketFrom: (_x, _socket) => [
        _x.sdp_a,
        _x.sdp_b
    ],
    AllDiagnosticsMpacketTracer: (_x) => _x.raw.kwl,
    SessionEventCountersNumRejectedSdps: (_x) => _x.raw.kwl,
    TimingPhaseControl: (_x) => _x.raw.kwl,
    PhaseControlSettingsManualPhaseSensitivity: (_x, _socket) => [
        VScript.VAPIHelpers.lowerSeconds(_x.value, _socket),
        _x.error
    ],
    TimingReadDelay: (_x) => _x.raw.kwl,
    TimingReadDelayBounds: (_x, _socket) => [
        _x.min === null ? null : VScript.VAPIHelpers.lowerSeconds(_x.min, _socket),
        _x.max === null ? null : VScript.VAPIHelpers.lowerSeconds(_x.max, _socket)
    ],
    MediaReceiverRedundancyLevels: (_x) => _x.raw.kwl,
    MediaReceiverRequiredRedundancyLevel: (_x, _socket) => [
        _x.sdp_a,
        _x.sdp_b
    ],
    VideoReceiverMediaSpecificSoftMetadataDecoderRtpChannelStatistics: (_x, _socket) => [
        _x.packets_lost,
        _x.packets_sent
    ],
    VideoReceiverMediaSpecificSoftMetadataDecoder: (_x) => _x.raw.kwl,
    VideoReceiverMediaSpecificHardMetadataDecoderStatistics: (_x, _socket) => [
        _x.num_relocations,
        _x.num_embedded_packets,
        _x.fc,
        _x.micro_epoch_index
    ],
    PacketStreamStreamParameters: (_x, _socket) => [
        _x.seqnr_offset,
        _x.src_address === null ? null : _x.src_address,
        _x.dst_address === null ? null : _x.dst_address,
        _x.interface === null ? null : _x.interface.raw.kwl,
        _x.type,
        _x.irq_rate
    ],
    PacketTracerFiltersUdpDstPortRange: (_x, _socket) => [
        _x.min,
        _x.max
    ],
    SessionVersionWindow: (_x) => _x.raw.kwl,
};
export class CountableErrorHandler {
    raw;
    type_identifier = "RTPReceiver::Data::CountableErrorHandler";
    constructor(raw) {
        this.raw = raw;
    }
    get threshold() {
        return new VScript.rwKeyword(this, "threshold", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get above_threshold_do() {
        return new VScript.rwKeyword(this, "above_threshold_do", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class CurrentRedundancyLevels {
    raw;
    type_identifier = "RTPReceiver::Data::CurrentRedundancyLevels";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Number of streams referenced by this receiver's SDP that are actually
      present, indexed by subflow number. The latter is typically 0, but for
      quad-link video receivers can range from 0 to 3, and is 4 for 2110-40
      flows routed into a 2110-20 video receiver.
    */
    get per_subflow() {
        return new VScript.rKeyword(this, "per_subflow", {
            lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
        });
    }
    get overall() {
        return new VScript.rKeyword(this, "overall", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class AllDerivedPtpTraits {
    raw;
    type_identifier = "RTPReceiver::Data::All::DerivedPtpTraits";
    constructor(raw) {
        this.raw = raw;
    }
    get packet_stream_media_clock() {
        return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "packet_stream_media_clock"));
    }
    get video_sof() {
        return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "video_sof"));
    }
}
export class MediaReceiverErrorCounters {
    raw;
    type_identifier = "RTPReceiver::Data::MediaReceiver::ErrorCounters";
    constructor(raw) {
        this.raw = raw;
    }
    get rx_error() {
        return new VScript.rKeyword(this, "rx_error", {
            lift: VAPI.RTPReceiver.lift.ErrorCounter,
            lower: VAPI.RTPReceiver.lower.ErrorCounter
        });
    }
    /**
      premature read errors are signalled when the decoder attempts to process
      data that has not yet been delivered by the memory controller
    */
    get premature_read() {
        return new VScript.rKeyword(this, "premature_read", {
            lift: VAPI.RTPReceiver.lift.ErrorCounter,
            lower: VAPI.RTPReceiver.lower.ErrorCounter
        });
    }
    get liveness_timeout() {
        return new VScript.rKeyword(this, "liveness_timeout", {
            lift: VAPI.RTPReceiver.lift.ErrorCounter,
            lower: VAPI.RTPReceiver.lower.ErrorCounter
        });
    }
    get phase_mismatch() {
        return new VScript.rKeyword(this, "phase_mismatch", {
            lift: VAPI.RTPReceiver.lift.ErrorCounter,
            lower: VAPI.RTPReceiver.lower.ErrorCounter
        });
    }
}
export class VideoReceiverMediaSpecificErrorCounters {
    raw;
    type_identifier = "RTPReceiver::Data::VideoReceiver::MediaSpecific::ErrorCounters";
    constructor(raw) {
        this.raw = raw;
    }
    get mpacket_error() {
        return new VScript.rKeyword(this, "mpacket_error", {
            lift: VAPI.RTPReceiver.lift.ErrorCounter,
            lower: VAPI.RTPReceiver.lower.ErrorCounter
        });
    }
    get offset_2110_error() {
        return new VScript.rKeyword(this, "offset_2110_error", {
            lift: VAPI.RTPReceiver.lift.ErrorCounter,
            lower: VAPI.RTPReceiver.lower.ErrorCounter
        });
    }
    get linenr_2110_error() {
        return new VScript.rKeyword(this, "linenr_2110_error", {
            lift: VAPI.RTPReceiver.lift.ErrorCounter,
            lower: VAPI.RTPReceiver.lower.ErrorCounter
        });
    }
    /**
      raised on audio deembedder overflow; only applies in 2022-6 mode
    */
    get audio_2022_6_deemb_read_overflow() {
        return new VScript.rKeyword(this, "audio_2022_6_deemb_read_overflow", {
            lift: VAPI.RTPReceiver.lift.ErrorCounter,
            lower: VAPI.RTPReceiver.lower.ErrorCounter
        });
    }
    /**
      raised on audio deembedder underflow; only applies in 2022-6 mode
    */
    get audio_2022_6_deemb_read_underflow() {
        return new VScript.rKeyword(this, "audio_2022_6_deemb_read_underflow", {
            lift: VAPI.RTPReceiver.lift.ErrorCounter,
            lower: VAPI.RTPReceiver.lower.ErrorCounter
        });
    }
}
export class MediaReceiverEventCounters {
    raw;
    type_identifier = "RTPReceiver::Data::MediaReceiver::EventCounters";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      increased by 1 on every start attempt targeting SDP A
    */
    get start_a() {
        return new VScript.rKeyword(this, "start_a", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      increased by 1 on every start attempt targeting SDP B
    */
    get start_b() {
        return new VScript.rKeyword(this, "start_b", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      increased by 1 on every A → B switch attempt
    */
    get switch_ab() {
        return new VScript.rKeyword(this, "switch_ab", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      increased by 1 on every B → A switch attempt
    */
    get switch_ba() {
        return new VScript.rKeyword(this, "switch_ba", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      increased by 1 on every receiver stop
    */
    get stop() {
        return new VScript.rKeyword(this, "stop", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      increased by 1 on every error-induced receiver restart
    */
    get restart() {
        return new VScript.rKeyword(this, "restart", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      increased by 1 every time an accepted SDP request evicts another SDP
      currently targeted by the decoder backend
    */
    get stop_evicted() {
        return new VScript.rKeyword(this, "stop_evicted", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      BBM video receivers that have their RX buffer supplied by other
      receivers' network streams do not attempt to freeze their decoder
      backends at switch time. If these foreign streams are withdrawn before
      the BBM switch has completed, the BBM receiver's decoder backend will be
      stopped, and `stop_abandoned` will increase by 1
    */
    get stop_abandoned() {
        return new VScript.rKeyword(this, "stop_abandoned", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      if, during SDP request processing, the completion of a previously issued
      start command has not been verified conclusively, the decoder backend may
      be stopped, in which case `stop_unfinished_start_attempt` will increase
      by 1
    */
    get stop_unfinished_start_attempt() {
        return new VScript.rKeyword(this, "stop_unfinished_start_attempt", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      if `clean_switching_policy` is set to `Whatever`, impossible
      clean-switching requests are silently converted to patch requests, thus
      causing loss-of-signal events at switch time
    */
    get downgraded_switch_requests() {
        return new VScript.rKeyword(this, "downgraded_switch_requests", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      increased by 1 every time the receiver formally switches between
      identical media flows on tracks A and B
    */
    get elided_switch_requests() {
        return new VScript.rKeyword(this, "elided_switch_requests", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class SessionEventCounters {
    raw;
    type_identifier = "RTPReceiver::Data::Session::EventCounters";
    constructor(raw) {
        this.raw = raw;
    }
    get num_rejected_sdps() {
        return VAPI.RTPReceiver.lift.SessionEventCountersNumRejectedSdps(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "num_rejected_sdps"));
    }
}
export class VideoReceiverMediaSpecificEventCounters {
    raw;
    type_identifier = "RTPReceiver::Data::VideoReceiver::MediaSpecific::EventCounters";
    constructor(raw) {
        this.raw = raw;
    }
    get frame_drop_repeat_events() {
        return new VScript.rKeyword(this, "frame_drop_repeat_events", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class PacketTracerFilters {
    raw;
    type_identifier = "RTPReceiver::Data::PacketTracer::Filters";
    constructor(raw) {
        this.raw = raw;
    }
    get udp_dst_port_range() {
        return new VScript.dKeyword(this, "udp_dst_port_range", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lift.PacketTracerFiltersUdpDstPortRange),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lower.PacketTracerFiltersUdpDstPortRange)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lift.PacketTracerFiltersUdpDstPortRange),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lower.PacketTracerFiltersUdpDstPortRange)
        }, null);
    }
    get vlan_id() {
        return new VScript.dKeyword(this, "vlan_id", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    get dst_address() {
        return new VScript.dKeyword(this, "dst_address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
}
export class MediaReceiverFlightPermit {
    raw;
    type_identifier = "RTPReceiver::Data::MediaReceiver::FlightPermit";
    constructor(raw) {
        this.raw = raw;
    }
    get denied() {
        return new VScript.rKeyword(this, "denied", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get remaining_patience() {
        return new VScript.rKeyword(this, "remaining_patience", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
        });
    }
    /**
      internal timestamp, initialized to zero at process startup
    */
    get prev_request_at() {
        return new VScript.rKeyword(this, "prev_request_at", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
        });
    }
}
export class VideoReceiverMediaSpecificHardMetadataDecoder {
    raw;
    type_identifier = "RTPReceiver::Data::VideoReceiver::MediaSpecific::HardMetadataDecoder";
    constructor(raw) {
        this.raw = raw;
    }
    get statistics() {
        return new VScript.rKeyword(this, "statistics", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lift.VideoReceiverMediaSpecificHardMetadataDecoderStatistics),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lower.VideoReceiverMediaSpecificHardMetadataDecoderStatistics)
        });
    }
}
export class MediaReceiverLatencySpread {
    raw;
    type_identifier = "RTPReceiver::Data::MediaReceiver::LatencySpread";
    constructor(raw) {
        this.raw = raw;
    }
    get per_subflow() {
        return new VScript.rKeyword(this, "per_subflow", {
            lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds)),
            lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds))
        });
    }
    get overall() {
        return new VScript.rKeyword(this, "overall", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
        });
    }
}
export class AllLicenseInformation {
    raw;
    type_identifier = "RTPReceiver::Data::All::LicenseInformation";
    constructor(raw) {
        this.raw = raw;
    }
    get num_jpeg_xs_receivers() {
        return new VScript.rKeyword(this, "num_jpeg_xs_receivers", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class AllDiagnosticsMpacketTracer {
    raw;
    type_identifier = "RTPReceiver::Data::All::Diagnostics::MpacketTracer";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      write m-packet characteristics to `prev_mpacket`. Note that this may
      cause noticeable processing overhead, and thus will not be retained
      across reboots
    */
    get active() {
        return new VScript.dKeyword(this, "active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get prev_mpacket() {
        return new VScript.rKeyword(this, "prev_mpacket", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lift.MPacketDebugInfo),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lower.MPacketDebugInfo)
        });
    }
}
export class SessionEventCountersNumRejectedSdps {
    raw;
    type_identifier = "RTPReceiver::Data::Session::EventCounters::NumRejectedSdps";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      increased by 1 every time a SDP command sent to track A is rejected
    */
    get sdp_a() {
        return new VScript.rKeyword(this, "sdp_a", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      increased by 1 every time a SDP command sent to track B is rejected
    */
    get sdp_b() {
        return new VScript.rKeyword(this, "sdp_b", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class TimingPhaseControl {
    raw;
    type_identifier = "RTPReceiver::Data::Timing::PhaseControl";
    constructor(raw) {
        this.raw = raw;
    }
    get settings() {
        return new VScript.dKeyword(this, "settings", {
            lift: VAPI.RTPReceiver.lift.PhaseControlSettings,
            lower: VAPI.RTPReceiver.lower.PhaseControlSettings
        }, {
            lift: VAPI.RTPReceiver.lift.PhaseControlSettings,
            lower: VAPI.RTPReceiver.lower.PhaseControlSettings
        }, null);
    }
    /**
      estimated time until |distance to buffer boundary| < 0.5 *
      `safety_margin`
    */
    get expected_time_to_collision() {
        return new VScript.rKeyword(this, "expected_time_to_collision", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
        });
    }
    /**
      This receiver's output phase is currently drifting, as defined by
      `settings.status.drift_tolerance`. Defaults to `true` if `current_phase`
      fails to supply a drift estimate
    */
    get drifting_phase() {
        return new VScript.rKeyword(this, "drifting_phase", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class TimingReadDelay {
    raw;
    type_identifier = "RTPReceiver::Data::Timing::ReadDelay";
    constructor(raw) {
        this.raw = raw;
    }
    get overall() {
        return new VScript.rKeyword(this, "overall", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lift.TimestampedOffset),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lower.TimestampedOffset)
        });
    }
    get rearguard() {
        return new VScript.rKeyword(this, "rearguard", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lift.TimestampedOffset),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lower.TimestampedOffset)
        });
    }
}
export class MediaReceiverRedundancyLevels {
    raw;
    type_identifier = "RTPReceiver::Data::MediaReceiver::RedundancyLevels";
    constructor(raw) {
        this.raw = raw;
    }
    get nominally_present() {
        return VAPI.RTPReceiver.lift.CurrentRedundancyLevels(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "nominally_present"));
    }
    get within_safe_bounds() {
        return VAPI.RTPReceiver.lift.CurrentRedundancyLevels(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "within_safe_bounds"));
    }
}
export class VideoReceiverMediaSpecificSoftMetadataDecoder {
    raw;
    type_identifier = "RTPReceiver::Data::VideoReceiver::MediaSpecific::SoftMetadataDecoder";
    constructor(raw) {
        this.raw = raw;
    }
    get statistics() {
        return new VScript.rKeyword(this, "statistics", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lift.SoftMetadataStatistics),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lower.SoftMetadataStatistics)
        });
    }
    get rtp_channel_statistics() {
        return new VScript.rKeyword(this, "rtp_channel_statistics", {
            lift: VAPI.RTPReceiver.lift.VideoReceiverMediaSpecificSoftMetadataDecoderRtpChannelStatistics,
            lower: VAPI.RTPReceiver.lower.VideoReceiverMediaSpecificSoftMetadataDecoderRtpChannelStatistics
        });
    }
}
export class SessionVersionWindow {
    raw;
    type_identifier = "RTPReceiver::Data::Session::VersionWindow";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Reject incoming SDPs unless their version (specified using a
      session-level `a=controller-version:` attribute) exceeds the most
      recently accepted version by at least this much, using cyclic 32-bit
      arithmetic
    */
    get min_delta() {
        return new VScript.dKeyword(this, "min_delta", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    /**
      Reject incoming SDPs unless their version (specified using a
      session-level `a=controller-version:` attribute) exceeds the most
      recently accepted version by no more than this much, using cyclic 32-bit
      arithmetic
    */
    get max_delta() {
        return new VScript.dKeyword(this, "max_delta", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
}
export const Enums = {
    VidStd20226Authority: ["SDPFmtpAttribute", "MPacketMetadata"],
    TrackSet: ["Empty", "A", "B", "AB"],
    Track: ["A", "B"],
    StatsSubscriptionType: ["InsertNew", "ReplaceOld"],
    SamplingStructure: ["Interlaced", "Progressive"],
    ResourceExhaustionPolicy: ["Refuse", "BestEffort"],
    PhaseMismatchSeverity: ["TargetViolation", "SafetyViolation"],
    PacketTracerMode: ["Seqnr", "DstPort_Delta", "Frc_Seqnr", "SrcIp_DstIp_DstPort", "Frc_Seqnr_DstPort_Timestamp"],
    PacketStreamType: ["Audio", "Video2022_6", "VideoOther", "Video2110_40_Metadata", "VideoJpegXs", "MipMap", "J2K", "Passthrough"],
    OrderedTrackSet: ["X", "A", "B", "AB", "BA", "XA", "XB"],
    OnIsolatedSubstream: ["PropagateSubstreamAttribute", "StripSubstreamAttribute"],
    NetworkSourceType: ["Audio", "Video2042_2", "Video2110_20", "Video2110_20_UHD", "VideoJpegXs", "Video2022_6", "Video2110_40_SoftMetadata", "Video2110_40_NativeMetadata", "Video2110_40_JpegXSMetadata", "Video2110_40_AncBurst", "MipMap", "J2K", "Passthrough"],
    MemoryRegion: ["Main", "Alternate"],
    MediaReceiverType: ["AncBurst", "Audio", "Video"],
    LogicalSwitchTime: ["Patch", "Past", "WithinCooldownTime", "WithinPreparationTime", "Future"],
    JumpResponse: ["Pending", "Refused"],
    IngressTrackState: ["Inactive", "Activating", "Active"],
    FrameShiftPolicy: ["Prohibit", "PermitFrameShifts", "PermitSubframeShifts"],
    ErrorHandler: ["Ignore", "RestartReceiver"],
    ErrorCondition: ["RXErrors", "PrematureRead", "LivenessTimeout", "MPacketError", "OffsetError2110", "LinenrError2110"],
    CleanSwitchingPolicy: ["Strict", "Tolerant", "Whatever"],
    BackpressurePolicy: ["Yield", "Resist"]
};
