import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly ControllerVersionWindow: (_raw: [null | number, null | number], _socket: VScript.VSocket) => ControllerVersionWindow;
};
export declare const lower: {
    readonly ControllerVersionWindow: (_x: {
        min: null | VAPI.SDP.ControllerVersion;
        max: null | VAPI.SDP.ControllerVersion;
    }, _socket: VScript.VSocket) => [null | number, null | number];
};
export type ControllerID = Array<VAPI.Primitives.Unsigned8>;
export type ControllerVersion = number;
export interface ControllerVersionWindow {
    min: null | VAPI.SDP.ControllerVersion;
    max: null | VAPI.SDP.ControllerVersion;
}
/**
  The SDP format used by software versions prior to V1.3 does not fully
  comply with SMPTE 2110 specifications (for example, the RTP receiver used
  to expect `rtpmap <payload> 2110` instead of `rtpmap <payload> raw/90000`).
  By setting `legacy_sdp` to *Accept*, old-style SDP files can still be used
  during a transitional period. Note, however, that this compatibility mode
  will be deprecated at some point.
*/
export type LegacyFormatHandler = "Accept" | "Reject";
export type NetworkPath = "Primary" | "Secondary";
export type NetworkPaths = "None" | "Primary" | "Secondary" | "Both";
export type Payload = number;
/**
  The SDP format used by software versions prior to V1.3 does not fully
  comply with SMPTE 2110 specifications (for example, video transmitters used
  to emit `rtpmap <payload> 2110` instead of `rtpmap <payload> raw/90000`).
  By setting `sdp_format` to `Legacy`, old-style SDP files can still be
  generated during a transitional period. Note, however, that this
  compatibility mode will be deprecated at some point.
*/
export type SDPFormat = "Legacy" | "Modern";
export type TTL = number;
export declare const Enums: {
    readonly SDPFormat: SDPFormat[];
    readonly NetworkPaths: NetworkPaths[];
    readonly NetworkPath: NetworkPath[];
    readonly LegacyFormatHandler: LegacyFormatHandler[];
};
