import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly Drift: (_raw: [number, number], _socket: VScript.VSocket) => Drift;
    readonly Offset: (_raw: [number, number], _socket: VScript.VSocket) => Offset;
    readonly SourceCharacteristics: (_raw: [null | VAPI.Time.OffsetType, null | VAPI.Time.GrainRate, VAPI.Time.ReferenceFrame, number], _socket: VScript.VSocket) => SourceCharacteristics;
    readonly TimestampedDrift: (_raw: [number, number, number, number], _socket: VScript.VSocket) => TimestampedDrift;
    readonly TimestampedOffset: (_raw: [number, number, number, number], _socket: VScript.VSocket) => TimestampedOffset;
    readonly TimestampedTimecode: (_raw: [null | VScript.TimecodePayload, null | VScript.TimecodePayload, null | VScript.TimecodePayload, number, number], _socket: VScript.VSocket) => TimestampedTimecode;
};
export declare const lower: {
    readonly Drift: (_x: {
        value: number;
        error: number;
    }, _socket: VScript.VSocket) => [number, number];
    readonly Offset: (_x: {
        value: VScript.Duration;
        error: VScript.Duration;
    }, _socket: VScript.VSocket) => [number, number];
    readonly SourceCharacteristics: (_x: {
        offset_type: null | VAPI.Time.OffsetType;
        grain_rate: null | VAPI.Time.GrainRate;
        drift_reference: VAPI.Time.ReferenceFrame;
        remoteness: VAPI.Primitives.Unsigned32;
    }, _socket: VScript.VSocket) => [null | VAPI.Time.OffsetType, null | VAPI.Time.GrainRate, VAPI.Time.ReferenceFrame, number];
    readonly TimestampedDrift: (_x: {
        /**
          speed of <Source> measured relative to `drift_reference_frame`. E.g.,
          if value = 5*1e-6, <Source> runs faster than `drift_reference_frame` by
          5ppm.
        */
        value: number;
        error: number;
        fc: VAPI.Time.FreeRunningCounter;
        /**
          specifies the micro epoch with respect to which the drift has been
          determined
        */
        micro_epoch_index: VAPI.Time.MicroEpochIndex;
    }, _socket: VScript.VSocket) => [number, number, number, number];
    readonly TimestampedOffset: (_x: {
        /**
          PTP-relative time offset of <Source> as defined by the machine's
          internal PTP clock (not necessarily in sync with the PTP master you may
          have in mind)
        */
        value: VScript.Duration;
        error: VScript.Duration;
        fc: VAPI.Time.FreeRunningCounter;
        /**
          specifies the micro epoch with respect to which the offset has been
          determined
        */
        micro_epoch_index: VAPI.Time.MicroEpochIndex;
    }, _socket: VScript.VSocket) => [number, number, number, number];
    readonly TimestampedTimecode: (_x: {
        ltc: null | VScript.TimecodePayload;
        vtc1: null | VScript.TimecodePayload;
        vtc2: null | VScript.TimecodePayload;
        fc: VAPI.Time.FreeRunningCounter;
        micro_epoch_index: VAPI.Time.MicroEpochIndex;
    }, _socket: VScript.VSocket) => [null | VScript.TimecodePayload, null | VScript.TimecodePayload, null | VScript.TimecodePayload, number, number];
};
export type Counts = number;
export interface Drift {
    value: number;
    error: number;
}
export type ExtendedFRC = number;
export type FreeRunningCounter = number;
export type GrainRate = "g23_98" | "g24" | "g25" | "g29_97" | "g30" | "g50" | "g59_94" | "g60" | "gRTP_48k" | "gRTP_90k" | "gRTP_27M" | "gRTP_96k";
export type MediaClockFrequency = "mcf_48k" | "mcf_96k" | "mcf_90k" | "mcf_27M";
export type MicroEpochIndex = number;
export interface Offset {
    value: VScript.Duration;
    error: VScript.Duration;
}
export type OffsetType = "Shift" | "GrainAccurateTime" | "AbsoluteTime";
export type RTPCounts = number;
export type RTPTimestamp = number;
export type ReferenceFrame = "PTP" | "FreeRunningCounter";
export interface SourceCharacteristics {
    offset_type: null | VAPI.Time.OffsetType;
    grain_rate: null | VAPI.Time.GrainRate;
    drift_reference: VAPI.Time.ReferenceFrame;
    remoteness: VAPI.Primitives.Unsigned32;
}
/**
  * `UTC` (Universal Time, Coordinated) is the standard for wall clock time.
  It is the standard that all timezones are based on. UTC has leap seconds to
  account for differences in the Earth's rotational speed. *When in doubt,
  always use `UTC`*
  
  * `TAI` (International Atomic Time) is the time standard used by PTP. It is
  a linear time standard that does not have leap seconds. TAI is currently
  ahead of UTC by 37 seconds.
*/
export type Standard = "TAI" | "UTC";
export type TimecodeType = "LTC" | "VTC1" | "VTC2";
export interface TimestampedDrift {
    /**
      speed of <Source> measured relative to `drift_reference_frame`. E.g., if
      value = 5*1e-6, <Source> runs faster than `drift_reference_frame` by
      5ppm.
    */
    value: number;
    error: number;
    fc: VAPI.Time.FreeRunningCounter;
    /**
      specifies the micro epoch with respect to which the drift has been
      determined
    */
    micro_epoch_index: VAPI.Time.MicroEpochIndex;
}
export interface TimestampedOffset {
    /**
      PTP-relative time offset of <Source> as defined by the machine's internal
      PTP clock (not necessarily in sync with the PTP master you may have in
      mind)
    */
    value: VScript.Duration;
    error: VScript.Duration;
    fc: VAPI.Time.FreeRunningCounter;
    /**
      specifies the micro epoch with respect to which the offset has been
      determined
    */
    micro_epoch_index: VAPI.Time.MicroEpochIndex;
}
export interface TimestampedTimecode {
    ltc: null | VScript.TimecodePayload;
    vtc1: null | VScript.TimecodePayload;
    vtc2: null | VScript.TimecodePayload;
    fc: VAPI.Time.FreeRunningCounter;
    micro_epoch_index: VAPI.Time.MicroEpochIndex;
}
export type SourceIssues = {
    cycle_detected: boolean;
};
export declare const Enums: {
    readonly TimecodeType: TimecodeType[];
    readonly Standard: Standard[];
    readonly ReferenceFrame: ReferenceFrame[];
    readonly OffsetType: OffsetType[];
    readonly MediaClockFrequency: MediaClockFrequency[];
    readonly GrainRate: GrainRate[];
};
