import * as VScript from "vscript";
export const lift = {
    Drift: (_raw, _socket) => {
        return { value: _raw[0], error: _raw[1] };
    },
    Offset: (_raw, _socket) => {
        return {
            value: VScript.VAPIHelpers.liftSeconds(_raw[0], _socket),
            error: VScript.VAPIHelpers.liftSeconds(_raw[1], _socket)
        };
    },
    SourceCharacteristics: (_raw, _socket) => {
        return {
            offset_type: _raw[0] === null ? null : _raw[0],
            grain_rate: _raw[1] === null ? null : _raw[1],
            drift_reference: _raw[2],
            remoteness: _raw[3]
        };
    },
    TimestampedDrift: (_raw, _socket) => {
        return {
            value: _raw[0],
            error: _raw[1],
            fc: _raw[2],
            micro_epoch_index: _raw[3]
        };
    },
    TimestampedOffset: (_raw, _socket) => {
        return {
            value: VScript.VAPIHelpers.liftSeconds(_raw[0], _socket),
            error: VScript.VAPIHelpers.liftSeconds(_raw[1], _socket),
            fc: _raw[2],
            micro_epoch_index: _raw[3]
        };
    },
    TimestampedTimecode: (_raw, _socket) => {
        return {
            ltc: _raw[0] === null ? null : _raw[0],
            vtc1: _raw[1] === null ? null : _raw[1],
            vtc2: _raw[2] === null ? null : _raw[2],
            fc: _raw[3],
            micro_epoch_index: _raw[4]
        };
    },
};
export const lower = {
    Drift: (_x, _socket) => [
        _x.value,
        _x.error
    ],
    Offset: (_x, _socket) => [
        VScript.VAPIHelpers.lowerSeconds(_x.value, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.error, _socket)
    ],
    SourceCharacteristics: (_x, _socket) => [
        _x.offset_type === null ? null : _x.offset_type,
        _x.grain_rate === null ? null : _x.grain_rate,
        _x.drift_reference,
        _x.remoteness
    ],
    TimestampedDrift: (_x, _socket) => [
        _x.value,
        _x.error,
        _x.fc,
        _x.micro_epoch_index
    ],
    TimestampedOffset: (_x, _socket) => [
        VScript.VAPIHelpers.lowerSeconds(_x.value, _socket),
        VScript.VAPIHelpers.lowerSeconds(_x.error, _socket),
        _x.fc,
        _x.micro_epoch_index
    ],
    TimestampedTimecode: (_x, _socket) => [
        _x.ltc === null ? null : _x.ltc,
        _x.vtc1 === null ? null : _x.vtc1,
        _x.vtc2 === null ? null : _x.vtc2,
        _x.fc,
        _x.micro_epoch_index
    ],
};
export const Enums = {
    TimecodeType: ["LTC", "VTC1", "VTC2"],
    Standard: ["TAI", "UTC"],
    ReferenceFrame: ["PTP", "FreeRunningCounter"],
    OffsetType: ["Shift", "GrainAccurateTime", "AbsoluteTime"],
    MediaClockFrequency: ["mcf_48k", "mcf_96k", "mcf_90k", "mcf_27M"],
    GrainRate: ["g23_98", "g24", "g25", "g29_97", "g30", "g50", "g59_94", "g60", "gRTP_48k", "gRTP_90k", "gRTP_27M", "gRTP_96k"]
};
