import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly AFD: (_raw: [VAPI.Video.AspectRatio, number, number, number, number, number], _socket: VScript.VSocket) => AFD;
    readonly ClosedCaption: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Video.ClosedCaption;
    readonly HSLCOLOUR: (_raw: [number, number, number], _socket: VScript.VSocket) => HSLCOLOUR;
    readonly HSLCOLOURWITHOPACITY: (_raw: [number, number, number, number], _socket: VScript.VSocket) => HSLCOLOURWITHOPACITY;
    readonly OverridePixelFormat: (_raw: [VAPI.Video.OverrideColorSpace, VAPI.Video.OverrideBitDepth, VAPI.Video.OverrideTransferCharacteristics], _socket: VScript.VSocket) => OverridePixelFormat;
    readonly PixelFormat: (_raw: [null | VAPI.Video.ColorSpace, VAPI.Video.BitDepth, null | VAPI.Video.TransferCharacteristics, VAPI.Video.LuminanceAndColorDifferenceSignal], _socket: VScript.VSocket) => PixelFormat;
    readonly TCLCD: (_raw: [null | VAPI.Video.TransferCharacteristics, VAPI.Video.LuminanceAndColorDifferenceSignal], _socket: VScript.VSocket) => TCLCD;
    readonly TimestampedSignature: (_raw: [number, Array<number>], _socket: VScript.VSocket) => TimestampedSignature;
    readonly ClosedCaptionChannelsPresent: (_raw: [boolean, boolean, boolean, boolean], _socket: VScript.VSocket) => ClosedCaptionChannelsPresent;
    readonly EssenceSubstream: (_raw: [VAPI.Video.SubStream, boolean], _socket: VScript.VSocket) => EssenceSubstream;
};
export declare const lower: {
    readonly AFD: (_x: {
        ar: VAPI.Video.AspectRatio;
        code: number;
        top: number;
        bottom: number;
        left: number;
        right: number;
    }, _socket: VScript.VSocket) => [VAPI.Video.AspectRatio, number, number, number, number, number];
    readonly ClosedCaption: (_x: ClosedCaption) => string;
    readonly HSLCOLOUR: (_x: {
        hue: number;
        saturation: number;
        lightness: number;
    }, _socket: VScript.VSocket) => [number, number, number];
    readonly HSLCOLOURWITHOPACITY: (_x: {
        hue: number;
        saturation: number;
        lightness: number;
        opacity: number;
    }, _socket: VScript.VSocket) => [number, number, number, number];
    readonly OverridePixelFormat: (_x: {
        colorspace: VAPI.Video.OverrideColorSpace;
        bit_depth: VAPI.Video.OverrideBitDepth;
        transfer_characteristics: VAPI.Video.OverrideTransferCharacteristics;
    }, _socket: VScript.VSocket) => [VAPI.Video.OverrideColorSpace, VAPI.Video.OverrideBitDepth, VAPI.Video.OverrideTransferCharacteristics];
    readonly PixelFormat: (_x: {
        colorspace: null | VAPI.Video.ColorSpace;
        bit_depth: VAPI.Video.BitDepth;
        tc: null | VAPI.Video.TransferCharacteristics;
        lcd: VAPI.Video.LuminanceAndColorDifferenceSignal;
    }, _socket: VScript.VSocket) => [null | VAPI.Video.ColorSpace, VAPI.Video.BitDepth, null | VAPI.Video.TransferCharacteristics, VAPI.Video.LuminanceAndColorDifferenceSignal];
    readonly TCLCD: (_x: {
        tc: null | VAPI.Video.TransferCharacteristics;
        lcd: VAPI.Video.LuminanceAndColorDifferenceSignal;
    }, _socket: VScript.VSocket) => [null | VAPI.Video.TransferCharacteristics, VAPI.Video.LuminanceAndColorDifferenceSignal];
    readonly TimestampedSignature: (_x: {
        free_running_counter: VAPI.Time.FreeRunningCounter;
        signature: Array<VAPI.Primitives.Unsigned32>;
    }, _socket: VScript.VSocket) => [number, Array<number>];
    readonly ClosedCaptionChannelsPresent: (_x: {
        c_c0: boolean;
        c_c1: boolean;
        c_c2: boolean;
        c_c3: boolean;
    }, _socket: VScript.VSocket) => [boolean, boolean, boolean, boolean];
    readonly EssenceSubstream: (_x: {
        stream: VAPI.Video.SubStream;
        splitter: boolean;
    }, _socket: VScript.VSocket) => [VAPI.Video.SubStream, boolean];
};
export interface AFD {
    ar: VAPI.Video.AspectRatio;
    code: number;
    top: number;
    bottom: number;
    left: number;
    right: number;
}
export type AspectRatio = "AR_4_3" | "AR_16_9";
export type BNCInputFreq = "ceDisable" | "ceMADI" | "ceSD" | "ceHD" | "ce3G" | "ce12G";
export type BitDepth = "BitDepth8" | "BitDepth10" | "BitDepth12" | "BitDepth10_FullRange" | "BitDepth12_FullRange";
export type CEA608Field = "L21_Field1" | "L21_Field2";
export declare class ClosedCaption implements VScript.Referenceable<"Video::Data::ClosedCaption"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Video::Data::ClosedCaption";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get mode(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.ClosedCaptionMode, null | VAPI.Video.ClosedCaptionMode, VAPI.Video.ClosedCaption>;
    get channels_present(): VScript.rKeyword<VScript.VSocket, [
        boolean,
        boolean,
        boolean,
        boolean
    ], VAPI.Video.ClosedCaptionChannelsPresent, VAPI.Video.ClosedCaption>;
    get screen(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.Video.ClosedCaption>;
}
export type ClosedCaptionChannel = "CC0" | "CC1" | "CC2" | "CC3";
export type ClosedCaptionMode = "CEA608" | "CEA708" | "OP47";
export type ColorSpace = "BT601" | "BT709" | "BT2020" | "BT2100";
export type DiracCompression = "C_2_5" | "C_3_33" | "C_4" | "C_4_44" | "C_6_66" | "C_8";
export type Field = "First" | "Second";
export type FrameRate = "f23_98" | "f24" | "f25" | "f29_97" | "f30" | "f50" | "f59_94" | "f60";
/**
  used internally by the SDP parser
*/
export type GeneralizedTransportFormat = "ST2022_6" | "ST2110_GPM" | "ST2110_BPM" | "ST2042_raw" | "ST2110_22_JpegXS" | "RFC4175";
export interface HSLCOLOUR {
    hue: number;
    saturation: number;
    lightness: number;
}
export interface HSLCOLOURWITHOPACITY {
    hue: number;
    saturation: number;
    lightness: number;
    opacity: number;
}
export type LuminanceAndColorDifferenceSignal = "YCbCr" | "ICtCp";
export type OverrideBitDepth = "Passthrough" | "BitDepth8" | "BitDepth10" | "BitDepth12" | "BitDepth10_FullRange" | "BitDepth12_FullRange";
export type OverrideColorSpace = "Passthrough" | "Remove" | "BT601" | "BT709" | "BT2020" | "BT2100";
export interface OverridePixelFormat {
    colorspace: VAPI.Video.OverrideColorSpace;
    bit_depth: VAPI.Video.OverrideBitDepth;
    transfer_characteristics: VAPI.Video.OverrideTransferCharacteristics;
}
export type OverrideTransferCharacteristics = "Passthrough" | "Remove" | "SDR" | "HLG" | "PQ";
export type PixelClockFrequency = "F13_5MHz" | "F74_175MHz" | "F74_25MHz" | "F148_35MHz" | "F148_5MHz" | "F296_7MHz" | "F297MHz";
export interface PixelFormat {
    colorspace: null | VAPI.Video.ColorSpace;
    bit_depth: VAPI.Video.BitDepth;
    tc: null | VAPI.Video.TransferCharacteristics;
    lcd: VAPI.Video.LuminanceAndColorDifferenceSignal;
}
export type Raster = "NTSC" | "PAL" | "r720" | "r1080" | "r2048" | "r2160";
export type Refresh = "fp23_98" | "fsF23_98" | "fp24" | "fsF24" | "fp25" | "fsF25" | "fp29_97" | "fsF29_97" | "fp30" | "fsF30" | "fp50" | "fi50" | "fp59_94" | "fi59_94" | "fp60" | "fi60";
export type ResolutionLevel = number;
export type SDID = number;
export type SDITXFrequency = "F74_175MHz" | "F74_25MHz" | "F148_35MHz" | "F148_5MHz" | "F296_7MHz" | "F297MHz";
export type Sampling = "b8_422_YUV" | "b10_422_YUV" | "b12_422_YUV" | "b10_444_YUV" | "b10_444_GBR" | "b12_444_YUV" | "b12_444_GBR" | "b12_444_XYZ" | "b10_4444_YUVA" | "b10_4444_GBRA" | "b8_4444_YUVA";
export type Speed = "SD" | "HD" | "s3G_A" | "s3G_B" | "s12G";
export type SquareDivisionStandard = "HD2160p50" | "HD2160p59_94" | "HD2160p60";
export type Standard = "PAL" | "NTSC" | "HD720p25" | "HD720p29_97" | "HD720p30" | "HD720p50" | "HD720p59_94" | "HD720p60" | "HD1080p23_98" | "HD1080sF23_98" | "HD1080p24" | "HD1080sF24" | "HD1080p25" | "HD1080sF25" | "HD1080p29_97" | "HD1080sF29_97" | "HD1080p30" | "HD1080sF30" | "HD1080i50" | "HD1080i59_94" | "HD1080i60" | "HD1080p50" | "HD1080p59_94" | "HD1080p60" | "HD2160p23_98" | "HD2160p24" | "HD2160p25" | "HD2160p29_97" | "HD2160p30" | "HD2160p50" | "HD2160p59_94" | "HD2160p60" | "HD1080p24_DCI" | "HD1080sF25_DCI";
export type SubStream = "QUAD_2SI_1" | "QUAD_2SI_2" | "QUAD_2SI_3" | "QUAD_2SI_4" | "UNSPECIFIED_CHANNEL_0" | "UNSPECIFIED_CHANNEL_1" | "UNSPECIFIED_CHANNEL_2" | "UNSPECIFIED_CHANNEL_3" | "UNSPECIFIED_CHANNEL_4" | "UNSPECIFIED_CHANNEL_5" | "UNSPECIFIED_CHANNEL_6" | "UNSPECIFIED_CHANNEL_7";
export type SubStream2SI = "QUAD_2SI_1" | "QUAD_2SI_2" | "QUAD_2SI_3" | "QUAD_2SI_4";
export interface TCLCD {
    tc: null | VAPI.Video.TransferCharacteristics;
    lcd: VAPI.Video.LuminanceAndColorDifferenceSignal;
}
export interface TimestampedSignature {
    free_running_counter: VAPI.Time.FreeRunningCounter;
    signature: Array<VAPI.Primitives.Unsigned32>;
}
export type TransferCharacteristics = "SDR" | "HLG" | "PQ";
export type TransportFormat = "ST2022_6" | "ST2110_GPM" | "ST2110_BPM" | "ST2042_raw" | "ST2110_22_JpegXS";
export type TransportStructure = "Interlaced" | "Segmented" | "Progressive";
export type VPID = number;
export type XsCompression = "C5To1" | "C6_66To1" | "C8To1" | "C10To1" | "C20To1" | "C25To1" | "C40To1";
export interface ClosedCaptionChannelsPresent {
    c_c0: boolean;
    c_c1: boolean;
    c_c2: boolean;
    c_c3: boolean;
}
export interface EssenceSubstream {
    stream: VAPI.Video.SubStream;
    splitter: boolean;
}
export declare const Enums: {
    readonly XsCompression: XsCompression[];
    readonly TransportStructure: TransportStructure[];
    readonly TransportFormat: TransportFormat[];
    readonly TransferCharacteristics: TransferCharacteristics[];
    readonly SubStream2SI: SubStream2SI[];
    readonly SubStream: SubStream[];
    readonly Standard: Standard[];
    readonly SquareDivisionStandard: SquareDivisionStandard[];
    readonly Speed: Speed[];
    readonly Sampling: Sampling[];
    readonly SDITXFrequency: SDITXFrequency[];
    readonly Refresh: Refresh[];
    readonly Raster: Raster[];
    readonly PixelClockFrequency: PixelClockFrequency[];
    readonly OverrideTransferCharacteristics: OverrideTransferCharacteristics[];
    readonly OverrideColorSpace: OverrideColorSpace[];
    readonly OverrideBitDepth: OverrideBitDepth[];
    readonly LuminanceAndColorDifferenceSignal: LuminanceAndColorDifferenceSignal[];
    readonly GeneralizedTransportFormat: GeneralizedTransportFormat[];
    readonly FrameRate: FrameRate[];
    readonly Field: Field[];
    readonly DiracCompression: DiracCompression[];
    readonly ColorSpace: ColorSpace[];
    readonly ClosedCaptionMode: ClosedCaptionMode[];
    readonly ClosedCaptionChannel: ClosedCaptionChannel[];
    readonly CEA608Field: CEA608Field[];
    readonly BitDepth: BitDepth[];
    readonly BNCInputFreq: BNCInputFreq[];
    readonly AspectRatio: AspectRatio[];
};
