import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    AutoFader: (_raw) => (new AutoFader(_raw)),
    BSLKMixer: (_raw) => (new BSLKMixer(_raw)),
    AutoFaderTransition: (_raw, _socket) => {
        return {
            target: _raw[0],
            time: VScript.VAPIHelpers.liftNanoseconds(_raw[1], _socket)
        };
    },
};
export const lower = {
    AutoFader: (_x) => _x.raw.kwl,
    BSLKMixer: (_x) => _x.raw.kwl,
    AutoFaderTransition: (_x, _socket) => [
        _x.target,
        VScript.VAPIHelpers.lowerNanoseconds(_x.time, _socket)
    ],
};
export class AutoFader {
    raw;
    type_identifier = "VideoMixer::Data::AutoFader";
    constructor(raw) {
        this.raw = raw;
    }
    get current() {
        return new VScript.rKeyword(this, "current", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get transition() {
        return new VScript.rwKeyword(this, "transition", {
            lift: VAPI.VideoMixer.lift.AutoFaderTransition,
            lower: VAPI.VideoMixer.lower.AutoFaderTransition
        }, {
            lift: VAPI.VideoMixer.lift.AutoFaderTransition,
            lower: VAPI.VideoMixer.lower.AutoFaderTransition
        }, null);
    }
}
export class BSLKMixer {
    raw;
    type_identifier = "VideoMixer::Data::BSLK::Mixer";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Fader value for crossfade in MIXER mode, or for v_src0 in
      MIXER_INDEPENDENT mode
    */
    get fader0() {
        return VAPI.VideoMixer.lift.AutoFader(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "fader0"));
    }
    /**
      Fader value for for source1 in MIXER_INDEPENDENT mode, unused otherwise
    */
    get fader1() {
        return VAPI.VideoMixer.lift.AutoFader(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "fader1"));
    }
    /**
      Color mixed in when the sum of fader0 and fader1 is below 1.0 in
      MIXER_INDEPENDENT mode
    */
    get fade_via() {
        return new VScript.rwKeyword(this, "fade_via", {
            lift: VAPI.Video.lift.HSLCOLOUR,
            lower: VAPI.Video.lower.HSLCOLOUR
        }, {
            lift: VAPI.Video.lift.HSLCOLOUR,
            lower: VAPI.Video.lower.HSLCOLOUR
        }, null);
    }
    /**
      Which input is the ANC data and V sync source
    */
    get anc_input() {
        return new VScript.rKeyword(this, "anc_input", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export const Enums = {
    BSLKMode: ["MIXER", "MIXER_INDEPENDENT", "LUMA_KEYER", "LUMA_KEYER_ADDITIVE"]
};
