import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare namespace Audio {
    const lift: {
        readonly Essence: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Essence;
        readonly TimedSource: (_raw: [null | string, null | number | string], _socket: VScript.VSocket) => TimedSource;
    };
    const lower: {
        readonly Essence: (_x: Essence) => string;
        readonly TimedSource: (_x: {
            source: null | VAPI.AT1101.Audio.Essence;
            switch_time: null | VAPI.Primitives.Timestamp;
        }, _socket: VScript.VSocket) => [null | string, null | number | string];
    };
    class Essence implements VScript.Referenceable<"Audio::Data::Essence"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Audio::Data::Essence";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.Audio.Essence>;
        get sop_dt_node(): VScript.rKeyword<VScript.VSocket, null | VScript.DeviceTreeNodePayload, null | VScript.DeviceTreeNodePayload, VAPI.AT1101.Audio.Essence>;
        get channels(): VScript.rKeywordReferenceable<VScript.VSocket, "channels", null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel, Array<null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ]>, Array<null | VAPI.Audio.Channel>, "Audio::Data::Essence", VAPI.AT1101.Audio.Essence>;
        /**
          some signal sources, such as RTP audio/video streams, include a
          well-defined offset to the PTP epoch (as seen by the sender). During
          processing, these 'media clocks' may shift (e.g., as signals pass through
          delay elements) or broaden into finite intervals (e.g., as audio channels
          at different offsets to the PTP epoch are combined into a single audio
          essence). Using the `media_clock` keyword, such changes are tracked
          explicitly and forwarded to audio/video transmitters.
        */
        get media_clock(): VAPI.AT1101.Time.Source;
    }
    interface TimedSource {
        source: null | VAPI.AT1101.Audio.Essence;
        switch_time: null | VAPI.Primitives.Timestamp;
    }
}
export declare namespace AudioGain {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly Levels: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Levels;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly Levels: (_x: Levels) => string;
    };
    class All implements VScript.Referenceable<"AudioGain::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioGain::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get instances(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioGain::Data::Levels", LevelsAsNamedTableRow>;
    }
    class Levels implements VScript.Referenceable<"AudioGain::Data::Levels"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioGain::Data::Levels";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get a_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Audio.Essence, null | VScript.Referenceable<"Audio::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.AudioGain.Levels>;
        get levels(): VScript.rwKeyword<VScript.VSocket, Array<number>, VScript.MaybeSparseArray<number>, Array<number>, VScript.MaybeSparseArray<number>, VAPI.AT1101.AudioGain.Levels>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, Array<boolean>, VScript.MaybeSparseArray<boolean>, Array<boolean>, VScript.MaybeSparseArray<boolean>, VAPI.AT1101.AudioGain.Levels>;
        get output(): VAPI.AT1101.Audio.Essence;
    }
    class LevelsAsNamedTableRow extends Levels {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
}
export declare namespace AudioMixer {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly ChannelMono: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ChannelMono;
        readonly ChannelSelection: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ChannelSelection;
        readonly ChannelStereo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ChannelStereo;
        readonly Downmixes: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Downmixes;
        readonly Mode51: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Mode51;
        readonly Mode71: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Mode71;
        readonly Monos: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Monos;
        readonly Source: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Source;
        readonly SourceStereo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SourceStereo;
        readonly Stereos: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Stereos;
        readonly StereosOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => StereosOutput;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly ChannelMono: (_x: ChannelMono) => string;
        readonly ChannelSelection: (_x: ChannelSelection) => string;
        readonly ChannelStereo: (_x: ChannelStereo) => string;
        readonly Downmixes: (_x: Downmixes) => string;
        readonly Mode51: (_x: Mode51) => string;
        readonly Mode71: (_x: Mode71) => string;
        readonly Monos: (_x: Monos) => string;
        readonly Source: (_x: Source) => string;
        readonly SourceStereo: (_x: SourceStereo) => string;
        readonly Stereos: (_x: Stereos) => string;
        readonly StereosOutput: (_x: StereosOutput) => string;
    };
    class All implements VScript.Referenceable<"AudioMixer::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::All";
        get runtime_constants(): {
            readonly num_audio_mixer_fader: number;
            readonly num_audio_mixer_outputs: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          @brief Defragment
          @desc Repeated allocation and deallocation of differently sized mixers
          can cause fader fragmentation. Press this button to defragment, but
          please note that _this will temporarily interrupt all outputs currently
          in use_.
        */
        get reorder_output(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.AudioMixer.All>;
        get mono_mixes(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioMixer::Data::Monos", MonosAsNamedTableRow>;
        get stereo_mixes(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioMixer::Data::Stereos", StereosAsNamedTableRow>;
        get down_mixes(): Downmixes;
        get resource_status(): VAPI.AudioMixer.ResourceStatus;
        get audio_source_slices(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
    }
    class ChannelMono implements VScript.Referenceable<"AudioMixer::Data::ChannelMono"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::ChannelMono";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get gain(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.AudioMixer.ChannelMono>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.AudioMixer.ChannelMono>;
        get mute(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.AudioMixer.ChannelMono>;
        get pan(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.AudioMixer.ChannelMono>;
        get source(): Source;
    }
    class ChannelMonoAsNamedTableRow extends ChannelMono {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class ChannelSelection implements VScript.Referenceable<"AudioMixer::Data::ChannelSelection"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::ChannelSelection";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get gain(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.AudioMixer.ChannelSelection>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.AudioMixer.ChannelSelection>;
        get mute(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.AudioMixer.ChannelSelection>;
        get source(): Source;
    }
    class ChannelSelectionAsNamedTableRow extends ChannelSelection {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class ChannelStereo implements VScript.Referenceable<"AudioMixer::Data::ChannelStereo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::ChannelStereo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get gain(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.AudioMixer.ChannelStereo>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.AudioMixer.ChannelStereo>;
        get mute(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.AudioMixer.ChannelStereo>;
        get balance(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.AudioMixer.ChannelStereo>;
        get source(): SourceStereo;
    }
    class ChannelStereoAsNamedTableRow extends ChannelStereo {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Downmixes implements VScript.Referenceable<"AudioMixer::Data::Downmixes"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::Downmixes";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get mode_5_1(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioMixer::Data::Mode51", Mode51AsNamedTableRow>;
        get mode_7_1(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioMixer::Data::Mode71", Mode71AsNamedTableRow>;
    }
    class Mode51 implements VScript.Referenceable<"AudioMixer::Data::Mode51"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::Mode51";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get front_left(): ChannelSelection;
        get front_right(): ChannelSelection;
        get center(): ChannelSelection;
        get lfe(): ChannelSelection;
        get rear_surround_left(): ChannelSelection;
        get rear_surround_right(): ChannelSelection;
        get output(): VAPI.AT1101.Audio.Essence;
    }
    class Mode51AsNamedTableRow extends Mode51 {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Mode71 implements VScript.Referenceable<"AudioMixer::Data::Mode71"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::Mode71";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get front_left(): ChannelSelection;
        get front_right(): ChannelSelection;
        get center(): ChannelSelection;
        get surround_left(): ChannelSelection;
        get surround_right(): ChannelSelection;
        get lfe(): ChannelSelection;
        get rear_surround_left(): ChannelSelection;
        get rear_surround_right(): ChannelSelection;
        get output(): VAPI.AT1101.Audio.Essence;
    }
    class Mode71AsNamedTableRow extends Mode71 {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Monos implements VScript.Referenceable<"AudioMixer::Data::Monos"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::Monos";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get channels(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioMixer::Data::ChannelSelection", ChannelSelectionAsNamedTableRow>;
        get output(): VAPI.AT1101.Audio.Essence;
    }
    class MonosAsNamedTableRow extends Monos {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Source implements VScript.Referenceable<"AudioMixer::Data::Source"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::Source";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get channel(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.AudioMixer.Source>;
        get a_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Audio.Essence, null | VScript.Referenceable<"Audio::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.AudioMixer.Source>;
    }
    class SourceStereo implements VScript.Referenceable<"AudioMixer::Data::SourceStereo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::SourceStereo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get channel_left(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.AudioMixer.SourceStereo>;
        get channel_right(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.AudioMixer.SourceStereo>;
        get a_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Audio.Essence, null | VScript.Referenceable<"Audio::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.AudioMixer.SourceStereo>;
    }
    class Stereos implements VScript.Referenceable<"AudioMixer::Data::Stereos"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::Stereos";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get mono_channels(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioMixer::Data::ChannelMono", ChannelMonoAsNamedTableRow>;
        get stereo_pairs(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioMixer::Data::ChannelStereo", ChannelStereoAsNamedTableRow>;
        get output(): StereosOutput;
    }
    class StereosAsNamedTableRow extends Stereos {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class StereosOutput implements VScript.Referenceable<"AudioMixer::Data::Stereos::Output"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioMixer::Data::Stereos::Output";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          Reset to default
        */
        get reset_to_default(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.AudioMixer.StereosOutput>;
        get gain(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.AudioMixer.StereosOutput>;
        get phase_inversion(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.AudioMixer.StereosOutput>;
        get output(): VAPI.AT1101.Audio.Essence;
    }
}
export declare namespace AudioRePlay {
    const lift: {
        readonly Audio: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Audio;
        readonly Buffer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Buffer;
        readonly Delay: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Delay;
        readonly DelayOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => DelayOutput;
        readonly Player: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Player;
        readonly PlayerOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PlayerOutput;
        readonly RelationAudio: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationAudio;
        readonly RelationVideo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationVideo;
        readonly Relations: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Relations;
        readonly Time: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Time;
        readonly RelationAudioFollowers: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationAudioFollowers;
        readonly RelationVideoFollowers: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationVideoFollowers;
        readonly DelayInputs: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => DelayInputs;
    };
    const lower: {
        readonly Audio: (_x: Audio) => string;
        readonly Buffer: (_x: Buffer) => string;
        readonly Delay: (_x: Delay) => string;
        readonly DelayOutput: (_x: DelayOutput) => string;
        readonly Player: (_x: Player) => string;
        readonly PlayerOutput: (_x: PlayerOutput) => string;
        readonly RelationAudio: (_x: RelationAudio) => string;
        readonly RelationVideo: (_x: RelationVideo) => string;
        readonly Relations: (_x: Relations) => string;
        readonly Time: (_x: Time) => string;
        readonly RelationAudioFollowers: (_x: RelationAudioFollowers) => string;
        readonly RelationVideoFollowers: (_x: RelationVideoFollowers) => string;
        readonly DelayInputs: (_x: DelayInputs) => string;
    };
    class Audio implements VScript.Referenceable<"AudioRePlay::Data::Audio"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::Audio";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get info(): VAPI.DataRePlay.MemoryInfo;
        get players(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioRePlay::Data::Player", PlayerAsNamedTableRow>;
        get delays(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioRePlay::Data::Delay", DelayAsNamedTableRow>;
        get statistics(): VAPI.DataRePlay.Statistic;
        get ecc(): VAPI.Memory.ECCMuxStatistics;
        get audio_source_slices(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
    }
    class Buffer implements VScript.Referenceable<"AudioRePlay::Data::Buffer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::Buffer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get offset(): VScript.dKeyword<VScript.VSocket, null | ([0, [number]] | [
            1,
            [number]
        ]), null | ([0, [number]] | [
            1,
            [number]
        ]), null | VAPI.AudioRePlay.AllocationMode, null | VAPI.AudioRePlay.AllocationMode, VAPI.AT1101.AudioRePlay.Buffer>;
        get audio_follow_video(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.AudioRePlay.Buffer>;
        get auto_dolby_e_aligner(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.AudioRePlay.Buffer>;
        get measurement_reference(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.AudioRePlay.Buffer>;
        get current_delay(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number,
            number,
            number,
            number
        ], null | VAPI.AudioRePlay.BufferCurrentDelay, VAPI.AT1101.AudioRePlay.Buffer>;
    }
    class Delay implements VScript.Referenceable<"AudioRePlay::Data::Delay"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::Delay";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AudioRePlay.DelayIssues, VAPI.AT1101.AudioRePlay.Delay>;
        get capabilities(): VAPI.AudioRePlay.BufferInput;
        get num_outputs(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.AudioRePlay.Delay>;
        /**
          Restart writer and reader
        */
        get restart(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.AudioRePlay.Delay>;
        get dolby_e(): VAPI.AudioRePlay.DolbyE;
        get inputs(): DelayInputs;
        get outputs(): VScript.StronglyTypedTable<VScript.VSocket, "AudioRePlay::Data::DelayOutput", DelayOutput>;
    }
    class DelayAsNamedTableRow extends Delay {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class DelayOutput implements VScript.Referenceable<"AudioRePlay::Data::DelayOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::DelayOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.AudioRePlay.DelayOutput>;
        get delay(): Buffer;
        get afv(): VAPI.AudioRePlay.AFVRef;
        get dolby_e(): VAPI.AudioRePlay.DolbyERef;
        get reader(): VScript.StronglyTypedTable<VScript.VSocket, "AudioRePlay::Data::Reader", VAPI.AudioRePlay.Reader>;
        get audio(): VAPI.AT1101.Audio.Essence;
    }
    class Player implements VScript.Referenceable<"AudioRePlay::Data::Player"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::Player";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AudioRePlay.PlayerIssues, VAPI.AT1101.AudioRePlay.Player>;
        get upload_header(): VAPI.AudioRePlay.UploadHeader;
        get capabilities(): VAPI.AudioRePlay.BufferInput;
        get gang(): Relations;
        /**
          Restart writer and reader
        */
        get restart(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.AudioRePlay.Player>;
        get output(): PlayerOutput;
    }
    class PlayerAsNamedTableRow extends Player {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class PlayerOutput implements VScript.Referenceable<"AudioRePlay::Data::PlayerOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::PlayerOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.AudioRePlay.PlayerOutput>;
        get control(): VAPI.AudioRePlay.Control;
        get reader(): VScript.StronglyTypedTable<VScript.VSocket, "AudioRePlay::Data::Reader", VAPI.AudioRePlay.Reader>;
        get audio(): VAPI.AT1101.Audio.Essence;
    }
    class RelationAudio implements VScript.Referenceable<"AudioRePlay::Data::RelationAudio"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::RelationAudio";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get leader(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.AudioRePlay.Player, null | VScript.Referenceable<"AudioRePlay::Data::Player"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.AudioRePlay.RelationAudio>;
        get followers(): VScript.StronglyTypedTable<VScript.VSocket, "AudioRePlay::Data::RelationAudio::Followers", RelationAudioFollowers>;
    }
    class RelationVideo implements VScript.Referenceable<"AudioRePlay::Data::RelationVideo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::RelationVideo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get leader(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.VideoPlayer.Player, null | VScript.Referenceable<"VideoPlayer::Data::Player"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.AudioRePlay.RelationVideo>;
        get followers(): VScript.StronglyTypedTable<VScript.VSocket, "AudioRePlay::Data::RelationVideo::Followers", RelationVideoFollowers>;
    }
    class Relations implements VScript.Referenceable<"AudioRePlay::Data::Relations"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::Relations";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video(): RelationVideo;
        get audio(): RelationAudio;
    }
    class Time implements VScript.Referenceable<"AudioRePlay::Data::Time"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::Time";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.AudioRePlay.Time>;
    }
    class RelationAudioFollowers implements VScript.Referenceable<"AudioRePlay::Data::RelationAudio::Followers"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::RelationAudio::Followers";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          TODO:
        */
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.AudioRePlay.Player, VAPI.AT1101.AudioRePlay.RelationAudioFollowers>;
    }
    class RelationVideoFollowers implements VScript.Referenceable<"AudioRePlay::Data::RelationVideo::Followers"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::RelationVideo::Followers";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          TODO:
        */
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.VideoPlayer.Player, VAPI.AT1101.AudioRePlay.RelationVideoFollowers>;
    }
    class DelayInputs implements VScript.Referenceable<"AudioRePlay::Data::Delay::Inputs"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioRePlay::Data::Delay::Inputs";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.AudioRePlay.DelayInputs>;
        get a_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Audio.Essence, null | VScript.Referenceable<"Audio::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.AudioRePlay.DelayInputs>;
        get writer(): VScript.StronglyTypedTable<VScript.VSocket, "AudioRePlay::Data::Writer", VAPI.AudioRePlay.Writer>;
    }
}
export declare namespace AudioShuffler {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly Shuffler: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Shuffler;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly Shuffler: (_x: Shuffler) => string;
    };
    class All implements VScript.Referenceable<"AudioShuffler::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioShuffler::Data::All";
        get runtime_constants(): {
            readonly num_shuffler_instances: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get global_cross_fade(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | VScript.Duration, null | VScript.Duration, VAPI.AT1101.AudioShuffler.All>;
        get instances(): VScript.StronglyTypedNamedTable<VScript.VSocket, "AudioShuffler::Data::Shuffler", ShufflerAsNamedTableRow>;
    }
    class Shuffler implements VScript.Referenceable<"AudioShuffler::Data::Shuffler"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioShuffler::Data::Shuffler";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get a_src(): VScript.dKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1101.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VScript.MaybeSparseArray<null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "channels", "Audio::Data::Essence", VScript.Referenceable<"Audio::Data::Essence"> & VAPI.AT1101.Audio.Essence, null | [
            null | string,
            number,
            boolean,
            [
                number,
                number,
                number,
                number,
                number
            ]
        ], null | VAPI.Audio.Channel>>, VAPI.AT1101.AudioShuffler.Shuffler>;
        get cross_fade(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | VScript.Duration, null | VScript.Duration, VAPI.AT1101.AudioShuffler.Shuffler>;
        get output(): VAPI.AT1101.Audio.Essence;
    }
    class ShufflerAsNamedTableRow extends Shuffler {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
}
export declare namespace AudioSignalGenerator {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly OUT: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => OUT;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly OUT: (_x: OUT) => string;
    };
    class All implements VScript.Referenceable<"AudioSignalGenerator::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioSignalGenerator::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get signal_aggregate(): OUT;
        get signal_silence(): VAPI.AT1101.Audio.Essence;
        get signal_400hz(): OUT;
        get signal_440hz(): OUT;
        get signal_1000hz(): OUT;
        get source_slice(): VAPI.Audio.SignalSourceSlice;
        get output_alsa(): VAPI.AT1101.Audio.Essence;
        get source_slice_alsa(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
    }
    class OUT implements VScript.Referenceable<"AudioSignalGenerator::Data::OUT"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "AudioSignalGenerator::Data::OUT";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get level(): VScript.dKeyword<VScript.VSocket, VAPI.Audio.Level, VAPI.Audio.Level, VAPI.Audio.Level, VAPI.Audio.Level, VAPI.AT1101.AudioSignalGenerator.OUT>;
        get output(): VAPI.AT1101.Audio.Essence;
    }
}
export declare namespace Cluster {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly ClusterGlobal: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterGlobal;
        readonly ClusterGlobalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterGlobalRuntime;
        readonly ClusterLocal: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterLocal;
        readonly ClusterLocalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterLocalRuntime;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly ClusterGlobal: (_x: ClusterGlobal) => string;
        readonly ClusterGlobalRuntime: (_x: ClusterGlobalRuntime) => string;
        readonly ClusterLocal: (_x: ClusterLocal) => string;
        readonly ClusterLocalRuntime: (_x: ClusterLocalRuntime) => string;
    };
    class All implements VScript.Referenceable<"Cluster::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Cluster::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get global(): ClusterGlobal;
        get local(): ClusterLocal;
    }
    class ClusterGlobal implements VScript.Referenceable<"Cluster::Data::ClusterGlobal"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Cluster::Data::ClusterGlobal";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get configuration(): VAPI.Cluster.ClusterGlobalConfiguration;
        get runtime(): ClusterGlobalRuntime;
    }
    class ClusterGlobalRuntime implements VScript.Referenceable<"Cluster::Data::ClusterGlobalRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Cluster::Data::ClusterGlobalRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get connected_to_myself(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.Cluster.ClusterGlobalRuntime>;
        get nodes(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterNodes::Data::ClusterNodeGlobalRuntime", VAPI.ClusterNodes.ClusterNodeGlobalRuntime>;
        get sources(): VAPI.AT1101.ClusterSources.ClusterSourcesGlobalRuntime;
        get outputs(): VAPI.ClusterOutputs.ClusterOutputsGlobalRuntime;
        get monitoring_objects(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterMonitoringObjects::Data::ClusterMonitoringObjectGlobalRuntime", VAPI.AT1101.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalRuntime>;
    }
    class ClusterLocal implements VScript.Referenceable<"Cluster::Data::ClusterLocal"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Cluster::Data::ClusterLocal";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get runtime(): ClusterLocalRuntime;
    }
    class ClusterLocalRuntime implements VScript.Referenceable<"Cluster::Data::ClusterLocalRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Cluster::Data::ClusterLocalRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get processors(): VAPI.AT1101.ClusterProcessors.ClusterProcessorsLocalRuntime;
        get statistics(): VAPI.Cluster.ClusterStatistics;
    }
}
export declare namespace ClusterMonitoringObjects {
    const lift: {
        readonly ClusterAudioMonitoringObjectRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterAudioMonitoringObjectRuntime;
        readonly ClusterMetadataMonitoringObjectRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterMetadataMonitoringObjectRuntime;
        readonly ClusterMonitoringObjectGlobalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterMonitoringObjectGlobalRuntime;
        readonly ClusterVideoMonitoringObjectRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterVideoMonitoringObjectRuntime;
    };
    const lower: {
        readonly ClusterAudioMonitoringObjectRuntime: (_x: ClusterAudioMonitoringObjectRuntime) => string;
        readonly ClusterMetadataMonitoringObjectRuntime: (_x: ClusterMetadataMonitoringObjectRuntime) => string;
        readonly ClusterMonitoringObjectGlobalRuntime: (_x: ClusterMonitoringObjectGlobalRuntime) => string;
        readonly ClusterVideoMonitoringObjectRuntime: (_x: ClusterVideoMonitoringObjectRuntime) => string;
    };
    class ClusterAudioMonitoringObjectRuntime implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterAudioMonitoringObjectRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterAudioMonitoringObjectRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get source(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.ClusterSources.ClusterAudioSourceRuntime, VAPI.AT1101.ClusterMonitoringObjects.ClusterAudioMonitoringObjectRuntime>;
        get alarms(): VScript.rKeyword<VScript.VSocket, [
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean
        ], VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectRuntimeAlarms, VAPI.AT1101.ClusterMonitoringObjects.ClusterAudioMonitoringObjectRuntime>;
    }
    class ClusterMetadataMonitoringObjectRuntime implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterMetadataMonitoringObjectRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterMetadataMonitoringObjectRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get source(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.ClusterSources.ClusterMetadataSourceRuntime, VAPI.AT1101.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectRuntime>;
        get alarms(): VScript.rKeyword<VScript.VSocket, [
            boolean,
            boolean,
            boolean,
            boolean
        ], VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectRuntimeAlarms, VAPI.AT1101.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectRuntime>;
    }
    class ClusterMonitoringObjectGlobalRuntime implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterMonitoringObjectGlobalRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterMonitoringObjectGlobalRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get alarm(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalRuntime>;
        get alarm_severity_level(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterMonitoringObjects.SeverityLevel, VAPI.AT1101.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalRuntime>;
        get video(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterMonitoringObjects::Data::ClusterVideoMonitoringObjectRuntime", ClusterVideoMonitoringObjectRuntime>;
        get audio(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterMonitoringObjects::Data::ClusterAudioMonitoringObjectRuntime", ClusterAudioMonitoringObjectRuntime>;
        get metadata(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterMonitoringObjects::Data::ClusterMetadataMonitoringObjectRuntime", ClusterMetadataMonitoringObjectRuntime>;
        get user_labels(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterSources::Data::ClusterSourceLabelDual", VAPI.ClusterSources.ClusterSourceLabelDual>;
        get configuration(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalConfiguration, VAPI.AT1101.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalRuntime>;
    }
    class ClusterVideoMonitoringObjectRuntime implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterVideoMonitoringObjectRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterVideoMonitoringObjectRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get source(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.ClusterSources.ClusterVideoSourceRuntime, VAPI.AT1101.ClusterMonitoringObjects.ClusterVideoMonitoringObjectRuntime>;
        get alarms(): VScript.rKeyword<VScript.VSocket, [
            boolean,
            boolean,
            boolean,
            boolean,
            boolean
        ], VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectRuntimeAlarms, VAPI.AT1101.ClusterMonitoringObjects.ClusterVideoMonitoringObjectRuntime>;
        get tally_mask(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterMonitoringObjects.TUnsignedMax, VAPI.ClusterMonitoringObjects.TUnsignedMax, VAPI.AT1101.ClusterMonitoringObjects.ClusterVideoMonitoringObjectRuntime>;
        get label(): VAPI.ClusterSources.ClusterSourceLabelDual;
    }
}
export declare namespace ClusterProcessors {
    const lift: {
        readonly ClusterProcessorMipMapsDualOutputRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterProcessorMipMapsDualOutputRuntime;
        readonly ClusterProcessorMipMapsDualOutputRuntimeSource: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterProcessorMipMapsDualOutputRuntimeSource;
        readonly ClusterProcessorsLocalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterProcessorsLocalRuntime;
        readonly ClusterProcessorsMetadataRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterProcessorsMetadataRuntime;
        readonly ClusterProcessorsMipMapsRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterProcessorsMipMapsRuntime;
    };
    const lower: {
        readonly ClusterProcessorMipMapsDualOutputRuntime: (_x: ClusterProcessorMipMapsDualOutputRuntime) => string;
        readonly ClusterProcessorMipMapsDualOutputRuntimeSource: (_x: ClusterProcessorMipMapsDualOutputRuntimeSource) => string;
        readonly ClusterProcessorsLocalRuntime: (_x: ClusterProcessorsLocalRuntime) => string;
        readonly ClusterProcessorsMetadataRuntime: (_x: ClusterProcessorsMetadataRuntime) => string;
        readonly ClusterProcessorsMipMapsRuntime: (_x: ClusterProcessorsMipMapsRuntime) => string;
    };
    class ClusterProcessorMipMapsDualOutputRuntime implements VScript.Referenceable<"ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get local_sources(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntimeSource", ClusterProcessorMipMapsDualOutputRuntimeSource>;
    }
    class ClusterProcessorMipMapsDualOutputRuntimeSource implements VScript.Referenceable<"ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntimeSource"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntimeSource";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get full_size(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        get source(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.ClusterSources.ClusterVideoSourceRuntime, VAPI.AT1101.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        get source_sdp(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        get input_primary_port(): VScript.rKeyword<VScript.VSocket, null | VAPI.ClusterSources.Ports, null | VAPI.ClusterSources.Ports, VAPI.AT1101.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        get input_secondary_port(): VScript.rKeyword<VScript.VSocket, null | VAPI.ClusterSources.Ports, null | VAPI.ClusterSources.Ports, VAPI.AT1101.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        get output_primary_port(): VScript.rKeyword<VScript.VSocket, null | VAPI.ClusterSources.Ports, null | VAPI.ClusterSources.Ports, VAPI.AT1101.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        get output_secondary_port(): VScript.rKeyword<VScript.VSocket, null | VAPI.ClusterSources.Ports, null | VAPI.ClusterSources.Ports, VAPI.AT1101.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        /**
          IP address of the mipmap RTP stream
        */
        get output_src_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1101.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        /**
          IP address of the secondary mipmap RTP stream
        */
        get output_secondary_src_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1101.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
        get crossbar_select(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource>;
    }
    class ClusterProcessorsLocalRuntime implements VScript.Referenceable<"ClusterProcessors::Data::ClusterProcessorsLocalRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterProcessors::Data::ClusterProcessorsLocalRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get mipmaps(): ClusterProcessorsMipMapsRuntime;
        get metadata(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterProcessors::Data::ClusterProcessorsMetadataRuntime", ClusterProcessorsMetadataRuntime>;
        get ppms(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterProcessors::Data::ClusterProcessorsPPMSRuntime", VAPI.ClusterProcessors.ClusterProcessorsPPMSRuntime>;
    }
    class ClusterProcessorsMetadataRuntime implements VScript.Referenceable<"ClusterProcessors::Data::ClusterProcessorsMetadataRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterProcessors::Data::ClusterProcessorsMetadataRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get source(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.ClusterSources.ClusterMetadataSourceRuntime, VAPI.AT1101.ClusterProcessors.ClusterProcessorsMetadataRuntime>;
    }
    class ClusterProcessorsMipMapsRuntime implements VScript.Referenceable<"ClusterProcessors::Data::ClusterProcessorsMipMapsRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterProcessors::Data::ClusterProcessorsMipMapsRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get outputs(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntime", ClusterProcessorMipMapsDualOutputRuntime>;
        get inputs(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterProcessors::Data::ClusterProcessorMipMapsInputRuntime", VAPI.ClusterProcessors.ClusterProcessorMipMapsInputRuntime>;
    }
}
export declare namespace ClusterSources {
    const lift: {
        readonly ClusterAudioSourceRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterAudioSourceRuntime;
        readonly ClusterAudioSourceRuntimeLocal: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterAudioSourceRuntimeLocal;
        readonly ClusterMetadataSourceLocalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterMetadataSourceLocalRuntime;
        readonly ClusterMetadataSourceRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterMetadataSourceRuntime;
        readonly ClusterSourcesGlobalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterSourcesGlobalRuntime;
        readonly ClusterVideoSourceRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterVideoSourceRuntime;
        readonly ClusterVideoSourceRuntimeLocal: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ClusterVideoSourceRuntimeLocal;
    };
    const lower: {
        readonly ClusterAudioSourceRuntime: (_x: ClusterAudioSourceRuntime) => string;
        readonly ClusterAudioSourceRuntimeLocal: (_x: ClusterAudioSourceRuntimeLocal) => string;
        readonly ClusterMetadataSourceLocalRuntime: (_x: ClusterMetadataSourceLocalRuntime) => string;
        readonly ClusterMetadataSourceRuntime: (_x: ClusterMetadataSourceRuntime) => string;
        readonly ClusterSourcesGlobalRuntime: (_x: ClusterSourcesGlobalRuntime) => string;
        readonly ClusterVideoSourceRuntime: (_x: ClusterVideoSourceRuntime) => string;
        readonly ClusterVideoSourceRuntimeLocal: (_x: ClusterVideoSourceRuntimeLocal) => string;
    };
    class ClusterAudioSourceRuntime implements VScript.Referenceable<"ClusterSources::Data::ClusterAudioSourceRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterSources::Data::ClusterAudioSourceRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.ClusterSources.ClusterAudioSourceRuntime>;
        get transport_format(): VScript.rKeyword<VScript.VSocket, null | VAPI.ClusterSources.SourceTransportFormat, null | VAPI.ClusterSources.SourceTransportFormat, VAPI.AT1101.ClusterSources.ClusterAudioSourceRuntime>;
        get num_channels(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.ClusterSources.ClusterAudioSourceRuntime>;
        get peak_meters(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Audio.PeakMeter>, VAPI.AT1101.ClusterSources.ClusterAudioSourceRuntime>;
        get ip_configuration(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.ClusterSources.ClusterIPSourceConfiguration, VAPI.AT1101.ClusterSources.ClusterAudioSourceRuntime>;
        get local(): ClusterAudioSourceRuntimeLocal;
        get tally_mask(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterSources.TUnsignedMax, VAPI.AT1101.ClusterSources.ClusterAudioSourceRuntime>;
        get label(): VAPI.ClusterSources.ClusterSourceLabelDual;
        get lifeness_count(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.ClusterSources.ClusterAudioSourceRuntime>;
        get bytes_per_second(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.ClusterSources.ClusterAudioSourceRuntime>;
    }
    class ClusterAudioSourceRuntimeLocal implements VScript.Referenceable<"ClusterSources::Data::ClusterAudioSourceRuntimeLocal"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterSources::Data::ClusterAudioSourceRuntimeLocal";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get audio_essence(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.Audio.Essence, VAPI.AT1101.ClusterSources.ClusterAudioSourceRuntimeLocal>;
        get bad_sdp(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.ClusterSources.ClusterAudioSourceRuntimeLocal>;
        get used_channel_id_start(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.ClusterSources.ClusterAudioSourceRuntimeLocal>;
        get used_channels_num(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.ClusterSources.ClusterAudioSourceRuntimeLocal>;
    }
    class ClusterMetadataSourceLocalRuntime implements VScript.Referenceable<"ClusterSources::Data::ClusterMetadataSourceLocalRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterSources::Data::ClusterMetadataSourceLocalRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get bad_sdp(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.ClusterSources.ClusterMetadataSourceLocalRuntime>;
        get time_source(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.Time.Source, VAPI.AT1101.ClusterSources.ClusterMetadataSourceLocalRuntime>;
        get closed_caption(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.Video.ClosedCaption, VAPI.AT1101.ClusterSources.ClusterMetadataSourceLocalRuntime>;
    }
    class ClusterMetadataSourceRuntime implements VScript.Referenceable<"ClusterSources::Data::ClusterMetadataSourceRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterSources::Data::ClusterMetadataSourceRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get global_source_id(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.MetadataSourceID, VAPI.AT1101.ClusterSources.ClusterMetadataSourceRuntime>;
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.ClusterSources.ClusterMetadataSourceRuntime>;
        get transport_format(): VScript.rKeyword<VScript.VSocket, null | VAPI.ClusterSources.SourceTransportFormat, null | VAPI.ClusterSources.SourceTransportFormat, VAPI.AT1101.ClusterSources.ClusterMetadataSourceRuntime>;
        /**
          Source IP address of the metadata RTP stream
        */
        get src_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1101.ClusterSources.ClusterMetadataSourceRuntime>;
        /**
          Source IP address of the metadata RTP stream
        */
        get secondary_src_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1101.ClusterSources.ClusterMetadataSourceRuntime>;
        /**
          Destination IP address of the metadata RTP stream
        */
        get dest_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1101.ClusterSources.ClusterMetadataSourceRuntime>;
        /**
          Destination IP address of the metadata RTP stream
        */
        get secondary_dest_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1101.ClusterSources.ClusterMetadataSourceRuntime>;
        get ip_configuration(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.ClusterSources.ClusterIPSourceConfiguration, VAPI.AT1101.ClusterSources.ClusterMetadataSourceRuntime>;
        get local(): ClusterMetadataSourceLocalRuntime;
        get lifeness_count(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.ClusterSources.ClusterMetadataSourceRuntime>;
        get time_code(): VScript.rKeyword<VScript.VSocket, [
            null | VScript.TimecodePayload,
            null | VScript.TimecodePayload,
            null | VScript.TimecodePayload
        ], VAPI.ClusterSources.TimestampedTimecode, VAPI.AT1101.ClusterSources.ClusterMetadataSourceRuntime>;
        get closed_caption(): VAPI.ClusterSources.ClusterMetadataSourceCC;
    }
    class ClusterSourcesGlobalRuntime implements VScript.Referenceable<"ClusterSources::Data::ClusterSourcesGlobalRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterSources::Data::ClusterSourcesGlobalRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterSources::Data::ClusterVideoSourceRuntime", ClusterVideoSourceRuntime>;
        get audio(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterSources::Data::ClusterAudioSourceRuntime", ClusterAudioSourceRuntime>;
        get metadata(): VScript.StronglyTypedTable<VScript.VSocket, "ClusterSources::Data::ClusterMetadataSourceRuntime", ClusterMetadataSourceRuntime>;
    }
    class ClusterVideoSourceRuntime implements VScript.Referenceable<"ClusterSources::Data::ClusterVideoSourceRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterSources::Data::ClusterVideoSourceRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get global_source_id(): VScript.rKeyword<VScript.VSocket, number, VAPI.ClusterSources.VideoSourceID, VAPI.AT1101.ClusterSources.ClusterVideoSourceRuntime>;
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.ClusterSources.ClusterVideoSourceRuntime>;
        get transport_format(): VScript.rKeyword<VScript.VSocket, null | VAPI.ClusterSources.SourceTransportFormat, null | VAPI.ClusterSources.SourceTransportFormat, VAPI.AT1101.ClusterSources.ClusterVideoSourceRuntime>;
        get video_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1101.ClusterSources.ClusterVideoSourceRuntime>;
        get ip_configuration(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.ClusterSources.ClusterIPSourceConfiguration, VAPI.AT1101.ClusterSources.ClusterVideoSourceRuntime>;
        /**
          Source IP address of the mipmap RTP stream
        */
        get resolution_levels_src_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1101.ClusterSources.ClusterVideoSourceRuntime>;
        /**
          Source IP address of the mipmap RTP stream
        */
        get secondary_resolution_levels_src_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1101.ClusterSources.ClusterVideoSourceRuntime>;
        get resolution_levels(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterSources::Data::ClusterVideoSourceRuntimeResolutionLevel", VAPI.ClusterSources.ClusterVideoSourceRuntimeResolutionLevel>;
        get local(): ClusterVideoSourceRuntimeLocal;
        get tally_mask(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterSources.TUnsignedMax, VAPI.ClusterSources.TUnsignedMax, VAPI.AT1101.ClusterSources.ClusterVideoSourceRuntime>;
        get label(): VAPI.ClusterSources.ClusterSourceLabelDual;
        get lifeness_count(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.ClusterSources.ClusterVideoSourceRuntime>;
    }
    class ClusterVideoSourceRuntimeLocal implements VScript.Referenceable<"ClusterSources::Data::ClusterVideoSourceRuntimeLocal"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ClusterSources::Data::ClusterVideoSourceRuntimeLocal";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video_essence(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.Video.Essence, VAPI.AT1101.ClusterSources.ClusterVideoSourceRuntimeLocal>;
        get bad_sdp(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.ClusterSources.ClusterVideoSourceRuntimeLocal>;
    }
}
export declare namespace ColorCorrection {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly CC1D: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => CC1D;
        readonly CC3D: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => CC3D;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly CC1D: (_x: CC1D) => string;
        readonly CC3D: (_x: CC3D) => string;
    };
    class All implements VScript.Referenceable<"ColorCorrection::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ColorCorrection::Data::All";
        get runtime_constants(): {
            readonly num_color_correction: number;
            readonly num_3d_color_correction: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get cc1d(): VScript.StronglyTypedNamedTable<VScript.VSocket, "ColorCorrection::Data::CC1D", CC1DAsNamedTableRow>;
        get cc3d(): VScript.StronglyTypedNamedTable<VScript.VSocket, "ColorCorrection::Data::CC3D", CC3DAsNamedTableRow>;
    }
    class CC1D implements VScript.Referenceable<"ColorCorrection::Data::CC1D"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ColorCorrection::Data::CC1D";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get v_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.ColorCorrection.CC1D>;
        get output(): VAPI.AT1101.Video.Essence;
        get reserve_uhd_resources(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.ColorCorrection.CC1D>;
        /**
          Selects which parameter sets are used to control this color correction
        */
        get color_schema(): VScript.rwKeyword<VScript.VSocket, VAPI.ColorCorrection.ColorSchema, VAPI.ColorCorrection.ColorSchema, VAPI.ColorCorrection.ColorSchema, VAPI.ColorCorrection.ColorSchema, VAPI.AT1101.ColorCorrection.CC1D>;
        /**
          When set changes the output color space to the specified one
        */
        get output_cs(): VScript.rwKeyword<VScript.VSocket, null | VAPI.Video.ColorSpace, null | VAPI.Video.ColorSpace, null | VAPI.Video.ColorSpace, null | VAPI.Video.ColorSpace, VAPI.AT1101.ColorCorrection.CC1D>;
        get yuv(): VAPI.ColorCorrection.YUV;
        get rgb(): VAPI.ColorCorrection.CC1DRgb;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.ColorCorrection.CC1DIssues, VAPI.AT1101.ColorCorrection.CC1D>;
    }
    class CC1DAsNamedTableRow extends CC1D {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class CC3D implements VScript.Referenceable<"ColorCorrection::Data::CC3D"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "ColorCorrection::Data::CC3D";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get v_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.ColorCorrection.CC3D>;
        get output(): VAPI.AT1101.Video.Essence;
        get reserve_uhd_resources(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.ColorCorrection.CC3D>;
        /**
          Selects which parameter sets are used to control this color correction
        */
        get color_schema(): VScript.rwKeyword<VScript.VSocket, VAPI.ColorCorrection.ColorSchema, VAPI.ColorCorrection.ColorSchema, VAPI.ColorCorrection.ColorSchema, VAPI.ColorCorrection.ColorSchema, VAPI.AT1101.ColorCorrection.CC3D>;
        get yuv(): VAPI.ColorCorrection.YUV;
        get lut_name(): VScript.dKeyword<VScript.VSocket, string, string, string, string, VAPI.AT1101.ColorCorrection.CC3D>;
        get lut_info(): VAPI.ColorCorrection.CC3DLutInfo;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.ColorCorrection.CC3DIssues, VAPI.AT1101.ColorCorrection.CC3D>;
    }
    class CC3DAsNamedTableRow extends CC3D {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
}
export declare namespace Definitions {
    const lift: {
        readonly AudioControl: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioControl;
        readonly TimecodeInserterGenerator: (_raw: [[boolean, boolean], null | string], _socket: VScript.VSocket) => TimecodeInserterGenerator;
        readonly TimecodeInserter: (_raw: ([0, []] | [1, []] | [2, [[boolean, boolean], [number, number, number, number]]] | [3, [[boolean, boolean], null | string]]), _socket: VScript.VSocket) => TimecodeInserter;
        readonly VancControl: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VancControl;
    };
    const lower: {
        readonly AudioControl: (_x: AudioControl) => string;
        readonly TimecodeInserterGenerator: (_x: {
            enable: VAPI.Definitions.TimecodeInserterGeneratorEnable;
            t_src: null | VAPI.AT1101.Time.Source;
        }, _socket: VScript.VSocket) => [[boolean, boolean], null | string];
        readonly TimecodeInserter: (_x: ({
            variant: "Passthrough";
            value: VAPI.Definitions.TimecodeInserterPassthrough;
        } | {
            variant: "Blank";
            value: VAPI.Definitions.TimecodeInserterBlank;
        } | {
            variant: "Freerun";
            value: VAPI.Definitions.TimecodeInserterFreerun;
        } | {
            variant: "Generator";
            value: VAPI.AT1101.Definitions.TimecodeInserterGenerator;
        }), _socket: VScript.VSocket) => ([0, []] | [1, []] | [2, [[boolean, boolean], [number, number, number, number]]] | [3, [[boolean, boolean], null | string]]);
        readonly VancControl: (_x: VancControl) => string;
    };
    class AudioControl implements VScript.Referenceable<"Definitions::Data::AudioControl"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Definitions::Data::AudioControl";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get group_enable(): VScript.dKeyword<VScript.VSocket, Array<VAPI.Definitions.TRSEmbedder>, VScript.MaybeSparseArray<VAPI.Definitions.TRSEmbedder>, Array<VAPI.Definitions.TRSEmbedder>, VScript.MaybeSparseArray<VAPI.Definitions.TRSEmbedder>, VAPI.AT1101.Definitions.AudioControl>;
        get source(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | number | string
        ], [
            null | string,
            null | number | string
        ], VAPI.AT1101.Audio.TimedSource, VAPI.AT1101.Audio.TimedSource, VAPI.AT1101.Definitions.AudioControl>;
    }
    interface TimecodeInserterGenerator {
        enable: VAPI.Definitions.TimecodeInserterGeneratorEnable;
        t_src: null | VAPI.AT1101.Time.Source;
    }
    type TimecodeInserter = ({
        variant: "Passthrough";
        value: VAPI.Definitions.TimecodeInserterPassthrough;
    } | {
        variant: "Blank";
        value: VAPI.Definitions.TimecodeInserterBlank;
    } | {
        variant: "Freerun";
        value: VAPI.Definitions.TimecodeInserterFreerun;
    } | {
        variant: "Generator";
        value: VAPI.AT1101.Definitions.TimecodeInserterGenerator;
    });
    class VancControl implements VScript.Referenceable<"Definitions::Data::VancControl"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Definitions::Data::VancControl";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get passthrough_c_y_0(): VScript.dKeyword<VScript.VSocket, [
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean
        ], [
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean,
            boolean
        ], VAPI.Definitions.BypassReplaceFlags, VAPI.Definitions.BypassReplaceFlags, VAPI.AT1101.Definitions.VancControl>;
        get timecode_inserter(): VScript.dKeyword<VScript.VSocket, ([0, []] | [
            1,
            []
        ] | [
            2,
            [
                [
                    boolean,
                    boolean
                ],
                [
                    number,
                    number,
                    number,
                    number
                ]
            ]
        ] | [
            3,
            [
                [
                    boolean,
                    boolean
                ],
                null | string
            ]
        ]), ([0, []] | [
            1,
            []
        ] | [
            2,
            [
                [
                    boolean,
                    boolean
                ],
                [
                    number,
                    number,
                    number,
                    number
                ]
            ]
        ] | [
            3,
            [
                [
                    boolean,
                    boolean
                ],
                null | string
            ]
        ]), VAPI.AT1101.Definitions.TimecodeInserter, VAPI.AT1101.Definitions.TimecodeInserter, VAPI.AT1101.Definitions.VancControl>;
        get afd_inserter(): VScript.rwKeyword<VScript.VSocket, ([0, []] | [
            1,
            []
        ] | [
            2,
            [null | VAPI.Definitions.VANCAfdCode]
        ]), ([0, []] | [
            1,
            []
        ] | [
            2,
            [null | VAPI.Definitions.VANCAfdCode]
        ]), VAPI.Definitions.VANCAfdInserter, VAPI.Definitions.VANCAfdInserter, VAPI.AT1101.Definitions.VancControl>;
        get override_smpte_352_payload(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | VAPI.Primitives.Unsigned32, null | VAPI.Primitives.Unsigned32, VAPI.AT1101.Definitions.VancControl>;
    }
}
export declare namespace EthernetStats {
    const lift: {
        readonly PortStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PortStatistics;
    };
    const lower: {
        readonly PortStatistics: (_x: PortStatistics) => string;
    };
    class PortStatistics implements VScript.Referenceable<"EthernetStats::Data::PortStatistics"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "EthernetStats::Data::PortStatistics";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get tx_cpu(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, VAPI.AT1101.EthernetStats.PortStatistics>;
        get rx_unicast(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, VAPI.AT1101.EthernetStats.PortStatistics>;
        get rx_broadcast(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, VAPI.AT1101.EthernetStats.PortStatistics>;
        get rx_multicast(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, VAPI.AT1101.EthernetStats.PortStatistics>;
        get rx_crc_error(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, VAPI.AT1101.EthernetStats.PortStatistics>;
        get rx_wrong_vlan(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, VAPI.AT1101.EthernetStats.PortStatistics>;
        get rx_error(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, VAPI.AT1101.EthernetStats.PortStatistics>;
        get rx_too_long(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, VAPI.AT1101.EthernetStats.PortStatistics>;
        get rx_too_short(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, VAPI.AT1101.EthernetStats.PortStatistics>;
    }
}
export declare namespace Genlock {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
    };
    const lower: {
        readonly All: (_x: All) => string;
    };
    class All implements VScript.Referenceable<"Genlock::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Genlock::Data::All";
        get runtime_constants(): {
            readonly num_physical_audio_genlocks: number;
            readonly num_physical_video_genlocks: number;
            readonly num_video_genlocks: number;
            readonly num_audio_genlocks: number;
            readonly num_genlocks: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get state(): VScript.rKeyword<VScript.VSocket, VAPI.Servos.State, VAPI.Servos.State, VAPI.AT1101.Genlock.All>;
        /**
          TODO: use this in IOModule (requires AnalogRefTracker/GrainTracker
          cleanup)
        */
        get analog_ref_mgmt(): VAPI.AT1101.Time.AnalogReference;
        get output(): VAPI.AT1101.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
}
export declare namespace IOModule {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly TimingAsynchronous: (_raw: [], _socket: VScript.VSocket) => TimingAsynchronous;
        readonly HwStatus: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HwStatus;
        readonly MADIInput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MADIInput;
        readonly SDIPayload: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SDIPayload;
        readonly SDIInput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SDIInput;
        readonly SDIOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SDIOutput;
        readonly TimingSynchronousOrSyntonous: (_raw: [], _socket: VScript.VSocket) => TimingSynchronousOrSyntonous;
        readonly Timing: (_raw: ([0, []] | [1, []]), _socket: VScript.VSocket) => Timing;
        readonly HwStatusEye: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HwStatusEye;
        readonly Input: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Input;
        readonly Merger: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Merger;
        readonly Output: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Output;
        readonly MergerOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MergerOutput;
        readonly SyncOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SyncOutput;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly TimingAsynchronous: (_x: {}, _socket: VScript.VSocket) => [];
        readonly HwStatus: (_x: HwStatus) => string;
        readonly MADIInput: (_x: MADIInput) => string;
        readonly SDIPayload: (_x: SDIPayload) => string;
        readonly SDIInput: (_x: SDIInput) => string;
        readonly SDIOutput: (_x: SDIOutput) => string;
        readonly TimingSynchronousOrSyntonous: (_x: {}, _socket: VScript.VSocket) => [];
        readonly Timing: (_x: ({
            variant: "SynchronousOrSyntonous";
            value: VAPI.AT1101.IOModule.TimingSynchronousOrSyntonous;
        } | {
            variant: "Asynchronous";
            value: VAPI.AT1101.IOModule.TimingAsynchronous;
        }), _socket: VScript.VSocket) => ([0, []] | [1, []]);
        readonly HwStatusEye: (_x: HwStatusEye) => string;
        readonly Input: (_x: Input) => string;
        readonly Merger: (_x: Merger) => string;
        readonly Output: (_x: Output) => string;
        readonly MergerOutput: (_x: MergerOutput) => string;
        readonly SyncOutput: (_x: SyncOutput) => string;
    };
    class All implements VScript.Referenceable<"IOModule::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::All";
        get runtime_constants(): {
            readonly should_deembed_all_metadata: boolean;
            readonly num_sdi_tx_plls: number;
            readonly num_metadata_extractors_per_sdi_input: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get info(): VAPI.IOModule.BncMode;
        get analog_ref(): VScript.StronglyTypedTable<VScript.VSocket, "Time::Data::Source", VAPI.AT1101.Time.Source>;
        get analog_ref_traits(): VAPI.PTP.Traits;
        get configuration(): VScript.StronglyTypedTable<VScript.VSocket, "IOModule::Data::Configuration", VAPI.IOModule.Configuration>;
        get merger(): VScript.StronglyTypedTable<VScript.VSocket, "IOModule::Data::Merger", Merger>;
        get output(): VScript.StronglyTypedTable<VScript.VSocket, "IOModule::Data::Output", Output>;
        get input(): VScript.StronglyTypedTable<VScript.VSocket, "IOModule::Data::Input", Input>;
        get sync_output(): VScript.StronglyTypedTable<VScript.VSocket, "IOModule::Data::SyncOutput", SyncOutput>;
    }
    interface TimingAsynchronous {
    }
    class HwStatus implements VScript.Referenceable<"IOModule::Data::HwStatus"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::HwStatus";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get timestamped_signature(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            Array<number>
        ], null | VAPI.Video.TimestampedSignature, VAPI.AT1101.IOModule.HwStatus>;
        get irq_index(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.IOModule.HwStatus>;
        get deemb_read_overflow(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.IOModule.HwStatus>;
        get deemb_read_underflow(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.IOModule.HwStatus>;
        get deemb_read_running(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.IOModule.HwStatus>;
        get phy_rx_locked_status(): VScript.rKeyword<VScript.VSocket, null | VAPI.IOModule.DecoderGroupPhyRxLockedStatus, null | VAPI.IOModule.DecoderGroupPhyRxLockedStatus, VAPI.AT1101.IOModule.HwStatus>;
        get phy_rx_ready(): VScript.rKeyword<VScript.VSocket, null | VAPI.IOModule.DecoderGroupPhyRxReady, null | VAPI.IOModule.DecoderGroupPhyRxReady, VAPI.AT1101.IOModule.HwStatus>;
        get phy_rx_calibrate_busy(): VScript.rKeyword<VScript.VSocket, null | VAPI.IOModule.DecoderGroupPhyRxCalibrateBusy, null | VAPI.IOModule.DecoderGroupPhyRxCalibrateBusy, VAPI.AT1101.IOModule.HwStatus>;
        get phy_rx_locked_status_changed(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.AT1101.IOModule.HwStatus>;
        get phy_rx_ready_changed(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.AT1101.IOModule.HwStatus>;
        get smpte_352_c(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.AT1101.IOModule.HwStatus>;
        get smpte_352_y(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.AT1101.IOModule.HwStatus>;
        get h_blank(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.IOModule.HwStatus>;
        get h_blank_changed(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.AT1101.IOModule.HwStatus>;
        get h_active(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.IOModule.HwStatus>;
        get h_active_changed(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.AT1101.IOModule.HwStatus>;
        get f_period(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1101.IOModule.HwStatus>;
        get interlace(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.AT1101.IOModule.HwStatus>;
        get standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1101.IOModule.HwStatus>;
        get substream_2_s_i(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.SubStream2SI, null | VAPI.Video.SubStream2SI, VAPI.AT1101.IOModule.HwStatus>;
        get input_substream(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.SubStream, null | VAPI.Video.SubStream, VAPI.AT1101.IOModule.HwStatus>;
        get eye(): HwStatusEye;
    }
    class MADIInput implements VScript.Referenceable<"IOModule::Data::MADIInput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::MADIInput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.IOModule.MADIInput>;
        get fifo_underflow_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.SaturatingCounter16, VAPI.AT1101.IOModule.MADIInput>;
        get fifo_overflow_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.SaturatingCounter16, VAPI.AT1101.IOModule.MADIInput>;
        get clear_fifo_error_counters(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.IOModule.MADIInput>;
        get output(): VAPI.AT1101.Audio.Essence;
    }
    class SDIPayload implements VScript.Referenceable<"IOModule::Data::SDIPayload"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::SDIPayload";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video(): VAPI.AT1101.Video.Essence;
        get audio(): VAPI.AT1101.Audio.Essence;
        get afd(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.Video.AspectRatio,
            number,
            number,
            number,
            number,
            number
        ], null | VAPI.Video.AFD, VAPI.AT1101.IOModule.SDIPayload>;
        get cc(): VAPI.Video.ClosedCaption;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class SDIInput implements VScript.Referenceable<"IOModule::Data::SDIInput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::SDIInput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get override_pixel_format(): VScript.rwKeyword<VScript.VSocket, [
            VAPI.Video.OverrideColorSpace,
            VAPI.Video.OverrideBitDepth,
            VAPI.Video.OverrideTransferCharacteristics
        ], [
            VAPI.Video.OverrideColorSpace,
            VAPI.Video.OverrideBitDepth,
            VAPI.Video.OverrideTransferCharacteristics
        ], VAPI.Video.OverridePixelFormat, VAPI.Video.OverridePixelFormat, VAPI.AT1101.IOModule.SDIInput>;
        get sub_stream(): VScript.dKeyword<VScript.VSocket, null | VAPI.Video.SubStream, null | VAPI.Video.SubStream, null | VAPI.Video.SubStream, null | VAPI.Video.SubStream, VAPI.AT1101.IOModule.SDIInput>;
        /**
          How to deembed audio from 12G SDI inputs
        */
        get audio_12g_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.IOModule.Audio12GMode, VAPI.IOModule.Audio12GMode, VAPI.IOModule.Audio12GMode, VAPI.IOModule.Audio12GMode, VAPI.AT1101.IOModule.SDIInput>;
        /**
          Which closed caption format to decode on input
        */
        get cc_mode(): VScript.rwKeyword<VScript.VSocket, null | VAPI.IOModule.ClosedCaptionDeembedMode, null | VAPI.IOModule.ClosedCaptionDeembedMode, null | VAPI.IOModule.ClosedCaptionDeembedMode, null | VAPI.IOModule.ClosedCaptionDeembedMode, VAPI.AT1101.IOModule.SDIInput>;
        /**
          Which line 21 field to decode in CEA708 mode
        */
        get cc_field(): VScript.rwKeyword<VScript.VSocket, VAPI.Video.CEA608Field, VAPI.Video.CEA608Field, VAPI.Video.CEA608Field, VAPI.Video.CEA608Field, VAPI.AT1101.IOModule.SDIInput>;
        get cc_channel(): VScript.rwKeyword<VScript.VSocket, null | VAPI.Video.ClosedCaptionChannel, null | VAPI.Video.ClosedCaptionChannel, null | VAPI.Video.ClosedCaptionChannel, null | VAPI.Video.ClosedCaptionChannel, VAPI.AT1101.IOModule.SDIInput>;
        get hw_status(): HwStatus;
        get output(): SDIPayload;
        get mode(): VScript.rKeyword<VScript.VSocket, VAPI.Video.BNCInputFreq, VAPI.Video.BNCInputFreq, VAPI.AT1101.IOModule.SDIInput>;
        get supports_12g(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.IOModule.SDIInput>;
        /**
          All audio groups which are part of the gang mode are started / stopped
          together. This ensures consistent audio phase for all these groups. All
          enabled groups must be present before de-embedding starts, and when one
          group encounters errors all are reset.
        */
        get deembedder_gang(): VScript.rwKeyword<VScript.VSocket, Array<boolean>, VScript.MaybeSparseArray<boolean>, Array<boolean>, VScript.MaybeSparseArray<boolean>, VAPI.AT1101.IOModule.SDIInput>;
        /**
          @brief restart deembedder
          @desc Restart audio deembedder to synchronize the groups
        */
        get restart_deembedder(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.IOModule.SDIInput>;
        get metadata_extractor(): VScript.StronglyTypedTable<VScript.VSocket, "MetadataProcessor::Data::MetadataExtractor", VAPI.AT1101.MetadataProcessor.MetadataExtractor>;
        /**
          This keyword is used for the DMV application only. It is used to set the
          video standard for the DMV.
        */
        get constraints(): VAPI.IOModule.Constraints;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AT1101.IOModule.SDIInputIssues, VAPI.AT1101.IOModule.SDIInput>;
    }
    class SDIOutput implements VScript.Referenceable<"IOModule::Data::SDIOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::SDIOutput";
        set_video_source(x: VAPI.AT1101.Video.Essence | VAPI.AT1101.Video.TimedSource | null, pars?: {
            timeout?: VScript.Duration;
        }): Promise<void>;
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get constraints(): VAPI.IOModule.Constraints;
        get sub_stream(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.SubStream, null | VAPI.Video.SubStream, VAPI.AT1101.IOModule.SDIOutput>;
        get standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1101.IOModule.SDIOutput>;
        get supports_12g(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.IOModule.SDIOutput>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.IOModule.SDIOutput>;
        get v_src(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | number | string
        ], [
            null | string,
            null | number | string
        ], VAPI.AT1101.Video.TimedSource, VAPI.AT1101.Video.TimedSource, VAPI.AT1101.IOModule.SDIOutput>;
        get phase_target(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.IOModule.SDIOutput>;
        get in_phase(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1101.IOModule.SDIOutput>;
        get phase_rst_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.AT1101.IOModule.SDIOutput>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AT1101.IOModule.SDIOutputIssues, VAPI.AT1101.IOModule.SDIOutput>;
        get vanc_control(): VAPI.AT1101.Definitions.VancControl;
        get embedded_audio(): VScript.dKeyword<VScript.VSocket, Array<VAPI.Definitions.TRSEmbedder>, VScript.MaybeSparseArray<VAPI.Definitions.TRSEmbedder>, Array<VAPI.Definitions.TRSEmbedder>, VScript.MaybeSparseArray<VAPI.Definitions.TRSEmbedder>, VAPI.AT1101.IOModule.SDIOutput>;
        /**
          Time when the SDI output was last enabled. Changing the standards or
          disconnecting the video source counts as disabling.
        */
        get last_enable_time(): VScript.rKeyword<VScript.VSocket, null | number | string, null | VAPI.Primitives.Timestamp, VAPI.AT1101.IOModule.SDIOutput>;
    }
    interface TimingSynchronousOrSyntonous {
    }
    type Timing = ({
        variant: "SynchronousOrSyntonous";
        value: VAPI.AT1101.IOModule.TimingSynchronousOrSyntonous;
    } | {
        variant: "Asynchronous";
        value: VAPI.AT1101.IOModule.TimingAsynchronous;
    });
    class HwStatusEye implements VScript.Referenceable<"IOModule::Data::HwStatus::Eye"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::HwStatus::Eye";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get eye_measure_time(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.IOModule.HwStatusEye>;
        /**
          Generate eye diagram
        */
        get generate(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.IOModule.HwStatusEye>;
        get progress(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.IOModule.HwStatusEye>;
        /**
          @brief URL of the eye diagram
          @desc An update to this keyword signals a new eye diagram has been
          generated
        */
        get url(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.IOModule.HwStatusEye>;
        /**
          @brief Measure eye opening only
          @desc Only measure horizontal eye opening (much faster than a full eye)
        */
        get measure_ui(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.IOModule.HwStatusEye>;
        get ui_measure_time(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.IOModule.HwStatusEye>;
        get ui(): VScript.rKeyword<VScript.VSocket, [
            null | number,
            null | number
        ], VAPI.IOModule.EyeShape, VAPI.AT1101.IOModule.HwStatusEye>;
    }
    class Input implements VScript.Referenceable<"IOModule::Data::Input"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::Input";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get mode(): VScript.dKeyword<VScript.VSocket, VAPI.IOModule.SDIMADIMode, VAPI.IOModule.SDIMADIMode, VAPI.IOModule.SDIMADIMode, VAPI.IOModule.SDIMADIMode, VAPI.AT1101.IOModule.Input>;
        get audio_timing(): VScript.dKeyword<VScript.VSocket, ([0, []] | [
            1,
            []
        ]), ([0, []] | [
            1,
            []
        ]), VAPI.AT1101.IOModule.Timing, VAPI.AT1101.IOModule.Timing, VAPI.AT1101.IOModule.Input>;
        get sdi(): SDIInput;
        get madi(): MADIInput;
        get audio_source_slices(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
    }
    type SDIInputIssues = {
        missmatching_constraint_standard: boolean;
    };
    type SDIOutputIssues = {
        input_out_of_linephaser_range: boolean;
        no_12g_support: boolean;
        std_mismatch: boolean;
    };
    class Merger implements VScript.Referenceable<"IOModule::Data::Merger"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::Merger";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          Merger: combines quad-link-2si signals to a single-link UHD signal. The
          corresponding SDI inputs are declared in `connected_to`. The order of the
          substream is adjusted by the information of the payload identifier. To
          set or reorder the substream, use the `sub_stream` parameter
        */
        get substream_2_s_i(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.IOModule.Merger>;
        get connected_to(): VAPI.IOModule.MergerConnectedTo;
        get output(): VScript.StronglyTypedTable<VScript.VSocket, "IOModule::Data::Merger::Output", MergerOutput>;
    }
    class Output implements VScript.Referenceable<"IOModule::Data::Output"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::Output";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get mode(): VScript.dKeyword<VScript.VSocket, VAPI.IOModule.SDIMADIMode, VAPI.IOModule.SDIMADIMode, VAPI.IOModule.SDIMADIMode, VAPI.IOModule.SDIMADIMode, VAPI.AT1101.IOModule.Output>;
        /**
          Number of times since last enable the output FIFO had to resync (sampled
          only every 100ms)
        */
        get resync_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.AT1101.IOModule.Output>;
        /**
          Output FIFO latency
        */
        get fifo_latency(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1101.IOModule.Output>;
        get sdi(): SDIOutput;
        get madi(): VAPI.IOModule.MADIOutput;
        get a_src(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | number | string
        ], [
            null | string,
            null | number | string
        ], VAPI.AT1101.Audio.TimedSource, VAPI.AT1101.Audio.TimedSource, VAPI.AT1101.IOModule.Output>;
        get peak_meter(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Audio.PeakMeter>, VAPI.AT1101.IOModule.Output>;
    }
    class MergerOutput implements VScript.Referenceable<"IOModule::Data::Merger::Output"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::Merger::Output";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video(): VAPI.AT1101.Video.Essence;
        get audio(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::Essence", VAPI.AT1101.Audio.Essence>;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class SyncOutput implements VScript.Referenceable<"IOModule::Data::SyncOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "IOModule::Data::SyncOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get standard(): VScript.rwKeyword<VScript.VSocket, null | VAPI.IOModule.SyncOutputStandard, null | VAPI.IOModule.SyncOutputStandard, null | VAPI.IOModule.SyncOutputStandard, null | VAPI.IOModule.SyncOutputStandard, VAPI.AT1101.IOModule.SyncOutput>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.IOModule.SyncOutput>;
        get phase_rst_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.AT1101.IOModule.SyncOutput>;
        /**
          Number of times since last enable the output FIFO had to resync (sampled
          only every 100ms)
        */
        get resync_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.AT1101.IOModule.SyncOutput>;
        /**
          Output FIFO latency
        */
        get fifo_latency(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1101.IOModule.SyncOutput>;
    }
}
export declare namespace J2KDecoder {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly J2KDecoderChannel: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => J2KDecoderChannel;
        readonly J2KDecoderRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => J2KDecoderRuntime;
        readonly J2KDecoderVideoRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => J2KDecoderVideoRuntime;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly J2KDecoderChannel: (_x: J2KDecoderChannel) => string;
        readonly J2KDecoderRuntime: (_x: J2KDecoderRuntime) => string;
        readonly J2KDecoderVideoRuntime: (_x: J2KDecoderVideoRuntime) => string;
    };
    class All implements VScript.Referenceable<"J2KDecoder::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "J2KDecoder::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get decoders(): VScript.StronglyTypedNamedTable<VScript.VSocket, "J2KDecoder::Data::J2KDecoderChannel", J2KDecoderChannelAsNamedTableRow>;
        get statistics(): VAPI.J2KDecoder.J2KDecoderStatistics;
    }
    class J2KDecoderChannel implements VScript.Referenceable<"J2KDecoder::Data::J2KDecoderChannel"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "J2KDecoder::Data::J2KDecoderChannel";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get configuration(): VAPI.J2KDecoder.J2KDecoderConfiguration;
        get runtime(): J2KDecoderRuntime;
    }
    class J2KDecoderChannelAsNamedTableRow extends J2KDecoderChannel {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class J2KDecoderRuntime implements VScript.Referenceable<"J2KDecoder::Data::J2KDecoderRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "J2KDecoder::Data::J2KDecoderRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get rtp(): VAPI.J2KDecoder.J2KDecoderRTPRuntime;
        get mpt2(): VAPI.J2KDecoder.J2KDecoderMPT2Runtime;
        get j2k(): VAPI.J2KDecoder.J2KDecoderJ2KRuntime;
        get video(): J2KDecoderVideoRuntime;
        get audio(): VAPI.J2KDecoder.J2KDecoderAudioRuntime;
        get metadata(): VAPI.J2KDecoder.J2KDecoderMetadataRuntime;
    }
    class J2KDecoderVideoRuntime implements VScript.Referenceable<"J2KDecoder::Data::J2KDecoderVideoRuntime"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "J2KDecoder::Data::J2KDecoderVideoRuntime";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video_standard(): VScript.rKeyword<VScript.VSocket, VAPI.Video.Standard, VAPI.Video.Standard, VAPI.AT1101.J2KDecoder.J2KDecoderVideoRuntime>;
        get signal(): VAPI.AT1101.Video.Essence;
    }
}
export declare namespace MasterClock {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly GPSReceiver: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => GPSReceiver;
        readonly LTCGenerator: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => LTCGenerator;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly GPSReceiver: (_x: GPSReceiver) => string;
        readonly LTCGenerator: (_x: LTCGenerator) => string;
    };
    class All implements VScript.Referenceable<"MasterClock::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MasterClock::Data::All";
        get runtime_constants(): {
            readonly num_ltc_generators: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get gps_receivers(): VScript.StronglyTypedTable<VScript.VSocket, "MasterClock::Data::GPSReceiver", GPSReceiver>;
        get ltc_generators(): VScript.StronglyTypedNamedTable<VScript.VSocket, "MasterClock::Data::LTCGenerator", LTCGeneratorAsNamedTableRow>;
        get ltc_slice(): VAPI.Audio.SignalSourceSlice;
    }
    class GPSReceiver implements VScript.Referenceable<"MasterClock::Data::GPSReceiver"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MasterClock::Data::GPSReceiver";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get date(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number,
            number
        ], null | VAPI.MasterClock.GPSReceiverDate, VAPI.AT1101.MasterClock.GPSReceiver>;
        get time_of_day(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number,
            number
        ], null | VAPI.MasterClock.GPSReceiverTimeOfDay, VAPI.AT1101.MasterClock.GPSReceiver>;
        get num_satellites(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.MasterClock.GPSReceiver>;
        get used_satellites(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.MasterClock.GPSReceiver>;
        get removed_satellites(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.MasterClock.GPSReceiver>;
        get ptp_traits(): VAPI.PTP.Traits;
        get output(): VAPI.AT1101.Time.Source;
    }
    class LTCGenerator implements VScript.Referenceable<"MasterClock::Data::LTCGenerator"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MasterClock::Data::LTCGenerator";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get timezone(): VScript.dKeyword<VScript.VSocket, VAPI.MasterClock.Timezone, VAPI.MasterClock.Timezone, VAPI.MasterClock.Timezone, VAPI.MasterClock.Timezone, VAPI.AT1101.MasterClock.LTCGenerator>;
        get custom_timezone_offset(): VScript.dKeyword<VScript.VSocket, [
            number,
            number
        ], [
            number,
            number
        ], VAPI.MasterClock.TimezoneOffset, VAPI.MasterClock.TimezoneOffset, VAPI.AT1101.MasterClock.LTCGenerator>;
        get frame_rate(): VScript.dKeyword<VScript.VSocket, VAPI.MasterClock.TimecodeRate, VAPI.MasterClock.TimecodeRate, VAPI.MasterClock.TimecodeRate, VAPI.MasterClock.TimecodeRate, VAPI.AT1101.MasterClock.LTCGenerator>;
        /**
          * `UTC` (Universal Time, Coordinated) is the standard for wall clock
          time. It is the standard that all timezones are based on. UTC has leap
          seconds to account for differences in the Earth's rotational speed. *When
          in doubt, always use `UTC`*
          
          * `TAI` (International Atomic Time) is the time standard used by PTP. It
          is a linear time standard that does not have leap seconds. TAI is
          currently ahead of UTC by 37 seconds.
        */
        get time_standard(): VScript.dKeyword<VScript.VSocket, VAPI.Time.Standard, VAPI.Time.Standard, VAPI.Time.Standard, VAPI.Time.Standard, VAPI.AT1101.MasterClock.LTCGenerator>;
        get reset_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.MasterClock.LTCGenerator>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.MasterClock.LTCGenerator>;
        get output(): VAPI.AT1101.Audio.Essence;
    }
    class LTCGeneratorAsNamedTableRow extends LTCGenerator {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
}
export declare namespace MetadataProcessor {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly MetadataExtractor: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MetadataExtractor;
        readonly MetadataInserter: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MetadataInserter;
        readonly Request: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Request;
        readonly Response: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Response;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly MetadataExtractor: (_x: MetadataExtractor) => string;
        readonly MetadataInserter: (_x: MetadataInserter) => string;
        readonly Request: (_x: Request) => string;
        readonly Response: (_x: Response) => string;
    };
    class All implements VScript.Referenceable<"MetadataProcessor::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MetadataProcessor::Data::All";
        get runtime_constants(): {
            readonly num_metadata_inserters: number;
            readonly num_metadata_extractors: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get rtp_channel(): VScript.rKeyword<VScript.VSocket, VAPI.MetadataProcessor.ChannelState, VAPI.MetadataProcessor.ChannelState, VAPI.AT1101.MetadataProcessor.All>;
        get responses(): VScript.StronglyTypedTable<VScript.VSocket, "MetadataProcessor::Data::Response", Response>;
    }
    class MetadataExtractor implements VScript.Referenceable<"MetadataProcessor::Data::MetadataExtractor"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MetadataProcessor::Data::MetadataExtractor";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.MetadataProcessor.MetadataExtractor>;
        get extractor_type(): VScript.rKeyword<VScript.VSocket, null | VAPI.MetadataProcessor.MetadataExtractorExtractorType, null | VAPI.MetadataProcessor.MetadataExtractorExtractorType, VAPI.AT1101.MetadataProcessor.MetadataExtractor>;
        get bnc_node(): VScript.rKeyword<VScript.VSocket, null | VScript.DeviceTreeNodePayload, null | VScript.DeviceTreeNodePayload, VAPI.AT1101.MetadataProcessor.MetadataExtractor>;
        get media_clock(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.Time.Source, VAPI.AT1101.MetadataProcessor.MetadataExtractor>;
        get standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1101.MetadataProcessor.MetadataExtractor>;
        get rtp_requested(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.MetadataProcessor.MetadataExtractor>;
        get rtp_index(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.MetadataProcessor.RTPIndex, VAPI.AT1101.MetadataProcessor.MetadataExtractor>;
    }
    class MetadataInserter implements VScript.Referenceable<"MetadataProcessor::Data::MetadataInserter"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MetadataProcessor::Data::MetadataInserter";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video_dt_node(): VScript.rKeyword<VScript.VSocket, null | VScript.DeviceTreeNodePayload, null | VScript.DeviceTreeNodePayload, VAPI.AT1101.MetadataProcessor.MetadataInserter>;
        get media_clock(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.Time.Source, VAPI.AT1101.MetadataProcessor.MetadataInserter>;
        get src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.MetadataProcessor.MetadataExtractor, null | VScript.Referenceable<"MetadataProcessor::Data::MetadataExtractor"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.MetadataProcessor.MetadataInserter>;
        get filter(): VScript.dKeyword<VScript.VSocket, [
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting
        ], [
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting
        ], VAPI.MetadataProcessor.Filter, VAPI.MetadataProcessor.Filter, VAPI.AT1101.MetadataProcessor.MetadataInserter>;
        get vanc_locations(): VScript.dKeyword<VScript.VSocket, [
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            number
        ], [
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            number
        ], VAPI.MetadataProcessor.VANCEmbedderLocations, VAPI.MetadataProcessor.VANCEmbedderLocations, VAPI.AT1101.MetadataProcessor.MetadataInserter>;
        get fine_print(): VScript.dKeyword<VScript.VSocket, [
            VAPI.MetadataProcessor.OnChecksumError,
            null | number,
            null | number
        ], [
            VAPI.MetadataProcessor.OnChecksumError,
            null | number,
            null | number
        ], VAPI.MetadataProcessor.FinePrint, VAPI.MetadataProcessor.FinePrint, VAPI.AT1101.MetadataProcessor.MetadataInserter>;
    }
    class Request implements VScript.Referenceable<"MetadataProcessor::Data::Request"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MetadataProcessor::Data::Request";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get inserter_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1101.MetadataProcessor.Request>;
        get src(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.MetadataProcessor.MetadataExtractor, VAPI.AT1101.MetadataProcessor.Request>;
        get dst(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.MetadataProcessor.MetadataInserter, VAPI.AT1101.MetadataProcessor.Request>;
        get filter(): VScript.rKeyword<VScript.VSocket, null | [
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting
        ], null | VAPI.MetadataProcessor.Filter, VAPI.AT1101.MetadataProcessor.Request>;
        get vanc_locations(): VScript.rKeyword<VScript.VSocket, [
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            number
        ], VAPI.MetadataProcessor.VANCEmbedderLocations, VAPI.AT1101.MetadataProcessor.Request>;
        get fine_print(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.MetadataProcessor.OnChecksumError,
            null | number,
            null | number
        ], null | VAPI.MetadataProcessor.FinePrint, VAPI.AT1101.MetadataProcessor.Request>;
    }
    class Response implements VScript.Referenceable<"MetadataProcessor::Data::Response"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MetadataProcessor::Data::Response";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get extractor_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1101.MetadataProcessor.Response>;
        get inserter_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1101.MetadataProcessor.Response>;
        get src(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.MetadataProcessor.MetadataExtractor, VAPI.AT1101.MetadataProcessor.Response>;
        get dst(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.MetadataProcessor.MetadataInserter, VAPI.AT1101.MetadataProcessor.Response>;
        get filter(): VScript.rKeyword<VScript.VSocket, null | [
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting,
            null | VAPI.MetadataProcessor.FilterSetting
        ], null | VAPI.MetadataProcessor.Filter, VAPI.AT1101.MetadataProcessor.Response>;
        get vanc_locations(): VScript.rKeyword<VScript.VSocket, [
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            null | number,
            number
        ], VAPI.MetadataProcessor.VANCEmbedderLocations, VAPI.AT1101.MetadataProcessor.Response>;
        get fine_print(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.MetadataProcessor.OnChecksumError,
            null | number,
            null | number
        ], null | VAPI.MetadataProcessor.FinePrint, VAPI.AT1101.MetadataProcessor.Response>;
        get statistics(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number,
            number
        ], VAPI.MetadataProcessor.ResponseStatistics, VAPI.AT1101.MetadataProcessor.Response>;
        /**
          Metadata inserters generally attempt to match their video stream's
          underlying media clock by delaying the supplied ANC streams accordingly.
          If the desired media clock offset cannot be met because, e.g., the ANC
          stream is already coming in too late, or Timecode/AFD continuity
          requirements force the inserter to soften its mediaclock criterion,
          packets may either be discarded or embedded out-of-phase. In the latter
          case, the mismatch between the embedded ANC stream's de-facto mediaclock
          and its target value is represented by `phase_mismatch`, with negative
          values corresponding to late ANC streams.
        */
        get phase_mismatch(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number,
            number,
            number
        ], null | VAPI.Time.TimestampedOffset, VAPI.AT1101.MetadataProcessor.Response>;
    }
}
export declare namespace Monitoring {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly AudioLoudness: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioLoudness;
        readonly AudioPhaseCorrelation: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioPhaseCorrelation;
        readonly LiveView: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => LiveView;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly AudioLoudness: (_x: AudioLoudness) => string;
        readonly AudioPhaseCorrelation: (_x: AudioPhaseCorrelation) => string;
        readonly LiveView: (_x: LiveView) => string;
    };
    class All implements VScript.Referenceable<"Monitoring::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Monitoring::Data::All";
        get runtime_constants(): {
            readonly num_audio_phase_correlation: number;
            readonly num_audio_loudness_instances: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get audio(): VAPI.Monitoring.Audio;
        get video(): VAPI.Monitoring.Video;
        get live_view(): LiveView;
        get correlation(): VScript.StronglyTypedNamedTable<VScript.VSocket, "Monitoring::Data::AudioPhaseCorrelation", AudioPhaseCorrelationAsNamedTableRow>;
        get loudness(): VScript.StronglyTypedNamedTable<VScript.VSocket, "Monitoring::Data::AudioLoudness", AudioLoudnessAsNamedTableRow>;
    }
    class AudioLoudness implements VScript.Referenceable<"Monitoring::Data::AudioLoudness"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Monitoring::Data::AudioLoudness";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get a_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Audio.Essence, null | VScript.Referenceable<"Audio::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.Monitoring.AudioLoudness>;
        get channels(): VAPI.Monitoring.AudioLoudnessChannels;
        get mode(): VScript.dKeyword<VScript.VSocket, VAPI.Monitoring.LoudnessMode, VAPI.Monitoring.LoudnessMode, VAPI.Monitoring.LoudnessMode, VAPI.Monitoring.LoudnessMode, VAPI.AT1101.Monitoring.AudioLoudness>;
        /**
          Set to false to pause gated_loudness measurement and back to true to
          resume
        */
        get active(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.Monitoring.AudioLoudness>;
        /**
          True peak meters
          
          Order: left, right, center, surround_left, surround_right,
          rear_surround_left, rear_surround_right
        */
        get true_peak_meter(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Audio.PeakMeter>, VAPI.AT1101.Monitoring.AudioLoudness>;
        /**
          Measured over the last 400 ms
        */
        get momentary_loudness(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.Monitoring.AudioLoudness>;
        /**
          Measured over the last 3 s
        */
        get short_term_loudness(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.Monitoring.AudioLoudness>;
        get gated_loudness(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.Monitoring.AudioLoudness>;
        /**
          How much data has been recorded for the gated loudness measurement so far
        */
        get gated_loudness_recorded(): VScript.rKeyword<VScript.VSocket, number, VScript.Duration, VAPI.AT1101.Monitoring.AudioLoudness>;
        /**
          Reset
        */
        get reset(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.Monitoring.AudioLoudness>;
    }
    class AudioLoudnessAsNamedTableRow extends AudioLoudness {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class AudioPhaseCorrelation implements VScript.Referenceable<"Monitoring::Data::AudioPhaseCorrelation"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Monitoring::Data::AudioPhaseCorrelation";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get a_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Audio.Essence, null | VScript.Referenceable<"Audio::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.Monitoring.AudioPhaseCorrelation>;
        get pairs(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.Monitoring.AudioPhaseCorrelation>;
        get peak_meter(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Audio.PeakMeter>, VAPI.AT1101.Monitoring.AudioPhaseCorrelation>;
        get correlation(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<number>, VAPI.AT1101.Monitoring.AudioPhaseCorrelation>;
    }
    class AudioPhaseCorrelationAsNamedTableRow extends AudioPhaseCorrelation {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class LiveView implements VScript.Referenceable<"Monitoring::Data::LiveView"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Monitoring::Data::LiveView";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get v_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.Monitoring.LiveView>;
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.Monitoring.LiveView>;
        get timestamped_signature(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            Array<number>
        ], null | VAPI.Video.TimestampedSignature, VAPI.AT1101.Monitoring.LiveView>;
    }
}
export declare namespace MultiviewerIO {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
    };
    const lower: {
        readonly All: (_x: All) => string;
    };
    class All implements VScript.Referenceable<"MultiviewerIO::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "MultiviewerIO::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get distributed(): VAPI.MultiviewerIO.DistributedMultiviewer;
        get cores(): VScript.StronglyTypedArray<VScript.VSocket, "MultiviewerIO::Data::ManifoldCore", VAPI.MultiviewerIO.ManifoldCore>;
        get outputs(): VScript.StronglyTypedArray<VScript.VSocket, "Video::Data::Essence", VAPI.AT1101.Video.Essence>;
    }
}
export declare namespace NetworkInterfaces {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly LaneStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => LaneStatistics;
        readonly Port: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Port;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly LaneStatistics: (_x: LaneStatistics) => string;
        readonly Port: (_x: Port) => string;
    };
    class All implements VScript.Referenceable<"NetworkInterfaces::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "NetworkInterfaces::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          Save all interfaces
        */
        get save_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.NetworkInterfaces.All>;
        /**
          Revert all interfaces
        */
        get revert_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.NetworkInterfaces.All>;
        /**
          Save all syslog settings
        */
        get save_syslog_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.NetworkInterfaces.All>;
        /**
          Revert all syslog settings
        */
        get revert_syslog_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.NetworkInterfaces.All>;
        get ports(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::Port", Port>;
        get hostname(): VAPI.NetworkInterfaces.HostnameConfiguration;
        get current_veth_configuration(): VAPI.NetworkInterfaces.CurrentVirtualEthernetConfiguration;
        get desired_veth_configuration(): VAPI.NetworkInterfaces.DesiredVirtualEthernetConfiguration;
    }
    type Lane = "P1_0" | "P1_1" | "P1_2" | "P1_3" | "P2_0" | "P2_1" | "P2_2" | "P2_3";
    class LaneStatistics implements VScript.Referenceable<"NetworkInterfaces::Data::LaneStatistics"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "NetworkInterfaces::Data::LaneStatistics";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get lane(): VScript.rKeyword<VScript.VSocket, null | VAPI.AT1101.NetworkInterfaces.Lane, null | VAPI.AT1101.NetworkInterfaces.Lane, VAPI.AT1101.NetworkInterfaces.LaneStatistics>;
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.NetworkInterfaces.LaneStatistics>;
        /**
          maximum throughput (per direction)
        */
        get max_throughput(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.NetworkInterfaces.LaneStatistics>;
        get tx_streams(): VScript.rKeywordReferenceable<VScript.VSocket, "tx_streams", [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, Array<[
            number,
            number,
            number,
            number
        ]>, Array<VAPI.EthernetStats.Counter>, "NetworkInterfaces::Data::LaneStatistics", VAPI.AT1101.NetworkInterfaces.LaneStatistics>;
        get tx_all_streams(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, VAPI.AT1101.NetworkInterfaces.LaneStatistics>;
        get locked_to_data(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.NetworkInterfaces.LaneStatistics>;
        get block_lock(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.NetworkInterfaces.LaneStatistics>;
        get high_ber(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.NetworkInterfaces.LaneStatistics>;
        get bip_errors(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned64, VAPI.AT1101.NetworkInterfaces.LaneStatistics>;
        get eye(): VAPI.NetworkInterfaces.EyeDiagram;
    }
    class Port implements VScript.Referenceable<"NetworkInterfaces::Data::Port"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "NetworkInterfaces::Data::Port";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.NetworkInterfaces.Port>;
        get port_id(): VScript.rKeyword<VScript.VSocket, null | VAPI.AT1101.Primitives.NetworkPortID, null | VAPI.AT1101.Primitives.NetworkPortID, VAPI.AT1101.NetworkInterfaces.Port>;
        get device_name(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.NetworkInterfaces.Port>;
        /**
          maximum throughput (per direction)
        */
        get max_throughput(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.NetworkInterfaces.Port>;
        get port_mode(): VScript.dKeyword<VScript.VSocket, null | VAPI.AT1101.NetworkInterfaces.PortMode, null | VAPI.AT1101.NetworkInterfaces.PortMode, null | VAPI.AT1101.NetworkInterfaces.PortMode, null | VAPI.AT1101.NetworkInterfaces.PortMode, VAPI.AT1101.NetworkInterfaces.Port>;
        get fault_status(): VScript.rKeyword<VScript.VSocket, null | VAPI.NetworkInterfaces.FaultStatus, null | VAPI.NetworkInterfaces.FaultStatus, VAPI.AT1101.NetworkInterfaces.Port>;
        get health(): VAPI.NetworkInterfaces.Health;
        get link_up(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.NetworkInterfaces.Port>;
        /**
          System runtime since boot
        */
        get link_up_last_changed(): VScript.rKeyword<VScript.VSocket, number, VScript.Duration, VAPI.AT1101.NetworkInterfaces.Port>;
        /**
          How often link_up has changed since boot
        */
        get link_up_changed_count(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.NetworkInterfaces.Port>;
        /**
          MAC address, stored in big-endian order.
        */
        get mac_address(): VScript.rKeyword<VScript.VSocket, Array<number>, VAPI.NetworkInterfaces.MacAddress, VAPI.AT1101.NetworkInterfaces.Port>;
        get supports_ptp(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.NetworkInterfaces.Port>;
        get supports_rtp(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.NetworkInterfaces.Port>;
        /**
          To execute shell commands on this interface, you will first need to enter
          its hosting network namespace. E.g., if `network_namespace` reads
          `ns_eth0.2`, the following command lists its IP addresses: `ip netns exec
          ns_eth0.2 ip addr show`
        */
        get network_namespace(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.NetworkInterfaces.Port>;
        get current_configuration(): VAPI.NetworkInterfaces.CurrentPortConfiguration;
        /**
          Save interface
        */
        get save_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.NetworkInterfaces.Port>;
        /**
          Revert interface
        */
        get revert_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.NetworkInterfaces.Port>;
        get desired_configuration(): VAPI.NetworkInterfaces.DesiredPortConfiguration;
        /**
          Save syslog settings
        */
        get save_syslog_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.NetworkInterfaces.Port>;
        /**
          Revert syslog settings
        */
        get revert_syslog_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.NetworkInterfaces.Port>;
        get current_syslog_configuration(): VAPI.NetworkInterfaces.CurrentSyslogConfiguration;
        get desired_syslog_configuration(): VAPI.NetworkInterfaces.DesiredSyslogConfiguration;
        get virtual_interfaces(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::VirtualInterface", VAPI.NetworkInterfaces.VirtualInterface>;
        /**
          Updated every time a virtual interface is added, removed, or has its list
          of ip addresses changed (not necessarily monotonic, since PTP-derived).
        */
        get last_vifc_change(): VScript.rKeyword<VScript.VSocket, null | number | string, null | VAPI.Primitives.Timestamp, VAPI.AT1101.NetworkInterfaces.Port>;
        get fpga_lane_statistics(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::LaneStatistics", LaneStatistics>;
        /**
          aggregate statistics as obtained by summing over all of a
          (FPGA-connected) port's internal lanes. Note that management ports never
          report traffic statistics, regardless of their actual activity
        */
        get aggregate_traffic_statistics(): VAPI.AT1101.EthernetStats.PortStatistics;
        get lldp_neighbors(): VScript.StronglyTypedTable<VScript.VSocket, "NetworkInterfaces::Data::LLDPNeighbor", VAPI.NetworkInterfaces.LLDPNeighbor>;
    }
    type PortMode = "eth1g" | "eth10g" | "eth40g";
    const Enums: {
        readonly PortMode: PortMode[];
        readonly Lane: Lane[];
    };
}
export declare namespace PCap {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly Instance: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Instance;
        readonly Mode: (_raw: ([0, []] | [1, [number, number]]), _socket: VScript.VSocket) => Mode;
        readonly ModeStoreAndForward: (_raw: [number, number], _socket: VScript.VSocket) => ModeStoreAndForward;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly Instance: (_x: Instance) => string;
        readonly Mode: (_x: ({
            variant: "Store";
            value: VAPI.PCap.ModeStore;
        } | {
            variant: "StoreAndForward";
            value: VAPI.AT1101.PCap.ModeStoreAndForward;
        }), _socket: VScript.VSocket) => ([0, []] | [1, [number, number]]);
        readonly ModeStoreAndForward: (_x: {
            min_delay: VAPI.PCap.Delay;
            /**
              fraction of packets to be randomly excluded from retransmission,
              adjustable between 0.0 (inclusive) and 1.0 (exclusive) in steps
              of 2^(-32). TODO: support on AT1130
            */
            packet_loss_rate: number;
        }, _socket: VScript.VSocket) => [number, number];
    };
    class All implements VScript.Referenceable<"PCap::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PCap::Data::All";
        get runtime_constants(): {
            readonly num_instances: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get instances(): VScript.StronglyTypedArray<VScript.VSocket, "PCap::Data::Instance", Instance>;
    }
    class Instance implements VScript.Referenceable<"PCap::Data::Instance"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PCap::Data::Instance";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get ingress(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.NetworkInterfaces.Port, VAPI.AT1101.PCap.Instance>;
        get egress(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.NetworkInterfaces.Port, VAPI.AT1101.PCap.Instance>;
        get mode(): VScript.dKeyword<VScript.VSocket, null | ([0, []] | [
            1,
            [
                number,
                number
            ]
        ]), null | ([0, []] | [
            1,
            [
                number,
                number
            ]
        ]), null | VAPI.AT1101.PCap.Mode, null | VAPI.AT1101.PCap.Mode, VAPI.AT1101.PCap.Instance>;
        /**
          Memory area currently holding valid pcap data
        */
        get cur_range(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number
        ], VAPI.PCap.MemoryRange, VAPI.AT1101.PCap.Instance>;
        /**
          number of packets discarded because of FIFO overflow, or RX errors. Does
          not include packet losses introduced by a nonzero value of
          `packet_loss_rate`.
        */
        get packets_discarded(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.SaturatingCounter32, VAPI.AT1101.PCap.Instance>;
        get pending_dma_transfers(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned16, VAPI.AT1101.PCap.Instance>;
        get capacity_at_cur_rate(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1101.PCap.Instance>;
        get igmp_memberships(): VScript.StronglyTypedNamedTable<VScript.VSocket, "PCap::Data::IGMPMembership", VAPI.PCap.IGMPMembershipAsNamedTableRow>;
    }
    type Mode = ({
        variant: "Store";
        value: VAPI.PCap.ModeStore;
    } | {
        variant: "StoreAndForward";
        value: VAPI.AT1101.PCap.ModeStoreAndForward;
    });
    interface ModeStoreAndForward {
        min_delay: VAPI.PCap.Delay;
        /**
          fraction of packets to be randomly excluded from retransmission,
          adjustable between 0.0 (inclusive) and 1.0 (exclusive) in steps of
          2^(-32). TODO: support on AT1130
        */
        packet_loss_rate: number;
    }
}
export declare namespace PTPClock {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
    };
    const lower: {
        readonly All: (_x: All) => string;
    };
    class All implements VScript.Referenceable<"PTPClock::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPClock::Data::All";
        get runtime_constants(): {
            readonly allows_clock_randomization: boolean;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.PTPClock.All>;
        get state(): VScript.rKeyword<VScript.VSocket, VAPI.PTPClock.State, VAPI.PTPClock.State, VAPI.AT1101.PTPClock.All>;
        /**
          when `mode` is set to `LockToInput`, the PTP clock will attempt to
          synchronize with the external time source designated by `input`. This is
          the default setting and typically the only option suitable for production
          use.
          
          When `mode` is set to `UseInternalOscillator`, the PTP clock will first
          reset its speed to the nominal clock rate generated by its internal
          oscillator, and in the following suspend all clock control operations.
          Likewise, `Disconnect` suspends all clock control operations but in
          contrast to `UseInternalOscillator` continues to run at the current value
          of `relative_clock_speed`
        */
        get mode(): VScript.rwKeyword<VScript.VSocket, VAPI.PTPClock.Mode, VAPI.PTPClock.Mode, VAPI.PTPClock.Mode, VAPI.PTPClock.Mode, VAPI.AT1101.PTPClock.All>;
        get statistics(): VAPI.PTPClock.AllStatistics;
        get relative_clock_speed(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.PTPClock.All>;
        get parameters(): VAPI.PTPClock.AllParameters;
        get micro_epochs(): VScript.rKeyword<VScript.VSocket, [
            [
                number,
                number,
                number | string,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number
            ],
            [
                number,
                number,
                number | string,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number,
                number
            ],
            null | number,
            null | number
        ], VAPI.PTPClock.MicroEpochs, VAPI.AT1101.PTPClock.All>;
        get output(): VAPI.AT1101.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
        /**
          @brief Randomize clock
          @desc Do not push this button
        */
        get randomize_clock(): VScript.rwKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.PTPClock.All>;
    }
}
export declare namespace PTPFlows {
    const lift: {
        readonly Agent: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Agent;
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly Master: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Master;
        readonly MasterSettings: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MasterSettings;
        readonly Port: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Port;
        readonly PortBestMasters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PortBestMasters;
        readonly MasterVisibleVia: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MasterVisibleVia;
    };
    const lower: {
        readonly Agent: (_x: Agent) => string;
        readonly All: (_x: All) => string;
        readonly Master: (_x: Master) => string;
        readonly MasterSettings: (_x: MasterSettings) => string;
        readonly Port: (_x: Port) => string;
        readonly PortBestMasters: (_x: PortBestMasters) => string;
        readonly MasterVisibleVia: (_x: MasterVisibleVia) => string;
    };
    class Agent implements VScript.Referenceable<"PTPFlows::Data::Agent"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPFlows::Data::Agent";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get mode(): VScript.rwKeyword<VScript.VSocket, VAPI.PTPFlows.AgentMode, VAPI.PTPFlows.AgentMode, VAPI.PTPFlows.AgentMode, VAPI.PTPFlows.AgentMode, VAPI.AT1101.PTPFlows.Agent>;
        get state(): VScript.rKeyword<VScript.VSocket, VAPI.PTPFlows.AgentState, VAPI.PTPFlows.AgentState, VAPI.AT1101.PTPFlows.Agent>;
        get domain(): VScript.dKeyword<VScript.VSocket, number, number, VAPI.PTP.Domain, VAPI.PTP.Domain, VAPI.AT1101.PTPFlows.Agent>;
        get hosting_port(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.PTPFlows.Port, null | VScript.Referenceable<"PTPFlows::Data::Port"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.PTPFlows.Agent>;
        /**
          best (as defined by the Best Master Clock algorithm) PTP master visible
          on this interface and within this PTP domain, excluding this agent
          itself.
        */
        get best_foreign_master(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.PTPFlows.Master, VAPI.AT1101.PTPFlows.Agent>;
        get slave_settings(): VAPI.PTPFlows.SlaveSettings;
        get master_settings(): MasterSettings;
        get slave_statistics(): VAPI.PTPFlows.AgentSlaveStatistics;
        get master_statistics(): VAPI.PTPFlows.AgentMasterStatistics;
        get output(): VAPI.AT1101.Time.Source;
    }
    class AgentAsNamedTableRow extends Agent {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class All implements VScript.Referenceable<"PTPFlows::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPFlows::Data::All";
        get runtime_constants(): {
            readonly supports_delayresp_in_hardware: boolean;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get general_settings(): VAPI.PTPFlows.AllGeneralSettings;
        get agents(): VScript.StronglyTypedNamedTable<VScript.VSocket, "PTPFlows::Data::Agent", AgentAsNamedTableRow>;
        get ports(): VScript.StronglyTypedTable<VScript.VSocket, "PTPFlows::Data::Port", Port>;
        get visible_masters(): VScript.StronglyTypedTable<VScript.VSocket, "PTPFlows::Data::Master", Master>;
    }
    class Master implements VScript.Referenceable<"PTPFlows::Data::Master"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPFlows::Data::Master";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get gen_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1101.PTPFlows.Master>;
        get evt_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.AT1101.PTPFlows.Master>;
        get visible_via(): VScript.StronglyTypedTable<VScript.VSocket, "PTPFlows::Data::Master::VisibleVia", MasterVisibleVia>;
        /**
          PTP traits as extracted from the most recently received announce message
        */
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class MasterSettings implements VScript.Referenceable<"PTPFlows::Data::MasterSettings"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPFlows::Data::MasterSettings";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          base-2 logarithm of the announce interval in seconds. E.g., a setting of
          -2 will cause this agent to emit announce messages 4 times a second; 2
          times a second if this is set to -1.
        */
        get log2_announce_interval(): VScript.dKeyword<VScript.VSocket, number, number, VAPI.PTPFlows.MasterSettingsLog2AnnounceInterval, VAPI.PTPFlows.MasterSettingsLog2AnnounceInterval, VAPI.AT1101.PTPFlows.MasterSettings>;
        /**
          base-2 logarithm of the sync interval in seconds. E.g., a setting of -3
          will cause this agent to emit sync and followup messages 8 times a
          second; 4 times a second if this is set to -2.
        */
        get log2_sync_interval(): VScript.dKeyword<VScript.VSocket, number, number, VAPI.PTPFlows.MasterSettingsLog2SyncInterval, VAPI.PTPFlows.MasterSettingsLog2SyncInterval, VAPI.AT1101.PTPFlows.MasterSettings>;
        get delay_decimation_factor(): VScript.rKeyword<VScript.VSocket, number, VAPI.PTPFlows.MasterSettingsDelayDecimationFactor, VAPI.AT1101.PTPFlows.MasterSettings>;
        get grandmaster(): VAPI.PTPFlows.MasterSettingsGrandmaster;
        /**
          unlike sync and follow-up messages, which contain no client-dependent
          information and are thus useful to all clients within their PTP domain,
          delay request/response messages are useful only to the inquiring client
          (and perhaps to the master if it wishes to monitor its clients' timing
          properties). Exchanging these messages via unicast reduces both network
          traffic and local workload but yields otherwise identical results (this
          mode may also be called `Hybrid` on other products). If
          `delay_resp_routing` is set to `Multicast`, all delay responses emitted
          by this agent will be sent to the PTP multicast address `224.0.1.129`
        */
        get delay_resp_routing(): VScript.dKeyword<VScript.VSocket, VAPI.PTPFlows.Routing, VAPI.PTPFlows.Routing, VAPI.PTPFlows.Routing, VAPI.PTPFlows.Routing, VAPI.AT1101.PTPFlows.MasterSettings>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.PTPFlows.MasterSettings>;
    }
    class Port implements VScript.Referenceable<"PTPFlows::Data::Port"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPFlows::Data::Port";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.PTPFlows.Port>;
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.PTPFlows.Port>;
        get hosting_interface(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.NetworkInterfaces.VirtualInterface, VAPI.AT1101.PTPFlows.Port>;
        get lane(): VScript.rKeyword<VScript.VSocket, null | VAPI.AT1101.NetworkInterfaces.Lane, null | VAPI.AT1101.NetworkInterfaces.Lane, VAPI.AT1101.PTPFlows.Port>;
        get port_identity(): VScript.rKeyword<VScript.VSocket, [
            Array<number>,
            number
        ], VAPI.PTP.PortIdentity, VAPI.AT1101.PTPFlows.Port>;
        get best_masters(): VScript.StronglyTypedArray<VScript.VSocket, "PTPFlows::Data::Port::BestMasters", PortBestMasters>;
        /**
          use this TTL value for all multicast event messages (UDP port 319) sent
          out from this PTP port
        */
        get multicast_event_ttl(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.PTPFlows.Port>;
        /**
          use this TTL value for all general multicast messages (UDP port 320) sent
          out from this PTP port
        */
        get multicast_general_ttl(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.PTPFlows.Port>;
    }
    class PortBestMasters implements VScript.Referenceable<"PTPFlows::Data::Port::BestMasters"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPFlows::Data::Port::BestMasters";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.PTPFlows.Master, VAPI.AT1101.PTPFlows.PortBestMasters>;
    }
    class MasterVisibleVia implements VScript.Referenceable<"PTPFlows::Data::Master::VisibleVia"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "PTPFlows::Data::Master::VisibleVia";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get port(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.PTPFlows.Port, VAPI.AT1101.PTPFlows.MasterVisibleVia>;
        /**
          time at which an announce message from this master had last been received
          via the referenced port, measured relative to process initialization time
        */
        get announced_at(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1101.PTPFlows.MasterVisibleVia>;
    }
}
export declare namespace Primitives {
    type NetworkPortID = "FRONT_MANAGEMENT" | "REAR_MANAGEMENT" | "PORT1" | "PORT1_0" | "PORT1_1" | "PORT1_2" | "PORT1_3" | "PORT2" | "PORT2_0" | "PORT2_1" | "PORT2_2" | "PORT2_3";
    const Enums: {
        readonly NetworkPortID: NetworkPortID[];
    };
}
export declare namespace RTPReceiver {
    const lift: {
        readonly AffineNetworkSource: (_raw: [null | string, number], _socket: VScript.VSocket) => AffineNetworkSource;
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly AncBurstReceiver: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AncBurstReceiver;
        readonly AssociatedStream: (_raw: [null | string, number, null | [number, number, number, number]], _socket: VScript.VSocket) => AssociatedStream;
        readonly AudioBackend: (_raw: [number, number, null | string, Array<null | number>, number], _socket: VScript.VSocket) => AudioBackend;
        readonly AudioCapabilities: (_raw: [number, boolean, ([0, []] | [1, []])], _socket: VScript.VSocket) => AudioCapabilities;
        readonly AudioFlowPartition: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioFlowPartition;
        readonly AudioReceiver: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioReceiver;
        readonly AudioServo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioServo;
        readonly BufferProfile: (_raw: [number, number, number], _socket: VScript.VSocket) => BufferProfile;
        readonly BufferSizes: (_raw: [VAPI.AT1101.RTPReceiver.BufferSize, VAPI.AT1101.RTPReceiver.BufferSize, VAPI.AT1101.RTPReceiver.BufferSize, VAPI.AT1101.RTPReceiver.BufferSize, VAPI.AT1101.RTPReceiver.BufferSize, VAPI.AT1101.RTPReceiver.BufferSize, VAPI.AT1101.RTPReceiver.BufferSize], _socket: VScript.VSocket) => BufferSizes;
        readonly TimingTargetForeignMediaClock: (_raw: [null | string, number, VAPI.RTPReceiver.BackpressurePolicy], _socket: VScript.VSocket) => TimingTargetForeignMediaClock;
        readonly TimingTargetForeignReadDelay: (_raw: [null | string, number, VAPI.RTPReceiver.BackpressurePolicy], _socket: VScript.VSocket) => TimingTargetForeignReadDelay;
        readonly JpegXsVideoBackend: (_raw: [number, Array<null | number>, number, null | [number, number, [number, number], number, number]], _socket: VScript.VSocket) => JpegXsVideoBackend;
        readonly ReadSpeedLockToGenlock: (_raw: [], _socket: VScript.VSocket) => ReadSpeedLockToGenlock;
        readonly MediaReceiver: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MediaReceiver;
        readonly MetadataBackend: (_raw: [number, number, [number, number], number, number], _socket: VScript.VSocket) => MetadataBackend;
        readonly NativeVideoBackend: (_raw: [number, Array<null | number>, number, null | [number, number, [number, number], number, number]], _socket: VScript.VSocket) => NativeVideoBackend;
        readonly NetworkSource: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => NetworkSource;
        readonly PacketStream: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PacketStream;
        readonly PacketTracer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PacketTracer;
        readonly PassthroughEssence: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PassthroughEssence;
        readonly PassthroughFlowPartition: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PassthroughFlowPartition;
        readonly PassthroughReceiver: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PassthroughReceiver;
        readonly ReadSpeed: (_raw: ([0, []] | [1, []]), _socket: VScript.VSocket) => ReadSpeed;
        readonly ReserveAudioBackend: (_raw: [number, number, Array<null | number>, number, null | number], _socket: VScript.VSocket) => ReserveAudioBackend;
        readonly Session: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Session;
        readonly TimingTargetTimeSource: (_raw: [null | string, boolean], _socket: VScript.VSocket) => TimingTargetTimeSource;
        readonly Timing: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Timing;
        readonly TimingTarget: (_raw: ([0, [number]] | [1, [number]] | [2, [null | string, boolean]] | [3, []] | [4, [null | string, number, VAPI.RTPReceiver.BackpressurePolicy]] | [5, [null | string, number, VAPI.RTPReceiver.BackpressurePolicy]]), _socket: VScript.VSocket) => TimingTarget;
        readonly VideoBackend: (_raw: [null | [number, Array<null | number>, number, null | [number, number, [number, number], number, number]], null | [number, Array<null | number>, number, null | [number, number, [number, number], number, number]], null | string], _socket: VScript.VSocket) => VideoBackend;
        readonly VideoCapabilities: (_raw: [boolean, boolean, null | VAPI.RTPReceiver.VideoCapabilitiesSt211020Caliber, null | VAPI.RTPReceiver.VideoCapabilitiesSt20422Caliber, null | VAPI.RTPReceiver.VideoCapabilitiesJpegXsCaliber, boolean, boolean, ([0, []] | [1, []])], _socket: VScript.VSocket) => VideoCapabilities;
        readonly VideoFlowPartition: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoFlowPartition;
        readonly VideoReceiver: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoReceiver;
        readonly VideoServo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoServo;
        readonly AllDiagnostics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AllDiagnostics;
        readonly PassthroughReceiverFlowPartitions: (_raw: [null | string, null | string], _socket: VScript.VSocket) => PassthroughReceiverFlowPartitions;
        readonly AudioReceiverMediaSpecificFlowPartitions: (_raw: [null | string, null | string], _socket: VScript.VSocket) => AudioReceiverMediaSpecificFlowPartitions;
        readonly VideoReceiverMediaSpecificFlowPartitions: (_raw: [null | string, null | string], _socket: VScript.VSocket) => VideoReceiverMediaSpecificFlowPartitions;
        readonly AllDiagnosticsIgmpPerformanceMetricsIgmpLatency: (_raw: [null | VAPI.AT1101.Primitives.NetworkPortID, null | string, null | string, null | number, null | number, null | number, null | number], _socket: VScript.VSocket) => AllDiagnosticsIgmpPerformanceMetricsIgmpLatency;
        readonly AllDiagnosticsIgmpPerformanceMetrics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AllDiagnosticsIgmpPerformanceMetrics;
        readonly AncBurstReceiverMediaClock: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AncBurstReceiverMediaClock;
        readonly AudioReceiverMediaSpecific: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioReceiverMediaSpecific;
        readonly VideoReceiverMediaSpecific: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoReceiverMediaSpecific;
        readonly PassthroughEssenceMemoryBlocks: (_raw: [number, Array<null | number>], _socket: VScript.VSocket) => PassthroughEssenceMemoryBlocks;
        readonly AudioReceiverMediaSpecificOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioReceiverMediaSpecificOutput;
        readonly VideoReceiverMediaSpecificOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoReceiverMediaSpecificOutput;
        readonly MediaReceiverPacketStreams: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MediaReceiverPacketStreams;
        readonly AllDiagnosticsRtpInput: (_raw: [Array<number>, number, number, number, number, number], _socket: VScript.VSocket) => AllDiagnosticsRtpInput;
        readonly AllSettings: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AllSettings;
    };
    const lower: {
        readonly AffineNetworkSource: (_x: {
            source: null | VAPI.AT1101.RTPReceiver.NetworkSource;
            seqnr_offset: VAPI.Primitives.Unsigned16;
        }, _socket: VScript.VSocket) => [null | string, number];
        readonly All: (_x: All) => string;
        readonly AncBurstReceiver: (_x: AncBurstReceiver) => string;
        readonly AssociatedStream: (_x: {
            stream: null | VAPI.AT1101.RTPReceiver.PacketStream;
            /**
              used to distinguish between a video flow's underlying video streams
              (subflows 0 to 3 for a quad-link flow, 0 otherwise), and its
              2110-40 sidecar (4), if any
            */
            subflow_index: VAPI.RTPReceiver.SubflowIndex;
            read_delay: null | VAPI.Time.TimestampedOffset;
        }, _socket: VScript.VSocket) => [null | string, number, null | [number, number, number, number]];
        readonly AudioBackend: (_x: {
            group: VAPI.RTPReceiver.AudioBlockIndex;
            instance: VAPI.RTPReceiver.AudioInstanceIndex;
            servo: null | VAPI.AT1101.RTPReceiver.AudioServo;
            slices: Array<null | VAPI.RTPReceiver.LocalSliceIndex>;
            channel: VAPI.AT1101.RTPReceiver.RAMChannel;
        }, _socket: VScript.VSocket) => [number, number, null | string, Array<null | number>, number];
        readonly AudioCapabilities: (_x: {
            channel_capacity: VAPI.RTPReceiver.ChannelCapacity;
            supports_clean_switching: boolean;
            read_speed: VAPI.AT1101.RTPReceiver.ReadSpeed;
        }, _socket: VScript.VSocket) => [number, boolean, ([0, []] | [1, []])];
        readonly AudioFlowPartition: (_x: AudioFlowPartition) => string;
        readonly AudioReceiver: (_x: AudioReceiver) => string;
        readonly AudioServo: (_x: AudioServo) => string;
        readonly BufferProfile: (_x: {
            channel: VAPI.AT1101.RTPReceiver.RAMChannel;
            pseudo_channel: VAPI.AT1101.RTPReceiver.RAMPseudoChannel;
            blockcount: VAPI.RTPReceiver.BlockCount;
        }, _socket: VScript.VSocket) => [number, number, number];
        readonly BufferSizes: (_x: {
            for_audio: VAPI.AT1101.RTPReceiver.BufferSize;
            for_2022_6: VAPI.AT1101.RTPReceiver.BufferSize;
            for_2110_20_uhd_singlelink: VAPI.AT1101.RTPReceiver.BufferSize;
            for_2110_20_other: VAPI.AT1101.RTPReceiver.BufferSize;
            for_2042_2: VAPI.AT1101.RTPReceiver.BufferSize;
            for_jpeg_xs: VAPI.AT1101.RTPReceiver.BufferSize;
            for_passthrough: VAPI.AT1101.RTPReceiver.BufferSize;
        }, _socket: VScript.VSocket) => [VAPI.AT1101.RTPReceiver.BufferSize, VAPI.AT1101.RTPReceiver.BufferSize, VAPI.AT1101.RTPReceiver.BufferSize, VAPI.AT1101.RTPReceiver.BufferSize, VAPI.AT1101.RTPReceiver.BufferSize, VAPI.AT1101.RTPReceiver.BufferSize, VAPI.AT1101.RTPReceiver.BufferSize];
        readonly TimingTargetForeignMediaClock: (_x: {
            foreign_receiver: null | VAPI.AT1101.RTPReceiver.MediaReceiver;
            extra_delay: VScript.Duration;
            on_backpressure: VAPI.RTPReceiver.BackpressurePolicy;
        }, _socket: VScript.VSocket) => [null | string, number, VAPI.RTPReceiver.BackpressurePolicy];
        readonly TimingTargetForeignReadDelay: (_x: {
            foreign_receiver: null | VAPI.AT1101.RTPReceiver.MediaReceiver;
            extra_delay: VScript.Duration;
            on_backpressure: VAPI.RTPReceiver.BackpressurePolicy;
        }, _socket: VScript.VSocket) => [null | string, number, VAPI.RTPReceiver.BackpressurePolicy];
        readonly JpegXsVideoBackend: (_x: {
            group: VAPI.RTPReceiver.JpegXsBlockIndex;
            instances: Array<null | VAPI.RTPReceiver.JpegXsDecoderInstance>;
            channel: VAPI.AT1101.RTPReceiver.RAMChannel;
            metadata: null | VAPI.AT1101.RTPReceiver.MetadataBackend;
        }, _socket: VScript.VSocket) => [number, Array<null | number>, number, null | [number, number, [number, number], number, number]];
        readonly ReadSpeedLockToGenlock: (_x: {}, _socket: VScript.VSocket) => [];
        readonly MediaReceiver: (_x: MediaReceiver) => string;
        readonly MetadataBackend: (_x: {
            group: VAPI.RTPReceiver.MetadataBackendGroup;
            instance: VAPI.RTPReceiver.MetadataBackendInstance;
            stats_id: VAPI.RTPReceiver.StatsID;
            /**
              TODO: should have dynamic, dts-derived bounds
            */
            read_id: VAPI.RTPReceiver.MMUReadIndex;
            channel: VAPI.AT1101.RTPReceiver.RAMChannel;
        }, _socket: VScript.VSocket) => [number, number, [number, number], number, number];
        readonly NativeVideoBackend: (_x: {
            group: VAPI.RTPReceiver.NativeVideoBlockIndex;
            instances: Array<null | VAPI.RTPReceiver.NativeVideoDecoderInstance>;
            channel: VAPI.AT1101.RTPReceiver.RAMChannel;
            metadata: null | VAPI.AT1101.RTPReceiver.MetadataBackend;
        }, _socket: VScript.VSocket) => [number, Array<null | number>, number, null | [number, number, [number, number], number, number]];
        readonly NetworkSource: (_x: NetworkSource) => string;
        readonly PacketStream: (_x: PacketStream) => string;
        readonly PacketTracer: (_x: PacketTracer) => string;
        readonly PassthroughEssence: (_x: PassthroughEssence) => string;
        readonly PassthroughFlowPartition: (_x: PassthroughFlowPartition) => string;
        readonly PassthroughReceiver: (_x: PassthroughReceiver) => string;
        readonly ReadSpeed: (_x: ({
            variant: "LockToGenlock";
            value: VAPI.AT1101.RTPReceiver.ReadSpeedLockToGenlock;
        } | {
            variant: "Adaptive";
            value: VAPI.RTPReceiver.ReadSpeedAdaptive;
        }), _socket: VScript.VSocket) => ([0, []] | [1, []]);
        readonly ReserveAudioBackend: (_x: {
            group: VAPI.RTPReceiver.AudioBlockIndex;
            instance: VAPI.RTPReceiver.AudioInstanceIndex;
            slices: Array<null | VAPI.RTPReceiver.LocalSliceIndex>;
            channel: VAPI.AT1101.RTPReceiver.RAMChannel;
            fence: null | VAPI.Time.FreeRunningCounter;
        }, _socket: VScript.VSocket) => [number, number, Array<null | number>, number, null | number];
        readonly Session: (_x: Session) => string;
        readonly TimingTargetTimeSource: (_x: {
            t_src: null | VAPI.AT1101.Time.Source;
            use_rtp_timestamp: boolean;
        }, _socket: VScript.VSocket) => [null | string, boolean];
        readonly Timing: (_x: Timing) => string;
        readonly TimingTarget: (_x: ({
            variant: "IngressPlusX";
            value: VAPI.RTPReceiver.TimingTargetIngressPlusX;
        } | {
            variant: "EgressPlusX";
            value: VAPI.RTPReceiver.TimingTargetEgressPlusX;
        } | {
            variant: "TimeSource";
            value: VAPI.AT1101.RTPReceiver.TimingTargetTimeSource;
        } | {
            variant: "BufferMidpoint";
            value: VAPI.RTPReceiver.TimingTargetBufferMidpoint;
        } | {
            variant: "ForeignReadDelay";
            value: VAPI.AT1101.RTPReceiver.TimingTargetForeignReadDelay;
        } | {
            variant: "ForeignMediaClock";
            value: VAPI.AT1101.RTPReceiver.TimingTargetForeignMediaClock;
        }), _socket: VScript.VSocket) => ([0, [number]] | [1, [number]] | [2, [null | string, boolean]] | [3, []] | [4, [null | string, number, VAPI.RTPReceiver.BackpressurePolicy]] | [5, [null | string, number, VAPI.RTPReceiver.BackpressurePolicy]]);
        readonly VideoBackend: (_x: {
            native: null | VAPI.AT1101.RTPReceiver.NativeVideoBackend;
            jpeg_xs: null | VAPI.AT1101.RTPReceiver.JpegXsVideoBackend;
            servo: null | VAPI.AT1101.RTPReceiver.VideoServo;
        }, _socket: VScript.VSocket) => [null | [number, Array<null | number>, number, null | [number, number, [number, number], number, number]], null | [number, Array<null | number>, number, null | [number, number, [number, number], number, number]], null | string];
        readonly VideoCapabilities: (_x: {
            supports_2022_6: boolean;
            supports_uhd_sample_interleaved: boolean;
            st2110_20_caliber: null | VAPI.RTPReceiver.VideoCapabilitiesSt211020Caliber;
            st2042_2_caliber: null | VAPI.RTPReceiver.VideoCapabilitiesSt20422Caliber;
            jpeg_xs_caliber: null | VAPI.RTPReceiver.VideoCapabilitiesJpegXsCaliber;
            supports_2110_40: boolean;
            supports_clean_switching: boolean;
            read_speed: VAPI.AT1101.RTPReceiver.ReadSpeed;
        }, _socket: VScript.VSocket) => [boolean, boolean, null | VAPI.RTPReceiver.VideoCapabilitiesSt211020Caliber, null | VAPI.RTPReceiver.VideoCapabilitiesSt20422Caliber, null | VAPI.RTPReceiver.VideoCapabilitiesJpegXsCaliber, boolean, boolean, ([0, []] | [1, []])];
        readonly VideoFlowPartition: (_x: VideoFlowPartition) => string;
        readonly VideoReceiver: (_x: VideoReceiver) => string;
        readonly VideoServo: (_x: VideoServo) => string;
        readonly AllDiagnostics: (_x: AllDiagnostics) => string;
        readonly PassthroughReceiverFlowPartitions: (_x: {
            sdp_a: null | VAPI.AT1101.RTPReceiver.PassthroughFlowPartition;
            sdp_b: null | VAPI.AT1101.RTPReceiver.PassthroughFlowPartition;
        }, _socket: VScript.VSocket) => [null | string, null | string];
        readonly AudioReceiverMediaSpecificFlowPartitions: (_x: {
            sdp_a: null | VAPI.AT1101.RTPReceiver.AudioFlowPartition;
            sdp_b: null | VAPI.AT1101.RTPReceiver.AudioFlowPartition;
        }, _socket: VScript.VSocket) => [null | string, null | string];
        readonly VideoReceiverMediaSpecificFlowPartitions: (_x: {
            sdp_a: null | VAPI.AT1101.RTPReceiver.VideoFlowPartition;
            sdp_b: null | VAPI.AT1101.RTPReceiver.VideoFlowPartition;
        }, _socket: VScript.VSocket) => [null | string, null | string];
        readonly AllDiagnosticsIgmpPerformanceMetricsIgmpLatency: (_x: {
            port: null | VAPI.AT1101.Primitives.NetworkPortID;
            src: null | string;
            dst: null | string;
            time_to_first_mpacket: null | VScript.Duration;
            first_rtp_timestamp: null | VAPI.Time.RTPTimestamp;
            first_rtp_seqnr: null | VAPI.RTPReceiver.Seqnr;
            /**
              time between two m-packets. This
              defines the latency measurement's
              uncertainty and depends on video
              standards, transport formats and
              (for audio streams) on the
              currently configured IRQ rate
            */
            mpacket_interval: null | VScript.Duration;
        }, _socket: VScript.VSocket) => [null | VAPI.AT1101.Primitives.NetworkPortID, null | string, null | string, null | number, null | number, null | number, null | number];
        readonly AllDiagnosticsIgmpPerformanceMetrics: (_x: AllDiagnosticsIgmpPerformanceMetrics) => string;
        readonly AncBurstReceiverMediaClock: (_x: AncBurstReceiverMediaClock) => string;
        readonly AudioReceiverMediaSpecific: (_x: AudioReceiverMediaSpecific) => string;
        readonly VideoReceiverMediaSpecific: (_x: VideoReceiverMediaSpecific) => string;
        readonly PassthroughEssenceMemoryBlocks: (_x: {
            channel: VAPI.AT1101.RTPReceiver.RAMChannel;
            blocks: Array<null | VAPI.AT1101.RTPReceiver.RAMBlock>;
        }, _socket: VScript.VSocket) => [number, Array<null | number>];
        readonly AudioReceiverMediaSpecificOutput: (_x: AudioReceiverMediaSpecificOutput) => string;
        readonly VideoReceiverMediaSpecificOutput: (_x: VideoReceiverMediaSpecificOutput) => string;
        readonly MediaReceiverPacketStreams: (_x: MediaReceiverPacketStreams) => string;
        readonly AllDiagnosticsRtpInput: (_x: {
            input_oom: Array<VAPI.Primitives.SaturatingCounter32>;
            queue_full: VAPI.Primitives.SaturatingCounter32;
            lowest_memfree: number;
            memfree: number;
            highest_fifo_usedw: number;
            fifo_usedw: number;
        }, _socket: VScript.VSocket) => [Array<number>, number, number, number, number, number];
        readonly AllSettings: (_x: AllSettings) => string;
    };
    interface AffineNetworkSource {
        source: null | VAPI.AT1101.RTPReceiver.NetworkSource;
        seqnr_offset: VAPI.Primitives.Unsigned16;
    }
    class All implements VScript.Referenceable<"RTPReceiver::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::All";
        get runtime_constants(): {
            readonly total_2022_6_audio_slices: number;
            readonly supports_2110_40_in_software: boolean;
            readonly max_audio_receivers: number;
            readonly uhd_packsize_2042_2: number;
            readonly uhd_packsize_2110_20: number;
            readonly supports_2110_40_in_hardware: boolean;
            readonly max_metadata_receivers: number;
            readonly video_memory_channels: number;
            readonly num_native_video_receiver_blocks: number;
            readonly audio_memory_channels: number;
            readonly total_2110_30_audio_slices: number;
            readonly num_metadata_extractors_per_video_receiver: number;
            readonly blocks_per_memory_channel: number;
            readonly max_st2042_2_uhd_video_receivers: number;
            readonly max_sessions: number;
            readonly num_jpeg_xs_video_receiver_blocks: number;
            readonly max_passthrough_receivers: number;
            readonly max_video_buffers: number;
            readonly num_packet_tracers: number;
            readonly max_anc_burst_receivers: number;
            readonly max_metadata_streams: number;
            readonly max_st2110_20_uhd_video_receivers: number;
            readonly max_native_video_receivers: number;
            readonly num_audio_receiver_blocks: number;
            readonly max_video_receivers: number;
            readonly max_metadata_buffers: number;
            readonly max_jpeg_xs_video_receivers: number;
            readonly num_metadata_receiver_blocks: number;
            readonly num_audio_servos: number;
            readonly num_video_servos: number;
            readonly max_st2042_2_video_receivers: number;
            readonly uhd_packsize_2si: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get license_information(): VAPI.RTPReceiver.AllLicenseInformation;
        get diagnostics(): AllDiagnostics;
        get settings(): AllSettings;
        get latest_allocation_id(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.CapabilityRequestID, VAPI.AT1101.RTPReceiver.All>;
        get sessions(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPReceiver::Data::Session", SessionAsNamedTableRow>;
        get audio_receivers(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPReceiver::Data::AudioReceiver", AudioReceiverAsNamedTableRow>;
        get passthrough_receivers(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPReceiver::Data::PassthroughReceiver", PassthroughReceiverAsNamedTableRow>;
        get video_receivers(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPReceiver::Data::VideoReceiver", VideoReceiverAsNamedTableRow>;
        get anc_burst_receivers(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPReceiver::Data::AncBurstReceiver", AncBurstReceiverAsNamedTableRow>;
        get signal_slices_2110_30(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
        get signal_slices_2022_6(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
        get packet_streams(): VScript.StronglyTypedTable<VScript.VSocket, "RTPReceiver::Data::PacketStream", PacketStream>;
        get network_sources(): VScript.StronglyTypedTable<VScript.VSocket, "RTPReceiver::Data::NetworkSource", NetworkSource>;
        get audio_flow_partitions(): VScript.StronglyTypedTable<VScript.VSocket, "RTPReceiver::Data::AudioFlowPartition", AudioFlowPartition>;
        get passthrough_flow_partitions(): VScript.StronglyTypedTable<VScript.VSocket, "RTPReceiver::Data::PassthroughFlowPartition", PassthroughFlowPartition>;
        get video_flow_partitions(): VScript.StronglyTypedTable<VScript.VSocket, "RTPReceiver::Data::VideoFlowPartition", VideoFlowPartition>;
        get derived_ptp_traits(): VAPI.RTPReceiver.AllDerivedPtpTraits;
        get audio_servos(): VScript.StronglyTypedArray<VScript.VSocket, "RTPReceiver::Data::AudioServo", AudioServo>;
        get video_servos(): VScript.StronglyTypedArray<VScript.VSocket, "RTPReceiver::Data::VideoServo", VideoServo>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.AllIssues, VAPI.AT1101.RTPReceiver.All>;
    }
    class AncBurstReceiver implements VScript.Referenceable<"RTPReceiver::Data::AncBurstReceiver"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::AncBurstReceiver";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get generic(): MediaReceiver;
        get media_clock(): AncBurstReceiverMediaClock;
    }
    class AncBurstReceiverAsNamedTableRow extends AncBurstReceiver {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    /**
      for every subflow index, the first entry to appear in this list represents
      its rear guard
    */
    interface AssociatedStream {
        stream: null | VAPI.AT1101.RTPReceiver.PacketStream;
        /**
          used to distinguish between a video flow's underlying video streams
          (subflows 0 to 3 for a quad-link flow, 0 otherwise), and its 2110-40
          sidecar (4), if any
        */
        subflow_index: VAPI.RTPReceiver.SubflowIndex;
        read_delay: null | VAPI.Time.TimestampedOffset;
    }
    interface AudioBackend {
        group: VAPI.RTPReceiver.AudioBlockIndex;
        instance: VAPI.RTPReceiver.AudioInstanceIndex;
        servo: null | VAPI.AT1101.RTPReceiver.AudioServo;
        slices: Array<null | VAPI.RTPReceiver.LocalSliceIndex>;
        channel: VAPI.AT1101.RTPReceiver.RAMChannel;
    }
    interface AudioCapabilities {
        channel_capacity: VAPI.RTPReceiver.ChannelCapacity;
        supports_clean_switching: boolean;
        read_speed: VAPI.AT1101.RTPReceiver.ReadSpeed;
    }
    class AudioFlowPartition implements VScript.Referenceable<"RTPReceiver::Data::AudioFlowPartition"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::AudioFlowPartition";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get id(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.PartitionID, VAPI.AT1101.RTPReceiver.AudioFlowPartition>;
        get format(): VScript.rKeyword<VScript.VSocket, null | VAPI.Audio.Format, null | VAPI.Audio.Format, VAPI.AT1101.RTPReceiver.AudioFlowPartition>;
        get frequency(): VScript.rKeyword<VScript.VSocket, null | VAPI.Audio.Frequency, null | VAPI.Audio.Frequency, VAPI.AT1101.RTPReceiver.AudioFlowPartition>;
        get channelcount(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.RTPReceiver.AudioFlowPartition>;
        get samplecount(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.RTPReceiver.AudioFlowPartition>;
        /**
          Network sources feeding this flow partition; if more than 8 sources feed
          into a single partition, surplus sources will not be published via the
          web interface
        */
        get sources(): VScript.rKeyword<VScript.VSocket, Array<[
            null | string,
            number
        ]>, Array<VAPI.AT1101.RTPReceiver.AffineNetworkSource>, VAPI.AT1101.RTPReceiver.AudioFlowPartition>;
    }
    class AudioReceiver implements VScript.Referenceable<"RTPReceiver::Data::AudioReceiver"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::AudioReceiver";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get generic(): MediaReceiver;
        get media_specific(): AudioReceiverMediaSpecific;
    }
    class AudioReceiverAsNamedTableRow extends AudioReceiver {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class AudioServo implements VScript.Referenceable<"RTPReceiver::Data::AudioServo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::AudioServo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get relative_speed(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.RTPReceiver.AudioServo>;
        get max_relative_speed(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.RTPReceiver.AudioServo>;
        get max_acceleration(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.RTPReceiver.AudioServo>;
        get prioritize(): VScript.rKeyword<VScript.VSocket, VAPI.RTPReceiver.AudioServoPrioritize, VAPI.RTPReceiver.AudioServoPrioritize, VAPI.AT1101.RTPReceiver.AudioServo>;
        get dt_node(): VScript.rKeyword<VScript.VSocket, null | VScript.DeviceTreeNodePayload, null | VScript.DeviceTreeNodePayload, VAPI.AT1101.RTPReceiver.AudioServo>;
        get sop_dt_node(): VScript.rKeyword<VScript.VSocket, null | VScript.DeviceTreeNodePayload, null | VScript.DeviceTreeNodePayload, VAPI.AT1101.RTPReceiver.AudioServo>;
    }
    interface BufferProfile {
        channel: VAPI.AT1101.RTPReceiver.RAMChannel;
        pseudo_channel: VAPI.AT1101.RTPReceiver.RAMPseudoChannel;
        blockcount: VAPI.RTPReceiver.BlockCount;
    }
    type BufferSize = "UpTo4KiPackets" | "UpTo8KiPackets" | "UpTo16KiPackets" | "UpTo32KiPackets" | "UpTo64KiPackets";
    interface BufferSizes {
        for_audio: VAPI.AT1101.RTPReceiver.BufferSize;
        for_2022_6: VAPI.AT1101.RTPReceiver.BufferSize;
        for_2110_20_uhd_singlelink: VAPI.AT1101.RTPReceiver.BufferSize;
        for_2110_20_other: VAPI.AT1101.RTPReceiver.BufferSize;
        for_2042_2: VAPI.AT1101.RTPReceiver.BufferSize;
        for_jpeg_xs: VAPI.AT1101.RTPReceiver.BufferSize;
        for_passthrough: VAPI.AT1101.RTPReceiver.BufferSize;
    }
    interface TimingTargetForeignMediaClock {
        foreign_receiver: null | VAPI.AT1101.RTPReceiver.MediaReceiver;
        extra_delay: VScript.Duration;
        on_backpressure: VAPI.RTPReceiver.BackpressurePolicy;
    }
    interface TimingTargetForeignReadDelay {
        foreign_receiver: null | VAPI.AT1101.RTPReceiver.MediaReceiver;
        extra_delay: VScript.Duration;
        on_backpressure: VAPI.RTPReceiver.BackpressurePolicy;
    }
    interface JpegXsVideoBackend {
        group: VAPI.RTPReceiver.JpegXsBlockIndex;
        instances: Array<null | VAPI.RTPReceiver.JpegXsDecoderInstance>;
        channel: VAPI.AT1101.RTPReceiver.RAMChannel;
        metadata: null | VAPI.AT1101.RTPReceiver.MetadataBackend;
    }
    interface ReadSpeedLockToGenlock {
    }
    class MediaReceiver implements VScript.Referenceable<"RTPReceiver::Data::MediaReceiver"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::MediaReceiver";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.RTPReceiver.MediaReceiver>;
        get tracks(): VScript.rKeyword<VScript.VSocket, [
            VAPI.RTPReceiver.TrackSet,
            VAPI.RTPReceiver.OrderedTrackSet,
            null | VAPI.RTPReceiver.Track,
            null | VAPI.RTPReceiver.Track,
            null | VAPI.RTPReceiver.Track,
            null | VAPI.RTPReceiver.Track
        ], VAPI.RTPReceiver.UsedReceiverTracks, VAPI.AT1101.RTPReceiver.MediaReceiver>;
        get main_region_holds(): VScript.rKeyword<VScript.VSocket, VAPI.RTPReceiver.Track, VAPI.RTPReceiver.Track, VAPI.AT1101.RTPReceiver.MediaReceiver>;
        get hosting_session(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.RTPReceiver.Session, null | VScript.Referenceable<"RTPReceiver::Data::Session"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.RTPReceiver.MediaReceiver>;
        get ingress(): VScript.rKeyword<VScript.VSocket, [
            VAPI.RTPReceiver.IngressTrackState,
            VAPI.RTPReceiver.IngressTrackState
        ], VAPI.RTPReceiver.Ingress, VAPI.AT1101.RTPReceiver.MediaReceiver>;
        get egress(): VScript.rKeyword<VScript.VSocket, [
            Array<null | [
                boolean,
                null | number
            ]>
        ], VAPI.RTPReceiver.Egress, VAPI.AT1101.RTPReceiver.MediaReceiver>;
        get expecting(): VScript.rKeyword<VScript.VSocket, [
            boolean,
            [
                boolean,
                boolean
            ]
        ], VAPI.RTPReceiver.Expectations, VAPI.AT1101.RTPReceiver.MediaReceiver>;
        /**
          Clear error counters
        */
        get clear_error_counters(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.RTPReceiver.MediaReceiver>;
        /**
          Clear event counters
        */
        get clear_event_counters(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.RTPReceiver.MediaReceiver>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.MediaReceiverIssues, VAPI.AT1101.RTPReceiver.MediaReceiver>;
        /**
          Ideally, this keyword shouldn't exist. In practice however, capability
          requests are currently processed eagerly, s.t. the outcome of a
          capability allocation attempt may depend on the order in which individual
          receivers are serviced. To ensure full state recovery across reboots, we
          thus store this ordering explicitly
        */
        get capability_request(): VScript.rKeyword<VScript.VSocket, [
            null | number,
            null | number
        ], VAPI.RTPReceiver.CapabilityRequestIDs, VAPI.AT1101.RTPReceiver.MediaReceiver>;
        get flight_permit(): VAPI.RTPReceiver.MediaReceiverFlightPermit;
        get error_counters(): VAPI.RTPReceiver.MediaReceiverErrorCounters;
        get event_counters(): VAPI.RTPReceiver.MediaReceiverEventCounters;
        get preparation_time(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.RTPReceiver.MediaReceiver>;
        get cooldown_time(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.RTPReceiver.MediaReceiver>;
        get timing(): Timing;
        get packet_streams(): MediaReceiverPacketStreams;
        get required_redundancy_level(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.RTPReceiver.MediaReceiverRequiredRedundancyLevel, VAPI.AT1101.RTPReceiver.MediaReceiver>;
        get redundancy_levels(): VAPI.RTPReceiver.MediaReceiverRedundancyLevels;
        get latency_spread(): VAPI.RTPReceiver.MediaReceiverLatencySpread;
        /**
          when set to `FirstStreamPresent`, the first packet stream to provide this
          receiver with valid format and timing characteristics will be used as the
          basis for the ensuing readout attempt. When set to `AllStreamsPresent`,
          the receiver will stall until all packet streams have been registered at
          their respective network interfaces. Whereas `FirstStreamPresent` may
          slightly reduce the time to readout, `AllStreamsPresent` is safer as it
          ensures immediate SPS protection (if so configured), and allows the
          receiver to correctly pick a rearguard stream if different network paths
          exhibit different transmission delays. In both cases, the set of packet
          streams considered encompasses only those flows directly referenced by
          this receiver's media description, not the auxiliary flows that may be
          routed to the receiver through stream sharing.
        */
        get initiate_readout_on(): VScript.dKeyword<VScript.VSocket, VAPI.RTPReceiver.MediaReceiverInitiateReadoutOn, VAPI.RTPReceiver.MediaReceiverInitiateReadoutOn, VAPI.RTPReceiver.MediaReceiverInitiateReadoutOn, VAPI.RTPReceiver.MediaReceiverInitiateReadoutOn, VAPI.AT1101.RTPReceiver.MediaReceiver>;
    }
    interface MetadataBackend {
        group: VAPI.RTPReceiver.MetadataBackendGroup;
        instance: VAPI.RTPReceiver.MetadataBackendInstance;
        stats_id: VAPI.RTPReceiver.StatsID;
        /**
          TODO: should have dynamic, dts-derived bounds
        */
        read_id: VAPI.RTPReceiver.MMUReadIndex;
        channel: VAPI.AT1101.RTPReceiver.RAMChannel;
    }
    interface NativeVideoBackend {
        group: VAPI.RTPReceiver.NativeVideoBlockIndex;
        instances: Array<null | VAPI.RTPReceiver.NativeVideoDecoderInstance>;
        channel: VAPI.AT1101.RTPReceiver.RAMChannel;
        metadata: null | VAPI.AT1101.RTPReceiver.MetadataBackend;
    }
    class NetworkSource implements VScript.Referenceable<"RTPReceiver::Data::NetworkSource"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::NetworkSource";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get packet_stream(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.RTPReceiver.PacketStream, VAPI.AT1101.RTPReceiver.NetworkSource>;
    }
    class PacketStream implements VScript.Referenceable<"RTPReceiver::Data::PacketStream"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::PacketStream";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get stream_parameters(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            null | string,
            null | string,
            null | string,
            VAPI.RTPReceiver.PacketStreamType,
            VAPI.RTPReceiver.PacketStreamStreamParametersIrqRate
        ], null | VAPI.RTPReceiver.PacketStreamStreamParameters, VAPI.AT1101.RTPReceiver.PacketStream>;
        /**
          no. of m-packets received since the last stream start (for audio streams,
          this refers to virtual m-packets). Note that for interlaced video
          streams, this number only includes lower field m-packets, i.e., a 50i
          2110 stream should report 25 m-packets per second.
        */
        get mpackets_received(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned64, VAPI.AT1101.RTPReceiver.PacketStream>;
        get traffic_stats(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, VAPI.AT1101.RTPReceiver.PacketStream>;
        get media_clock(): VAPI.AT1101.Time.Source;
    }
    class PacketTracer implements VScript.Referenceable<"RTPReceiver::Data::PacketTracer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::PacketTracer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          Set to true to enable realtime packet tracing in one of various modes.
          Note that packet tracing is CPU-intensive, and hence will always come up
          disabled after reboots.
        */
        get active(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.RTPReceiver.PacketTracer>;
        get mode(): VScript.dKeyword<VScript.VSocket, VAPI.RTPReceiver.PacketTracerMode, VAPI.RTPReceiver.PacketTracerMode, VAPI.RTPReceiver.PacketTracerMode, VAPI.RTPReceiver.PacketTracerMode, VAPI.AT1101.RTPReceiver.PacketTracer>;
        /**
          Set this to `Store` to have the packet tracer store packet details (up to
          some limited maximum log file size) that can later be downloaded via
          HTTP.
        */
        get packet_details(): VScript.dKeyword<VScript.VSocket, VAPI.RTPReceiver.PacketTracerPacketDetails, VAPI.RTPReceiver.PacketTracerPacketDetails, VAPI.RTPReceiver.PacketTracerPacketDetails, VAPI.RTPReceiver.PacketTracerPacketDetails, VAPI.AT1101.RTPReceiver.PacketTracer>;
        get filters(): VAPI.RTPReceiver.PacketTracerFilters;
        /**
          Reorder up to this many consecutive RTP packets before trying to check
          for missing sequence numbers
        */
        get reordering_depth(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.RTPReceiver.PacketTracer>;
        get port(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.NetworkInterfaces.Port, null | VScript.Referenceable<"NetworkInterfaces::Data::Port"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.RTPReceiver.PacketTracer>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.PacketTracerIssues, VAPI.AT1101.RTPReceiver.PacketTracer>;
        get cur_run(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number | string,
            number | string,
            number,
            number,
            number,
            number,
            number,
            number,
            VAPI.RTPReceiver.PacketTracerRunPacketDetails,
            VAPI.RTPReceiver.PacketTracerMode
        ], null | VAPI.RTPReceiver.PacketTracerRun, VAPI.AT1101.RTPReceiver.PacketTracer>;
        get prev_run(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number | string,
            number | string,
            number,
            number,
            number,
            number,
            number,
            number,
            VAPI.RTPReceiver.PacketTracerRunPacketDetails,
            VAPI.RTPReceiver.PacketTracerMode
        ], null | VAPI.RTPReceiver.PacketTracerRun, VAPI.AT1101.RTPReceiver.PacketTracer>;
        get num_pending_downloads(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.NumDownloads, VAPI.AT1101.RTPReceiver.PacketTracer>;
    }
    class PassthroughEssence implements VScript.Referenceable<"RTPReceiver::Data::PassthroughEssence"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::PassthroughEssence";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.RTPReceiver.PassthroughEssence>;
        get stream_id(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.RTPReceiver.PacketStreamIndex, VAPI.AT1101.RTPReceiver.PassthroughEssence>;
        get memory_blocks(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            Array<null | number>
        ], null | VAPI.AT1101.RTPReceiver.PassthroughEssenceMemoryBlocks, VAPI.AT1101.RTPReceiver.PassthroughEssence>;
        get sdp(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.RTPReceiver.PassthroughEssence>;
    }
    class PassthroughFlowPartition implements VScript.Referenceable<"RTPReceiver::Data::PassthroughFlowPartition"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::PassthroughFlowPartition";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get id(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.PartitionID, VAPI.AT1101.RTPReceiver.PassthroughFlowPartition>;
        /**
          Network sources feeding this flow partition; if more than 8 sources feed
          into a single partition, surplus sources will not be published via the
          web interface
        */
        get sources(): VScript.rKeyword<VScript.VSocket, Array<[
            null | string,
            number
        ]>, Array<VAPI.AT1101.RTPReceiver.AffineNetworkSource>, VAPI.AT1101.RTPReceiver.PassthroughFlowPartition>;
    }
    class PassthroughReceiver implements VScript.Referenceable<"RTPReceiver::Data::PassthroughReceiver"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::PassthroughReceiver";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get tracks(): VScript.rKeyword<VScript.VSocket, [
            VAPI.RTPReceiver.TrackSet,
            VAPI.RTPReceiver.OrderedTrackSet,
            null | VAPI.RTPReceiver.Track,
            null | VAPI.RTPReceiver.Track,
            null | VAPI.RTPReceiver.Track,
            null | VAPI.RTPReceiver.Track
        ], VAPI.RTPReceiver.UsedReceiverTracks, VAPI.AT1101.RTPReceiver.PassthroughReceiver>;
        get hosting_session(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.RTPReceiver.Session, null | VScript.Referenceable<"RTPReceiver::Data::Session"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.RTPReceiver.PassthroughReceiver>;
        get ingress(): VScript.rKeyword<VScript.VSocket, [
            VAPI.RTPReceiver.IngressTrackState,
            VAPI.RTPReceiver.IngressTrackState
        ], VAPI.RTPReceiver.Ingress, VAPI.AT1101.RTPReceiver.PassthroughReceiver>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.PassthroughReceiverIssues, VAPI.AT1101.RTPReceiver.PassthroughReceiver>;
        get output(): PassthroughEssence;
        get reserved_buffer_id(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.RTPReceiver.BufferID, VAPI.AT1101.RTPReceiver.PassthroughReceiver>;
        /**
          Ideally, this keyword shouldn't exist. In practice however, capability
          requests are currently processed eagerly, s.t. the outcome of a
          capability allocation attempt may depend on the order in which individual
          receivers are serviced. To ensure full state recovery across reboots, we
          thus store this ordering explicitly
        */
        get capability_request(): VScript.rKeyword<VScript.VSocket, [
            null | number,
            null | number
        ], VAPI.RTPReceiver.CapabilityRequestIDs, VAPI.AT1101.RTPReceiver.PassthroughReceiver>;
        get flow_partitions(): VScript.rKeyword<VScript.VSocket, [
            null | string,
            null | string
        ], VAPI.AT1101.RTPReceiver.PassthroughReceiverFlowPartitions, VAPI.AT1101.RTPReceiver.PassthroughReceiver>;
    }
    class PassthroughReceiverAsNamedTableRow extends PassthroughReceiver {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    type RAMBlock = number;
    type RAMChannel = number;
    type RAMPseudoChannel = number;
    type ReadSpeed = ({
        variant: "LockToGenlock";
        value: VAPI.AT1101.RTPReceiver.ReadSpeedLockToGenlock;
    } | {
        variant: "Adaptive";
        value: VAPI.RTPReceiver.ReadSpeedAdaptive;
    });
    interface ReserveAudioBackend {
        group: VAPI.RTPReceiver.AudioBlockIndex;
        instance: VAPI.RTPReceiver.AudioInstanceIndex;
        slices: Array<null | VAPI.RTPReceiver.LocalSliceIndex>;
        channel: VAPI.AT1101.RTPReceiver.RAMChannel;
        fence: null | VAPI.Time.FreeRunningCounter;
    }
    class Session implements VScript.Referenceable<"RTPReceiver::Data::Session"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::Session";
        set_sdp(track: VAPI.RTPReceiver.Track, sdp: string | null, pars?: {
            timeout?: VScript.Duration;
            retry_interval?: VScript.Duration;
        }): Promise<void>;
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          A session only supports clean switching if all of its media receivers do
          (see
          `{audio,video}_receivers[*].media_specific.capabilities.supports_clean_switching`)
        */
        get supports_clean_switching(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.RTPReceiver.Session>;
        get switch_type(): VScript.dKeyword<VScript.VSocket, ([0, []] | [
            1,
            [number | string]
        ] | [
            2,
            [number | string]
        ]), ([0, []] | [
            1,
            [number | string]
        ] | [
            2,
            [number | string]
        ]), VAPI.RTPReceiver.SwitchType, VAPI.RTPReceiver.SwitchType, VAPI.AT1101.RTPReceiver.Session>;
        get video_receivers(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1101.RTPReceiver.VideoReceiver>, VAPI.AT1101.RTPReceiver.Session>;
        get audio_receivers(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1101.RTPReceiver.AudioReceiver>, VAPI.AT1101.RTPReceiver.Session>;
        get anc_burst_receivers(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1101.RTPReceiver.AncBurstReceiver>, VAPI.AT1101.RTPReceiver.Session>;
        get passthrough_receivers(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1101.RTPReceiver.PassthroughReceiver>, VAPI.AT1101.RTPReceiver.Session>;
        get active(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.RTPReceiver.Session>;
        get sdp_a(): VScript.dKeyword<VScript.VSocket, string, string, string, string, VAPI.AT1101.RTPReceiver.Session>;
        get sdp_b(): VScript.dKeyword<VScript.VSocket, string, string, string, string, VAPI.AT1101.RTPReceiver.Session>;
        get interfaces(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | string
        ], [
            null | string,
            null | string
        ], VAPI.RTPReceiver.SessionInterfaces, VAPI.RTPReceiver.SessionInterfaces, VAPI.AT1101.RTPReceiver.Session>;
        get used_tracks(): VScript.rKeyword<VScript.VSocket, [
            VAPI.RTPReceiver.TrackSet,
            VAPI.RTPReceiver.TrackSet,
            VAPI.RTPReceiver.TrackSet,
            VAPI.RTPReceiver.TrackSet
        ], VAPI.RTPReceiver.UsedSessionTracks, VAPI.AT1101.RTPReceiver.Session>;
        get last_accepted_track(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.RTPReceiver.Track,
            number,
            number,
            Array<number>
        ], null | VAPI.RTPReceiver.SessionLastAcceptedTrack, VAPI.AT1101.RTPReceiver.Session>;
        get event_counters(): VAPI.RTPReceiver.SessionEventCounters;
        get version_window(): VAPI.RTPReceiver.SessionVersionWindow;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.SessionIssues, VAPI.AT1101.RTPReceiver.Session>;
    }
    class SessionAsNamedTableRow extends Session {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    interface TimingTargetTimeSource {
        t_src: null | VAPI.AT1101.Time.Source;
        use_rtp_timestamp: boolean;
    }
    class Timing implements VScript.Referenceable<"RTPReceiver::Data::Timing"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::Timing";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          If possible, maintain at least this much distance from both buffer ends.
          Note that JPEG XS receivers will always enforce a safety margin of at
          least 4ms.
        */
        get safety_margin(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.RTPReceiver.Timing>;
        /**
          Capacity of the receive buffer, as dictated by buffer settings, packet
          rates and limitations of the statistics engine
        */
        get buffer_capacity(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1101.RTPReceiver.Timing>;
        get target(): VScript.dKeyword<VScript.VSocket, ([0, [number]] | [
            1,
            [number]
        ] | [
            2,
            [
                null | string,
                boolean
            ]
        ] | [
            3,
            []
        ] | [
            4,
            [
                null | string,
                number,
                VAPI.RTPReceiver.BackpressurePolicy
            ]
        ] | [
            5,
            [
                null | string,
                number,
                VAPI.RTPReceiver.BackpressurePolicy
            ]
        ]), ([0, [number]] | [
            1,
            [number]
        ] | [
            2,
            [
                null | string,
                boolean
            ]
        ] | [
            3,
            []
        ] | [
            4,
            [
                null | string,
                number,
                VAPI.RTPReceiver.BackpressurePolicy
            ]
        ] | [
            5,
            [
                null | string,
                number,
                VAPI.RTPReceiver.BackpressurePolicy
            ]
        ]), VAPI.AT1101.RTPReceiver.TimingTarget, VAPI.AT1101.RTPReceiver.TimingTarget, VAPI.AT1101.RTPReceiver.Timing>;
        /**
          estimated time until |distance to buffer boundary| < 0.5 *
          `safety_margin`
        */
        get expected_time_to_collision(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1101.RTPReceiver.Timing>;
        get read_delay(): VAPI.RTPReceiver.TimingReadDelay;
        get read_delay_bounds(): VScript.dKeyword<VScript.VSocket, [
            null | number,
            null | number
        ], [
            null | number,
            null | number
        ], VAPI.RTPReceiver.TimingReadDelayBounds, VAPI.RTPReceiver.TimingReadDelayBounds, VAPI.AT1101.RTPReceiver.Timing>;
        get current_phase(): VAPI.AT1101.Time.Source;
        get safety_mismatch(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1101.RTPReceiver.Timing>;
        get phase_control(): VAPI.RTPReceiver.TimingPhaseControl;
        /**
          delay readout of newly incoming streams until at least this many mpackets
          have been received. While this increases readout latency, this may also
          improve robustness if there is reason to believe that stream setup may
          sometimes be 'dirty' (e.g., with gaps within the first few received video
          frames)
        */
        get mpackets_warmup(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.Primitives.Unsigned32, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPReceiver.Timing>;
    }
    type TimingTarget = ({
        variant: "IngressPlusX";
        value: VAPI.RTPReceiver.TimingTargetIngressPlusX;
    } | {
        variant: "EgressPlusX";
        value: VAPI.RTPReceiver.TimingTargetEgressPlusX;
    } | {
        variant: "TimeSource";
        value: VAPI.AT1101.RTPReceiver.TimingTargetTimeSource;
    } | {
        variant: "BufferMidpoint";
        value: VAPI.RTPReceiver.TimingTargetBufferMidpoint;
    } | {
        variant: "ForeignReadDelay";
        value: VAPI.AT1101.RTPReceiver.TimingTargetForeignReadDelay;
    } | {
        variant: "ForeignMediaClock";
        value: VAPI.AT1101.RTPReceiver.TimingTargetForeignMediaClock;
    });
    interface VideoBackend {
        native: null | VAPI.AT1101.RTPReceiver.NativeVideoBackend;
        jpeg_xs: null | VAPI.AT1101.RTPReceiver.JpegXsVideoBackend;
        servo: null | VAPI.AT1101.RTPReceiver.VideoServo;
    }
    interface VideoCapabilities {
        supports_2022_6: boolean;
        supports_uhd_sample_interleaved: boolean;
        st2110_20_caliber: null | VAPI.RTPReceiver.VideoCapabilitiesSt211020Caliber;
        st2042_2_caliber: null | VAPI.RTPReceiver.VideoCapabilitiesSt20422Caliber;
        jpeg_xs_caliber: null | VAPI.RTPReceiver.VideoCapabilitiesJpegXsCaliber;
        supports_2110_40: boolean;
        supports_clean_switching: boolean;
        read_speed: VAPI.AT1101.RTPReceiver.ReadSpeed;
    }
    class VideoFlowPartition implements VScript.Referenceable<"RTPReceiver::Data::VideoFlowPartition"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::VideoFlowPartition";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get id(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.PartitionID, VAPI.AT1101.RTPReceiver.VideoFlowPartition>;
        get sdp_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1101.RTPReceiver.VideoFlowPartition>;
        get fmt_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1101.RTPReceiver.VideoFlowPartition>;
        get transport_format(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.TransportFormat, null | VAPI.Video.TransportFormat, VAPI.AT1101.RTPReceiver.VideoFlowPartition>;
        /**
          Network sources feeding this flow partition; if more than 8 sources feed
          into a single partition, surplus sources will not be published via the
          web interface
        */
        get sources(): VScript.rKeyword<VScript.VSocket, Array<[
            null | string,
            number
        ]>, Array<VAPI.AT1101.RTPReceiver.AffineNetworkSource>, VAPI.AT1101.RTPReceiver.VideoFlowPartition>;
    }
    class VideoReceiver implements VScript.Referenceable<"RTPReceiver::Data::VideoReceiver"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::VideoReceiver";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get generic(): MediaReceiver;
        get media_specific(): VideoReceiverMediaSpecific;
    }
    class VideoReceiverAsNamedTableRow extends VideoReceiver {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class VideoServo implements VScript.Referenceable<"RTPReceiver::Data::VideoServo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::VideoServo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get relative_speed(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.RTPReceiver.VideoServo>;
        get max_relative_speed(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.RTPReceiver.VideoServo>;
        get max_acceleration(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.RTPReceiver.VideoServo>;
        get dt_node(): VScript.rKeyword<VScript.VSocket, null | VScript.DeviceTreeNodePayload, null | VScript.DeviceTreeNodePayload, VAPI.AT1101.RTPReceiver.VideoServo>;
    }
    class AllDiagnostics implements VScript.Referenceable<"RTPReceiver::Data::All::Diagnostics"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::All::Diagnostics";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          Clear traffic statistics
        */
        get clear_traffic_stats(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.RTPReceiver.AllDiagnostics>;
        /**
          Clear input stage statistics
        */
        get clear_input_statistics(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.RTPReceiver.AllDiagnostics>;
        get aggregate_traffic_stats(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter, VAPI.AT1101.RTPReceiver.AllDiagnostics>;
        /**
          if RAM calibration failed and rebooting does not fix the issue, please
          contact customer support
        */
        get ram_calibration(): VScript.rKeyword<VScript.VSocket, VAPI.AT1101.RTPReceiver.AllDiagnosticsRamCalibration, VAPI.AT1101.RTPReceiver.AllDiagnosticsRamCalibration, VAPI.AT1101.RTPReceiver.AllDiagnostics>;
        get memory_statistics(): VAPI.Memory.ECCMuxStatistics;
        get rtp_input(): VScript.rKeyword<VScript.VSocket, Array<null | [
            Array<number>,
            number,
            number,
            number,
            number,
            number
        ]>, Array<null | VAPI.AT1101.RTPReceiver.AllDiagnosticsRtpInput>, VAPI.AT1101.RTPReceiver.AllDiagnostics>;
        get mpacket_tracer(): VAPI.RTPReceiver.AllDiagnosticsMpacketTracer;
        get packet_tracers(): VScript.StronglyTypedArray<VScript.VSocket, "RTPReceiver::Data::PacketTracer", PacketTracer>;
        get igmp_performance_metrics(): AllDiagnosticsIgmpPerformanceMetrics;
        /**
          Enable this option to have the receiver log every readout attempt to
          syslog. Potentially useful for debugging but very verbose, so you'll
          probably want to keep this disabled in production.
        */
        get log_readout_requests(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.RTPReceiver.AllDiagnostics>;
        /**
          Enable this option to have the receiver log every IGMP join/leave request
          to syslog. Potentially useful for debugging but very verbose, so you'll
          probably want to keep this disabled in production.
        */
        get log_igmp_requests(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.RTPReceiver.AllDiagnostics>;
    }
    interface PassthroughReceiverFlowPartitions {
        sdp_a: null | VAPI.AT1101.RTPReceiver.PassthroughFlowPartition;
        sdp_b: null | VAPI.AT1101.RTPReceiver.PassthroughFlowPartition;
    }
    interface AudioReceiverMediaSpecificFlowPartitions {
        sdp_a: null | VAPI.AT1101.RTPReceiver.AudioFlowPartition;
        sdp_b: null | VAPI.AT1101.RTPReceiver.AudioFlowPartition;
    }
    interface VideoReceiverMediaSpecificFlowPartitions {
        sdp_a: null | VAPI.AT1101.RTPReceiver.VideoFlowPartition;
        sdp_b: null | VAPI.AT1101.RTPReceiver.VideoFlowPartition;
    }
    interface AllDiagnosticsIgmpPerformanceMetricsIgmpLatency {
        port: null | VAPI.AT1101.Primitives.NetworkPortID;
        src: null | string;
        dst: null | string;
        time_to_first_mpacket: null | VScript.Duration;
        first_rtp_timestamp: null | VAPI.Time.RTPTimestamp;
        first_rtp_seqnr: null | VAPI.RTPReceiver.Seqnr;
        /**
          time between two m-packets. This defines the latency measurement's
          uncertainty and depends on video standards, transport formats and (for
          audio streams) on the currently configured IRQ rate
        */
        mpacket_interval: null | VScript.Duration;
    }
    class AllDiagnosticsIgmpPerformanceMetrics implements VScript.Referenceable<"RTPReceiver::Data::All::Diagnostics::IgmpPerformanceMetrics"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::All::Diagnostics::IgmpPerformanceMetrics";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          emit warning message if the time elapsed between an outgoing IGMP join
          request and the arrival of the first corresponding packet (estimated
          conservatively as `time_to_first_mpacket - mpacket_interval`) exceeds
          `warning_threshold`. Note that for interlaced 2110/2042 streams,
          upper-field mpackets are not considered.
        */
        get warning_threshold(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.RTPReceiver.AllDiagnosticsIgmpPerformanceMetrics>;
        get igmp_latency(): VScript.rKeyword<VScript.VSocket, [
            null | VAPI.AT1101.Primitives.NetworkPortID,
            null | string,
            null | string,
            null | number,
            null | number,
            null | number,
            null | number
        ], VAPI.AT1101.RTPReceiver.AllDiagnosticsIgmpPerformanceMetricsIgmpLatency, VAPI.AT1101.RTPReceiver.AllDiagnosticsIgmpPerformanceMetrics>;
    }
    class AncBurstReceiverMediaClock implements VScript.Referenceable<"RTPReceiver::Data::AncBurstReceiver::MediaClock"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::AncBurstReceiver::MediaClock";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get ingress(): VAPI.AT1101.Time.Source;
        get egress(): VAPI.AT1101.Time.Source;
    }
    class AudioReceiverMediaSpecific implements VScript.Referenceable<"RTPReceiver::Data::AudioReceiver::MediaSpecific"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::AudioReceiver::MediaSpecific";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get capabilities(): VScript.dKeyword<VScript.VSocket, null | [
            number,
            boolean,
            ([0, []] | [
                1,
                []
            ])
        ], null | [
            number,
            boolean,
            ([0, []] | [
                1,
                []
            ])
        ], null | VAPI.AT1101.RTPReceiver.AudioCapabilities, null | VAPI.AT1101.RTPReceiver.AudioCapabilities, VAPI.AT1101.RTPReceiver.AudioReceiverMediaSpecific>;
        get backend(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number,
            null | string,
            Array<null | number>,
            number
        ], null | VAPI.AT1101.RTPReceiver.AudioBackend, VAPI.AT1101.RTPReceiver.AudioReceiverMediaSpecific>;
        get flow_partitions(): VScript.rKeyword<VScript.VSocket, [
            null | string,
            null | string
        ], VAPI.AT1101.RTPReceiver.AudioReceiverMediaSpecificFlowPartitions, VAPI.AT1101.RTPReceiver.AudioReceiverMediaSpecific>;
        get output(): AudioReceiverMediaSpecificOutput;
    }
    class VideoReceiverMediaSpecific implements VScript.Referenceable<"RTPReceiver::Data::VideoReceiver::MediaSpecific"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::VideoReceiver::MediaSpecific";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get capabilities(): VScript.dKeyword<VScript.VSocket, null | [
            boolean,
            boolean,
            null | VAPI.RTPReceiver.VideoCapabilitiesSt211020Caliber,
            null | VAPI.RTPReceiver.VideoCapabilitiesSt20422Caliber,
            null | VAPI.RTPReceiver.VideoCapabilitiesJpegXsCaliber,
            boolean,
            boolean,
            ([0, []] | [
                1,
                []
            ])
        ], null | [
            boolean,
            boolean,
            null | VAPI.RTPReceiver.VideoCapabilitiesSt211020Caliber,
            null | VAPI.RTPReceiver.VideoCapabilitiesSt20422Caliber,
            null | VAPI.RTPReceiver.VideoCapabilitiesJpegXsCaliber,
            boolean,
            boolean,
            ([0, []] | [
                1,
                []
            ])
        ], null | VAPI.AT1101.RTPReceiver.VideoCapabilities, null | VAPI.AT1101.RTPReceiver.VideoCapabilities, VAPI.AT1101.RTPReceiver.VideoReceiverMediaSpecific>;
        get backend(): VScript.rKeyword<VScript.VSocket, null | [
            null | [
                number,
                Array<null | number>,
                number,
                null | [
                    number,
                    number,
                    [
                        number,
                        number
                    ],
                    number,
                    number
                ]
            ],
            null | [
                number,
                Array<null | number>,
                number,
                null | [
                    number,
                    number,
                    [
                        number,
                        number
                    ],
                    number,
                    number
                ]
            ],
            null | string
        ], null | VAPI.AT1101.RTPReceiver.VideoBackend, VAPI.AT1101.RTPReceiver.VideoReceiverMediaSpecific>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPReceiver.VideoReceiverMediaSpecificIssues, VAPI.AT1101.RTPReceiver.VideoReceiverMediaSpecific>;
        get error_counters(): VAPI.RTPReceiver.VideoReceiverMediaSpecificErrorCounters;
        get event_counters(): VAPI.RTPReceiver.VideoReceiverMediaSpecificEventCounters;
        /**
          Reset 2022-6 audio deembedder
        */
        get reset_audio_deembedder(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.RTPReceiver.VideoReceiverMediaSpecific>;
        get flow_partitions(): VScript.rKeyword<VScript.VSocket, [
            null | string,
            null | string
        ], VAPI.AT1101.RTPReceiver.VideoReceiverMediaSpecificFlowPartitions, VAPI.AT1101.RTPReceiver.VideoReceiverMediaSpecific>;
        get output(): VideoReceiverMediaSpecificOutput;
        /**
          when this is set to true, a timestamped CRC32 signature of every emitted
          video frame will be published via `signature`
        */
        get publish_signature(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.RTPReceiver.VideoReceiverMediaSpecific>;
        get timestamped_signature(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            Array<number>
        ], null | VAPI.Video.TimestampedSignature, VAPI.AT1101.RTPReceiver.VideoReceiverMediaSpecific>;
        get hard_metadata_decoder(): VAPI.RTPReceiver.VideoReceiverMediaSpecificHardMetadataDecoder;
        get soft_metadata_decoder(): VAPI.RTPReceiver.VideoReceiverMediaSpecificSoftMetadataDecoder;
        get soft_metadata_extractor(): VScript.StronglyTypedTable<VScript.VSocket, "MetadataProcessor::Data::MetadataExtractor", VAPI.AT1101.MetadataProcessor.MetadataExtractor>;
        /**
          Single video substreams pertaining to a quadlink UHD flow may be
          subscribed to independently, and used as separate 3G streams instead. By
          default, the resulting 3G video essences will be stripped of their
          substream attributes, which affects SDPs generated on retransmission, as
          well as 352 payloads. If you wish to retain original substream
          attributes, set this setting to `PropagateSubstreamAttribute` (but note
          that this setting only takes effect on readout).
        */
        get on_isolated_substream(): VScript.dKeyword<VScript.VSocket, null | VAPI.RTPReceiver.OnIsolatedSubstream, null | VAPI.RTPReceiver.OnIsolatedSubstream, null | VAPI.RTPReceiver.OnIsolatedSubstream, null | VAPI.RTPReceiver.OnIsolatedSubstream, VAPI.AT1101.RTPReceiver.VideoReceiverMediaSpecific>;
        /**
          When non-null, this keyword holds decoder state as inferred from
          currently received streams, or as obtained from the underlying hardware
          decoder at runtime.
        */
        get cur_decoder_ws(): VScript.rKeyword<VScript.VSocket, null | ([0, []] | [
            1,
            [
                ([0, []] | [
                    1,
                    []
                ] | [
                    2,
                    [Array<number>]
                ]),
                number
            ]
        ]), null | VAPI.RTPReceiver.SingleVideoDecoderWorkingSet, VAPI.AT1101.RTPReceiver.VideoReceiverMediaSpecific>;
    }
    interface PassthroughEssenceMemoryBlocks {
        channel: VAPI.AT1101.RTPReceiver.RAMChannel;
        blocks: Array<null | VAPI.AT1101.RTPReceiver.RAMBlock>;
    }
    class AudioReceiverMediaSpecificOutput implements VScript.Referenceable<"RTPReceiver::Data::AudioReceiver::MediaSpecific::Output"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::AudioReceiver::MediaSpecific::Output";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get audio(): VAPI.AT1101.Audio.Essence;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class VideoReceiverMediaSpecificOutput implements VScript.Referenceable<"RTPReceiver::Data::VideoReceiver::MediaSpecific::Output"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::VideoReceiver::MediaSpecific::Output";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get cc_channel(): VScript.dKeyword<VScript.VSocket, null | VAPI.Video.ClosedCaptionChannel, null | VAPI.Video.ClosedCaptionChannel, null | VAPI.Video.ClosedCaptionChannel, null | VAPI.Video.ClosedCaptionChannel, VAPI.AT1101.RTPReceiver.VideoReceiverMediaSpecificOutput>;
        get video(): VAPI.AT1101.Video.Essence;
        get start_of_frame(): VAPI.AT1101.Time.Source;
        get cc(): VAPI.Video.ClosedCaption;
        get deembedded_audio(): VScript.StronglyTypedTable<VScript.VSocket, "Audio::Data::Essence", VAPI.AT1101.Audio.Essence>;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class MediaReceiverPacketStreams implements VScript.Referenceable<"RTPReceiver::Data::MediaReceiver::PacketStreams"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::MediaReceiver::PacketStreams";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          for every subflow index, the first entry to appear in this list
          represents its rear guard
        */
        get sdp_a(): VScript.rKeyword<VScript.VSocket, Array<[
            null | string,
            number,
            null | [
                number,
                number,
                number,
                number
            ]
        ]>, Array<VAPI.AT1101.RTPReceiver.AssociatedStream>, VAPI.AT1101.RTPReceiver.MediaReceiverPacketStreams>;
        /**
          for every subflow index, the first entry to appear in this list
          represents its rear guard
        */
        get sdp_b(): VScript.rKeyword<VScript.VSocket, Array<[
            null | string,
            number,
            null | [
                number,
                number,
                number,
                number
            ]
        ]>, Array<VAPI.AT1101.RTPReceiver.AssociatedStream>, VAPI.AT1101.RTPReceiver.MediaReceiverPacketStreams>;
    }
    /**
      if RAM calibration failed and rebooting does not fix the issue, please
      contact customer support
    */
    type AllDiagnosticsRamCalibration = "Successful" | "Unknown" | "Failed";
    interface AllDiagnosticsRtpInput {
        input_oom: Array<VAPI.Primitives.SaturatingCounter32>;
        queue_full: VAPI.Primitives.SaturatingCounter32;
        lowest_memfree: number;
        memfree: number;
        highest_fifo_usedw: number;
        fifo_usedw: number;
    }
    class AllSettings implements VScript.Referenceable<"RTPReceiver::Data::All::Settings"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPReceiver::Data::All::Settings";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          if `clean_switching_policy` is set to `Tolerant`, packet rates and ST2042
          compression ratios may change across switching boundaries. This ensures
          interoperability between a wider range of transmitters but comes at a
          slight performance penalty, as the receiver first has to determine the
          current packet rate before a switch can be effected. When set to
          `Whatever`, impossible clean switching requests will silently be
          converted into patching operations. Please only use this option as a
          measure of last resort, if at all.
        */
        get clean_switching_policy(): VScript.rwKeyword<VScript.VSocket, VAPI.RTPReceiver.CleanSwitchingPolicy, VAPI.RTPReceiver.CleanSwitchingPolicy, VAPI.RTPReceiver.CleanSwitchingPolicy, VAPI.RTPReceiver.CleanSwitchingPolicy, VAPI.AT1101.RTPReceiver.AllSettings>;
        /**
          limits IGMP stream subscriptions such that there remains an esimated
          `reserved_bandwidth` % of headroom on every RTP port (non-media traffic
          such as PTP or JSON/WS is not taken into account)
        */
        get reserved_bandwidth(): VScript.rwKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.AT1101.RTPReceiver.AllSettings>;
        get max_concurrent_mpacket_irq_boosts(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.Primitives.Unsigned16, VAPI.Primitives.Unsigned16, VAPI.AT1101.RTPReceiver.AllSettings>;
        get concurrent_mpacket_irq_boosts(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned16, VAPI.AT1101.RTPReceiver.AllSettings>;
        /**
          set this to modern to have generated 2042-raw/2022-6 streams state their
          respective rtp clock rates
        */
        get sdp_format(): VScript.rwKeyword<VScript.VSocket, VAPI.SDP.SDPFormat, VAPI.SDP.SDPFormat, VAPI.SDP.SDPFormat, VAPI.SDP.SDPFormat, VAPI.AT1101.RTPReceiver.AllSettings>;
        /**
          determines how SDP files entered into `sdp_a_command` or `sdp_b_command`
          translate into their respective `status` counterparts. If
          `sdp_generation` is set to `Verbatim`, accepted SDP files are copied to
          `status` unmodified, even if some or all of the media descriptions within
          could not be serviced due to resource exhaustion. If `sdp_generation` is
          set to `Semantic`, only operationally effective parts of the SDP will be
          emitted.
        */
        get sdp_generation(): VScript.rwKeyword<VScript.VSocket, VAPI.RTPReceiver.AllSettingsSdpGeneration, VAPI.RTPReceiver.AllSettingsSdpGeneration, VAPI.RTPReceiver.AllSettingsSdpGeneration, VAPI.RTPReceiver.AllSettingsSdpGeneration, VAPI.AT1101.RTPReceiver.AllSettings>;
        get num_audio_reserve_receivers(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.RTPReceiver.AllSettings>;
        get rx_error(): VAPI.RTPReceiver.CountableErrorHandler;
        get mpacket_error(): VAPI.RTPReceiver.CountableErrorHandler;
        get offset_2110_error(): VAPI.RTPReceiver.CountableErrorHandler;
        get linenr_2110_error(): VAPI.RTPReceiver.CountableErrorHandler;
        /**
          time after which countable error events (such as RX errors or m-packet
          errors) are automatically cleared. Error accumulators are left unchanged
          until cleared explicitly by the user
        */
        get error_signalling_timeout(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.RTPReceiver.AllSettings>;
        /**
          TODO
        */
        get flight_permit_timeout(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.RTPReceiver.AllSettings>;
        /**
          when in clean-switching mode (i.e., if `switch_time` is neither 0 nor 1),
          SDP writes to `current_target` are rejected, followed by an informational
          error message. Set `on_sdp_collision` to `RejectSilently` to suppress
          this error message.
        */
        get on_sdp_collision(): VScript.rwKeyword<VScript.VSocket, VAPI.RTPReceiver.AllSettingsOnSdpCollision, VAPI.RTPReceiver.AllSettingsOnSdpCollision, VAPI.RTPReceiver.AllSettingsOnSdpCollision, VAPI.RTPReceiver.AllSettingsOnSdpCollision, VAPI.AT1101.RTPReceiver.AllSettings>;
        /**
          some configuration attempts cannot be executed completely. For example, a
          session containing 3 audio receivers will not be able to service a
          connection request if the corresponding SDP contains 4 or more audio
          essences. In these cases, the receiver may either set up as many
          connections as possible and discard the rest (`BestEffort`), or refuse
          the configuration attempt and raise an error message instead (`Refuse`).
        */
        get exhaustion_policy(): VScript.rwKeyword<VScript.VSocket, VAPI.RTPReceiver.ResourceExhaustionPolicy, VAPI.RTPReceiver.ResourceExhaustionPolicy, VAPI.RTPReceiver.ResourceExhaustionPolicy, VAPI.RTPReceiver.ResourceExhaustionPolicy, VAPI.AT1101.RTPReceiver.AllSettings>;
        get backend_liveness(): VAPI.RTPReceiver.CountableErrorHandler;
        get premature_read(): VAPI.RTPReceiver.CountableErrorHandler;
        /**
          Single video substreams pertaining to a quadlink UHD flow may be
          subscribed to independently, and used as separate 3G streams instead. By
          default, the resulting 3G video essences will be stripped of their
          substream attributes, which affects SDPs generated on retransmission, as
          well as 352 payloads. If you wish to retain original substream
          attributes, set this setting to `PropagateSubstreamAttribute` (but note
          that this setting only takes effect on readout).
        */
        get on_isolated_substream(): VScript.dKeyword<VScript.VSocket, VAPI.RTPReceiver.OnIsolatedSubstream, VAPI.RTPReceiver.OnIsolatedSubstream, VAPI.RTPReceiver.OnIsolatedSubstream, VAPI.RTPReceiver.OnIsolatedSubstream, VAPI.AT1101.RTPReceiver.AllSettings>;
        get buffer_sizes(): VScript.dKeyword<VScript.VSocket, [
            VAPI.AT1101.RTPReceiver.BufferSize,
            VAPI.AT1101.RTPReceiver.BufferSize,
            VAPI.AT1101.RTPReceiver.BufferSize,
            VAPI.AT1101.RTPReceiver.BufferSize,
            VAPI.AT1101.RTPReceiver.BufferSize,
            VAPI.AT1101.RTPReceiver.BufferSize,
            VAPI.AT1101.RTPReceiver.BufferSize
        ], [
            VAPI.AT1101.RTPReceiver.BufferSize,
            VAPI.AT1101.RTPReceiver.BufferSize,
            VAPI.AT1101.RTPReceiver.BufferSize,
            VAPI.AT1101.RTPReceiver.BufferSize,
            VAPI.AT1101.RTPReceiver.BufferSize,
            VAPI.AT1101.RTPReceiver.BufferSize,
            VAPI.AT1101.RTPReceiver.BufferSize
        ], VAPI.AT1101.RTPReceiver.BufferSizes, VAPI.AT1101.RTPReceiver.BufferSizes, VAPI.AT1101.RTPReceiver.AllSettings>;
    }
    const Enums: {
        readonly BufferSize: BufferSize[];
    };
}
export declare namespace RTPTransmitter {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly AudioEncoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioEncoder;
        readonly AudioEncoderStatus: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioEncoderStatus;
        readonly AudioFlowReference: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioFlowReference;
        readonly AudioStreamHardware: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioStreamHardware;
        readonly AudioStreamer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioStreamer;
        readonly EncoderHWDataEncoderClassic: (_raw: [boolean, boolean, boolean, boolean, boolean, boolean, number, number, number, number, number, number], _socket: VScript.VSocket) => EncoderHWDataEncoderClassic;
        readonly EncoderHWData: (_raw: ([0, [boolean, boolean, boolean, boolean, boolean, boolean, number, number, number, number, number, number]] | [1, [boolean, boolean, boolean, number, number]] | [2, [null | number, null | number, null | VAPI.RTPTransmitter.ColorSampleMode, null | number, null | VAPI.RTPTransmitter.ValidateMode, null | number, null | VAPI.RTPTransmitter.VideoDepth, null | boolean, null | Array<number>, null | number]]), _socket: VScript.VSocket) => EncoderHWData;
        readonly EncoderHWDataEncoderJxsCodec: (_raw: [null | number, null | number, null | VAPI.RTPTransmitter.ColorSampleMode, null | number, null | VAPI.RTPTransmitter.ValidateMode, null | number, null | VAPI.RTPTransmitter.VideoDepth, null | boolean, null | Array<number>, null | number], _socket: VScript.VSocket) => EncoderHWDataEncoderJxsCodec;
        readonly EncoderHWDataEncoderVC2: (_raw: [boolean, boolean, boolean, number, number], _socket: VScript.VSocket) => EncoderHWDataEncoderVC2;
        readonly FlowReference: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => FlowReference;
        readonly GroupOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => GroupOutput;
        readonly HDRAudio: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HDRAudio;
        readonly HDRGeneral: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HDRGeneral;
        readonly HDRMipmap: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HDRMipmap;
        readonly HDRVideo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HDRVideo;
        readonly HardwareStatus: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HardwareStatus;
        readonly HeaderReference: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => HeaderReference;
        readonly LaneHeader: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => LaneHeader;
        readonly LaneStatistic: (_raw: [number, number, number, number, null | string], _socket: VScript.VSocket) => LaneStatistic;
        readonly MediaClock: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MediaClock;
        readonly MediaClockControl: (_raw: ([0, [null | string]] | [1, []]), _socket: VScript.VSocket) => MediaClockControl;
        readonly MediaStreamer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MediaStreamer;
        readonly MediaStreamerVideo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MediaStreamerVideo;
        readonly MipMapOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MipMapOutput;
        readonly MipMapStreamHardware: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MipMapStreamHardware;
        readonly MipMapStreamer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MipMapStreamer;
        readonly PortStatistic: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PortStatistic;
        readonly ReStreamer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => ReStreamer;
        readonly RouterEncoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RouterEncoder;
        readonly RouterOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RouterOutput;
        readonly ST2110Settings: (_raw: [VAPI.RTPTransmitter.PackingMode, boolean], _socket: VScript.VSocket) => ST2110Settings;
        readonly Session: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Session;
        readonly MediaClockControlTimesource: (_raw: [null | string], _socket: VScript.VSocket) => MediaClockControlTimesource;
        readonly VideoConfigurationContainer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoConfigurationContainer;
        readonly VideoFormat: (_raw: ([0, []] | [1, [VAPI.RTPTransmitter.PackingMode, boolean]] | [2, [VAPI.Video.DiracCompression, boolean]] | [3, [([0, [number]] | [1, [number]]), VAPI.RTPTransmitter.LVLMODE, boolean, boolean]]), _socket: VScript.VSocket) => VideoFormat;
        readonly VideoStreamHardware: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoStreamHardware;
        readonly VideoStreamer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoStreamer;
        readonly XbarEncoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => XbarEncoder;
        readonly AudioStreamHardwareAudioEncoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioStreamHardwareAudioEncoder;
        readonly AudioEncoderError: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AudioEncoderError;
        readonly RouterEncoderError: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RouterEncoderError;
        readonly RouterOutputError: (_raw: [number, number], _socket: VScript.VSocket) => RouterOutputError;
        readonly GroupOutputHwCapability: (_raw: [number], _socket: VScript.VSocket) => GroupOutputHwCapability;
        readonly MipMapOutputHwCapability: (_raw: [number], _socket: VScript.VSocket) => MipMapOutputHwCapability;
        readonly RouterOutputHwCapability: (_raw: [number], _socket: VScript.VSocket) => RouterOutputHwCapability;
        readonly PortStatisticInterfaces: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PortStatisticInterfaces;
        readonly PortStatisticLane: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PortStatisticLane;
        readonly MipMapStreamHardwareRouterEncoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MipMapStreamHardwareRouterEncoder;
        readonly VideoStreamHardwareRouterEncoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoStreamHardwareRouterEncoder;
        readonly VideoStreamHardwareXbarEncoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VideoStreamHardwareXbarEncoder;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly AudioEncoder: (_x: AudioEncoder) => string;
        readonly AudioEncoderStatus: (_x: AudioEncoderStatus) => string;
        readonly AudioFlowReference: (_x: AudioFlowReference) => string;
        readonly AudioStreamHardware: (_x: AudioStreamHardware) => string;
        readonly AudioStreamer: (_x: AudioStreamer) => string;
        readonly EncoderHWDataEncoderClassic: (_x: {
            tr: boolean;
            interlace: boolean;
            line_skip: boolean;
            bpm_mode: boolean;
            /**
              40  bit encoder
            */
            bits: boolean;
            enabled: boolean;
            /**
              Lines after end of active video to update the RTP
              timestamp (TR-03 mode only)
            */
            out_ts_target: VAPI.Primitives.Unsigned32;
            /**
              Lines after end of active video to update the RTP
              timestamp (TR-03 mode only)
            */
            mpkt_wordcounter: VAPI.Primitives.Unsigned32;
            vtotal: VAPI.Primitives.Unsigned32;
            vstart: VAPI.Primitives.Unsigned32;
            hactive: VAPI.Primitives.Unsigned32;
            sts_select: VAPI.Primitives.Unsigned32;
        }, _socket: VScript.VSocket) => [boolean, boolean, boolean, boolean, boolean, boolean, number, number, number, number, number, number];
        readonly EncoderHWData: (_x: ({
            variant: "EncoderClassic";
            value: VAPI.AT1101.RTPTransmitter.EncoderHWDataEncoderClassic;
        } | {
            variant: "EncoderVC2";
            value: VAPI.AT1101.RTPTransmitter.EncoderHWDataEncoderVC2;
        } | {
            variant: "EncoderJxsCodec";
            value: VAPI.AT1101.RTPTransmitter.EncoderHWDataEncoderJxsCodec;
        }), _socket: VScript.VSocket) => ([0, [boolean, boolean, boolean, boolean, boolean, boolean, number, number, number, number, number, number]] | [1, [boolean, boolean, boolean, number, number]] | [2, [null | number, null | number, null | VAPI.RTPTransmitter.ColorSampleMode, null | number, null | VAPI.RTPTransmitter.ValidateMode, null | number, null | VAPI.RTPTransmitter.VideoDepth, null | boolean, null | Array<number>, null | number]]);
        readonly EncoderHWDataEncoderJxsCodec: (_x: {
            /**
              Width of the input encoded image, in pixels. Must be a
              multiple of 2. Up to 4096 for UHD IP-core flavor
            */
            width: null | VAPI.Primitives.Unsigned32;
            /**
              Height of the input encoded image, in pixels. Must be a
              multiple of 2, and greater than or equal to 4
            */
            height: null | VAPI.Primitives.Unsigned32;
            /**
              Contains input mode configuration fields: bit 3-0: color
              and sub-sampling mode
            */
            mode: null | VAPI.RTPTransmitter.ColorSampleMode;
            /**
              Budget in bytes per compressed frame, which is allocated
              to the picture header and the compressed data. Note: To
              compute this value according to a bit per pixel rate:
              budget = bpp x width x height / 8 Complementary header
              (ie. boxes) is not included in the budget
            */
            budget_per_frame: null | VAPI.Primitives.Unsigned32;
            /**
              VALIDATE It validates the given configuration. Set to '1'
              to start the IP-core, after setting mode and images
              parameters. This signal must be activated to validate any
              change in configuration (width, height, ...). Set to '0'
              to stop the IP-core. bit 1: (R) CFG_READY ‘1’
              indicates that the TICO-XS is ready to receive a new
              configuration, when this bit is ‘0’ configuration
              registers shouldn't be modified
            */
            vld: null | VAPI.RTPTransmitter.ValidateMode;
            /**
              Number of images to play when the IP-core is in command
              mode. (when PLAY_MODE register = 0)
            */
            number_of_images: null | VAPI.Primitives.Unsigned32;
            /**
              Bit depth of the video content, mapped on the MSBs of the
              port interface. The valid bit depths are 8, 10 and 12
              bits per component
            */
            video_depth: null | VAPI.RTPTransmitter.VideoDepth;
            /**
              It allows to choose between two running modes: set to '1'
              to run in play mode, in which the IP-core processes
              frames continuously. or set to '0' to run in command
              mode, in which the IP-core processes n frames, n defined
              by NBR
            */
            play_mode: null | boolean;
            /**
              This register is used to program the image quality
              optimization parameters (visual or PSNR). Each
              pre-computed weights value must be written to this
              register sequentially to ensure proper encoder behavior.
            */
            level_weights: null | Array<VAPI.Primitives.Unsigned32>;
            profile: null | VAPI.Primitives.Unsigned32;
        }, _socket: VScript.VSocket) => [null | number, null | number, null | VAPI.RTPTransmitter.ColorSampleMode, null | number, null | VAPI.RTPTransmitter.ValidateMode, null | number, null | VAPI.RTPTransmitter.VideoDepth, null | boolean, null | Array<number>, null | number];
        readonly EncoderHWDataEncoderVC2: (_x: {
            interlace: boolean;
            enabled: boolean;
            is_uhd: boolean;
            target_bytes_per_slice: VAPI.Primitives.Unsigned32;
            last_slice: VAPI.Primitives.Unsigned32;
        }, _socket: VScript.VSocket) => [boolean, boolean, boolean, number, number];
        readonly FlowReference: (_x: FlowReference) => string;
        readonly GroupOutput: (_x: GroupOutput) => string;
        readonly HDRAudio: (_x: HDRAudio) => string;
        readonly HDRGeneral: (_x: HDRGeneral) => string;
        readonly HDRMipmap: (_x: HDRMipmap) => string;
        readonly HDRVideo: (_x: HDRVideo) => string;
        readonly HardwareStatus: (_x: HardwareStatus) => string;
        readonly HeaderReference: (_x: HeaderReference) => string;
        readonly LaneHeader: (_x: LaneHeader) => string;
        readonly LaneStatistic: (_x: {
            /**
              maximum throughput, measured in
              bits/second
            */
            reserved_tdm_output_bandwidth: VAPI.Primitives.NetworkBandwidth;
            /**
              maximum throughput, measured in
              bits/second
            */
            max_tdm_output_bandwidth: VAPI.Primitives.NetworkBandwidth;
            /**
              maximum throughput, measured in
              bits/second
            */
            reserved_bus_bandwidth: VAPI.Primitives.NetworkBandwidth;
            /**
              maximum throughput, measured in
              bits/second
            */
            maxbus_bandwidth: VAPI.Primitives.NetworkBandwidth;
            fpga_lane_statistic: null | VAPI.AT1101.NetworkInterfaces.LaneStatistics;
        }, _socket: VScript.VSocket) => [number, number, number, number, null | string];
        readonly MediaClock: (_x: MediaClock) => string;
        readonly MediaClockControl: (_x: ({
            variant: "Timesource";
            value: VAPI.AT1101.RTPTransmitter.MediaClockControlTimesource;
        } | {
            variant: "Propagate";
            value: VAPI.RTPTransmitter.MediaClockControlPropagate;
        }), _socket: VScript.VSocket) => ([0, [null | string]] | [1, []]);
        readonly MediaStreamer: (_x: MediaStreamer) => string;
        readonly MediaStreamerVideo: (_x: MediaStreamerVideo) => string;
        readonly MipMapOutput: (_x: MipMapOutput) => string;
        readonly MipMapStreamHardware: (_x: MipMapStreamHardware) => string;
        readonly MipMapStreamer: (_x: MipMapStreamer) => string;
        readonly PortStatistic: (_x: PortStatistic) => string;
        readonly ReStreamer: (_x: ReStreamer) => string;
        readonly RouterEncoder: (_x: RouterEncoder) => string;
        readonly RouterOutput: (_x: RouterOutput) => string;
        readonly ST2110Settings: (_x: {
            packing_mode: VAPI.RTPTransmitter.PackingMode;
            add_st2110_40: boolean;
        }, _socket: VScript.VSocket) => [VAPI.RTPTransmitter.PackingMode, boolean];
        readonly Session: (_x: Session) => string;
        readonly MediaClockControlTimesource: (_x: {
            t_src: null | VAPI.AT1101.Time.Source;
        }, _socket: VScript.VSocket) => [null | string];
        readonly VideoConfigurationContainer: (_x: VideoConfigurationContainer) => string;
        readonly VideoFormat: (_x: ({
            variant: "ST2022_6";
            value: VAPI.RTPTransmitter.ST20226Settings;
        } | {
            variant: "ST2110_20";
            value: VAPI.AT1101.RTPTransmitter.ST2110Settings;
        } | {
            variant: "ST2042";
            value: VAPI.RTPTransmitter.ST2042Settings;
        } | {
            variant: "JPEG_XS";
            value: VAPI.RTPTransmitter.JpegXsSettings;
        }), _socket: VScript.VSocket) => ([0, []] | [1, [VAPI.RTPTransmitter.PackingMode, boolean]] | [2, [VAPI.Video.DiracCompression, boolean]] | [3, [([0, [number]] | [1, [number]]), VAPI.RTPTransmitter.LVLMODE, boolean, boolean]]);
        readonly VideoStreamHardware: (_x: VideoStreamHardware) => string;
        readonly VideoStreamer: (_x: VideoStreamer) => string;
        readonly XbarEncoder: (_x: XbarEncoder) => string;
        readonly AudioStreamHardwareAudioEncoder: (_x: AudioStreamHardwareAudioEncoder) => string;
        readonly AudioEncoderError: (_x: AudioEncoderError) => string;
        readonly RouterEncoderError: (_x: RouterEncoderError) => string;
        readonly RouterOutputError: (_x: {
            queue_overflow: VAPI.Primitives.Unsigned32;
            queue_full: VAPI.Primitives.Unsigned32;
        }, _socket: VScript.VSocket) => [number, number];
        readonly GroupOutputHwCapability: (_x: {
            num_encoder: VAPI.Primitives.Unsigned32;
        }, _socket: VScript.VSocket) => [number];
        readonly MipMapOutputHwCapability: (_x: {
            num_encoder: VAPI.Primitives.Unsigned32;
        }, _socket: VScript.VSocket) => [number];
        readonly RouterOutputHwCapability: (_x: {
            num_encoder: VAPI.Primitives.Unsigned32;
        }, _socket: VScript.VSocket) => [number];
        readonly PortStatisticInterfaces: (_x: PortStatisticInterfaces) => string;
        readonly PortStatisticLane: (_x: PortStatisticLane) => string;
        readonly MipMapStreamHardwareRouterEncoder: (_x: MipMapStreamHardwareRouterEncoder) => string;
        readonly VideoStreamHardwareRouterEncoder: (_x: VideoStreamHardwareRouterEncoder) => string;
        readonly VideoStreamHardwareXbarEncoder: (_x: VideoStreamHardwareXbarEncoder) => string;
    };
    class All implements VScript.Referenceable<"RTPTransmitter::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::All";
        get runtime_constants(): {
            readonly num_mipmaptransmitters: number;
            readonly num_transmitter_video_lane: number;
            readonly has_2042_uhd: boolean;
            readonly num_hdr_flows: number;
            readonly num_xbar_encoder: number;
            readonly num_ports: number;
            readonly num_audio_group_control: number;
            readonly max_st2110_20_uhd_transmitters: number;
            readonly max_2042: number;
            readonly has_2042: boolean;
            readonly num_encoder_mux: number;
            readonly num_videotransmitters: number;
            readonly num_audiotransmitters: number;
            readonly max_2042_uhd: number;
            readonly num_jpegxs: number;
            readonly num_transmitter_mipmap_lane: number;
            readonly num_transmitter_audio_lane: number;
            readonly num_hdr_flows_port: number;
            readonly num_transmitters: number;
            readonly num_passthroughtransmitters: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get license_information(): VAPI.RTPTransmitter.AllLicenseInformation;
        get hardware_status(): HardwareStatus;
        get settings(): VAPI.RTPTransmitter.AllSettings;
        get sessions(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPTransmitter::Data::Session", SessionAsNamedTableRow>;
        get video_transmitters(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPTransmitter::Data::VideoStreamer", VideoStreamerAsNamedTableRow>;
        get audio_transmitters(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPTransmitter::Data::AudioStreamer", AudioStreamerAsNamedTableRow>;
        get passthrough_transmitters(): VScript.StronglyTypedNamedTable<VScript.VSocket, "RTPTransmitter::Data::ReStreamer", ReStreamerAsNamedTableRow>;
        get mipmap_transmitters(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::MipMapStreamer", MipMapStreamer>;
    }
    class AudioEncoder implements VScript.Referenceable<"RTPTransmitter::Data::AudioEncoder"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::AudioEncoder";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get allocated_blocks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPTransmitter.AudioEncoder>;
        get block_addr(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Primitives.Unsigned32>, VAPI.AT1101.RTPTransmitter.AudioEncoder>;
        get last_sample(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPTransmitter.AudioEncoder>;
        get write_disabled(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.RTPTransmitter.AudioEncoder>;
        get mode(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPTransmitter.AudioEncoder>;
        get header_fifo_select(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPTransmitter.AudioEncoder>;
        get sequence_number(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPTransmitter.AudioEncoder>;
        get error(): AudioEncoderError;
    }
    class AudioEncoderStatus implements VScript.Referenceable<"RTPTransmitter::Data::AudioEncoderStatus"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::AudioEncoderStatus";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          reference to router encoder hardware
        */
        get wrapped_reference_encoder(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.RTPTransmitter.HDRAudio, VAPI.AT1101.RTPTransmitter.AudioEncoderStatus>;
        /**
          reference to group control hardware
        */
        get wrapped_reference_group_control(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.RTPTransmitter.AudioGroupControl, VAPI.AT1101.RTPTransmitter.AudioEncoderStatus>;
    }
    class AudioFlowReference implements VScript.Referenceable<"RTPTransmitter::Data::AudioFlowReference"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::AudioFlowReference";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hdr_ref(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.RTPTransmitter.HDRAudio, VAPI.AT1101.RTPTransmitter.AudioFlowReference>;
        get hdr_index(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.RTPTransmitter.AudioFlowReference>;
        get hdr_port(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.RTPTransmitter.AudioFlowReference>;
    }
    class AudioStreamHardware implements VScript.Referenceable<"RTPTransmitter::Data::AudioStreamHardware"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::AudioStreamHardware";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get possible_sps_source(): VScript.rKeyword<VScript.VSocket, null | VAPI.RTPTransmitter.SPSMode, null | VAPI.RTPTransmitter.SPSMode, VAPI.AT1101.RTPTransmitter.AudioStreamHardware>;
        get group_control_status(): VAPI.RTPTransmitter.AudioGroupControlStatus;
        get audio_encoder(): AudioStreamHardwareAudioEncoder;
    }
    class AudioStreamer implements VScript.Referenceable<"RTPTransmitter::Data::AudioStreamer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::AudioStreamer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get generic(): MediaStreamer;
        get a_src(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | number | string
        ], [
            null | string,
            null | number | string
        ], VAPI.AT1101.Audio.TimedSource, VAPI.AT1101.Audio.TimedSource, VAPI.AT1101.RTPTransmitter.AudioStreamer>;
        get configuration(): VAPI.RTPTransmitter.AudioConfigurationContainer;
        get stream_name(): VAPI.Definitions.NAME;
        get connected_hardware(): AudioStreamHardware;
    }
    class AudioStreamerAsNamedTableRow extends AudioStreamer {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    interface EncoderHWDataEncoderClassic {
        tr: boolean;
        interlace: boolean;
        line_skip: boolean;
        bpm_mode: boolean;
        /**
          40  bit encoder
        */
        bits: boolean;
        enabled: boolean;
        /**
          Lines after end of active video to update the RTP timestamp (TR-03 mode
          only)
        */
        out_ts_target: VAPI.Primitives.Unsigned32;
        /**
          Lines after end of active video to update the RTP timestamp (TR-03 mode
          only)
        */
        mpkt_wordcounter: VAPI.Primitives.Unsigned32;
        vtotal: VAPI.Primitives.Unsigned32;
        vstart: VAPI.Primitives.Unsigned32;
        hactive: VAPI.Primitives.Unsigned32;
        sts_select: VAPI.Primitives.Unsigned32;
    }
    type EncoderHWData = ({
        variant: "EncoderClassic";
        value: VAPI.AT1101.RTPTransmitter.EncoderHWDataEncoderClassic;
    } | {
        variant: "EncoderVC2";
        value: VAPI.AT1101.RTPTransmitter.EncoderHWDataEncoderVC2;
    } | {
        variant: "EncoderJxsCodec";
        value: VAPI.AT1101.RTPTransmitter.EncoderHWDataEncoderJxsCodec;
    });
    interface EncoderHWDataEncoderJxsCodec {
        /**
          Width of the input encoded image, in pixels. Must be a multiple of 2. Up
          to 4096 for UHD IP-core flavor
        */
        width: null | VAPI.Primitives.Unsigned32;
        /**
          Height of the input encoded image, in pixels. Must be a multiple of 2,
          and greater than or equal to 4
        */
        height: null | VAPI.Primitives.Unsigned32;
        /**
          Contains input mode configuration fields: bit 3-0: color and sub-sampling
          mode
        */
        mode: null | VAPI.RTPTransmitter.ColorSampleMode;
        /**
          Budget in bytes per compressed frame, which is allocated to the picture
          header and the compressed data. Note: To compute this value according to
          a bit per pixel rate: budget = bpp x width x height / 8 Complementary
          header (ie. boxes) is not included in the budget
        */
        budget_per_frame: null | VAPI.Primitives.Unsigned32;
        /**
          VALIDATE It validates the given configuration. Set to '1' to start the
          IP-core, after setting mode and images parameters. This signal must be
          activated to validate any change in configuration (width, height, ...).
          Set to '0' to stop the IP-core. bit 1: (R) CFG_READY ‘1’ indicates
          that the TICO-XS is ready to receive a new configuration, when this bit
          is ‘0’ configuration registers shouldn't be modified
        */
        vld: null | VAPI.RTPTransmitter.ValidateMode;
        /**
          Number of images to play when the IP-core is in command mode. (when
          PLAY_MODE register = 0)
        */
        number_of_images: null | VAPI.Primitives.Unsigned32;
        /**
          Bit depth of the video content, mapped on the MSBs of the port interface.
          The valid bit depths are 8, 10 and 12 bits per component
        */
        video_depth: null | VAPI.RTPTransmitter.VideoDepth;
        /**
          It allows to choose between two running modes: set to '1' to run in play
          mode, in which the IP-core processes frames continuously. or set to '0'
          to run in command mode, in which the IP-core processes n frames, n
          defined by NBR
        */
        play_mode: null | boolean;
        /**
          This register is used to program the image quality optimization
          parameters (visual or PSNR). Each pre-computed weights value must be
          written to this register sequentially to ensure proper encoder behavior.
        */
        level_weights: null | Array<VAPI.Primitives.Unsigned32>;
        profile: null | VAPI.Primitives.Unsigned32;
    }
    interface EncoderHWDataEncoderVC2 {
        interlace: boolean;
        enabled: boolean;
        is_uhd: boolean;
        target_bytes_per_slice: VAPI.Primitives.Unsigned32;
        last_slice: VAPI.Primitives.Unsigned32;
    }
    class FlowReference implements VScript.Referenceable<"RTPTransmitter::Data::FlowReference"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::FlowReference";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hdr_ref(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.RTPTransmitter.HDRVideo, VAPI.AT1101.RTPTransmitter.FlowReference>;
        get hdr_index(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.RTPTransmitter.FlowReference>;
    }
    class GroupOutput implements VScript.Referenceable<"RTPTransmitter::Data::GroupOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::GroupOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get traffic_shaper_interval(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Primitives.Unsigned32>, VAPI.AT1101.RTPTransmitter.GroupOutput>;
        get hw_capability(): VScript.rKeyword<VScript.VSocket, [
            number
        ], VAPI.AT1101.RTPTransmitter.GroupOutputHwCapability, VAPI.AT1101.RTPTransmitter.GroupOutput>;
        get group_control_encoder_header(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::HDRAudio", HDRAudio>;
    }
    class HDRAudio implements VScript.Referenceable<"RTPTransmitter::Data::HDRAudio"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HDRAudio";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_port_bandwidth(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.NetworkBandwidth, VAPI.AT1101.RTPTransmitter.HDRAudio>;
        get related_references(): HeaderReference;
        get audio_encoder_hw(): AudioEncoder;
    }
    class HDRGeneral implements VScript.Referenceable<"RTPTransmitter::Data::HDRGeneral"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HDRGeneral";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get audio(): HDRAudio;
        get video(): HDRVideo;
        get mipmap(): HDRMipmap;
    }
    class HDRMipmap implements VScript.Referenceable<"RTPTransmitter::Data::HDRMipmap"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HDRMipmap";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_port_bandwidth(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.NetworkBandwidth, VAPI.AT1101.RTPTransmitter.HDRMipmap>;
        get related_references(): HeaderReference;
        get mipmap_encoder_hw(): VAPI.RTPTransmitter.MipMapEncoder;
    }
    class HDRVideo implements VScript.Referenceable<"RTPTransmitter::Data::HDRVideo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HDRVideo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_tdm_output_bandwidth(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.NetworkBandwidth, VAPI.AT1101.RTPTransmitter.HDRVideo>;
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_bandwidth(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.NetworkBandwidth, VAPI.AT1101.RTPTransmitter.HDRVideo>;
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_port_bandwidth(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.NetworkBandwidth, VAPI.AT1101.RTPTransmitter.HDRVideo>;
        get related_references(): HeaderReference;
        get router_encoder_hw(): RouterEncoder;
    }
    class HardwareStatus implements VScript.Referenceable<"RTPTransmitter::Data::HardwareStatus"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HardwareStatus";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get lane(): VScript.StronglyTypedArray<VScript.VSocket, "RTPTransmitter::Data::LaneHeader", LaneHeader>;
        get ports(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::PortStatistic", PortStatistic>;
        get xbar_encoder(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::XbarEncoder", XbarEncoder>;
        get router_error(): VAPI.RTPTransmitter.RouterError;
        get audio_tx_group_control(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::AudioGroupControl", VAPI.RTPTransmitter.AudioGroupControl>;
    }
    class HeaderReference implements VScript.Referenceable<"RTPTransmitter::Data::HeaderReference"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::HeaderReference";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get tx_stream_counter(): VScript.rKeyword<VScript.VSocket, null | string, null | VScript.RefinedIndexedNonmutatingReference<VScript.VSocket, "tx_streams", "NetworkInterfaces::Data::LaneStatistics", VScript.Referenceable<"NetworkInterfaces::Data::LaneStatistics"> & VAPI.AT1101.NetworkInterfaces.LaneStatistics, [
            number,
            number,
            number,
            number
        ], VAPI.EthernetStats.Counter>, VAPI.AT1101.RTPTransmitter.HeaderReference>;
    }
    class LaneHeader implements VScript.Referenceable<"RTPTransmitter::Data::LaneHeader"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::LaneHeader";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get statistic(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            number,
            number,
            null | string
        ], VAPI.AT1101.RTPTransmitter.LaneStatistic, VAPI.AT1101.RTPTransmitter.LaneHeader>;
        get video(): RouterOutput;
        get audio(): GroupOutput;
        get mipmap(): MipMapOutput;
    }
    interface LaneStatistic {
        /**
          maximum throughput, measured in bits/second
        */
        reserved_tdm_output_bandwidth: VAPI.Primitives.NetworkBandwidth;
        /**
          maximum throughput, measured in bits/second
        */
        max_tdm_output_bandwidth: VAPI.Primitives.NetworkBandwidth;
        /**
          maximum throughput, measured in bits/second
        */
        reserved_bus_bandwidth: VAPI.Primitives.NetworkBandwidth;
        /**
          maximum throughput, measured in bits/second
        */
        maxbus_bandwidth: VAPI.Primitives.NetworkBandwidth;
        fpga_lane_statistic: null | VAPI.AT1101.NetworkInterfaces.LaneStatistics;
    }
    class MediaClock implements VScript.Referenceable<"RTPTransmitter::Data::MediaClock"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MediaClock";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get clock_mode(): VScript.dKeyword<VScript.VSocket, ([0, [null | string]] | [
            1,
            []
        ]), ([0, [null | string]] | [
            1,
            []
        ]), VAPI.AT1101.RTPTransmitter.MediaClockControl, VAPI.AT1101.RTPTransmitter.MediaClockControl, VAPI.AT1101.RTPTransmitter.MediaClock>;
        get offset(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.RTPTransmitter.MediaClock>;
        get latch_control(): VAPI.Definitions.LatchControl;
        get latched_timestamp(): VScript.rKeyword<VScript.VSocket, number, VScript.Duration, VAPI.AT1101.RTPTransmitter.MediaClock>;
        get hw_latched_timestamp(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPTransmitter.MediaClock>;
    }
    type MediaClockControl = ({
        variant: "Timesource";
        value: VAPI.AT1101.RTPTransmitter.MediaClockControlTimesource;
    } | {
        variant: "Propagate";
        value: VAPI.RTPTransmitter.MediaClockControlPropagate;
    });
    class MediaStreamer implements VScript.Referenceable<"RTPTransmitter::Data::MediaStreamer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MediaStreamer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hosting_session(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.RTPTransmitter.Session, null | VScript.Referenceable<"RTPTransmitter::Data::Session"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.RTPTransmitter.MediaStreamer>;
        get mediaclock(): MediaClock;
        get ip_configuration(): VAPI.RTPTransmitter.MediaStreamerIpConfiguration;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPTransmitter.MediaStreamerIssues, VAPI.AT1101.RTPTransmitter.MediaStreamer>;
    }
    class MediaStreamerVideo implements VScript.Referenceable<"RTPTransmitter::Data::MediaStreamerVideo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MediaStreamerVideo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hosting_session(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.RTPTransmitter.Session, null | VScript.Referenceable<"RTPTransmitter::Data::Session"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.RTPTransmitter.MediaStreamerVideo>;
        get mediaclock(): MediaClock;
        get ip_configuration(): VAPI.RTPTransmitter.MediaStreamerVideoIpConfiguration;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.RTPTransmitter.MediaStreamerVideoIssues, VAPI.AT1101.RTPTransmitter.MediaStreamerVideo>;
    }
    class MipMapOutput implements VScript.Referenceable<"RTPTransmitter::Data::MipMapOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MipMapOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hw_capability(): VScript.rKeyword<VScript.VSocket, [
            number
        ], VAPI.AT1101.RTPTransmitter.MipMapOutputHwCapability, VAPI.AT1101.RTPTransmitter.MipMapOutput>;
        get mipmap_encoder_header(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::HDRMipmap", HDRMipmap>;
    }
    class MipMapStreamHardware implements VScript.Referenceable<"RTPTransmitter::Data::MipMapStreamHardware"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MipMapStreamHardware";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get router_encoder(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::MipMapStreamHardware::RouterEncoder", MipMapStreamHardwareRouterEncoder>;
    }
    class MipMapStreamer implements VScript.Referenceable<"RTPTransmitter::Data::MipMapStreamer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MipMapStreamer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get ip_configuration(): VAPI.RTPTransmitter.MipMapStreamerIpConfiguration;
        get stream_name(): VAPI.Definitions.NAME;
        get connected_hardware(): MipMapStreamHardware;
    }
    class PortStatistic implements VScript.Referenceable<"RTPTransmitter::Data::PortStatistic"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::PortStatistic";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_output_bandwidth(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.NetworkBandwidth, VAPI.AT1101.RTPTransmitter.PortStatistic>;
        /**
          maximum throughput (per direction), measured in bits/second
        */
        get max_throughput(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.RTPTransmitter.PortStatistic>;
        get interfaces(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::PortStatistic::Interfaces", PortStatisticInterfaces>;
        get lane(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::PortStatistic::Lane", PortStatisticLane>;
    }
    class ReStreamer implements VScript.Referenceable<"RTPTransmitter::Data::ReStreamer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::ReStreamer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get fill_it_up(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPTransmitter.ReStreamer>;
        get generic(): MediaStreamer;
    }
    class ReStreamerAsNamedTableRow extends ReStreamer {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class RouterEncoder implements VScript.Referenceable<"RTPTransmitter::Data::RouterEncoder"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::RouterEncoder";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get allocated_blocks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPTransmitter.RouterEncoder>;
        get block_addr(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Primitives.Unsigned32>, VAPI.AT1101.RTPTransmitter.RouterEncoder>;
        get sequence_number(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPTransmitter.RouterEncoder>;
        get sequence_add_eol(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPTransmitter.RouterEncoder>;
        get no_m_packet(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.RTPTransmitter.RouterEncoder>;
        get timestamp_offset(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPTransmitter.RouterEncoder>;
        get error(): RouterEncoderError;
    }
    class RouterOutput implements VScript.Referenceable<"RTPTransmitter::Data::RouterOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::RouterOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get error(): VScript.rKeyword<VScript.VSocket, [
            number,
            number
        ], VAPI.AT1101.RTPTransmitter.RouterOutputError, VAPI.AT1101.RTPTransmitter.RouterOutput>;
        get hw_capability(): VScript.rKeyword<VScript.VSocket, [
            number
        ], VAPI.AT1101.RTPTransmitter.RouterOutputHwCapability, VAPI.AT1101.RTPTransmitter.RouterOutput>;
        get router_encoder_header(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::HDRVideo", HDRVideo>;
    }
    interface ST2110Settings {
        packing_mode: VAPI.RTPTransmitter.PackingMode;
        add_st2110_40: boolean;
    }
    class Session implements VScript.Referenceable<"RTPTransmitter::Data::Session"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::Session";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get active(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.RTPTransmitter.Session>;
        get reserve_resources(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.RTPTransmitter.Session>;
        get sdp_a(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.RTPTransmitter.Session>;
        get session_name(): VAPI.Definitions.NAME;
        get video_transmitters(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1101.RTPTransmitter.VideoStreamer>, VAPI.AT1101.RTPTransmitter.Session>;
        get audio_transmitters(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1101.RTPTransmitter.AudioStreamer>, VAPI.AT1101.RTPTransmitter.Session>;
        get passthrough_transmitters(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1101.RTPTransmitter.ReStreamer>, VAPI.AT1101.RTPTransmitter.Session>;
        get mipmap_transmitters(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1101.RTPTransmitter.MipMapStreamer>, VAPI.AT1101.RTPTransmitter.Session>;
        get interfaces(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | string
        ], [
            null | string,
            null | string
        ], VAPI.RTPTransmitter.SessionInterfaces, VAPI.RTPTransmitter.SessionInterfaces, VAPI.AT1101.RTPTransmitter.Session>;
    }
    class SessionAsNamedTableRow extends Session {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    interface MediaClockControlTimesource {
        t_src: null | VAPI.AT1101.Time.Source;
    }
    class VideoConfigurationContainer implements VScript.Referenceable<"RTPTransmitter::Data::VideoConfigurationContainer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::VideoConfigurationContainer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get transport_format(): VScript.dKeyword<VScript.VSocket, ([0, []] | [
            1,
            [
                VAPI.RTPTransmitter.PackingMode,
                boolean
            ]
        ] | [
            2,
            [
                VAPI.Video.DiracCompression,
                boolean
            ]
        ] | [
            3,
            [
                ([0, [number]] | [
                    1,
                    [number]
                ]),
                VAPI.RTPTransmitter.LVLMODE,
                boolean,
                boolean
            ]
        ]), ([0, []] | [
            1,
            [
                VAPI.RTPTransmitter.PackingMode,
                boolean
            ]
        ] | [
            2,
            [
                VAPI.Video.DiracCompression,
                boolean
            ]
        ] | [
            3,
            [
                ([0, [number]] | [
                    1,
                    [number]
                ]),
                VAPI.RTPTransmitter.LVLMODE,
                boolean,
                boolean
            ]
        ]), VAPI.AT1101.RTPTransmitter.VideoFormat, VAPI.AT1101.RTPTransmitter.VideoFormat, VAPI.AT1101.RTPTransmitter.VideoConfigurationContainer>;
        get vanc(): VAPI.AT1101.Definitions.VancControl;
        get embedded_audio(): VScript.dKeyword<VScript.VSocket, Array<VAPI.Definitions.TRSEmbedder>, VScript.MaybeSparseArray<VAPI.Definitions.TRSEmbedder>, Array<VAPI.Definitions.TRSEmbedder>, VScript.MaybeSparseArray<VAPI.Definitions.TRSEmbedder>, VAPI.AT1101.RTPTransmitter.VideoConfigurationContainer>;
        get a_src(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | number | string
        ], [
            null | string,
            null | number | string
        ], VAPI.AT1101.Audio.TimedSource, VAPI.AT1101.Audio.TimedSource, VAPI.AT1101.RTPTransmitter.VideoConfigurationContainer>;
    }
    type VideoFormat = ({
        variant: "ST2022_6";
        value: VAPI.RTPTransmitter.ST20226Settings;
    } | {
        variant: "ST2110_20";
        value: VAPI.AT1101.RTPTransmitter.ST2110Settings;
    } | {
        variant: "ST2042";
        value: VAPI.RTPTransmitter.ST2042Settings;
    } | {
        variant: "JPEG_XS";
        value: VAPI.RTPTransmitter.JpegXsSettings;
    });
    class VideoStreamHardware implements VScript.Referenceable<"RTPTransmitter::Data::VideoStreamHardware"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::VideoStreamHardware";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get xbar_encoder(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::VideoStreamHardware::XbarEncoder", VideoStreamHardwareXbarEncoder>;
        get router_encoder(): VScript.StronglyTypedTable<VScript.VSocket, "RTPTransmitter::Data::VideoStreamHardware::RouterEncoder", VideoStreamHardwareRouterEncoder>;
    }
    class VideoStreamer implements VScript.Referenceable<"RTPTransmitter::Data::VideoStreamer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::VideoStreamer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get generic(): MediaStreamerVideo;
        get constraints(): VAPI.RTPTransmitter.Constraints;
        get v_src(): VScript.dKeyword<VScript.VSocket, [
            null | string,
            null | number | string
        ], [
            null | string,
            null | number | string
        ], VAPI.AT1101.Video.TimedSource, VAPI.AT1101.Video.TimedSource, VAPI.AT1101.RTPTransmitter.VideoStreamer>;
        get configuration(): VideoConfigurationContainer;
        get stream_name(): VAPI.Definitions.NAME;
        get connected_hardware(): VideoStreamHardware;
    }
    class VideoStreamerAsNamedTableRow extends VideoStreamer {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class XbarEncoder implements VScript.Referenceable<"RTPTransmitter::Data::XbarEncoder"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::XbarEncoder";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get st2110_40_capable(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.RTPTransmitter.XbarEncoder>;
        get st2110_40_in_use(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.RTPTransmitter.XbarEncoder>;
        get debug(): VScript.rKeyword<VScript.VSocket, ([
            0,
            [
                boolean,
                boolean,
                boolean,
                boolean,
                boolean,
                boolean,
                number,
                number,
                number,
                number,
                number,
                number
            ]
        ] | [
            1,
            [
                boolean,
                boolean,
                boolean,
                number,
                number
            ]
        ] | [
            2,
            [
                null | number,
                null | number,
                null | VAPI.RTPTransmitter.ColorSampleMode,
                null | number,
                null | VAPI.RTPTransmitter.ValidateMode,
                null | number,
                null | VAPI.RTPTransmitter.VideoDepth,
                null | boolean,
                null | Array<number>,
                null | number
            ]
        ]), VAPI.AT1101.RTPTransmitter.EncoderHWData, VAPI.AT1101.RTPTransmitter.XbarEncoder>;
    }
    class AudioStreamHardwareAudioEncoder implements VScript.Referenceable<"RTPTransmitter::Data::AudioStreamHardware::AudioEncoder"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::AudioStreamHardware::AudioEncoder";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get primary(): AudioEncoderStatus;
        get secondary(): AudioEncoderStatus;
    }
    class AudioEncoderError implements VScript.Referenceable<"RTPTransmitter::Data::AudioEncoder::Error"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::AudioEncoder::Error";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get queue_overflow(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPTransmitter.AudioEncoderError>;
        get queue_full(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPTransmitter.AudioEncoderError>;
    }
    class RouterEncoderError implements VScript.Referenceable<"RTPTransmitter::Data::RouterEncoder::Error"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::RouterEncoder::Error";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get queue_overflow(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPTransmitter.RouterEncoderError>;
        get queue_full(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.RTPTransmitter.RouterEncoderError>;
    }
    interface RouterOutputError {
        queue_overflow: VAPI.Primitives.Unsigned32;
        queue_full: VAPI.Primitives.Unsigned32;
    }
    interface GroupOutputHwCapability {
        num_encoder: VAPI.Primitives.Unsigned32;
    }
    interface MipMapOutputHwCapability {
        num_encoder: VAPI.Primitives.Unsigned32;
    }
    interface RouterOutputHwCapability {
        num_encoder: VAPI.Primitives.Unsigned32;
    }
    class PortStatisticInterfaces implements VScript.Referenceable<"RTPTransmitter::Data::PortStatistic::Interfaces"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::PortStatistic::Interfaces";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get interface(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.NetworkInterfaces.VirtualInterface, VAPI.AT1101.RTPTransmitter.PortStatisticInterfaces>;
    }
    class PortStatisticLane implements VScript.Referenceable<"RTPTransmitter::Data::PortStatistic::Lane"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::PortStatistic::Lane";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.RTPTransmitter.LaneHeader, VAPI.AT1101.RTPTransmitter.PortStatisticLane>;
    }
    class MipMapStreamHardwareRouterEncoder implements VScript.Referenceable<"RTPTransmitter::Data::MipMapStreamHardware::RouterEncoder"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::MipMapStreamHardware::RouterEncoder";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          reference to router encoder hardware
        */
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.RTPTransmitter.HDRMipmap, VAPI.AT1101.RTPTransmitter.MipMapStreamHardwareRouterEncoder>;
    }
    class VideoStreamHardwareRouterEncoder implements VScript.Referenceable<"RTPTransmitter::Data::VideoStreamHardware::RouterEncoder"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::VideoStreamHardware::RouterEncoder";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          reference to router encoder hardware
        */
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.RTPTransmitter.HDRVideo, VAPI.AT1101.RTPTransmitter.VideoStreamHardwareRouterEncoder>;
    }
    class VideoStreamHardwareXbarEncoder implements VScript.Referenceable<"RTPTransmitter::Data::VideoStreamHardware::XbarEncoder"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RTPTransmitter::Data::VideoStreamHardware::XbarEncoder";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          reference to xbar encoder hardware
        */
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.RTPTransmitter.XbarEncoder, VAPI.AT1101.RTPTransmitter.VideoStreamHardwareXbarEncoder>;
    }
}
export declare namespace RePlay {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
    };
    const lower: {
        readonly All: (_x: All) => string;
    };
    class All implements VScript.Referenceable<"RePlay::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "RePlay::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video(): VAPI.AT1101.VideoRePlay.Video;
        get audio(): VAPI.AT1101.AudioRePlay.Audio;
    }
}
export declare namespace SampleRateConverter {
    const lift: {
        readonly AUDIOSRCSTATUS: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AUDIOSRCSTATUS;
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly INPUTSTATUS: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => INPUTSTATUS;
        readonly RESOURCE: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RESOURCE;
        readonly RESOURCES: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RESOURCES;
        readonly SRC: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SRC;
        readonly SRCHardware: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SRCHardware;
        readonly Time: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Time;
        readonly AUDIOSRCSTATUSHwSettings: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AUDIOSRCSTATUSHwSettings;
        readonly SRCSettings: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SRCSettings;
    };
    const lower: {
        readonly AUDIOSRCSTATUS: (_x: AUDIOSRCSTATUS) => string;
        readonly All: (_x: All) => string;
        readonly INPUTSTATUS: (_x: INPUTSTATUS) => string;
        readonly RESOURCE: (_x: RESOURCE) => string;
        readonly RESOURCES: (_x: RESOURCES) => string;
        readonly SRC: (_x: SRC) => string;
        readonly SRCHardware: (_x: SRCHardware) => string;
        readonly Time: (_x: Time) => string;
        readonly AUDIOSRCSTATUSHwSettings: (_x: AUDIOSRCSTATUSHwSettings) => string;
        readonly SRCSettings: (_x: SRCSettings) => string;
    };
    class AUDIOSRCSTATUS implements VScript.Referenceable<"SampleRateConverter::Data::AUDIOSRCSTATUS"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::AUDIOSRCSTATUS";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hw_settings(): AUDIOSRCSTATUSHwSettings;
        get hw_resource_mux(): RESOURCE;
    }
    class All implements VScript.Referenceable<"SampleRateConverter::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::All";
        get runtime_constants(): {
            readonly num_srcs: number;
            readonly num_src_inputs: number;
            readonly num_srcs_x24: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get instances(): VScript.StronglyTypedNamedTable<VScript.VSocket, "SampleRateConverter::Data::SRC", SRCAsNamedTableRow>;
        get hardware_resources(): RESOURCES;
    }
    class INPUTSTATUS implements VScript.Referenceable<"SampleRateConverter::Data::INPUTSTATUS"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::INPUTSTATUS";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hw_value(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.SampleRateConverter.INPUTSTATUS>;
        /**
          index of the selected input channel based on 64
        */
        get audio_src(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.SampleRateConverter.INPUTSTATUS>;
        get sop_src(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.SampleRateConverter.INPUTSTATUS>;
        get enable(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.AT1101.SampleRateConverter.INPUTSTATUS>;
    }
    class RESOURCE implements VScript.Referenceable<"SampleRateConverter::Data::RESOURCE"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::RESOURCE";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get mux(): INPUTSTATUS;
        get read_status(): VAPI.SampleRateConverter.READSTATUS;
        get audio_source_slices(): VAPI.Audio.SignalSourceSlice;
        get related_mux(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1101.SampleRateConverter.RESOURCE>, VAPI.AT1101.SampleRateConverter.RESOURCE>;
    }
    class RESOURCES implements VScript.Referenceable<"SampleRateConverter::Data::RESOURCES"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::RESOURCES";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hw_resource_x24(): VScript.StronglyTypedTable<VScript.VSocket, "SampleRateConverter::Data::AUDIOSRCSTATUS", AUDIOSRCSTATUS>;
    }
    class SRC implements VScript.Referenceable<"SampleRateConverter::Data::SRC"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::SRC";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get active(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.SampleRateConverter.SRC>;
        get settings(): SRCSettings;
        get a_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Audio.Essence, null | VScript.Referenceable<"Audio::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.SampleRateConverter.SRC>;
        get output(): VAPI.AT1101.Audio.Essence;
        get connected_hardware(): SRCHardware;
    }
    class SRCAsNamedTableRow extends SRC {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class SRCHardware implements VScript.Referenceable<"SampleRateConverter::Data::SRCHardware"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::SRCHardware";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get hw(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1101.SampleRateConverter.AUDIOSRCSTATUS>, VAPI.AT1101.SampleRateConverter.SRCHardware>;
        get hw_mux(): VScript.rKeyword<VScript.VSocket, Array<null | string>, Array<null | VAPI.AT1101.SampleRateConverter.INPUTSTATUS>, VAPI.AT1101.SampleRateConverter.SRCHardware>;
    }
    class Time implements VScript.Referenceable<"SampleRateConverter::Data::Time"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::Time";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.SampleRateConverter.Time>;
    }
    class AUDIOSRCSTATUSHwSettings implements VScript.Referenceable<"SampleRateConverter::Data::AUDIOSRCSTATUS::HwSettings"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::AUDIOSRCSTATUS::HwSettings";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get pairs(): VScript.StronglyTypedArray<VScript.VSocket, "SampleRateConverter::Data::PAIRCOM", VAPI.SampleRateConverter.PAIRCOM>;
    }
    class SRCSettings implements VScript.Referenceable<"SampleRateConverter::Data::SRC::Settings"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SampleRateConverter::Data::SRC::Settings";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get channel_capacity(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.SampleRateConverter.SRCSettings>;
    }
}
export declare namespace Splitter {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly SP: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SP;
        readonly SPOutputs: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => SPOutputs;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly SP: (_x: SP) => string;
        readonly SPOutputs: (_x: SPOutputs) => string;
    };
    class All implements VScript.Referenceable<"Splitter::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Splitter::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get instances(): VScript.StronglyTypedNamedTable<VScript.VSocket, "Splitter::Data::SP", SPAsNamedTableRow>;
    }
    class SP implements VScript.Referenceable<"Splitter::Data::SP"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Splitter::Data::SP";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get v_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.Splitter.SP>;
        get outputs(): VScript.StronglyTypedTable<VScript.VSocket, "Splitter::Data::SP::Outputs", SPOutputs>;
    }
    class SPAsNamedTableRow extends SP {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class SPOutputs implements VScript.Referenceable<"Splitter::Data::SP::Outputs"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Splitter::Data::SP::Outputs";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get output(): VAPI.AT1101.Video.Essence;
    }
}
export declare namespace System {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly InternalHW: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => InternalHW;
        readonly MEMORY: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => MEMORY;
        readonly Partitions: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Partitions;
        readonly Power: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Power;
        readonly Temperature: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Temperature;
        readonly InternalHWSgmii: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => InternalHWSgmii;
        readonly AllSysinfo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AllSysinfo;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly InternalHW: (_x: InternalHW) => string;
        readonly MEMORY: (_x: MEMORY) => string;
        readonly Partitions: (_x: Partitions) => string;
        readonly Power: (_x: Power) => string;
        readonly Temperature: (_x: Temperature) => string;
        readonly InternalHWSgmii: (_x: InternalHWSgmii) => string;
        readonly AllSysinfo: (_x: AllSysinfo) => string;
    };
    class All implements VScript.Referenceable<"System::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::All";
        get runtime_constants(): {
            readonly is_udx: boolean;
            readonly is_no_pcap: boolean;
            readonly is_multiviewer: boolean;
            readonly is_j2kdecoder: boolean;
            readonly has_replay: boolean;
            readonly has_audio_mixer: boolean;
            readonly has_color_correction: boolean;
            readonly has_video_mixer: boolean;
            readonly has_audio_gain: boolean;
            readonly supports_metadata_extraction: boolean;
            readonly is_pcap: boolean;
            readonly has_passthrough_transmitters: boolean;
            readonly is_jpegxs: boolean;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get temperature(): Temperature;
        get power(): Power;
        get fan_speed(): VScript.StronglyTypedTable<VScript.VSocket, "System::Data::FanSpeed", VAPI.System.FanSpeed>;
        get barebox_version(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.System.All>;
        get barebox_state(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.System.All>;
        get booted_partition(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.System.All>;
        get partitions(): Partitions;
        get watchdog_version(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number
        ], null | VAPI.System.Revision, VAPI.AT1101.System.All>;
        get sysinfo(): AllSysinfo;
        get usrinfo(): VAPI.System.AllUsrinfo;
        get neighborhood_watch(): VAPI.System.NeighborhoodWatch;
        get psu(): VScript.StronglyTypedTable<VScript.VSocket, "System::Data::PSU", VAPI.System.PSU>;
        get qsfp(): VScript.StronglyTypedTable<VScript.VSocket, "System::Data::QSFP", VAPI.System.QSFP>;
        get ecc(): VAPI.System.AllEcc;
        get unique_id(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.System.All>;
        get fpga(): VAPI.System.CompileInfo;
        get device(): VAPI.System.Device;
        get io_board(): VAPI.System.AllIoBoard;
        get fan_board(): VAPI.System.Device;
        get frame(): VAPI.System.Device;
        get memory(): MEMORY;
        get internal_hw(): InternalHW;
        /**
          FPGA debug bus at last reboot
        */
        get previous_dbg_bus(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.System.All>;
        /**
          Watchdog event log - contains boot reason and times
        */
        get watchdog_event_log(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.System.All>;
        get board_location(): VScript.rKeyword<VScript.VSocket, VAPI.System.BOARDPOS, VAPI.System.BOARDPOS, VAPI.AT1101.System.All>;
        get frontpanel_led_brightness(): VScript.rwKeyword<VScript.VSocket, VAPI.System.LEDBRIGHTNESS, VAPI.System.LEDBRIGHTNESS, VAPI.System.LEDBRIGHTNESS, VAPI.System.LEDBRIGHTNESS, VAPI.AT1101.System.All>;
        /**
          Blink the front panel LED in blue to help locating this blade
        */
        get frontpanel_blink_blue(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.System.All>;
        get slots(): VScript.StronglyTypedTable<VScript.VSocket, "System::Data::SlotInformation", VAPI.System.SlotInformation>;
        get services(): VAPI.System.AllServices;
        /**
          Currently loaded FPGA
        */
        get selected_fpga(): VScript.rKeyword<VScript.VSocket, null | VAPI.AT1101.System.FPGA, null | VAPI.AT1101.System.FPGA, VAPI.AT1101.System.All>;
        /**
          Change which FPGA to load on next reboot
        */
        get select_fpga(): VScript.dKeyword<VScript.VSocket, null | VAPI.AT1101.System.FPGASelection, null | VAPI.AT1101.System.FPGASelection, null | VAPI.AT1101.System.FPGASelection, null | VAPI.AT1101.System.FPGASelection, VAPI.AT1101.System.All>;
        /**
          @brief Perform a reboot of the blade
          @desc Type in 'reboot' to reboot the current partition. Type in 'system0'
          or 'system1' to reboot to the respective partition.
        */
        get reboot(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.AT1101.System.All>;
        /**
          @brief Perform a power cycle
          @desc Interrupt blade power for 3 seconds
        */
        get powercycle(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.AT1101.System.All>;
        /**
          @brief Reset NVRAM
          @desc Enter /reset/ to clear all settings and reboot
        */
        get reset(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.AT1101.System.All>;
        get command_logging(): VAPI.System.AllCommandLogging;
        get nmos(): VAPI.System.AllNmos;
    }
    type FPGA = "AVP" | "AVP_40GbE" | "DMV_40GbE" | "UDX_40GbE" | "J2KD" | "J2KD_40GbE" | "CC3D_40GbE" | "JPEGXS_40GbE" | "PCAP_40GbE";
    type FPGASelection = "AVP" | "AVP_40GbE" | "CC3D_40GbE" | "DMV_40GbE" | "JPEGXS_40GbE" | "PCAP_40GbE" | "UDX_40GbE";
    class InternalHW implements VScript.Referenceable<"System::Data::InternalHW"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::InternalHW";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          Active PCIe lanes - should be 4
        */
        get pcie_lanes(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.InternalHW>;
        /**
          Active PCIe speed - should be GT_5_0
        */
        get pcie_speed(): VScript.rKeyword<VScript.VSocket, null | VAPI.System.PCIESPEED, null | VAPI.System.PCIESPEED, VAPI.AT1101.System.InternalHW>;
        get sgmii(): VScript.StronglyTypedArray<VScript.VSocket, "System::Data::InternalHW::Sgmii", InternalHWSgmii>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AT1101.System.InternalHWIssues, VAPI.AT1101.System.InternalHW>;
    }
    class MEMORY implements VScript.Referenceable<"System::Data::MEMORY"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::MEMORY";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          if RAM calibration failed and rebooting does not fix the issue, please
          contact customer support
        */
        get ram_sodimm1(): VScript.rKeyword<VScript.VSocket, VAPI.System.RAMCALIBRATION, VAPI.System.RAMCALIBRATION, VAPI.AT1101.System.MEMORY>;
        /**
          if RAM calibration failed and rebooting does not fix the issue, please
          contact customer support
        */
        get ram_sodimm2(): VScript.rKeyword<VScript.VSocket, VAPI.System.RAMCALIBRATION, VAPI.System.RAMCALIBRATION, VAPI.AT1101.System.MEMORY>;
        /**
          if RAM calibration failed and rebooting does not fix the issue, please
          contact customer support
        */
        get ram_u16(): VScript.rKeyword<VScript.VSocket, VAPI.System.RAMCALIBRATION, VAPI.System.RAMCALIBRATION, VAPI.AT1101.System.MEMORY>;
        /**
          J101
        */
        get spd_sodimm1(): VAPI.System.SPD;
        /**
          J111
        */
        get spd_sodimm2(): VAPI.System.SPD;
        get spd_cpu(): VAPI.System.SPD;
    }
    class Partitions implements VScript.Referenceable<"System::Data::Partitions"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::Partitions";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get booted(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.System.SWVersion, VAPI.AT1101.System.Partitions>;
        get recovery(): VAPI.System.SWVersion;
        get system0(): VAPI.System.SWVersion;
        get system1(): VAPI.System.SWVersion;
    }
    class Power implements VScript.Referenceable<"System::Data::Power"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::Power";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          Power usage for P0V95
        */
        get p0v95(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Power>;
        /**
          Power usage for P1V1 and P1V2
        */
        get p1v1_1v2(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Power>;
        /**
          Power usage for P1V8
        */
        get p1v8(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Power>;
    }
    class Temperature implements VScript.Referenceable<"System::Data::Temperature"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::Temperature";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get fpga_int(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        get fpga_ext(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        get cpu(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        get u21(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        get u22(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        /**
          Temperature of Fan-Controller (U24)
        */
        get fan_controller(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        /**
          Temperature of U42
        */
        get p0v95_t1(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        /**
          Temperature of U43
        */
        get p0v95_t2(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        /**
          Temperature of U45
        */
        get p1v1_p1v2(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        /**
          Temperature of U44
        */
        get p1v8(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        get ioboard(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        /**
          Temperature of FPGA-SODIMM 1 (J101)
        */
        get fpga_sodimm1(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        /**
          Temperature of FPGA-SODIMM 2 (J111)
        */
        get fpga_sodimm2(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        /**
          Temperature of CPU-SODIMM (J71)
        */
        get cpu_sodimm(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        /**
          Temperature of U2
        */
        get mgmt_phy(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        /**
          Total minutes spent at overtemperature, where overtemperature is defined
          as follows:
          
          `CPU`: 100 °C
          
          `CPU_SODIMM`: 75 °C
          
          `MGMT_PHY`: 125 °C
          
          `FPGA_SODIMM1`: 75 °C
          
          `FPGA_SODIMM2`: 75 °C
          
          `FAN_CONTROLLER`: 70 °C
          
          `FPGA_EXT`: 100 °C
          
          `FPGA_INT`: 105 °C
          
          `P0V95_T1`: 125 °C
          
          `P0V95_T2`: 125 °C
          
          `P1V1_P1V2` 125 °C
          
          `P1V8`: 125 °C
          
          `U21`: 85 °C
          
          `U22`: 70 °C
        */
        get accumulated_overtemperature_time(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        get current_fanspeed_profile(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.Temperature>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AT1101.System.TemperatureIssues, VAPI.AT1101.System.Temperature>;
    }
    type InternalHWIssues = {
        wrong_pcie_speed_or_lanecount: boolean;
    };
    type TemperatureIssues = {
        cpu_sodimm_temperature_above_critical: boolean;
        cpu_sodimm_temperature_high: boolean;
        cpu_temperature_above_critical: boolean;
        cpu_temperature_high: boolean;
        fan_controller_temperature_above_critical: boolean;
        fan_controller_temperature_high: boolean;
        fpga_ext_temperature_above_critical: boolean;
        fpga_ext_temperature_high: boolean;
        fpga_int_temperature_above_critical: boolean;
        fpga_int_temperature_high: boolean;
        fpga_sodimm1_temperature_above_critical: boolean;
        fpga_sodimm1_temperature_high: boolean;
        fpga_sodimm2_temperature_above_critical: boolean;
        fpga_sodimm2_temperature_high: boolean;
        ioboard_temperature_above_critical: boolean;
        ioboard_temperature_high: boolean;
        mgmt_phy_temperature_above_critical: boolean;
        mgmt_phy_temperature_high: boolean;
        missing_data: boolean;
        p0v95_t1_temperature_above_critical: boolean;
        p0v95_t1_temperature_high: boolean;
        p0v95_t2_temperature_above_critical: boolean;
        p0v95_t2_temperature_high: boolean;
        p1v1_p1v2_temperature_above_critical: boolean;
        p1v1_p1v2_temperature_high: boolean;
        p1v8_temperature_above_critical: boolean;
        p1v8_temperature_high: boolean;
        u21_temperature_above_critical: boolean;
        u21_temperature_high: boolean;
        u22_temperature_above_critical: boolean;
        u22_temperature_high: boolean;
    };
    type InternalHWSgmiiIssues = {
        crc_errors: boolean;
        link_down: boolean;
        pcs_errors: boolean;
    };
    class InternalHWSgmii implements VScript.Referenceable<"System::Data::InternalHW::Sgmii"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::InternalHW::Sgmii";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get link_up(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.AT1101.System.InternalHWSgmii>;
        get crc_errors(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned64, VAPI.AT1101.System.InternalHWSgmii>;
        get pcs_errors(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned64, VAPI.AT1101.System.InternalHWSgmii>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.AT1101.System.InternalHWSgmiiIssues, VAPI.AT1101.System.InternalHWSgmii>;
    }
    class AllSysinfo implements VScript.Referenceable<"System::Data::All::Sysinfo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "System::Data::All::Sysinfo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          System runtime since boot
        */
        get uptime(): VScript.rKeyword<VScript.VSocket, number, VScript.Duration, VAPI.AT1101.System.AllSysinfo>;
        /**
          Load average for 1, 5 and 15 minutes
        */
        get load_avg(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<number>, VAPI.AT1101.System.AllSysinfo>;
        /**
          Free memory
        */
        get freeram(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.System.AllSysinfo>;
        /**
          Number of running processes
        */
        get procs(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.System.AllSysinfo>;
        /**
          Number of currently active CPU cores
        */
        get num_cores(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.AllSysinfo>;
        /**
          CPU-SAR Register (Sample At Reset)
        */
        get cpu_sar(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.System.AllSysinfo>;
        /**
          CPU-Frequency
        */
        get cpu_freq(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AT1101.System.AllSysinfo>;
        get services(): VAPI.ServicesList.ServicesList;
    }
    const Enums: {
        readonly FPGASelection: FPGASelection[];
        readonly FPGA: FPGA[];
    };
}
export declare namespace SystemClock {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
    };
    const lower: {
        readonly All: (_x: All) => string;
    };
    class All implements VScript.Referenceable<"SystemClock::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "SystemClock::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.SystemClock.All>;
        /**
          Determines the time standard the SystemClock will be set to.
          
          * `UTC` (Universal Time, Coordinated) is the standard for wall clock
          time. It is the standard that all timezones are based on. UTC has leap
          seconds to account for differences in the Earth's rotational speed. *When
          in doubt, always use `UTC`*
          
          * `TAI` (International Atomic Time) is the time standard used by PTP. It
          is a linear time standard that does not have leap seconds. TAI is
          currently ahead of UTC by 37 seconds.
        */
        get time_standard(): VScript.dKeyword<VScript.VSocket, VAPI.Time.Standard, VAPI.Time.Standard, VAPI.Time.Standard, VAPI.Time.Standard, VAPI.AT1101.SystemClock.All>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.SystemClock.AllIssues, VAPI.AT1101.SystemClock.All>;
        get system_time_updates(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.AT1101.SystemClock.All>;
        get system_time(): VScript.rKeyword<VScript.VSocket, null | number | string, null | VAPI.Primitives.Timestamp, VAPI.AT1101.SystemClock.All>;
        /**
          use this to override `output.characteristics.offset_type`; may be useful
          to, e.g., redistribute BlackBurst-derived local time as (absolute) PTP
          time
        */
        get offset_type_override(): VScript.rwKeyword<VScript.VSocket, null | VAPI.Time.OffsetType, null | VAPI.Time.OffsetType, null | VAPI.Time.OffsetType, null | VAPI.Time.OffsetType, VAPI.AT1101.SystemClock.All>;
        get output(): VAPI.AT1101.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
}
export declare namespace Time {
    const lift: {
        readonly AnalogReference: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => AnalogReference;
        readonly Source: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Source;
    };
    const lower: {
        readonly AnalogReference: (_x: AnalogReference) => string;
        readonly Source: (_x: Source) => string;
    };
    class AnalogReference implements VScript.Referenceable<"Time::Data::AnalogReference"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Time::Data::AnalogReference";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get output(): Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class Source implements VScript.Referenceable<"Time::Data::Source"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Time::Data::Source";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.Time.Source>;
        get characteristics(): VScript.rKeyword<VScript.VSocket, null | [
            null | VAPI.Time.OffsetType,
            null | VAPI.Time.GrainRate,
            VAPI.Time.ReferenceFrame,
            number
        ], null | VAPI.Time.SourceCharacteristics, VAPI.AT1101.Time.Source>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.Time.SourceIssues, VAPI.AT1101.Time.Source>;
        get drift(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number,
            number,
            number
        ], null | VAPI.Time.TimestampedDrift, VAPI.AT1101.Time.Source>;
        get offset(): VScript.rKeyword<VScript.VSocket, null | [
            number,
            number,
            number,
            number
        ], null | VAPI.Time.TimestampedOffset, VAPI.AT1101.Time.Source>;
        get time_code(): VScript.rKeyword<VScript.VSocket, null | [
            null | VScript.TimecodePayload,
            null | VScript.TimecodePayload,
            null | VScript.TimecodePayload,
            number,
            number
        ], null | VAPI.Time.TimestampedTimecode, VAPI.AT1101.Time.Source>;
        get ptp_traits(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.PTP.Traits, VAPI.AT1101.Time.Source>;
    }
}
export declare namespace TimeFlows {
    const lift: {
        readonly Aligner: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Aligner;
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly Combinator: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Combinator;
        readonly Detonator: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Detonator;
        readonly DriftConverter: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => DriftConverter;
        readonly Impostor: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Impostor;
        readonly Selector: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Selector;
        readonly Shifter: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Shifter;
        readonly Stretcher: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Stretcher;
    };
    const lower: {
        readonly Aligner: (_x: Aligner) => string;
        readonly All: (_x: All) => string;
        readonly Combinator: (_x: Combinator) => string;
        readonly Detonator: (_x: Detonator) => string;
        readonly DriftConverter: (_x: DriftConverter) => string;
        readonly Impostor: (_x: Impostor) => string;
        readonly Selector: (_x: Selector) => string;
        readonly Shifter: (_x: Shifter) => string;
        readonly Stretcher: (_x: Stretcher) => string;
    };
    class Aligner implements VScript.Referenceable<"TimeFlows::Data::Aligner"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::Aligner";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src_absolute(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.TimeFlows.Aligner>;
        get t_src_grain_accurate(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.TimeFlows.Aligner>;
        get warning_threshold(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.TimeFlows.Aligner>;
        get holdover_grains(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.TimeFlows.Aligner>;
        get output(): VAPI.AT1101.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.TimeFlows.AlignerIssues, VAPI.AT1101.TimeFlows.Aligner>;
    }
    class AlignerAsNamedTableRow extends Aligner {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class All implements VScript.Referenceable<"TimeFlows::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get aligners(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::Aligner", AlignerAsNamedTableRow>;
        get combinators(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::Combinator", CombinatorAsNamedTableRow>;
        get detonators(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::Detonator", DetonatorAsNamedTableRow>;
        get drift_converters(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::DriftConverter", DriftConverterAsNamedTableRow>;
        get impostors(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::Impostor", ImpostorAsNamedTableRow>;
        get selectors(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::Selector", SelectorAsNamedTableRow>;
        get shifters(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::Shifter", ShifterAsNamedTableRow>;
        /**
          stretchers shift their input source's measured drift by a user-defined
          amount (note that this demotes `Absolute` and `GrainAccurate` time
          sources to class `FrequencyOnly`). Stretchers are probably useless in a
          production setting, but can be helpful in simulating failure scenarios.
        */
        get stretchers(): VScript.StronglyTypedNamedTable<VScript.VSocket, "TimeFlows::Data::Stretcher", StretcherAsNamedTableRow>;
    }
    class Combinator implements VScript.Referenceable<"TimeFlows::Data::Combinator"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::Combinator";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get required_offset_type(): VScript.rwKeyword<VScript.VSocket, null | VAPI.TimeFlows.CombinatorType, null | VAPI.TimeFlows.CombinatorType, null | VAPI.TimeFlows.CombinatorType, null | VAPI.TimeFlows.CombinatorType, VAPI.AT1101.TimeFlows.Combinator>;
        get required_ptp_source_type(): VScript.rwKeyword<VScript.VSocket, null | VAPI.TimeFlows.PTPSourceTypeFilter, null | VAPI.TimeFlows.PTPSourceTypeFilter, null | VAPI.TimeFlows.PTPSourceTypeFilter, null | VAPI.TimeFlows.PTPSourceTypeFilter, VAPI.AT1101.TimeFlows.Combinator>;
        get drift_reference(): VScript.rwKeyword<VScript.VSocket, VAPI.Time.ReferenceFrame, VAPI.Time.ReferenceFrame, VAPI.Time.ReferenceFrame, VAPI.Time.ReferenceFrame, VAPI.AT1101.TimeFlows.Combinator>;
        get min_drift_tolerance(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.TimeFlows.Combinator>;
        get min_offset_tolerance(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.TimeFlows.Combinator>;
        get quorum(): VScript.dKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.TimeFlows.Combinator>;
        get session_length(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.TimeFlows.Combinator>;
        get selected(): VScript.rKeyword<VScript.VSocket, Array<boolean>, Array<boolean>, VAPI.AT1101.TimeFlows.Combinator>;
        get t_src(): VScript.dKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VAPI.AT1101.Time.Source>, VScript.MaybeSparseArray<null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>>, VAPI.AT1101.TimeFlows.Combinator>;
        get output(): VAPI.AT1101.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class CombinatorAsNamedTableRow extends Combinator {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Detonator implements VScript.Referenceable<"TimeFlows::Data::Detonator"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::Detonator";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get max_drift_blast(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.TimeFlows.Detonator>;
        get max_offset_blast(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.TimeFlows.Detonator>;
        /**
          Discharge
        */
        get discharge(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.TimeFlows.Detonator>;
        /**
          Realign
        */
        get realign(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.TimeFlows.Detonator>;
        get friction(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.TimeFlows.Detonator>;
        get stiffness(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.TimeFlows.Detonator>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.TimeFlows.Detonator>;
        get output(): VAPI.AT1101.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class DetonatorAsNamedTableRow extends Detonator {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class DriftConverter implements VScript.Referenceable<"TimeFlows::Data::DriftConverter"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::DriftConverter";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get drift_reference(): VScript.rwKeyword<VScript.VSocket, VAPI.Time.ReferenceFrame, VAPI.Time.ReferenceFrame, VAPI.Time.ReferenceFrame, VAPI.Time.ReferenceFrame, VAPI.AT1101.TimeFlows.DriftConverter>;
        /**
          ideally, all inputs to a clock combinator should use the same reference
          frame as the clock combinator itself. If this is not the case,
          mismatching inputs will be discarded by default. By setting
          `on_reference_frame_mismatch` to `Convert`, inputs can also be converted
          to the combinator's own reference frame. Note, however, that this
          generally incurs a loss in precision
        */
        get on_drift_reference_mismatch(): VScript.rwKeyword<VScript.VSocket, VAPI.TimeFlows.ReferenceFrameMismatchPolicy, VAPI.TimeFlows.ReferenceFrameMismatchPolicy, VAPI.TimeFlows.ReferenceFrameMismatchPolicy, VAPI.TimeFlows.ReferenceFrameMismatchPolicy, VAPI.AT1101.TimeFlows.DriftConverter>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.TimeFlows.DriftConverter>;
        get output(): VAPI.AT1101.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class DriftConverterAsNamedTableRow extends DriftConverter {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Impostor implements VScript.Referenceable<"TimeFlows::Data::Impostor"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::Impostor";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.TimeFlows.Impostor>;
        /**
          Insert specified `grain_rate`, or upgrade input to absolute time source
          if null
        */
        get grain_rate(): VScript.rwKeyword<VScript.VSocket, null | VAPI.Time.GrainRate, null | VAPI.Time.GrainRate, null | VAPI.Time.GrainRate, null | VAPI.Time.GrainRate, VAPI.AT1101.TimeFlows.Impostor>;
        get output(): VAPI.AT1101.Time.Source;
    }
    class ImpostorAsNamedTableRow extends Impostor {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Selector implements VScript.Referenceable<"TimeFlows::Data::Selector"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::Selector";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get selected(): VScript.rKeyword<VScript.VSocket, Array<boolean>, Array<boolean>, VAPI.AT1101.TimeFlows.Selector>;
        get t_src(): VScript.dKeyword<VScript.VSocket, Array<null | string>, VScript.MaybeSparseArray<null | string>, Array<null | VAPI.AT1101.Time.Source>, VScript.MaybeSparseArray<null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>>, VAPI.AT1101.TimeFlows.Selector>;
        get required_offset_type(): VScript.rwKeyword<VScript.VSocket, null | VAPI.Time.OffsetType, null | VAPI.Time.OffsetType, null | VAPI.Time.OffsetType, null | VAPI.Time.OffsetType, VAPI.AT1101.TimeFlows.Selector>;
        get required_drift_reference(): VScript.rwKeyword<VScript.VSocket, null | VAPI.Time.ReferenceFrame, null | VAPI.Time.ReferenceFrame, null | VAPI.Time.ReferenceFrame, null | VAPI.Time.ReferenceFrame, VAPI.AT1101.TimeFlows.Selector>;
        get required_ptp_source_type(): VScript.rwKeyword<VScript.VSocket, null | VAPI.TimeFlows.PTPSourceTypeFilter, null | VAPI.TimeFlows.PTPSourceTypeFilter, null | VAPI.TimeFlows.PTPSourceTypeFilter, null | VAPI.TimeFlows.PTPSourceTypeFilter, VAPI.AT1101.TimeFlows.Selector>;
        get output(): VAPI.AT1101.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class SelectorAsNamedTableRow extends Selector {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Shifter implements VScript.Referenceable<"TimeFlows::Data::Shifter"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::Shifter";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get shift(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.TimeFlows.Shifter>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.TimeFlows.Shifter>;
        get output(): VAPI.AT1101.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class ShifterAsNamedTableRow extends Shifter {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Stretcher implements VScript.Referenceable<"TimeFlows::Data::Stretcher"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "TimeFlows::Data::Stretcher";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get frequency_shift(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.TimeFlows.Stretcher>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.TimeFlows.Stretcher>;
        get output(): VAPI.AT1101.Time.Source;
        get ptp_traits(): VAPI.PTP.Traits;
    }
    class StretcherAsNamedTableRow extends Stretcher {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
}
export declare namespace UDX {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly UDXOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => UDXOutput;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly UDXOutput: (_x: UDXOutput) => string;
    };
    class All implements VScript.Referenceable<"UDX::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "UDX::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get outputs(): VScript.StronglyTypedTable<VScript.VSocket, "UDX::Data::UDXOutput", UDXOutput>;
        get statistics(): VAPI.UDX.UDXStatistics;
    }
    class UDXOutput implements VScript.Referenceable<"UDX::Data::UDXOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "UDX::Data::UDXOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video_source(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.UDX.UDXOutput>;
        get video_standard(): VScript.rwKeyword<VScript.VSocket, VAPI.UDX.UDXVideoStandard, VAPI.UDX.UDXVideoStandard, VAPI.UDX.UDXVideoStandard, VAPI.UDX.UDXVideoStandard, VAPI.AT1101.UDX.UDXOutput>;
        get aspect_ratio(): VScript.dKeyword<VScript.VSocket, VAPI.UDX.UDXASPECTRATIO, VAPI.UDX.UDXASPECTRATIO, VAPI.UDX.UDXASPECTRATIO, VAPI.UDX.UDXASPECTRATIO, VAPI.AT1101.UDX.UDXOutput>;
        get sd_active_pixels(): VScript.rwKeyword<VScript.VSocket, VAPI.UDX.UDXSDACTIVEWIDTH, VAPI.UDX.UDXSDACTIVEWIDTH, VAPI.UDX.UDXSDACTIVEWIDTH, VAPI.UDX.UDXSDACTIVEWIDTH, VAPI.AT1101.UDX.UDXOutput>;
        get video_full_range(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.UDX.UDXOutput>;
        get on_video_source_lost(): VScript.rwKeyword<VScript.VSocket, VAPI.UDX.UDXSOURCESHOWMODE, VAPI.UDX.UDXSOURCESHOWMODE, VAPI.UDX.UDXSOURCESHOWMODE, VAPI.UDX.UDXSOURCESHOWMODE, VAPI.AT1101.UDX.UDXOutput>;
        get crop(): VAPI.UDX.UDXVideoCrop;
        get transform(): VAPI.UDX.UDXTransform;
        get filter(): VAPI.UDX.UDXFilter;
        get signal(): VAPI.AT1101.Video.Essence;
        get metadata_inserter(): VAPI.AT1101.MetadataProcessor.MetadataInserter;
    }
}
export declare namespace UDXMetadataRequests {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
    };
    const lower: {
        readonly All: (_x: All) => string;
    };
    class All implements VScript.Referenceable<"UDXMetadataRequests::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "UDXMetadataRequests::Data::All";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get requests(): VScript.StronglyTypedTable<VScript.VSocket, "MetadataProcessor::Data::Request", VAPI.AT1101.MetadataProcessor.Request>;
    }
}
export declare namespace Video {
    const lift: {
        readonly Essence: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Essence;
        readonly TimedSource: (_raw: [null | string, null | number | string], _socket: VScript.VSocket) => TimedSource;
    };
    const lower: {
        readonly Essence: (_x: Essence) => string;
        readonly TimedSource: (_x: {
            source: null | VAPI.AT1101.Video.Essence;
            switch_time: null | VAPI.Primitives.Timestamp;
        }, _socket: VScript.VSocket) => [null | string, null | number | string];
    };
    class Essence implements VScript.Referenceable<"Video::Data::Essence"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "Video::Data::Essence";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AT1101.Video.Essence>;
        get standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1101.Video.Essence>;
        get pixel_format(): VScript.rKeyword<VScript.VSocket, [
            null | VAPI.Video.ColorSpace,
            VAPI.Video.BitDepth,
            null | VAPI.Video.TransferCharacteristics,
            VAPI.Video.LuminanceAndColorDifferenceSignal
        ], VAPI.Video.PixelFormat, VAPI.AT1101.Video.Essence>;
        get substream(): VScript.rKeyword<VScript.VSocket, [
            VAPI.Video.SubStream,
            boolean
        ], VAPI.Video.EssenceSubstream, VAPI.AT1101.Video.Essence>;
        get frozen(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.AT1101.Video.Essence>;
        get black(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.AT1101.Video.Essence>;
        get dt_node(): VScript.rKeyword<VScript.VSocket, null | VScript.DeviceTreeNodePayload, null | VScript.DeviceTreeNodePayload, VAPI.AT1101.Video.Essence>;
        /**
          some signal sources, such as RTP audio/video streams, include a
          well-defined offset to the PTP epoch (as seen by the sender). During
          processing, these 'media clocks' may shift (e.g., as signals pass through
          delay elements) or broaden into finite intervals (e.g., as audio channels
          at different offsets to the PTP epoch are combined into a single audio
          essence). Using the `media_clock` keyword, such changes are tracked
          explicitly and forwarded to audio/video transmitters.
        */
        get media_clock(): VAPI.AT1101.Time.Source;
        get afd(): VScript.rKeyword<VScript.VSocket, null | [
            VAPI.Video.AspectRatio,
            number,
            number,
            number,
            number,
            number
        ], null | VAPI.Video.AFD, VAPI.AT1101.Video.Essence>;
        get cc(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.Video.ClosedCaption, VAPI.AT1101.Video.Essence>;
    }
    interface TimedSource {
        source: null | VAPI.AT1101.Video.Essence;
        switch_time: null | VAPI.Primitives.Timestamp;
    }
}
export declare namespace VideoMixer {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly BSLK: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => BSLK;
        readonly BSLKLumaKeyer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => BSLKLumaKeyer;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly BSLK: (_x: BSLK) => string;
        readonly BSLKLumaKeyer: (_x: BSLKLumaKeyer) => string;
    };
    class All implements VScript.Referenceable<"VideoMixer::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoMixer::Data::All";
        get runtime_constants(): {
            readonly num_instances: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get instances(): VScript.StronglyTypedNamedTable<VScript.VSocket, "VideoMixer::Data::BSLK", BSLKAsNamedTableRow>;
    }
    class BSLK implements VScript.Referenceable<"VideoMixer::Data::BSLK"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoMixer::Data::BSLK";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.VideoMixer.BSLKIssues, VAPI.AT1101.VideoMixer.BSLK>;
        get v_src0(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.VideoMixer.BSLK>;
        get v_src1(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.VideoMixer.BSLK>;
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.VideoMixer.BSLK>;
        get phase_target(): VScript.dKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.VideoMixer.BSLK>;
        get in_phase(): VScript.rKeyword<VScript.VSocket, Array<null | number>, Array<null | VScript.Duration>, VAPI.AT1101.VideoMixer.BSLK>;
        get phase_rst_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter16, VAPI.AT1101.VideoMixer.BSLK>;
        get output(): VAPI.AT1101.Video.Essence;
        get reserve_uhd_resources(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.VideoMixer.BSLK>;
        get hw_resources(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AT1101.VideoMixer.BSLK>;
        get mode(): VScript.rwKeyword<VScript.VSocket, VAPI.VideoMixer.BSLKMode, VAPI.VideoMixer.BSLKMode, VAPI.VideoMixer.BSLKMode, VAPI.VideoMixer.BSLKMode, VAPI.AT1101.VideoMixer.BSLK>;
        get luma_keyer(): BSLKLumaKeyer;
        get mixer(): VAPI.VideoMixer.BSLKMixer;
    }
    class BSLKAsNamedTableRow extends BSLK {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class BSLKLumaKeyer implements VScript.Referenceable<"VideoMixer::Data::BSLK::LumaKeyer"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoMixer::Data::BSLK::LumaKeyer";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get v_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.VideoMixer.BSLKLumaKeyer>;
        /**
          Luminance level at and below which everything is transparent
        */
        get clip(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.VideoMixer.BSLKLumaKeyer>;
        /**
          Luminance range above clip to reach full opacity
        */
        get gain(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.VideoMixer.BSLKLumaKeyer>;
        get opacity(): VAPI.VideoMixer.AutoFader;
        /**
          Invert the transparent / opaque ends of the output range
        */
        get invert(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.VideoMixer.BSLKLumaKeyer>;
    }
}
export declare namespace VideoPlayer {
    const lift: {
        readonly Player: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Player;
        readonly PlayerOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => PlayerOutput;
        readonly RelationAudio: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationAudio;
        readonly RelationVideo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationVideo;
        readonly Relations: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Relations;
        readonly Time: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Time;
        readonly RelationAudioFollowers: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationAudioFollowers;
        readonly RelationVideoFollowers: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => RelationVideoFollowers;
    };
    const lower: {
        readonly Player: (_x: Player) => string;
        readonly PlayerOutput: (_x: PlayerOutput) => string;
        readonly RelationAudio: (_x: RelationAudio) => string;
        readonly RelationVideo: (_x: RelationVideo) => string;
        readonly Relations: (_x: Relations) => string;
        readonly Time: (_x: Time) => string;
        readonly RelationAudioFollowers: (_x: RelationAudioFollowers) => string;
        readonly RelationVideoFollowers: (_x: RelationVideoFollowers) => string;
    };
    class Player implements VScript.Referenceable<"VideoPlayer::Data::Player"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::Player";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.VideoPlayer.PlayerIssues, VAPI.AT1101.VideoPlayer.Player>;
        get upload_header(): VAPI.VideoPlayer.UploadHeader;
        get memory_usage(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            [
                null | number,
                null | number
            ],
            null | VAPI.Video.Standard
        ], VAPI.VideoPlayer.MemoryCapacity, VAPI.AT1101.VideoPlayer.Player>;
        get capabilities(): VScript.dKeyword<VScript.VSocket, [
            null | ([0, [number]] | [
                1,
                [number]
            ]),
            [
                boolean,
                ([0, [VAPI.Video.Standard]] | [
                    1,
                    [VAPI.Definitions.Bandwidth]
                ])
            ]
        ], [
            null | ([0, [number]] | [
                1,
                [number]
            ]),
            [
                boolean,
                ([0, [VAPI.Video.Standard]] | [
                    1,
                    [VAPI.Definitions.Bandwidth]
                ])
            ]
        ], VAPI.VideoPlayer.Capabilities, VAPI.VideoPlayer.Capabilities, VAPI.AT1101.VideoPlayer.Player>;
        get gang(): Relations;
        /**
          Restart writer and reader
        */
        get restart(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.VideoPlayer.Player>;
        get output(): PlayerOutput;
    }
    class PlayerAsNamedTableRow extends Player {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class PlayerOutput implements VScript.Referenceable<"VideoPlayer::Data::PlayerOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::PlayerOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get time(): Time;
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.VideoPlayer.PlayerOutput>;
        get control(): VAPI.VideoPlayer.Control;
        get deembedded_audio(): VScript.StronglyTypedArray<VScript.VSocket, "VideoPlayer::Data::GroupSelections", VAPI.VideoPlayer.GroupSelections>;
        get reader(): VScript.StronglyTypedTable<VScript.VSocket, "VideoPlayer::Data::Reader", VAPI.VideoPlayer.Reader>;
        get video(): VAPI.AT1101.Video.Essence;
        get audio(): VAPI.AT1101.Audio.Essence;
    }
    class RelationAudio implements VScript.Referenceable<"VideoPlayer::Data::RelationAudio"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::RelationAudio";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get leader(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.AudioRePlay.Player, null | VScript.Referenceable<"AudioRePlay::Data::Player"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.VideoPlayer.RelationAudio>;
        get followers(): VScript.StronglyTypedTable<VScript.VSocket, "VideoPlayer::Data::RelationAudio::Followers", RelationAudioFollowers>;
    }
    class RelationVideo implements VScript.Referenceable<"VideoPlayer::Data::RelationVideo"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::RelationVideo";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get leader(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.VideoPlayer.Player, null | VScript.Referenceable<"VideoPlayer::Data::Player"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.VideoPlayer.RelationVideo>;
        get followers(): VScript.StronglyTypedTable<VScript.VSocket, "VideoPlayer::Data::RelationVideo::Followers", RelationVideoFollowers>;
    }
    class Relations implements VScript.Referenceable<"VideoPlayer::Data::Relations"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::Relations";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get video(): RelationVideo;
        get audio(): RelationAudio;
    }
    class Time implements VScript.Referenceable<"VideoPlayer::Data::Time"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::Time";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.VideoPlayer.Time>;
    }
    class RelationAudioFollowers implements VScript.Referenceable<"VideoPlayer::Data::RelationAudio::Followers"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::RelationAudio::Followers";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          TODO:
        */
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.AudioRePlay.Player, VAPI.AT1101.VideoPlayer.RelationAudioFollowers>;
    }
    class RelationVideoFollowers implements VScript.Referenceable<"VideoPlayer::Data::RelationVideo::Followers"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoPlayer::Data::RelationVideo::Followers";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        /**
          TODO:
        */
        get wrapped_reference(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.AT1101.VideoPlayer.Player, VAPI.AT1101.VideoPlayer.RelationVideoFollowers>;
    }
}
export declare namespace VideoRePlay {
    const lift: {
        readonly Delay: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Delay;
        readonly DelayOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => DelayOutput;
        readonly Time: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Time;
        readonly Video: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => Video;
        readonly DelayInputs: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => DelayInputs;
    };
    const lower: {
        readonly Delay: (_x: Delay) => string;
        readonly DelayOutput: (_x: DelayOutput) => string;
        readonly Time: (_x: Time) => string;
        readonly Video: (_x: Video) => string;
        readonly DelayInputs: (_x: DelayInputs) => string;
    };
    class Delay implements VScript.Referenceable<"VideoRePlay::Data::Delay"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoRePlay::Data::Delay";
        url(pars?: {
            frame_index?: number;
        }): string;
        stop_and_download(pars?: {
            frame_index?: number;
        }): Promise<ArrayBuffer>;
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.VideoRePlay.DelayIssues, VAPI.AT1101.VideoRePlay.Delay>;
        get memory_usage(): VScript.rKeyword<VScript.VSocket, [
            number,
            number,
            [
                null | number,
                null | number
            ],
            [
                null | number,
                null | number
            ],
            null | VAPI.Video.Standard
        ], VAPI.VideoRePlay.MemoryCapacity, VAPI.AT1101.VideoRePlay.Delay>;
        get capabilities(): VScript.dKeyword<VScript.VSocket, [
            null | ([0, [number]] | [
                1,
                [number]
            ]),
            VAPI.VideoRePlay.DelayMode,
            ([
                0,
                [
                    boolean,
                    ([0, [VAPI.Video.Standard]] | [
                        1,
                        [VAPI.Definitions.Bandwidth]
                    ])
                ]
            ] | [
                1,
                [VAPI.Video.SquareDivisionStandard]
            ])
        ], [
            null | ([0, [number]] | [
                1,
                [number]
            ]),
            VAPI.VideoRePlay.DelayMode,
            ([
                0,
                [
                    boolean,
                    ([0, [VAPI.Video.Standard]] | [
                        1,
                        [VAPI.Definitions.Bandwidth]
                    ])
                ]
            ] | [
                1,
                [VAPI.Video.SquareDivisionStandard]
            ])
        ], VAPI.VideoRePlay.Capabilities, VAPI.VideoRePlay.Capabilities, VAPI.AT1101.VideoRePlay.Delay>;
        /**
          Restart writer and reader
        */
        get restart(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AT1101.VideoRePlay.Delay>;
        get dma(): VAPI.VideoRePlay.DMA;
        get inputs(): VScript.StronglyTypedTable<VScript.VSocket, "VideoRePlay::Data::Delay::Inputs", DelayInputs>;
        get outputs(): VScript.StronglyTypedNamedTable<VScript.VSocket, "VideoRePlay::Data::DelayOutput", DelayOutputAsNamedTableRow>;
    }
    class DelayAsNamedTableRow extends Delay {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class DelayOutput implements VScript.Referenceable<"VideoRePlay::Data::DelayOutput"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoRePlay::Data::DelayOutput";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.VideoRePlay.DelayOutput>;
        get time(): Time;
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.VideoRePlay.DelayOutput>;
        get delay(): VAPI.VideoRePlay.Buffer;
        get deembedded_audio(): VScript.StronglyTypedArray<VScript.VSocket, "VideoRePlay::Data::GroupSelections", VAPI.VideoRePlay.GroupSelections>;
        get reader(): VScript.StronglyTypedTable<VScript.VSocket, "VideoRePlay::Data::Reader", VAPI.VideoRePlay.Reader>;
        get video(): VAPI.AT1101.Video.Essence;
        get audio(): VAPI.AT1101.Audio.Essence;
    }
    class DelayOutputAsNamedTableRow extends DelayOutput {
        readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
        readonly index: number;
        constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
        rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
        row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
        delete(opts?: VScript.CommonWriteOptions): Promise<void>;
    }
    class Time implements VScript.Referenceable<"VideoRePlay::Data::Time"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoRePlay::Data::Time";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get phaser_range(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AT1101.VideoRePlay.Time>;
        get restart_phaser(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.AT1101.VideoRePlay.Time>;
    }
    class Video implements VScript.Referenceable<"VideoRePlay::Data::Video"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoRePlay::Data::Video";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get info(): VAPI.DataRePlay.MemoryInfo;
        get players(): VScript.StronglyTypedNamedTable<VScript.VSocket, "VideoPlayer::Data::Player", VAPI.AT1101.VideoPlayer.PlayerAsNamedTableRow>;
        get delays(): VScript.StronglyTypedNamedTable<VScript.VSocket, "VideoRePlay::Data::Delay", DelayAsNamedTableRow>;
        get statistic(): VAPI.DataRePlay.Statistic;
        get ecc(): VAPI.Memory.ECCMuxStatistics;
        get audio_source_slices(): VScript.StronglyTypedArray<VScript.VSocket, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
    }
    class DelayInputs implements VScript.Referenceable<"VideoRePlay::Data::Delay::Inputs"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoRePlay::Data::Delay::Inputs";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AT1101.VideoRePlay.DelayInputs>;
        get latest_running_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.AT1101.VideoRePlay.DelayInputs>;
        get v_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Video.Essence, null | VScript.Referenceable<"Video::Data::Essence"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.VideoRePlay.DelayInputs>;
        get writer(): VScript.StronglyTypedTable<VScript.VSocket, "VideoRePlay::Data::Writer", VAPI.VideoRePlay.Writer>;
    }
}
export declare namespace VideoSignalGenerator {
    const lift: {
        readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => All;
        readonly VSG: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VSG;
    };
    const lower: {
        readonly All: (_x: All) => string;
        readonly VSG: (_x: VSG) => string;
    };
    class All implements VScript.Referenceable<"VideoSignalGenerator::Data::All"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoSignalGenerator::Data::All";
        get runtime_constants(): {
            readonly num_video_signal_generators: number;
        };
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get instances(): VScript.StronglyTypedArray<VScript.VSocket, "VideoSignalGenerator::Data::VSG", VSG>;
    }
    class VSG implements VScript.Referenceable<"VideoSignalGenerator::Data::VSG"> {
        readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
        readonly type_identifier: "VideoSignalGenerator::Data::VSG";
        constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
        get t_src(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AT1101.Time.Source, null | VScript.Referenceable<"Time::Data::Source"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AT1101.VideoSignalGenerator.VSG>;
        get output(): VAPI.AT1101.Video.Essence;
        get standard(): VScript.dKeyword<VScript.VSocket, VAPI.Video.Standard, VAPI.Video.Standard, VAPI.Video.Standard, VAPI.Video.Standard, VAPI.AT1101.VideoSignalGenerator.VSG>;
        get pattern(): VScript.rwKeyword<VScript.VSocket, VAPI.VideoSignalGenerator.TestPatternSelect, VAPI.VideoSignalGenerator.TestPatternSelect, VAPI.VideoSignalGenerator.TestPatternSelect, VAPI.VideoSignalGenerator.TestPatternSelect, VAPI.AT1101.VideoSignalGenerator.VSG>;
        get cnt0_full(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.VideoSignalGenerator.VSG>;
        get cnt1_full(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.VideoSignalGenerator.VSG>;
        get cnt0_horz(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.VideoSignalGenerator.VSG>;
        get cnt1_horz(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AT1101.VideoSignalGenerator.VSG>;
        get phase(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AT1101.VideoSignalGenerator.VSG>;
        get phase_rst_counter(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.CyclicCounter32, VAPI.AT1101.VideoSignalGenerator.VSG>;
        get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.VideoSignalGenerator.VSGIssues, VAPI.AT1101.VideoSignalGenerator.VSG>;
    }
}
export declare class Root {
    readonly raw: VScript.VSocket;
    readonly audio_gain?: VAPI.AT1101.AudioGain.All;
    readonly audio_mixer?: VAPI.AT1101.AudioMixer.All;
    readonly audio_shuffler?: VAPI.AT1101.AudioShuffler.All;
    readonly audio_signal_generator?: VAPI.AT1101.AudioSignalGenerator.All;
    readonly clos_x_bar?: VAPI.ClosXBar.All;
    readonly cluster?: VAPI.AT1101.Cluster.All;
    readonly color_correction?: VAPI.AT1101.ColorCorrection.All;
    readonly genlock?: VAPI.AT1101.Genlock.All;
    readonly i_o_module?: VAPI.AT1101.IOModule.All;
    readonly j2_k_decoder?: VAPI.AT1101.J2KDecoder.All;
    readonly master_clock: VAPI.AT1101.MasterClock.All;
    readonly metadata_processor?: VAPI.AT1101.MetadataProcessor.All;
    readonly monitoring?: VAPI.AT1101.Monitoring.All;
    readonly multiviewer?: VAPI.Multiviewer.All;
    readonly multiviewer_i_o?: VAPI.AT1101.MultiviewerIO.All;
    readonly network_interfaces: VAPI.AT1101.NetworkInterfaces.All;
    readonly p_cap?: VAPI.AT1101.PCap.All;
    readonly p_t_p_clock: VAPI.AT1101.PTPClock.All;
    readonly p_t_p_flows: VAPI.AT1101.PTPFlows.All;
    readonly r_t_p_metadata_channel?: VAPI.RTPMetadataChannel.All;
    readonly r_t_p_receiver?: VAPI.AT1101.RTPReceiver.All;
    readonly r_t_p_transmitter?: VAPI.AT1101.RTPTransmitter.All;
    readonly re_play?: VAPI.AT1101.RePlay.All;
    readonly sample_rate_converter?: VAPI.AT1101.SampleRateConverter.All;
    readonly software_update: VAPI.SoftwareUpdate.All;
    readonly splitter?: VAPI.AT1101.Splitter.All;
    readonly system: VAPI.AT1101.System.All;
    readonly system_clock: VAPI.AT1101.SystemClock.All;
    readonly time_flows: VAPI.AT1101.TimeFlows.All;
    readonly u_d_x?: VAPI.AT1101.UDX.All;
    readonly u_d_x_metadata_requests?: VAPI.AT1101.UDXMetadataRequests.All;
    readonly video_mixer?: VAPI.AT1101.VideoMixer.All;
    readonly video_signal_generator?: VAPI.AT1101.VideoSignalGenerator.All;
    constructor(raw: VScript.VSocket);
    static adopt(socket: VScript.VSocket): Root;
    close(): Promise<void>;
}
