import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    AFVRef: (_raw) => (new AFVRef(_raw)),
    AllocationMode: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "Samples", value: VAPI.AudioRePlay.lift.SamplesSettings(_raw[1], _socket) };
            case 1: return { variant: "Time", value: VAPI.AudioRePlay.lift.TimeSettings(_raw[1], _socket) };
        }
        ;
    },
    BufferInput: (_raw) => (new BufferInput(_raw)),
    Control: (_raw) => (new Control(_raw)),
    DolbyE: (_raw) => (new DolbyE(_raw)),
    DolbyEDebug: (_raw) => (new DolbyEDebug(_raw)),
    DolbyERef: (_raw) => (new DolbyERef(_raw)),
    DolbyEWriter: (_raw) => (new DolbyEWriter(_raw)),
    DolbyLine: (_raw, _socket) => {
        return {
            earliest: _raw[0] === null ? null : _raw[0],
            earliest_ideal: _raw[1] === null ? null : _raw[1],
            ideal: _raw[2] === null ? null : _raw[2],
            latest_ideal: _raw[3] === null ? null : _raw[3],
            latest: _raw[4] === null ? null : _raw[4],
            calculated: _raw[5] === null ? null : _raw[5]
        };
    },
    InputDebug: (_raw) => (new InputDebug(_raw)),
    OutputDebug: (_raw) => (new OutputDebug(_raw)),
    Reader: (_raw) => (new Reader(_raw)),
    SampleTime: (_raw, _socket) => {
        return {
            samples: _raw[0],
            time: VScript.VAPIHelpers.liftNanoseconds(_raw[1], _socket)
        };
    },
    SamplesSettings: (_raw, _socket) => {
        return {
            samples: _raw[0]
        };
    },
    TimeSettings: (_raw, _socket) => {
        return {
            time: VScript.VAPIHelpers.liftNanoseconds(_raw[0], _socket)
        };
    },
    UploadHeader: (_raw) => (new UploadHeader(_raw)),
    Writer: (_raw) => (new Writer(_raw)),
    BufferCurrentDelay: (_raw, _socket) => {
        return {
            manual_fraction: VScript.VAPIHelpers.liftNanoseconds(_raw[0], _socket),
            afv_fraction: VScript.VAPIHelpers.liftNanoseconds(_raw[1], _socket),
            dolby_e_fraction: VScript.VAPIHelpers.liftNanoseconds(_raw[2], _socket),
            as_samples: _raw[3],
            as_time: VScript.VAPIHelpers.liftNanoseconds(_raw[4], _socket)
        };
    },
    UploadHeaderDate: (_raw, _socket) => {
        return {
            year: _raw[0],
            month: _raw[1],
            day: _raw[2]
        };
    },
    UploadHeaderTimeOfDay: (_raw, _socket) => {
        return {
            hours: _raw[0],
            minutes: _raw[1],
            seconds: _raw[2]
        };
    },
};
export const lower = {
    AFVRef: (_x) => _x.raw.kwl,
    AllocationMode: (_x, _socket) => {
        switch (_x.variant) {
            case "Samples": return [0, VAPI.AudioRePlay.lower.SamplesSettings(_x.value, _socket)];
            case "Time": return [1, VAPI.AudioRePlay.lower.TimeSettings(_x.value, _socket)];
        }
    },
    BufferInput: (_x) => _x.raw.kwl,
    Control: (_x) => _x.raw.kwl,
    DolbyE: (_x) => _x.raw.kwl,
    DolbyEDebug: (_x) => _x.raw.kwl,
    DolbyERef: (_x) => _x.raw.kwl,
    DolbyEWriter: (_x) => _x.raw.kwl,
    DolbyLine: (_x, _socket) => [
        _x.earliest === null ? null : _x.earliest,
        _x.earliest_ideal === null ? null : _x.earliest_ideal,
        _x.ideal === null ? null : _x.ideal,
        _x.latest_ideal === null ? null : _x.latest_ideal,
        _x.latest === null ? null : _x.latest,
        _x.calculated === null ? null : _x.calculated
    ],
    InputDebug: (_x) => _x.raw.kwl,
    OutputDebug: (_x) => _x.raw.kwl,
    Reader: (_x) => _x.raw.kwl,
    SampleTime: (_x, _socket) => [
        _x.samples,
        VScript.VAPIHelpers.lowerNanoseconds(_x.time, _socket)
    ],
    SamplesSettings: (_x, _socket) => [
        _x.samples
    ],
    TimeSettings: (_x, _socket) => [
        VScript.VAPIHelpers.lowerNanoseconds(_x.time, _socket)
    ],
    UploadHeader: (_x) => _x.raw.kwl,
    Writer: (_x) => _x.raw.kwl,
    BufferCurrentDelay: (_x, _socket) => [
        VScript.VAPIHelpers.lowerNanoseconds(_x.manual_fraction, _socket),
        VScript.VAPIHelpers.lowerNanoseconds(_x.afv_fraction, _socket),
        VScript.VAPIHelpers.lowerNanoseconds(_x.dolby_e_fraction, _socket),
        _x.as_samples,
        VScript.VAPIHelpers.lowerNanoseconds(_x.as_time, _socket)
    ],
    UploadHeaderDate: (_x, _socket) => [
        _x.year,
        _x.month,
        _x.day
    ],
    UploadHeaderTimeOfDay: (_x, _socket) => [
        _x.hours,
        _x.minutes,
        _x.seconds
    ],
};
export class AFVRef {
    raw;
    type_identifier = "AudioRePlay::Data::AFVRef";
    constructor(raw) {
        this.raw = raw;
    }
    get transition_mode() {
        return new VScript.rwKeyword(this, "transition_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get audio_late() {
        return new VScript.rwKeyword(this, "audio_late", {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, null);
    }
    get audio_early() {
        return new VScript.rwKeyword(this, "audio_early", {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, null);
    }
}
export class BufferInput {
    raw;
    type_identifier = "AudioRePlay::Data::BufferInput";
    constructor(raw) {
        this.raw = raw;
    }
    get memory_usage() {
        return new VScript.rKeyword(this, "memory_usage", {
            lift: VAPI.DataRePlay.lift.MemoryCapacity,
            lower: VAPI.DataRePlay.lower.MemoryCapacity
        });
    }
    get capacity() {
        return new VScript.dKeyword(this, "capacity", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lift.AllocationMode),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lower.AllocationMode)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lift.AllocationMode),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lower.AllocationMode)
        }, (parent, command) => (void parent, void command, { criterion: "status", validator: (status) => (command === null && status === null) || (command !== null && status !== null) && ((command.variant === 'Samples' && status.variant === 'Samples' && status.value.samples >= command.value.samples) || (command.variant === 'Time' && status.variant === 'Time' && status.value.time.s() >= command.value.time.s())) }));
    }
    get setting() {
        return new VScript.rKeyword(this, "setting", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lift.SampleTime),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lower.SampleTime)
        });
    }
    get frequency() {
        return new VScript.dKeyword(this, "frequency", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get num_channels() {
        return new VScript.dKeyword(this, "num_channels", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class Control {
    raw;
    type_identifier = "AudioRePlay::Data::Control";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Stop
    */
    get stop() {
        return new VScript.wKeyword(this, "stop", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      @brief Play
      @desc Depending on the status of play mode. This command starts a Loop or
      Play
    */
    get play() {
        return new VScript.wKeyword(this, "play", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      @brief PlayMode
      @desc Play: Plays once from start_sample till end_sample Loop: start
      playing from start_sample. Reaching the end_sample rewinds the clip and
      plays from now on in a loop from clip_start to end_sample
    */
    get play_mode() {
        return new VScript.dKeyword(this, "play_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get start_sample() {
        return new VScript.dKeyword(this, "start_sample", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    get end_sample() {
        return new VScript.dKeyword(this, "end_sample", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    get time() {
        return new VScript.rKeyword(this, "time", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
        });
    }
    get motion_status() {
        return new VScript.rKeyword(this, "motion_status", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class DolbyE {
    raw;
    type_identifier = "AudioRePlay::Data::DolbyE";
    constructor(raw) {
        this.raw = raw;
    }
    get run_dolby_e_detector() {
        return new VScript.rwKeyword(this, "run_dolby_e_detector", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get measurement_duration() {
        return new VScript.rwKeyword(this, "measurement_duration", {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        }, null);
    }
}
export class DolbyEDebug {
    raw;
    type_identifier = "AudioRePlay::Data::DolbyEDebug";
    constructor(raw) {
        this.raw = raw;
    }
    get zero_samples_before_header() {
        return new VScript.rKeyword(this, "zero_samples_before_header", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get free_running_counter_header_detected() {
        return new VScript.rKeyword(this, "free_running_counter_header_detected", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
}
export class DolbyERef {
    raw;
    type_identifier = "AudioRePlay::Data::DolbyERef";
    constructor(raw) {
        this.raw = raw;
    }
    get channel_pair() {
        return new VScript.rwKeyword(this, "channel_pair", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get samples() {
        return new VScript.rKeyword(this, "samples", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get time() {
        return new VScript.rKeyword(this, "time", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
        });
    }
    get dolby_e_line() {
        return new VScript.rKeyword(this, "dolby_e_line", {
            lift: VAPI.AudioRePlay.lift.DolbyLine,
            lower: VAPI.AudioRePlay.lower.DolbyLine
        });
    }
}
export class DolbyEWriter {
    raw;
    type_identifier = "AudioRePlay::Data::DolbyEWriter";
    constructor(raw) {
        this.raw = raw;
    }
    get free_running_counter_irq() {
        return new VScript.rKeyword(this, "free_running_counter_irq", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get bits_irq() {
        return new VScript.rKeyword(this, "bits_irq", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get debug() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 2, "debug"), (st, _) => VAPI.AudioRePlay.lift.DolbyEDebug(st));
    }
}
export class InputDebug {
    raw;
    type_identifier = "AudioRePlay::Data::InputDebug";
    constructor(raw) {
        this.raw = raw;
    }
    get writer_id() {
        return new VScript.rKeyword(this, "writer_id", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get writer_v_idx() {
        return new VScript.rKeyword(this, "writer_v_idx", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get start_address() {
        return new VScript.rKeyword(this, "start_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get end_address() {
        return new VScript.rKeyword(this, "end_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get enable() {
        return new VScript.rKeyword(this, "enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class OutputDebug {
    raw;
    type_identifier = "AudioRePlay::Data::OutputDebug";
    constructor(raw) {
        this.raw = raw;
    }
    get reader_id() {
        return new VScript.rKeyword(this, "reader_id", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get reader_v_idx() {
        return new VScript.rKeyword(this, "reader_v_idx", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get loop_start_address() {
        return new VScript.rKeyword(this, "loop_start_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get loop_end_address() {
        return new VScript.rKeyword(this, "loop_end_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get enable() {
        return new VScript.rKeyword(this, "enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get start_address() {
        return new VScript.rKeyword(this, "start_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get start_timestamp() {
        return new VScript.rKeyword(this, "start_timestamp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class Reader {
    raw;
    type_identifier = "AudioRePlay::Data::Reader";
    constructor(raw) {
        this.raw = raw;
    }
    get active() {
        return new VScript.rKeyword(this, "active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get debug() {
        return VAPI.AudioRePlay.lift.OutputDebug(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "debug"));
    }
}
export class UploadHeader {
    raw;
    type_identifier = "AudioRePlay::Data::UploadHeader";
    constructor(raw) {
        this.raw = raw;
    }
    get date() {
        return new VScript.rKeyword(this, "date", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lift.UploadHeaderDate),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lower.UploadHeaderDate)
        });
    }
    get time_of_day() {
        return new VScript.rKeyword(this, "time_of_day", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lift.UploadHeaderTimeOfDay),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lower.UploadHeaderTimeOfDay)
        });
    }
    get channels() {
        return new VScript.rKeyword(this, "channels", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get sample_rate() {
        return new VScript.rKeyword(this, "sample_rate", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get bits_per_sample() {
        return new VScript.rKeyword(this, "bits_per_sample", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get samples() {
        return new VScript.rKeyword(this, "samples", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get time() {
        return new VScript.rKeyword(this, "time", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
        });
    }
}
export class Writer {
    raw;
    type_identifier = "AudioRePlay::Data::Writer";
    constructor(raw) {
        this.raw = raw;
    }
    get active() {
        return new VScript.rKeyword(this, "active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get debug() {
        return VAPI.AudioRePlay.lift.InputDebug(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "debug"));
    }
    get dolby_e_debug() {
        return VAPI.AudioRePlay.lift.DolbyEWriter(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "dolby_e_debug"));
    }
}
export const Enums = {
    TransitionMode: ["Jump", "V_Fade"],
    MotionStatus: ["Stop", "Play", "Loop"],
    Motion: ["Play", "Loop"],
    BufferMode: ["Samples", "Time"]
};
