import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly AlarmConfiguratin: (_raw: [boolean], _socket: VScript.VSocket) => AlarmConfiguratin;
    readonly AlarmConfiguratinWithTiming: (_raw: [boolean, number, number], _socket: VScript.VSocket) => AlarmConfiguratinWithTiming;
    readonly AlarmConfigurationWithTimingAndAudioLevel: (_raw: [boolean, number, number, number], _socket: VScript.VSocket) => AlarmConfigurationWithTimingAndAudioLevel;
    readonly AlarmConfigurationWithVideoStandard: (_raw: [boolean, VAPI.Video.Standard], _socket: VScript.VSocket) => AlarmConfigurationWithVideoStandard;
    readonly ClusterAudioMonitoringObjectAlarmsConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectAlarmsConfiguration;
    readonly ClusterAudioMonitoringObjectAlarmsEnable: (_raw: [boolean, boolean, boolean, boolean, boolean, boolean, boolean], _socket: VScript.VSocket) => ClusterAudioMonitoringObjectAlarmsEnable;
    readonly ClusterAudioMonitoringObjectAlarmsSeverityLevel: (_raw: [number, number, number, number, number, number], _socket: VScript.VSocket) => ClusterAudioMonitoringObjectAlarmsSeverityLevel;
    readonly ClusterAudioMonitoringObjectConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectConfiguration;
    readonly ClusterAudioMonitoringObjectRuntimeAlarms: (_raw: [boolean, boolean, boolean, boolean, boolean, boolean], _socket: VScript.VSocket) => ClusterAudioMonitoringObjectRuntimeAlarms;
    readonly ClusterGlobalMonitoringObjectsParameters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterMonitoringObjects.ClusterGlobalMonitoringObjectsParameters;
    readonly ClusterMetadataMonitoringObjectAlarmsConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectAlarmsConfiguration;
    readonly ClusterMetadataMonitoringObjectAlarmsEnable: (_raw: [boolean, boolean, boolean, boolean], _socket: VScript.VSocket) => ClusterMetadataMonitoringObjectAlarmsEnable;
    readonly ClusterMetadataMonitoringObjectAlarmsSeverityLevel: (_raw: [number, number, number, number], _socket: VScript.VSocket) => ClusterMetadataMonitoringObjectAlarmsSeverityLevel;
    readonly ClusterMetadataMonitoringObjectConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectConfiguration;
    readonly ClusterMetadataMonitoringObjectRuntimeAlarms: (_raw: [boolean, boolean, boolean, boolean], _socket: VScript.VSocket) => ClusterMetadataMonitoringObjectRuntimeAlarms;
    readonly ClusterMonitoringObjectAlarmsEnable: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectAlarmsEnable;
    readonly ClusterMonitoringObjectAlarmsSeverityLevel: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectAlarmsSeverityLevel;
    readonly ClusterMonitoringObjectGlobalConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalConfiguration;
    readonly ClusterMonitoringObjectUserAlarmConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectUserAlarmConfiguration;
    readonly ClusterVideoMonitoringObjectAlarmsConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectAlarmsConfiguration;
    readonly ClusterVideoMonitoringObjectAlarmsEnable: (_raw: [boolean, boolean, boolean, boolean, boolean, boolean], _socket: VScript.VSocket) => ClusterVideoMonitoringObjectAlarmsEnable;
    readonly ClusterVideoMonitoringObjectAlarmsSeverityLevel: (_raw: [number, number, number, number, number], _socket: VScript.VSocket) => ClusterVideoMonitoringObjectAlarmsSeverityLevel;
    readonly ClusterVideoMonitoringObjectConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectConfiguration;
    readonly ClusterVideoMonitoringObjectRuntimeAlarms: (_raw: [boolean, boolean, boolean, boolean, boolean], _socket: VScript.VSocket) => ClusterVideoMonitoringObjectRuntimeAlarms;
    readonly MonitoringObjectChannelID: (_raw: [number, number], _socket: VScript.VSocket) => MonitoringObjectChannelID;
};
export declare const lower: {
    readonly AlarmConfiguratin: (_x: {
        enable: boolean;
    }, _socket: VScript.VSocket) => [boolean];
    readonly AlarmConfiguratinWithTiming: (_x: {
        enable: boolean;
        /**
          How long takes to activate alarm
        */
        activate_duration: VScript.Duration;
        /**
          How long takes to deactivate alarm
        */
        deactivate_duration: VScript.Duration;
    }, _socket: VScript.VSocket) => [boolean, number, number];
    readonly AlarmConfigurationWithTimingAndAudioLevel: (_x: {
        enable: boolean;
        /**
          How long it takes to activate alarm
        */
        activate_duration: VScript.Duration;
        /**
          How long it takes to deactivate alarm
        */
        deactivate_duration: VScript.Duration;
        level: number;
    }, _socket: VScript.VSocket) => [boolean, number, number, number];
    readonly AlarmConfigurationWithVideoStandard: (_x: {
        enable: boolean;
        video_standard: VAPI.Video.Standard;
    }, _socket: VScript.VSocket) => [boolean, VAPI.Video.Standard];
    readonly ClusterAudioMonitoringObjectAlarmsConfiguration: (_x: ClusterAudioMonitoringObjectAlarmsConfiguration) => string;
    readonly ClusterAudioMonitoringObjectAlarmsEnable: (_x: {
        not_assigned_source: boolean;
        lost_source: boolean;
        silent_source: boolean;
        over_range_source: boolean;
        under_range_source: boolean;
        unexpected_source_standard: boolean;
        tally_source: boolean;
    }, _socket: VScript.VSocket) => [boolean, boolean, boolean, boolean, boolean, boolean, boolean];
    readonly ClusterAudioMonitoringObjectAlarmsSeverityLevel: (_x: {
        not_assigned_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
        lost_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
        silent_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
        over_range_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
        under_range_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
        unexpected_source_standard: VAPI.ClusterMonitoringObjects.SeverityLevel;
    }, _socket: VScript.VSocket) => [number, number, number, number, number, number];
    readonly ClusterAudioMonitoringObjectConfiguration: (_x: ClusterAudioMonitoringObjectConfiguration) => string;
    readonly ClusterAudioMonitoringObjectRuntimeAlarms: (_x: {
        not_assigned_source: boolean;
        lost_source: boolean;
        silent_source: boolean;
        over_range_source: boolean;
        under_range_source: boolean;
        unexpected_source_standard: boolean;
    }, _socket: VScript.VSocket) => [boolean, boolean, boolean, boolean, boolean, boolean];
    readonly ClusterGlobalMonitoringObjectsParameters: (_x: ClusterGlobalMonitoringObjectsParameters) => string;
    readonly ClusterMetadataMonitoringObjectAlarmsConfiguration: (_x: ClusterMetadataMonitoringObjectAlarmsConfiguration) => string;
    readonly ClusterMetadataMonitoringObjectAlarmsEnable: (_x: {
        not_assigned_source: boolean;
        lost_source: boolean;
        missing_closed_caption: boolean;
        missing_time_code: boolean;
    }, _socket: VScript.VSocket) => [boolean, boolean, boolean, boolean];
    readonly ClusterMetadataMonitoringObjectAlarmsSeverityLevel: (_x: {
        not_assigned_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
        lost_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
        missing_closed_caption: VAPI.ClusterMonitoringObjects.SeverityLevel;
        missing_time_code: VAPI.ClusterMonitoringObjects.SeverityLevel;
    }, _socket: VScript.VSocket) => [number, number, number, number];
    readonly ClusterMetadataMonitoringObjectConfiguration: (_x: ClusterMetadataMonitoringObjectConfiguration) => string;
    readonly ClusterMetadataMonitoringObjectRuntimeAlarms: (_x: {
        not_assigned_source: boolean;
        lost_source: boolean;
        missing_closed_caption: boolean;
        missing_time_code: boolean;
    }, _socket: VScript.VSocket) => [boolean, boolean, boolean, boolean];
    readonly ClusterMonitoringObjectAlarmsEnable: (_x: ClusterMonitoringObjectAlarmsEnable) => string;
    readonly ClusterMonitoringObjectAlarmsSeverityLevel: (_x: ClusterMonitoringObjectAlarmsSeverityLevel) => string;
    readonly ClusterMonitoringObjectGlobalConfiguration: (_x: ClusterMonitoringObjectGlobalConfiguration) => string;
    readonly ClusterMonitoringObjectUserAlarmConfiguration: (_x: ClusterMonitoringObjectUserAlarmConfiguration) => string;
    readonly ClusterVideoMonitoringObjectAlarmsConfiguration: (_x: ClusterVideoMonitoringObjectAlarmsConfiguration) => string;
    readonly ClusterVideoMonitoringObjectAlarmsEnable: (_x: {
        not_assigned_source: boolean;
        lost_source: boolean;
        frozen_source: boolean;
        black_source: boolean;
        unexpected_source_standard: boolean;
        tally_source: boolean;
    }, _socket: VScript.VSocket) => [boolean, boolean, boolean, boolean, boolean, boolean];
    readonly ClusterVideoMonitoringObjectAlarmsSeverityLevel: (_x: {
        not_assigned_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
        lost_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
        frozen_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
        black_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
        unexpected_source_standard: VAPI.ClusterMonitoringObjects.SeverityLevel;
    }, _socket: VScript.VSocket) => [number, number, number, number, number];
    readonly ClusterVideoMonitoringObjectConfiguration: (_x: ClusterVideoMonitoringObjectConfiguration) => string;
    readonly ClusterVideoMonitoringObjectRuntimeAlarms: (_x: {
        not_assigned_source: boolean;
        lost_source: boolean;
        frozen_source: boolean;
        black_source: boolean;
        unexpected_source_standard: boolean;
    }, _socket: VScript.VSocket) => [boolean, boolean, boolean, boolean, boolean];
    readonly MonitoringObjectChannelID: (_x: {
        id: VAPI.ClusterMonitoringObjects.MonitoringObjectID;
        channel_id: number;
    }, _socket: VScript.VSocket) => [number, number];
};
export type ALARMSMASK = number;
export interface AlarmConfiguratin {
    enable: boolean;
}
export interface AlarmConfiguratinWithTiming {
    enable: boolean;
    /**
      How long takes to activate alarm
    */
    activate_duration: VScript.Duration;
    /**
      How long takes to deactivate alarm
    */
    deactivate_duration: VScript.Duration;
}
export interface AlarmConfigurationWithTimingAndAudioLevel {
    enable: boolean;
    /**
      How long it takes to activate alarm
    */
    activate_duration: VScript.Duration;
    /**
      How long it takes to deactivate alarm
    */
    deactivate_duration: VScript.Duration;
    level: number;
}
export interface AlarmConfigurationWithVideoStandard {
    enable: boolean;
    video_standard: VAPI.Video.Standard;
}
export type COMBINEFUNCTION = "OR" | "AND";
export declare class ClusterAudioMonitoringObjectAlarmsConfiguration implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterAudioMonitoringObjectAlarmsConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterAudioMonitoringObjectAlarmsConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get not_assigned_source(): VScript.rwKeyword<VScript.VSocket, [
        boolean
    ], [
        boolean
    ], VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectAlarmsConfiguration>;
    get lost_source(): VScript.rwKeyword<VScript.VSocket, [
        boolean
    ], [
        boolean
    ], VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectAlarmsConfiguration>;
    get silent_source(): VScript.rwKeyword<VScript.VSocket, [
        boolean,
        number,
        number,
        number
    ], [
        boolean,
        number,
        number,
        number
    ], VAPI.ClusterMonitoringObjects.AlarmConfigurationWithTimingAndAudioLevel, VAPI.ClusterMonitoringObjects.AlarmConfigurationWithTimingAndAudioLevel, VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectAlarmsConfiguration>;
    get over_range_source(): VScript.rwKeyword<VScript.VSocket, [
        boolean,
        number,
        number,
        number
    ], [
        boolean,
        number,
        number,
        number
    ], VAPI.ClusterMonitoringObjects.AlarmConfigurationWithTimingAndAudioLevel, VAPI.ClusterMonitoringObjects.AlarmConfigurationWithTimingAndAudioLevel, VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectAlarmsConfiguration>;
    get under_range_source(): VScript.rwKeyword<VScript.VSocket, [
        boolean,
        number,
        number,
        number
    ], [
        boolean,
        number,
        number,
        number
    ], VAPI.ClusterMonitoringObjects.AlarmConfigurationWithTimingAndAudioLevel, VAPI.ClusterMonitoringObjects.AlarmConfigurationWithTimingAndAudioLevel, VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectAlarmsConfiguration>;
    get unexpected_source_standard(): VScript.rwKeyword<VScript.VSocket, [
        boolean
    ], [
        boolean
    ], VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectAlarmsConfiguration>;
    get tally_source(): VScript.rwKeyword<VScript.VSocket, [
        boolean
    ], [
        boolean
    ], VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectAlarmsConfiguration>;
}
export interface ClusterAudioMonitoringObjectAlarmsEnable {
    not_assigned_source: boolean;
    lost_source: boolean;
    silent_source: boolean;
    over_range_source: boolean;
    under_range_source: boolean;
    unexpected_source_standard: boolean;
    tally_source: boolean;
}
export interface ClusterAudioMonitoringObjectAlarmsSeverityLevel {
    not_assigned_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
    lost_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
    silent_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
    over_range_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
    under_range_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
    unexpected_source_standard: VAPI.ClusterMonitoringObjects.SeverityLevel;
}
export declare class ClusterAudioMonitoringObjectConfiguration implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterAudioMonitoringObjectConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterAudioMonitoringObjectConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get source_id(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterSources.AudioSourceID, VAPI.ClusterSources.AudioSourceID, VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectConfiguration>;
    get channel_id_start(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectConfiguration>;
    get channels_num(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectConfiguration>;
    get channels_combine_function(): VScript.rwKeyword<VScript.VSocket, VAPI.ClusterMonitoringObjects.COMBINEFUNCTION, VAPI.ClusterMonitoringObjects.COMBINEFUNCTION, VAPI.ClusterMonitoringObjects.COMBINEFUNCTION, VAPI.ClusterMonitoringObjects.COMBINEFUNCTION, VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectConfiguration>;
    get alarms(): VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectAlarmsConfiguration;
}
export interface ClusterAudioMonitoringObjectRuntimeAlarms {
    not_assigned_source: boolean;
    lost_source: boolean;
    silent_source: boolean;
    over_range_source: boolean;
    under_range_source: boolean;
    unexpected_source_standard: boolean;
}
export declare class ClusterGlobalMonitoringObjectsParameters implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterGlobalMonitoringObjectsParameters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterGlobalMonitoringObjectsParameters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get severity_levels(): VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectAlarmsSeverityLevel;
}
export declare class ClusterMetadataMonitoringObjectAlarmsConfiguration implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterMetadataMonitoringObjectAlarmsConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterMetadataMonitoringObjectAlarmsConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get not_assigned_source(): VScript.rwKeyword<VScript.VSocket, [
        boolean
    ], [
        boolean
    ], VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectAlarmsConfiguration>;
    get lost_source(): VScript.rwKeyword<VScript.VSocket, [
        boolean
    ], [
        boolean
    ], VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectAlarmsConfiguration>;
    get missing_closed_caption(): VScript.rwKeyword<VScript.VSocket, [
        boolean,
        number,
        number
    ], [
        boolean,
        number,
        number
    ], VAPI.ClusterMonitoringObjects.AlarmConfiguratinWithTiming, VAPI.ClusterMonitoringObjects.AlarmConfiguratinWithTiming, VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectAlarmsConfiguration>;
    get missing_time_code(): VScript.rwKeyword<VScript.VSocket, [
        boolean,
        number,
        number
    ], [
        boolean,
        number,
        number
    ], VAPI.ClusterMonitoringObjects.AlarmConfiguratinWithTiming, VAPI.ClusterMonitoringObjects.AlarmConfiguratinWithTiming, VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectAlarmsConfiguration>;
}
export interface ClusterMetadataMonitoringObjectAlarmsEnable {
    not_assigned_source: boolean;
    lost_source: boolean;
    missing_closed_caption: boolean;
    missing_time_code: boolean;
}
export interface ClusterMetadataMonitoringObjectAlarmsSeverityLevel {
    not_assigned_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
    lost_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
    missing_closed_caption: VAPI.ClusterMonitoringObjects.SeverityLevel;
    missing_time_code: VAPI.ClusterMonitoringObjects.SeverityLevel;
}
export declare class ClusterMetadataMonitoringObjectConfiguration implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterMetadataMonitoringObjectConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterMetadataMonitoringObjectConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get source_id(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterSources.MetadataSourceID, VAPI.ClusterSources.MetadataSourceID, VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectConfiguration>;
    get cc_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.Video.ClosedCaptionMode, VAPI.Video.ClosedCaptionMode, VAPI.Video.ClosedCaptionMode, VAPI.Video.ClosedCaptionMode, VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectConfiguration>;
    get cc_channel(): VScript.rwKeyword<VScript.VSocket, VAPI.Video.ClosedCaptionChannel, VAPI.Video.ClosedCaptionChannel, VAPI.Video.ClosedCaptionChannel, VAPI.Video.ClosedCaptionChannel, VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectConfiguration>;
    get alarms(): VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectAlarmsConfiguration;
}
export interface ClusterMetadataMonitoringObjectRuntimeAlarms {
    not_assigned_source: boolean;
    lost_source: boolean;
    missing_closed_caption: boolean;
    missing_time_code: boolean;
}
export declare class ClusterMonitoringObjectAlarmsEnable implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterMonitoringObjectAlarmsEnable"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterMonitoringObjectAlarmsEnable";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get video(): VScript.rwKeyword<VScript.VSocket, [
        boolean,
        boolean,
        boolean,
        boolean,
        boolean,
        boolean
    ], [
        boolean,
        boolean,
        boolean,
        boolean,
        boolean,
        boolean
    ], VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectAlarmsEnable, VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectAlarmsEnable, VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectAlarmsEnable>;
    get audio(): VScript.rwKeyword<VScript.VSocket, [
        boolean,
        boolean,
        boolean,
        boolean,
        boolean,
        boolean,
        boolean
    ], [
        boolean,
        boolean,
        boolean,
        boolean,
        boolean,
        boolean,
        boolean
    ], VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectAlarmsEnable, VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectAlarmsEnable, VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectAlarmsEnable>;
    get metadata(): VScript.rwKeyword<VScript.VSocket, [
        boolean,
        boolean,
        boolean,
        boolean
    ], [
        boolean,
        boolean,
        boolean,
        boolean
    ], VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectAlarmsEnable, VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectAlarmsEnable, VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectAlarmsEnable>;
}
export declare class ClusterMonitoringObjectAlarmsSeverityLevel implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterMonitoringObjectAlarmsSeverityLevel"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterMonitoringObjectAlarmsSeverityLevel";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get video(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number,
        number
    ], VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectAlarmsSeverityLevel, VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectAlarmsSeverityLevel, VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectAlarmsSeverityLevel>;
    get audio(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number,
        number,
        number
    ], VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectAlarmsSeverityLevel, VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectAlarmsSeverityLevel, VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectAlarmsSeverityLevel>;
    get metadata(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number
    ], VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectAlarmsSeverityLevel, VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectAlarmsSeverityLevel, VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectAlarmsSeverityLevel>;
}
export declare class ClusterMonitoringObjectGlobalConfiguration implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterMonitoringObjectGlobalConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterMonitoringObjectGlobalConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get video(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterMonitoringObjects::Data::ClusterVideoMonitoringObjectConfiguration", VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectConfiguration>;
    get audio(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterMonitoringObjects::Data::ClusterAudioMonitoringObjectConfiguration", VAPI.ClusterMonitoringObjects.ClusterAudioMonitoringObjectConfiguration>;
    get metadata(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterMonitoringObjects::Data::ClusterMetadataMonitoringObjectConfiguration", VAPI.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectConfiguration>;
    get user_alarms_enable(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalConfiguration>;
    get user_alarms(): VScript.StronglyTypedArray<VScript.VSocket, "ClusterMonitoringObjects::Data::ClusterMonitoringObjectUserAlarmConfiguration", VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectUserAlarmConfiguration>;
}
export declare class ClusterMonitoringObjectGlobalConfigurationAsNamedTableRow extends ClusterMonitoringObjectGlobalConfiguration {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export declare class ClusterMonitoringObjectUserAlarmConfiguration implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterMonitoringObjectUserAlarmConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterMonitoringObjectUserAlarmConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get enable(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectUserAlarmConfiguration>;
    get severity_level(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterMonitoringObjects.SeverityLevel, VAPI.ClusterMonitoringObjects.SeverityLevel, VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectUserAlarmConfiguration>;
    get label(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectUserAlarmConfiguration>;
}
export declare class ClusterVideoMonitoringObjectAlarmsConfiguration implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterVideoMonitoringObjectAlarmsConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterVideoMonitoringObjectAlarmsConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get not_assigned_source(): VScript.rwKeyword<VScript.VSocket, [
        boolean
    ], [
        boolean
    ], VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectAlarmsConfiguration>;
    get lost_source(): VScript.rwKeyword<VScript.VSocket, [
        boolean
    ], [
        boolean
    ], VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectAlarmsConfiguration>;
    get frozen_source(): VScript.rwKeyword<VScript.VSocket, [
        boolean,
        number,
        number
    ], [
        boolean,
        number,
        number
    ], VAPI.ClusterMonitoringObjects.AlarmConfiguratinWithTiming, VAPI.ClusterMonitoringObjects.AlarmConfiguratinWithTiming, VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectAlarmsConfiguration>;
    get black_source(): VScript.rwKeyword<VScript.VSocket, [
        boolean,
        number,
        number
    ], [
        boolean,
        number,
        number
    ], VAPI.ClusterMonitoringObjects.AlarmConfiguratinWithTiming, VAPI.ClusterMonitoringObjects.AlarmConfiguratinWithTiming, VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectAlarmsConfiguration>;
    get unexpected_source_standard(): VScript.rwKeyword<VScript.VSocket, [
        boolean,
        VAPI.Video.Standard
    ], [
        boolean,
        VAPI.Video.Standard
    ], VAPI.ClusterMonitoringObjects.AlarmConfigurationWithVideoStandard, VAPI.ClusterMonitoringObjects.AlarmConfigurationWithVideoStandard, VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectAlarmsConfiguration>;
    get tally_source(): VScript.rwKeyword<VScript.VSocket, [
        boolean
    ], [
        boolean
    ], VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.AlarmConfiguratin, VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectAlarmsConfiguration>;
}
export interface ClusterVideoMonitoringObjectAlarmsEnable {
    not_assigned_source: boolean;
    lost_source: boolean;
    frozen_source: boolean;
    black_source: boolean;
    unexpected_source_standard: boolean;
    tally_source: boolean;
}
export interface ClusterVideoMonitoringObjectAlarmsSeverityLevel {
    not_assigned_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
    lost_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
    frozen_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
    black_source: VAPI.ClusterMonitoringObjects.SeverityLevel;
    unexpected_source_standard: VAPI.ClusterMonitoringObjects.SeverityLevel;
}
export declare class ClusterVideoMonitoringObjectConfiguration implements VScript.Referenceable<"ClusterMonitoringObjects::Data::ClusterVideoMonitoringObjectConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterMonitoringObjects::Data::ClusterVideoMonitoringObjectConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get source_id(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterSources.VideoSourceID, VAPI.ClusterSources.VideoSourceID, VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectConfiguration>;
    get alarms(): VAPI.ClusterMonitoringObjects.ClusterVideoMonitoringObjectAlarmsConfiguration;
}
export interface ClusterVideoMonitoringObjectRuntimeAlarms {
    not_assigned_source: boolean;
    lost_source: boolean;
    frozen_source: boolean;
    black_source: boolean;
    unexpected_source_standard: boolean;
}
export interface MonitoringObjectChannelID {
    id: VAPI.ClusterMonitoringObjects.MonitoringObjectID;
    channel_id: number;
}
export type MonitoringObjectID = number;
export type SeverityLevel = number;
export type TIMECODE = "LTC" | "VTC1" | "VTC2";
export type TUnsignedMax = number;
export declare const Enums: {
    readonly TIMECODE: TIMECODE[];
    readonly COMBINEFUNCTION: COMBINEFUNCTION[];
};
