import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    ClusterNodeGlobalConfiguration: (_raw) => (new ClusterNodeGlobalConfiguration(_raw)),
    ClusterNodeGlobalRuntime: (_raw) => (new ClusterNodeGlobalRuntime(_raw)),
    ClusterNodeGlobalRuntimeConfiguration: (_raw) => (new ClusterNodeGlobalRuntimeConfiguration(_raw)),
    ClusterNodeGlobalRuntimeMcastCtrlStatistics: (_raw) => (new ClusterNodeGlobalRuntimeMcastCtrlStatistics(_raw)),
    ClusterNodeGlobalRuntimeStreamingPortConfiguration: (_raw) => (new ClusterNodeGlobalRuntimeStreamingPortConfiguration(_raw)),
    ClusterNodePortEgress: (_raw) => (new ClusterNodePortEgress(_raw)),
    ClusterNodePortIngress: (_raw) => (new ClusterNodePortIngress(_raw)),
    ClusterNodePortLLDPInfo: (_raw) => (new ClusterNodePortLLDPInfo(_raw)),
};
export const lower = {
    ClusterNodeGlobalConfiguration: (_x) => _x.raw.kwl,
    ClusterNodeGlobalRuntime: (_x) => _x.raw.kwl,
    ClusterNodeGlobalRuntimeConfiguration: (_x) => _x.raw.kwl,
    ClusterNodeGlobalRuntimeMcastCtrlStatistics: (_x) => _x.raw.kwl,
    ClusterNodeGlobalRuntimeStreamingPortConfiguration: (_x) => _x.raw.kwl,
    ClusterNodePortEgress: (_x) => _x.raw.kwl,
    ClusterNodePortIngress: (_x) => _x.raw.kwl,
    ClusterNodePortLLDPInfo: (_x) => _x.raw.kwl,
};
export class ClusterNodeGlobalConfiguration {
    raw;
    type_identifier = "ClusterNodes::Data::ClusterNodeGlobalConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get mode() {
        return new VScript.rwKeyword(this, "mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      IP address of the cluster node control
    */
    get ctrl_ip_address() {
        return new VScript.rwKeyword(this, "ctrl_ip_address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    get route_outputs_enable() {
        return new VScript.rwKeyword(this, "route_outputs_enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ClusterNodeGlobalConfigurationAsNamedTableRow extends ClusterNodeGlobalConfiguration {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export class ClusterNodeGlobalRuntime {
    raw;
    type_identifier = "ClusterNodes::Data::ClusterNodeGlobalRuntime";
    constructor(raw) {
        this.raw = raw;
    }
    get connection_status() {
        return new VScript.rKeyword(this, "connection_status", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get multicast_connection_status() {
        return new VScript.rKeyword(this, "multicast_connection_status", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get configuration() {
        return VAPI.ClusterNodes.lift.ClusterNodeGlobalRuntimeConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "configuration"));
    }
    get routed_sources() {
        return VAPI.ClusterSources.lift.ClusterSourcesLocalRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "routed_sources"));
    }
    get routed_processors() {
        return VAPI.ClusterProcessors.lift.ClusterProcessorsLocalConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "routed_processors"));
    }
    get streaming_ports() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 5, "streaming_ports"), (st, _) => VAPI.ClusterNodes.lift.ClusterNodeGlobalRuntimeStreamingPortConfiguration(st));
    }
    get mcast_ctrl_sequence_number_error() {
        return VAPI.ClusterNodes.lift.ClusterNodeGlobalRuntimeMcastCtrlStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "mcast_ctrl_sequence_number_error"));
    }
}
export class ClusterNodeGlobalRuntimeConfiguration {
    raw;
    type_identifier = "ClusterNodes::Data::ClusterNodeGlobalRuntimeConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get sdi_inputs_num() {
        return new VScript.rKeyword(this, "sdi_inputs_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get sdi_outputs_num() {
        return new VScript.rKeyword(this, "sdi_outputs_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mipmaps_dual_input_stages_num() {
        return new VScript.rKeyword(this, "mipmaps_dual_input_stages_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class ClusterNodeGlobalRuntimeMcastCtrlStatistics {
    raw;
    type_identifier = "ClusterNodes::Data::ClusterNodeGlobalRuntimeMcastCtrlStatistics";
    constructor(raw) {
        this.raw = raw;
    }
    get video_alarms() {
        return new VScript.rKeyword(this, "video_alarms", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get video_standard() {
        return new VScript.rKeyword(this, "video_standard", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get video_mip_maps_src_i_p_addresses() {
        return new VScript.rKeyword(this, "video_mip_maps_src_i_p_addresses", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get video_tally() {
        return new VScript.rKeyword(this, "video_tally", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get video_lifeness() {
        return new VScript.rKeyword(this, "video_lifeness", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get video_routing() {
        return new VScript.rKeyword(this, "video_routing", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get audio_alarms() {
        return new VScript.rKeyword(this, "audio_alarms", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get audio_p_p_ms() {
        return new VScript.rKeyword(this, "audio_p_p_ms", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get audio_tally() {
        return new VScript.rKeyword(this, "audio_tally", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get audio_lifeness() {
        return new VScript.rKeyword(this, "audio_lifeness", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get metadata_alarms() {
        return new VScript.rKeyword(this, "metadata_alarms", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get metadata_lifeness() {
        return new VScript.rKeyword(this, "metadata_lifeness", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get metadata_time_code() {
        return new VScript.rKeyword(this, "metadata_time_code", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get metadata_closed_caption() {
        return new VScript.rKeyword(this, "metadata_closed_caption", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      Clear
    */
    get clear() {
        return new VScript.wKeyword(this, "clear", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ClusterNodeGlobalRuntimeStreamingPortConfiguration {
    raw;
    type_identifier = "ClusterNodes::Data::ClusterNodeGlobalRuntimeStreamingPortConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get max_bandwidth() {
        return new VScript.rKeyword(this, "max_bandwidth", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      Streaming Port IP address
    */
    get ip_address() {
        return new VScript.rKeyword(this, "ip_address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get lldp_info() {
        return VAPI.ClusterNodes.lift.ClusterNodePortLLDPInfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "lldp_info"));
    }
    get ingress() {
        return VAPI.ClusterNodes.lift.ClusterNodePortIngress(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "ingress"));
    }
    get egress() {
        return VAPI.ClusterNodes.lift.ClusterNodePortEgress(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "egress"));
    }
}
export class ClusterNodePortEgress {
    raw;
    type_identifier = "ClusterNodes::Data::ClusterNodePortEgress";
    constructor(raw) {
        this.raw = raw;
    }
    get video() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "video"), (raw, _) => VAPI.ClusterSources.lift.ClusterVideoSourceID(raw));
    }
}
export class ClusterNodePortIngress {
    raw;
    type_identifier = "ClusterNodes::Data::ClusterNodePortIngress";
    constructor(raw) {
        this.raw = raw;
    }
    get video() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "video"), (raw, _) => VAPI.ClusterSources.lift.ClusterVideoSourceID(raw));
    }
    get audio() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "audio"), (raw, _) => VAPI.ClusterSources.lift.ClusterAudioSourceID(raw));
    }
    get metadata() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "metadata"), (raw, _) => VAPI.ClusterSources.lift.ClusterMetadataSourceID(raw));
    }
}
export class ClusterNodePortLLDPInfo {
    raw;
    type_identifier = "ClusterNodes::Data::ClusterNodePortLLDPInfo";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      MAC address, stored in big-endian order.
    */
    get chassis_id() {
        return new VScript.rKeyword(this, "chassis_id", {
            lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
        });
    }
    /**
      MAC address, stored in big-endian order.
    */
    get port_id() {
        return new VScript.rKeyword(this, "port_id", {
            lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
        });
    }
    get interface_name() {
        return new VScript.rKeyword(this, "interface_name", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export const Enums = {
    NODEMODE: ["MASTER", "SLAVE"],
    NODECONNECTIONSTATUS: ["CONNECTED", "DISCONNECTED"]
};
