import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly MemoryCapacity: (_raw: [number, number], _socket: VScript.VSocket) => MemoryCapacity;
    readonly MemoryInfo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.DataRePlay.MemoryInfo;
    readonly Statistic: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.DataRePlay.Statistic;
};
export declare const lower: {
    readonly MemoryCapacity: (_x: {
        as_pages: VAPI.Primitives.Unsigned16;
        as_bytes: VAPI.Primitives.Unsigned64;
    }, _socket: VScript.VSocket) => [number, number];
    readonly MemoryInfo: (_x: MemoryInfo) => string;
    readonly Statistic: (_x: Statistic) => string;
};
export interface MemoryCapacity {
    as_pages: VAPI.Primitives.Unsigned16;
    as_bytes: VAPI.Primitives.Unsigned64;
}
export declare class MemoryInfo implements VScript.Referenceable<"DataRePlay::Data::MemoryInfo"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "DataRePlay::Data::MemoryInfo";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get page_bits(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.DataRePlay.MemoryInfo>;
    get address_bits(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.DataRePlay.MemoryInfo>;
    get loop_start_address_granularity(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.DataRePlay.MemoryInfo>;
    get data_bits(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.DataRePlay.MemoryInfo>;
    get page_size(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.DataRePlay.MemoryInfo>;
    get total_capacity(): VScript.rKeyword<VScript.VSocket, [
        number,
        number
    ], VAPI.DataRePlay.MemoryCapacity, VAPI.DataRePlay.MemoryInfo>;
    get free(): VScript.rKeyword<VScript.VSocket, [
        number,
        number
    ], VAPI.DataRePlay.MemoryCapacity, VAPI.DataRePlay.MemoryInfo>;
}
export declare class Statistic implements VScript.Referenceable<"DataRePlay::Data::Statistic"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "DataRePlay::Data::Statistic";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get pages_per_instance(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.DataRePlay.Statistic>;
    get max_writer_instance(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.DataRePlay.Statistic>;
    get writer_instance(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Primitives.Unsigned32>, VAPI.DataRePlay.Statistic>;
    get max_read_instance(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.DataRePlay.Statistic>;
    get read_instance(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Primitives.Unsigned32>, VAPI.DataRePlay.Statistic>;
    get memory_map(): VScript.rKeyword<VScript.VSocket, Array<boolean>, Array<boolean>, VAPI.DataRePlay.Statistic>;
}
