import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    TimecodeInserterBlank: (_raw, _socket) => {
        return {};
    },
    VANCAfdInserterBlank: (_raw, _socket) => {
        return {};
    },
    BypassReplaceFlags: (_raw, _socket) => {
        return {
            c_unknown: _raw[0],
            y_334_cea_708_cdp: _raw[1],
            y_334_cea_608: _raw[2],
            y_334_program: _raw[3],
            y_334_data: _raw[4],
            y_334_vbi: _raw[5],
            y_2010_ansi_scte_104: _raw[6],
            y_2031_dvb_scte_vbi: _raw[7],
            y_rdd_8_op_47: _raw[8],
            y_2020_amd: _raw[9],
            y_obs: _raw[10],
            y_unknown: _raw[11]
        };
    },
    TimecodeInserterFreerun: (_raw, _socket) => {
        return {
            enable: VAPI.Definitions.lift.TimecodeInserterFreerunEnable(_raw[0], _socket),
            initial_timecode: VAPI.Definitions.lift.TimecodeInserterFreerunInitialTimecode(_raw[1], _socket)
        };
    },
    LatchControl: (_raw) => (new LatchControl(_raw)),
    NAME: (_raw) => (new NAME(_raw)),
    TimecodeInserterPassthrough: (_raw, _socket) => {
        return {};
    },
    VANCAfdInserterPassthrough: (_raw, _socket) => {
        return {};
    },
    VANCAfdInserterReplace: (_raw, _socket) => {
        return {
            afd: _raw[0] === null ? null : _raw[0]
        };
    },
    VANCAfdInserter: (_raw, _socket) => {
        switch (_raw[0]) {
            case 0: return { variant: "Passthrough", value: VAPI.Definitions.lift.VANCAfdInserterPassthrough(_raw[1], _socket) };
            case 1: return { variant: "Blank", value: VAPI.Definitions.lift.VANCAfdInserterBlank(_raw[1], _socket) };
            case 2: return { variant: "Replace", value: VAPI.Definitions.lift.VANCAfdInserterReplace(_raw[1], _socket) };
        }
        ;
    },
    LatchControlBoundaries: (_raw, _socket) => {
        return {
            attack_time: VScript.VAPIHelpers.liftNanoseconds(_raw[0], _socket),
            mediaclock_late: VScript.VAPIHelpers.liftNanoseconds(_raw[1], _socket),
            mediaclock_early: VScript.VAPIHelpers.liftNanoseconds(_raw[2], _socket)
        };
    },
    TimecodeInserterFreerunEnable: (_raw, _socket) => {
        return {
            ltc: _raw[0],
            vitc: _raw[1]
        };
    },
    TimecodeInserterGeneratorEnable: (_raw, _socket) => {
        return {
            ltc: _raw[0],
            vitc: _raw[1]
        };
    },
    TimecodeInserterFreerunInitialTimecode: (_raw, _socket) => {
        return {
            hours: _raw[0],
            minutes: _raw[1],
            seconds: _raw[2],
            frames: _raw[3]
        };
    },
};
export const lower = {
    TimecodeInserterBlank: (_x, _socket) => [],
    VANCAfdInserterBlank: (_x, _socket) => [],
    BypassReplaceFlags: (_x, _socket) => [
        _x.c_unknown,
        _x.y_334_cea_708_cdp,
        _x.y_334_cea_608,
        _x.y_334_program,
        _x.y_334_data,
        _x.y_334_vbi,
        _x.y_2010_ansi_scte_104,
        _x.y_2031_dvb_scte_vbi,
        _x.y_rdd_8_op_47,
        _x.y_2020_amd,
        _x.y_obs,
        _x.y_unknown
    ],
    TimecodeInserterFreerun: (_x, _socket) => [
        VAPI.Definitions.lower.TimecodeInserterFreerunEnable(_x.enable, _socket),
        VAPI.Definitions.lower.TimecodeInserterFreerunInitialTimecode(_x.initial_timecode, _socket)
    ],
    LatchControl: (_x) => _x.raw.kwl,
    NAME: (_x) => _x.raw.kwl,
    TimecodeInserterPassthrough: (_x, _socket) => [],
    VANCAfdInserterPassthrough: (_x, _socket) => [],
    VANCAfdInserterReplace: (_x, _socket) => [
        _x.afd === null ? null : _x.afd
    ],
    VANCAfdInserter: (_x, _socket) => {
        switch (_x.variant) {
            case "Passthrough": return [0, VAPI.Definitions.lower.VANCAfdInserterPassthrough(_x.value, _socket)];
            case "Blank": return [1, VAPI.Definitions.lower.VANCAfdInserterBlank(_x.value, _socket)];
            case "Replace": return [2, VAPI.Definitions.lower.VANCAfdInserterReplace(_x.value, _socket)];
        }
    },
    LatchControlBoundaries: (_x, _socket) => [
        VScript.VAPIHelpers.lowerNanoseconds(_x.attack_time, _socket),
        VScript.VAPIHelpers.lowerNanoseconds(_x.mediaclock_late, _socket),
        VScript.VAPIHelpers.lowerNanoseconds(_x.mediaclock_early, _socket)
    ],
    TimecodeInserterFreerunEnable: (_x, _socket) => [
        _x.ltc,
        _x.vitc
    ],
    TimecodeInserterGeneratorEnable: (_x, _socket) => [
        _x.ltc,
        _x.vitc
    ],
    TimecodeInserterFreerunInitialTimecode: (_x, _socket) => [
        _x.hours,
        _x.minutes,
        _x.seconds,
        _x.frames
    ],
};
export class LatchControl {
    raw;
    type_identifier = "Definitions::Data::LatchControl";
    constructor(raw) {
        this.raw = raw;
    }
    get mode() {
        return new VScript.dKeyword(this, "mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get boundaries() {
        return new VScript.rwKeyword(this, "boundaries", {
            lift: VAPI.Definitions.lift.LatchControlBoundaries,
            lower: VAPI.Definitions.lower.LatchControlBoundaries
        }, {
            lift: VAPI.Definitions.lift.LatchControlBoundaries,
            lower: VAPI.Definitions.lower.LatchControlBoundaries
        }, null);
    }
}
export class NAME {
    raw;
    type_identifier = "Definitions::Data::NAME";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Is the textual brief
    */
    get brief() {
        return new VScript.dKeyword(this, "brief", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Provides textual information
    */
    get description() {
        return new VScript.dKeyword(this, "description", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export const Enums = {
    VANCAfdCode: ["Code_0010", "Code_0011", "Code_0100", "Code_0101", "Code_0110", "Code_0111", "Code_1000", "Code_1001", "Code_1010", "Code_1011", "Code_1100", "Code_1101", "Code_1110", "Code_1111"],
    TRSEmbedder: ["Embed", "Bypass", "Off"],
    PacketTime: ["p1", "p0_666", "p0_500", "p0_333", "p0_250", "p0_125"],
    LatchMode: ["On_Start", "Continuous"],
    InputTypes: ["SDI", "VidStream", "AudStream", "SRC", "DELAY", "TestTone", "Volume", "Mixer"],
    Bandwidth: ["b1_5Gb", "b3_0Gb", "b12_0Gb"],
    AudioFormat: ["AM824", "L24", "L16"]
};
