import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly Anchor: (_raw: [number | string, number, number], _socket: VScript.VSocket) => Anchor;
    readonly GenlockPosition: (_raw: [[number, number, number, number], [number, number, number, number]], _socket: VScript.VSocket) => GenlockPosition;
    readonly SingleGenlockSettings: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Genlock.SingleGenlockSettings;
};
export declare const lower: {
    readonly Anchor: (_x: {
        t: VAPI.Primitives.Timestamp;
        y: VAPI.Genlock.Samplecount;
        micro_epoch_index: VAPI.Time.MicroEpochIndex;
    }, _socket: VScript.VSocket) => [number | string, number, number];
    readonly GenlockPosition: (_x: {
        drift_from_frc: VAPI.Time.TimestampedDrift;
        offset_from_ptp: VAPI.Time.TimestampedOffset;
    }, _socket: VScript.VSocket) => [[number, number, number, number], [number, number, number, number]];
    readonly SingleGenlockSettings: (_x: SingleGenlockSettings) => string;
};
export interface Anchor {
    t: VAPI.Primitives.Timestamp;
    y: VAPI.Genlock.Samplecount;
    micro_epoch_index: VAPI.Time.MicroEpochIndex;
}
export type AudioClockLane = "a48kHz" | "a96kHz";
export interface GenlockPosition {
    drift_from_frc: VAPI.Time.TimestampedDrift;
    offset_from_ptp: VAPI.Time.TimestampedOffset;
}
export type Samplecount = number;
export declare class SingleGenlockSettings implements VScript.Referenceable<"Genlock::Data::SingleGenlockSettings"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Genlock::Data::SingleGenlockSettings";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get servo(): VScript.dKeyword<VScript.VSocket, [
        [
            [
                number,
                number,
                number,
                number,
                number
            ],
            [
                number,
                number
            ],
            [
                number,
                number,
                number,
                number
            ],
            [
                number,
                number
            ]
        ],
        [
            [
                number,
                number,
                number,
                number,
                number
            ],
            [
                number,
                number
            ],
            [
                number,
                number,
                number,
                number
            ],
            [
                number,
                number
            ]
        ],
        VAPI.Servos.LockingPolicy,
        [
            number,
            number
        ],
        number,
        VAPI.Servos.OnCalibrationTimeout
    ], [
        [
            [
                number,
                number,
                number,
                number,
                number
            ],
            [
                number,
                number
            ],
            [
                number,
                number,
                number,
                number
            ],
            [
                number,
                number
            ]
        ],
        [
            [
                number,
                number,
                number,
                number,
                number
            ],
            [
                number,
                number
            ],
            [
                number,
                number,
                number,
                number
            ],
            [
                number,
                number
            ]
        ],
        VAPI.Servos.LockingPolicy,
        [
            number,
            number
        ],
        number,
        VAPI.Servos.OnCalibrationTimeout
    ], VAPI.Servos.Settings, VAPI.Servos.Settings, VAPI.Genlock.SingleGenlockSettings>;
    get decalibrate_on_input_change(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.Genlock.SingleGenlockSettings>;
}
export type VideoClockLane = "f50_ish" | "f59_ish";
export declare const Enums: {
    readonly VideoClockLane: VideoClockLane[];
    readonly AudioClockLane: AudioClockLane[];
};
