import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly BncMode: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.IOModule.BncMode;
    readonly Constraints: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.IOModule.Constraints;
    readonly EyeShape: (_raw: [null | number, null | number], _socket: VScript.VSocket) => EyeShape;
    readonly MADIOutput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.IOModule.MADIOutput;
    readonly BncModeBnc: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.IOModule.BncModeBnc;
    readonly Configuration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.IOModule.Configuration;
    readonly MergerConnectedTo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.IOModule.MergerConnectedTo;
};
export declare const lower: {
    readonly BncMode: (_x: BncMode) => string;
    readonly Constraints: (_x: Constraints) => string;
    readonly EyeShape: (_x: {
        width: null | number;
        height: null | number;
    }, _socket: VScript.VSocket) => [null | number, null | number];
    readonly MADIOutput: (_x: MADIOutput) => string;
    readonly BncModeBnc: (_x: BncModeBnc) => string;
    readonly Configuration: (_x: Configuration) => string;
    readonly MergerConnectedTo: (_x: MergerConnectedTo) => string;
};
export type Audio12GMode = "st299_2_stream_0" | "st299_1_stream_0_1";
export type BNCDirection = "ceDisable" | "ceIn" | "ceOut" | "ceInOut";
export declare class BncMode implements VScript.Referenceable<"IOModule::Data::BncMode"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "IOModule::Data::BncMode";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get version(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.IOModule.BncMode>;
    get bnc(): VScript.StronglyTypedArray<VScript.VSocket, "IOModule::Data::BncMode::Bnc", VAPI.IOModule.BncModeBnc>;
    get install_version(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.IOModule.BncMode>;
}
export type ClosedCaptionDeembedMode = "CEA708" | "OP47";
export type ConfigDirection = "Input" | "Output";
export declare class Constraints implements VScript.Referenceable<"IOModule::Data::Constraints"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "IOModule::Data::Constraints";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get standard(): VScript.dKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.IOModule.Constraints>;
}
export type DecoderGroupPhyRxCalibrateBusy = "cePhyRxNormal" | "cePhyRxCalibrate";
export type DecoderGroupPhyRxLockedStatus = "Unlocked" | "LockedToRef" | "LockedToData";
export type DecoderGroupPhyRxReady = "ceNotReady" | "ceReady";
export interface EyeShape {
    width: null | number;
    height: null | number;
}
export type MADIChannels = "CH28" | "CH32" | "CH56" | "CH64";
export declare class MADIOutput implements VScript.Referenceable<"IOModule::Data::MADIOutput"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "IOModule::Data::MADIOutput";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get channels(): VScript.dKeyword<VScript.VSocket, VAPI.IOModule.MADIChannels, VAPI.IOModule.MADIChannels, VAPI.IOModule.MADIChannels, VAPI.IOModule.MADIChannels, VAPI.IOModule.MADIOutput>;
}
export type SDIMADIMode = "SDI" | "MADI";
export type SyncOutputStandard = "PAL" | "NTSC" | "HD720p50" | "HD720p59_94" | "HD720p60" | "HD1080p23_98" | "HD1080p24" | "HD1080p25" | "HD1080p29_97" | "HD1080p30" | "HD1080i50" | "HD1080i59_94" | "HD1080i60";
export declare class BncModeBnc implements VScript.Referenceable<"IOModule::Data::BncMode::Bnc"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "IOModule::Data::BncMode::Bnc";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get board(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.IOModule.BncModeBnc>;
    get chip_type(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.IOModule.BncModeBnc>;
    get direction(): VScript.rKeyword<VScript.VSocket, VAPI.IOModule.BNCDirection, VAPI.IOModule.BNCDirection, VAPI.IOModule.BncModeBnc>;
    get frequency(): VScript.rKeyword<VScript.VSocket, VAPI.Video.BNCInputFreq, VAPI.Video.BNCInputFreq, VAPI.IOModule.BncModeBnc>;
}
export declare class Configuration implements VScript.Referenceable<"IOModule::Data::Configuration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "IOModule::Data::Configuration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get direction(): VScript.rwKeyword<VScript.VSocket, VAPI.IOModule.ConfigDirection, VAPI.IOModule.ConfigDirection, VAPI.IOModule.ConfigDirection, VAPI.IOModule.ConfigDirection, VAPI.IOModule.Configuration>;
}
export declare class MergerConnectedTo implements VScript.Referenceable<"IOModule::Data::Merger::ConnectedTo"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "IOModule::Data::Merger::ConnectedTo";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get inputs(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.IOModule.MergerConnectedTo>;
    get input_identifier(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Primitives.Signed32>, VAPI.IOModule.MergerConnectedTo>;
}
export declare const Enums: {
    readonly SyncOutputStandard: SyncOutputStandard[];
    readonly SDIMADIMode: SDIMADIMode[];
    readonly MADIChannels: MADIChannels[];
    readonly DecoderGroupPhyRxReady: DecoderGroupPhyRxReady[];
    readonly DecoderGroupPhyRxLockedStatus: DecoderGroupPhyRxLockedStatus[];
    readonly DecoderGroupPhyRxCalibrateBusy: DecoderGroupPhyRxCalibrateBusy[];
    readonly ConfigDirection: ConfigDirection[];
    readonly ClosedCaptionDeembedMode: ClosedCaptionDeembedMode[];
    readonly BNCDirection: BNCDirection[];
    readonly Audio12GMode: Audio12GMode[];
};
