import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    J2KDecoderStatistics: (_raw) => (new J2KDecoderStatistics(_raw)),
    J2KDecoderAudioRuntime: (_raw) => (new J2KDecoderAudioRuntime(_raw)),
    J2KDecoderConfiguration: (_raw) => (new J2KDecoderConfiguration(_raw)),
    J2KDecoderJ2KRuntime: (_raw) => (new J2KDecoderJ2KRuntime(_raw)),
    J2KDecoderJ2KT2Runtime: (_raw) => (new J2KDecoderJ2KT2Runtime(_raw)),
    J2KDecoderMP2TConfiguration: (_raw) => (new J2KDecoderMP2TConfiguration(_raw)),
    J2KDecoderMPT2Runtime: (_raw) => (new J2KDecoderMPT2Runtime(_raw)),
    J2KDecoderMetadataRuntime: (_raw) => (new J2KDecoderMetadataRuntime(_raw)),
    J2KDecoderRTPConfiguration: (_raw) => (new J2KDecoderRTPConfiguration(_raw)),
    J2KDecoderRTPRuntime: (_raw) => (new J2KDecoderRTPRuntime(_raw)),
    MP2TPES: (_raw) => (new MP2TPES(_raw)),
    TTr01J2kVideoDescriptor: (_raw) => (new TTr01J2kVideoDescriptor(_raw)),
};
export const lower = {
    J2KDecoderStatistics: (_x) => _x.raw.kwl,
    J2KDecoderAudioRuntime: (_x) => _x.raw.kwl,
    J2KDecoderConfiguration: (_x) => _x.raw.kwl,
    J2KDecoderJ2KRuntime: (_x) => _x.raw.kwl,
    J2KDecoderJ2KT2Runtime: (_x) => _x.raw.kwl,
    J2KDecoderMP2TConfiguration: (_x) => _x.raw.kwl,
    J2KDecoderMPT2Runtime: (_x) => _x.raw.kwl,
    J2KDecoderMetadataRuntime: (_x) => _x.raw.kwl,
    J2KDecoderRTPConfiguration: (_x) => _x.raw.kwl,
    J2KDecoderRTPRuntime: (_x) => _x.raw.kwl,
    MP2TPES: (_x) => _x.raw.kwl,
    TTr01J2kVideoDescriptor: (_x) => _x.raw.kwl,
};
export class J2KDecoderStatistics {
    raw;
    type_identifier = "J2KDecoder::Data::J2KDecoderStatistics";
    constructor(raw) {
        this.raw = raw;
    }
    get mem_band_max_gbits() {
        return new VScript.rKeyword(this, "mem_band_max_gbits", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mem_band_write_gbits() {
        return new VScript.rKeyword(this, "mem_band_write_gbits", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mem_band_read_gbits() {
        return new VScript.rKeyword(this, "mem_band_read_gbits", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get t1_total_clks() {
        return new VScript.rKeyword(this, "t1_total_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get t1_active_clks() {
        return new VScript.rKeyword(this, "t1_active_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get t1_load() {
        return new VScript.rKeyword(this, "t1_load", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class J2KDecoderAudioRuntime {
    raw;
    type_identifier = "J2KDecoder::Data::J2KDecoderAudioRuntime";
    constructor(raw) {
        this.raw = raw;
    }
    get dummy() {
        return new VScript.rwKeyword(this, "dummy", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class J2KDecoderConfiguration {
    raw;
    type_identifier = "J2KDecoder::Data::J2KDecoderConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get rtp() {
        return VAPI.J2KDecoder.lift.J2KDecoderRTPConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "rtp"));
    }
    get mp2t() {
        return VAPI.J2KDecoder.lift.J2KDecoderMP2TConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "mp2t"));
    }
}
export class J2KDecoderJ2KRuntime {
    raw;
    type_identifier = "J2KDecoder::Data::J2KDecoderJ2KRuntime";
    constructor(raw) {
        this.raw = raw;
    }
    get t2() {
        return VAPI.J2KDecoder.lift.J2KDecoderJ2KT2Runtime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "t2"));
    }
}
export class J2KDecoderJ2KT2Runtime {
    raw;
    type_identifier = "J2KDecoder::Data::J2KDecoderJ2KT2Runtime";
    constructor(raw) {
        this.raw = raw;
    }
    get packets_num() {
        return new VScript.rKeyword(this, "packets_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class J2KDecoderMP2TConfiguration {
    raw;
    type_identifier = "J2KDecoder::Data::J2KDecoderMP2TConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get pmt_pid() {
        return new VScript.rwKeyword(this, "pmt_pid", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get video_pid() {
        return new VScript.rwKeyword(this, "video_pid", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get pcr_pid() {
        return new VScript.rwKeyword(this, "pcr_pid", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get vanc_pid_1() {
        return new VScript.rwKeyword(this, "vanc_pid_1", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get vanc_pid_2() {
        return new VScript.rwKeyword(this, "vanc_pid_2", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get vanc_pid_3() {
        return new VScript.rwKeyword(this, "vanc_pid_3", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get vanc_pid_4() {
        return new VScript.rwKeyword(this, "vanc_pid_4", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get audio_pid_1() {
        return new VScript.rwKeyword(this, "audio_pid_1", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get audio_pid_2() {
        return new VScript.rwKeyword(this, "audio_pid_2", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get audio_pid_3() {
        return new VScript.rwKeyword(this, "audio_pid_3", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get audio_pid_4() {
        return new VScript.rwKeyword(this, "audio_pid_4", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get audio_pid_5() {
        return new VScript.rwKeyword(this, "audio_pid_5", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get audio_pid_6() {
        return new VScript.rwKeyword(this, "audio_pid_6", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get audio_pid_7() {
        return new VScript.rwKeyword(this, "audio_pid_7", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get audio_pid_8() {
        return new VScript.rwKeyword(this, "audio_pid_8", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class J2KDecoderMPT2Runtime {
    raw;
    type_identifier = "J2KDecoder::Data::J2KDecoderMPT2Runtime";
    constructor(raw) {
        this.raw = raw;
    }
    get p_e_s() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "p_e_s"), (raw, _) => VAPI.J2KDecoder.lift.MP2TPES(raw));
    }
    get j2k_video_descriptor() {
        return VAPI.J2KDecoder.lift.TTr01J2kVideoDescriptor(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "j2k_video_descriptor"));
    }
}
export class J2KDecoderMetadataRuntime {
    raw;
    type_identifier = "J2KDecoder::Data::J2KDecoderMetadataRuntime";
    constructor(raw) {
        this.raw = raw;
    }
    get dummy() {
        return new VScript.rwKeyword(this, "dummy", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class J2KDecoderRTPConfiguration {
    raw;
    type_identifier = "J2KDecoder::Data::J2KDecoderRTPConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get activate() {
        return new VScript.dKeyword(this, "activate", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Primary source input ip address
    */
    get src_ip_address() {
        return new VScript.rwKeyword(this, "src_ip_address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    /**
      Primary destination input ip address
    */
    get dest_ip_address() {
        return new VScript.rwKeyword(this, "dest_ip_address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, (parent, command) => (void parent, void command, { criterion: "status", validator: (status) => VScript.addrs_equal_up_to_port({ command, status }) }));
    }
    /**
      Secondary source input ip address
    */
    get secondary_src_ip_address() {
        return new VScript.rwKeyword(this, "secondary_src_ip_address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    /**
      Secondary destination input ip address
    */
    get secondary_dest_ip_address() {
        return new VScript.rwKeyword(this, "secondary_dest_ip_address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, (parent, command) => (void parent, void command, { criterion: "status", validator: (status) => VScript.addrs_equal_up_to_port({ command, status }) }));
    }
    get use_sdp() {
        return new VScript.rwKeyword(this, "use_sdp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get sdp() {
        return new VScript.rKeyword(this, "sdp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class J2KDecoderRTPRuntime {
    raw;
    type_identifier = "J2KDecoder::Data::J2KDecoderRTPRuntime";
    constructor(raw) {
        this.raw = raw;
    }
    get dummy() {
        return new VScript.rwKeyword(this, "dummy", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class MP2TPES {
    raw;
    type_identifier = "J2KDecoder::Data::MP2TPES";
    constructor(raw) {
        this.raw = raw;
    }
    get type() {
        return new VScript.rKeyword(this, "type", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get pid() {
        return new VScript.rKeyword(this, "pid", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class TTr01J2kVideoDescriptor {
    raw;
    type_identifier = "J2KDecoder::Data::TTr01J2kVideoDescriptor";
    constructor(raw) {
        this.raw = raw;
    }
    get extended_capability_flag() {
        return new VScript.rKeyword(this, "extended_capability_flag", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get profile_and_level() {
        return new VScript.rKeyword(this, "profile_and_level", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get horizontal_size() {
        return new VScript.rKeyword(this, "horizontal_size", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get vertical_size() {
        return new VScript.rKeyword(this, "vertical_size", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get max_bit_rate() {
        return new VScript.rKeyword(this, "max_bit_rate", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get max_buffer_size() {
        return new VScript.rKeyword(this, "max_buffer_size", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get d_e_n_frame_rate() {
        return new VScript.rKeyword(this, "d_e_n_frame_rate", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get n_u_m_frame_rate() {
        return new VScript.rKeyword(this, "n_u_m_frame_rate", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get stripe_flag() {
        return new VScript.rKeyword(this, "stripe_flag", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get block_flag() {
        return new VScript.rKeyword(this, "block_flag", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mdm_flag() {
        return new VScript.rKeyword(this, "mdm_flag", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get color_specification() {
        return new VScript.rKeyword(this, "color_specification", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get still_mode() {
        return new VScript.rKeyword(this, "still_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get interlaced_video() {
        return new VScript.rKeyword(this, "interlaced_video", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get colour_primaries() {
        return new VScript.rKeyword(this, "colour_primaries", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get transfer_characteristics() {
        return new VScript.rKeyword(this, "transfer_characteristics", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get matrix_coefficients() {
        return new VScript.rKeyword(this, "matrix_coefficients", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get video_full_range_flag() {
        return new VScript.rKeyword(this, "video_full_range_flag", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get strp_max_idx() {
        return new VScript.rKeyword(this, "strp_max_idx", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get strp_height() {
        return new VScript.rKeyword(this, "strp_height", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get full_horizontal_size() {
        return new VScript.rKeyword(this, "full_horizontal_size", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get full_vertical_size() {
        return new VScript.rKeyword(this, "full_vertical_size", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get blk_width() {
        return new VScript.rKeyword(this, "blk_width", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get blk_height() {
        return new VScript.rKeyword(this, "blk_height", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get max_blk_idx_h() {
        return new VScript.rKeyword(this, "max_blk_idx_h", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get max_blk_idx_v() {
        return new VScript.rKeyword(this, "max_blk_idx_v", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get blk_idx_h() {
        return new VScript.rKeyword(this, "blk_idx_h", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get blk_idx_v() {
        return new VScript.rKeyword(this, "blk_idx_v", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get x_c0() {
        return new VScript.rKeyword(this, "x_c0", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get y_c0() {
        return new VScript.rKeyword(this, "y_c0", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get x_c1() {
        return new VScript.rKeyword(this, "x_c1", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get y_c1() {
        return new VScript.rKeyword(this, "y_c1", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get x_c2() {
        return new VScript.rKeyword(this, "x_c2", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get y_c2() {
        return new VScript.rKeyword(this, "y_c2", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get x_wp() {
        return new VScript.rKeyword(this, "x_wp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get y_wp() {
        return new VScript.rKeyword(this, "y_wp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get l_max() {
        return new VScript.rKeyword(this, "l_max", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get l_min() {
        return new VScript.rKeyword(this, "l_min", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get max_c_l_l() {
        return new VScript.rKeyword(this, "max_c_l_l", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get max_f_a_l_l() {
        return new VScript.rKeyword(this, "max_f_a_l_l", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
