import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly ALARMSSEVERITYLEVELS: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.ALARMSSEVERITYLEVELS;
    readonly ALARMSEVERITYLEVEL: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.ALARMSEVERITYLEVEL;
    readonly ANALOGCLOCK: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.ANALOGCLOCK;
    readonly AUTOMONITORINGSETTINGS: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.AUTOMONITORINGSETTINGS;
    readonly All: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.All;
    readonly PPMSCALESETTINGSBBCRange: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.PPMSCALESETTINGSBBCRange;
    readonly BORDER: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.BORDER;
    readonly BORDERGEOMETRY: (_raw: [number, number, VAPI.Multiviewer.BORDERRADIUSCORNERS], _socket: VScript.VSocket) => BORDERGEOMETRY;
    readonly BOX: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.BOX;
    readonly CLOCKTIME: (_raw: [number, number, number], _socket: VScript.VSocket) => CLOCKTIME;
    readonly CLOCKTIMESETTINGS: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.CLOCKTIMESETTINGS;
    readonly CLOSEDCAPTION: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.CLOSEDCAPTION;
    readonly CLOSEDCAPTIONPARAMETERS: (_raw: [number, number, number, number], _socket: VScript.VSocket) => CLOSEDCAPTIONPARAMETERS;
    readonly CROP: (_raw: [number, number, number, number], _socket: VScript.VSocket) => CROP;
    readonly DIGITALCLOCK: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.DIGITALCLOCK;
    readonly PPMSCALESETTINGSDINRange: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.PPMSCALESETTINGSDINRange;
    readonly FONT: (_raw: [VAPI.Multiviewer.FONTFAMILY, VAPI.Multiviewer.FONTSTYLE], _socket: VScript.VSocket) => FONT;
    readonly GEOMETRY: (_raw: [number, number, number, number, number], _socket: VScript.VSocket) => GEOMETRY;
    readonly HSLCOLOUR: (_raw: [number, number, number], _socket: VScript.VSocket) => HSLCOLOUR;
    readonly HSLCOLOURWITHOPACITY: (_raw: [number, number, number, number], _socket: VScript.VSocket) => HSLCOLOURWITHOPACITY;
    readonly IMAGE: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.IMAGE;
    readonly LABEL: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.LABEL;
    readonly LABELDUAL: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.LABELDUAL;
    readonly LoadValue: (_raw: [number, number], _socket: VScript.VSocket) => LoadValue;
    readonly MD: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MD;
    readonly MDCELL: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MDCELL;
    readonly ManifoldCoreRasterizerStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.ManifoldCoreRasterizerStatistics;
    readonly ManifoldCoreStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.ManifoldCoreStatistics;
    readonly ManifoldMemoryStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.ManifoldMemoryStatistics;
    readonly MultiviewerGlobal: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MultiviewerGlobal;
    readonly MultiviewerGlobalConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MultiviewerGlobalConfiguration;
    readonly MultiviewerGlobalConfigurationParameters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MultiviewerGlobalConfigurationParameters;
    readonly MultiviewerGlobalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MultiviewerGlobalRuntime;
    readonly MultiviewerHeadGlobalConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MultiviewerHeadGlobalConfiguration;
    readonly MultiviewerHeadGlobalParameters: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MultiviewerHeadGlobalParameters;
    readonly MultiviewerHeadGlobalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MultiviewerHeadGlobalRuntime;
    readonly MultiviewerHeadLayout: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MultiviewerHeadLayout;
    readonly MultiviewerHeadLocalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MultiviewerHeadLocalRuntime;
    readonly MultiviewerHeadStreamingConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MultiviewerHeadStreamingConfiguration;
    readonly MultiviewerLocal: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MultiviewerLocal;
    readonly MultiviewerLocalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MultiviewerLocalRuntime;
    readonly MultiviewerPIPGlobalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MultiviewerPIPGlobalRuntime;
    readonly MultiviewerPIPLocalRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MultiviewerPIPLocalRuntime;
    readonly MultiviewerStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.MultiviewerStatistics;
    readonly PPMSCALESETTINGSNordicRange: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.PPMSCALESETTINGSNordicRange;
    readonly PIP: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.PIP;
    readonly PIPPPM: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.PIPPPM;
    readonly PIPROUTING: (_raw: [number, number, number, number], _socket: VScript.VSocket) => PIPROUTING;
    readonly PIPTALLYRULESSETTINGS: (_raw: [number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number], _socket: VScript.VSocket) => PIPTALLYRULESSETTINGS;
    readonly PIPTALLYSETTINGS: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.PIPTALLYSETTINGS;
    readonly PPMSCALESETTINGS: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.PPMSCALESETTINGS;
    readonly PPMSETTINGS: (_raw: [VAPI.Multiviewer.PPMDisplayMode, VAPI.Multiviewer.PPMScalePosition, VAPI.Multiviewer.PPMScaleType, VAPI.Multiviewer.PEAKHOLDTIME, VAPI.Multiviewer.PEAKHOLDDECAY, VAPI.Multiviewer.PPMDECAY, number, number, number, number, number, number], _socket: VScript.VSocket) => PPMSETTINGS;
    readonly RLBLOCKSTATISTICS: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.RLBLOCKSTATISTICS;
    readonly STANDALONEPPM: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.STANDALONEPPM;
    readonly STOPWATCHCMD: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.STOPWATCHCMD;
    readonly STOPWATCHSETTINGS: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.STOPWATCHSETTINGS;
    readonly TALLYLAMPS: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.TALLYLAMPS;
    readonly TALLYRULE: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.TALLYRULE;
    readonly TALLYRULES: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.TALLYRULES;
    readonly TEXTBOX: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.TEXTBOX;
    readonly TMPREMOVEDFROMPIPStruct: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.TMPREMOVEDFROMPIPStruct;
    readonly PPMSCALESETTINGSDBFSRange: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Multiviewer.PPMSCALESETTINGSDBFSRange;
};
export declare const lower: {
    readonly ALARMSSEVERITYLEVELS: (_x: ALARMSSEVERITYLEVELS) => string;
    readonly ALARMSEVERITYLEVEL: (_x: ALARMSEVERITYLEVEL) => string;
    readonly ANALOGCLOCK: (_x: ANALOGCLOCK) => string;
    readonly AUTOMONITORINGSETTINGS: (_x: AUTOMONITORINGSETTINGS) => string;
    readonly All: (_x: All) => string;
    readonly PPMSCALESETTINGSBBCRange: (_x: PPMSCALESETTINGSBBCRange) => string;
    readonly BORDER: (_x: BORDER) => string;
    readonly BORDERGEOMETRY: (_x: {
        width: number;
        radius: number;
        radius_corners: VAPI.Multiviewer.BORDERRADIUSCORNERS;
    }, _socket: VScript.VSocket) => [number, number, VAPI.Multiviewer.BORDERRADIUSCORNERS];
    readonly BOX: (_x: BOX) => string;
    readonly CLOCKTIME: (_x: {
        seconds: number;
        minutes: number;
        hours: number;
    }, _socket: VScript.VSocket) => [number, number, number];
    readonly CLOCKTIMESETTINGS: (_x: CLOCKTIMESETTINGS) => string;
    readonly CLOSEDCAPTION: (_x: CLOSEDCAPTION) => string;
    readonly CLOSEDCAPTIONPARAMETERS: (_x: {
        width_zoom: number;
        height_zoom: number;
        x_offset: number;
        y_offset: number;
    }, _socket: VScript.VSocket) => [number, number, number, number];
    readonly CROP: (_x: {
        left: VAPI.Multiviewer.WidthZero;
        right: VAPI.Multiviewer.WidthZero;
        top: VAPI.Multiviewer.HeightZero;
        bottom: VAPI.Multiviewer.HeightZero;
    }, _socket: VScript.VSocket) => [number, number, number, number];
    readonly DIGITALCLOCK: (_x: DIGITALCLOCK) => string;
    readonly PPMSCALESETTINGSDINRange: (_x: PPMSCALESETTINGSDINRange) => string;
    readonly FONT: (_x: {
        font_family: VAPI.Multiviewer.FONTFAMILY;
        font_style: VAPI.Multiviewer.FONTSTYLE;
    }, _socket: VScript.VSocket) => [VAPI.Multiviewer.FONTFAMILY, VAPI.Multiviewer.FONTSTYLE];
    readonly GEOMETRY: (_x: {
        posx: VAPI.Multiviewer.VirtualXY;
        posy: VAPI.Multiviewer.VirtualXY;
        width: VAPI.Multiviewer.Width;
        height: VAPI.Multiviewer.Height;
        depth: number;
    }, _socket: VScript.VSocket) => [number, number, number, number, number];
    readonly HSLCOLOUR: (_x: {
        hue: number;
        saturation: number;
        lightness: number;
    }, _socket: VScript.VSocket) => [number, number, number];
    readonly HSLCOLOURWITHOPACITY: (_x: {
        hue: number;
        saturation: number;
        lightness: number;
        opacity: number;
    }, _socket: VScript.VSocket) => [number, number, number, number];
    readonly IMAGE: (_x: IMAGE) => string;
    readonly LABEL: (_x: LABEL) => string;
    readonly LABELDUAL: (_x: LABELDUAL) => string;
    readonly LoadValue: (_x: {
        value: VAPI.Multiviewer.TUnsignedMax;
        percents: VAPI.Multiviewer.TUnsignedMax;
    }, _socket: VScript.VSocket) => [number, number];
    readonly MD: (_x: MD) => string;
    readonly MDCELL: (_x: MDCELL) => string;
    readonly ManifoldCoreRasterizerStatistics: (_x: ManifoldCoreRasterizerStatistics) => string;
    readonly ManifoldCoreStatistics: (_x: ManifoldCoreStatistics) => string;
    readonly ManifoldMemoryStatistics: (_x: ManifoldMemoryStatistics) => string;
    readonly MultiviewerGlobal: (_x: MultiviewerGlobal) => string;
    readonly MultiviewerGlobalConfiguration: (_x: MultiviewerGlobalConfiguration) => string;
    readonly MultiviewerGlobalConfigurationParameters: (_x: MultiviewerGlobalConfigurationParameters) => string;
    readonly MultiviewerGlobalRuntime: (_x: MultiviewerGlobalRuntime) => string;
    readonly MultiviewerHeadGlobalConfiguration: (_x: MultiviewerHeadGlobalConfiguration) => string;
    readonly MultiviewerHeadGlobalParameters: (_x: MultiviewerHeadGlobalParameters) => string;
    readonly MultiviewerHeadGlobalRuntime: (_x: MultiviewerHeadGlobalRuntime) => string;
    readonly MultiviewerHeadLayout: (_x: MultiviewerHeadLayout) => string;
    readonly MultiviewerHeadLocalRuntime: (_x: MultiviewerHeadLocalRuntime) => string;
    readonly MultiviewerHeadStreamingConfiguration: (_x: MultiviewerHeadStreamingConfiguration) => string;
    readonly MultiviewerLocal: (_x: MultiviewerLocal) => string;
    readonly MultiviewerLocalRuntime: (_x: MultiviewerLocalRuntime) => string;
    readonly MultiviewerPIPGlobalRuntime: (_x: MultiviewerPIPGlobalRuntime) => string;
    readonly MultiviewerPIPLocalRuntime: (_x: MultiviewerPIPLocalRuntime) => string;
    readonly MultiviewerStatistics: (_x: MultiviewerStatistics) => string;
    readonly PPMSCALESETTINGSNordicRange: (_x: PPMSCALESETTINGSNordicRange) => string;
    readonly PIP: (_x: PIP) => string;
    readonly PIPPPM: (_x: PIPPPM) => string;
    readonly PIPROUTING: (_x: {
        video_texture_width: number;
        video_texture_height: number;
        video_texture_input_id: number;
        video_texture_input_rl_id: number;
    }, _socket: VScript.VSocket) => [number, number, number, number];
    readonly PIPTALLYRULESSETTINGS: (_x: {
        bgnd_tally_rules_mask: number;
        bgnd_border_tally_rules_mask: number;
        video_border_tally_rules_mask: number;
        umd_0_tally_rules_mask: number;
        umd_0_border_tally_rules_mask: number;
        umd_0_label_tally_rules_mask: number;
        umd_1_tally_rules_mask: number;
        umd_1_border_tally_rules_mask: number;
        umd_1_label_tally_rules_mask: number;
        umd_2_tally_rules_mask: number;
        umd_2_border_tally_rules_mask: number;
        umd_2_label_tally_rules_mask: number;
        omd_0_tally_rules_mask: number;
        omd_0_border_tally_rules_mask: number;
        omd_0_label_tally_rules_mask: number;
        omd_1_tally_rules_mask: number;
        omd_1_border_tally_rules_mask: number;
        omd_1_label_tally_rules_mask: number;
        omd_2_tally_rules_mask: number;
        omd_2_border_tally_rules_mask: number;
        omd_2_label_tally_rules_mask: number;
        left_lamp_tally_rules_mask: number;
        left_lamp_border_tally_rules_mask: number;
        right_lamp_tally_rules_mask: number;
        right_lamp_border_tally_rules_mask: number;
    }, _socket: VScript.VSocket) => [number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number, number];
    readonly PIPTALLYSETTINGS: (_x: PIPTALLYSETTINGS) => string;
    readonly PPMSCALESETTINGS: (_x: PPMSCALESETTINGS) => string;
    readonly PPMSETTINGS: (_x: {
        display_mode: VAPI.Multiviewer.PPMDisplayMode;
        scale_position: VAPI.Multiviewer.PPMScalePosition;
        scale_type: VAPI.Multiviewer.PPMScaleType;
        peak_hold: VAPI.Multiviewer.PEAKHOLDTIME;
        peak_hold_decay: VAPI.Multiviewer.PEAKHOLDDECAY;
        ppm_decay: VAPI.Multiviewer.PPMDECAY;
        width: number;
        opacity: number;
        scale_size: number;
        channel_spacing_size: number;
        leds_size: number;
        leds_spacing_size: number;
    }, _socket: VScript.VSocket) => [VAPI.Multiviewer.PPMDisplayMode, VAPI.Multiviewer.PPMScalePosition, VAPI.Multiviewer.PPMScaleType, VAPI.Multiviewer.PEAKHOLDTIME, VAPI.Multiviewer.PEAKHOLDDECAY, VAPI.Multiviewer.PPMDECAY, number, number, number, number, number, number];
    readonly RLBLOCKSTATISTICS: (_x: RLBLOCKSTATISTICS) => string;
    readonly STANDALONEPPM: (_x: STANDALONEPPM) => string;
    readonly STOPWATCHCMD: (_x: STOPWATCHCMD) => string;
    readonly STOPWATCHSETTINGS: (_x: STOPWATCHSETTINGS) => string;
    readonly TALLYLAMPS: (_x: TALLYLAMPS) => string;
    readonly TALLYRULE: (_x: TALLYRULE) => string;
    readonly TALLYRULES: (_x: TALLYRULES) => string;
    readonly TEXTBOX: (_x: TEXTBOX) => string;
    readonly TMPREMOVEDFROMPIPStruct: (_x: TMPREMOVEDFROMPIPStruct) => string;
    readonly PPMSCALESETTINGSDBFSRange: (_x: PPMSCALESETTINGSDBFSRange) => string;
};
export declare class ALARMSSEVERITYLEVELS implements VScript.Referenceable<"Multiviewer::Data::ALARMSSEVERITYLEVELS"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::ALARMSSEVERITYLEVELS";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get severity_level_0(): VAPI.Multiviewer.ALARMSEVERITYLEVEL;
    get severity_level_1(): VAPI.Multiviewer.ALARMSEVERITYLEVEL;
    get severity_level_2(): VAPI.Multiviewer.ALARMSEVERITYLEVEL;
    get severity_level_3(): VAPI.Multiviewer.ALARMSEVERITYLEVEL;
    get severity_level_4(): VAPI.Multiviewer.ALARMSEVERITYLEVEL;
    get border_width(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.ALARMSSEVERITYLEVELS>;
}
export declare class ALARMSEVERITYLEVEL implements VScript.Referenceable<"Multiviewer::Data::ALARMSEVERITYLEVEL"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::ALARMSEVERITYLEVEL";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get font_colour(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.ALARMSEVERITYLEVEL>;
    get bgnd_colour(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.ALARMSEVERITYLEVEL>;
}
export type ALIGNMENT = "INSIDE" | "OUTSIDE";
export declare class ANALOGCLOCK implements VScript.Referenceable<"Multiviewer::Data::ANALOGCLOCK"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::ANALOGCLOCK";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get display_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.ANALOGCLOCK>;
    get geometry(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.GEOMETRY, VAPI.Multiviewer.GEOMETRY, VAPI.Multiviewer.ANALOGCLOCK>;
    get time_settings(): VAPI.Multiviewer.CLOCKTIMESETTINGS;
    get theme(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.ANALOGCLOCK>;
}
export declare class ANALOGCLOCKAsNamedTableRow extends ANALOGCLOCK {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export declare class AUTOMONITORINGSETTINGS implements VScript.Referenceable<"Multiviewer::Data::AUTOMONITORINGSETTINGS"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::AUTOMONITORINGSETTINGS";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get first_monitoring_object_id(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterMonitoringObjects.MonitoringObjectID, VAPI.ClusterMonitoringObjects.MonitoringObjectID, VAPI.Multiviewer.AUTOMONITORINGSETTINGS>;
    get last_monitoring_object_id(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterMonitoringObjects.MonitoringObjectID, VAPI.ClusterMonitoringObjects.MonitoringObjectID, VAPI.Multiviewer.AUTOMONITORINGSETTINGS>;
}
export declare class All implements VScript.Referenceable<"Multiviewer::Data::All"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::All";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get global(): VAPI.Multiviewer.MultiviewerGlobal;
    get local(): VAPI.Multiviewer.MultiviewerLocal;
}
export declare class PPMSCALESETTINGSBBCRange implements VScript.Referenceable<"Multiviewer::Data::PPMSCALESETTINGS::BBCRange"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::PPMSCALESETTINGS::BBCRange";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get safe_area(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSBBCRange>;
    get operation_area(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSBBCRange>;
    get min_level(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSBBCRange>;
    get max_level(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSBBCRange>;
}
export declare class BORDER implements VScript.Referenceable<"Multiviewer::Data::BORDER"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::BORDER";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get geometry(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        VAPI.Multiviewer.BORDERRADIUSCORNERS
    ], [
        number,
        number,
        VAPI.Multiviewer.BORDERRADIUSCORNERS
    ], VAPI.Multiviewer.BORDERGEOMETRY, VAPI.Multiviewer.BORDERGEOMETRY, VAPI.Multiviewer.BORDER>;
    get colour(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.BORDER>;
}
export interface BORDERGEOMETRY {
    width: number;
    radius: number;
    radius_corners: VAPI.Multiviewer.BORDERRADIUSCORNERS;
}
export type BORDERRADIUSCORNERS = "All" | "Top" | "Bottom" | "Left" | "Right" | "TopLeft" | "TopRight" | "BottomLeft" | "BottomRight";
export declare class BOX implements VScript.Referenceable<"Multiviewer::Data::BOX"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::BOX";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get bgnd_colour(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.BOX>;
    get border(): VAPI.Multiviewer.BORDER;
}
export interface CLOCKTIME {
    seconds: number;
    minutes: number;
    hours: number;
}
export declare class CLOCKTIMESETTINGS implements VScript.Referenceable<"Multiviewer::Data::CLOCKTIMESETTINGS"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::CLOCKTIMESETTINGS";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get metadata_monitoring_object_id(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number
    ], [
        number,
        number
    ], VAPI.ClusterMonitoringObjects.MonitoringObjectChannelID, VAPI.ClusterMonitoringObjects.MonitoringObjectChannelID, VAPI.Multiviewer.CLOCKTIMESETTINGS>;
    get timecode_select(): VScript.rwKeyword<VScript.VSocket, VAPI.ClusterMonitoringObjects.TIMECODE, VAPI.ClusterMonitoringObjects.TIMECODE, VAPI.ClusterMonitoringObjects.TIMECODE, VAPI.ClusterMonitoringObjects.TIMECODE, VAPI.Multiviewer.CLOCKTIMESETTINGS>;
    get timezone_offset(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number
    ], [
        number,
        number,
        number
    ], VAPI.Multiviewer.CLOCKTIME, VAPI.Multiviewer.CLOCKTIME, VAPI.Multiviewer.CLOCKTIMESETTINGS>;
}
export declare class CLOSEDCAPTION implements VScript.Referenceable<"Multiviewer::Data::CLOSEDCAPTION"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::CLOSEDCAPTION";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get enable(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.Multiviewer.CLOSEDCAPTION>;
    get bgnd(): VAPI.Multiviewer.BOX;
    get safe_area(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.CLOSEDCAPTION>;
    get column_offset(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.CLOSEDCAPTION>;
    get row_offset(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.CLOSEDCAPTION>;
    get font_bgnd_opacity(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.CLOSEDCAPTION>;
    get font(): VScript.rwKeyword<VScript.VSocket, [
        VAPI.Multiviewer.FONTFAMILY,
        VAPI.Multiviewer.FONTSTYLE
    ], [
        VAPI.Multiviewer.FONTFAMILY,
        VAPI.Multiviewer.FONTSTYLE
    ], VAPI.Multiviewer.FONT, VAPI.Multiviewer.FONT, VAPI.Multiviewer.CLOSEDCAPTION>;
}
export interface CLOSEDCAPTIONPARAMETERS {
    width_zoom: number;
    height_zoom: number;
    x_offset: number;
    y_offset: number;
}
export interface CROP {
    left: VAPI.Multiviewer.WidthZero;
    right: VAPI.Multiviewer.WidthZero;
    top: VAPI.Multiviewer.HeightZero;
    bottom: VAPI.Multiviewer.HeightZero;
}
export declare class DIGITALCLOCK implements VScript.Referenceable<"Multiviewer::Data::DIGITALCLOCK"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::DIGITALCLOCK";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get display_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DIGITALCLOCK>;
    get geometry(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.GEOMETRY, VAPI.Multiviewer.GEOMETRY, VAPI.Multiviewer.DIGITALCLOCK>;
    get time_settings(): VAPI.Multiviewer.CLOCKTIMESETTINGS;
    get stopwatch(): VAPI.Multiviewer.STOPWATCHSETTINGS;
    get time_format(): VScript.rwKeyword<VScript.VSocket, VAPI.Multiviewer.TIMEFORMAT, VAPI.Multiviewer.TIMEFORMAT, VAPI.Multiviewer.TIMEFORMAT, VAPI.Multiviewer.TIMEFORMAT, VAPI.Multiviewer.DIGITALCLOCK>;
    get bgnd(): VAPI.Multiviewer.BOX;
    get digit_font_colour(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.DIGITALCLOCK>;
    get digit_font(): VScript.rwKeyword<VScript.VSocket, [
        VAPI.Multiviewer.FONTFAMILY,
        VAPI.Multiviewer.FONTSTYLE
    ], [
        VAPI.Multiviewer.FONTFAMILY,
        VAPI.Multiviewer.FONTSTYLE
    ], VAPI.Multiviewer.FONT, VAPI.Multiviewer.FONT, VAPI.Multiviewer.DIGITALCLOCK>;
    get digit_bgnd_colour(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.DIGITALCLOCK>;
}
export declare class DIGITALCLOCKAsNamedTableRow extends DIGITALCLOCK {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export declare class PPMSCALESETTINGSDINRange implements VScript.Referenceable<"Multiviewer::Data::PPMSCALESETTINGS::DINRange"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::PPMSCALESETTINGS::DINRange";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get safe_area(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSDINRange>;
    get operation_area(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSDINRange>;
    get min_level(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSDINRange>;
    get max_level(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSDINRange>;
}
export type DISPLAYMODE = "ON" | "OFF" | "NAME";
export interface FONT {
    font_family: VAPI.Multiviewer.FONTFAMILY;
    font_style: VAPI.Multiviewer.FONTSTYLE;
}
export type FONTFAMILY = "OPEN_SANS" | "DSEG7_Classic" | "DSEG7_Classic_MINI" | "DSEG7_Modern" | "DSEG7_Modern_MINI" | "DSEG14_Classic" | "DSEG14_Classic_MINI" | "DSEG14_Modern" | "DSEG14_Modern_MINI" | "NOTO_SANS_TC" | "NOTO_SANS_MONO" | "FIRA_CODE_MONO";
export type FONTSTYLE = "NORMAL" | "ITALIC" | "BOLD" | "BOLD_ITALIC";
export interface GEOMETRY {
    posx: VAPI.Multiviewer.VirtualXY;
    posy: VAPI.Multiviewer.VirtualXY;
    width: VAPI.Multiviewer.Width;
    height: VAPI.Multiviewer.Height;
    depth: number;
}
export type HEADLAYOUTMODE = "MANUAL" | "AUTO" | "AUTO_MONITORING" | "PATTERN_ID";
export interface HSLCOLOUR {
    hue: number;
    saturation: number;
    lightness: number;
}
export interface HSLCOLOURWITHOPACITY {
    hue: number;
    saturation: number;
    lightness: number;
    opacity: number;
}
export type Height = number;
export type HeightZero = number;
export declare class IMAGE implements VScript.Referenceable<"Multiviewer::Data::IMAGE"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::IMAGE";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get display_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.IMAGE>;
    get geometry(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.GEOMETRY, VAPI.Multiviewer.GEOMETRY, VAPI.Multiviewer.IMAGE>;
}
export declare class IMAGEAsNamedTableRow extends IMAGE {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export type Inputs = number;
export declare class LABEL implements VScript.Referenceable<"Multiviewer::Data::LABEL"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::LABEL";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get colour(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.LABEL>;
    get font(): VScript.rwKeyword<VScript.VSocket, [
        VAPI.Multiviewer.FONTFAMILY,
        VAPI.Multiviewer.FONTSTYLE
    ], [
        VAPI.Multiviewer.FONTFAMILY,
        VAPI.Multiviewer.FONTSTYLE
    ], VAPI.Multiviewer.FONT, VAPI.Multiviewer.FONT, VAPI.Multiviewer.LABEL>;
    get string_default(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.Multiviewer.LABEL>;
}
export declare class LABELDUAL implements VScript.Referenceable<"Multiviewer::Data::LABELDUAL"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::LABELDUAL";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get colour(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.LABELDUAL>;
    get font(): VScript.rwKeyword<VScript.VSocket, [
        VAPI.Multiviewer.FONTFAMILY,
        VAPI.Multiviewer.FONTSTYLE
    ], [
        VAPI.Multiviewer.FONTFAMILY,
        VAPI.Multiviewer.FONTSTYLE
    ], VAPI.Multiviewer.FONT, VAPI.Multiviewer.FONT, VAPI.Multiviewer.LABELDUAL>;
    get string_default(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.Multiviewer.LABELDUAL>;
    get string_user(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.Multiviewer.LABELDUAL>;
}
export interface LoadValue {
    value: VAPI.Multiviewer.TUnsignedMax;
    percents: VAPI.Multiviewer.TUnsignedMax;
}
export declare class MD implements VScript.Referenceable<"Multiviewer::Data::MD"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MD";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get enable(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.Multiviewer.MD>;
    get mode(): VScript.rwKeyword<VScript.VSocket, VAPI.Multiviewer.MDMODE, VAPI.Multiviewer.MDMODE, VAPI.Multiviewer.MDMODE, VAPI.Multiviewer.MDMODE, VAPI.Multiviewer.MD>;
    get alignment(): VScript.rwKeyword<VScript.VSocket, VAPI.Multiviewer.ALIGNMENT, VAPI.Multiviewer.ALIGNMENT, VAPI.Multiviewer.ALIGNMENT, VAPI.Multiviewer.ALIGNMENT, VAPI.Multiviewer.MD>;
    get width(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.MD>;
    get height(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.MD>;
    get cells(): VScript.StronglyTypedArray<VScript.VSocket, "Multiviewer::Data::MDCELL", VAPI.Multiviewer.MDCELL>;
}
export declare class MDCELL implements VScript.Referenceable<"Multiviewer::Data::MDCELL"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MDCELL";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get mode(): VScript.rwKeyword<VScript.VSocket, VAPI.Multiviewer.MDCELLMODE, VAPI.Multiviewer.MDCELLMODE, VAPI.Multiviewer.MDCELLMODE, VAPI.Multiviewer.MDCELLMODE, VAPI.Multiviewer.MDCELL>;
    get timecode_select(): VScript.rwKeyword<VScript.VSocket, VAPI.ClusterMonitoringObjects.TIMECODE, VAPI.ClusterMonitoringObjects.TIMECODE, VAPI.ClusterMonitoringObjects.TIMECODE, VAPI.ClusterMonitoringObjects.TIMECODE, VAPI.Multiviewer.MDCELL>;
    get timecode_show_frames(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.Multiviewer.MDCELL>;
    get bgnd(): VAPI.Multiviewer.BOX;
    get label(): VAPI.Multiviewer.LABELDUAL;
}
export type MDCELLMODE = "AUDIO_SOURCE_0_NAME" | "LABEL" | "PIP_NAME" | "METADATA_SOURCE_0_NAME" | "METADATA_SOURCE_0_TIMECODE" | "MONITORING_OBJECT_VIDEO_SOURCE_LABEL" | "MONITORING_OBJECT_USER_LABEL_0" | "MONITORING_OBJECT_USER_LABEL_1" | "MONITORING_OBJECT_USER_LABEL_2" | "MONITORING_OBJECT_USER_LABEL_3" | "MONITORING_OBJECT_USER_LABEL_4" | "MONITORING_OBJECT_USER_LABEL_5" | "VIDEO_SOURCE_LABEL" | "VIDEO_SOURCE_0_NAME" | "VIDEO_STANDARD";
export type MDMODE = "SINGLE" | "DUAL" | "TRIPLE";
export declare class ManifoldCoreRasterizerStatistics implements VScript.Referenceable<"Multiviewer::Data::ManifoldCoreRasterizerStatistics"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::ManifoldCoreRasterizerStatistics";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get clocks_per_frame_active(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreRasterizerStatistics>;
    get pixel_clocks_per_frame(): VScript.rKeyword<VScript.VSocket, [
        number,
        number
    ], VAPI.Multiviewer.LoadValue, VAPI.Multiviewer.ManifoldCoreRasterizerStatistics>;
    get pixels_per_frame(): VScript.rKeyword<VScript.VSocket, [
        number,
        number
    ], VAPI.Multiviewer.LoadValue, VAPI.Multiviewer.ManifoldCoreRasterizerStatistics>;
    get clocks_store_wait_for_memory(): VScript.rKeyword<VScript.VSocket, [
        number,
        number
    ], VAPI.Multiviewer.LoadValue, VAPI.Multiviewer.ManifoldCoreRasterizerStatistics>;
}
export declare class ManifoldCoreStatistics implements VScript.Referenceable<"Multiviewer::Data::ManifoldCoreStatistics"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::ManifoldCoreStatistics";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get sync_length(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get sync_length_throttled(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get sync_refresh_rate(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get sync_refresh_rate_throttled(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get sync_calc_length(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_0_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_1_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_2_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_3_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_4_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_5_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_6_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_7_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get total_primitives_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_0_total_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_1_total_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_2_total_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_3_total_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_4_total_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_5_total_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_6_total_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_7_total_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_0_active_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_1_active_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_2_active_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_3_active_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_4_active_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_5_active_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_6_active_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_7_active_clks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_0_load(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_1_load(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_2_load(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_3_load(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_4_load(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_5_load(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_6_load(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
    get output_7_load(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.ManifoldCoreStatistics>;
}
export declare class ManifoldMemoryStatistics implements VScript.Referenceable<"Multiviewer::Data::ManifoldMemoryStatistics"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::ManifoldMemoryStatistics";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get mem_band_max_gbits(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.Multiviewer.ManifoldMemoryStatistics>;
    get mem_band_write_gbits(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.Multiviewer.ManifoldMemoryStatistics>;
    get mem_band_read_gbits(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.Multiviewer.ManifoldMemoryStatistics>;
    get video_static_rl_blocks(): VScript.StronglyTypedArray<VScript.VSocket, "Multiviewer::Data::RLBLOCKSTATISTICS", VAPI.Multiviewer.RLBLOCKSTATISTICS>;
    get video_dynamic_rl_blocks(): VScript.StronglyTypedArray<VScript.VSocket, "Multiviewer::Data::RLBLOCKSTATISTICS", VAPI.Multiviewer.RLBLOCKSTATISTICS>;
    get graphics_rl_blocks(): VScript.StronglyTypedArray<VScript.VSocket, "Multiviewer::Data::RLBLOCKSTATISTICS", VAPI.Multiviewer.RLBLOCKSTATISTICS>;
}
export declare class MultiviewerGlobal implements VScript.Referenceable<"Multiviewer::Data::MultiviewerGlobal"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MultiviewerGlobal";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get configuration(): VAPI.Multiviewer.MultiviewerGlobalConfiguration;
    get runtime(): VAPI.Multiviewer.MultiviewerGlobalRuntime;
}
export declare class MultiviewerGlobalConfiguration implements VScript.Referenceable<"Multiviewer::Data::MultiviewerGlobalConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MultiviewerGlobalConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get parameters(): VAPI.Multiviewer.MultiviewerGlobalConfigurationParameters;
    get head(): VScript.StronglyTypedNamedTable<VScript.VSocket, "Multiviewer::Data::MultiviewerHeadGlobalConfiguration", VAPI.Multiviewer.MultiviewerHeadGlobalConfigurationAsNamedTableRow>;
}
export declare class MultiviewerGlobalConfigurationParameters implements VScript.Referenceable<"Multiviewer::Data::MultiviewerGlobalConfigurationParameters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MultiviewerGlobalConfigurationParameters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get alarms(): VAPI.Multiviewer.ALARMSSEVERITYLEVELS;
}
export declare class MultiviewerGlobalRuntime implements VScript.Referenceable<"Multiviewer::Data::MultiviewerGlobalRuntime"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MultiviewerGlobalRuntime";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get head(): VScript.StronglyTypedTable<VScript.VSocket, "Multiviewer::Data::MultiviewerHeadGlobalRuntime", VAPI.Multiviewer.MultiviewerHeadGlobalRuntime>;
}
export declare class MultiviewerHeadGlobalConfiguration implements VScript.Referenceable<"Multiviewer::Data::MultiviewerHeadGlobalConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MultiviewerHeadGlobalConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get parameters(): VAPI.Multiviewer.MultiviewerHeadGlobalParameters;
    get pip(): VScript.StronglyTypedNamedTable<VScript.VSocket, "Multiviewer::Data::PIP", VAPI.Multiviewer.PIPAsNamedTableRow>;
    get ppm(): VScript.StronglyTypedNamedTable<VScript.VSocket, "Multiviewer::Data::STANDALONEPPM", VAPI.Multiviewer.STANDALONEPPMAsNamedTableRow>;
    get analog_clock(): VScript.StronglyTypedNamedTable<VScript.VSocket, "Multiviewer::Data::ANALOGCLOCK", VAPI.Multiviewer.ANALOGCLOCKAsNamedTableRow>;
    get digital_clock(): VScript.StronglyTypedNamedTable<VScript.VSocket, "Multiviewer::Data::DIGITALCLOCK", VAPI.Multiviewer.DIGITALCLOCKAsNamedTableRow>;
    get text_box(): VScript.StronglyTypedNamedTable<VScript.VSocket, "Multiviewer::Data::TEXTBOX", VAPI.Multiviewer.TEXTBOXAsNamedTableRow>;
    get image(): VScript.StronglyTypedNamedTable<VScript.VSocket, "Multiviewer::Data::IMAGE", VAPI.Multiviewer.IMAGEAsNamedTableRow>;
}
export declare class MultiviewerHeadGlobalConfigurationAsNamedTableRow extends MultiviewerHeadGlobalConfiguration {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export declare class MultiviewerHeadGlobalParameters implements VScript.Referenceable<"Multiviewer::Data::MultiviewerHeadGlobalParameters"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MultiviewerHeadGlobalParameters";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get display_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.MultiviewerHeadGlobalParameters>;
    get video_standard(): VScript.rwKeyword<VScript.VSocket, VAPI.MultiviewerIO.MultiviewerHeadVideoStandard, VAPI.MultiviewerIO.MultiviewerHeadVideoStandard, VAPI.MultiviewerIO.MultiviewerHeadVideoStandard, VAPI.MultiviewerIO.MultiviewerHeadVideoStandard, VAPI.Multiviewer.MultiviewerHeadGlobalParameters>;
    get double_buffer_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.MultiviewerIO.DOUBLEBUFFERMODE, VAPI.MultiviewerIO.DOUBLEBUFFERMODE, VAPI.MultiviewerIO.DOUBLEBUFFERMODE, VAPI.MultiviewerIO.DOUBLEBUFFERMODE, VAPI.Multiviewer.MultiviewerHeadGlobalParameters>;
    get rotation(): VScript.rwKeyword<VScript.VSocket, VAPI.MultiviewerIO.OUTPUTROTATIONMODE, VAPI.MultiviewerIO.OUTPUTROTATIONMODE, VAPI.MultiviewerIO.OUTPUTROTATIONMODE, VAPI.MultiviewerIO.OUTPUTROTATIONMODE, VAPI.Multiviewer.MultiviewerHeadGlobalParameters>;
    get bgnd_colour(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number
    ], [
        number,
        number,
        number
    ], VAPI.Multiviewer.HSLCOLOUR, VAPI.Multiviewer.HSLCOLOUR, VAPI.Multiviewer.MultiviewerHeadGlobalParameters>;
    get layout(): VAPI.Multiviewer.MultiviewerHeadLayout;
    get ppm_scale(): VAPI.Multiviewer.PPMSCALESETTINGS;
    get tally_rules(): VAPI.Multiviewer.TALLYRULES;
    get streaming(): VAPI.Multiviewer.MultiviewerHeadStreamingConfiguration;
}
export declare class MultiviewerHeadGlobalRuntime implements VScript.Referenceable<"Multiviewer::Data::MultiviewerHeadGlobalRuntime"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MultiviewerHeadGlobalRuntime";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get pip(): VScript.StronglyTypedTable<VScript.VSocket, "Multiviewer::Data::MultiviewerPIPGlobalRuntime", VAPI.Multiviewer.MultiviewerPIPGlobalRuntime>;
}
export declare class MultiviewerHeadLayout implements VScript.Referenceable<"Multiviewer::Data::MultiviewerHeadLayout"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MultiviewerHeadLayout";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get layout_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.Multiviewer.HEADLAYOUTMODE, VAPI.Multiviewer.HEADLAYOUTMODE, VAPI.Multiviewer.HEADLAYOUTMODE, VAPI.Multiviewer.HEADLAYOUTMODE, VAPI.Multiviewer.MultiviewerHeadLayout>;
    get pattern_id(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.MultiviewerHeadLayout>;
    get pattern_gap_x(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.MultiviewerHeadLayout>;
    get pattern_gap_y(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.MultiviewerHeadLayout>;
    get auto_monitoring(): VAPI.Multiviewer.AUTOMONITORINGSETTINGS;
}
export declare class MultiviewerHeadLocalRuntime implements VScript.Referenceable<"Multiviewer::Data::MultiviewerHeadLocalRuntime"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MultiviewerHeadLocalRuntime";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get pip(): VScript.StronglyTypedTable<VScript.VSocket, "Multiviewer::Data::MultiviewerPIPLocalRuntime", VAPI.Multiviewer.MultiviewerPIPLocalRuntime>;
}
export declare class MultiviewerHeadStreamingConfiguration implements VScript.Referenceable<"Multiviewer::Data::MultiviewerHeadStreamingConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MultiviewerHeadStreamingConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get enable(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.Multiviewer.MultiviewerHeadStreamingConfiguration>;
    get transport_format(): VScript.rwKeyword<VScript.VSocket, VAPI.Video.TransportFormat, VAPI.Video.TransportFormat, VAPI.Video.TransportFormat, VAPI.Video.TransportFormat, VAPI.Multiviewer.MultiviewerHeadStreamingConfiguration>;
}
export declare class MultiviewerLocal implements VScript.Referenceable<"Multiviewer::Data::MultiviewerLocal"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MultiviewerLocal";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get runtime(): VAPI.Multiviewer.MultiviewerLocalRuntime;
}
export declare class MultiviewerLocalRuntime implements VScript.Referenceable<"Multiviewer::Data::MultiviewerLocalRuntime"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MultiviewerLocalRuntime";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get head(): VScript.StronglyTypedTable<VScript.VSocket, "Multiviewer::Data::MultiviewerHeadLocalRuntime", VAPI.Multiviewer.MultiviewerHeadLocalRuntime>;
    get statistics(): VAPI.Multiviewer.MultiviewerStatistics;
}
export declare class MultiviewerPIPGlobalRuntime implements VScript.Referenceable<"Multiviewer::Data::MultiviewerPIPGlobalRuntime"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MultiviewerPIPGlobalRuntime";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get use_full_size(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.Multiviewer.MultiviewerPIPGlobalRuntime>;
    get resolution_level(): VScript.rKeyword<VScript.VSocket, VAPI.Multiviewer.RESOLUTIONLEVEL, VAPI.Multiviewer.RESOLUTIONLEVEL, VAPI.Multiviewer.MultiviewerPIPGlobalRuntime>;
}
export declare class MultiviewerPIPLocalRuntime implements VScript.Referenceable<"Multiviewer::Data::MultiviewerPIPLocalRuntime"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MultiviewerPIPLocalRuntime";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get routing(): VScript.rKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.PIPROUTING, VAPI.Multiviewer.MultiviewerPIPLocalRuntime>;
}
export declare class MultiviewerStatistics implements VScript.Referenceable<"Multiviewer::Data::MultiviewerStatistics"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::MultiviewerStatistics";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get cores(): VScript.StronglyTypedArray<VScript.VSocket, "Multiviewer::Data::ManifoldCoreStatistics", VAPI.Multiviewer.ManifoldCoreStatistics>;
    get memory(): VAPI.Multiviewer.ManifoldMemoryStatistics;
}
export declare class PPMSCALESETTINGSNordicRange implements VScript.Referenceable<"Multiviewer::Data::PPMSCALESETTINGS::NordicRange"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::PPMSCALESETTINGS::NordicRange";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get safe_area(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSNordicRange>;
    get operation_area(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSNordicRange>;
    get min_level(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSNordicRange>;
    get max_level(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSNordicRange>;
}
export type OBJECTID = number;
export type PEAKHOLDDECAY = "Off" | "Slow" | "Medium" | "Fast";
export type PEAKHOLDTIME = "Off" | "OneSecond" | "TwoSeconds" | "ThreeSeconds" | "FourSeconds";
export declare class PIP implements VScript.Referenceable<"Multiviewer::Data::PIP"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::PIP";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get monitoring_object_id(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterMonitoringObjects.MonitoringObjectID, VAPI.ClusterMonitoringObjects.MonitoringObjectID, VAPI.Multiviewer.PIP>;
    get display_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.PIP>;
    get geometry(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.GEOMETRY, VAPI.Multiviewer.GEOMETRY, VAPI.Multiviewer.PIP>;
    get keep_ar(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.Multiviewer.PIP>;
    get mipmap_bias(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PIP>;
    get bgnd(): VAPI.Multiviewer.BOX;
    get video_crop(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.CROP, VAPI.Multiviewer.CROP, VAPI.Multiviewer.PIP>;
    get video_border(): VAPI.Multiviewer.BORDER;
    get ppms(): VScript.StronglyTypedArray<VScript.VSocket, "Multiviewer::Data::PIPPPM", VAPI.Multiviewer.PIPPPM>;
    get omd(): VAPI.Multiviewer.MD;
    get umd(): VAPI.Multiviewer.MD;
    get tally_lamps(): VAPI.Multiviewer.TALLYLAMPS;
    get tally_settings(): VAPI.Multiviewer.PIPTALLYSETTINGS;
    get closed_caption(): VAPI.Multiviewer.CLOSEDCAPTION;
}
export declare class PIPAsNamedTableRow extends PIP {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export declare class PIPPPM implements VScript.Referenceable<"Multiviewer::Data::PIPPPM"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::PIPPPM";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get enable(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.Multiviewer.PIPPPM>;
    get alignment(): VScript.rwKeyword<VScript.VSocket, VAPI.Multiviewer.PIPPPMALIGNMENT, VAPI.Multiviewer.PIPPPMALIGNMENT, VAPI.Multiviewer.PIPPPMALIGNMENT, VAPI.Multiviewer.PIPPPMALIGNMENT, VAPI.Multiviewer.PIPPPM>;
    get bgnd(): VAPI.Multiviewer.BOX;
    get settings(): VScript.rwKeyword<VScript.VSocket, [
        VAPI.Multiviewer.PPMDisplayMode,
        VAPI.Multiviewer.PPMScalePosition,
        VAPI.Multiviewer.PPMScaleType,
        VAPI.Multiviewer.PEAKHOLDTIME,
        VAPI.Multiviewer.PEAKHOLDDECAY,
        VAPI.Multiviewer.PPMDECAY,
        number,
        number,
        number,
        number,
        number,
        number
    ], [
        VAPI.Multiviewer.PPMDisplayMode,
        VAPI.Multiviewer.PPMScalePosition,
        VAPI.Multiviewer.PPMScaleType,
        VAPI.Multiviewer.PEAKHOLDTIME,
        VAPI.Multiviewer.PEAKHOLDDECAY,
        VAPI.Multiviewer.PPMDECAY,
        number,
        number,
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.PPMSETTINGS, VAPI.Multiviewer.PPMSETTINGS, VAPI.Multiviewer.PIPPPM>;
}
export type PIPPPMALIGNMENT = "LEFT_INSIDE" | "LEFT_OUTSIDE" | "RIGHT_INSIDE" | "RIGHT_OUTSIDE";
export interface PIPROUTING {
    video_texture_width: number;
    video_texture_height: number;
    video_texture_input_id: number;
    video_texture_input_rl_id: number;
}
export type PIPTALLYMODE = "PIP_TALLY_MASK" | "VIDEO_SOURCE_TALLY_MASK" | "MONITORING_OBJECT_TALLY_MASK";
export interface PIPTALLYRULESSETTINGS {
    bgnd_tally_rules_mask: number;
    bgnd_border_tally_rules_mask: number;
    video_border_tally_rules_mask: number;
    umd_0_tally_rules_mask: number;
    umd_0_border_tally_rules_mask: number;
    umd_0_label_tally_rules_mask: number;
    umd_1_tally_rules_mask: number;
    umd_1_border_tally_rules_mask: number;
    umd_1_label_tally_rules_mask: number;
    umd_2_tally_rules_mask: number;
    umd_2_border_tally_rules_mask: number;
    umd_2_label_tally_rules_mask: number;
    omd_0_tally_rules_mask: number;
    omd_0_border_tally_rules_mask: number;
    omd_0_label_tally_rules_mask: number;
    omd_1_tally_rules_mask: number;
    omd_1_border_tally_rules_mask: number;
    omd_1_label_tally_rules_mask: number;
    omd_2_tally_rules_mask: number;
    omd_2_border_tally_rules_mask: number;
    omd_2_label_tally_rules_mask: number;
    left_lamp_tally_rules_mask: number;
    left_lamp_border_tally_rules_mask: number;
    right_lamp_tally_rules_mask: number;
    right_lamp_border_tally_rules_mask: number;
}
export declare class PIPTALLYSETTINGS implements VScript.Referenceable<"Multiviewer::Data::PIPTALLYSETTINGS"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::PIPTALLYSETTINGS";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get mode(): VScript.rwKeyword<VScript.VSocket, VAPI.Multiviewer.PIPTALLYMODE, VAPI.Multiviewer.PIPTALLYMODE, VAPI.Multiviewer.PIPTALLYMODE, VAPI.Multiviewer.PIPTALLYMODE, VAPI.Multiviewer.PIPTALLYSETTINGS>;
    get tally_mask(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.PIPTALLYSETTINGS>;
    get rules(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.PIPTALLYRULESSETTINGS, VAPI.Multiviewer.PIPTALLYRULESSETTINGS, VAPI.Multiviewer.PIPTALLYSETTINGS>;
}
export declare class PPMSCALESETTINGS implements VScript.Referenceable<"Multiviewer::Data::PPMSCALESETTINGS"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::PPMSCALESETTINGS";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get scale_strech(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGS>;
    get d_b_f_s_range(): VAPI.Multiviewer.PPMSCALESETTINGSDBFSRange;
    get d_i_n_range(): VAPI.Multiviewer.PPMSCALESETTINGSDINRange;
    get nordic_range(): VAPI.Multiviewer.PPMSCALESETTINGSNordicRange;
    get b_b_c_range(): VAPI.Multiviewer.PPMSCALESETTINGSBBCRange;
}
export type PPMChannels = number;
export type PPMDECAY = "decay_Fast" | "decay_24db_2_8s" | "decay_20db_1_7s" | "decay_20db_1_5s";
export type PPMDisplayMode = "ColourBars" | "ColourBarsGradient" | "ColourLEDs" | "ColourLEDsGradient";
export interface PPMSETTINGS {
    display_mode: VAPI.Multiviewer.PPMDisplayMode;
    scale_position: VAPI.Multiviewer.PPMScalePosition;
    scale_type: VAPI.Multiviewer.PPMScaleType;
    peak_hold: VAPI.Multiviewer.PEAKHOLDTIME;
    peak_hold_decay: VAPI.Multiviewer.PEAKHOLDDECAY;
    ppm_decay: VAPI.Multiviewer.PPMDECAY;
    width: number;
    opacity: number;
    scale_size: number;
    channel_spacing_size: number;
    leds_size: number;
    leds_spacing_size: number;
}
export type PPMScalePosition = "Left" | "Right" | "LeftAndRight" | "None";
export type PPMScaleType = "dBFS" | "DIN" | "Nordic" | "BBC";
export type RESOLUTIONLEVEL = "UNDEFINED" | "FULL_SIZE" | "ONE_4" | "ONE_16" | "ONE_64" | "ONE_256";
export declare class RLBLOCKSTATISTICS implements VScript.Referenceable<"Multiviewer::Data::RLBLOCKSTATISTICS"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::RLBLOCKSTATISTICS";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get total_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.RLBLOCKSTATISTICS>;
    get free_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.RLBLOCKSTATISTICS>;
    get used_num(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.RLBLOCKSTATISTICS>;
    get max_width(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.RLBLOCKSTATISTICS>;
    get max_height(): VScript.rKeyword<VScript.VSocket, number, VAPI.Multiviewer.TUnsignedMax, VAPI.Multiviewer.RLBLOCKSTATISTICS>;
}
export declare class STANDALONEPPM implements VScript.Referenceable<"Multiviewer::Data::STANDALONEPPM"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::STANDALONEPPM";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get monitoring_object_id(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterMonitoringObjects.MonitoringObjectID, VAPI.ClusterMonitoringObjects.MonitoringObjectID, VAPI.Multiviewer.STANDALONEPPM>;
    get display_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.STANDALONEPPM>;
    get geometry(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.GEOMETRY, VAPI.Multiviewer.GEOMETRY, VAPI.Multiviewer.STANDALONEPPM>;
    get bgnd(): VAPI.Multiviewer.BOX;
    get settings(): VScript.rwKeyword<VScript.VSocket, [
        VAPI.Multiviewer.PPMDisplayMode,
        VAPI.Multiviewer.PPMScalePosition,
        VAPI.Multiviewer.PPMScaleType,
        VAPI.Multiviewer.PEAKHOLDTIME,
        VAPI.Multiviewer.PEAKHOLDDECAY,
        VAPI.Multiviewer.PPMDECAY,
        number,
        number,
        number,
        number,
        number,
        number
    ], [
        VAPI.Multiviewer.PPMDisplayMode,
        VAPI.Multiviewer.PPMScalePosition,
        VAPI.Multiviewer.PPMScaleType,
        VAPI.Multiviewer.PEAKHOLDTIME,
        VAPI.Multiviewer.PEAKHOLDDECAY,
        VAPI.Multiviewer.PPMDECAY,
        number,
        number,
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.PPMSETTINGS, VAPI.Multiviewer.PPMSETTINGS, VAPI.Multiviewer.STANDALONEPPM>;
}
export declare class STANDALONEPPMAsNamedTableRow extends STANDALONEPPM {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export declare class STOPWATCHCMD implements VScript.Referenceable<"Multiviewer::Data::STOPWATCHCMD"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::STOPWATCHCMD";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Start
    */
    get start(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.Multiviewer.STOPWATCHCMD>;
    /**
      Stop
    */
    get stop(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.Multiviewer.STOPWATCHCMD>;
    /**
      Pause
    */
    get pause(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.Multiviewer.STOPWATCHCMD>;
    /**
      Reset
    */
    get reset(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.Multiviewer.STOPWATCHCMD>;
    /**
      Restart
    */
    get restart(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.Multiviewer.STOPWATCHCMD>;
    /**
      Lap
    */
    get lap(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.Multiviewer.STOPWATCHCMD>;
}
export type STOPWATCHCMDTYPE = "eNone" | "eStart" | "eStop" | "ePause" | "eReset" | "eRestart" | "eLap";
export type STOPWATCHMODE = "OFF" | "COUNT_UP_DURATION" | "COUNT_DOWN_DURATION" | "COUNT_UP_TARGET" | "COUNT_DOWN_TARGET" | "COUNT_UP_START";
export declare class STOPWATCHSETTINGS implements VScript.Referenceable<"Multiviewer::Data::STOPWATCHSETTINGS"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::STOPWATCHSETTINGS";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get mode(): VScript.rwKeyword<VScript.VSocket, VAPI.Multiviewer.STOPWATCHMODE, VAPI.Multiviewer.STOPWATCHMODE, VAPI.Multiviewer.STOPWATCHMODE, VAPI.Multiviewer.STOPWATCHMODE, VAPI.Multiviewer.STOPWATCHSETTINGS>;
    get count_after_finished(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.Multiviewer.STOPWATCHSETTINGS>;
    get colour_after_finished(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.Multiviewer.STOPWATCHSETTINGS>;
    get blinking_after_finished(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.Multiviewer.STOPWATCHSETTINGS>;
    get cmd(): VAPI.Multiviewer.STOPWATCHCMD;
    get target_or_duration(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number
    ], [
        number,
        number,
        number
    ], VAPI.Multiviewer.CLOCKTIME, VAPI.Multiviewer.CLOCKTIME, VAPI.Multiviewer.STOPWATCHSETTINGS>;
    get finish_colour_time(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number
    ], [
        number,
        number,
        number
    ], VAPI.Multiviewer.CLOCKTIME, VAPI.Multiviewer.CLOCKTIME, VAPI.Multiviewer.STOPWATCHSETTINGS>;
    get finish_blinking_time(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number
    ], [
        number,
        number,
        number
    ], VAPI.Multiviewer.CLOCKTIME, VAPI.Multiviewer.CLOCKTIME, VAPI.Multiviewer.STOPWATCHSETTINGS>;
    get finish_colour(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.STOPWATCHSETTINGS>;
    get state(): VScript.rKeyword<VScript.VSocket, VAPI.Multiviewer.STOPWATCHSTATE, VAPI.Multiviewer.STOPWATCHSTATE, VAPI.Multiviewer.STOPWATCHSETTINGS>;
    get is_finish_colour(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.Multiviewer.STOPWATCHSETTINGS>;
    get is_finish_blinking(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.Multiviewer.STOPWATCHSETTINGS>;
    get is_finished(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.Multiviewer.STOPWATCHSETTINGS>;
}
export type STOPWATCHSTATE = "STOP" | "PAUSE" | "RUN" | "LAP";
export declare class TALLYLAMPS implements VScript.Referenceable<"Multiviewer::Data::TALLYLAMPS"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::TALLYLAMPS";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get enable(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.Multiviewer.TALLYLAMPS>;
    get width(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.TALLYLAMPS>;
    get left_lamp(): VAPI.Multiviewer.BOX;
    get right_lamp(): VAPI.Multiviewer.BOX;
}
export declare class TALLYRULE implements VScript.Referenceable<"Multiviewer::Data::TALLYRULE"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::TALLYRULE";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get bit_id(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.TALLYRULE>;
    get priority_id(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.TALLYRULE>;
    get colour(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.TALLYRULE>;
}
export declare class TALLYRULES implements VScript.Referenceable<"Multiviewer::Data::TALLYRULES"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::TALLYRULES";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get rule_0(): VAPI.Multiviewer.TALLYRULE;
    get rule_1(): VAPI.Multiviewer.TALLYRULE;
    get rule_2(): VAPI.Multiviewer.TALLYRULE;
    get rule_3(): VAPI.Multiviewer.TALLYRULE;
    get rule_4(): VAPI.Multiviewer.TALLYRULE;
    get rule_5(): VAPI.Multiviewer.TALLYRULE;
    get rule_6(): VAPI.Multiviewer.TALLYRULE;
    get rule_7(): VAPI.Multiviewer.TALLYRULE;
}
export declare class TEXTBOX implements VScript.Referenceable<"Multiviewer::Data::TEXTBOX"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::TEXTBOX";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get display_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.DISPLAYMODE, VAPI.Multiviewer.TEXTBOX>;
    get geometry(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.GEOMETRY, VAPI.Multiviewer.GEOMETRY, VAPI.Multiviewer.TEXTBOX>;
    get bgnd(): VAPI.Multiviewer.BOX;
    get label(): VAPI.Multiviewer.LABEL;
    get arg0(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.Primitives.Signed32, VAPI.Primitives.Signed32, VAPI.Multiviewer.TEXTBOX>;
    get arg1(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.Primitives.Signed32, VAPI.Primitives.Signed32, VAPI.Multiviewer.TEXTBOX>;
    get flash_bgnd_colour(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.TEXTBOX>;
    get flash_label_colour(): VScript.rwKeyword<VScript.VSocket, [
        number,
        number,
        number,
        number
    ], [
        number,
        number,
        number,
        number
    ], VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.HSLCOLOURWITHOPACITY, VAPI.Multiviewer.TEXTBOX>;
    get flash_speed(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.TEXTBOX>;
}
export declare class TEXTBOXAsNamedTableRow extends TEXTBOX {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export type TIMEZONE = number;
export type TIMEFORMAT = "HHMMSS" | "HMMSS12";
export declare class TMPREMOVEDFROMPIPStruct implements VScript.Referenceable<"Multiviewer::Data::TMPREMOVEDFROMPIPStruct"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::TMPREMOVEDFROMPIPStruct";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get alarms(): VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectAlarmsEnable;
}
export type TUnsignedMax = number;
export type VirtualXY = number;
export type Width = number;
export type WidthZero = number;
export declare class PPMSCALESETTINGSDBFSRange implements VScript.Referenceable<"Multiviewer::Data::PPMSCALESETTINGS::DBFSRange"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Multiviewer::Data::PPMSCALESETTINGS::DBFSRange";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get safe_area(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSDBFSRange>;
    get operation_area(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSDBFSRange>;
    get min_level(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSDBFSRange>;
    get max_level(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.Multiviewer.PPMSCALESETTINGSDBFSRange>;
}
export declare const Enums: {
    readonly TIMEFORMAT: TIMEFORMAT[];
    readonly STOPWATCHSTATE: STOPWATCHSTATE[];
    readonly STOPWATCHMODE: STOPWATCHMODE[];
    readonly STOPWATCHCMDTYPE: STOPWATCHCMDTYPE[];
    readonly RESOLUTIONLEVEL: RESOLUTIONLEVEL[];
    readonly PPMScaleType: PPMScaleType[];
    readonly PPMScalePosition: PPMScalePosition[];
    readonly PPMDisplayMode: PPMDisplayMode[];
    readonly PPMDECAY: PPMDECAY[];
    readonly PIPTALLYMODE: PIPTALLYMODE[];
    readonly PIPPPMALIGNMENT: PIPPPMALIGNMENT[];
    readonly PEAKHOLDTIME: PEAKHOLDTIME[];
    readonly PEAKHOLDDECAY: PEAKHOLDDECAY[];
    readonly MDMODE: MDMODE[];
    readonly MDCELLMODE: MDCELLMODE[];
    readonly HEADLAYOUTMODE: HEADLAYOUTMODE[];
    readonly FONTSTYLE: FONTSTYLE[];
    readonly FONTFAMILY: FONTFAMILY[];
    readonly DISPLAYMODE: DISPLAYMODE[];
    readonly BORDERRADIUSCORNERS: BORDERRADIUSCORNERS[];
    readonly ALIGNMENT: ALIGNMENT[];
};
