import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    ALARMSSEVERITYLEVELS: (_raw) => (new ALARMSSEVERITYLEVELS(_raw)),
    ALARMSEVERITYLEVEL: (_raw) => (new ALARMSEVERITYLEVEL(_raw)),
    ANALOGCLOCK: (_raw) => (new ANALOGCLOCK(_raw)),
    AUTOMONITORINGSETTINGS: (_raw) => (new AUTOMONITORINGSETTINGS(_raw)),
    All: (_raw) => (new All(_raw)),
    PPMSCALESETTINGSBBCRange: (_raw) => (new PPMSCALESETTINGSBBCRange(_raw)),
    BORDER: (_raw) => (new BORDER(_raw)),
    BORDERGEOMETRY: (_raw, _socket) => {
        return {
            width: _raw[0],
            radius: _raw[1],
            radius_corners: _raw[2]
        };
    },
    BOX: (_raw) => (new BOX(_raw)),
    CLOCKTIME: (_raw, _socket) => {
        return {
            seconds: _raw[0],
            minutes: _raw[1],
            hours: _raw[2]
        };
    },
    CLOCKTIMESETTINGS: (_raw) => (new CLOCKTIMESETTINGS(_raw)),
    CLOSEDCAPTION: (_raw) => (new CLOSEDCAPTION(_raw)),
    CLOSEDCAPTIONPARAMETERS: (_raw, _socket) => {
        return {
            width_zoom: _raw[0],
            height_zoom: _raw[1],
            x_offset: _raw[2],
            y_offset: _raw[3]
        };
    },
    CROP: (_raw, _socket) => {
        return {
            left: _raw[0],
            right: _raw[1],
            top: _raw[2],
            bottom: _raw[3]
        };
    },
    DIGITALCLOCK: (_raw) => (new DIGITALCLOCK(_raw)),
    PPMSCALESETTINGSDINRange: (_raw) => (new PPMSCALESETTINGSDINRange(_raw)),
    FONT: (_raw, _socket) => {
        return {
            font_family: _raw[0],
            font_style: _raw[1]
        };
    },
    GEOMETRY: (_raw, _socket) => {
        return {
            posx: _raw[0],
            posy: _raw[1],
            width: _raw[2],
            height: _raw[3],
            depth: _raw[4]
        };
    },
    HSLCOLOUR: (_raw, _socket) => {
        return {
            hue: _raw[0],
            saturation: _raw[1],
            lightness: _raw[2]
        };
    },
    HSLCOLOURWITHOPACITY: (_raw, _socket) => {
        return {
            hue: _raw[0],
            saturation: _raw[1],
            lightness: _raw[2],
            opacity: _raw[3]
        };
    },
    IMAGE: (_raw) => (new IMAGE(_raw)),
    LABEL: (_raw) => (new LABEL(_raw)),
    LABELDUAL: (_raw) => (new LABELDUAL(_raw)),
    LoadValue: (_raw, _socket) => {
        return {
            value: _raw[0],
            percents: _raw[1]
        };
    },
    MD: (_raw) => (new MD(_raw)),
    MDCELL: (_raw) => (new MDCELL(_raw)),
    ManifoldCoreRasterizerStatistics: (_raw) => (new ManifoldCoreRasterizerStatistics(_raw)),
    ManifoldCoreStatistics: (_raw) => (new ManifoldCoreStatistics(_raw)),
    ManifoldMemoryStatistics: (_raw) => (new ManifoldMemoryStatistics(_raw)),
    MultiviewerGlobal: (_raw) => (new MultiviewerGlobal(_raw)),
    MultiviewerGlobalConfiguration: (_raw) => (new MultiviewerGlobalConfiguration(_raw)),
    MultiviewerGlobalConfigurationParameters: (_raw) => (new MultiviewerGlobalConfigurationParameters(_raw)),
    MultiviewerGlobalRuntime: (_raw) => (new MultiviewerGlobalRuntime(_raw)),
    MultiviewerHeadGlobalConfiguration: (_raw) => (new MultiviewerHeadGlobalConfiguration(_raw)),
    MultiviewerHeadGlobalParameters: (_raw) => (new MultiviewerHeadGlobalParameters(_raw)),
    MultiviewerHeadGlobalRuntime: (_raw) => (new MultiviewerHeadGlobalRuntime(_raw)),
    MultiviewerHeadLayout: (_raw) => (new MultiviewerHeadLayout(_raw)),
    MultiviewerHeadLocalRuntime: (_raw) => (new MultiviewerHeadLocalRuntime(_raw)),
    MultiviewerHeadStreamingConfiguration: (_raw) => (new MultiviewerHeadStreamingConfiguration(_raw)),
    MultiviewerLocal: (_raw) => (new MultiviewerLocal(_raw)),
    MultiviewerLocalRuntime: (_raw) => (new MultiviewerLocalRuntime(_raw)),
    MultiviewerPIPGlobalRuntime: (_raw) => (new MultiviewerPIPGlobalRuntime(_raw)),
    MultiviewerPIPLocalRuntime: (_raw) => (new MultiviewerPIPLocalRuntime(_raw)),
    MultiviewerStatistics: (_raw) => (new MultiviewerStatistics(_raw)),
    PPMSCALESETTINGSNordicRange: (_raw) => (new PPMSCALESETTINGSNordicRange(_raw)),
    PIP: (_raw) => (new PIP(_raw)),
    PIPPPM: (_raw) => (new PIPPPM(_raw)),
    PIPROUTING: (_raw, _socket) => {
        return {
            video_texture_width: _raw[0],
            video_texture_height: _raw[1],
            video_texture_input_id: _raw[2],
            video_texture_input_rl_id: _raw[3]
        };
    },
    PIPTALLYRULESSETTINGS: (_raw, _socket) => {
        return {
            bgnd_tally_rules_mask: _raw[0],
            bgnd_border_tally_rules_mask: _raw[1],
            video_border_tally_rules_mask: _raw[2],
            umd_0_tally_rules_mask: _raw[3],
            umd_0_border_tally_rules_mask: _raw[4],
            umd_0_label_tally_rules_mask: _raw[5],
            umd_1_tally_rules_mask: _raw[6],
            umd_1_border_tally_rules_mask: _raw[7],
            umd_1_label_tally_rules_mask: _raw[8],
            umd_2_tally_rules_mask: _raw[9],
            umd_2_border_tally_rules_mask: _raw[10],
            umd_2_label_tally_rules_mask: _raw[11],
            omd_0_tally_rules_mask: _raw[12],
            omd_0_border_tally_rules_mask: _raw[13],
            omd_0_label_tally_rules_mask: _raw[14],
            omd_1_tally_rules_mask: _raw[15],
            omd_1_border_tally_rules_mask: _raw[16],
            omd_1_label_tally_rules_mask: _raw[17],
            omd_2_tally_rules_mask: _raw[18],
            omd_2_border_tally_rules_mask: _raw[19],
            omd_2_label_tally_rules_mask: _raw[20],
            left_lamp_tally_rules_mask: _raw[21],
            left_lamp_border_tally_rules_mask: _raw[22],
            right_lamp_tally_rules_mask: _raw[23],
            right_lamp_border_tally_rules_mask: _raw[24]
        };
    },
    PIPTALLYSETTINGS: (_raw) => (new PIPTALLYSETTINGS(_raw)),
    PPMSCALESETTINGS: (_raw) => (new PPMSCALESETTINGS(_raw)),
    PPMSETTINGS: (_raw, _socket) => {
        return {
            display_mode: _raw[0],
            scale_position: _raw[1],
            scale_type: _raw[2],
            peak_hold: _raw[3],
            peak_hold_decay: _raw[4],
            ppm_decay: _raw[5],
            width: _raw[6],
            opacity: _raw[7],
            scale_size: _raw[8],
            channel_spacing_size: _raw[9],
            leds_size: _raw[10],
            leds_spacing_size: _raw[11]
        };
    },
    RLBLOCKSTATISTICS: (_raw) => (new RLBLOCKSTATISTICS(_raw)),
    STANDALONEPPM: (_raw) => (new STANDALONEPPM(_raw)),
    STOPWATCHCMD: (_raw) => (new STOPWATCHCMD(_raw)),
    STOPWATCHSETTINGS: (_raw) => (new STOPWATCHSETTINGS(_raw)),
    TALLYLAMPS: (_raw) => (new TALLYLAMPS(_raw)),
    TALLYRULE: (_raw) => (new TALLYRULE(_raw)),
    TALLYRULES: (_raw) => (new TALLYRULES(_raw)),
    TEXTBOX: (_raw) => (new TEXTBOX(_raw)),
    TMPREMOVEDFROMPIPStruct: (_raw) => (new TMPREMOVEDFROMPIPStruct(_raw)),
    PPMSCALESETTINGSDBFSRange: (_raw) => (new PPMSCALESETTINGSDBFSRange(_raw)),
};
export const lower = {
    ALARMSSEVERITYLEVELS: (_x) => _x.raw.kwl,
    ALARMSEVERITYLEVEL: (_x) => _x.raw.kwl,
    ANALOGCLOCK: (_x) => _x.raw.kwl,
    AUTOMONITORINGSETTINGS: (_x) => _x.raw.kwl,
    All: (_x) => _x.raw.kwl,
    PPMSCALESETTINGSBBCRange: (_x) => _x.raw.kwl,
    BORDER: (_x) => _x.raw.kwl,
    BORDERGEOMETRY: (_x, _socket) => [
        _x.width,
        _x.radius,
        _x.radius_corners
    ],
    BOX: (_x) => _x.raw.kwl,
    CLOCKTIME: (_x, _socket) => [
        _x.seconds,
        _x.minutes,
        _x.hours
    ],
    CLOCKTIMESETTINGS: (_x) => _x.raw.kwl,
    CLOSEDCAPTION: (_x) => _x.raw.kwl,
    CLOSEDCAPTIONPARAMETERS: (_x, _socket) => [
        _x.width_zoom,
        _x.height_zoom,
        _x.x_offset,
        _x.y_offset
    ],
    CROP: (_x, _socket) => [
        _x.left,
        _x.right,
        _x.top,
        _x.bottom
    ],
    DIGITALCLOCK: (_x) => _x.raw.kwl,
    PPMSCALESETTINGSDINRange: (_x) => _x.raw.kwl,
    FONT: (_x, _socket) => [
        _x.font_family,
        _x.font_style
    ],
    GEOMETRY: (_x, _socket) => [
        _x.posx,
        _x.posy,
        _x.width,
        _x.height,
        _x.depth
    ],
    HSLCOLOUR: (_x, _socket) => [
        _x.hue,
        _x.saturation,
        _x.lightness
    ],
    HSLCOLOURWITHOPACITY: (_x, _socket) => [
        _x.hue,
        _x.saturation,
        _x.lightness,
        _x.opacity
    ],
    IMAGE: (_x) => _x.raw.kwl,
    LABEL: (_x) => _x.raw.kwl,
    LABELDUAL: (_x) => _x.raw.kwl,
    LoadValue: (_x, _socket) => [
        _x.value,
        _x.percents
    ],
    MD: (_x) => _x.raw.kwl,
    MDCELL: (_x) => _x.raw.kwl,
    ManifoldCoreRasterizerStatistics: (_x) => _x.raw.kwl,
    ManifoldCoreStatistics: (_x) => _x.raw.kwl,
    ManifoldMemoryStatistics: (_x) => _x.raw.kwl,
    MultiviewerGlobal: (_x) => _x.raw.kwl,
    MultiviewerGlobalConfiguration: (_x) => _x.raw.kwl,
    MultiviewerGlobalConfigurationParameters: (_x) => _x.raw.kwl,
    MultiviewerGlobalRuntime: (_x) => _x.raw.kwl,
    MultiviewerHeadGlobalConfiguration: (_x) => _x.raw.kwl,
    MultiviewerHeadGlobalParameters: (_x) => _x.raw.kwl,
    MultiviewerHeadGlobalRuntime: (_x) => _x.raw.kwl,
    MultiviewerHeadLayout: (_x) => _x.raw.kwl,
    MultiviewerHeadLocalRuntime: (_x) => _x.raw.kwl,
    MultiviewerHeadStreamingConfiguration: (_x) => _x.raw.kwl,
    MultiviewerLocal: (_x) => _x.raw.kwl,
    MultiviewerLocalRuntime: (_x) => _x.raw.kwl,
    MultiviewerPIPGlobalRuntime: (_x) => _x.raw.kwl,
    MultiviewerPIPLocalRuntime: (_x) => _x.raw.kwl,
    MultiviewerStatistics: (_x) => _x.raw.kwl,
    PPMSCALESETTINGSNordicRange: (_x) => _x.raw.kwl,
    PIP: (_x) => _x.raw.kwl,
    PIPPPM: (_x) => _x.raw.kwl,
    PIPROUTING: (_x, _socket) => [
        _x.video_texture_width,
        _x.video_texture_height,
        _x.video_texture_input_id,
        _x.video_texture_input_rl_id
    ],
    PIPTALLYRULESSETTINGS: (_x, _socket) => [
        _x.bgnd_tally_rules_mask,
        _x.bgnd_border_tally_rules_mask,
        _x.video_border_tally_rules_mask,
        _x.umd_0_tally_rules_mask,
        _x.umd_0_border_tally_rules_mask,
        _x.umd_0_label_tally_rules_mask,
        _x.umd_1_tally_rules_mask,
        _x.umd_1_border_tally_rules_mask,
        _x.umd_1_label_tally_rules_mask,
        _x.umd_2_tally_rules_mask,
        _x.umd_2_border_tally_rules_mask,
        _x.umd_2_label_tally_rules_mask,
        _x.omd_0_tally_rules_mask,
        _x.omd_0_border_tally_rules_mask,
        _x.omd_0_label_tally_rules_mask,
        _x.omd_1_tally_rules_mask,
        _x.omd_1_border_tally_rules_mask,
        _x.omd_1_label_tally_rules_mask,
        _x.omd_2_tally_rules_mask,
        _x.omd_2_border_tally_rules_mask,
        _x.omd_2_label_tally_rules_mask,
        _x.left_lamp_tally_rules_mask,
        _x.left_lamp_border_tally_rules_mask,
        _x.right_lamp_tally_rules_mask,
        _x.right_lamp_border_tally_rules_mask
    ],
    PIPTALLYSETTINGS: (_x) => _x.raw.kwl,
    PPMSCALESETTINGS: (_x) => _x.raw.kwl,
    PPMSETTINGS: (_x, _socket) => [
        _x.display_mode,
        _x.scale_position,
        _x.scale_type,
        _x.peak_hold,
        _x.peak_hold_decay,
        _x.ppm_decay,
        _x.width,
        _x.opacity,
        _x.scale_size,
        _x.channel_spacing_size,
        _x.leds_size,
        _x.leds_spacing_size
    ],
    RLBLOCKSTATISTICS: (_x) => _x.raw.kwl,
    STANDALONEPPM: (_x) => _x.raw.kwl,
    STOPWATCHCMD: (_x) => _x.raw.kwl,
    STOPWATCHSETTINGS: (_x) => _x.raw.kwl,
    TALLYLAMPS: (_x) => _x.raw.kwl,
    TALLYRULE: (_x) => _x.raw.kwl,
    TALLYRULES: (_x) => _x.raw.kwl,
    TEXTBOX: (_x) => _x.raw.kwl,
    TMPREMOVEDFROMPIPStruct: (_x) => _x.raw.kwl,
    PPMSCALESETTINGSDBFSRange: (_x) => _x.raw.kwl,
};
export class ALARMSSEVERITYLEVELS {
    raw;
    type_identifier = "Multiviewer::Data::ALARMSSEVERITYLEVELS";
    constructor(raw) {
        this.raw = raw;
    }
    get severity_level_0() {
        return VAPI.Multiviewer.lift.ALARMSEVERITYLEVEL(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "severity_level_0"));
    }
    get severity_level_1() {
        return VAPI.Multiviewer.lift.ALARMSEVERITYLEVEL(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "severity_level_1"));
    }
    get severity_level_2() {
        return VAPI.Multiviewer.lift.ALARMSEVERITYLEVEL(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "severity_level_2"));
    }
    get severity_level_3() {
        return VAPI.Multiviewer.lift.ALARMSEVERITYLEVEL(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "severity_level_3"));
    }
    get severity_level_4() {
        return VAPI.Multiviewer.lift.ALARMSEVERITYLEVEL(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "severity_level_4"));
    }
    get border_width() {
        return new VScript.rwKeyword(this, "border_width", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ALARMSEVERITYLEVEL {
    raw;
    type_identifier = "Multiviewer::Data::ALARMSEVERITYLEVEL";
    constructor(raw) {
        this.raw = raw;
    }
    get font_colour() {
        return new VScript.rwKeyword(this, "font_colour", {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, null);
    }
    get bgnd_colour() {
        return new VScript.rwKeyword(this, "bgnd_colour", {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, null);
    }
}
export class ANALOGCLOCK {
    raw;
    type_identifier = "Multiviewer::Data::ANALOGCLOCK";
    constructor(raw) {
        this.raw = raw;
    }
    get display_mode() {
        return new VScript.rwKeyword(this, "display_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get geometry() {
        return new VScript.rwKeyword(this, "geometry", {
            lift: VAPI.Multiviewer.lift.GEOMETRY,
            lower: VAPI.Multiviewer.lower.GEOMETRY
        }, {
            lift: VAPI.Multiviewer.lift.GEOMETRY,
            lower: VAPI.Multiviewer.lower.GEOMETRY
        }, null);
    }
    get time_settings() {
        return VAPI.Multiviewer.lift.CLOCKTIMESETTINGS(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "time_settings"));
    }
    get theme() {
        return new VScript.rwKeyword(this, "theme", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ANALOGCLOCKAsNamedTableRow extends ANALOGCLOCK {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export class AUTOMONITORINGSETTINGS {
    raw;
    type_identifier = "Multiviewer::Data::AUTOMONITORINGSETTINGS";
    constructor(raw) {
        this.raw = raw;
    }
    get first_monitoring_object_id() {
        return new VScript.rwKeyword(this, "first_monitoring_object_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get last_monitoring_object_id() {
        return new VScript.rwKeyword(this, "last_monitoring_object_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class All {
    raw;
    type_identifier = "Multiviewer::Data::All";
    constructor(raw) {
        this.raw = raw;
    }
    get global() {
        return VAPI.Multiviewer.lift.MultiviewerGlobal(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "global"));
    }
    get local() {
        return VAPI.Multiviewer.lift.MultiviewerLocal(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "local"));
    }
}
export class PPMSCALESETTINGSBBCRange {
    raw;
    type_identifier = "Multiviewer::Data::PPMSCALESETTINGS::BBCRange";
    constructor(raw) {
        this.raw = raw;
    }
    get safe_area() {
        return new VScript.rwKeyword(this, "safe_area", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get operation_area() {
        return new VScript.rwKeyword(this, "operation_area", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get min_level() {
        return new VScript.rwKeyword(this, "min_level", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get max_level() {
        return new VScript.rwKeyword(this, "max_level", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class BORDER {
    raw;
    type_identifier = "Multiviewer::Data::BORDER";
    constructor(raw) {
        this.raw = raw;
    }
    get geometry() {
        return new VScript.rwKeyword(this, "geometry", {
            lift: VAPI.Multiviewer.lift.BORDERGEOMETRY,
            lower: VAPI.Multiviewer.lower.BORDERGEOMETRY
        }, {
            lift: VAPI.Multiviewer.lift.BORDERGEOMETRY,
            lower: VAPI.Multiviewer.lower.BORDERGEOMETRY
        }, null);
    }
    get colour() {
        return new VScript.rwKeyword(this, "colour", {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, null);
    }
}
export class BOX {
    raw;
    type_identifier = "Multiviewer::Data::BOX";
    constructor(raw) {
        this.raw = raw;
    }
    get bgnd_colour() {
        return new VScript.rwKeyword(this, "bgnd_colour", {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, null);
    }
    get border() {
        return VAPI.Multiviewer.lift.BORDER(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "border"));
    }
}
export class CLOCKTIMESETTINGS {
    raw;
    type_identifier = "Multiviewer::Data::CLOCKTIMESETTINGS";
    constructor(raw) {
        this.raw = raw;
    }
    get metadata_monitoring_object_id() {
        return new VScript.rwKeyword(this, "metadata_monitoring_object_id", {
            lift: VAPI.ClusterMonitoringObjects.lift.MonitoringObjectChannelID,
            lower: VAPI.ClusterMonitoringObjects.lower.MonitoringObjectChannelID
        }, {
            lift: VAPI.ClusterMonitoringObjects.lift.MonitoringObjectChannelID,
            lower: VAPI.ClusterMonitoringObjects.lower.MonitoringObjectChannelID
        }, null);
    }
    get timecode_select() {
        return new VScript.rwKeyword(this, "timecode_select", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get timezone_offset() {
        return new VScript.rwKeyword(this, "timezone_offset", {
            lift: VAPI.Multiviewer.lift.CLOCKTIME,
            lower: VAPI.Multiviewer.lower.CLOCKTIME
        }, {
            lift: VAPI.Multiviewer.lift.CLOCKTIME,
            lower: VAPI.Multiviewer.lower.CLOCKTIME
        }, null);
    }
}
export class CLOSEDCAPTION {
    raw;
    type_identifier = "Multiviewer::Data::CLOSEDCAPTION";
    constructor(raw) {
        this.raw = raw;
    }
    get enable() {
        return new VScript.rwKeyword(this, "enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get bgnd() {
        return VAPI.Multiviewer.lift.BOX(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "bgnd"));
    }
    get safe_area() {
        return new VScript.rwKeyword(this, "safe_area", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get column_offset() {
        return new VScript.rwKeyword(this, "column_offset", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get row_offset() {
        return new VScript.rwKeyword(this, "row_offset", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get font_bgnd_opacity() {
        return new VScript.rwKeyword(this, "font_bgnd_opacity", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get font() {
        return new VScript.rwKeyword(this, "font", {
            lift: VAPI.Multiviewer.lift.FONT,
            lower: VAPI.Multiviewer.lower.FONT
        }, {
            lift: VAPI.Multiviewer.lift.FONT,
            lower: VAPI.Multiviewer.lower.FONT
        }, null);
    }
}
export class DIGITALCLOCK {
    raw;
    type_identifier = "Multiviewer::Data::DIGITALCLOCK";
    constructor(raw) {
        this.raw = raw;
    }
    get display_mode() {
        return new VScript.rwKeyword(this, "display_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get geometry() {
        return new VScript.rwKeyword(this, "geometry", {
            lift: VAPI.Multiviewer.lift.GEOMETRY,
            lower: VAPI.Multiviewer.lower.GEOMETRY
        }, {
            lift: VAPI.Multiviewer.lift.GEOMETRY,
            lower: VAPI.Multiviewer.lower.GEOMETRY
        }, null);
    }
    get time_settings() {
        return VAPI.Multiviewer.lift.CLOCKTIMESETTINGS(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "time_settings"));
    }
    get stopwatch() {
        return VAPI.Multiviewer.lift.STOPWATCHSETTINGS(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "stopwatch"));
    }
    get time_format() {
        return new VScript.rwKeyword(this, "time_format", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get bgnd() {
        return VAPI.Multiviewer.lift.BOX(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "bgnd"));
    }
    get digit_font_colour() {
        return new VScript.rwKeyword(this, "digit_font_colour", {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, null);
    }
    get digit_font() {
        return new VScript.rwKeyword(this, "digit_font", {
            lift: VAPI.Multiviewer.lift.FONT,
            lower: VAPI.Multiviewer.lower.FONT
        }, {
            lift: VAPI.Multiviewer.lift.FONT,
            lower: VAPI.Multiviewer.lower.FONT
        }, null);
    }
    get digit_bgnd_colour() {
        return new VScript.rwKeyword(this, "digit_bgnd_colour", {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, null);
    }
}
export class DIGITALCLOCKAsNamedTableRow extends DIGITALCLOCK {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export class PPMSCALESETTINGSDINRange {
    raw;
    type_identifier = "Multiviewer::Data::PPMSCALESETTINGS::DINRange";
    constructor(raw) {
        this.raw = raw;
    }
    get safe_area() {
        return new VScript.rwKeyword(this, "safe_area", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get operation_area() {
        return new VScript.rwKeyword(this, "operation_area", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get min_level() {
        return new VScript.rwKeyword(this, "min_level", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get max_level() {
        return new VScript.rwKeyword(this, "max_level", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class IMAGE {
    raw;
    type_identifier = "Multiviewer::Data::IMAGE";
    constructor(raw) {
        this.raw = raw;
    }
    get display_mode() {
        return new VScript.rwKeyword(this, "display_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get geometry() {
        return new VScript.rwKeyword(this, "geometry", {
            lift: VAPI.Multiviewer.lift.GEOMETRY,
            lower: VAPI.Multiviewer.lower.GEOMETRY
        }, {
            lift: VAPI.Multiviewer.lift.GEOMETRY,
            lower: VAPI.Multiviewer.lower.GEOMETRY
        }, null);
    }
}
export class IMAGEAsNamedTableRow extends IMAGE {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export class LABEL {
    raw;
    type_identifier = "Multiviewer::Data::LABEL";
    constructor(raw) {
        this.raw = raw;
    }
    get colour() {
        return new VScript.rwKeyword(this, "colour", {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, null);
    }
    get font() {
        return new VScript.rwKeyword(this, "font", {
            lift: VAPI.Multiviewer.lift.FONT,
            lower: VAPI.Multiviewer.lower.FONT
        }, {
            lift: VAPI.Multiviewer.lift.FONT,
            lower: VAPI.Multiviewer.lower.FONT
        }, null);
    }
    get string_default() {
        return new VScript.rwKeyword(this, "string_default", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class LABELDUAL {
    raw;
    type_identifier = "Multiviewer::Data::LABELDUAL";
    constructor(raw) {
        this.raw = raw;
    }
    get colour() {
        return new VScript.rwKeyword(this, "colour", {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, null);
    }
    get font() {
        return new VScript.rwKeyword(this, "font", {
            lift: VAPI.Multiviewer.lift.FONT,
            lower: VAPI.Multiviewer.lower.FONT
        }, {
            lift: VAPI.Multiviewer.lift.FONT,
            lower: VAPI.Multiviewer.lower.FONT
        }, null);
    }
    get string_default() {
        return new VScript.rwKeyword(this, "string_default", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get string_user() {
        return new VScript.rwKeyword(this, "string_user", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class MD {
    raw;
    type_identifier = "Multiviewer::Data::MD";
    constructor(raw) {
        this.raw = raw;
    }
    get enable() {
        return new VScript.rwKeyword(this, "enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get mode() {
        return new VScript.rwKeyword(this, "mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get alignment() {
        return new VScript.rwKeyword(this, "alignment", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get width() {
        return new VScript.rwKeyword(this, "width", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get height() {
        return new VScript.rwKeyword(this, "height", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get cells() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 5, "cells"), (st, _) => VAPI.Multiviewer.lift.MDCELL(st));
    }
}
export class MDCELL {
    raw;
    type_identifier = "Multiviewer::Data::MDCELL";
    constructor(raw) {
        this.raw = raw;
    }
    get mode() {
        return new VScript.rwKeyword(this, "mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get timecode_select() {
        return new VScript.rwKeyword(this, "timecode_select", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get timecode_show_frames() {
        return new VScript.rwKeyword(this, "timecode_show_frames", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get bgnd() {
        return VAPI.Multiviewer.lift.BOX(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "bgnd"));
    }
    get label() {
        return VAPI.Multiviewer.lift.LABELDUAL(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "label"));
    }
}
export class ManifoldCoreRasterizerStatistics {
    raw;
    type_identifier = "Multiviewer::Data::ManifoldCoreRasterizerStatistics";
    constructor(raw) {
        this.raw = raw;
    }
    get clocks_per_frame_active() {
        return new VScript.rKeyword(this, "clocks_per_frame_active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get pixel_clocks_per_frame() {
        return new VScript.rKeyword(this, "pixel_clocks_per_frame", {
            lift: VAPI.Multiviewer.lift.LoadValue,
            lower: VAPI.Multiviewer.lower.LoadValue
        });
    }
    get pixels_per_frame() {
        return new VScript.rKeyword(this, "pixels_per_frame", {
            lift: VAPI.Multiviewer.lift.LoadValue,
            lower: VAPI.Multiviewer.lower.LoadValue
        });
    }
    get clocks_store_wait_for_memory() {
        return new VScript.rKeyword(this, "clocks_store_wait_for_memory", {
            lift: VAPI.Multiviewer.lift.LoadValue,
            lower: VAPI.Multiviewer.lower.LoadValue
        });
    }
}
export class ManifoldCoreStatistics {
    raw;
    type_identifier = "Multiviewer::Data::ManifoldCoreStatistics";
    constructor(raw) {
        this.raw = raw;
    }
    get sync_length() {
        return new VScript.rKeyword(this, "sync_length", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get sync_length_throttled() {
        return new VScript.rKeyword(this, "sync_length_throttled", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get sync_refresh_rate() {
        return new VScript.rKeyword(this, "sync_refresh_rate", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get sync_refresh_rate_throttled() {
        return new VScript.rKeyword(this, "sync_refresh_rate_throttled", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get sync_calc_length() {
        return new VScript.rKeyword(this, "sync_calc_length", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_0_primitives_num() {
        return new VScript.rKeyword(this, "output_0_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_1_primitives_num() {
        return new VScript.rKeyword(this, "output_1_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_2_primitives_num() {
        return new VScript.rKeyword(this, "output_2_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_3_primitives_num() {
        return new VScript.rKeyword(this, "output_3_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_4_primitives_num() {
        return new VScript.rKeyword(this, "output_4_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_5_primitives_num() {
        return new VScript.rKeyword(this, "output_5_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_6_primitives_num() {
        return new VScript.rKeyword(this, "output_6_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_7_primitives_num() {
        return new VScript.rKeyword(this, "output_7_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get total_primitives_num() {
        return new VScript.rKeyword(this, "total_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_0_total_clks() {
        return new VScript.rKeyword(this, "output_0_total_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_1_total_clks() {
        return new VScript.rKeyword(this, "output_1_total_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_2_total_clks() {
        return new VScript.rKeyword(this, "output_2_total_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_3_total_clks() {
        return new VScript.rKeyword(this, "output_3_total_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_4_total_clks() {
        return new VScript.rKeyword(this, "output_4_total_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_5_total_clks() {
        return new VScript.rKeyword(this, "output_5_total_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_6_total_clks() {
        return new VScript.rKeyword(this, "output_6_total_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_7_total_clks() {
        return new VScript.rKeyword(this, "output_7_total_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_0_active_clks() {
        return new VScript.rKeyword(this, "output_0_active_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_1_active_clks() {
        return new VScript.rKeyword(this, "output_1_active_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_2_active_clks() {
        return new VScript.rKeyword(this, "output_2_active_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_3_active_clks() {
        return new VScript.rKeyword(this, "output_3_active_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_4_active_clks() {
        return new VScript.rKeyword(this, "output_4_active_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_5_active_clks() {
        return new VScript.rKeyword(this, "output_5_active_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_6_active_clks() {
        return new VScript.rKeyword(this, "output_6_active_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_7_active_clks() {
        return new VScript.rKeyword(this, "output_7_active_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_0_load() {
        return new VScript.rKeyword(this, "output_0_load", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_1_load() {
        return new VScript.rKeyword(this, "output_1_load", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_2_load() {
        return new VScript.rKeyword(this, "output_2_load", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_3_load() {
        return new VScript.rKeyword(this, "output_3_load", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_4_load() {
        return new VScript.rKeyword(this, "output_4_load", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_5_load() {
        return new VScript.rKeyword(this, "output_5_load", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_6_load() {
        return new VScript.rKeyword(this, "output_6_load", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_7_load() {
        return new VScript.rKeyword(this, "output_7_load", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class ManifoldMemoryStatistics {
    raw;
    type_identifier = "Multiviewer::Data::ManifoldMemoryStatistics";
    constructor(raw) {
        this.raw = raw;
    }
    get mem_band_max_gbits() {
        return new VScript.rKeyword(this, "mem_band_max_gbits", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mem_band_write_gbits() {
        return new VScript.rKeyword(this, "mem_band_write_gbits", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mem_band_read_gbits() {
        return new VScript.rKeyword(this, "mem_band_read_gbits", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get video_static_rl_blocks() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 3, "video_static_rl_blocks"), (st, _) => VAPI.Multiviewer.lift.RLBLOCKSTATISTICS(st));
    }
    get video_dynamic_rl_blocks() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 4, "video_dynamic_rl_blocks"), (st, _) => VAPI.Multiviewer.lift.RLBLOCKSTATISTICS(st));
    }
    get graphics_rl_blocks() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 5, "graphics_rl_blocks"), (st, _) => VAPI.Multiviewer.lift.RLBLOCKSTATISTICS(st));
    }
}
export class MultiviewerGlobal {
    raw;
    type_identifier = "Multiviewer::Data::MultiviewerGlobal";
    constructor(raw) {
        this.raw = raw;
    }
    get configuration() {
        return VAPI.Multiviewer.lift.MultiviewerGlobalConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "configuration"));
    }
    get runtime() {
        return VAPI.Multiviewer.lift.MultiviewerGlobalRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "runtime"));
    }
}
export class MultiviewerGlobalConfiguration {
    raw;
    type_identifier = "Multiviewer::Data::MultiviewerGlobalConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get parameters() {
        return VAPI.Multiviewer.lift.MultiviewerGlobalConfigurationParameters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "parameters"));
    }
    get head() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "head"), (raw) => new VAPI.Multiviewer.MultiviewerHeadGlobalConfigurationAsNamedTableRow(raw));
    }
}
export class MultiviewerGlobalConfigurationParameters {
    raw;
    type_identifier = "Multiviewer::Data::MultiviewerGlobalConfigurationParameters";
    constructor(raw) {
        this.raw = raw;
    }
    get alarms() {
        return VAPI.Multiviewer.lift.ALARMSSEVERITYLEVELS(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "alarms"));
    }
}
export class MultiviewerGlobalRuntime {
    raw;
    type_identifier = "Multiviewer::Data::MultiviewerGlobalRuntime";
    constructor(raw) {
        this.raw = raw;
    }
    get head() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "head"), (raw, _) => VAPI.Multiviewer.lift.MultiviewerHeadGlobalRuntime(raw));
    }
}
export class MultiviewerHeadGlobalConfiguration {
    raw;
    type_identifier = "Multiviewer::Data::MultiviewerHeadGlobalConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get parameters() {
        return VAPI.Multiviewer.lift.MultiviewerHeadGlobalParameters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "parameters"));
    }
    get pip() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "pip"), (raw) => new VAPI.Multiviewer.PIPAsNamedTableRow(raw));
    }
    get ppm() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 2, "ppm"), (raw) => new VAPI.Multiviewer.STANDALONEPPMAsNamedTableRow(raw));
    }
    get analog_clock() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 3, "analog_clock"), (raw) => new VAPI.Multiviewer.ANALOGCLOCKAsNamedTableRow(raw));
    }
    get digital_clock() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 4, "digital_clock"), (raw) => new VAPI.Multiviewer.DIGITALCLOCKAsNamedTableRow(raw));
    }
    get text_box() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 5, "text_box"), (raw) => new VAPI.Multiviewer.TEXTBOXAsNamedTableRow(raw));
    }
    get image() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 6, "image"), (raw) => new VAPI.Multiviewer.IMAGEAsNamedTableRow(raw));
    }
}
export class MultiviewerHeadGlobalConfigurationAsNamedTableRow extends MultiviewerHeadGlobalConfiguration {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export class MultiviewerHeadGlobalParameters {
    raw;
    type_identifier = "Multiviewer::Data::MultiviewerHeadGlobalParameters";
    constructor(raw) {
        this.raw = raw;
    }
    get display_mode() {
        return new VScript.rwKeyword(this, "display_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get video_standard() {
        return new VScript.rwKeyword(this, "video_standard", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get double_buffer_mode() {
        return new VScript.rwKeyword(this, "double_buffer_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get rotation() {
        return new VScript.rwKeyword(this, "rotation", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get bgnd_colour() {
        return new VScript.rwKeyword(this, "bgnd_colour", {
            lift: VAPI.Multiviewer.lift.HSLCOLOUR,
            lower: VAPI.Multiviewer.lower.HSLCOLOUR
        }, {
            lift: VAPI.Multiviewer.lift.HSLCOLOUR,
            lower: VAPI.Multiviewer.lower.HSLCOLOUR
        }, null);
    }
    get layout() {
        return VAPI.Multiviewer.lift.MultiviewerHeadLayout(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "layout"));
    }
    get ppm_scale() {
        return VAPI.Multiviewer.lift.PPMSCALESETTINGS(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "ppm_scale"));
    }
    get tally_rules() {
        return VAPI.Multiviewer.lift.TALLYRULES(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "tally_rules"));
    }
    get streaming() {
        return VAPI.Multiviewer.lift.MultiviewerHeadStreamingConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "streaming"));
    }
}
export class MultiviewerHeadGlobalRuntime {
    raw;
    type_identifier = "Multiviewer::Data::MultiviewerHeadGlobalRuntime";
    constructor(raw) {
        this.raw = raw;
    }
    get pip() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "pip"), (raw, _) => VAPI.Multiviewer.lift.MultiviewerPIPGlobalRuntime(raw));
    }
}
export class MultiviewerHeadLayout {
    raw;
    type_identifier = "Multiviewer::Data::MultiviewerHeadLayout";
    constructor(raw) {
        this.raw = raw;
    }
    get layout_mode() {
        return new VScript.rwKeyword(this, "layout_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get pattern_id() {
        return new VScript.rwKeyword(this, "pattern_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get pattern_gap_x() {
        return new VScript.rwKeyword(this, "pattern_gap_x", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get pattern_gap_y() {
        return new VScript.rwKeyword(this, "pattern_gap_y", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get auto_monitoring() {
        return VAPI.Multiviewer.lift.AUTOMONITORINGSETTINGS(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "auto_monitoring"));
    }
}
export class MultiviewerHeadLocalRuntime {
    raw;
    type_identifier = "Multiviewer::Data::MultiviewerHeadLocalRuntime";
    constructor(raw) {
        this.raw = raw;
    }
    get pip() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "pip"), (raw, _) => VAPI.Multiviewer.lift.MultiviewerPIPLocalRuntime(raw));
    }
}
export class MultiviewerHeadStreamingConfiguration {
    raw;
    type_identifier = "Multiviewer::Data::MultiviewerHeadStreamingConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get enable() {
        return new VScript.rwKeyword(this, "enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get transport_format() {
        return new VScript.rwKeyword(this, "transport_format", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class MultiviewerLocal {
    raw;
    type_identifier = "Multiviewer::Data::MultiviewerLocal";
    constructor(raw) {
        this.raw = raw;
    }
    get runtime() {
        return VAPI.Multiviewer.lift.MultiviewerLocalRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "runtime"));
    }
}
export class MultiviewerLocalRuntime {
    raw;
    type_identifier = "Multiviewer::Data::MultiviewerLocalRuntime";
    constructor(raw) {
        this.raw = raw;
    }
    get head() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "head"), (raw, _) => VAPI.Multiviewer.lift.MultiviewerHeadLocalRuntime(raw));
    }
    get statistics() {
        return VAPI.Multiviewer.lift.MultiviewerStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "statistics"));
    }
}
export class MultiviewerPIPGlobalRuntime {
    raw;
    type_identifier = "Multiviewer::Data::MultiviewerPIPGlobalRuntime";
    constructor(raw) {
        this.raw = raw;
    }
    get use_full_size() {
        return new VScript.rKeyword(this, "use_full_size", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get resolution_level() {
        return new VScript.rKeyword(this, "resolution_level", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class MultiviewerPIPLocalRuntime {
    raw;
    type_identifier = "Multiviewer::Data::MultiviewerPIPLocalRuntime";
    constructor(raw) {
        this.raw = raw;
    }
    get routing() {
        return new VScript.rKeyword(this, "routing", {
            lift: VAPI.Multiviewer.lift.PIPROUTING,
            lower: VAPI.Multiviewer.lower.PIPROUTING
        });
    }
}
export class MultiviewerStatistics {
    raw;
    type_identifier = "Multiviewer::Data::MultiviewerStatistics";
    constructor(raw) {
        this.raw = raw;
    }
    get cores() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 0, "cores"), (st, _) => VAPI.Multiviewer.lift.ManifoldCoreStatistics(st));
    }
    get memory() {
        return VAPI.Multiviewer.lift.ManifoldMemoryStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "memory"));
    }
}
export class PPMSCALESETTINGSNordicRange {
    raw;
    type_identifier = "Multiviewer::Data::PPMSCALESETTINGS::NordicRange";
    constructor(raw) {
        this.raw = raw;
    }
    get safe_area() {
        return new VScript.rwKeyword(this, "safe_area", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get operation_area() {
        return new VScript.rwKeyword(this, "operation_area", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get min_level() {
        return new VScript.rwKeyword(this, "min_level", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get max_level() {
        return new VScript.rwKeyword(this, "max_level", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class PIP {
    raw;
    type_identifier = "Multiviewer::Data::PIP";
    constructor(raw) {
        this.raw = raw;
    }
    get monitoring_object_id() {
        return new VScript.rwKeyword(this, "monitoring_object_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get display_mode() {
        return new VScript.rwKeyword(this, "display_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get geometry() {
        return new VScript.rwKeyword(this, "geometry", {
            lift: VAPI.Multiviewer.lift.GEOMETRY,
            lower: VAPI.Multiviewer.lower.GEOMETRY
        }, {
            lift: VAPI.Multiviewer.lift.GEOMETRY,
            lower: VAPI.Multiviewer.lower.GEOMETRY
        }, null);
    }
    get keep_ar() {
        return new VScript.rwKeyword(this, "keep_ar", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get mipmap_bias() {
        return new VScript.rwKeyword(this, "mipmap_bias", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get bgnd() {
        return VAPI.Multiviewer.lift.BOX(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "bgnd"));
    }
    get video_crop() {
        return new VScript.rwKeyword(this, "video_crop", {
            lift: VAPI.Multiviewer.lift.CROP,
            lower: VAPI.Multiviewer.lower.CROP
        }, {
            lift: VAPI.Multiviewer.lift.CROP,
            lower: VAPI.Multiviewer.lower.CROP
        }, null);
    }
    get video_border() {
        return VAPI.Multiviewer.lift.BORDER(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "video_border"));
    }
    get ppms() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 8, "ppms"), (st, _) => VAPI.Multiviewer.lift.PIPPPM(st));
    }
    get omd() {
        return VAPI.Multiviewer.lift.MD(VScript.VAPIHelpers.subtree_child_checked(this.raw, 9, "omd"));
    }
    get umd() {
        return VAPI.Multiviewer.lift.MD(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "umd"));
    }
    get tally_lamps() {
        return VAPI.Multiviewer.lift.TALLYLAMPS(VScript.VAPIHelpers.subtree_child_checked(this.raw, 11, "tally_lamps"));
    }
    get tally_settings() {
        return VAPI.Multiviewer.lift.PIPTALLYSETTINGS(VScript.VAPIHelpers.subtree_child_checked(this.raw, 12, "tally_settings"));
    }
    get closed_caption() {
        return VAPI.Multiviewer.lift.CLOSEDCAPTION(VScript.VAPIHelpers.subtree_child_checked(this.raw, 13, "closed_caption"));
    }
}
export class PIPAsNamedTableRow extends PIP {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export class PIPPPM {
    raw;
    type_identifier = "Multiviewer::Data::PIPPPM";
    constructor(raw) {
        this.raw = raw;
    }
    get enable() {
        return new VScript.rwKeyword(this, "enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get alignment() {
        return new VScript.rwKeyword(this, "alignment", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get bgnd() {
        return VAPI.Multiviewer.lift.BOX(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "bgnd"));
    }
    get settings() {
        return new VScript.rwKeyword(this, "settings", {
            lift: VAPI.Multiviewer.lift.PPMSETTINGS,
            lower: VAPI.Multiviewer.lower.PPMSETTINGS
        }, {
            lift: VAPI.Multiviewer.lift.PPMSETTINGS,
            lower: VAPI.Multiviewer.lower.PPMSETTINGS
        }, null);
    }
}
export class PIPTALLYSETTINGS {
    raw;
    type_identifier = "Multiviewer::Data::PIPTALLYSETTINGS";
    constructor(raw) {
        this.raw = raw;
    }
    get mode() {
        return new VScript.rwKeyword(this, "mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get tally_mask() {
        return new VScript.rwKeyword(this, "tally_mask", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get rules() {
        return new VScript.rwKeyword(this, "rules", {
            lift: VAPI.Multiviewer.lift.PIPTALLYRULESSETTINGS,
            lower: VAPI.Multiviewer.lower.PIPTALLYRULESSETTINGS
        }, {
            lift: VAPI.Multiviewer.lift.PIPTALLYRULESSETTINGS,
            lower: VAPI.Multiviewer.lower.PIPTALLYRULESSETTINGS
        }, null);
    }
}
export class PPMSCALESETTINGS {
    raw;
    type_identifier = "Multiviewer::Data::PPMSCALESETTINGS";
    constructor(raw) {
        this.raw = raw;
    }
    get scale_strech() {
        return new VScript.rwKeyword(this, "scale_strech", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get d_b_f_s_range() {
        return VAPI.Multiviewer.lift.PPMSCALESETTINGSDBFSRange(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "d_b_f_s_range"));
    }
    get d_i_n_range() {
        return VAPI.Multiviewer.lift.PPMSCALESETTINGSDINRange(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "d_i_n_range"));
    }
    get nordic_range() {
        return VAPI.Multiviewer.lift.PPMSCALESETTINGSNordicRange(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "nordic_range"));
    }
    get b_b_c_range() {
        return VAPI.Multiviewer.lift.PPMSCALESETTINGSBBCRange(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "b_b_c_range"));
    }
}
export class RLBLOCKSTATISTICS {
    raw;
    type_identifier = "Multiviewer::Data::RLBLOCKSTATISTICS";
    constructor(raw) {
        this.raw = raw;
    }
    get total_num() {
        return new VScript.rKeyword(this, "total_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get free_num() {
        return new VScript.rKeyword(this, "free_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get used_num() {
        return new VScript.rKeyword(this, "used_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get max_width() {
        return new VScript.rKeyword(this, "max_width", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get max_height() {
        return new VScript.rKeyword(this, "max_height", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class STANDALONEPPM {
    raw;
    type_identifier = "Multiviewer::Data::STANDALONEPPM";
    constructor(raw) {
        this.raw = raw;
    }
    get monitoring_object_id() {
        return new VScript.rwKeyword(this, "monitoring_object_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get display_mode() {
        return new VScript.rwKeyword(this, "display_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get geometry() {
        return new VScript.rwKeyword(this, "geometry", {
            lift: VAPI.Multiviewer.lift.GEOMETRY,
            lower: VAPI.Multiviewer.lower.GEOMETRY
        }, {
            lift: VAPI.Multiviewer.lift.GEOMETRY,
            lower: VAPI.Multiviewer.lower.GEOMETRY
        }, null);
    }
    get bgnd() {
        return VAPI.Multiviewer.lift.BOX(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "bgnd"));
    }
    get settings() {
        return new VScript.rwKeyword(this, "settings", {
            lift: VAPI.Multiviewer.lift.PPMSETTINGS,
            lower: VAPI.Multiviewer.lower.PPMSETTINGS
        }, {
            lift: VAPI.Multiviewer.lift.PPMSETTINGS,
            lower: VAPI.Multiviewer.lower.PPMSETTINGS
        }, null);
    }
}
export class STANDALONEPPMAsNamedTableRow extends STANDALONEPPM {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export class STOPWATCHCMD {
    raw;
    type_identifier = "Multiviewer::Data::STOPWATCHCMD";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Start
    */
    get start() {
        return new VScript.wKeyword(this, "start", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Stop
    */
    get stop() {
        return new VScript.wKeyword(this, "stop", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Pause
    */
    get pause() {
        return new VScript.wKeyword(this, "pause", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Reset
    */
    get reset() {
        return new VScript.wKeyword(this, "reset", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Restart
    */
    get restart() {
        return new VScript.wKeyword(this, "restart", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Lap
    */
    get lap() {
        return new VScript.wKeyword(this, "lap", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class STOPWATCHSETTINGS {
    raw;
    type_identifier = "Multiviewer::Data::STOPWATCHSETTINGS";
    constructor(raw) {
        this.raw = raw;
    }
    get mode() {
        return new VScript.rwKeyword(this, "mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get count_after_finished() {
        return new VScript.rwKeyword(this, "count_after_finished", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get colour_after_finished() {
        return new VScript.rwKeyword(this, "colour_after_finished", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get blinking_after_finished() {
        return new VScript.rwKeyword(this, "blinking_after_finished", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get cmd() {
        return VAPI.Multiviewer.lift.STOPWATCHCMD(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "cmd"));
    }
    get target_or_duration() {
        return new VScript.rwKeyword(this, "target_or_duration", {
            lift: VAPI.Multiviewer.lift.CLOCKTIME,
            lower: VAPI.Multiviewer.lower.CLOCKTIME
        }, {
            lift: VAPI.Multiviewer.lift.CLOCKTIME,
            lower: VAPI.Multiviewer.lower.CLOCKTIME
        }, null);
    }
    get finish_colour_time() {
        return new VScript.rwKeyword(this, "finish_colour_time", {
            lift: VAPI.Multiviewer.lift.CLOCKTIME,
            lower: VAPI.Multiviewer.lower.CLOCKTIME
        }, {
            lift: VAPI.Multiviewer.lift.CLOCKTIME,
            lower: VAPI.Multiviewer.lower.CLOCKTIME
        }, null);
    }
    get finish_blinking_time() {
        return new VScript.rwKeyword(this, "finish_blinking_time", {
            lift: VAPI.Multiviewer.lift.CLOCKTIME,
            lower: VAPI.Multiviewer.lower.CLOCKTIME
        }, {
            lift: VAPI.Multiviewer.lift.CLOCKTIME,
            lower: VAPI.Multiviewer.lower.CLOCKTIME
        }, null);
    }
    get finish_colour() {
        return new VScript.rwKeyword(this, "finish_colour", {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, null);
    }
    get state() {
        return new VScript.rKeyword(this, "state", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get is_finish_colour() {
        return new VScript.rKeyword(this, "is_finish_colour", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get is_finish_blinking() {
        return new VScript.rKeyword(this, "is_finish_blinking", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get is_finished() {
        return new VScript.rKeyword(this, "is_finished", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class TALLYLAMPS {
    raw;
    type_identifier = "Multiviewer::Data::TALLYLAMPS";
    constructor(raw) {
        this.raw = raw;
    }
    get enable() {
        return new VScript.rwKeyword(this, "enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get width() {
        return new VScript.rwKeyword(this, "width", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get left_lamp() {
        return VAPI.Multiviewer.lift.BOX(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "left_lamp"));
    }
    get right_lamp() {
        return VAPI.Multiviewer.lift.BOX(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "right_lamp"));
    }
}
export class TALLYRULE {
    raw;
    type_identifier = "Multiviewer::Data::TALLYRULE";
    constructor(raw) {
        this.raw = raw;
    }
    get bit_id() {
        return new VScript.rwKeyword(this, "bit_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get priority_id() {
        return new VScript.rwKeyword(this, "priority_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get colour() {
        return new VScript.rwKeyword(this, "colour", {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, null);
    }
}
export class TALLYRULES {
    raw;
    type_identifier = "Multiviewer::Data::TALLYRULES";
    constructor(raw) {
        this.raw = raw;
    }
    get rule_0() {
        return VAPI.Multiviewer.lift.TALLYRULE(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "rule_0"));
    }
    get rule_1() {
        return VAPI.Multiviewer.lift.TALLYRULE(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "rule_1"));
    }
    get rule_2() {
        return VAPI.Multiviewer.lift.TALLYRULE(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "rule_2"));
    }
    get rule_3() {
        return VAPI.Multiviewer.lift.TALLYRULE(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "rule_3"));
    }
    get rule_4() {
        return VAPI.Multiviewer.lift.TALLYRULE(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "rule_4"));
    }
    get rule_5() {
        return VAPI.Multiviewer.lift.TALLYRULE(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "rule_5"));
    }
    get rule_6() {
        return VAPI.Multiviewer.lift.TALLYRULE(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "rule_6"));
    }
    get rule_7() {
        return VAPI.Multiviewer.lift.TALLYRULE(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "rule_7"));
    }
}
export class TEXTBOX {
    raw;
    type_identifier = "Multiviewer::Data::TEXTBOX";
    constructor(raw) {
        this.raw = raw;
    }
    get display_mode() {
        return new VScript.rwKeyword(this, "display_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get geometry() {
        return new VScript.rwKeyword(this, "geometry", {
            lift: VAPI.Multiviewer.lift.GEOMETRY,
            lower: VAPI.Multiviewer.lower.GEOMETRY
        }, {
            lift: VAPI.Multiviewer.lift.GEOMETRY,
            lower: VAPI.Multiviewer.lower.GEOMETRY
        }, null);
    }
    get bgnd() {
        return VAPI.Multiviewer.lift.BOX(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "bgnd"));
    }
    get label() {
        return VAPI.Multiviewer.lift.LABEL(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "label"));
    }
    get arg0() {
        return new VScript.rwKeyword(this, "arg0", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get arg1() {
        return new VScript.rwKeyword(this, "arg1", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get flash_bgnd_colour() {
        return new VScript.rwKeyword(this, "flash_bgnd_colour", {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, null);
    }
    get flash_label_colour() {
        return new VScript.rwKeyword(this, "flash_label_colour", {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, {
            lift: VAPI.Multiviewer.lift.HSLCOLOURWITHOPACITY,
            lower: VAPI.Multiviewer.lower.HSLCOLOURWITHOPACITY
        }, null);
    }
    get flash_speed() {
        return new VScript.rwKeyword(this, "flash_speed", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class TEXTBOXAsNamedTableRow extends TEXTBOX {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export class TMPREMOVEDFROMPIPStruct {
    raw;
    type_identifier = "Multiviewer::Data::TMPREMOVEDFROMPIPStruct";
    constructor(raw) {
        this.raw = raw;
    }
    get alarms() {
        return VAPI.ClusterMonitoringObjects.lift.ClusterMonitoringObjectAlarmsEnable(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "alarms"));
    }
}
export class PPMSCALESETTINGSDBFSRange {
    raw;
    type_identifier = "Multiviewer::Data::PPMSCALESETTINGS::DBFSRange";
    constructor(raw) {
        this.raw = raw;
    }
    get safe_area() {
        return new VScript.rwKeyword(this, "safe_area", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get operation_area() {
        return new VScript.rwKeyword(this, "operation_area", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get min_level() {
        return new VScript.rwKeyword(this, "min_level", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get max_level() {
        return new VScript.rwKeyword(this, "max_level", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export const Enums = {
    TIMEFORMAT: ["HHMMSS", "HMMSS12"],
    STOPWATCHSTATE: ["STOP", "PAUSE", "RUN", "LAP"],
    STOPWATCHMODE: ["OFF", "COUNT_UP_DURATION", "COUNT_DOWN_DURATION", "COUNT_UP_TARGET", "COUNT_DOWN_TARGET", "COUNT_UP_START"],
    STOPWATCHCMDTYPE: ["eNone", "eStart", "eStop", "ePause", "eReset", "eRestart", "eLap"],
    RESOLUTIONLEVEL: ["UNDEFINED", "FULL_SIZE", "ONE_4", "ONE_16", "ONE_64", "ONE_256"],
    PPMScaleType: ["dBFS", "DIN", "Nordic", "BBC"],
    PPMScalePosition: ["Left", "Right", "LeftAndRight", "None"],
    PPMDisplayMode: ["ColourBars", "ColourBarsGradient", "ColourLEDs", "ColourLEDsGradient"],
    PPMDECAY: ["decay_Fast", "decay_24db_2_8s", "decay_20db_1_7s", "decay_20db_1_5s"],
    PIPTALLYMODE: ["PIP_TALLY_MASK", "VIDEO_SOURCE_TALLY_MASK", "MONITORING_OBJECT_TALLY_MASK"],
    PIPPPMALIGNMENT: ["LEFT_INSIDE", "LEFT_OUTSIDE", "RIGHT_INSIDE", "RIGHT_OUTSIDE"],
    PEAKHOLDTIME: ["Off", "OneSecond", "TwoSeconds", "ThreeSeconds", "FourSeconds"],
    PEAKHOLDDECAY: ["Off", "Slow", "Medium", "Fast"],
    MDMODE: ["SINGLE", "DUAL", "TRIPLE"],
    MDCELLMODE: ["AUDIO_SOURCE_0_NAME", "LABEL", "PIP_NAME", "METADATA_SOURCE_0_NAME", "METADATA_SOURCE_0_TIMECODE", "MONITORING_OBJECT_VIDEO_SOURCE_LABEL", "MONITORING_OBJECT_USER_LABEL_0", "MONITORING_OBJECT_USER_LABEL_1", "MONITORING_OBJECT_USER_LABEL_2", "MONITORING_OBJECT_USER_LABEL_3", "MONITORING_OBJECT_USER_LABEL_4", "MONITORING_OBJECT_USER_LABEL_5", "VIDEO_SOURCE_LABEL", "VIDEO_SOURCE_0_NAME", "VIDEO_STANDARD"],
    HEADLAYOUTMODE: ["MANUAL", "AUTO", "AUTO_MONITORING", "PATTERN_ID"],
    FONTSTYLE: ["NORMAL", "ITALIC", "BOLD", "BOLD_ITALIC"],
    FONTFAMILY: ["OPEN_SANS", "DSEG7_Classic", "DSEG7_Classic_MINI", "DSEG7_Modern", "DSEG7_Modern_MINI", "DSEG14_Classic", "DSEG14_Classic_MINI", "DSEG14_Modern", "DSEG14_Modern_MINI", "NOTO_SANS_TC", "NOTO_SANS_MONO", "FIRA_CODE_MONO"],
    DISPLAYMODE: ["ON", "OFF", "NAME"],
    BORDERRADIUSCORNERS: ["All", "Top", "Bottom", "Left", "Right", "TopLeft", "TopRight", "BottomLeft", "BottomRight"],
    ALIGNMENT: ["INSIDE", "OUTSIDE"]
};
