import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    CurrentBridgeConfiguration: (_raw) => (new CurrentBridgeConfiguration(_raw)),
    CurrentPortConfiguration: (_raw) => (new CurrentPortConfiguration(_raw)),
    CurrentSyslogConfiguration: (_raw) => (new CurrentSyslogConfiguration(_raw)),
    CurrentSyslogServer: (_raw) => (new CurrentSyslogServer(_raw)),
    CurrentVirtualEthernetConfiguration: (_raw) => (new CurrentVirtualEthernetConfiguration(_raw)),
    CurrentVirtualInterfaceConfiguration: (_raw) => (new CurrentVirtualInterfaceConfiguration(_raw)),
    DesiredBridgeConfiguration: (_raw) => (new DesiredBridgeConfiguration(_raw)),
    DesiredPortConfiguration: (_raw) => (new DesiredPortConfiguration(_raw)),
    DesiredSyslogConfiguration: (_raw) => (new DesiredSyslogConfiguration(_raw)),
    DesiredSyslogServer: (_raw) => (new DesiredSyslogServer(_raw)),
    DesiredVirtualEthernetConfiguration: (_raw) => (new DesiredVirtualEthernetConfiguration(_raw)),
    DesiredVirtualInterfaceConfiguration: (_raw) => (new DesiredVirtualInterfaceConfiguration(_raw)),
    ErrorWindow: (_raw, _socket) => {
        return {
            window: VScript.VAPIHelpers.liftNanoseconds(_raw[0], _socket),
            threshold: _raw[1]
        };
    },
    EyeDiagram: (_raw) => (new EyeDiagram(_raw)),
    Health: (_raw) => (new Health(_raw)),
    HostnameConfiguration: (_raw) => (new HostnameConfiguration(_raw)),
    LLDPNeighbor: (_raw) => (new LLDPNeighbor(_raw)),
    VirtualInterface: (_raw) => (new VirtualInterface(_raw)),
    CurrentBridgeConfigurationDevices: (_raw) => (new CurrentBridgeConfigurationDevices(_raw)),
    DesiredBridgeConfigurationDevices: (_raw) => (new DesiredBridgeConfigurationDevices(_raw)),
    CurrentVirtualInterfaceConfigurationIpAddresses: (_raw) => (new CurrentVirtualInterfaceConfigurationIpAddresses(_raw)),
    DesiredVirtualInterfaceConfigurationIpAddresses: (_raw) => (new DesiredVirtualInterfaceConfigurationIpAddresses(_raw)),
    MaskedIpAddress: (_raw) => (new MaskedIpAddress(_raw)),
    CurrentVirtualInterfaceConfigurationRoutes: (_raw) => (new CurrentVirtualInterfaceConfigurationRoutes(_raw)),
    DesiredVirtualInterfaceConfigurationRoutes: (_raw) => (new DesiredVirtualInterfaceConfigurationRoutes(_raw)),
    CurrentVirtualEthernetConfigurationVeths: (_raw) => (new CurrentVirtualEthernetConfigurationVeths(_raw)),
    DesiredVirtualEthernetConfigurationVeths: (_raw) => (new DesiredVirtualEthernetConfigurationVeths(_raw)),
    CurrentPortConfigurationVlans: (_raw) => (new CurrentPortConfigurationVlans(_raw)),
    DesiredPortConfigurationVlans: (_raw) => (new DesiredPortConfigurationVlans(_raw)),
};
export const lower = {
    CurrentBridgeConfiguration: (_x) => _x.raw.kwl,
    CurrentPortConfiguration: (_x) => _x.raw.kwl,
    CurrentSyslogConfiguration: (_x) => _x.raw.kwl,
    CurrentSyslogServer: (_x) => _x.raw.kwl,
    CurrentVirtualEthernetConfiguration: (_x) => _x.raw.kwl,
    CurrentVirtualInterfaceConfiguration: (_x) => _x.raw.kwl,
    DesiredBridgeConfiguration: (_x) => _x.raw.kwl,
    DesiredPortConfiguration: (_x) => _x.raw.kwl,
    DesiredSyslogConfiguration: (_x) => _x.raw.kwl,
    DesiredSyslogServer: (_x) => _x.raw.kwl,
    DesiredVirtualEthernetConfiguration: (_x) => _x.raw.kwl,
    DesiredVirtualInterfaceConfiguration: (_x) => _x.raw.kwl,
    ErrorWindow: (_x, _socket) => [
        VScript.VAPIHelpers.lowerNanoseconds(_x.window, _socket),
        _x.threshold
    ],
    EyeDiagram: (_x) => _x.raw.kwl,
    Health: (_x) => _x.raw.kwl,
    HostnameConfiguration: (_x) => _x.raw.kwl,
    LLDPNeighbor: (_x) => _x.raw.kwl,
    VirtualInterface: (_x) => _x.raw.kwl,
    CurrentBridgeConfigurationDevices: (_x) => _x.raw.kwl,
    DesiredBridgeConfigurationDevices: (_x) => _x.raw.kwl,
    CurrentVirtualInterfaceConfigurationIpAddresses: (_x) => _x.raw.kwl,
    DesiredVirtualInterfaceConfigurationIpAddresses: (_x) => _x.raw.kwl,
    MaskedIpAddress: (_x) => _x.raw.kwl,
    CurrentVirtualInterfaceConfigurationRoutes: (_x) => _x.raw.kwl,
    DesiredVirtualInterfaceConfigurationRoutes: (_x) => _x.raw.kwl,
    CurrentVirtualEthernetConfigurationVeths: (_x) => _x.raw.kwl,
    DesiredVirtualEthernetConfigurationVeths: (_x) => _x.raw.kwl,
    CurrentPortConfigurationVlans: (_x) => _x.raw.kwl,
    DesiredPortConfigurationVlans: (_x) => _x.raw.kwl,
};
export class CurrentBridgeConfiguration {
    raw;
    type_identifier = "NetworkInterfaces::Data::CurrentBridgeConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get brief() {
        return new VScript.rKeyword(this, "brief", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get stp() {
        return new VScript.rKeyword(this, "stp", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get settings() {
        return VAPI.NetworkInterfaces.lift.CurrentVirtualInterfaceConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "settings"));
    }
    get devices() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 3, "devices"), (raw, _) => VAPI.NetworkInterfaces.lift.CurrentBridgeConfigurationDevices(raw));
    }
}
export class CurrentPortConfiguration {
    raw;
    type_identifier = "NetworkInterfaces::Data::CurrentPortConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get base() {
        return VAPI.NetworkInterfaces.lift.CurrentVirtualInterfaceConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "base"));
    }
    get vlans() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "vlans"), (raw, _) => VAPI.NetworkInterfaces.lift.CurrentPortConfigurationVlans(raw));
    }
    get bridges() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "bridges"), (raw, _) => VAPI.NetworkInterfaces.lift.CurrentBridgeConfiguration(raw));
    }
    get unknown_commands() {
        return new VScript.rKeyword(this, "unknown_commands", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class CurrentSyslogConfiguration {
    raw;
    type_identifier = "NetworkInterfaces::Data::CurrentSyslogConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get syslog_servers() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 0, "syslog_servers"), (st, _) => VAPI.NetworkInterfaces.lift.CurrentSyslogServer(st));
    }
}
export class CurrentSyslogServer {
    raw;
    type_identifier = "NetworkInterfaces::Data::CurrentSyslogServer";
    constructor(raw) {
        this.raw = raw;
    }
    get address() {
        return new VScript.rKeyword(this, "address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get protocol() {
        return new VScript.rKeyword(this, "protocol", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get rebind_interval() {
        return new VScript.rKeyword(this, "rebind_interval", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get keep_alive() {
        return new VScript.rKeyword(this, "keep_alive", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
}
export class CurrentVirtualEthernetConfiguration {
    raw;
    type_identifier = "NetworkInterfaces::Data::CurrentVirtualEthernetConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get veths() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "veths"), (raw, _) => VAPI.NetworkInterfaces.lift.CurrentVirtualEthernetConfigurationVeths(raw));
    }
}
export class CurrentVirtualInterfaceConfiguration {
    raw;
    type_identifier = "NetworkInterfaces::Data::CurrentVirtualInterfaceConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get brief() {
        return new VScript.rKeyword(this, "brief", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get ip_addresses() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "ip_addresses"), (raw, _) => VAPI.NetworkInterfaces.lift.CurrentVirtualInterfaceConfigurationIpAddresses(raw));
    }
    get routes() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "routes"), (raw, _) => VAPI.NetworkInterfaces.lift.CurrentVirtualInterfaceConfigurationRoutes(raw));
    }
    get dhcp() {
        return new VScript.rKeyword(this, "dhcp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      BusyBox NTP server using current system time as source
    */
    get ntpd() {
        return new VScript.rKeyword(this, "ntpd", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get reverse_path_filter() {
        return new VScript.rKeyword(this, "reverse_path_filter", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
}
export class DesiredBridgeConfiguration {
    raw;
    type_identifier = "NetworkInterfaces::Data::DesiredBridgeConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get brief() {
        return new VScript.rKeyword(this, "brief", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      Enable spanning tree protocol on this bridge
    */
    get stp() {
        return new VScript.rwKeyword(this, "stp", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    get settings() {
        return VAPI.NetworkInterfaces.lift.DesiredVirtualInterfaceConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "settings"));
    }
    /**
      Delete
    */
    get delete_bridge() {
        return new VScript.wKeyword(this, "delete_bridge", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get devices() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 4, "devices"), (st, _) => VAPI.NetworkInterfaces.lift.DesiredBridgeConfigurationDevices(st));
    }
}
export class DesiredPortConfiguration {
    raw;
    type_identifier = "NetworkInterfaces::Data::DesiredPortConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get base() {
        return VAPI.NetworkInterfaces.lift.DesiredVirtualInterfaceConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "base"));
    }
    /**
      Add VLAN
    */
    get add_vlan() {
        return new VScript.wKeyword(this, "add_vlan", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get vlans() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "vlans"), (raw, _) => VAPI.NetworkInterfaces.lift.DesiredPortConfigurationVlans(raw));
    }
    /**
      Add Bridge
    */
    get add_bridge() {
        return new VScript.wKeyword(this, "add_bridge", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get bridges() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "bridges"), (raw, _) => VAPI.NetworkInterfaces.lift.DesiredBridgeConfiguration(raw));
    }
}
export class DesiredSyslogConfiguration {
    raw;
    type_identifier = "NetworkInterfaces::Data::DesiredSyslogConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get syslog_servers() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 0, "syslog_servers"), (st, _) => VAPI.NetworkInterfaces.lift.DesiredSyslogServer(st));
    }
}
export class DesiredSyslogServer {
    raw;
    type_identifier = "NetworkInterfaces::Data::DesiredSyslogServer";
    constructor(raw) {
        this.raw = raw;
    }
    get address() {
        return new VScript.rwKeyword(this, "address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    get protocol() {
        return new VScript.rwKeyword(this, "protocol", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get rebind_interval() {
        return new VScript.rwKeyword(this, "rebind_interval", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    get keep_alive() {
        return new VScript.rwKeyword(this, "keep_alive", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class DesiredVirtualEthernetConfiguration {
    raw;
    type_identifier = "NetworkInterfaces::Data::DesiredVirtualEthernetConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Save veth settings
    */
    get save_veth_config() {
        return new VScript.wKeyword(this, "save_veth_config", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Revert veth settings
    */
    get revert_veth_config() {
        return new VScript.wKeyword(this, "revert_veth_config", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Add VETH
    */
    get add_veth() {
        return new VScript.wKeyword(this, "add_veth", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get veths() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 3, "veths"), (raw, _) => VAPI.NetworkInterfaces.lift.DesiredVirtualEthernetConfigurationVeths(raw));
    }
}
export class DesiredVirtualInterfaceConfiguration {
    raw;
    type_identifier = "NetworkInterfaces::Data::DesiredVirtualInterfaceConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get brief() {
        return new VScript.rKeyword(this, "brief", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      Add IP address
    */
    get add_ip_address() {
        return new VScript.wKeyword(this, "add_ip_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get ip_addresses() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "ip_addresses"), (raw, _) => VAPI.NetworkInterfaces.lift.DesiredVirtualInterfaceConfigurationIpAddresses(raw));
    }
    /**
      Add route
    */
    get add_route() {
        return new VScript.wKeyword(this, "add_route", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get routes() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "routes"), (raw, _) => VAPI.NetworkInterfaces.lift.DesiredVirtualInterfaceConfigurationRoutes(raw));
    }
    get dhcp() {
        return new VScript.rwKeyword(this, "dhcp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      BusyBox NTP server using current system time as source
    */
    get ntpd() {
        return new VScript.rwKeyword(this, "ntpd", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get reverse_path_filter() {
        return new VScript.rwKeyword(this, "reverse_path_filter", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
}
export class EyeDiagram {
    raw;
    type_identifier = "NetworkInterfaces::Data::EyeDiagram";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Generate eye diagram
    */
    get generate() {
        return new VScript.wKeyword(this, "generate", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get progress() {
        return new VScript.rKeyword(this, "progress", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    /**
      @brief URL of the eye diagram
      @desc An update to this keyword signals a new eye diagram has been
      generated
    */
    get url() {
        return new VScript.rKeyword(this, "url", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      @brief Measure eye opening only
      @desc Only measure horizontal eye opening (much faster than a full eye)
    */
    get measure_ui() {
        return new VScript.wKeyword(this, "measure_ui", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get ui() {
        return new VScript.rKeyword(this, "ui", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
}
export class Health {
    raw;
    type_identifier = "NetworkInterfaces::Data::Health";
    constructor(raw) {
        this.raw = raw;
    }
    get unreliable() {
        return new VScript.rKeyword(this, "unreliable", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    /**
      Include aggregate_traffic_statistics.rx_error and
      aggregate_traffic_statistics.rx_crc_error in addition to the BIP error
      counters (which are only available in 40GbE)
    */
    get include_rx_errors() {
        return new VScript.rwKeyword(this, "include_rx_errors", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get set_unreliable() {
        return new VScript.dKeyword(this, "set_unreliable", {
            lift: VAPI.NetworkInterfaces.lift.ErrorWindow,
            lower: VAPI.NetworkInterfaces.lower.ErrorWindow
        }, {
            lift: VAPI.NetworkInterfaces.lift.ErrorWindow,
            lower: VAPI.NetworkInterfaces.lower.ErrorWindow
        }, null);
    }
    get clear_unreliable() {
        return new VScript.dKeyword(this, "clear_unreliable", {
            lift: VAPI.NetworkInterfaces.lift.ErrorWindow,
            lower: VAPI.NetworkInterfaces.lower.ErrorWindow
        }, {
            lift: VAPI.NetworkInterfaces.lift.ErrorWindow,
            lower: VAPI.NetworkInterfaces.lower.ErrorWindow
        }, null);
    }
}
export class HostnameConfiguration {
    raw;
    type_identifier = "NetworkInterfaces::Data::HostnameConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Save hostname settings
    */
    get save_hostname_config() {
        return new VScript.wKeyword(this, "save_hostname_config", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Revert hostname settings
    */
    get revert_hostname_config() {
        return new VScript.wKeyword(this, "revert_hostname_config", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get current_configuration() {
        return new VScript.rKeyword(this, "current_configuration", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      A valid hostname may only contain the following characters: 0-9, a-z,
      A-Z, - and .
    */
    get desired_configuration() {
        return new VScript.rwKeyword(this, "desired_configuration", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class LLDPNeighbor {
    raw;
    type_identifier = "NetworkInterfaces::Data::LLDPNeighbor";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      System runtime since boot
    */
    get last_changed() {
        return new VScript.rKeyword(this, "last_changed", {
            lift: VScript.VAPIHelpers.liftNanoseconds,
            lower: VScript.VAPIHelpers.lowerNanoseconds
        });
    }
    get rid() {
        return new VScript.rKeyword(this, "rid", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get system_name() {
        return new VScript.rKeyword(this, "system_name", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get system_description() {
        return new VScript.rKeyword(this, "system_description", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get chassis_id() {
        return new VScript.rKeyword(this, "chassis_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get interface_name() {
        return new VScript.rKeyword(this, "interface_name", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get vlan_id() {
        return new VScript.rKeyword(this, "vlan_id", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get mgmt_addr_v4() {
        return new VScript.rKeyword(this, "mgmt_addr_v4", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get mgmt_addr_v6() {
        return new VScript.rKeyword(this, "mgmt_addr_v6", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
}
export class VirtualInterface {
    raw;
    type_identifier = "NetworkInterfaces::Data::VirtualInterface";
    constructor(raw) {
        this.raw = raw;
    }
    get brief() {
        return new VScript.rKeyword(this, "brief", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      TODO: look up actual upper bound
    */
    get linux_ifc_index() {
        return new VScript.rKeyword(this, "linux_ifc_index", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    /**
      NOTE: the empty string is interpreted as <null>
    */
    get ifname() {
        return new VScript.rKeyword(this, "ifname", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get ip_addresses() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 3, "ip_addresses"), (raw, _) => VAPI.NetworkInterfaces.lift.MaskedIpAddress(raw));
    }
    get vlan_id() {
        return new VScript.rKeyword(this, "vlan_id", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get supports_ptp() {
        return new VScript.rKeyword(this, "supports_ptp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get supports_rtp() {
        return new VScript.rKeyword(this, "supports_rtp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get active() {
        return new VScript.rKeyword(this, "active", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class CurrentBridgeConfigurationDevices {
    raw;
    type_identifier = "NetworkInterfaces::Data::CurrentBridgeConfiguration::Devices";
    constructor(raw) {
        this.raw = raw;
    }
    get wrapped_reference() {
        return new VScript.rKeyword(this, "wrapped_reference", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.CurrentVirtualInterfaceConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
        });
    }
}
export class DesiredBridgeConfigurationDevices {
    raw;
    type_identifier = "NetworkInterfaces::Data::DesiredBridgeConfiguration::Devices";
    constructor(raw) {
        this.raw = raw;
    }
    get wrapped_reference() {
        return new VScript.rwKeyword(this, "wrapped_reference", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.DesiredVirtualInterfaceConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
        }, null);
    }
}
export class CurrentVirtualInterfaceConfigurationIpAddresses {
    raw;
    type_identifier = "NetworkInterfaces::Data::CurrentVirtualInterfaceConfiguration::IpAddresses";
    constructor(raw) {
        this.raw = raw;
    }
    get ip_address() {
        return new VScript.rKeyword(this, "ip_address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get prefix() {
        return new VScript.rKeyword(this, "prefix", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
}
export class DesiredVirtualInterfaceConfigurationIpAddresses {
    raw;
    type_identifier = "NetworkInterfaces::Data::DesiredVirtualInterfaceConfiguration::IpAddresses";
    constructor(raw) {
        this.raw = raw;
    }
    get ip_address() {
        return new VScript.rwKeyword(this, "ip_address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    get prefix() {
        return new VScript.rwKeyword(this, "prefix", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Delete
    */
    get delete_ip_address() {
        return new VScript.wKeyword(this, "delete_ip_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class MaskedIpAddress {
    raw;
    type_identifier = "NetworkInterfaces::Data::MaskedIpAddress";
    constructor(raw) {
        this.raw = raw;
    }
    get ip_address() {
        return new VScript.rKeyword(this, "ip_address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get netmask() {
        return new VScript.rKeyword(this, "netmask", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
}
export class CurrentVirtualInterfaceConfigurationRoutes {
    raw;
    type_identifier = "NetworkInterfaces::Data::CurrentVirtualInterfaceConfiguration::Routes";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Destination address or subnet for this route. Blank for the default
      route.
    */
    get dst() {
        return new VScript.rKeyword(this, "dst", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get dst_prefix() {
        return new VScript.rKeyword(this, "dst_prefix", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get via() {
        return new VScript.rKeyword(this, "via", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get weight() {
        return new VScript.rKeyword(this, "weight", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
}
export class DesiredVirtualInterfaceConfigurationRoutes {
    raw;
    type_identifier = "NetworkInterfaces::Data::DesiredVirtualInterfaceConfiguration::Routes";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Destination address or subnet for this route. Leave blank for the default
      route.
    */
    get dst() {
        return new VScript.rwKeyword(this, "dst", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    get dst_prefix() {
        return new VScript.rwKeyword(this, "dst_prefix", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    get via() {
        return new VScript.rwKeyword(this, "via", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    get weight() {
        return new VScript.rwKeyword(this, "weight", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    /**
      Delete
    */
    get delete_route() {
        return new VScript.wKeyword(this, "delete_route", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class CurrentVirtualEthernetConfigurationVeths {
    raw;
    type_identifier = "NetworkInterfaces::Data::CurrentVirtualEthernetConfiguration::Veths";
    constructor(raw) {
        this.raw = raw;
    }
    get brief() {
        return new VScript.rKeyword(this, "brief", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get endpoint0() {
        return new VScript.rKeyword(this, "endpoint0", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.CurrentBridgeConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
        });
    }
    get endpoint1() {
        return new VScript.rKeyword(this, "endpoint1", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.CurrentBridgeConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
        });
    }
}
export class DesiredVirtualEthernetConfigurationVeths {
    raw;
    type_identifier = "NetworkInterfaces::Data::DesiredVirtualEthernetConfiguration::Veths";
    constructor(raw) {
        this.raw = raw;
    }
    get brief() {
        return new VScript.rKeyword(this, "brief", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      Delete this VETH
    */
    get delete_veth() {
        return new VScript.wKeyword(this, "delete_veth", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get endpoint0() {
        return new VScript.rwKeyword(this, "endpoint0", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.DesiredBridgeConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.DesiredBridgeConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
        }, null);
    }
    get endpoint1() {
        return new VScript.rwKeyword(this, "endpoint1", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.DesiredBridgeConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.DesiredBridgeConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
        }, null);
    }
}
export class CurrentPortConfigurationVlans {
    raw;
    type_identifier = "NetworkInterfaces::Data::CurrentPortConfiguration::Vlans";
    constructor(raw) {
        this.raw = raw;
    }
    get vlan_id() {
        return new VScript.rKeyword(this, "vlan_id", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get settings() {
        return VAPI.NetworkInterfaces.lift.CurrentVirtualInterfaceConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "settings"));
    }
}
export class DesiredPortConfigurationVlans {
    raw;
    type_identifier = "NetworkInterfaces::Data::DesiredPortConfiguration::Vlans";
    constructor(raw) {
        this.raw = raw;
    }
    get vlan_id() {
        return new VScript.rwKeyword(this, "vlan_id", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
    /**
      Delete
    */
    get delete_vlan() {
        return new VScript.wKeyword(this, "delete_vlan", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get settings() {
        return VAPI.NetworkInterfaces.lift.DesiredVirtualInterfaceConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "settings"));
    }
}
export const Enums = {
    ReversePathFilter: ["Disabled", "Loose", "Strict"],
    Protocol: ["UDP", "TCP"],
    FaultStatus: ["LINK_UP", "LOCAL_FAULT", "REMOTE_FAULT"]
};
