import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly ClockQuality: (_raw: [VAPI.PTP.ClockClass, VAPI.PTP.ClockAccuracy, number], _socket: VScript.VSocket) => ClockQuality;
    readonly PortIdentity: (_raw: [Array<number>, number], _socket: VScript.VSocket) => PortIdentity;
    readonly Traits: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.PTP.Traits;
};
export declare const lower: {
    readonly ClockQuality: (_x: {
        clock_class: VAPI.PTP.ClockClass;
        clock_accuracy: VAPI.PTP.ClockAccuracy;
        offset_scaled_log_variance: VAPI.Primitives.Unsigned16;
    }, _socket: VScript.VSocket) => [VAPI.PTP.ClockClass, VAPI.PTP.ClockAccuracy, number];
    readonly PortIdentity: (_x: {
        /**
          ClockIdentity as defined by the PTP standard, stored in big-endian
          order.
        */
        clock_identity: VAPI.PTP.ClockIdentity;
        port_number: VAPI.Primitives.Unsigned16;
    }, _socket: VScript.VSocket) => [Array<number>, number];
    readonly Traits: (_x: Traits) => string;
};
export type ClockAccuracy = "Reserved" | "AccurateToWithin25ns" | "AccurateToWithin100ns" | "AccurateToWithin250ns" | "AccurateToWithin1000ns" | "AccurateToWithin2500ns" | "AccurateToWithin10us" | "AccurateToWithin25us" | "AccurateToWithin100us" | "AccurateToWithin250us" | "AccurateToWithin1000us" | "AccurateToWithin2500us" | "AccurateToWithin10ms" | "AccurateToWithin25ms" | "AccurateToWithin100ms" | "AccurateToWithin250ms" | "AccurateToWithin1s" | "AccurateToWithin10s" | "AccuracyBelow10s" | "ProfileSpecific" | "Unknown";
export type ClockClass = "Reserved" | "SynchronizedToPrimary" | "WasSynchronizedToPrimaryNowInHoldOver" | "SynchronizedToAppSpecific" | "WasSynchronizedToAppSpecificNowInHoldOver" | "WasSynchronizedToPrimaryDegradAlternativeA" | "WasSynchronizedToAppSpecificDegradAlternativeA" | "ProfileSpecific" | "WasSynchronizedToPrimaryDegradAlternativeB" | "WasSynchronizedToAppSpecificDegradAlternativeB" | "Default" | "ReservedForV1Compatibility" | "SlaveOnly";
/**
  ClockIdentity as defined by the PTP standard, stored in big-endian order.
*/
export type ClockIdentity = Array<number>;
export interface ClockQuality {
    clock_class: VAPI.PTP.ClockClass;
    clock_accuracy: VAPI.PTP.ClockAccuracy;
    offset_scaled_log_variance: VAPI.Primitives.Unsigned16;
}
/**
  Most clock control units continuously adjust their target's operating
  frequency until the time and/or frequency offset between source and target
  matches a user-defined value. These units require no data beyond frame
  rate, source type, frequency offset and offset.
  
  However, other clock operations implicitly guarantee synchronicity by
  rigidly linking their target's operating frequency to the source frequency.
  This implicit link may be broken when the timing source changes
  discontinuously. For example, an uncalibrated PTP clock may perform
  arbitrarily large offset and/or frequency jumps, yet after reachieving
  calibration will again report its offset to the internal PTP reference
  frame as 0.0 ± 0.0. To signal such 'timing shocks' to consumers, every
  timing source performing discontinuous changes in a way that breaks
  implicit synchronicity has to increase its continuity_index (with
  wraparound behaviour in the unlikely case of overflow).
*/
export type ContinuityIndex = number;
export type Domain = number;
export interface PortIdentity {
    /**
      ClockIdentity as defined by the PTP standard, stored in big-endian order.
    */
    clock_identity: VAPI.PTP.ClockIdentity;
    port_number: VAPI.Primitives.Unsigned16;
}
export type SourceType = "AtomicClock" | "GPS" | "TerrestrialRadio" | "PTP" | "NTP" | "HandSet" | "Other" | "InternalOscillator" | "ProfileSpecific" | "Reserved";
export type TimeScale = "PTP" | "Arbitrary";
export type Traceability = "NotTraceable" | "FrequencyTraceable" | "Traceable";
export declare class Traits implements VScript.Referenceable<"PTP::Data::Traits"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "PTP::Data::Traits";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get domain(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.PTP.Domain, VAPI.PTP.Traits>;
    get alternate_master(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.PTP.Traits>;
    get leap61(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.PTP.Traits>;
    get leap59(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.PTP.Traits>;
    get ptp_timescale(): VScript.rKeyword<VScript.VSocket, null | VAPI.PTP.TimeScale, null | VAPI.PTP.TimeScale, VAPI.PTP.Traits>;
    get traceability(): VScript.rKeyword<VScript.VSocket, VAPI.PTP.Traceability, VAPI.PTP.Traceability, VAPI.PTP.Traits>;
    get utc_offset_seconds(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Signed8, VAPI.PTP.Traits>;
    get source_type(): VScript.rKeyword<VScript.VSocket, VAPI.PTP.SourceType, VAPI.PTP.SourceType, VAPI.PTP.Traits>;
    get port_identity(): VScript.rKeyword<VScript.VSocket, [
        Array<number>,
        number
    ], VAPI.PTP.PortIdentity, VAPI.PTP.Traits>;
    get grandmaster_priority_1(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned8, VAPI.PTP.Traits>;
    get grandmaster_clock_quality(): VScript.rKeyword<VScript.VSocket, [
        VAPI.PTP.ClockClass,
        VAPI.PTP.ClockAccuracy,
        number
    ], VAPI.PTP.ClockQuality, VAPI.PTP.Traits>;
    get grandmaster_priority_2(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned8, VAPI.PTP.Traits>;
    /**
      ClockIdentity as defined by the PTP standard, stored in big-endian order.
    */
    get grandmaster_identity(): VScript.rKeyword<VScript.VSocket, Array<number>, VAPI.PTP.ClockIdentity, VAPI.PTP.Traits>;
    get steps_removed(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned16, VAPI.PTP.Traits>;
}
export declare const Enums: {
    readonly Traceability: Traceability[];
    readonly TimeScale: TimeScale[];
    readonly SourceType: SourceType[];
    readonly ClockClass: ClockClass[];
    readonly ClockAccuracy: ClockAccuracy[];
};
