import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly AudioConfigurationContainer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.AudioConfigurationContainer;
    readonly AudioConfigurationFormat: (_raw: [number, VAPI.Audio.Format, VAPI.Definitions.PacketTime], _socket: VScript.VSocket) => AudioConfigurationFormat;
    readonly AudioGroupControl: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.AudioGroupControl;
    readonly AudioGroupControlStatus: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.AudioGroupControlStatus;
    readonly CompressionBandwidth: (_raw: [number], _socket: VScript.VSocket) => CompressionBandwidth;
    readonly Compression: (_raw: ([0, [number]] | [1, [number]]), _socket: VScript.VSocket) => Compression;
    readonly Constraints: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.Constraints;
    readonly HeaderSettings: (_raw: [null | number, null | VAPI.RTPTransmitter.ClassOfService, null | VAPI.RTPTransmitter.TrafficClassOrQos, null | number, number], _socket: VScript.VSocket) => HeaderSettings;
    readonly IpConfig: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.IpConfig;
    readonly IpConfigInterfaces: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.IpConfigInterfaces;
    readonly IpConfigMipMap: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.IpConfigMipMap;
    readonly IpSDPConfigInterfaces: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.IpSDPConfigInterfaces;
    readonly JpegXsSettings: (_raw: [([0, [number]] | [1, [number]]), VAPI.RTPTransmitter.LVLMODE, boolean, boolean], _socket: VScript.VSocket) => JpegXsSettings;
    readonly MipMapEncoder: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.MipMapEncoder;
    readonly MuxStatistics: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.MuxStatistics;
    readonly MediaClockControlPropagate: (_raw: [], _socket: VScript.VSocket) => MediaClockControlPropagate;
    readonly CompressionRatio: (_raw: [number], _socket: VScript.VSocket) => CompressionRatio;
    readonly RouterError: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.RouterError;
    readonly SSRCStatus: (_raw: [number, number], _socket: VScript.VSocket) => SSRCStatus;
    readonly ST20226Settings: (_raw: [], _socket: VScript.VSocket) => ST20226Settings;
    readonly ST2042Settings: (_raw: [VAPI.Video.DiracCompression, boolean], _socket: VScript.VSocket) => ST2042Settings;
    readonly SourceAddressVlan: (_raw: [null | number, null | string], _socket: VScript.VSocket) => SourceAddressVlan;
    readonly Tagging: (_raw: [number, [number, VAPI.RTPTransmitter.ClassOfService]], _socket: VScript.VSocket) => Tagging;
    readonly TaggingDecipher: (_raw: [number, VAPI.RTPTransmitter.ClassOfService], _socket: VScript.VSocket) => TaggingDecipher;
    readonly IpConfigMipMapActiveStreamParameter: (_raw: [null | string, null | string, number, number, null | number], _socket: VScript.VSocket) => IpConfigMipMapActiveStreamParameter;
    readonly RouterErrorErrorInput: (_raw: [Array<number>, Array<number>, Array<number>, number], _socket: VScript.VSocket) => RouterErrorErrorInput;
    readonly RouterErrorErrorOutput: (_raw: [Array<number>, Array<number>, Array<number>], _socket: VScript.VSocket) => RouterErrorErrorOutput;
    readonly IpConfigHeaderInfo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.IpConfigHeaderInfo;
    readonly SessionInterfaces: (_raw: [null | string, null | string], _socket: VScript.VSocket) => SessionInterfaces;
    readonly MediaStreamerIpConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.MediaStreamerIpConfiguration;
    readonly MediaStreamerVideoIpConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.MediaStreamerVideoIpConfiguration;
    readonly MipMapStreamerIpConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.MipMapStreamerIpConfiguration;
    readonly JpegXsHardware: (_raw: [number, number, VAPI.RTPTransmitter.ColorSampleMode, number, VAPI.RTPTransmitter.ValidateMode, number, VAPI.RTPTransmitter.VideoDepth, boolean, Array<number>, number], _socket: VScript.VSocket) => JpegXsHardware;
    readonly AllLicenseInformation: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.AllLicenseInformation;
    readonly MipMapStreamerIpConfigurationMedia: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.MipMapStreamerIpConfigurationMedia;
    readonly AllSettingsOnIncompleteConfiguration: (_raw: [boolean, boolean], _socket: VScript.VSocket) => AllSettingsOnIncompleteConfiguration;
    readonly MuxStatisticsPort0: (_raw: [number, number], _socket: VScript.VSocket) => MuxStatisticsPort0;
    readonly MuxStatisticsPort1: (_raw: [number, number], _socket: VScript.VSocket) => MuxStatisticsPort1;
    readonly MuxStatisticsScheduler: (_raw: [number], _socket: VScript.VSocket) => MuxStatisticsScheduler;
    readonly AllSettings: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.RTPTransmitter.AllSettings;
};
export declare const lower: {
    readonly AudioConfigurationContainer: (_x: AudioConfigurationContainer) => string;
    readonly AudioConfigurationFormat: (_x: {
        num_channels: VAPI.Audio.Channelcount;
        format: VAPI.Audio.Format;
        packet_time: VAPI.Definitions.PacketTime;
    }, _socket: VScript.VSocket) => [number, VAPI.Audio.Format, VAPI.Definitions.PacketTime];
    readonly AudioGroupControl: (_x: AudioGroupControl) => string;
    readonly AudioGroupControlStatus: (_x: AudioGroupControlStatus) => string;
    readonly CompressionBandwidth: (_x: {
        max_data_rate: VAPI.Primitives.Unsigned32;
    }, _socket: VScript.VSocket) => [number];
    readonly Compression: (_x: ({
        variant: "Bandwidth";
        value: VAPI.RTPTransmitter.CompressionBandwidth;
    } | {
        variant: "Ratio";
        value: VAPI.RTPTransmitter.CompressionRatio;
    }), _socket: VScript.VSocket) => ([0, [number]] | [1, [number]]);
    readonly Constraints: (_x: Constraints) => string;
    readonly HeaderSettings: (_x: {
        payload_type: null | VAPI.Definitions.RtpPayloadType;
        /**
          refers to 802.1p Class of Service (CoS). The CoS is part of
          the Ethernet header, and thus is only available when VLAN
          tagging is used.
        */
        class_of_service: null | VAPI.RTPTransmitter.ClassOfService;
        /**
          The Class Name (assured forwarding) offers an easy way to
          identify the DSCP value. DSCP uses the first six bits of the
          Type of Service(Tos) to identify the packet priority. The
          first three bits represent the Class Selector. The last three
          bits the Drop Precedence. If a packet is marked
          assured_forwarding_23, then its Class Selector is 2 (the 2 in
          23) and its Drop Precedence is High (the 3 in 23).
        */
        traffic_class: null | VAPI.RTPTransmitter.TrafficClassOrQos;
        /**
          This field is used to identify the synchronization source.
          The value is determined randomly so that no two sources
          within the RTP session have the same identification number
        */
        ssrc: null | VAPI.Primitives.Unsigned32;
        ttl: number;
    }, _socket: VScript.VSocket) => [null | number, null | VAPI.RTPTransmitter.ClassOfService, null | VAPI.RTPTransmitter.TrafficClassOrQos, null | number, number];
    readonly IpConfig: (_x: IpConfig) => string;
    readonly IpConfigInterfaces: (_x: IpConfigInterfaces) => string;
    readonly IpConfigMipMap: (_x: IpConfigMipMap) => string;
    readonly IpSDPConfigInterfaces: (_x: IpSDPConfigInterfaces) => string;
    readonly JpegXsSettings: (_x: {
        compression: VAPI.RTPTransmitter.Compression;
        /**
          PSNR optimization: by default, the rate allocation of
          the encoder is configured to optimize the image
          quality based on the Peak Signal to Noise Ratio
          (PSNR) calculation. This configuration, called 'PSNR
          Weights', is providing the best results of TICO
          compression for PSNR measurements. visual
          optimization: the 'Visual Weights' configuration is
          the optimal configuration for real-life subjective
          quality assessment. Compared to the “PSNR
          Weights” configuration, it provides a better
          viewing experience but it sometimes produces lower
          PSNR results.
        */
        lvl_weight_mode: VAPI.RTPTransmitter.LVLMODE;
        add_st2110_40: boolean;
        omit_mandatory_pre_header: boolean;
    }, _socket: VScript.VSocket) => [([0, [number]] | [1, [number]]), VAPI.RTPTransmitter.LVLMODE, boolean, boolean];
    readonly MipMapEncoder: (_x: MipMapEncoder) => string;
    readonly MuxStatistics: (_x: MuxStatistics) => string;
    readonly MediaClockControlPropagate: (_x: {}, _socket: VScript.VSocket) => [];
    readonly CompressionRatio: (_x: {
        ratio: number;
    }, _socket: VScript.VSocket) => [number];
    readonly RouterError: (_x: RouterError) => string;
    readonly SSRCStatus: (_x: {
        /**
          This field is used to identify the
          synchronization source. The value is determined
          randomly so that no two sources within the RTP
          session have the same identification number
        */
        ssrc: VAPI.Primitives.Unsigned32;
        ssrc_counter: VAPI.Primitives.Unsigned32;
    }, _socket: VScript.VSocket) => [number, number];
    readonly ST20226Settings: (_x: {}, _socket: VScript.VSocket) => [];
    readonly ST2042Settings: (_x: {
        compression: VAPI.Video.DiracCompression;
        add_st2110_40: boolean;
    }, _socket: VScript.VSocket) => [VAPI.Video.DiracCompression, boolean];
    readonly SourceAddressVlan: (_x: {
        vlan_id: null | VAPI.Primitives.VlanID;
        /**
          IP (unicast) address of the RTP stream sender
        */
        src_address: null | string;
    }, _socket: VScript.VSocket) => [null | number, null | string];
    readonly Tagging: (_x: {
        tagging_hw_value: VAPI.Primitives.Unsigned32;
        tagging_decipher: VAPI.RTPTransmitter.TaggingDecipher;
    }, _socket: VScript.VSocket) => [number, [number, VAPI.RTPTransmitter.ClassOfService]];
    readonly TaggingDecipher: (_x: {
        vlan_id: VAPI.Primitives.VlanID;
        class_of_service: VAPI.RTPTransmitter.ClassOfService;
    }, _socket: VScript.VSocket) => [number, VAPI.RTPTransmitter.ClassOfService];
    readonly IpConfigMipMapActiveStreamParameter: (_x: {
        /**
          IP (unicast) address of the RTP stream sender
        */
        src_address: null | string;
        /**
          IP (multicast) destination address of the RTP
          stream
        */
        dst_address: null | string;
        lane_id: number;
        stream_id: number;
        vlan_id: null | VAPI.Primitives.VlanID;
    }, _socket: VScript.VSocket) => [null | string, null | string, number, number, null | number];
    readonly RouterErrorErrorInput: (_x: {
        max_fifo_level: Array<VAPI.Primitives.Unsigned32>;
        max_fifo_level_last_read: Array<VAPI.Primitives.Unsigned32>;
        overflow: Array<VAPI.Primitives.Unsigned32>;
        error_irq_counter: VAPI.Primitives.Unsigned32;
    }, _socket: VScript.VSocket) => [Array<number>, Array<number>, Array<number>, number];
    readonly RouterErrorErrorOutput: (_x: {
        max_fifo_level: Array<VAPI.Primitives.Unsigned32>;
        max_fifo_level_last_read: Array<VAPI.Primitives.Unsigned32>;
        overflow: Array<VAPI.Primitives.Unsigned32>;
    }, _socket: VScript.VSocket) => [Array<number>, Array<number>, Array<number>];
    readonly IpConfigHeaderInfo: (_x: IpConfigHeaderInfo) => string;
    readonly SessionInterfaces: (_x: {
        primary: null | VAPI.NetworkInterfaces.VirtualInterface;
        secondary: null | VAPI.NetworkInterfaces.VirtualInterface;
    }, _socket: VScript.VSocket) => [null | string, null | string];
    readonly MediaStreamerIpConfiguration: (_x: MediaStreamerIpConfiguration) => string;
    readonly MediaStreamerVideoIpConfiguration: (_x: MediaStreamerVideoIpConfiguration) => string;
    readonly MipMapStreamerIpConfiguration: (_x: MipMapStreamerIpConfiguration) => string;
    readonly JpegXsHardware: (_x: {
        /**
          Width of the input encoded image, in
          pixels. Must be a multiple of 2. Up to
          4096 for UHD IP-core flavor
        */
        width: VAPI.Primitives.Unsigned32;
        /**
          Height of the input encoded image, in
          pixels. Must be a multiple of 2, and
          greater than or equal to 4
        */
        height: VAPI.Primitives.Unsigned32;
        /**
          Contains input mode configuration
          fields: bit 3-0: color and sub-sampling
          mode
        */
        mode: VAPI.RTPTransmitter.ColorSampleMode;
        /**
          Budget in bytes per compressed frame,
          which is allocated to the picture
          header and the compressed data. Note:
          To compute this value according to a
          bit per pixel rate: budget = bpp x
          width x height / 8 Complementary header
          (ie. boxes) is not included in the
          budget
        */
        budget_per_frame: VAPI.Primitives.Unsigned32;
        /**
          VALIDATE It validates the given
          configuration. Set to '1' to start the
          IP-core, after setting mode and images
          parameters. This signal must be
          activated to validate any change in
          configuration (width, height, ...). Set
          to '0' to stop the IP-core. bit 1: (R)
          CFG_READY ‘1’ indicates that the
          TICO-XS is ready to receive a new
          configuration, when this bit is ‘0’
          configuration registers shouldn't be
          modified
        */
        vld: VAPI.RTPTransmitter.ValidateMode;
        /**
          Number of images to play when the
          IP-core is in command mode. (when
          PLAY_MODE register = 0)
        */
        number_of_images: VAPI.Primitives.Unsigned32;
        /**
          Bit depth of the video content, mapped
          on the MSBs of the port interface. The
          valid bit depths are 8, 10 and 12 bits
          per component
        */
        video_depth: VAPI.RTPTransmitter.VideoDepth;
        /**
          It allows to choose between two running
          modes: set to '1' to run in play mode,
          in which the IP-core processes frames
          continuously. or set to '0' to run in
          command mode, in which the IP-core
          processes n frames, n defined by NBR
        */
        play_mode: boolean;
        /**
          This register is used to program the
          image quality optimization parameters
          (visual or PSNR). Each pre-computed
          weights value must be written to this
          register sequentially to ensure proper
          encoder behavior.
        */
        level_weights: Array<VAPI.Primitives.Unsigned32>;
        profile: VAPI.Primitives.Unsigned32;
    }, _socket: VScript.VSocket) => [number, number, VAPI.RTPTransmitter.ColorSampleMode, number, VAPI.RTPTransmitter.ValidateMode, number, VAPI.RTPTransmitter.VideoDepth, boolean, Array<number>, number];
    readonly AllLicenseInformation: (_x: AllLicenseInformation) => string;
    readonly MipMapStreamerIpConfigurationMedia: (_x: MipMapStreamerIpConfigurationMedia) => string;
    readonly AllSettingsOnIncompleteConfiguration: (_x: {
        /**
          allow the session to be activated
          even though not all ip
          configuration has been completed.
        */
        refuse_activation: boolean;
        /**
          true: reserve the hardware for the
          incomplete configured path
        */
        reserve_resources: boolean;
    }, _socket: VScript.VSocket) => [boolean, boolean];
    readonly MuxStatisticsPort0: (_x: {
        words: VAPI.Primitives.Unsigned32;
        packets: VAPI.Primitives.Unsigned32;
    }, _socket: VScript.VSocket) => [number, number];
    readonly MuxStatisticsPort1: (_x: {
        words: VAPI.Primitives.Unsigned32;
        packets: VAPI.Primitives.Unsigned32;
    }, _socket: VScript.VSocket) => [number, number];
    readonly MuxStatisticsScheduler: (_x: {
        packets: VAPI.Primitives.Unsigned32;
    }, _socket: VScript.VSocket) => [number];
    readonly AllSettings: (_x: AllSettings) => string;
};
export type ActivationControl = "Off" | "Off_preserve_resource" | "On";
export declare class AudioConfigurationContainer implements VScript.Referenceable<"RTPTransmitter::Data::AudioConfigurationContainer"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::AudioConfigurationContainer";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get transport_format(): VScript.dKeyword<VScript.VSocket, [
        number,
        VAPI.Audio.Format,
        VAPI.Definitions.PacketTime
    ], [
        number,
        VAPI.Audio.Format,
        VAPI.Definitions.PacketTime
    ], VAPI.RTPTransmitter.AudioConfigurationFormat, VAPI.RTPTransmitter.AudioConfigurationFormat, VAPI.RTPTransmitter.AudioConfigurationContainer>;
}
export interface AudioConfigurationFormat {
    num_channels: VAPI.Audio.Channelcount;
    format: VAPI.Audio.Format;
    packet_time: VAPI.Definitions.PacketTime;
}
export declare class AudioGroupControl implements VScript.Referenceable<"RTPTransmitter::Data::AudioGroupControl"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::AudioGroupControl";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get remapping(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<number>, VAPI.RTPTransmitter.AudioGroupControl>;
    get enabled_output_0(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.RTPTransmitter.AudioGroupControl>;
    get enabled_output_1(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.RTPTransmitter.AudioGroupControl>;
    get used_groups(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.RTPTransmitter.AudioGroupControl>;
}
export declare class AudioGroupControlStatus implements VScript.Referenceable<"RTPTransmitter::Data::AudioGroupControlStatus"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::AudioGroupControlStatus";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get primary(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Primitives.Signed32>, VAPI.RTPTransmitter.AudioGroupControlStatus>;
    get secondary(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Primitives.Signed32>, VAPI.RTPTransmitter.AudioGroupControlStatus>;
}
export interface CompressionBandwidth {
    max_data_rate: VAPI.Primitives.Unsigned32;
}
export type ClassOfService = "best_effort" | "medium_priority" | "high_priority" | "voice_call_signaling" | "video" | "voice";
export type ColorSampleMode = "GB_444" | "YCbCr_422" | "YCbCr_420" | "YCbCr_444";
export type Compression = ({
    variant: "Bandwidth";
    value: VAPI.RTPTransmitter.CompressionBandwidth;
} | {
    variant: "Ratio";
    value: VAPI.RTPTransmitter.CompressionRatio;
});
export declare class Constraints implements VScript.Referenceable<"RTPTransmitter::Data::Constraints"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::Constraints";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get calculation_standard(): VScript.rKeyword<VScript.VSocket, VAPI.Video.Standard, VAPI.Video.Standard, VAPI.RTPTransmitter.Constraints>;
    get latched_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.RTPTransmitter.Constraints>;
    get current_send_standard(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.RTPTransmitter.Constraints>;
    get latched_pixel_format(): VScript.rKeyword<VScript.VSocket, null | [
        null | VAPI.Video.ColorSpace,
        VAPI.Video.BitDepth,
        null | VAPI.Video.TransferCharacteristics,
        VAPI.Video.LuminanceAndColorDifferenceSignal
    ], null | VAPI.Video.PixelFormat, VAPI.RTPTransmitter.Constraints>;
    get standard(): VScript.dKeyword<VScript.VSocket, null | VAPI.Video.Standard, null | VAPI.Video.Standard, null | VAPI.Video.Standard, null | VAPI.Video.Standard, VAPI.RTPTransmitter.Constraints>;
    get sub_stream(): VScript.rKeyword<VScript.VSocket, null | VAPI.Video.SubStream, null | VAPI.Video.SubStream, VAPI.RTPTransmitter.Constraints>;
    get max_bandwidth(): VScript.dKeyword<VScript.VSocket, VAPI.Definitions.Bandwidth, VAPI.Definitions.Bandwidth, VAPI.Definitions.Bandwidth, VAPI.Definitions.Bandwidth, VAPI.RTPTransmitter.Constraints>;
}
export interface HeaderSettings {
    payload_type: null | VAPI.Definitions.RtpPayloadType;
    /**
      refers to 802.1p Class of Service (CoS). The CoS is part of the Ethernet
      header, and thus is only available when VLAN tagging is used.
    */
    class_of_service: null | VAPI.RTPTransmitter.ClassOfService;
    /**
      The Class Name (assured forwarding) offers an easy way to identify the
      DSCP value. DSCP uses the first six bits of the Type of Service(Tos) to
      identify the packet priority. The first three bits represent the Class
      Selector. The last three bits the Drop Precedence. If a packet is marked
      assured_forwarding_23, then its Class Selector is 2 (the 2 in 23) and its
      Drop Precedence is High (the 3 in 23).
    */
    traffic_class: null | VAPI.RTPTransmitter.TrafficClassOrQos;
    /**
      This field is used to identify the synchronization source. The value is
      determined randomly so that no two sources within the RTP session have
      the same identification number
    */
    ssrc: null | VAPI.Primitives.Unsigned32;
    ttl: number;
}
export declare class IpConfig implements VScript.Referenceable<"RTPTransmitter::Data::IpConfig"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::IpConfig";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get sdp_a(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.RTPTransmitter.IpConfig>;
    get preserve_src_ip_entry(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.RTPTransmitter.IpConfig>;
    get src_address_vlan(): VScript.dKeyword<VScript.VSocket, [
        null | number,
        null | string
    ], [
        null | number,
        null | string
    ], VAPI.RTPTransmitter.SourceAddressVlan, VAPI.RTPTransmitter.SourceAddressVlan, VAPI.RTPTransmitter.IpConfig>;
    /**
      IP (multicast) destination address of the RTP stream
    */
    get dst_address(): VScript.dKeyword<VScript.VSocket, null | string, null | string, null | string, null | string, VAPI.RTPTransmitter.IpConfig>;
    get header_settings(): VScript.dKeyword<VScript.VSocket, [
        null | number,
        null | VAPI.RTPTransmitter.ClassOfService,
        null | VAPI.RTPTransmitter.TrafficClassOrQos,
        null | number,
        number
    ], [
        null | number,
        null | VAPI.RTPTransmitter.ClassOfService,
        null | VAPI.RTPTransmitter.TrafficClassOrQos,
        null | number,
        number
    ], VAPI.RTPTransmitter.HeaderSettings, VAPI.RTPTransmitter.HeaderSettings, VAPI.RTPTransmitter.IpConfig>;
    get header_info(): VAPI.RTPTransmitter.IpConfigHeaderInfo;
}
export declare class IpConfigInterfaces implements VScript.Referenceable<"RTPTransmitter::Data::IpConfigInterfaces"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::IpConfigInterfaces";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      reference to ip configuration
    */
    get primary(): VAPI.RTPTransmitter.IpConfig;
    /**
      reference to ip configuration
    */
    get secondary(): VAPI.RTPTransmitter.IpConfig;
}
export declare class IpConfigMipMap implements VScript.Referenceable<"RTPTransmitter::Data::IpConfigMipMap"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::IpConfigMipMap";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get active_stream_parameter(): VScript.rKeyword<VScript.VSocket, null | [
        null | string,
        null | string,
        number,
        number,
        null | number
    ], null | VAPI.RTPTransmitter.IpConfigMipMapActiveStreamParameter, VAPI.RTPTransmitter.IpConfigMipMap>;
}
export declare class IpSDPConfigInterfaces implements VScript.Referenceable<"RTPTransmitter::Data::IpSDPConfigInterfaces"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::IpSDPConfigInterfaces";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get sdp_a(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.RTPTransmitter.IpSDPConfigInterfaces>;
    /**
      reference to ip configuration
    */
    get primary(): VAPI.RTPTransmitter.IpConfig;
    /**
      reference to ip configuration
    */
    get secondary(): VAPI.RTPTransmitter.IpConfig;
}
export interface JpegXsSettings {
    compression: VAPI.RTPTransmitter.Compression;
    /**
      PSNR optimization: by default, the rate allocation of the encoder is
      configured to optimize the image quality based on the Peak Signal to
      Noise Ratio (PSNR) calculation. This configuration, called 'PSNR
      Weights', is providing the best results of TICO compression for PSNR
      measurements. visual optimization: the 'Visual Weights' configuration is
      the optimal configuration for real-life subjective quality assessment.
      Compared to the “PSNR Weights” configuration, it provides a better
      viewing experience but it sometimes produces lower PSNR results.
    */
    lvl_weight_mode: VAPI.RTPTransmitter.LVLMODE;
    add_st2110_40: boolean;
    omit_mandatory_pre_header: boolean;
}
export type LVLMODE = "peak_signal_noise_ratio" | "visual_optimization";
export declare class MipMapEncoder implements VScript.Referenceable<"RTPTransmitter::Data::MipMapEncoder"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::MipMapEncoder";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get allocated_blocks(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.RTPTransmitter.MipMapEncoder>;
    get block_addr(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Primitives.Unsigned32>, VAPI.RTPTransmitter.MipMapEncoder>;
}
export declare class MuxStatistics implements VScript.Referenceable<"RTPTransmitter::Data::MuxStatistics"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::MuxStatistics";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get port0(): VScript.rKeyword<VScript.VSocket, [
        number,
        number
    ], VAPI.RTPTransmitter.MuxStatisticsPort0, VAPI.RTPTransmitter.MuxStatistics>;
    get port1(): VScript.rKeyword<VScript.VSocket, [
        number,
        number
    ], VAPI.RTPTransmitter.MuxStatisticsPort1, VAPI.RTPTransmitter.MuxStatistics>;
    get scheduler(): VScript.rKeyword<VScript.VSocket, [
        number
    ], VAPI.RTPTransmitter.MuxStatisticsScheduler, VAPI.RTPTransmitter.MuxStatistics>;
}
export type OnConfiguration = "RefuseActivation" | "AllowActivation";
export type PackingMode = "GPM" | "BPM";
export interface MediaClockControlPropagate {
}
export interface CompressionRatio {
    ratio: number;
}
export type ReduceMaxThroughput = "doNotReduce" | "ReduceBy_1Percent" | "ReduceBy_2Percent" | "ReduceBy_3Percent" | "ReduceBy_4Percent" | "ReduceBy_5Percent" | "ReduceBy_6Percent" | "ReduceBy_7Percent" | "ReduceBy_8Percent" | "ReduceBy_9Percent" | "ReduceBy_10Percent";
export declare class RouterError implements VScript.Referenceable<"RTPTransmitter::Data::RouterError"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::RouterError";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get error_input(): VScript.rKeyword<VScript.VSocket, [
        Array<number>,
        Array<number>,
        Array<number>,
        number
    ], VAPI.RTPTransmitter.RouterErrorErrorInput, VAPI.RTPTransmitter.RouterError>;
    get error_output(): VScript.rKeyword<VScript.VSocket, [
        Array<number>,
        Array<number>,
        Array<number>
    ], VAPI.RTPTransmitter.RouterErrorErrorOutput, VAPI.RTPTransmitter.RouterError>;
}
export type SPSMode = "possible" | "in_use" | "is_optimized";
export interface SSRCStatus {
    /**
      This field is used to identify the synchronization source. The value is
      determined randomly so that no two sources within the RTP session have
      the same identification number
    */
    ssrc: VAPI.Primitives.Unsigned32;
    ssrc_counter: VAPI.Primitives.Unsigned32;
}
export interface ST20226Settings {
}
export interface ST2042Settings {
    compression: VAPI.Video.DiracCompression;
    add_st2110_40: boolean;
}
export interface SourceAddressVlan {
    vlan_id: null | VAPI.Primitives.VlanID;
    /**
      IP (unicast) address of the RTP stream sender
    */
    src_address: null | string;
}
export type StripMining = "ReduceToMinimum" | "HoldInBackhand";
export interface Tagging {
    tagging_hw_value: VAPI.Primitives.Unsigned32;
    tagging_decipher: VAPI.RTPTransmitter.TaggingDecipher;
}
export interface TaggingDecipher {
    vlan_id: VAPI.Primitives.VlanID;
    class_of_service: VAPI.RTPTransmitter.ClassOfService;
}
export type TrafficClassOrQos = "assured_forwarding_default" | "assured_forwarding_11" | "assured_forwarding_12" | "assured_forwarding_13" | "assured_forwarding_21" | "assured_forwarding_22" | "assured_forwarding_23" | "assured_forwarding_31" | "assured_forwarding_32" | "assured_forwarding_33" | "assured_forwarding_41" | "assured_forwarding_42" | "assured_forwarding_43" | "assured_forwarding_ef";
export type ValidateMode = "validate_start" | "validate_stop";
export type VideoDepth = "depths_8" | "depths_10" | "depths_12";
export interface IpConfigMipMapActiveStreamParameter {
    /**
      IP (unicast) address of the RTP stream sender
    */
    src_address: null | string;
    /**
      IP (multicast) destination address of the RTP stream
    */
    dst_address: null | string;
    lane_id: number;
    stream_id: number;
    vlan_id: null | VAPI.Primitives.VlanID;
}
export interface RouterErrorErrorInput {
    max_fifo_level: Array<VAPI.Primitives.Unsigned32>;
    max_fifo_level_last_read: Array<VAPI.Primitives.Unsigned32>;
    overflow: Array<VAPI.Primitives.Unsigned32>;
    error_irq_counter: VAPI.Primitives.Unsigned32;
}
export interface RouterErrorErrorOutput {
    max_fifo_level: Array<VAPI.Primitives.Unsigned32>;
    max_fifo_level_last_read: Array<VAPI.Primitives.Unsigned32>;
    overflow: Array<VAPI.Primitives.Unsigned32>;
}
export declare class IpConfigHeaderInfo implements VScript.Referenceable<"RTPTransmitter::Data::IpConfig::HeaderInfo"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::IpConfig::HeaderInfo";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get tagging(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        [
            number,
            VAPI.RTPTransmitter.ClassOfService
        ]
    ], null | VAPI.RTPTransmitter.Tagging, VAPI.RTPTransmitter.IpConfigHeaderInfo>;
    get ssrc_info(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        number
    ], null | VAPI.RTPTransmitter.SSRCStatus, VAPI.RTPTransmitter.IpConfigHeaderInfo>;
}
export interface SessionInterfaces {
    primary: null | VAPI.NetworkInterfaces.VirtualInterface;
    secondary: null | VAPI.NetworkInterfaces.VirtualInterface;
}
export declare class MediaStreamerIpConfiguration implements VScript.Referenceable<"RTPTransmitter::Data::MediaStreamer::IpConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::MediaStreamer::IpConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get sdp_a(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.RTPTransmitter.MediaStreamerIpConfiguration>;
    get media(): VAPI.RTPTransmitter.IpConfigInterfaces;
}
export declare class MediaStreamerVideoIpConfiguration implements VScript.Referenceable<"RTPTransmitter::Data::MediaStreamerVideo::IpConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::MediaStreamerVideo::IpConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get sdp_a(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.RTPTransmitter.MediaStreamerVideoIpConfiguration>;
    get video(): VAPI.RTPTransmitter.IpSDPConfigInterfaces;
    get meta(): VAPI.RTPTransmitter.IpSDPConfigInterfaces;
}
export declare class MipMapStreamerIpConfiguration implements VScript.Referenceable<"RTPTransmitter::Data::MipMapStreamer::IpConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::MipMapStreamer::IpConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get media(): VAPI.RTPTransmitter.MipMapStreamerIpConfigurationMedia;
}
export type MediaStreamerIssues = {
    missmatching_dst_and_src_ip_class: boolean;
};
export type MediaStreamerVideoIssues = {
    missing_input_dt_node: boolean;
    missmatching_dst_and_src_ip_class: boolean;
};
export interface JpegXsHardware {
    /**
      Width of the input encoded image, in pixels. Must be a multiple of 2. Up
      to 4096 for UHD IP-core flavor
    */
    width: VAPI.Primitives.Unsigned32;
    /**
      Height of the input encoded image, in pixels. Must be a multiple of 2,
      and greater than or equal to 4
    */
    height: VAPI.Primitives.Unsigned32;
    /**
      Contains input mode configuration fields: bit 3-0: color and sub-sampling
      mode
    */
    mode: VAPI.RTPTransmitter.ColorSampleMode;
    /**
      Budget in bytes per compressed frame, which is allocated to the picture
      header and the compressed data. Note: To compute this value according to
      a bit per pixel rate: budget = bpp x width x height / 8 Complementary
      header (ie. boxes) is not included in the budget
    */
    budget_per_frame: VAPI.Primitives.Unsigned32;
    /**
      VALIDATE It validates the given configuration. Set to '1' to start the
      IP-core, after setting mode and images parameters. This signal must be
      activated to validate any change in configuration (width, height, ...).
      Set to '0' to stop the IP-core. bit 1: (R) CFG_READY ‘1’ indicates
      that the TICO-XS is ready to receive a new configuration, when this bit
      is ‘0’ configuration registers shouldn't be modified
    */
    vld: VAPI.RTPTransmitter.ValidateMode;
    /**
      Number of images to play when the IP-core is in command mode. (when
      PLAY_MODE register = 0)
    */
    number_of_images: VAPI.Primitives.Unsigned32;
    /**
      Bit depth of the video content, mapped on the MSBs of the port interface.
      The valid bit depths are 8, 10 and 12 bits per component
    */
    video_depth: VAPI.RTPTransmitter.VideoDepth;
    /**
      It allows to choose between two running modes: set to '1' to run in play
      mode, in which the IP-core processes frames continuously. or set to '0'
      to run in command mode, in which the IP-core processes n frames, n
      defined by NBR
    */
    play_mode: boolean;
    /**
      This register is used to program the image quality optimization
      parameters (visual or PSNR). Each pre-computed weights value must be
      written to this register sequentially to ensure proper encoder behavior.
    */
    level_weights: Array<VAPI.Primitives.Unsigned32>;
    profile: VAPI.Primitives.Unsigned32;
}
export declare class AllLicenseInformation implements VScript.Referenceable<"RTPTransmitter::Data::All::LicenseInformation"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::All::LicenseInformation";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get num_jpeg_xs_transmitters(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned16, VAPI.RTPTransmitter.AllLicenseInformation>;
}
export declare class MipMapStreamerIpConfigurationMedia implements VScript.Referenceable<"RTPTransmitter::Data::MipMapStreamer::IpConfiguration::Media"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::MipMapStreamer::IpConfiguration::Media";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get primary(): VAPI.RTPTransmitter.IpConfigMipMap;
    get secondary(): VAPI.RTPTransmitter.IpConfigMipMap;
}
export interface AllSettingsOnIncompleteConfiguration {
    /**
      allow the session to be activated even though not all ip configuration
      has been completed.
    */
    refuse_activation: boolean;
    /**
      true: reserve the hardware for the incomplete configured path
    */
    reserve_resources: boolean;
}
export interface MuxStatisticsPort0 {
    words: VAPI.Primitives.Unsigned32;
    packets: VAPI.Primitives.Unsigned32;
}
export interface MuxStatisticsPort1 {
    words: VAPI.Primitives.Unsigned32;
    packets: VAPI.Primitives.Unsigned32;
}
export interface MuxStatisticsScheduler {
    packets: VAPI.Primitives.Unsigned32;
}
export declare class AllSettings implements VScript.Referenceable<"RTPTransmitter::Data::All::Settings"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "RTPTransmitter::Data::All::Settings";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get on_incomplete_configuration(): VScript.rwKeyword<VScript.VSocket, [
        boolean,
        boolean
    ], [
        boolean,
        boolean
    ], VAPI.RTPTransmitter.AllSettingsOnIncompleteConfiguration, VAPI.RTPTransmitter.AllSettingsOnIncompleteConfiguration, VAPI.RTPTransmitter.AllSettings>;
    /**
      reserves a desired bandwidth from the maximum possible throughput of the
      port to be used for inband control
    */
    get reserved_bandwidth(): VScript.rwKeyword<VScript.VSocket, number, number, number, number, VAPI.RTPTransmitter.AllSettings>;
    get check_ip_address_timeout(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.RTPTransmitter.AllSettings>;
}
export declare const Enums: {
    readonly VideoDepth: VideoDepth[];
    readonly ValidateMode: ValidateMode[];
    readonly TrafficClassOrQos: TrafficClassOrQos[];
    readonly StripMining: StripMining[];
    readonly SPSMode: SPSMode[];
    readonly ReduceMaxThroughput: ReduceMaxThroughput[];
    readonly PackingMode: PackingMode[];
    readonly OnConfiguration: OnConfiguration[];
    readonly LVLMODE: LVLMODE[];
    readonly ColorSampleMode: ColorSampleMode[];
    readonly ClassOfService: ClassOfService[];
    readonly ActivationControl: ActivationControl[];
};
