import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly CompileInfo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.CompileInfo;
    readonly Device: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.Device;
    readonly DeviceInfo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.DeviceInfo;
    readonly ECC: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.ECC;
    readonly FanSpeed: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.FanSpeed;
    readonly IS04: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.IS04;
    readonly NeighborhoodWatch: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.NeighborhoodWatch;
    readonly PCBInfo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.PCBInfo;
    readonly PSU: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.PSU;
    readonly QSFP: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.QSFP;
    readonly Revision: (_raw: [number, number], _socket: VScript.VSocket) => Revision;
    readonly SPD: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.SPD;
    readonly SWVersion: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.SWVersion;
    readonly SlotInformation: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.SlotInformation;
    readonly AllCommandLogging: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.AllCommandLogging;
    readonly AllEcc: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.AllEcc;
    readonly QSFPEqSupport: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.QSFPEqSupport;
    readonly AllIoBoardInfo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.AllIoBoardInfo;
    readonly AllIoBoard: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.AllIoBoard;
    readonly SlotInformationIpAddresses: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.SlotInformationIpAddresses;
    readonly AllNmos: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.AllNmos;
    readonly QSFPRxPower: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.QSFPRxPower;
    readonly AllServices: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.AllServices;
    readonly AllUsrinfo: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.System.AllUsrinfo;
};
export declare const lower: {
    readonly CompileInfo: (_x: CompileInfo) => string;
    readonly Device: (_x: Device) => string;
    readonly DeviceInfo: (_x: DeviceInfo) => string;
    readonly ECC: (_x: ECC) => string;
    readonly FanSpeed: (_x: FanSpeed) => string;
    readonly IS04: (_x: IS04) => string;
    readonly NeighborhoodWatch: (_x: NeighborhoodWatch) => string;
    readonly PCBInfo: (_x: PCBInfo) => string;
    readonly PSU: (_x: PSU) => string;
    readonly QSFP: (_x: QSFP) => string;
    readonly Revision: (_x: {
        major: number;
        minor: number;
    }, _socket: VScript.VSocket) => [number, number];
    readonly SPD: (_x: SPD) => string;
    readonly SWVersion: (_x: SWVersion) => string;
    readonly SlotInformation: (_x: SlotInformation) => string;
    readonly AllCommandLogging: (_x: AllCommandLogging) => string;
    readonly AllEcc: (_x: AllEcc) => string;
    readonly QSFPEqSupport: (_x: QSFPEqSupport) => string;
    readonly AllIoBoardInfo: (_x: AllIoBoardInfo) => string;
    readonly AllIoBoard: (_x: AllIoBoard) => string;
    readonly SlotInformationIpAddresses: (_x: SlotInformationIpAddresses) => string;
    readonly AllNmos: (_x: AllNmos) => string;
    readonly QSFPRxPower: (_x: QSFPRxPower) => string;
    readonly AllServices: (_x: AllServices) => string;
    readonly AllUsrinfo: (_x: AllUsrinfo) => string;
};
export type BOARDPOS = "BOTTOM_LEFT" | "BOTTOM_RIGHT" | "MID_LEFT" | "MID_CENTER" | "MID_RIGHT" | "TOP_LEFT" | "TOP_CENTER" | "TOP_RIGHT" | "UNKNOWN";
export declare class CompileInfo implements VScript.Referenceable<"System::Data::CompileInfo"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::CompileInfo";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get hg(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.CompileInfo>;
    get user(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.CompileInfo>;
    get time(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.CompileInfo>;
    get proj(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.CompileInfo>;
}
export declare class Device implements VScript.Referenceable<"System::Data::Device"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::Device";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get info(): VAPI.System.DeviceInfo;
    get pcb(): VScript.StronglyTypedTable<VScript.VSocket, "System::Data::PCBInfo", VAPI.System.PCBInfo>;
}
export declare class DeviceInfo implements VScript.Referenceable<"System::Data::DeviceInfo"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::DeviceInfo";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get type(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.DeviceInfo>;
    get revision(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        number
    ], null | VAPI.System.Revision, VAPI.System.DeviceInfo>;
    get serial(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.DeviceInfo>;
}
export declare class ECC implements VScript.Referenceable<"System::Data::ECC"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::ECC";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Corrected errors
    */
    get ce_count(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.System.ECC>;
    /**
      Uncorrected errors
    */
    get ue_count(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.System.ECC>;
}
export declare class FanSpeed implements VScript.Referenceable<"System::Data::FanSpeed"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::FanSpeed";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get id(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.FanSpeed>;
    get speed(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.FanSpeed>;
    get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.System.FanSpeedIssues, VAPI.System.FanSpeed>;
}
/**
  The following IO modules can currently be used with the
  C100/AT300:
  
  `IO_BNC_10_10`: 10× BNC in, 10× BNC out (up to 3G); 12G supported on
  bottom row.
  
  `IO_BNC_18_2`: 9× BNC in (up to 12G), 9× BNC in (up to 3G), 1× BNC out
  (up to 12G), 1× BNC out (up to 3G), analog video ref in +
  loop-through.
  
  `IO_BNC_11_11`: 11× BNC in (up to 12G), 11× BNC out (up to
  12G).
  
  `IO_BNC_11_11_GD32`: with GD32 microcontroller instead
  STM32.
  
  `IO_BNC_16_16`: 11× BNC in (up to 12G), 11× BNC out (up to 12G), 5× BNC
  in (up to 3G), 5× BNC out (up to 3G).
  
  `IO_BNC_16_16_GD32`: with GD32 microcontroller instead STM32.
  
  `IO_BNC_2_18`: 1× BNC in (up to 12G), 1× BNC in (up to 3G), 9× BNC out
  (up to 12G), 9× BNC out (up to 3G), analog video ref in +
  loop-through.
  
  `IO_BNC_2_2_16bidi`: 2× BNC in (up to 3G), 2× BNC out (up to 3G), 16×
  bidirectional BNC (up to 3G), analog video ref in +
  loop-through.
  
  `IO_BNC_16bidi`: 16× bidirectional BNC (up to 12G), analog ref in +
  loop-through.
  
  `IO_BNC_16bidi_GD32`: with GD32 microcontroller instead STM32.
  
  `IO_MSC_v2`: 10× bidirectional BNC (up to 12G), 2×3 analog video ref out,
  GPS antenna input, wordclock out, analog video ref in +
  loop-through.
  
  `IO_MSC_v2_GD32`: with GD32 microcontroller instead STM32.
*/
export type IOBoard = "IO_BNC_10_10" | "IO_BNC_18_2" | "IO_BNC_11_11" | "IO_BNC_11_11_GD32" | "IO_BNC_16_16" | "IO_BNC_16_16_GD32" | "IO_BNC_2_18" | "IO_BNC_2_2_16bidi" | "IO_BNC_16bidi" | "IO_BNC_16bidi_GD32" | "IO_MSC_v1" | "IO_MSC_v2" | "IO_MSC_v2_GD32";
export declare class IS04 implements VScript.Referenceable<"System::Data::IS04"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::IS04";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get registry_connected(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.System.IS04>;
    get protocol(): VScript.rwKeyword<VScript.VSocket, VAPI.System.Protocol, VAPI.System.Protocol, VAPI.System.Protocol, VAPI.System.Protocol, VAPI.System.IS04>;
    /**
      IP and Port of desired NMOS Registry
    */
    get registry_address(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | string, null | string, VAPI.System.IS04>;
}
export type LEDBRIGHTNESS = "FULL" | "MINIMUM";
export declare class NeighborhoodWatch implements VScript.Referenceable<"System::Data::NeighborhoodWatch"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::NeighborhoodWatch";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.System.NeighborhoodWatchIssues, VAPI.System.NeighborhoodWatch>;
    get connected(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.System.NeighborhoodWatch>;
    get neighbor_info(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.NeighborhoodWatch>;
    /**
      if this is set to true, successfully parsed neighbor info lines will be
      filtered from the output
    */
    get filter_neighbor_info(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.System.NeighborhoodWatch>;
    get output(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.NeighborhoodWatch>;
}
/**
  IEEE company ID
*/
export type OUI = Array<VAPI.Primitives.Unsigned8>;
export declare class PCBInfo implements VScript.Referenceable<"System::Data::PCBInfo"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::PCBInfo";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get type(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.PCBInfo>;
    get revision(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        number
    ], null | VAPI.System.Revision, VAPI.System.PCBInfo>;
    get serial(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.PCBInfo>;
    get vendor(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.PCBInfo>;
    get date(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.PCBInfo>;
}
export type PCIESPEED = "UNKNOWN" | "GT_2_5" | "GT_5_0" | "GT_8_0";
export declare class PSU implements VScript.Referenceable<"System::Data::PSU"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::PSU";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get vin(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.PSU>;
    get vin_min(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.PSU>;
    get iin(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.PSU>;
    get vout(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.PSU>;
    get iout(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.PSU>;
    get temp1(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.PSU>;
    get temp2(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.PSU>;
    get temp_hotspot(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.PSU>;
    get on(): VScript.rKeyword<VScript.VSocket, null | boolean, null | boolean, VAPI.System.PSU>;
    get fanspeed(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.PSU>;
    get current_fanspeed_profile(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.PSU>;
    get issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.System.PSUIssues, VAPI.System.PSU>;
    get fan_issues(): VScript.rKeyword<VScript.VSocket, number, VAPI.System.PSUFanIssues, VAPI.System.PSU>;
}
export declare class QSFP implements VScript.Referenceable<"System::Data::QSFP"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::QSFP";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get vendor_name(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.QSFP>;
    /**
      IEEE company ID
    */
    get vendor_oui(): VScript.rKeyword<VScript.VSocket, Array<number>, VAPI.System.OUI, VAPI.System.QSFP>;
    get vendor_pn(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.QSFP>;
    get vendor_rev(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.QSFP>;
    get vendor_sn(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.QSFP>;
    get date_code(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.QSFP>;
    get eq_support(): VAPI.System.QSFPEqSupport;
    get temperature(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.QSFP>;
    get temp_error(): VScript.rKeyword<VScript.VSocket, null | VAPI.System.QSFPError, null | VAPI.System.QSFPError, VAPI.System.QSFP>;
    get rx_power(): VScript.StronglyTypedArray<VScript.VSocket, "System::Data::QSFP::RxPower", VAPI.System.QSFPRxPower>;
}
export type QSFPError = "OK" | "LOW_WARNING" | "HIGH_WARNING" | "LOW_ALARM" | "HIGH_ALARM";
/**
  if RAM calibration failed and rebooting does not fix the issue, please
  contact customer support
*/
export type RAMCALIBRATION = "Successful" | "Unknown" | "Failed";
export interface Revision {
    major: number;
    minor: number;
}
export declare class SPD implements VScript.Referenceable<"System::Data::SPD"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::SPD";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      ID code of the module manufacturer.
      
      0x2C80 = Micron
      
      0x5207 = Memphis
    */
    get module_manufacturer(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned16, VAPI.System.SPD>;
    /**
      ID code of the DRAM chips manufacturer.
      
      0xAD80 = SK Hynix
      
      0xCE80 = Samsung
      
      0x2C80 = Micron
    */
    get dram_manufacturer(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned16, VAPI.System.SPD>;
    get year(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.SPD>;
    get week(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.SPD>;
    get sn(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Primitives.Unsigned8>, VAPI.System.SPD>;
    get pn(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.SPD>;
    get revision(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned16, VAPI.System.SPD>;
    get data_capacity(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned64, VAPI.System.SPD>;
}
export declare class SWVersion implements VScript.Referenceable<"System::Data::SWVersion"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::SWVersion";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get version(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.SWVersion>;
    get timestamp(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.SWVersion>;
}
export declare class SlotInformation implements VScript.Referenceable<"System::Data::SlotInformation"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::SlotInformation";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get location(): VScript.rKeyword<VScript.VSocket, VAPI.System.BOARDPOS, VAPI.System.BOARDPOS, VAPI.System.SlotInformation>;
    get version(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.SlotInformation>;
    get temperature(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.System.SlotInformation>;
    get model(): VScript.rKeyword<VScript.VSocket, null | VAPI.Primitives.Model, null | VAPI.Primitives.Model, VAPI.System.SlotInformation>;
    get ip_addresses(): VScript.StronglyTypedTable<VScript.VSocket, "System::Data::SlotInformation::IpAddresses", VAPI.System.SlotInformationIpAddresses>;
}
export declare class AllCommandLogging implements VScript.Referenceable<"System::Data::All::CommandLogging"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::All::CommandLogging";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get log_commands_to_syslog(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.System.AllCommandLogging>;
    get include_sender_id(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.System.AllCommandLogging>;
    get include_data(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.System.AllCommandLogging>;
}
export declare class AllEcc implements VScript.Referenceable<"System::Data::All::Ecc"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::All::Ecc";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get cpu_internal(): VAPI.System.ECC;
    get cpu_memory(): VAPI.System.ECC;
}
export declare class QSFPEqSupport implements VScript.Referenceable<"System::Data::QSFP::EqSupport"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::QSFP::EqSupport";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get max_tx_equalization(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.QSFPEqSupport>;
    get max_rx_output_emphasis(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.QSFPEqSupport>;
    get rx_output_emphasis_type(): VScript.rKeyword<VScript.VSocket, null | VAPI.System.QSFPEqSupportRxOutputEmphasisType, null | VAPI.System.QSFPEqSupportRxOutputEmphasisType, VAPI.System.QSFPEqSupport>;
    get rx_output_amplitude_support(): VScript.rKeyword<VScript.VSocket, null | Array<boolean>, null | Array<boolean>, VAPI.System.QSFPEqSupport>;
    get tx_input_equalizer_control(): VScript.rKeyword<VScript.VSocket, null | Array<number>, null | Array<number>, VAPI.System.QSFPEqSupport>;
    get tx_adaptive_equalization_control(): VScript.rKeyword<VScript.VSocket, null | Array<boolean>, null | Array<boolean>, VAPI.System.QSFPEqSupport>;
    get rx_output_emphasis_control(): VScript.rKeyword<VScript.VSocket, null | Array<number>, null | Array<number>, VAPI.System.QSFPEqSupport>;
    /**
      0: 100mV - 400mV 1: 300mV - 600mV 2: 400mV - 800mV 3: 600mV - 1200mV
    */
    get rx_output_amplitude_control(): VScript.rKeyword<VScript.VSocket, null | Array<number>, null | Array<number>, VAPI.System.QSFPEqSupport>;
}
export type PSUFanIssues = {
    airflow_fault: boolean;
    airflow_warning: boolean;
    fan_fault: boolean;
    fan_warning: boolean;
};
export declare class AllIoBoardInfo implements VScript.Referenceable<"System::Data::All::IoBoard::Info"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::All::IoBoard::Info";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      The following IO modules can currently be used with the
      C100/AT300:
      
      `IO_BNC_10_10`: 10× BNC in, 10× BNC out (up to 3G); 12G supported on
      bottom row.
      
      `IO_BNC_18_2`: 9× BNC in (up to 12G), 9× BNC in (up to 3G), 1× BNC out
      (up to 12G), 1× BNC out (up to 3G), analog video ref in +
      loop-through.
      
      `IO_BNC_11_11`: 11× BNC in (up to 12G), 11× BNC out (up to
      12G).
      
      `IO_BNC_11_11_GD32`: with GD32 microcontroller instead
      STM32.
      
      `IO_BNC_16_16`: 11× BNC in (up to 12G), 11× BNC out (up to 12G), 5×
      BNC in (up to 3G), 5× BNC out (up to 3G).
      
      `IO_BNC_16_16_GD32`: with GD32 microcontroller instead
      STM32.
      
      `IO_BNC_2_18`: 1× BNC in (up to 12G), 1× BNC in (up to 3G), 9× BNC out
      (up to 12G), 9× BNC out (up to 3G), analog video ref in +
      loop-through.
      
      `IO_BNC_2_2_16bidi`: 2× BNC in (up to 3G), 2× BNC out (up to 3G), 16×
      bidirectional BNC (up to 3G), analog video ref in +
      loop-through.
      
      `IO_BNC_16bidi`: 16× bidirectional BNC (up to 12G), analog ref in +
      loop-through.
      
      `IO_BNC_16bidi_GD32`: with GD32 microcontroller instead
      STM32.
      
      `IO_MSC_v2`: 10× bidirectional BNC (up to 12G), 2×3 analog video ref
      out, GPS antenna input, wordclock out, analog video ref in +
      loop-through.
      
      `IO_MSC_v2_GD32`: with GD32 microcontroller instead STM32.
    */
    get type(): VScript.rKeyword<VScript.VSocket, null | VAPI.System.IOBoard, null | VAPI.System.IOBoard, VAPI.System.AllIoBoardInfo>;
    get revision(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        number
    ], null | VAPI.System.Revision, VAPI.System.AllIoBoardInfo>;
    get serial(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.System.AllIoBoardInfo>;
}
export declare class AllIoBoard implements VScript.Referenceable<"System::Data::All::IoBoard"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::All::IoBoard";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get info(): VAPI.System.AllIoBoardInfo;
    get pcb(): VScript.StronglyTypedTable<VScript.VSocket, "System::Data::PCBInfo", VAPI.System.PCBInfo>;
}
export declare class SlotInformationIpAddresses implements VScript.Referenceable<"System::Data::SlotInformation::IpAddresses"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::SlotInformation::IpAddresses";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get port(): VScript.rKeyword<VScript.VSocket, null | VAPI.System.SlotInformationIpAddressesPort, null | VAPI.System.SlotInformationIpAddressesPort, VAPI.System.SlotInformationIpAddresses>;
    get ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.System.SlotInformationIpAddresses>;
}
export type FanSpeedIssues = {
    critically_low_fan_speed: boolean;
    low_fan_speed: boolean;
};
export type NeighborhoodWatchIssues = {
    unknown_neighbor_address: boolean;
};
export type PSUIssues = {
    input_f_w: boolean;
    input_uv_f: boolean;
    iout_pout_f_w: boolean;
    output_oc_f: boolean;
    output_ov_f: boolean;
    temperature_f_w: boolean;
    vout_f_w: boolean;
};
export declare class AllNmos implements VScript.Referenceable<"System::Data::All::Nmos"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::All::Nmos";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Write to config file
    */
    get write_config(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.System.AllNmos>;
    get enable(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.System.AllNmos>;
    get log_requests(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.System.AllNmos>;
    get is_04(): VAPI.System.IS04;
}
export type SlotInformationIpAddressesPort = "FRONT_MANAGEMENT" | "REAR_MANAGEMENT" | "PORT0" | "PORT1" | "PORT1_0" | "PORT1_1" | "PORT1_2" | "PORT1_3" | "PORT2" | "PORT2_0" | "PORT2_1" | "PORT2_2" | "PORT2_3";
export type Protocol = "http" | "https";
export type QSFPEqSupportRxOutputEmphasisType = "PEAK_TO_PEAK" | "STEADY_STATE" | "AVERAGE" | "RESERVED";
export declare class QSFPRxPower implements VScript.Referenceable<"System::Data::QSFP::RxPower"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::QSFP::RxPower";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get wattage(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.QSFPRxPower>;
    get d_bm(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.System.QSFPRxPower>;
    get error(): VScript.rKeyword<VScript.VSocket, null | VAPI.System.QSFPError, null | VAPI.System.QSFPError, VAPI.System.QSFPRxPower>;
}
export declare class AllServices implements VScript.Referenceable<"System::Data::All::Services"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::All::Services";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Enables Avahi daemon (mDNS/DNS-SD)
    */
    get avahi(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.System.AllServices>;
    /**
      Enables SNMP daemon
    */
    get snmp(): VScript.dKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.System.AllServices>;
}
export declare class AllUsrinfo implements VScript.Referenceable<"System::Data::All::Usrinfo"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "System::Data::All::Usrinfo";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      this should be a brief, human-readable description that will be displayed
      within the web UI
    */
    get short_desc(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.System.AllUsrinfo>;
    /**
      this should be a detailed, human-readable description that will be
      displayed within the web UI
    */
    get long_desc(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.System.AllUsrinfo>;
    /**
      enter a towel owner to mark this machine as reserved. Like a physical
      towel, this serves as a declaration of interest only and does not provide
      any protection against unauthorized access
    */
    get towel(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.System.AllUsrinfo>;
    /**
      this is a transient status field that does not persist across machine
      restarts. It can be used to, e.g., signal a machine's current task within
      an automated testing environment
    */
    get cur_status(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.System.AllUsrinfo>;
}
export declare const Enums: {
    readonly Protocol: Protocol[];
    readonly RAMCALIBRATION: RAMCALIBRATION[];
    readonly QSFPError: QSFPError[];
    readonly PCIESPEED: PCIESPEED[];
    readonly LEDBRIGHTNESS: LEDBRIGHTNESS[];
    readonly IOBoard: IOBoard[];
    readonly BOARDPOS: BOARDPOS[];
};
