import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    CompileInfo: (_raw) => (new CompileInfo(_raw)),
    Device: (_raw) => (new Device(_raw)),
    DeviceInfo: (_raw) => (new DeviceInfo(_raw)),
    ECC: (_raw) => (new ECC(_raw)),
    FanSpeed: (_raw) => (new FanSpeed(_raw)),
    IS04: (_raw) => (new IS04(_raw)),
    NeighborhoodWatch: (_raw) => (new NeighborhoodWatch(_raw)),
    PCBInfo: (_raw) => (new PCBInfo(_raw)),
    PSU: (_raw) => (new PSU(_raw)),
    QSFP: (_raw) => (new QSFP(_raw)),
    Revision: (_raw, _socket) => {
        return {
            major: _raw[0],
            minor: _raw[1]
        };
    },
    SPD: (_raw) => (new SPD(_raw)),
    SWVersion: (_raw) => (new SWVersion(_raw)),
    SlotInformation: (_raw) => (new SlotInformation(_raw)),
    AllCommandLogging: (_raw) => (new AllCommandLogging(_raw)),
    AllEcc: (_raw) => (new AllEcc(_raw)),
    QSFPEqSupport: (_raw) => (new QSFPEqSupport(_raw)),
    AllIoBoardInfo: (_raw) => (new AllIoBoardInfo(_raw)),
    AllIoBoard: (_raw) => (new AllIoBoard(_raw)),
    SlotInformationIpAddresses: (_raw) => (new SlotInformationIpAddresses(_raw)),
    AllNmos: (_raw) => (new AllNmos(_raw)),
    QSFPRxPower: (_raw) => (new QSFPRxPower(_raw)),
    AllServices: (_raw) => (new AllServices(_raw)),
    AllUsrinfo: (_raw) => (new AllUsrinfo(_raw)),
};
export const lower = {
    CompileInfo: (_x) => _x.raw.kwl,
    Device: (_x) => _x.raw.kwl,
    DeviceInfo: (_x) => _x.raw.kwl,
    ECC: (_x) => _x.raw.kwl,
    FanSpeed: (_x) => _x.raw.kwl,
    IS04: (_x) => _x.raw.kwl,
    NeighborhoodWatch: (_x) => _x.raw.kwl,
    PCBInfo: (_x) => _x.raw.kwl,
    PSU: (_x) => _x.raw.kwl,
    QSFP: (_x) => _x.raw.kwl,
    Revision: (_x, _socket) => [
        _x.major,
        _x.minor
    ],
    SPD: (_x) => _x.raw.kwl,
    SWVersion: (_x) => _x.raw.kwl,
    SlotInformation: (_x) => _x.raw.kwl,
    AllCommandLogging: (_x) => _x.raw.kwl,
    AllEcc: (_x) => _x.raw.kwl,
    QSFPEqSupport: (_x) => _x.raw.kwl,
    AllIoBoardInfo: (_x) => _x.raw.kwl,
    AllIoBoard: (_x) => _x.raw.kwl,
    SlotInformationIpAddresses: (_x) => _x.raw.kwl,
    AllNmos: (_x) => _x.raw.kwl,
    QSFPRxPower: (_x) => _x.raw.kwl,
    AllServices: (_x) => _x.raw.kwl,
    AllUsrinfo: (_x) => _x.raw.kwl,
};
export class CompileInfo {
    raw;
    type_identifier = "System::Data::CompileInfo";
    constructor(raw) {
        this.raw = raw;
    }
    get hg() {
        return new VScript.rKeyword(this, "hg", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get user() {
        return new VScript.rKeyword(this, "user", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get time() {
        return new VScript.rKeyword(this, "time", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get proj() {
        return new VScript.rKeyword(this, "proj", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class Device {
    raw;
    type_identifier = "System::Data::Device";
    constructor(raw) {
        this.raw = raw;
    }
    get info() {
        return VAPI.System.lift.DeviceInfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "info"));
    }
    get pcb() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "pcb"), (raw, _) => VAPI.System.lift.PCBInfo(raw));
    }
}
export class DeviceInfo {
    raw;
    type_identifier = "System::Data::DeviceInfo";
    constructor(raw) {
        this.raw = raw;
    }
    get type() {
        return new VScript.rKeyword(this, "type", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get revision() {
        return new VScript.rKeyword(this, "revision", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.System.lift.Revision),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.System.lower.Revision)
        });
    }
    get serial() {
        return new VScript.rKeyword(this, "serial", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class ECC {
    raw;
    type_identifier = "System::Data::ECC";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Corrected errors
    */
    get ce_count() {
        return new VScript.rKeyword(this, "ce_count", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    /**
      Uncorrected errors
    */
    get ue_count() {
        return new VScript.rKeyword(this, "ue_count", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
}
export class FanSpeed {
    raw;
    type_identifier = "System::Data::FanSpeed";
    constructor(raw) {
        this.raw = raw;
    }
    get id() {
        return new VScript.rKeyword(this, "id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get speed() {
        return new VScript.rKeyword(this, "speed", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get issues() {
        return new VScript.rKeyword(this, "issues", {
            lift: (x, _) => ({
                critically_low_fan_speed: (x & 1) !== 0,
                low_fan_speed: (x & 2) !== 0
            }),
            lower: (x, _) => ((x.critically_low_fan_speed ? 1 : 0) |
                (x.low_fan_speed ? 2 : 0))
        });
    }
}
export class IS04 {
    raw;
    type_identifier = "System::Data::IS04";
    constructor(raw) {
        this.raw = raw;
    }
    get registry_connected() {
        return new VScript.rKeyword(this, "registry_connected", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get protocol() {
        return new VScript.rwKeyword(this, "protocol", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      IP and Port of desired NMOS Registry
    */
    get registry_address() {
        return new VScript.rwKeyword(this, "registry_address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        }, null);
    }
}
export class NeighborhoodWatch {
    raw;
    type_identifier = "System::Data::NeighborhoodWatch";
    constructor(raw) {
        this.raw = raw;
    }
    get issues() {
        return new VScript.rKeyword(this, "issues", {
            lift: (x, _) => ({
                unknown_neighbor_address: (x & 1) !== 0
            }),
            lower: (x, _) => ((x.unknown_neighbor_address ? 1 : 0))
        });
    }
    get connected() {
        return new VScript.rKeyword(this, "connected", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get neighbor_info() {
        return new VScript.rKeyword(this, "neighbor_info", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      if this is set to true, successfully parsed neighbor info lines will be
      filtered from the output
    */
    get filter_neighbor_info() {
        return new VScript.rwKeyword(this, "filter_neighbor_info", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get output() {
        return new VScript.rKeyword(this, "output", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class PCBInfo {
    raw;
    type_identifier = "System::Data::PCBInfo";
    constructor(raw) {
        this.raw = raw;
    }
    get type() {
        return new VScript.rKeyword(this, "type", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get revision() {
        return new VScript.rKeyword(this, "revision", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.System.lift.Revision),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.System.lower.Revision)
        });
    }
    get serial() {
        return new VScript.rKeyword(this, "serial", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get vendor() {
        return new VScript.rKeyword(this, "vendor", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get date() {
        return new VScript.rKeyword(this, "date", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class PSU {
    raw;
    type_identifier = "System::Data::PSU";
    constructor(raw) {
        this.raw = raw;
    }
    get vin() {
        return new VScript.rKeyword(this, "vin", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get vin_min() {
        return new VScript.rKeyword(this, "vin_min", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get iin() {
        return new VScript.rKeyword(this, "iin", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get vout() {
        return new VScript.rKeyword(this, "vout", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get iout() {
        return new VScript.rKeyword(this, "iout", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get temp1() {
        return new VScript.rKeyword(this, "temp1", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get temp2() {
        return new VScript.rKeyword(this, "temp2", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get temp_hotspot() {
        return new VScript.rKeyword(this, "temp_hotspot", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get on() {
        return new VScript.rKeyword(this, "on", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get fanspeed() {
        return new VScript.rKeyword(this, "fanspeed", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get current_fanspeed_profile() {
        return new VScript.rKeyword(this, "current_fanspeed_profile", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get issues() {
        return new VScript.rKeyword(this, "issues", {
            lift: (x, _) => ({
                input_f_w: (x & 1) !== 0,
                input_uv_f: (x & 2) !== 0,
                iout_pout_f_w: (x & 4) !== 0,
                output_oc_f: (x & 8) !== 0,
                output_ov_f: (x & 16) !== 0,
                temperature_f_w: (x & 32) !== 0,
                vout_f_w: (x & 64) !== 0
            }),
            lower: (x, _) => ((x.input_f_w ? 1 : 0) |
                (x.input_uv_f ? 2 : 0) |
                (x.iout_pout_f_w ? 4 : 0) |
                (x.output_oc_f ? 8 : 0) |
                (x.output_ov_f ? 16 : 0) |
                (x.temperature_f_w ? 32 : 0) |
                (x.vout_f_w ? 64 : 0))
        });
    }
    get fan_issues() {
        return new VScript.rKeyword(this, "fan_issues", {
            lift: (x, _) => ({
                airflow_fault: (x & 1) !== 0,
                airflow_warning: (x & 2) !== 0,
                fan_fault: (x & 4) !== 0,
                fan_warning: (x & 8) !== 0
            }),
            lower: (x, _) => ((x.airflow_fault ? 1 : 0) |
                (x.airflow_warning ? 2 : 0) |
                (x.fan_fault ? 4 : 0) |
                (x.fan_warning ? 8 : 0))
        });
    }
}
export class QSFP {
    raw;
    type_identifier = "System::Data::QSFP";
    constructor(raw) {
        this.raw = raw;
    }
    get vendor_name() {
        return new VScript.rKeyword(this, "vendor_name", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      IEEE company ID
    */
    get vendor_oui() {
        return new VScript.rKeyword(this, "vendor_oui", {
            lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
        });
    }
    get vendor_pn() {
        return new VScript.rKeyword(this, "vendor_pn", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get vendor_rev() {
        return new VScript.rKeyword(this, "vendor_rev", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get vendor_sn() {
        return new VScript.rKeyword(this, "vendor_sn", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get date_code() {
        return new VScript.rKeyword(this, "date_code", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get eq_support() {
        return VAPI.System.lift.QSFPEqSupport(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "eq_support"));
    }
    get temperature() {
        return new VScript.rKeyword(this, "temperature", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get temp_error() {
        return new VScript.rKeyword(this, "temp_error", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get rx_power() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 9, "rx_power"), (st, _) => VAPI.System.lift.QSFPRxPower(st));
    }
}
export class SPD {
    raw;
    type_identifier = "System::Data::SPD";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      ID code of the module manufacturer.
      
      0x2C80 = Micron
      
      0x5207 = Memphis
    */
    get module_manufacturer() {
        return new VScript.rKeyword(this, "module_manufacturer", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    /**
      ID code of the DRAM chips manufacturer.
      
      0xAD80 = SK Hynix
      
      0xCE80 = Samsung
      
      0x2C80 = Micron
    */
    get dram_manufacturer() {
        return new VScript.rKeyword(this, "dram_manufacturer", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get year() {
        return new VScript.rKeyword(this, "year", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get week() {
        return new VScript.rKeyword(this, "week", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get sn() {
        return new VScript.rKeyword(this, "sn", {
            lift: VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x)
        });
    }
    get pn() {
        return new VScript.rKeyword(this, "pn", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get revision() {
        return new VScript.rKeyword(this, "revision", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get data_capacity() {
        return new VScript.rKeyword(this, "data_capacity", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
}
export class SWVersion {
    raw;
    type_identifier = "System::Data::SWVersion";
    constructor(raw) {
        this.raw = raw;
    }
    get version() {
        return new VScript.rKeyword(this, "version", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get timestamp() {
        return new VScript.rKeyword(this, "timestamp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class SlotInformation {
    raw;
    type_identifier = "System::Data::SlotInformation";
    constructor(raw) {
        this.raw = raw;
    }
    get location() {
        return new VScript.rKeyword(this, "location", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get version() {
        return new VScript.rKeyword(this, "version", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get temperature() {
        return new VScript.rKeyword(this, "temperature", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get model() {
        return new VScript.rKeyword(this, "model", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get ip_addresses() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "ip_addresses"), (raw, _) => VAPI.System.lift.SlotInformationIpAddresses(raw));
    }
}
export class AllCommandLogging {
    raw;
    type_identifier = "System::Data::All::CommandLogging";
    constructor(raw) {
        this.raw = raw;
    }
    get log_commands_to_syslog() {
        return new VScript.rwKeyword(this, "log_commands_to_syslog", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get include_sender_id() {
        return new VScript.rwKeyword(this, "include_sender_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get include_data() {
        return new VScript.rwKeyword(this, "include_data", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class AllEcc {
    raw;
    type_identifier = "System::Data::All::Ecc";
    constructor(raw) {
        this.raw = raw;
    }
    get cpu_internal() {
        return VAPI.System.lift.ECC(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "cpu_internal"));
    }
    get cpu_memory() {
        return VAPI.System.lift.ECC(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "cpu_memory"));
    }
}
export class QSFPEqSupport {
    raw;
    type_identifier = "System::Data::QSFP::EqSupport";
    constructor(raw) {
        this.raw = raw;
    }
    get max_tx_equalization() {
        return new VScript.rKeyword(this, "max_tx_equalization", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get max_rx_output_emphasis() {
        return new VScript.rKeyword(this, "max_rx_output_emphasis", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get rx_output_emphasis_type() {
        return new VScript.rKeyword(this, "rx_output_emphasis_type", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get rx_output_amplitude_support() {
        return new VScript.rKeyword(this, "rx_output_amplitude_support", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x)),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x))
        });
    }
    get tx_input_equalizer_control() {
        return new VScript.rKeyword(this, "tx_input_equalizer_control", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x)),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x))
        });
    }
    get tx_adaptive_equalization_control() {
        return new VScript.rKeyword(this, "tx_adaptive_equalization_control", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x)),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x))
        });
    }
    get rx_output_emphasis_control() {
        return new VScript.rKeyword(this, "rx_output_emphasis_control", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x)),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x))
        });
    }
    /**
      0: 100mV - 400mV 1: 300mV - 600mV 2: 400mV - 800mV 3: 600mV - 1200mV
    */
    get rx_output_amplitude_control() {
        return new VScript.rKeyword(this, "rx_output_amplitude_control", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftArray((x /* FIXME */, _) => x)),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerArray((x /* FIXME */, _) => x))
        });
    }
}
export class AllIoBoardInfo {
    raw;
    type_identifier = "System::Data::All::IoBoard::Info";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      The following IO modules can currently be used with the
      C100/AT300:
      
      `IO_BNC_10_10`: 10× BNC in, 10× BNC out (up to 3G); 12G supported on
      bottom row.
      
      `IO_BNC_18_2`: 9× BNC in (up to 12G), 9× BNC in (up to 3G), 1× BNC out
      (up to 12G), 1× BNC out (up to 3G), analog video ref in +
      loop-through.
      
      `IO_BNC_11_11`: 11× BNC in (up to 12G), 11× BNC out (up to
      12G).
      
      `IO_BNC_11_11_GD32`: with GD32 microcontroller instead
      STM32.
      
      `IO_BNC_16_16`: 11× BNC in (up to 12G), 11× BNC out (up to 12G), 5×
      BNC in (up to 3G), 5× BNC out (up to 3G).
      
      `IO_BNC_16_16_GD32`: with GD32 microcontroller instead
      STM32.
      
      `IO_BNC_2_18`: 1× BNC in (up to 12G), 1× BNC in (up to 3G), 9× BNC out
      (up to 12G), 9× BNC out (up to 3G), analog video ref in +
      loop-through.
      
      `IO_BNC_2_2_16bidi`: 2× BNC in (up to 3G), 2× BNC out (up to 3G), 16×
      bidirectional BNC (up to 3G), analog video ref in +
      loop-through.
      
      `IO_BNC_16bidi`: 16× bidirectional BNC (up to 12G), analog ref in +
      loop-through.
      
      `IO_BNC_16bidi_GD32`: with GD32 microcontroller instead
      STM32.
      
      `IO_MSC_v2`: 10× bidirectional BNC (up to 12G), 2×3 analog video ref
      out, GPS antenna input, wordclock out, analog video ref in +
      loop-through.
      
      `IO_MSC_v2_GD32`: with GD32 microcontroller instead STM32.
    */
    get type() {
        return new VScript.rKeyword(this, "type", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get revision() {
        return new VScript.rKeyword(this, "revision", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.System.lift.Revision),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.System.lower.Revision)
        });
    }
    get serial() {
        return new VScript.rKeyword(this, "serial", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class AllIoBoard {
    raw;
    type_identifier = "System::Data::All::IoBoard";
    constructor(raw) {
        this.raw = raw;
    }
    get info() {
        return VAPI.System.lift.AllIoBoardInfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "info"));
    }
    get pcb() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "pcb"), (raw, _) => VAPI.System.lift.PCBInfo(raw));
    }
}
export class SlotInformationIpAddresses {
    raw;
    type_identifier = "System::Data::SlotInformation::IpAddresses";
    constructor(raw) {
        this.raw = raw;
    }
    get port() {
        return new VScript.rKeyword(this, "port", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get ip_address() {
        return new VScript.rKeyword(this, "ip_address", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
}
export class AllNmos {
    raw;
    type_identifier = "System::Data::All::Nmos";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Write to config file
    */
    get write_config() {
        return new VScript.wKeyword(this, "write_config", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get enable() {
        return new VScript.rwKeyword(this, "enable", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get log_requests() {
        return new VScript.rwKeyword(this, "log_requests", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get is_04() {
        return VAPI.System.lift.IS04(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "is_04"));
    }
}
export class QSFPRxPower {
    raw;
    type_identifier = "System::Data::QSFP::RxPower";
    constructor(raw) {
        this.raw = raw;
    }
    get wattage() {
        return new VScript.rKeyword(this, "wattage", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get d_bm() {
        return new VScript.rKeyword(this, "d_bm", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
    get error() {
        return new VScript.rKeyword(this, "error", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
        });
    }
}
export class AllServices {
    raw;
    type_identifier = "System::Data::All::Services";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Enables Avahi daemon (mDNS/DNS-SD)
    */
    get avahi() {
        return new VScript.dKeyword(this, "avahi", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      Enables SNMP daemon
    */
    get snmp() {
        return new VScript.dKeyword(this, "snmp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class AllUsrinfo {
    raw;
    type_identifier = "System::Data::All::Usrinfo";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      this should be a brief, human-readable description that will be displayed
      within the web UI
    */
    get short_desc() {
        return new VScript.rwKeyword(this, "short_desc", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      this should be a detailed, human-readable description that will be
      displayed within the web UI
    */
    get long_desc() {
        return new VScript.rwKeyword(this, "long_desc", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      enter a towel owner to mark this machine as reserved. Like a physical
      towel, this serves as a declaration of interest only and does not provide
      any protection against unauthorized access
    */
    get towel() {
        return new VScript.rwKeyword(this, "towel", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    /**
      this is a transient status field that does not persist across machine
      restarts. It can be used to, e.g., signal a machine's current task within
      an automated testing environment
    */
    get cur_status() {
        return new VScript.rwKeyword(this, "cur_status", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export const Enums = {
    Protocol: ["http", "https"],
    RAMCALIBRATION: ["Successful", "Unknown", "Failed"],
    QSFPError: ["OK", "LOW_WARNING", "HIGH_WARNING", "LOW_ALARM", "HIGH_ALARM"],
    PCIESPEED: ["UNKNOWN", "GT_2_5", "GT_5_0", "GT_8_0"],
    LEDBRIGHTNESS: ["FULL", "MINIMUM"],
    IOBoard: ["IO_BNC_10_10", "IO_BNC_18_2", "IO_BNC_11_11", "IO_BNC_11_11_GD32", "IO_BNC_16_16", "IO_BNC_16_16_GD32", "IO_BNC_2_18", "IO_BNC_2_2_16bidi", "IO_BNC_16bidi", "IO_BNC_16bidi_GD32", "IO_MSC_v1", "IO_MSC_v2", "IO_MSC_v2_GD32"],
    BOARDPOS: ["BOTTOM_LEFT", "BOTTOM_RIGHT", "MID_LEFT", "MID_CENTER", "MID_RIGHT", "TOP_LEFT", "TOP_CENTER", "TOP_RIGHT", "UNKNOWN"]
};
