import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    ManifoldCoreStatistics: (_raw) => (new ManifoldCoreStatistics(_raw)),
    ManifoldMemoryStatistics: (_raw) => (new ManifoldMemoryStatistics(_raw)),
    UDXFilter: (_raw) => (new UDXFilter(_raw)),
    UDXStatistics: (_raw) => (new UDXStatistics(_raw)),
    UDXTransform: (_raw) => (new UDXTransform(_raw)),
    UDXVideoCrop: (_raw) => (new UDXVideoCrop(_raw)),
};
export const lower = {
    ManifoldCoreStatistics: (_x) => _x.raw.kwl,
    ManifoldMemoryStatistics: (_x) => _x.raw.kwl,
    UDXFilter: (_x) => _x.raw.kwl,
    UDXStatistics: (_x) => _x.raw.kwl,
    UDXTransform: (_x) => _x.raw.kwl,
    UDXVideoCrop: (_x) => _x.raw.kwl,
};
export class ManifoldCoreStatistics {
    raw;
    type_identifier = "UDX::Data::ManifoldCoreStatistics";
    constructor(raw) {
        this.raw = raw;
    }
    get sync_length() {
        return new VScript.rKeyword(this, "sync_length", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get sync_calc_length() {
        return new VScript.rKeyword(this, "sync_calc_length", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_0_primitives_num() {
        return new VScript.rKeyword(this, "output_0_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_1_primitives_num() {
        return new VScript.rKeyword(this, "output_1_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_2_primitives_num() {
        return new VScript.rKeyword(this, "output_2_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_3_primitives_num() {
        return new VScript.rKeyword(this, "output_3_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_4_primitives_num() {
        return new VScript.rKeyword(this, "output_4_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_5_primitives_num() {
        return new VScript.rKeyword(this, "output_5_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_6_primitives_num() {
        return new VScript.rKeyword(this, "output_6_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get output_7_primitives_num() {
        return new VScript.rKeyword(this, "output_7_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get total_primitives_num() {
        return new VScript.rKeyword(this, "total_primitives_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get core_total_clks() {
        return new VScript.rKeyword(this, "core_total_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get core_active_clks() {
        return new VScript.rKeyword(this, "core_active_clks", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get core_load() {
        return new VScript.rKeyword(this, "core_load", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class ManifoldMemoryStatistics {
    raw;
    type_identifier = "UDX::Data::ManifoldMemoryStatistics";
    constructor(raw) {
        this.raw = raw;
    }
    get mem_band_max_gbits() {
        return new VScript.rKeyword(this, "mem_band_max_gbits", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mem_band_write_gbits() {
        return new VScript.rKeyword(this, "mem_band_write_gbits", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get mem_band_read_gbits() {
        return new VScript.rKeyword(this, "mem_band_read_gbits", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class UDXFilter {
    raw;
    type_identifier = "UDX::Data::UDXFilter";
    constructor(raw) {
        this.raw = raw;
    }
    get mode() {
        return new VScript.rwKeyword(this, "mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get window() {
        return new VScript.rwKeyword(this, "window", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get h_filter_offset() {
        return new VScript.dKeyword(this, "h_filter_offset", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get v_filter_offset() {
        return new VScript.dKeyword(this, "v_filter_offset", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class UDXStatistics {
    raw;
    type_identifier = "UDX::Data::UDXStatistics";
    constructor(raw) {
        this.raw = raw;
    }
    get cores() {
        return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 0, "cores"), (st, _) => VAPI.UDX.lift.ManifoldCoreStatistics(st));
    }
    get memory() {
        return VAPI.UDX.lift.ManifoldMemoryStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "memory"));
    }
}
export class UDXTransform {
    raw;
    type_identifier = "UDX::Data::UDXTransform";
    constructor(raw) {
        this.raw = raw;
    }
    get pos_mode() {
        return new VScript.rwKeyword(this, "pos_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get pos_x() {
        return new VScript.dKeyword(this, "pos_x", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get pos_y() {
        return new VScript.dKeyword(this, "pos_y", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get size_mode() {
        return new VScript.rwKeyword(this, "size_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get size_x() {
        return new VScript.dKeyword(this, "size_x", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get size_y() {
        return new VScript.dKeyword(this, "size_y", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class UDXVideoCrop {
    raw;
    type_identifier = "UDX::Data::UDXVideoCrop";
    constructor(raw) {
        this.raw = raw;
    }
    get crop_mode() {
        return new VScript.rwKeyword(this, "crop_mode", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get left() {
        return new VScript.dKeyword(this, "left", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get right() {
        return new VScript.dKeyword(this, "right", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get top() {
        return new VScript.dKeyword(this, "top", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
    get bottom() {
        return new VScript.dKeyword(this, "bottom", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export const Enums = {
    UDXSOURCESHOWMODE: ["SHOW_BLACK", "SHOW_LAST_FRAME"],
    UDXSDACTIVEWIDTH: ["W720", "W702"],
    UDXOFFSETMODE: ["AUTO", "OFFSET_AUTO", "OFFSET_MANUAL"],
    UDXFILTERWINDOW: ["HAMMING", "KAISER"],
    UDXASPECTRATIO: ["ANAMORPHIC", "LETTERBOX", "PILLARBOX", "CENTERCUT"],
    UDXVideoStandard: ["PAL", "NTSC", "HD720p25", "HD720p29_97", "HD720p30", "HD720p50", "HD720p59_94", "HD720p60", "HD1080p23_98", "HD1080sF23_98", "HD1080p24", "HD1080sF24", "HD1080p25", "HD1080sF25", "HD1080p29_97", "HD1080sF29_97", "HD1080p30", "HD1080sF30", "HD1080i50", "HD1080i59_94", "HD1080i60", "HD1080p50", "HD1080p59_94", "HD1080p60", "HD2160p50", "HD2160p59_94", "HD2160p60"]
};
