import * as VScript from "vscript";
export * as Audio from "./Audio.js";
export * as AudioMixer from "./AudioMixer.js";
export * as AudioRePlay from "./AudioRePlay.js";
export * as ClosXBar from "./ClosXBar.js";
export * as Cluster from "./Cluster.js";
export * as ClusterMonitoringObjects from "./ClusterMonitoringObjects.js";
export * as ClusterNodes from "./ClusterNodes.js";
export * as ClusterOutputs from "./ClusterOutputs.js";
export * as ClusterProcessors from "./ClusterProcessors.js";
export * as ClusterSources from "./ClusterSources.js";
export * as ColorCorrection from "./ColorCorrection.js";
export * as DataRePlay from "./DataRePlay.js";
export * as Definitions from "./Definitions.js";
export * as EthernetStats from "./EthernetStats.js";
export * as Genlock from "./Genlock.js";
export * as IOModule from "./IOModule.js";
export * as J2KDecoder from "./J2KDecoder.js";
export * as MasterClock from "./MasterClock.js";
export * as Memory from "./Memory.js";
export * as MetadataProcessor from "./MetadataProcessor.js";
export * as Monitoring from "./Monitoring.js";
export * as Multiviewer from "./Multiviewer.js";
export * as MultiviewerIO from "./MultiviewerIO.js";
export * as NetworkInterfaces from "./NetworkInterfaces.js";
export * as PCap from "./PCap.js";
export * as PTP from "./PTP.js";
export * as PTPClock from "./PTPClock.js";
export * as PTPFlows from "./PTPFlows.js";
export * as Primitives from "./Primitives.js";
export * as RTPMetadataChannel from "./RTPMetadataChannel.js";
export * as RTPReceiver from "./RTPReceiver.js";
export * as RTPTransmitter from "./RTPTransmitter.js";
export * as SDP from "./SDP.js";
export * as SampleRateConverter from "./SampleRateConverter.js";
export * as ServicesList from "./ServicesList.js";
export * as Servos from "./Servos.js";
export * as SoftwareUpdate from "./SoftwareUpdate.js";
export * as System from "./System.js";
export * as SystemClock from "./SystemClock.js";
export * as Time from "./Time.js";
export * as TimeFlows from "./TimeFlows.js";
export * as UDX from "./UDX.js";
export * as Video from "./Video.js";
export * as VideoMixer from "./VideoMixer.js";
export * as VideoPlayer from "./VideoPlayer.js";
export * as VideoRePlay from "./VideoRePlay.js";
export * as VideoSignalGenerator from "./VideoSignalGenerator.js";
import * as AT1101 from "./AT1101.js";
export * as AT1101 from "./AT1101.js";
import * as AT1130 from "./AT1130.js";
export * as AT1130 from "./AT1130.js";
export declare const version = "2.4.20";
export declare namespace VM {
    type Any = AT1101.Root | AT1130.Root;
    function adopt(vsocket: VScript.VSocket): Any;
    function open(pars: VScript.VSocketParameters): Promise<Any>;
}
export declare namespace Any {
    namespace Audio {
        type Essence = AT1101.Audio.Essence | AT1130.Audio.Essence;
        type TimedSource = AT1101.Audio.TimedSource | AT1130.Audio.TimedSource;
    }
    namespace AudioGain {
        type All = AT1101.AudioGain.All | AT1130.AudioGain.All;
        type Levels = AT1101.AudioGain.Levels | AT1130.AudioGain.Levels;
    }
    namespace AudioMixer {
        type All = AT1101.AudioMixer.All | AT1130.AudioMixer.All;
        type ChannelMono = AT1101.AudioMixer.ChannelMono | AT1130.AudioMixer.ChannelMono;
        type ChannelSelection = AT1101.AudioMixer.ChannelSelection | AT1130.AudioMixer.ChannelSelection;
        type ChannelStereo = AT1101.AudioMixer.ChannelStereo | AT1130.AudioMixer.ChannelStereo;
        type Downmixes = AT1101.AudioMixer.Downmixes | AT1130.AudioMixer.Downmixes;
        type Mode51 = AT1101.AudioMixer.Mode51 | AT1130.AudioMixer.Mode51;
        type Mode71 = AT1101.AudioMixer.Mode71 | AT1130.AudioMixer.Mode71;
        type Monos = AT1101.AudioMixer.Monos | AT1130.AudioMixer.Monos;
        type Source = AT1101.AudioMixer.Source | AT1130.AudioMixer.Source;
        type SourceStereo = AT1101.AudioMixer.SourceStereo | AT1130.AudioMixer.SourceStereo;
        type Stereos = AT1101.AudioMixer.Stereos | AT1130.AudioMixer.Stereos;
        type StereosOutput = AT1101.AudioMixer.StereosOutput | AT1130.AudioMixer.StereosOutput;
    }
    namespace AudioRePlay {
        type Audio = AT1101.AudioRePlay.Audio | AT1130.AudioRePlay.Audio;
        type Buffer = AT1101.AudioRePlay.Buffer | AT1130.AudioRePlay.Buffer;
        type Delay = AT1101.AudioRePlay.Delay | AT1130.AudioRePlay.Delay;
        type DelayInputs = AT1101.AudioRePlay.DelayInputs | AT1130.AudioRePlay.DelayInputs;
        type DelayOutput = AT1101.AudioRePlay.DelayOutput | AT1130.AudioRePlay.DelayOutput;
        type Player = AT1101.AudioRePlay.Player | AT1130.AudioRePlay.Player;
        type PlayerOutput = AT1101.AudioRePlay.PlayerOutput | AT1130.AudioRePlay.PlayerOutput;
        type RelationAudio = AT1101.AudioRePlay.RelationAudio | AT1130.AudioRePlay.RelationAudio;
        type RelationAudioFollowers = AT1101.AudioRePlay.RelationAudioFollowers | AT1130.AudioRePlay.RelationAudioFollowers;
        type RelationVideo = AT1101.AudioRePlay.RelationVideo | AT1130.AudioRePlay.RelationVideo;
        type RelationVideoFollowers = AT1101.AudioRePlay.RelationVideoFollowers | AT1130.AudioRePlay.RelationVideoFollowers;
        type Relations = AT1101.AudioRePlay.Relations | AT1130.AudioRePlay.Relations;
        type Time = AT1101.AudioRePlay.Time | AT1130.AudioRePlay.Time;
    }
    namespace AudioShuffler {
        type All = AT1101.AudioShuffler.All | AT1130.AudioShuffler.All;
        type Shuffler = AT1101.AudioShuffler.Shuffler | AT1130.AudioShuffler.Shuffler;
    }
    namespace AudioSignalGenerator {
        type All = AT1101.AudioSignalGenerator.All | AT1130.AudioSignalGenerator.All;
        type OUT = AT1101.AudioSignalGenerator.OUT | AT1130.AudioSignalGenerator.OUT;
    }
    namespace Cluster {
        type All = AT1101.Cluster.All | AT1130.Cluster.All;
        type ClusterGlobal = AT1101.Cluster.ClusterGlobal | AT1130.Cluster.ClusterGlobal;
        type ClusterGlobalRuntime = AT1101.Cluster.ClusterGlobalRuntime | AT1130.Cluster.ClusterGlobalRuntime;
        type ClusterLocal = AT1101.Cluster.ClusterLocal | AT1130.Cluster.ClusterLocal;
        type ClusterLocalRuntime = AT1101.Cluster.ClusterLocalRuntime | AT1130.Cluster.ClusterLocalRuntime;
    }
    namespace ClusterMonitoringObjects {
        type ClusterAudioMonitoringObjectRuntime = AT1101.ClusterMonitoringObjects.ClusterAudioMonitoringObjectRuntime | AT1130.ClusterMonitoringObjects.ClusterAudioMonitoringObjectRuntime;
        type ClusterMetadataMonitoringObjectRuntime = AT1101.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectRuntime | AT1130.ClusterMonitoringObjects.ClusterMetadataMonitoringObjectRuntime;
        type ClusterMonitoringObjectGlobalRuntime = AT1101.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalRuntime | AT1130.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalRuntime;
        type ClusterVideoMonitoringObjectRuntime = AT1101.ClusterMonitoringObjects.ClusterVideoMonitoringObjectRuntime | AT1130.ClusterMonitoringObjects.ClusterVideoMonitoringObjectRuntime;
    }
    namespace ClusterProcessors {
        type ClusterProcessorMipMapsDualOutputRuntime = AT1101.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntime | AT1130.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntime;
        type ClusterProcessorMipMapsDualOutputRuntimeSource = AT1101.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource | AT1130.ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource;
        type ClusterProcessorsLocalRuntime = AT1101.ClusterProcessors.ClusterProcessorsLocalRuntime | AT1130.ClusterProcessors.ClusterProcessorsLocalRuntime;
        type ClusterProcessorsMetadataRuntime = AT1101.ClusterProcessors.ClusterProcessorsMetadataRuntime | AT1130.ClusterProcessors.ClusterProcessorsMetadataRuntime;
        type ClusterProcessorsMipMapsRuntime = AT1101.ClusterProcessors.ClusterProcessorsMipMapsRuntime | AT1130.ClusterProcessors.ClusterProcessorsMipMapsRuntime;
    }
    namespace ClusterSources {
        type ClusterAudioSourceRuntime = AT1101.ClusterSources.ClusterAudioSourceRuntime | AT1130.ClusterSources.ClusterAudioSourceRuntime;
        type ClusterAudioSourceRuntimeLocal = AT1101.ClusterSources.ClusterAudioSourceRuntimeLocal | AT1130.ClusterSources.ClusterAudioSourceRuntimeLocal;
        type ClusterMetadataSourceLocalRuntime = AT1101.ClusterSources.ClusterMetadataSourceLocalRuntime | AT1130.ClusterSources.ClusterMetadataSourceLocalRuntime;
        type ClusterMetadataSourceRuntime = AT1101.ClusterSources.ClusterMetadataSourceRuntime | AT1130.ClusterSources.ClusterMetadataSourceRuntime;
        type ClusterSourcesGlobalRuntime = AT1101.ClusterSources.ClusterSourcesGlobalRuntime | AT1130.ClusterSources.ClusterSourcesGlobalRuntime;
        type ClusterVideoSourceRuntime = AT1101.ClusterSources.ClusterVideoSourceRuntime | AT1130.ClusterSources.ClusterVideoSourceRuntime;
        type ClusterVideoSourceRuntimeLocal = AT1101.ClusterSources.ClusterVideoSourceRuntimeLocal | AT1130.ClusterSources.ClusterVideoSourceRuntimeLocal;
    }
    namespace ColorCorrection {
        type All = AT1101.ColorCorrection.All | AT1130.ColorCorrection.All;
        type CC1D = AT1101.ColorCorrection.CC1D | AT1130.ColorCorrection.CC1D;
        type CC3D = AT1101.ColorCorrection.CC3D | AT1130.ColorCorrection.CC3D;
    }
    namespace Definitions {
        type AudioControl = AT1101.Definitions.AudioControl | AT1130.Definitions.AudioControl;
        type TimecodeInserter = AT1101.Definitions.TimecodeInserter | AT1130.Definitions.TimecodeInserter;
        type TimecodeInserterGenerator = AT1101.Definitions.TimecodeInserterGenerator | AT1130.Definitions.TimecodeInserterGenerator;
        type VancControl = AT1101.Definitions.VancControl | AT1130.Definitions.VancControl;
    }
    namespace EthernetStats {
        type PortStatistics = AT1101.EthernetStats.PortStatistics | AT1130.EthernetStats.PortStatistics;
    }
    namespace Genlock {
        type All = AT1101.Genlock.All | AT1130.Genlock.All;
    }
    namespace IOModule {
        type All = AT1101.IOModule.All | AT1130.IOModule.All;
        type HwStatus = AT1101.IOModule.HwStatus | AT1130.IOModule.HwStatus;
        type HwStatusEye = AT1101.IOModule.HwStatusEye | AT1130.IOModule.HwStatusEye;
        type Input = AT1101.IOModule.Input | AT1130.IOModule.Input;
        type MADIInput = AT1101.IOModule.MADIInput | AT1130.IOModule.MADIInput;
        type Merger = AT1101.IOModule.Merger | AT1130.IOModule.Merger;
        type MergerOutput = AT1101.IOModule.MergerOutput | AT1130.IOModule.MergerOutput;
        type Output = AT1101.IOModule.Output | AT1130.IOModule.Output;
        type SDIInput = AT1101.IOModule.SDIInput | AT1130.IOModule.SDIInput;
        type SDIOutput = AT1101.IOModule.SDIOutput | AT1130.IOModule.SDIOutput;
        type SDIOutputIssues = AT1101.IOModule.SDIOutputIssues | AT1130.IOModule.SDIOutputIssues;
        type SDIPayload = AT1101.IOModule.SDIPayload | AT1130.IOModule.SDIPayload;
        type SyncOutput = AT1101.IOModule.SyncOutput | AT1130.IOModule.SyncOutput;
        type Timing = AT1101.IOModule.Timing | AT1130.IOModule.Timing;
        type TimingAsynchronous = AT1101.IOModule.TimingAsynchronous | AT1130.IOModule.TimingAsynchronous;
        type TimingSynchronousOrSyntonous = AT1101.IOModule.TimingSynchronousOrSyntonous | AT1130.IOModule.TimingSynchronousOrSyntonous;
    }
    namespace J2KDecoder {
        type All = AT1101.J2KDecoder.All | AT1130.J2KDecoder.All;
        type J2KDecoderChannel = AT1101.J2KDecoder.J2KDecoderChannel | AT1130.J2KDecoder.J2KDecoderChannel;
        type J2KDecoderRuntime = AT1101.J2KDecoder.J2KDecoderRuntime | AT1130.J2KDecoder.J2KDecoderRuntime;
        type J2KDecoderVideoRuntime = AT1101.J2KDecoder.J2KDecoderVideoRuntime | AT1130.J2KDecoder.J2KDecoderVideoRuntime;
    }
    namespace MasterClock {
        type All = AT1101.MasterClock.All | AT1130.MasterClock.All;
        type GPSReceiver = AT1101.MasterClock.GPSReceiver | AT1130.MasterClock.GPSReceiver;
        type LTCGenerator = AT1101.MasterClock.LTCGenerator | AT1130.MasterClock.LTCGenerator;
    }
    namespace MetadataProcessor {
        type All = AT1101.MetadataProcessor.All | AT1130.MetadataProcessor.All;
        type MetadataExtractor = AT1101.MetadataProcessor.MetadataExtractor | AT1130.MetadataProcessor.MetadataExtractor;
        type MetadataInserter = AT1101.MetadataProcessor.MetadataInserter | AT1130.MetadataProcessor.MetadataInserter;
        type Request = AT1101.MetadataProcessor.Request | AT1130.MetadataProcessor.Request;
        type Response = AT1101.MetadataProcessor.Response | AT1130.MetadataProcessor.Response;
    }
    namespace Monitoring {
        type All = AT1101.Monitoring.All | AT1130.Monitoring.All;
        type AudioLoudness = AT1101.Monitoring.AudioLoudness | AT1130.Monitoring.AudioLoudness;
        type AudioPhaseCorrelation = AT1101.Monitoring.AudioPhaseCorrelation | AT1130.Monitoring.AudioPhaseCorrelation;
        type LiveView = AT1101.Monitoring.LiveView | AT1130.Monitoring.LiveView;
    }
    namespace MultiviewerIO {
        type All = AT1101.MultiviewerIO.All | AT1130.MultiviewerIO.All;
    }
    namespace NetworkInterfaces {
        type All = AT1101.NetworkInterfaces.All | AT1130.NetworkInterfaces.All;
        type Lane = AT1101.NetworkInterfaces.Lane | AT1130.NetworkInterfaces.Lane;
        type LaneStatistics = AT1101.NetworkInterfaces.LaneStatistics | AT1130.NetworkInterfaces.LaneStatistics;
        type Port = AT1101.NetworkInterfaces.Port | AT1130.NetworkInterfaces.Port;
        type PortMode = AT1101.NetworkInterfaces.PortMode | AT1130.NetworkInterfaces.PortMode;
    }
    namespace PCap {
        type All = AT1101.PCap.All | AT1130.PCap.All;
        type Instance = AT1101.PCap.Instance | AT1130.PCap.Instance;
        type Mode = AT1101.PCap.Mode | AT1130.PCap.Mode;
        type ModeStoreAndForward = AT1101.PCap.ModeStoreAndForward | AT1130.PCap.ModeStoreAndForward;
    }
    namespace PTPClock {
        type All = AT1101.PTPClock.All | AT1130.PTPClock.All;
    }
    namespace PTPFlows {
        type Agent = AT1101.PTPFlows.Agent | AT1130.PTPFlows.Agent;
        type All = AT1101.PTPFlows.All | AT1130.PTPFlows.All;
        type Master = AT1101.PTPFlows.Master | AT1130.PTPFlows.Master;
        type MasterSettings = AT1101.PTPFlows.MasterSettings | AT1130.PTPFlows.MasterSettings;
        type MasterVisibleVia = AT1101.PTPFlows.MasterVisibleVia | AT1130.PTPFlows.MasterVisibleVia;
        type Port = AT1101.PTPFlows.Port | AT1130.PTPFlows.Port;
        type PortBestMasters = AT1101.PTPFlows.PortBestMasters | AT1130.PTPFlows.PortBestMasters;
    }
    namespace Primitives {
        type NetworkPortID = AT1101.Primitives.NetworkPortID | AT1130.Primitives.NetworkPortID;
    }
    namespace RTPReceiver {
        type AffineNetworkSource = AT1101.RTPReceiver.AffineNetworkSource | AT1130.RTPReceiver.AffineNetworkSource;
        type All = AT1101.RTPReceiver.All | AT1130.RTPReceiver.All;
        type AllDiagnostics = AT1101.RTPReceiver.AllDiagnostics | AT1130.RTPReceiver.AllDiagnostics;
        type AllDiagnosticsIgmpPerformanceMetrics = AT1101.RTPReceiver.AllDiagnosticsIgmpPerformanceMetrics | AT1130.RTPReceiver.AllDiagnosticsIgmpPerformanceMetrics;
        type AllDiagnosticsIgmpPerformanceMetricsIgmpLatency = AT1101.RTPReceiver.AllDiagnosticsIgmpPerformanceMetricsIgmpLatency | AT1130.RTPReceiver.AllDiagnosticsIgmpPerformanceMetricsIgmpLatency;
        type AllDiagnosticsRtpInput = AT1101.RTPReceiver.AllDiagnosticsRtpInput | AT1130.RTPReceiver.AllDiagnosticsRtpInput;
        type AllSettings = AT1101.RTPReceiver.AllSettings | AT1130.RTPReceiver.AllSettings;
        type AncBurstReceiver = AT1101.RTPReceiver.AncBurstReceiver | AT1130.RTPReceiver.AncBurstReceiver;
        type AncBurstReceiverMediaClock = AT1101.RTPReceiver.AncBurstReceiverMediaClock | AT1130.RTPReceiver.AncBurstReceiverMediaClock;
        type AssociatedStream = AT1101.RTPReceiver.AssociatedStream | AT1130.RTPReceiver.AssociatedStream;
        type AudioBackend = AT1101.RTPReceiver.AudioBackend | AT1130.RTPReceiver.AudioBackend;
        type AudioCapabilities = AT1101.RTPReceiver.AudioCapabilities | AT1130.RTPReceiver.AudioCapabilities;
        type AudioFlowPartition = AT1101.RTPReceiver.AudioFlowPartition | AT1130.RTPReceiver.AudioFlowPartition;
        type AudioReceiver = AT1101.RTPReceiver.AudioReceiver | AT1130.RTPReceiver.AudioReceiver;
        type AudioReceiverMediaSpecific = AT1101.RTPReceiver.AudioReceiverMediaSpecific | AT1130.RTPReceiver.AudioReceiverMediaSpecific;
        type AudioReceiverMediaSpecificFlowPartitions = AT1101.RTPReceiver.AudioReceiverMediaSpecificFlowPartitions | AT1130.RTPReceiver.AudioReceiverMediaSpecificFlowPartitions;
        type AudioReceiverMediaSpecificOutput = AT1101.RTPReceiver.AudioReceiverMediaSpecificOutput | AT1130.RTPReceiver.AudioReceiverMediaSpecificOutput;
        type AudioServo = AT1101.RTPReceiver.AudioServo | AT1130.RTPReceiver.AudioServo;
        type BufferProfile = AT1101.RTPReceiver.BufferProfile | AT1130.RTPReceiver.BufferProfile;
        type BufferSize = AT1101.RTPReceiver.BufferSize | AT1130.RTPReceiver.BufferSize;
        type BufferSizes = AT1101.RTPReceiver.BufferSizes | AT1130.RTPReceiver.BufferSizes;
        type JpegXsVideoBackend = AT1101.RTPReceiver.JpegXsVideoBackend | AT1130.RTPReceiver.JpegXsVideoBackend;
        type MediaReceiver = AT1101.RTPReceiver.MediaReceiver | AT1130.RTPReceiver.MediaReceiver;
        type MediaReceiverPacketStreams = AT1101.RTPReceiver.MediaReceiverPacketStreams | AT1130.RTPReceiver.MediaReceiverPacketStreams;
        type MetadataBackend = AT1101.RTPReceiver.MetadataBackend | AT1130.RTPReceiver.MetadataBackend;
        type NativeVideoBackend = AT1101.RTPReceiver.NativeVideoBackend | AT1130.RTPReceiver.NativeVideoBackend;
        type NetworkSource = AT1101.RTPReceiver.NetworkSource | AT1130.RTPReceiver.NetworkSource;
        type PacketStream = AT1101.RTPReceiver.PacketStream | AT1130.RTPReceiver.PacketStream;
        type PacketTracer = AT1101.RTPReceiver.PacketTracer | AT1130.RTPReceiver.PacketTracer;
        type PassthroughEssence = AT1101.RTPReceiver.PassthroughEssence | AT1130.RTPReceiver.PassthroughEssence;
        type PassthroughEssenceMemoryBlocks = AT1101.RTPReceiver.PassthroughEssenceMemoryBlocks | AT1130.RTPReceiver.PassthroughEssenceMemoryBlocks;
        type PassthroughFlowPartition = AT1101.RTPReceiver.PassthroughFlowPartition | AT1130.RTPReceiver.PassthroughFlowPartition;
        type PassthroughReceiver = AT1101.RTPReceiver.PassthroughReceiver | AT1130.RTPReceiver.PassthroughReceiver;
        type PassthroughReceiverFlowPartitions = AT1101.RTPReceiver.PassthroughReceiverFlowPartitions | AT1130.RTPReceiver.PassthroughReceiverFlowPartitions;
        type RAMBlock = AT1101.RTPReceiver.RAMBlock | AT1130.RTPReceiver.RAMBlock;
        type RAMChannel = AT1101.RTPReceiver.RAMChannel | AT1130.RTPReceiver.RAMChannel;
        type RAMPseudoChannel = AT1101.RTPReceiver.RAMPseudoChannel | AT1130.RTPReceiver.RAMPseudoChannel;
        type ReadSpeed = AT1101.RTPReceiver.ReadSpeed | AT1130.RTPReceiver.ReadSpeed;
        type ReadSpeedLockToGenlock = AT1101.RTPReceiver.ReadSpeedLockToGenlock | AT1130.RTPReceiver.ReadSpeedLockToGenlock;
        type ReserveAudioBackend = AT1101.RTPReceiver.ReserveAudioBackend | AT1130.RTPReceiver.ReserveAudioBackend;
        type Session = AT1101.RTPReceiver.Session | AT1130.RTPReceiver.Session;
        type Timing = AT1101.RTPReceiver.Timing | AT1130.RTPReceiver.Timing;
        type TimingTarget = AT1101.RTPReceiver.TimingTarget | AT1130.RTPReceiver.TimingTarget;
        type TimingTargetForeignMediaClock = AT1101.RTPReceiver.TimingTargetForeignMediaClock | AT1130.RTPReceiver.TimingTargetForeignMediaClock;
        type TimingTargetForeignReadDelay = AT1101.RTPReceiver.TimingTargetForeignReadDelay | AT1130.RTPReceiver.TimingTargetForeignReadDelay;
        type TimingTargetTimeSource = AT1101.RTPReceiver.TimingTargetTimeSource | AT1130.RTPReceiver.TimingTargetTimeSource;
        type VideoBackend = AT1101.RTPReceiver.VideoBackend | AT1130.RTPReceiver.VideoBackend;
        type VideoCapabilities = AT1101.RTPReceiver.VideoCapabilities | AT1130.RTPReceiver.VideoCapabilities;
        type VideoFlowPartition = AT1101.RTPReceiver.VideoFlowPartition | AT1130.RTPReceiver.VideoFlowPartition;
        type VideoReceiver = AT1101.RTPReceiver.VideoReceiver | AT1130.RTPReceiver.VideoReceiver;
        type VideoReceiverMediaSpecific = AT1101.RTPReceiver.VideoReceiverMediaSpecific | AT1130.RTPReceiver.VideoReceiverMediaSpecific;
        type VideoReceiverMediaSpecificFlowPartitions = AT1101.RTPReceiver.VideoReceiverMediaSpecificFlowPartitions | AT1130.RTPReceiver.VideoReceiverMediaSpecificFlowPartitions;
        type VideoReceiverMediaSpecificOutput = AT1101.RTPReceiver.VideoReceiverMediaSpecificOutput | AT1130.RTPReceiver.VideoReceiverMediaSpecificOutput;
        type VideoServo = AT1101.RTPReceiver.VideoServo | AT1130.RTPReceiver.VideoServo;
    }
    namespace RTPTransmitter {
        type All = AT1101.RTPTransmitter.All | AT1130.RTPTransmitter.All;
        type AudioEncoder = AT1101.RTPTransmitter.AudioEncoder | AT1130.RTPTransmitter.AudioEncoder;
        type AudioEncoderError = AT1101.RTPTransmitter.AudioEncoderError | AT1130.RTPTransmitter.AudioEncoderError;
        type AudioFlowReference = AT1101.RTPTransmitter.AudioFlowReference | AT1130.RTPTransmitter.AudioFlowReference;
        type AudioStreamHardware = AT1101.RTPTransmitter.AudioStreamHardware | AT1130.RTPTransmitter.AudioStreamHardware;
        type AudioStreamHardwareAudioEncoder = AT1101.RTPTransmitter.AudioStreamHardwareAudioEncoder | AT1130.RTPTransmitter.AudioStreamHardwareAudioEncoder;
        type AudioStreamer = AT1101.RTPTransmitter.AudioStreamer | AT1130.RTPTransmitter.AudioStreamer;
        type EncoderHWData = AT1101.RTPTransmitter.EncoderHWData | AT1130.RTPTransmitter.EncoderHWData;
        type EncoderHWDataEncoderClassic = AT1101.RTPTransmitter.EncoderHWDataEncoderClassic | AT1130.RTPTransmitter.EncoderHWDataEncoderClassic;
        type EncoderHWDataEncoderJxsCodec = AT1101.RTPTransmitter.EncoderHWDataEncoderJxsCodec | AT1130.RTPTransmitter.EncoderHWDataEncoderJxsCodec;
        type EncoderHWDataEncoderVC2 = AT1101.RTPTransmitter.EncoderHWDataEncoderVC2 | AT1130.RTPTransmitter.EncoderHWDataEncoderVC2;
        type FlowReference = AT1101.RTPTransmitter.FlowReference | AT1130.RTPTransmitter.FlowReference;
        type HDRAudio = AT1101.RTPTransmitter.HDRAudio | AT1130.RTPTransmitter.HDRAudio;
        type HDRGeneral = AT1101.RTPTransmitter.HDRGeneral | AT1130.RTPTransmitter.HDRGeneral;
        type HDRMipmap = AT1101.RTPTransmitter.HDRMipmap | AT1130.RTPTransmitter.HDRMipmap;
        type HDRVideo = AT1101.RTPTransmitter.HDRVideo | AT1130.RTPTransmitter.HDRVideo;
        type HardwareStatus = AT1101.RTPTransmitter.HardwareStatus | AT1130.RTPTransmitter.HardwareStatus;
        type HeaderReference = AT1101.RTPTransmitter.HeaderReference | AT1130.RTPTransmitter.HeaderReference;
        type LaneHeader = AT1101.RTPTransmitter.LaneHeader | AT1130.RTPTransmitter.LaneHeader;
        type LaneStatistic = AT1101.RTPTransmitter.LaneStatistic | AT1130.RTPTransmitter.LaneStatistic;
        type MediaClock = AT1101.RTPTransmitter.MediaClock | AT1130.RTPTransmitter.MediaClock;
        type MediaClockControl = AT1101.RTPTransmitter.MediaClockControl | AT1130.RTPTransmitter.MediaClockControl;
        type MediaClockControlTimesource = AT1101.RTPTransmitter.MediaClockControlTimesource | AT1130.RTPTransmitter.MediaClockControlTimesource;
        type MediaStreamer = AT1101.RTPTransmitter.MediaStreamer | AT1130.RTPTransmitter.MediaStreamer;
        type MediaStreamerVideo = AT1101.RTPTransmitter.MediaStreamerVideo | AT1130.RTPTransmitter.MediaStreamerVideo;
        type MipMapStreamHardware = AT1101.RTPTransmitter.MipMapStreamHardware | AT1130.RTPTransmitter.MipMapStreamHardware;
        type MipMapStreamHardwareRouterEncoder = AT1101.RTPTransmitter.MipMapStreamHardwareRouterEncoder | AT1130.RTPTransmitter.MipMapStreamHardwareRouterEncoder;
        type MipMapStreamer = AT1101.RTPTransmitter.MipMapStreamer | AT1130.RTPTransmitter.MipMapStreamer;
        type PortStatistic = AT1101.RTPTransmitter.PortStatistic | AT1130.RTPTransmitter.PortStatistic;
        type PortStatisticInterfaces = AT1101.RTPTransmitter.PortStatisticInterfaces | AT1130.RTPTransmitter.PortStatisticInterfaces;
        type ReStreamer = AT1101.RTPTransmitter.ReStreamer | AT1130.RTPTransmitter.ReStreamer;
        type RouterEncoder = AT1101.RTPTransmitter.RouterEncoder | AT1130.RTPTransmitter.RouterEncoder;
        type RouterOutput = AT1101.RTPTransmitter.RouterOutput | AT1130.RTPTransmitter.RouterOutput;
        type RouterOutputHwCapability = AT1101.RTPTransmitter.RouterOutputHwCapability | AT1130.RTPTransmitter.RouterOutputHwCapability;
        type ST2110Settings = AT1101.RTPTransmitter.ST2110Settings | AT1130.RTPTransmitter.ST2110Settings;
        type Session = AT1101.RTPTransmitter.Session | AT1130.RTPTransmitter.Session;
        type VideoConfigurationContainer = AT1101.RTPTransmitter.VideoConfigurationContainer | AT1130.RTPTransmitter.VideoConfigurationContainer;
        type VideoFormat = AT1101.RTPTransmitter.VideoFormat | AT1130.RTPTransmitter.VideoFormat;
        type VideoStreamHardware = AT1101.RTPTransmitter.VideoStreamHardware | AT1130.RTPTransmitter.VideoStreamHardware;
        type VideoStreamHardwareRouterEncoder = AT1101.RTPTransmitter.VideoStreamHardwareRouterEncoder | AT1130.RTPTransmitter.VideoStreamHardwareRouterEncoder;
        type VideoStreamHardwareXbarEncoder = AT1101.RTPTransmitter.VideoStreamHardwareXbarEncoder | AT1130.RTPTransmitter.VideoStreamHardwareXbarEncoder;
        type VideoStreamer = AT1101.RTPTransmitter.VideoStreamer | AT1130.RTPTransmitter.VideoStreamer;
        type XbarEncoder = AT1101.RTPTransmitter.XbarEncoder | AT1130.RTPTransmitter.XbarEncoder;
    }
    namespace RePlay {
        type All = AT1101.RePlay.All | AT1130.RePlay.All;
    }
    namespace SampleRateConverter {
        type AUDIOSRCSTATUS = AT1101.SampleRateConverter.AUDIOSRCSTATUS | AT1130.SampleRateConverter.AUDIOSRCSTATUS;
        type AUDIOSRCSTATUSHwSettings = AT1101.SampleRateConverter.AUDIOSRCSTATUSHwSettings | AT1130.SampleRateConverter.AUDIOSRCSTATUSHwSettings;
        type All = AT1101.SampleRateConverter.All | AT1130.SampleRateConverter.All;
        type INPUTSTATUS = AT1101.SampleRateConverter.INPUTSTATUS | AT1130.SampleRateConverter.INPUTSTATUS;
        type RESOURCE = AT1101.SampleRateConverter.RESOURCE | AT1130.SampleRateConverter.RESOURCE;
        type RESOURCES = AT1101.SampleRateConverter.RESOURCES | AT1130.SampleRateConverter.RESOURCES;
        type SRC = AT1101.SampleRateConverter.SRC | AT1130.SampleRateConverter.SRC;
        type SRCHardware = AT1101.SampleRateConverter.SRCHardware | AT1130.SampleRateConverter.SRCHardware;
        type SRCSettings = AT1101.SampleRateConverter.SRCSettings | AT1130.SampleRateConverter.SRCSettings;
        type Time = AT1101.SampleRateConverter.Time | AT1130.SampleRateConverter.Time;
    }
    namespace Splitter {
        type All = AT1101.Splitter.All | AT1130.Splitter.All;
        type SP = AT1101.Splitter.SP | AT1130.Splitter.SP;
        type SPOutputs = AT1101.Splitter.SPOutputs | AT1130.Splitter.SPOutputs;
    }
    namespace System {
        type All = AT1101.System.All | AT1130.System.All;
        type AllSysinfo = AT1101.System.AllSysinfo | AT1130.System.AllSysinfo;
        type FPGA = AT1101.System.FPGA | AT1130.System.FPGA;
        type FPGASelection = AT1101.System.FPGASelection | AT1130.System.FPGASelection;
        type InternalHW = AT1101.System.InternalHW | AT1130.System.InternalHW;
        type InternalHWIssues = AT1101.System.InternalHWIssues | AT1130.System.InternalHWIssues;
        type MEMORY = AT1101.System.MEMORY | AT1130.System.MEMORY;
        type Partitions = AT1101.System.Partitions | AT1130.System.Partitions;
        type Power = AT1101.System.Power | AT1130.System.Power;
        type Temperature = AT1101.System.Temperature | AT1130.System.Temperature;
        type TemperatureIssues = AT1101.System.TemperatureIssues | AT1130.System.TemperatureIssues;
    }
    namespace SystemClock {
        type All = AT1101.SystemClock.All | AT1130.SystemClock.All;
    }
    namespace Time {
        type AnalogReference = AT1101.Time.AnalogReference | AT1130.Time.AnalogReference;
        type Source = AT1101.Time.Source | AT1130.Time.Source;
    }
    namespace TimeFlows {
        type Aligner = AT1101.TimeFlows.Aligner | AT1130.TimeFlows.Aligner;
        type All = AT1101.TimeFlows.All | AT1130.TimeFlows.All;
        type Combinator = AT1101.TimeFlows.Combinator | AT1130.TimeFlows.Combinator;
        type Detonator = AT1101.TimeFlows.Detonator | AT1130.TimeFlows.Detonator;
        type DriftConverter = AT1101.TimeFlows.DriftConverter | AT1130.TimeFlows.DriftConverter;
        type Impostor = AT1101.TimeFlows.Impostor | AT1130.TimeFlows.Impostor;
        type Selector = AT1101.TimeFlows.Selector | AT1130.TimeFlows.Selector;
        type Shifter = AT1101.TimeFlows.Shifter | AT1130.TimeFlows.Shifter;
        type Stretcher = AT1101.TimeFlows.Stretcher | AT1130.TimeFlows.Stretcher;
    }
    namespace UDX {
        type All = AT1101.UDX.All | AT1130.UDX.All;
        type UDXOutput = AT1101.UDX.UDXOutput | AT1130.UDX.UDXOutput;
    }
    namespace UDXMetadataRequests {
        type All = AT1101.UDXMetadataRequests.All | AT1130.UDXMetadataRequests.All;
    }
    namespace Video {
        type Essence = AT1101.Video.Essence | AT1130.Video.Essence;
        type TimedSource = AT1101.Video.TimedSource | AT1130.Video.TimedSource;
    }
    namespace VideoMixer {
        type All = AT1101.VideoMixer.All | AT1130.VideoMixer.All;
        type BSLK = AT1101.VideoMixer.BSLK | AT1130.VideoMixer.BSLK;
        type BSLKLumaKeyer = AT1101.VideoMixer.BSLKLumaKeyer | AT1130.VideoMixer.BSLKLumaKeyer;
    }
    namespace VideoPlayer {
        type Player = AT1101.VideoPlayer.Player | AT1130.VideoPlayer.Player;
        type PlayerOutput = AT1101.VideoPlayer.PlayerOutput | AT1130.VideoPlayer.PlayerOutput;
        type RelationAudio = AT1101.VideoPlayer.RelationAudio | AT1130.VideoPlayer.RelationAudio;
        type RelationAudioFollowers = AT1101.VideoPlayer.RelationAudioFollowers | AT1130.VideoPlayer.RelationAudioFollowers;
        type RelationVideo = AT1101.VideoPlayer.RelationVideo | AT1130.VideoPlayer.RelationVideo;
        type RelationVideoFollowers = AT1101.VideoPlayer.RelationVideoFollowers | AT1130.VideoPlayer.RelationVideoFollowers;
        type Relations = AT1101.VideoPlayer.Relations | AT1130.VideoPlayer.Relations;
        type Time = AT1101.VideoPlayer.Time | AT1130.VideoPlayer.Time;
    }
    namespace VideoRePlay {
        type Delay = AT1101.VideoRePlay.Delay | AT1130.VideoRePlay.Delay;
        type DelayInputs = AT1101.VideoRePlay.DelayInputs | AT1130.VideoRePlay.DelayInputs;
        type DelayOutput = AT1101.VideoRePlay.DelayOutput | AT1130.VideoRePlay.DelayOutput;
        type Time = AT1101.VideoRePlay.Time | AT1130.VideoRePlay.Time;
        type Video = AT1101.VideoRePlay.Video | AT1130.VideoRePlay.Video;
    }
    namespace VideoSignalGenerator {
        type All = AT1101.VideoSignalGenerator.All | AT1130.VideoSignalGenerator.All;
        type VSG = AT1101.VideoSignalGenerator.VSG | AT1130.VideoSignalGenerator.VSG;
    }
}
