import * as VScript from "vscript";
export * as Audio from "./Audio.js";
export * as AudioMixer from "./AudioMixer.js";
export * as AudioRePlay from "./AudioRePlay.js";
export * as ClosXBar from "./ClosXBar.js";
export * as Cluster from "./Cluster.js";
export * as ClusterMonitoringObjects from "./ClusterMonitoringObjects.js";
export * as ClusterNodes from "./ClusterNodes.js";
export * as ClusterOutputs from "./ClusterOutputs.js";
export * as ClusterProcessors from "./ClusterProcessors.js";
export * as ClusterSources from "./ClusterSources.js";
export * as ColorCorrection from "./ColorCorrection.js";
export * as DataRePlay from "./DataRePlay.js";
export * as Definitions from "./Definitions.js";
export * as EthernetStats from "./EthernetStats.js";
export * as Genlock from "./Genlock.js";
export * as IOModule from "./IOModule.js";
export * as J2KDecoder from "./J2KDecoder.js";
export * as MasterClock from "./MasterClock.js";
export * as Memory from "./Memory.js";
export * as MetadataProcessor from "./MetadataProcessor.js";
export * as Monitoring from "./Monitoring.js";
export * as Multiviewer from "./Multiviewer.js";
export * as MultiviewerIO from "./MultiviewerIO.js";
export * as NetworkInterfaces from "./NetworkInterfaces.js";
export * as PCap from "./PCap.js";
export * as PTP from "./PTP.js";
export * as PTPClock from "./PTPClock.js";
export * as PTPFlows from "./PTPFlows.js";
export * as Primitives from "./Primitives.js";
export * as RTPMetadataChannel from "./RTPMetadataChannel.js";
export * as RTPReceiver from "./RTPReceiver.js";
export * as RTPTransmitter from "./RTPTransmitter.js";
export * as SDP from "./SDP.js";
export * as SampleRateConverter from "./SampleRateConverter.js";
export * as ServicesList from "./ServicesList.js";
export * as Servos from "./Servos.js";
export * as SoftwareUpdate from "./SoftwareUpdate.js";
export * as System from "./System.js";
export * as SystemClock from "./SystemClock.js";
export * as Time from "./Time.js";
export * as TimeFlows from "./TimeFlows.js";
export * as UDX from "./UDX.js";
export * as Video from "./Video.js";
export * as VideoMixer from "./VideoMixer.js";
export * as VideoPlayer from "./VideoPlayer.js";
export * as VideoRePlay from "./VideoRePlay.js";
export * as VideoSignalGenerator from "./VideoSignalGenerator.js";
import * as AT1101 from "./AT1101.js";
export * as AT1101 from "./AT1101.js";
import * as AT1130 from "./AT1130.js";
export * as AT1130 from "./AT1130.js";
export const version = "2.4.20";
export var VM;
(function (VM) {
    function adopt(vsocket) {
        // assuming AT1101 for backwards compatibility if build_info does not specify
        // a hardware model
        switch (vsocket.build_info.hardware_model ?? "AT1101") {
            case "AT1101": return new AT1101.Root(vsocket);
            case "AT1130": return new AT1130.Root(vsocket);
        }
        throw new Error(`Unknown hardware model '${vsocket.build_info.hardware_model}'`);
    }
    VM.adopt = adopt;
    async function open(pars) {
        return adopt(await VScript.VSocket.open(pars));
    }
    VM.open = open;
})(VM || (VM = {}));
