export declare function strip_header(sdp: string): string;
export declare function extract_header(sdp: string): string;
export declare function sdp_is_empty(sdp: string): boolean;
export interface MediaDescription {
    dst: string;
    port: number;
    src: string;
    text: string;
    rtpmap: {
        payload: number;
        type: string;
    };
    fmtp?: string;
    mid?: string;
}
export interface SplitSDP {
    header: string;
    media_descriptions: MediaDescription[];
}
export declare function split_sdp(sdp: string): SplitSDP;
export declare function assemble_sdp(sdp: SplitSDP): string;
export declare function merge_sdps(sdps: string[]): string;
export declare function sprinkle_fmtps(sdp: string): string;
export declare function filter_mid(sdp: string, mid: string): string;
