import * as VScript from "vscript";
import * as VAPI from "./index.js";
import * as AE from "./toplevel/audioengine.js";
import { do_upload_config } from "./toplevel/network_config.js";
import { assemble_config_record } from "./toplevel/network_config.js";
import { split_sdp } from "./toplevel/sdp.js";
export var Audio;
(function (Audio) {
    Audio.lift = {
        Essence: (_raw) => (new Essence(_raw)),
        TimedSource: (_raw, _socket) => {
            return {
                source: _raw[0] === null ? null : new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                switch_time: _raw[1] === null ? null : VScript.VAPIHelpers.liftTimestamp(_raw[1], _socket)
            };
        },
    };
    Audio.lower = {
        Essence: (_x) => _x.raw.kwl,
        TimedSource: (_x, _socket) => [
            _x.source === null ? null : _x.source.raw.kwl,
            _x.switch_time === null ? null : VScript.VAPIHelpers.lowerTimestamp(_x.switch_time, _socket)
        ],
    };
    class Essence {
        raw;
        type_identifier = "Audio::Data::Essence";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get sop_dt_node() {
            return new VScript.rKeyword(this, "sop_dt_node", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get channels() {
            return new VScript.rKeywordReferenceable(this, "channels", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel)),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel))
            });
        }
        /**
          some signal sources, such as RTP audio/video streams, include a
          well-defined offset to the PTP epoch (as seen by the sender). During
          processing, these 'media clocks' may shift (e.g., as signals pass through
          delay elements) or broaden into finite intervals (e.g., as audio channels
          at different offsets to the PTP epoch are combined into a single audio
          essence). Using the `media_clock` keyword, such changes are tracked
          explicitly and forwarded to audio/video transmitters.
        */
        get media_clock() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "media_clock"));
        }
    }
    Audio.Essence = Essence;
})(Audio || (Audio = {}));
export var AudioEngine;
(function (AudioEngine) {
    AudioEngine.lift = {
        All: (_raw) => (new All(_raw)),
        Compressor: (_raw) => (new Compressor(_raw)),
        Delay: (_raw) => (new Delay(_raw)),
        DownMix: (_raw) => (new DownMix(_raw)),
        Filter: (_raw) => (new Filter(_raw)),
        InputTrim: (_raw) => (new InputTrim(_raw)),
        InputTrimInputs: (_raw) => (new InputTrimInputs(_raw)),
        Loudness: (_raw) => (new Loudness(_raw)),
        MidSide: (_raw) => (new MidSide(_raw)),
        MonoMix: (_raw) => (new MonoMix(_raw)),
        NMinus1: (_raw) => (new NMinus1(_raw)),
        StereoMix: (_raw) => (new StereoMix(_raw)),
        TruePeak: (_raw) => (new TruePeak(_raw)),
    };
    AudioEngine.lower = {
        All: (_x) => _x.raw.kwl,
        Compressor: (_x) => _x.raw.kwl,
        Delay: (_x) => _x.raw.kwl,
        DownMix: (_x) => _x.raw.kwl,
        Filter: (_x) => _x.raw.kwl,
        InputTrim: (_x) => _x.raw.kwl,
        InputTrimInputs: (_x) => _x.raw.kwl,
        Loudness: (_x) => _x.raw.kwl,
        MidSide: (_x) => _x.raw.kwl,
        MonoMix: (_x) => _x.raw.kwl,
        NMinus1: (_x) => _x.raw.kwl,
        StereoMix: (_x) => _x.raw.kwl,
        TruePeak: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "AudioEngine::Data::All";
        get runtime_constants() {
            return {
                num_input_stages: this.raw.backing_store.get_runtime_constant("AudioEngine::num_input_stages"),
                max_nminus1_instances: this.raw.backing_store.get_runtime_constant("AudioEngine::max_nminus1_instances"),
                max_mixer_instances: this.raw.backing_store.get_runtime_constant("AudioEngine::max_mixer_instances"),
                max_delay_instances: this.raw.backing_store.get_runtime_constant("AudioEngine::max_delay_instances"),
                num_output_slices: this.raw.backing_store.get_runtime_constant("AudioEngine::num_output_slices"),
                max_loudness_instances: this.raw.backing_store.get_runtime_constant("AudioEngine::max_loudness_instances"),
                max_truepeak_instances: this.raw.backing_store.get_runtime_constant("AudioEngine::max_truepeak_instances"),
                max_inputs_per_stage: this.raw.backing_store.get_runtime_constant("AudioEngine::max_inputs_per_stage"),
                max_compressor_instances: this.raw.backing_store.get_runtime_constant("AudioEngine::max_compressor_instances"),
                max_filter_instances: this.raw.backing_store.get_runtime_constant("AudioEngine::max_filter_instances")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get genlock() {
            return new VScript.dKeyword(this, "genlock", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Genlock.AT1130Genlock(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Genlock.AT1130Genlock(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, (parent, command) => (void parent, void command, { criterion: "status", validator: (status) => command === null || VScript.same(command, status) }));
        }
        get groups() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "groups"), (raw) => new VAPI.AudioEngine.GroupAsNamedTableRow(raw));
        }
        get nminus1() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 2, "nminus1"), (raw) => new VAPI.AT1130.AudioEngine.NMinus1AsNamedTableRow(raw));
        }
        get mono() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 3, "mono"), (raw) => new VAPI.AT1130.AudioEngine.MonoMixAsNamedTableRow(raw));
        }
        get stereo() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 4, "stereo"), (raw) => new VAPI.AT1130.AudioEngine.StereoMixAsNamedTableRow(raw));
        }
        get filter() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 5, "filter"), (raw) => new VAPI.AT1130.AudioEngine.FilterAsNamedTableRow(raw));
        }
        get delay() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 6, "delay"), (raw) => new VAPI.AT1130.AudioEngine.DelayAsNamedTableRow(raw));
        }
        get truepeak() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 7, "truepeak"), (raw) => new VAPI.AT1130.AudioEngine.TruePeakAsNamedTableRow(raw));
        }
        get loudness() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 8, "loudness"), (raw) => new VAPI.AT1130.AudioEngine.LoudnessAsNamedTableRow(raw));
        }
        get compressor() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 9, "compressor"), (raw) => new VAPI.AT1130.AudioEngine.CompressorAsNamedTableRow(raw));
        }
        get downmix() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 10, "downmix"), (raw) => new VAPI.AT1130.AudioEngine.DownMixAsNamedTableRow(raw));
        }
        get midside() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 11, "midside"), (raw) => new VAPI.AT1130.AudioEngine.MidSideAsNamedTableRow(raw));
        }
        get inputtrim() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 12, "inputtrim"), (raw) => new VAPI.AT1130.AudioEngine.InputTrimAsNamedTableRow(raw));
        }
        get info() {
            return new VScript.rKeyword(this, "info", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.Info),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.Info)
            });
        }
        get audio_source_slices() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 14, "audio_source_slices"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
        async create_stereo_mixer(pars) {
            const total_channels = pars.channel_strips.reduce((accu, cs) => accu + cs.count, 0);
            if (total_channels <= 0 || total_channels > 64)
                throw new Error("Invalid channel count - must be between 1 and 64");
            let allocated = [];
            const group = await (async () => {
                if (!pars.group)
                    return null;
                if (typeof pars.group === "string") {
                    const group = await this.groups.create_row({ name: pars.group });
                    allocated.push(() => group.delete());
                    return group;
                }
                return pars.group;
            })();
            try {
                const sum = await this.stereo.create_row({ name: pars.name });
                allocated.push(() => sum.delete());
                await Promise.all([
                    sum.capabilities.command.write({ channels: total_channels, master_fader: true }),
                    sum.group.write(group)
                ]);
                let ch_idx = 0;
                for (let cs of pars.channel_strips) {
                    const channels = cs.capabilities.format == "Stereo" ? 2 : 1;
                    const eq_mode = cs.capabilities.eq ?? "3-Band";
                    for (let idx = 0; idx < cs.count; ++idx) {
                        let src = null;
                        if (cs.capabilities.hpf ?? true) {
                            const hpf = await this.filter.create_row({ name: `${pars.name} HPF ${ch_idx}` });
                            allocated.push(() => hpf.delete());
                            await Promise.all([
                                hpf.capabilities.command.write({ channels, bands: 1 }),
                                hpf.group.write(group)
                            ]);
                            await hpf.bands.row(0).param.write({ variant: "HighPass", value: { fc: 50.0, q: 0.707 } });
                            src = hpf.output;
                        }
                        if (cs.capabilities.gate) {
                            const comp = await this.compressor.create_row({ name: `${pars.name} GATE ${ch_idx}` });
                            allocated.push(() => comp.delete());
                            await Promise.all([
                                comp.capabilities.command.write({ channels, control: { variant: "Input", value: { bandpass: false } }, lookahead: false }),
                                comp.group.write(group),
                                comp.curve.write({ variant: "Gate", value: { threshold: -30.0, width: 3.0 } }),
                                comp.params.write({
                                    attack: { variant: "Time", value: { time: new VScript.Duration(10, "ms") } },
                                    release: { variant: "Time", value: { time: new VScript.Duration(50, "ms") } },
                                    hold: { variant: "Time", value: { time: new VScript.Duration(5, "ms") } },
                                    gain: 0.0
                                }),
                                comp.set_input(src, { channels })
                            ]);
                            src = comp.output;
                        }
                        if (cs.capabilities.compressor ?? true) {
                            const comp = await this.compressor.create_row({ name: `${pars.name} COMP ${ch_idx}` });
                            allocated.push(() => comp.delete());
                            await Promise.all([
                                comp.capabilities.command.write({ channels, control: { variant: "Input", value: { bandpass: false } }, lookahead: false }),
                                comp.group.write(group),
                                comp.curve.write({ variant: "SoftKnee", value: { threshold: 0.0, width: 3.0, ratio: 4.0 } }),
                                comp.params.write({
                                    attack: { variant: "Time", value: { time: new VScript.Duration(30, "ms") } },
                                    release: { variant: "Time", value: { time: new VScript.Duration(30, "ms") } },
                                    hold: { variant: "Time", value: { time: new VScript.Duration(0, "ms") } },
                                    gain: 0.0
                                }),
                                comp.set_input(src, { channels })
                            ]);
                            src = comp.output;
                        }
                        if (eq_mode != "None") {
                            const eq = await this.filter.create_row({ name: `${pars.name} EQ ${ch_idx}` });
                            allocated.push(() => eq.delete());
                            const bands = (() => {
                                switch (eq_mode) {
                                    case "3-Band": return [
                                        { variant: "LowShelf", value: { fc: 150.0, gain: 0.0 } },
                                        { variant: "Peak", value: { fc: 2000.0, q: 0.3, gain: 0.0 } },
                                        { variant: "HighShelf", value: { fc: 4000.0, gain: 0.0 } }
                                    ];
                                    case "4-Band": return [
                                        { variant: "LowShelf", value: { fc: 150.0, gain: 0.0 } },
                                        { variant: "Peak", value: { fc: 1000.0, q: 0.707, gain: 0.0 } },
                                        { variant: "Peak", value: { fc: 2000.0, q: 0.707, gain: 0.0 } },
                                        { variant: "HighShelf", value: { fc: 4000.0, gain: 0.0 } }
                                    ];
                                }
                            })();
                            await Promise.all([
                                eq.capabilities.command.write({ channels, bands: bands.length }),
                                eq.group.write(group),
                                eq.set_input(src, { channels })
                            ]);
                            await Promise.all(bands.map((p, idx) => eq.bands.row(idx).param.write(p)));
                            src = eq.output;
                        }
                        if (src) {
                            let update_inputs = {};
                            update_inputs[ch_idx] = (channels == 2)
                                ? [src.channels.reference_to_index(0), src.channels.reference_to_index(1)]
                                : [src.channels.reference_to_index(0), null];
                            let update_pan = {};
                            update_pan[ch_idx] = (channels == 2)
                                ? { "variant": "BalanceCenterLinear", value: { balance: 0.0 } }
                                : { "variant": "PanConstantPower", value: { pan: 0.0 } };
                            await Promise.all([
                                sum.inputs.write(update_inputs),
                                sum.pan.write(update_pan)
                            ]);
                            ch_idx++;
                        }
                    }
                }
                return sum;
            }
            catch (error) {
                await Promise.all(allocated.map(cb => cb()));
                throw error;
            }
        }
        find_audio_source(dst) {
            const kwl = dst.enclosing_subtree.raw.kwl;
            function extract_index(kwl, table_kwl, capacity) {
                const prefix = `${table_kwl}[`;
                if (kwl.startsWith(prefix)) {
                    const end = kwl.indexOf("]", prefix.length);
                    if (end > 0) {
                        const idx = parseInt(kwl.substring(prefix.length, end));
                        if (!isNaN(idx) && idx >= 0 && idx < capacity)
                            return idx;
                    }
                }
                return null;
            }
            function check(tables) {
                for (const table of tables) {
                    if (table) {
                        const idx = extract_index(kwl, table.raw.kwl, table.capacity());
                        if (idx !== null)
                            return table.row(idx);
                    }
                }
                return null;
            }
            const obj = check([this.nminus1, this.mono, this.stereo, this.filter, this.delay, this.compressor]);
            if (obj) {
                if (obj instanceof VAPI.AT1130.AudioEngine.NMinus1AsNamedTableRow) {
                    const out_idx = extract_index(dst.enclosing_subtree.raw.kwl, obj.output.raw.kwl, obj.output.raw.description.capacity);
                    if (out_idx) {
                        return { src: obj, ch: out_idx * 64 + dst.index };
                    }
                }
                return { src: obj, ch: dst.index };
            }
            return null;
        }
    }
    AudioEngine.All = All;
    class Compressor {
        raw;
        type_identifier = "AudioEngine::Data::Compressor";
        constructor(raw) {
            this.raw = raw;
        }
        get group() {
            return new VScript.rwKeyword(this, "group", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.CompressorCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.CompressorCapabilities)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.CompressorCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.CompressorCapabilities)
            }, null);
        }
        get inputs() {
            return new VScript.rwKeyword(this, "inputs", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get hw_inputs() {
            return new VScript.rKeyword(this, "hw_inputs", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.HWInputAssignment),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AudioEngine.lower.HWInputAssignment)
            });
        }
        get control() {
            return new VScript.rwKeyword(this, "control", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.CompressorSource(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.CompressorSource(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    bandpass_unavailable_capabilities: (x & 1) !== 0,
                    bandpass_unavailable_sidechain: (x & 2) !== 0,
                    control_missing: (x & 4) !== 0,
                    curve_update_delayed: (x & 8) !== 0,
                    cycle_detected: (x & 16) !== 0,
                    invalid_input_channel: (x & 32) !== 0,
                    lookahead_not_available: (x & 64) !== 0
                }),
                lower: (x, _) => ((x.bandpass_unavailable_capabilities ? 1 : 0) |
                    (x.bandpass_unavailable_sidechain ? 2 : 0) |
                    (x.control_missing ? 4 : 0) |
                    (x.curve_update_delayed ? 8 : 0) |
                    (x.cycle_detected ? 16 : 0) |
                    (x.invalid_input_channel ? 32 : 0) |
                    (x.lookahead_not_available ? 64 : 0))
            });
        }
        get curve() {
            return new VScript.rwKeyword(this, "curve", {
                lift: VAPI.AudioEngine.lift.CompressorCurve,
                lower: VAPI.AudioEngine.lower.CompressorCurve
            }, {
                lift: VAPI.AudioEngine.lift.CompressorCurve,
                lower: VAPI.AudioEngine.lower.CompressorCurve
            }, null);
        }
        get curve_points() {
            return new VScript.rKeyword(this, "curve_points", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.CompressorCurvePoint),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AudioEngine.lower.CompressorCurvePoint)
            });
        }
        get params() {
            return new VScript.rwKeyword(this, "params", {
                lift: VAPI.AudioEngine.lift.CompressorParameter,
                lower: VAPI.AudioEngine.lower.CompressorParameter
            }, {
                lift: VAPI.AudioEngine.lift.CompressorParameter,
                lower: VAPI.AudioEngine.lower.CompressorParameter
            }, null);
        }
        get bandpass() {
            return new VScript.rwKeyword(this, "bandpass", {
                lift: VAPI.AudioEngine.lift.CompressorBandpass,
                lower: VAPI.AudioEngine.lower.CompressorBandpass
            }, {
                lift: VAPI.AudioEngine.lift.CompressorBandpass,
                lower: VAPI.AudioEngine.lower.CompressorBandpass
            }, null);
        }
        get lookahead() {
            return new VScript.rwKeyword(this, "lookahead", {
                lift: VAPI.AudioEngine.lift.CompressorLookahead,
                lower: VAPI.AudioEngine.lower.CompressorLookahead
            }, {
                lift: VAPI.AudioEngine.lift.CompressorLookahead,
                lower: VAPI.AudioEngine.lower.CompressorLookahead
            }, null);
        }
        get current_gain() {
            return new VScript.rKeyword(this, "current_gain", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 12, "output"));
        }
        async set_input(src, pars) {
            return AE.set_input(this, src, pars);
        }
    }
    AudioEngine.Compressor = Compressor;
    class CompressorAsNamedTableRow extends Compressor {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioEngine.CompressorAsNamedTableRow = CompressorAsNamedTableRow;
    class Delay {
        raw;
        type_identifier = "AudioEngine::Data::Delay";
        constructor(raw) {
            this.raw = raw;
        }
        get group() {
            return new VScript.rwKeyword(this, "group", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.DelayCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.DelayCapabilities)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.DelayCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.DelayCapabilities)
            }, null);
        }
        get inputs() {
            return new VScript.rwKeyword(this, "inputs", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get hw_inputs() {
            return new VScript.rKeyword(this, "hw_inputs", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.HWInputAssignment),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AudioEngine.lower.HWInputAssignment)
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cycle_detected: (x & 1) !== 0,
                    invalid_input_channel: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.cycle_detected ? 1 : 0) |
                    (x.invalid_input_channel ? 2 : 0))
            });
        }
        get delay() {
            return new VScript.rwKeyword(this, "delay", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.DelayParameter),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VAPI.AudioEngine.lower.DelayParameter)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.DelayParameter),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VAPI.AudioEngine.lower.DelayParameter)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "output"));
        }
        async set_input(src, pars) {
            return AE.set_input(this, src, pars);
        }
    }
    AudioEngine.Delay = Delay;
    class DelayAsNamedTableRow extends Delay {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioEngine.DelayAsNamedTableRow = DelayAsNamedTableRow;
    class DownMix {
        raw;
        type_identifier = "AudioEngine::Data::DownMix";
        constructor(raw) {
            this.raw = raw;
        }
        get group() {
            return new VScript.rwKeyword(this, "group", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.DownMixCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.DownMixCapabilities)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.DownMixCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.DownMixCapabilities)
            }, null);
        }
        /**
          Channel order:
          
          0: Left
          
          1: Right
          
          2: Center
          
          3: LFE
          
          4: Surround Left
          
          5: Surround Right
          
          6: Surround Back Left
          
          7: Surround Back Right
          
          8: Top Left
          
          9: Top Right
          
          10: Top Back Left
          
          11: Top Back Right
        */
        get inputs() {
            return new VScript.rwKeyword(this, "inputs", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get hw_inputs() {
            return new VScript.rKeyword(this, "hw_inputs", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.HWInputAssignment),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AudioEngine.lower.HWInputAssignment)
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cycle_detected: (x & 1) !== 0,
                    invalid_input_channel: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.cycle_detected ? 1 : 0) |
                    (x.invalid_input_channel ? 2 : 0))
            });
        }
        get levels() {
            return new VScript.rwKeyword(this, "levels", {
                lift: VAPI.AudioEngine.lift.DownMixLevels,
                lower: VAPI.AudioEngine.lower.DownMixLevels
            }, {
                lift: VAPI.AudioEngine.lift.DownMixLevels,
                lower: VAPI.AudioEngine.lower.DownMixLevels
            }, null);
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "output"));
        }
        async set_input(src, pars) {
            return AE.set_input(this, src, pars);
        }
    }
    AudioEngine.DownMix = DownMix;
    class DownMixAsNamedTableRow extends DownMix {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioEngine.DownMixAsNamedTableRow = DownMixAsNamedTableRow;
    class Filter {
        raw;
        type_identifier = "AudioEngine::Data::Filter";
        constructor(raw) {
            this.raw = raw;
        }
        get group() {
            return new VScript.rwKeyword(this, "group", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.FilterCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.FilterCapabilities)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.FilterCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.FilterCapabilities)
            }, null);
        }
        get inputs() {
            return new VScript.rwKeyword(this, "inputs", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get hw_inputs() {
            return new VScript.rKeyword(this, "hw_inputs", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.HWInputAssignment),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AudioEngine.lower.HWInputAssignment)
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cycle_detected: (x & 1) !== 0,
                    invalid_input_channel: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.cycle_detected ? 1 : 0) |
                    (x.invalid_input_channel ? 2 : 0))
            });
        }
        get bands() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 5, "bands"), (raw, _) => VAPI.AudioEngine.lift.FilterBands(raw));
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "output"));
        }
        async set_input(src, pars) {
            return AE.set_input(this, src, pars);
        }
    }
    AudioEngine.Filter = Filter;
    class FilterAsNamedTableRow extends Filter {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioEngine.FilterAsNamedTableRow = FilterAsNamedTableRow;
    class InputTrim {
        raw;
        type_identifier = "AudioEngine::Data::InputTrim";
        constructor(raw) {
            this.raw = raw;
        }
        get group() {
            return new VScript.rwKeyword(this, "group", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.InputTrimCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.InputTrimCapabilities)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.InputTrimCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.InputTrimCapabilities)
            }, null);
        }
        get a() {
            return VAPI.AT1130.AudioEngine.lift.InputTrimInputs(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "a"));
        }
        get b() {
            return VAPI.AT1130.AudioEngine.lift.InputTrimInputs(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "b"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cycle_detected: (x & 1) !== 0,
                    invalid_input_channel: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.cycle_detected ? 1 : 0) |
                    (x.invalid_input_channel ? 2 : 0))
            });
        }
        get src() {
            return new VScript.rwKeyword(this, "src", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get peak_meter() {
            return new VScript.rKeyword(this, "peak_meter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "output"));
        }
        async set_input(inp, src, pars) {
            switch (inp) {
                case "A":
                    return AE.set_input(this.a, src, pars);
                case "B":
                    return AE.set_input(this.b, src, pars);
            }
        }
    }
    AudioEngine.InputTrim = InputTrim;
    class InputTrimAsNamedTableRow extends InputTrim {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioEngine.InputTrimAsNamedTableRow = InputTrimAsNamedTableRow;
    class InputTrimInputs {
        raw;
        type_identifier = "AudioEngine::Data::InputTrimInputs";
        constructor(raw) {
            this.raw = raw;
        }
        get inputs() {
            return new VScript.rwKeyword(this, "inputs", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get hw_inputs() {
            return new VScript.rKeyword(this, "hw_inputs", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.HWInputAssignment),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AudioEngine.lower.HWInputAssignment)
            });
        }
        get gain() {
            return new VScript.rwKeyword(this, "gain", {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get master() {
            return new VScript.rwKeyword(this, "master", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    AudioEngine.InputTrimInputs = InputTrimInputs;
    class Loudness {
        raw;
        type_identifier = "AudioEngine::Data::Loudness";
        constructor(raw) {
            this.raw = raw;
        }
        get group() {
            return new VScript.rwKeyword(this, "group", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.LoudnessCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.LoudnessCapabilities)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.LoudnessCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.LoudnessCapabilities)
            }, (parent, command) => (void parent, void command, { criterion: "status", validator: (status) => (command !== null && status === null && command.front_channels == 0 && command.surround_channels == 0) || (command !== null && status !== null && command.front_channels == status.front_channels && command.surround_channels == status.surround_channels && command.k_weighting == status.k_weighting) }));
        }
        get inputs() {
            return new VScript.rwKeyword(this, "inputs", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get hw_inputs() {
            return new VScript.rKeyword(this, "hw_inputs", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.HWInputAssignment),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AudioEngine.lower.HWInputAssignment)
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cant_disable_k_weighting: (x & 1) !== 0,
                    cycle_detected: (x & 2) !== 0,
                    invalid_input_channel: (x & 4) !== 0
                }),
                lower: (x, _) => ((x.cant_disable_k_weighting ? 1 : 0) |
                    (x.cycle_detected ? 2 : 0) |
                    (x.invalid_input_channel ? 4 : 0))
            });
        }
        get measurement() {
            return new VScript.rKeyword(this, "measurement", {
                lift: VAPI.AudioEngine.lift.LoudnessMeasurement,
                lower: VAPI.AudioEngine.lower.LoudnessMeasurement
            });
        }
        get active() {
            return new VScript.rwKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Reset
        */
        get reset() {
            return new VScript.wKeyword(this, "reset", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get compressor_control() {
            return VAPI.AudioEngine.lift.CompressorSource(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "compressor_control"));
        }
        async set_input(src, pars) {
            return AE.set_input(this, src, pars);
        }
    }
    AudioEngine.Loudness = Loudness;
    class LoudnessAsNamedTableRow extends Loudness {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioEngine.LoudnessAsNamedTableRow = LoudnessAsNamedTableRow;
    class MidSide {
        raw;
        type_identifier = "AudioEngine::Data::MidSide";
        constructor(raw) {
            this.raw = raw;
        }
        get group() {
            return new VScript.rwKeyword(this, "group", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.MidSideCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.MidSideCapabilities)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.MidSideCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.MidSideCapabilities)
            }, null);
        }
        get inputs() {
            return new VScript.rwKeyword(this, "inputs", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get hw_inputs() {
            return new VScript.rKeyword(this, "hw_inputs", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.HWInputAssignment),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AudioEngine.lower.HWInputAssignment)
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cycle_detected: (x & 1) !== 0,
                    invalid_input_channel: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.cycle_detected ? 1 : 0) |
                    (x.invalid_input_channel ? 2 : 0))
            });
        }
        get params() {
            return new VScript.rwKeyword(this, "params", {
                lift: VAPI.AudioEngine.lift.MidSideParams,
                lower: VAPI.AudioEngine.lower.MidSideParams
            }, {
                lift: VAPI.AudioEngine.lift.MidSideParams,
                lower: VAPI.AudioEngine.lower.MidSideParams
            }, null);
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "output"));
        }
        async set_input(src, pars) {
            return AE.set_input(this, src, pars);
        }
    }
    AudioEngine.MidSide = MidSide;
    class MidSideAsNamedTableRow extends MidSide {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioEngine.MidSideAsNamedTableRow = MidSideAsNamedTableRow;
    class MonoMix {
        raw;
        type_identifier = "AudioEngine::Data::MonoMix";
        constructor(raw) {
            this.raw = raw;
        }
        get group() {
            return new VScript.rwKeyword(this, "group", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.MonoMixCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.MonoMixCapabilities)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.MonoMixCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.MonoMixCapabilities)
            }, null);
        }
        get inputs() {
            return new VScript.rwKeyword(this, "inputs", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get hw_inputs() {
            return new VScript.rKeyword(this, "hw_inputs", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.HWInputAssignment),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AudioEngine.lower.HWInputAssignment)
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cycle_detected: (x & 1) !== 0,
                    invalid_input_channel: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.cycle_detected ? 1 : 0) |
                    (x.invalid_input_channel ? 2 : 0))
            });
        }
        get peak_meter() {
            return new VScript.rKeyword(this, "peak_meter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get faders() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 7, "faders"), (raw, _) => VAPI.AudioEngine.lift.Fader(raw));
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "output"));
        }
    }
    AudioEngine.MonoMix = MonoMix;
    class MonoMixAsNamedTableRow extends MonoMix {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioEngine.MonoMixAsNamedTableRow = MonoMixAsNamedTableRow;
    class NMinus1 {
        raw;
        type_identifier = "AudioEngine::Data::NMinus1";
        constructor(raw) {
            this.raw = raw;
        }
        get group() {
            return new VScript.rwKeyword(this, "group", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.NMinus1Capabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.NMinus1Capabilities)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.NMinus1Capabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.NMinus1Capabilities)
            }, null);
        }
        get inputs() {
            return new VScript.rwKeyword(this, "inputs", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get hw_inputs() {
            return new VScript.rKeyword(this, "hw_inputs", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.HWInputAssignment),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AudioEngine.lower.HWInputAssignment)
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cycle_detected: (x & 1) !== 0,
                    invalid_input_channel: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.cycle_detected ? 1 : 0) |
                    (x.invalid_input_channel ? 2 : 0))
            });
        }
        get faders() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 6, "faders"), (raw, _) => VAPI.AudioEngine.lift.Fader(raw));
        }
        get output() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 7, "output"), (raw, _) => VAPI.AT1130.Audio.lift.Essence(raw));
        }
    }
    AudioEngine.NMinus1 = NMinus1;
    class NMinus1AsNamedTableRow extends NMinus1 {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioEngine.NMinus1AsNamedTableRow = NMinus1AsNamedTableRow;
    class StereoMix {
        raw;
        type_identifier = "AudioEngine::Data::StereoMix";
        constructor(raw) {
            this.raw = raw;
        }
        get group() {
            return new VScript.rwKeyword(this, "group", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.StereoMixCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.StereoMixCapabilities)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.StereoMixCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.StereoMixCapabilities)
            }, null);
        }
        get inputs() {
            return new VScript.rwKeyword(this, "inputs", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                })))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference())))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                })))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference())))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get hw_inputs() {
            return new VScript.rKeyword(this, "hw_inputs", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.HWInputAssignment)),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.lowerArray(VAPI.AudioEngine.lower.HWInputAssignment))
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cycle_detected: (x & 1) !== 0,
                    invalid_input_channel: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.cycle_detected ? 1 : 0) |
                    (x.invalid_input_channel ? 2 : 0))
            });
        }
        get peak_meter() {
            return new VScript.rKeyword(this, "peak_meter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get faders() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 7, "faders"), (raw, _) => VAPI.AudioEngine.lift.Fader(raw));
        }
        get pan() {
            return new VScript.rwKeyword(this, "pan", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.StereoPanBalance),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VAPI.AudioEngine.lower.StereoPanBalance)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.StereoPanBalance),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VAPI.AudioEngine.lower.StereoPanBalance)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 9, "output"));
        }
        async set_input(input, sources) {
            const channels = sources.length;
            if (channels < 1 || channels > 2)
                throw new Error("Invalid number of sources - must be either 1 or 2");
            const vm = VAPI.VM.adopt(this.raw.backing_store);
            const ae = vm.audio_engine;
            function check_multi(dst) {
                if (!dst[0])
                    return null;
                if (channels == 1 && dst[1] !== null)
                    return null;
                const tmp = dst.map(e => e ? ae.find_audio_source(e) : null);
                if (!tmp[0])
                    return null;
                if (channels == 1 || (tmp[1] && VScript.same(tmp[0].src, tmp[1].src))) {
                    return { src: tmp[0].src, ch: tmp.slice(0, channels).map(e => e.ch) };
                }
                return null;
            }
            const group = await this.group.read();
            async function check_inp(e) {
                if (e.src instanceof VAPI.AT1130.AudioEngine.FilterAsNamedTableRow ||
                    e.src instanceof VAPI.AT1130.AudioEngine.CompressorAsNamedTableRow) {
                    if (group) {
                        if (!VScript.same(await e.src.group.read(), group))
                            return false;
                    }
                    const src = check_multi((await e.src.inputs.read()).slice(0, 2));
                    if (src && await check_inp(src))
                        return true;
                    e.src.set_input(sources);
                    return true;
                }
                else
                    return false;
            }
            const src = check_multi((await this.inputs.read())[input]);
            if (!src || !await check_inp(src)) {
                let sparse_update = {};
                sparse_update[input] = channels >= 2
                    ? [sources[0], sources[1]]
                    : [sources[0], null];
                await this.inputs.write(sparse_update);
            }
        }
    }
    AudioEngine.StereoMix = StereoMix;
    class StereoMixAsNamedTableRow extends StereoMix {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioEngine.StereoMixAsNamedTableRow = StereoMixAsNamedTableRow;
    class TruePeak {
        raw;
        type_identifier = "AudioEngine::Data::TruePeak";
        constructor(raw) {
            this.raw = raw;
        }
        get group() {
            return new VScript.rwKeyword(this, "group", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AudioEngine.Group(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.TruePeakCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.TruePeakCapabilities)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lift.TruePeakCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioEngine.lower.TruePeakCapabilities)
            }, null);
        }
        get inputs() {
            return new VScript.rwKeyword(this, "inputs", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get hw_inputs() {
            return new VScript.rKeyword(this, "hw_inputs", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AudioEngine.lift.HWInputAssignment),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AudioEngine.lower.HWInputAssignment)
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cycle_detected: (x & 1) !== 0,
                    invalid_input_channel: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.cycle_detected ? 1 : 0) |
                    (x.invalid_input_channel ? 2 : 0))
            });
        }
        get peak_meter() {
            return new VScript.rKeyword(this, "peak_meter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get peak_hold() {
            return new VScript.rKeyword(this, "peak_hold", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get peak_hold_time() {
            return new VScript.rwKeyword(this, "peak_hold_time", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            }, null);
        }
        /**
          Reset
        */
        get reset() {
            return new VScript.wKeyword(this, "reset", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get compressor_control() {
            return VAPI.AudioEngine.lift.CompressorSource(VScript.VAPIHelpers.subtree_child_checked(this.raw, 9, "compressor_control"));
        }
        async set_input(src, pars) {
            return AE.set_input(this, src, pars);
        }
    }
    AudioEngine.TruePeak = TruePeak;
    class TruePeakAsNamedTableRow extends TruePeak {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioEngine.TruePeakAsNamedTableRow = TruePeakAsNamedTableRow;
})(AudioEngine || (AudioEngine = {}));
export var AudioGain;
(function (AudioGain) {
    AudioGain.lift = {
        All: (_raw) => (new All(_raw)),
        Levels: (_raw) => (new Levels(_raw)),
    };
    AudioGain.lower = {
        All: (_x) => _x.raw.kwl,
        Levels: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "AudioGain::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get instances() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "instances"), (raw) => new VAPI.AT1130.AudioGain.LevelsAsNamedTableRow(raw));
        }
    }
    AudioGain.All = All;
    class Levels {
        raw;
        type_identifier = "AudioGain::Data::Levels";
        constructor(raw) {
            this.raw = raw;
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get levels() {
            return new VScript.rwKeyword(this, "levels", {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "output"));
        }
    }
    AudioGain.Levels = Levels;
    class LevelsAsNamedTableRow extends Levels {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioGain.LevelsAsNamedTableRow = LevelsAsNamedTableRow;
})(AudioGain || (AudioGain = {}));
export var AudioMixer;
(function (AudioMixer) {
    AudioMixer.lift = {
        All: (_raw) => (new All(_raw)),
        ChannelMono: (_raw) => (new ChannelMono(_raw)),
        ChannelSelection: (_raw) => (new ChannelSelection(_raw)),
        ChannelStereo: (_raw) => (new ChannelStereo(_raw)),
        Downmixes: (_raw) => (new Downmixes(_raw)),
        Mode51: (_raw) => (new Mode51(_raw)),
        Mode71: (_raw) => (new Mode71(_raw)),
        Monos: (_raw) => (new Monos(_raw)),
        Source: (_raw) => (new Source(_raw)),
        SourceStereo: (_raw) => (new SourceStereo(_raw)),
        Stereos: (_raw) => (new Stereos(_raw)),
        StereosOutput: (_raw) => (new StereosOutput(_raw)),
    };
    AudioMixer.lower = {
        All: (_x) => _x.raw.kwl,
        ChannelMono: (_x) => _x.raw.kwl,
        ChannelSelection: (_x) => _x.raw.kwl,
        ChannelStereo: (_x) => _x.raw.kwl,
        Downmixes: (_x) => _x.raw.kwl,
        Mode51: (_x) => _x.raw.kwl,
        Mode71: (_x) => _x.raw.kwl,
        Monos: (_x) => _x.raw.kwl,
        Source: (_x) => _x.raw.kwl,
        SourceStereo: (_x) => _x.raw.kwl,
        Stereos: (_x) => _x.raw.kwl,
        StereosOutput: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "AudioMixer::Data::All";
        get runtime_constants() {
            return {
                num_audio_mixer_fader: this.raw.backing_store.get_runtime_constant("AudioMixer::num_audio_mixer_fader"),
                num_audio_mixer_outputs: this.raw.backing_store.get_runtime_constant("AudioMixer::num_audio_mixer_outputs")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        /**
          @brief Defragment
          @desc Repeated allocation and deallocation of differently sized mixers
          can cause fader fragmentation. Press this button to defragment, but
          please note that _this will temporarily interrupt all outputs currently
          in use_.
        */
        get reorder_output() {
            return new VScript.wKeyword(this, "reorder_output", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get mono_mixes() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "mono_mixes"), (raw) => new VAPI.AT1130.AudioMixer.MonosAsNamedTableRow(raw));
        }
        get stereo_mixes() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 2, "stereo_mixes"), (raw) => new VAPI.AT1130.AudioMixer.StereosAsNamedTableRow(raw));
        }
        get down_mixes() {
            return VAPI.AT1130.AudioMixer.lift.Downmixes(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "down_mixes"));
        }
        get resource_status() {
            return VAPI.AudioMixer.lift.ResourceStatus(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "resource_status"));
        }
        get audio_source_slices() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 5, "audio_source_slices"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
    }
    AudioMixer.All = All;
    class ChannelMono {
        raw;
        type_identifier = "AudioMixer::Data::ChannelMono";
        constructor(raw) {
            this.raw = raw;
        }
        get gain() {
            return new VScript.rwKeyword(this, "gain", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get mute() {
            return new VScript.rwKeyword(this, "mute", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get pan() {
            return new VScript.rwKeyword(this, "pan", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get source() {
            return VAPI.AT1130.AudioMixer.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "source"));
        }
    }
    AudioMixer.ChannelMono = ChannelMono;
    class ChannelMonoAsNamedTableRow extends ChannelMono {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioMixer.ChannelMonoAsNamedTableRow = ChannelMonoAsNamedTableRow;
    class ChannelSelection {
        raw;
        type_identifier = "AudioMixer::Data::ChannelSelection";
        constructor(raw) {
            this.raw = raw;
        }
        get gain() {
            return new VScript.rwKeyword(this, "gain", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get mute() {
            return new VScript.rwKeyword(this, "mute", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get source() {
            return VAPI.AT1130.AudioMixer.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "source"));
        }
    }
    AudioMixer.ChannelSelection = ChannelSelection;
    class ChannelSelectionAsNamedTableRow extends ChannelSelection {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioMixer.ChannelSelectionAsNamedTableRow = ChannelSelectionAsNamedTableRow;
    class ChannelStereo {
        raw;
        type_identifier = "AudioMixer::Data::ChannelStereo";
        constructor(raw) {
            this.raw = raw;
        }
        get gain() {
            return new VScript.rwKeyword(this, "gain", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get mute() {
            return new VScript.rwKeyword(this, "mute", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get balance() {
            return new VScript.rwKeyword(this, "balance", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get source() {
            return VAPI.AT1130.AudioMixer.lift.SourceStereo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "source"));
        }
    }
    AudioMixer.ChannelStereo = ChannelStereo;
    class ChannelStereoAsNamedTableRow extends ChannelStereo {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioMixer.ChannelStereoAsNamedTableRow = ChannelStereoAsNamedTableRow;
    class Downmixes {
        raw;
        type_identifier = "AudioMixer::Data::Downmixes";
        constructor(raw) {
            this.raw = raw;
        }
        get mode_5_1() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "mode_5_1"), (raw) => new VAPI.AT1130.AudioMixer.Mode51AsNamedTableRow(raw));
        }
        get mode_7_1() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "mode_7_1"), (raw) => new VAPI.AT1130.AudioMixer.Mode71AsNamedTableRow(raw));
        }
    }
    AudioMixer.Downmixes = Downmixes;
    class Mode51 {
        raw;
        type_identifier = "AudioMixer::Data::Mode51";
        constructor(raw) {
            this.raw = raw;
        }
        get front_left() {
            return VAPI.AT1130.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "front_left"));
        }
        get front_right() {
            return VAPI.AT1130.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "front_right"));
        }
        get center() {
            return VAPI.AT1130.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "center"));
        }
        get lfe() {
            return VAPI.AT1130.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "lfe"));
        }
        get rear_surround_left() {
            return VAPI.AT1130.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "rear_surround_left"));
        }
        get rear_surround_right() {
            return VAPI.AT1130.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "rear_surround_right"));
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "output"));
        }
    }
    AudioMixer.Mode51 = Mode51;
    class Mode51AsNamedTableRow extends Mode51 {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioMixer.Mode51AsNamedTableRow = Mode51AsNamedTableRow;
    class Mode71 {
        raw;
        type_identifier = "AudioMixer::Data::Mode71";
        constructor(raw) {
            this.raw = raw;
        }
        get front_left() {
            return VAPI.AT1130.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "front_left"));
        }
        get front_right() {
            return VAPI.AT1130.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "front_right"));
        }
        get center() {
            return VAPI.AT1130.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "center"));
        }
        get surround_left() {
            return VAPI.AT1130.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "surround_left"));
        }
        get surround_right() {
            return VAPI.AT1130.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "surround_right"));
        }
        get lfe() {
            return VAPI.AT1130.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "lfe"));
        }
        get rear_surround_left() {
            return VAPI.AT1130.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "rear_surround_left"));
        }
        get rear_surround_right() {
            return VAPI.AT1130.AudioMixer.lift.ChannelSelection(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "rear_surround_right"));
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "output"));
        }
    }
    AudioMixer.Mode71 = Mode71;
    class Mode71AsNamedTableRow extends Mode71 {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioMixer.Mode71AsNamedTableRow = Mode71AsNamedTableRow;
    class Monos {
        raw;
        type_identifier = "AudioMixer::Data::Monos";
        constructor(raw) {
            this.raw = raw;
        }
        get channels() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "channels"), (raw) => new VAPI.AT1130.AudioMixer.ChannelSelectionAsNamedTableRow(raw));
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "output"));
        }
    }
    AudioMixer.Monos = Monos;
    class MonosAsNamedTableRow extends Monos {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioMixer.MonosAsNamedTableRow = MonosAsNamedTableRow;
    class Source {
        raw;
        type_identifier = "AudioMixer::Data::Source";
        constructor(raw) {
            this.raw = raw;
        }
        get channel() {
            return new VScript.dKeyword(this, "channel", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
    }
    AudioMixer.Source = Source;
    class SourceStereo {
        raw;
        type_identifier = "AudioMixer::Data::SourceStereo";
        constructor(raw) {
            this.raw = raw;
        }
        get channel_left() {
            return new VScript.dKeyword(this, "channel_left", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get channel_right() {
            return new VScript.dKeyword(this, "channel_right", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
    }
    AudioMixer.SourceStereo = SourceStereo;
    class Stereos {
        raw;
        type_identifier = "AudioMixer::Data::Stereos";
        constructor(raw) {
            this.raw = raw;
        }
        get mono_channels() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "mono_channels"), (raw) => new VAPI.AT1130.AudioMixer.ChannelMonoAsNamedTableRow(raw));
        }
        get stereo_pairs() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "stereo_pairs"), (raw) => new VAPI.AT1130.AudioMixer.ChannelStereoAsNamedTableRow(raw));
        }
        get output() {
            return VAPI.AT1130.AudioMixer.lift.StereosOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "output"));
        }
    }
    AudioMixer.Stereos = Stereos;
    class StereosAsNamedTableRow extends Stereos {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioMixer.StereosAsNamedTableRow = StereosAsNamedTableRow;
    class StereosOutput {
        raw;
        type_identifier = "AudioMixer::Data::Stereos::Output";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          Reset to default
        */
        get reset_to_default() {
            return new VScript.wKeyword(this, "reset_to_default", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get gain() {
            return new VScript.rwKeyword(this, "gain", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get phase_inversion() {
            return new VScript.rwKeyword(this, "phase_inversion", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "output"));
        }
    }
    AudioMixer.StereosOutput = StereosOutput;
})(AudioMixer || (AudioMixer = {}));
export var AudioRePlay;
(function (AudioRePlay) {
    AudioRePlay.lift = {
        Audio: (_raw) => (new Audio(_raw)),
        Buffer: (_raw) => (new Buffer(_raw)),
        Delay: (_raw) => (new Delay(_raw)),
        DelayOutput: (_raw) => (new DelayOutput(_raw)),
        Player: (_raw) => (new Player(_raw)),
        PlayerOutput: (_raw) => (new PlayerOutput(_raw)),
        RelationAudio: (_raw) => (new RelationAudio(_raw)),
        RelationVideo: (_raw) => (new RelationVideo(_raw)),
        Relations: (_raw) => (new Relations(_raw)),
        Time: (_raw) => (new Time(_raw)),
        RelationAudioFollowers: (_raw) => (new RelationAudioFollowers(_raw)),
        RelationVideoFollowers: (_raw) => (new RelationVideoFollowers(_raw)),
        DelayInputs: (_raw) => (new DelayInputs(_raw)),
    };
    AudioRePlay.lower = {
        Audio: (_x) => _x.raw.kwl,
        Buffer: (_x) => _x.raw.kwl,
        Delay: (_x) => _x.raw.kwl,
        DelayOutput: (_x) => _x.raw.kwl,
        Player: (_x) => _x.raw.kwl,
        PlayerOutput: (_x) => _x.raw.kwl,
        RelationAudio: (_x) => _x.raw.kwl,
        RelationVideo: (_x) => _x.raw.kwl,
        Relations: (_x) => _x.raw.kwl,
        Time: (_x) => _x.raw.kwl,
        RelationAudioFollowers: (_x) => _x.raw.kwl,
        RelationVideoFollowers: (_x) => _x.raw.kwl,
        DelayInputs: (_x) => _x.raw.kwl,
    };
    class Audio {
        raw;
        type_identifier = "AudioRePlay::Data::Audio";
        constructor(raw) {
            this.raw = raw;
        }
        get info() {
            return VAPI.DataRePlay.lift.MemoryInfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "info"));
        }
        get players() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "players"), (raw) => new VAPI.AT1130.AudioRePlay.PlayerAsNamedTableRow(raw));
        }
        get delays() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 2, "delays"), (raw) => new VAPI.AT1130.AudioRePlay.DelayAsNamedTableRow(raw));
        }
        get statistics() {
            return VAPI.DataRePlay.lift.Statistic(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "statistics"));
        }
        get ecc() {
            return VAPI.Memory.lift.ECCMuxStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "ecc"));
        }
        get audio_source_slices() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 5, "audio_source_slices"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
    }
    AudioRePlay.Audio = Audio;
    class Buffer {
        raw;
        type_identifier = "AudioRePlay::Data::Buffer";
        constructor(raw) {
            this.raw = raw;
        }
        get offset() {
            return new VScript.dKeyword(this, "offset", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lift.AllocationMode),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lower.AllocationMode)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lift.AllocationMode),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lower.AllocationMode)
            }, (parent, command) => (void parent, void command, { criterion: "status", validator: (status) => (command === null && status === null) || (command !== null && status !== null) && ((command.variant === 'Samples' && status.variant === 'Samples' && status.value.samples >= command.value.samples) || (command.variant === 'Time' && status.variant === 'Time' && status.value.time.s() >= command.value.time.s())) }));
        }
        get audio_follow_video() {
            return new VScript.dKeyword(this, "audio_follow_video", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get auto_dolby_e_aligner() {
            return new VScript.dKeyword(this, "auto_dolby_e_aligner", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get measurement_reference() {
            return new VScript.dKeyword(this, "measurement_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get current_delay() {
            return new VScript.rKeyword(this, "current_delay", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lift.BufferCurrentDelay),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AudioRePlay.lower.BufferCurrentDelay)
            });
        }
    }
    AudioRePlay.Buffer = Buffer;
    class Delay {
        raw;
        type_identifier = "AudioRePlay::Data::Delay";
        constructor(raw) {
            this.raw = raw;
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    missing_buffer_allocation: (x & 1) !== 0,
                    missing_sample_setting: (x & 2) !== 0,
                    missing_time_setting: (x & 4) !== 0,
                    missing_timesource: (x & 8) !== 0,
                    out_of_bounds: (x & 16) !== 0,
                    out_of_memory: (x & 32) !== 0,
                    out_of_readers: (x & 64) !== 0,
                    out_of_writers: (x & 128) !== 0,
                    too_small_for_dolby_e_alignment: (x & 256) !== 0
                }),
                lower: (x, _) => ((x.missing_buffer_allocation ? 1 : 0) |
                    (x.missing_sample_setting ? 2 : 0) |
                    (x.missing_time_setting ? 4 : 0) |
                    (x.missing_timesource ? 8 : 0) |
                    (x.out_of_bounds ? 16 : 0) |
                    (x.out_of_memory ? 32 : 0) |
                    (x.out_of_readers ? 64 : 0) |
                    (x.out_of_writers ? 128 : 0) |
                    (x.too_small_for_dolby_e_alignment ? 256 : 0))
            });
        }
        get capabilities() {
            return VAPI.AudioRePlay.lift.BufferInput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "capabilities"));
        }
        get num_outputs() {
            return new VScript.rwKeyword(this, "num_outputs", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Restart writer and reader
        */
        get restart() {
            return new VScript.wKeyword(this, "restart", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get dolby_e() {
            return VAPI.AudioRePlay.lift.DolbyE(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "dolby_e"));
        }
        get inputs() {
            return VAPI.AT1130.AudioRePlay.lift.DelayInputs(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "inputs"));
        }
        get outputs() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 6, "outputs"), (raw, _) => VAPI.AT1130.AudioRePlay.lift.DelayOutput(raw));
        }
    }
    AudioRePlay.Delay = Delay;
    class DelayAsNamedTableRow extends Delay {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioRePlay.DelayAsNamedTableRow = DelayAsNamedTableRow;
    class DelayOutput {
        raw;
        type_identifier = "AudioRePlay::Data::DelayOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get time() {
            return VAPI.AT1130.AudioRePlay.lift.Time(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "time"));
        }
        get delay() {
            return VAPI.AT1130.AudioRePlay.lift.Buffer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "delay"));
        }
        get afv() {
            return VAPI.AudioRePlay.lift.AFVRef(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "afv"));
        }
        get dolby_e() {
            return VAPI.AudioRePlay.lift.DolbyERef(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "dolby_e"));
        }
        get reader() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 5, "reader"), (raw, _) => VAPI.AudioRePlay.lift.Reader(raw));
        }
        get audio() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "audio"));
        }
    }
    AudioRePlay.DelayOutput = DelayOutput;
    class Player {
        raw;
        type_identifier = "AudioRePlay::Data::Player";
        constructor(raw) {
            this.raw = raw;
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    missing_timesource: (x & 1) !== 0,
                    out_of_memory: (x & 2) !== 0,
                    out_of_readers: (x & 4) !== 0
                }),
                lower: (x, _) => ((x.missing_timesource ? 1 : 0) |
                    (x.out_of_memory ? 2 : 0) |
                    (x.out_of_readers ? 4 : 0))
            });
        }
        get upload_header() {
            return VAPI.AudioRePlay.lift.UploadHeader(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "upload_header"));
        }
        get capabilities() {
            return VAPI.AudioRePlay.lift.BufferInput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "capabilities"));
        }
        get gang() {
            return VAPI.AT1130.AudioRePlay.lift.Relations(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "gang"));
        }
        /**
          Restart writer and reader
        */
        get restart() {
            return new VScript.wKeyword(this, "restart", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get output() {
            return VAPI.AT1130.AudioRePlay.lift.PlayerOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "output"));
        }
    }
    AudioRePlay.Player = Player;
    class PlayerAsNamedTableRow extends Player {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioRePlay.PlayerAsNamedTableRow = PlayerAsNamedTableRow;
    class PlayerOutput {
        raw;
        type_identifier = "AudioRePlay::Data::PlayerOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get time() {
            return VAPI.AT1130.AudioRePlay.lift.Time(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "time"));
        }
        get control() {
            return VAPI.AudioRePlay.lift.Control(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "control"));
        }
        get reader() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 3, "reader"), (raw, _) => VAPI.AudioRePlay.lift.Reader(raw));
        }
        get audio() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "audio"));
        }
    }
    AudioRePlay.PlayerOutput = PlayerOutput;
    class RelationAudio {
        raw;
        type_identifier = "AudioRePlay::Data::RelationAudio";
        constructor(raw) {
            this.raw = raw;
        }
        get leader() {
            return new VScript.dKeyword(this, "leader", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.AudioRePlay.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.AudioRePlay.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get followers() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "followers"), (raw, _) => VAPI.AT1130.AudioRePlay.lift.RelationAudioFollowers(raw));
        }
    }
    AudioRePlay.RelationAudio = RelationAudio;
    class RelationVideo {
        raw;
        type_identifier = "AudioRePlay::Data::RelationVideo";
        constructor(raw) {
            this.raw = raw;
        }
        get leader() {
            return new VScript.dKeyword(this, "leader", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.VideoPlayer.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.VideoPlayer.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get followers() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "followers"), (raw, _) => VAPI.AT1130.AudioRePlay.lift.RelationVideoFollowers(raw));
        }
    }
    AudioRePlay.RelationVideo = RelationVideo;
    class Relations {
        raw;
        type_identifier = "AudioRePlay::Data::Relations";
        constructor(raw) {
            this.raw = raw;
        }
        get video() {
            return VAPI.AT1130.AudioRePlay.lift.RelationVideo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "video"));
        }
        get audio() {
            return VAPI.AT1130.AudioRePlay.lift.RelationAudio(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "audio"));
        }
    }
    AudioRePlay.Relations = Relations;
    class Time {
        raw;
        type_identifier = "AudioRePlay::Data::Time";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
    }
    AudioRePlay.Time = Time;
    class RelationAudioFollowers {
        raw;
        type_identifier = "AudioRePlay::Data::RelationAudio::Followers";
        constructor(raw) {
            this.raw = raw;
        }
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.AudioRePlay.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    AudioRePlay.RelationAudioFollowers = RelationAudioFollowers;
    class RelationVideoFollowers {
        raw;
        type_identifier = "AudioRePlay::Data::RelationVideo::Followers";
        constructor(raw) {
            this.raw = raw;
        }
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.VideoPlayer.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    AudioRePlay.RelationVideoFollowers = RelationVideoFollowers;
    class DelayInputs {
        raw;
        type_identifier = "AudioRePlay::Data::Delay::Inputs";
        constructor(raw) {
            this.raw = raw;
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get writer() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "writer"), (raw, _) => VAPI.AudioRePlay.lift.Writer(raw));
        }
    }
    AudioRePlay.DelayInputs = DelayInputs;
})(AudioRePlay || (AudioRePlay = {}));
export var AudioShuffler;
(function (AudioShuffler) {
    AudioShuffler.lift = {
        All: (_raw) => (new All(_raw)),
        Shuffler: (_raw) => (new Shuffler(_raw)),
    };
    AudioShuffler.lower = {
        All: (_x) => _x.raw.kwl,
        Shuffler: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "AudioShuffler::Data::All";
        get runtime_constants() {
            return {
                num_shuffler_instances: this.raw.backing_store.get_runtime_constant("AudioShuffler::num_shuffler_instances")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get global_cross_fade() {
            return new VScript.rwKeyword(this, "global_cross_fade", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            }, null);
        }
        get instances() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "instances"), (raw) => new VAPI.AT1130.AudioShuffler.ShufflerAsNamedTableRow(raw));
        }
    }
    AudioShuffler.All = All;
    class Shuffler {
        raw;
        type_identifier = "AudioShuffler::Data::Shuffler";
        constructor(raw) {
            this.raw = raw;
        }
        get genlock() {
            return new VScript.dKeyword(this, "genlock", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Genlock.AT1130Genlock(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Genlock.AT1130Genlock(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "channels", {
                    lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lift.Channel),
                    lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Audio.lower.Channel)
                }))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference()))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get cross_fade() {
            return new VScript.rwKeyword(this, "cross_fade", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            }, null);
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "output"));
        }
    }
    AudioShuffler.Shuffler = Shuffler;
    class ShufflerAsNamedTableRow extends Shuffler {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    AudioShuffler.ShufflerAsNamedTableRow = ShufflerAsNamedTableRow;
})(AudioShuffler || (AudioShuffler = {}));
export var AudioSignalGenerator;
(function (AudioSignalGenerator) {
    AudioSignalGenerator.lift = {
        All: (_raw) => (new All(_raw)),
        OUT: (_raw) => (new OUT(_raw)),
        OUTS: (_raw) => (new OUTS(_raw)),
        AllAlsa: (_raw) => (new AllAlsa(_raw)),
        AllGenlock: (_raw) => (new AllGenlock(_raw)),
    };
    AudioSignalGenerator.lower = {
        All: (_x) => _x.raw.kwl,
        OUT: (_x) => _x.raw.kwl,
        OUTS: (_x) => _x.raw.kwl,
        AllAlsa: (_x) => _x.raw.kwl,
        AllGenlock: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "AudioSignalGenerator::Data::All";
        get runtime_constants() {
            return {
                num_alsa_interfaces: this.raw.backing_store.get_runtime_constant("AudioSignalGenerator::num_alsa_interfaces")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get genlock() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 0, "genlock"), (st, _) => VAPI.AT1130.AudioSignalGenerator.lift.AllGenlock(st));
        }
        get alsa() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 1, "alsa"), (st, _) => VAPI.AT1130.AudioSignalGenerator.lift.AllAlsa(st));
        }
    }
    AudioSignalGenerator.All = All;
    class OUT {
        raw;
        type_identifier = "AudioSignalGenerator::Data::OUT";
        constructor(raw) {
            this.raw = raw;
        }
        get level() {
            return new VScript.dKeyword(this, "level", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "output"));
        }
    }
    AudioSignalGenerator.OUT = OUT;
    class OUTS {
        raw;
        type_identifier = "AudioSignalGenerator::Data::OUTS";
        constructor(raw) {
            this.raw = raw;
        }
        get signal_silence() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "signal_silence"));
        }
        get signal_400hz() {
            return VAPI.AT1130.AudioSignalGenerator.lift.OUT(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "signal_400hz"));
        }
        get signal_440hz() {
            return VAPI.AT1130.AudioSignalGenerator.lift.OUT(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "signal_440hz"));
        }
        get signal_1000hz() {
            return VAPI.AT1130.AudioSignalGenerator.lift.OUT(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "signal_1000hz"));
        }
        get source_slice() {
            return VAPI.Audio.lift.SignalSourceSlice(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "source_slice"));
        }
    }
    AudioSignalGenerator.OUTS = OUTS;
    class AllAlsa {
        raw;
        type_identifier = "AudioSignalGenerator::Data::All::Alsa";
        constructor(raw) {
            this.raw = raw;
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "output"));
        }
        get source_slice() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 1, "source_slice"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
    }
    AudioSignalGenerator.AllAlsa = AllAlsa;
    class AllGenlock {
        raw;
        type_identifier = "AudioSignalGenerator::Data::All::Genlock";
        constructor(raw) {
            this.raw = raw;
        }
        get f48000() {
            return VAPI.AT1130.AudioSignalGenerator.lift.OUTS(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "f48000"));
        }
        get f96000() {
            return VAPI.AT1130.AudioSignalGenerator.lift.OUTS(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "f96000"));
        }
    }
    AudioSignalGenerator.AllGenlock = AllGenlock;
})(AudioSignalGenerator || (AudioSignalGenerator = {}));
export var Cluster;
(function (Cluster) {
    Cluster.lift = {
        All: (_raw) => (new All(_raw)),
        ClusterGlobal: (_raw) => (new ClusterGlobal(_raw)),
        ClusterGlobalRuntime: (_raw) => (new ClusterGlobalRuntime(_raw)),
        ClusterLocal: (_raw) => (new ClusterLocal(_raw)),
        ClusterLocalRuntime: (_raw) => (new ClusterLocalRuntime(_raw)),
    };
    Cluster.lower = {
        All: (_x) => _x.raw.kwl,
        ClusterGlobal: (_x) => _x.raw.kwl,
        ClusterGlobalRuntime: (_x) => _x.raw.kwl,
        ClusterLocal: (_x) => _x.raw.kwl,
        ClusterLocalRuntime: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "Cluster::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get global() {
            return VAPI.AT1130.Cluster.lift.ClusterGlobal(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "global"));
        }
        get local() {
            return VAPI.AT1130.Cluster.lift.ClusterLocal(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "local"));
        }
    }
    Cluster.All = All;
    class ClusterGlobal {
        raw;
        type_identifier = "Cluster::Data::ClusterGlobal";
        constructor(raw) {
            this.raw = raw;
        }
        get configuration() {
            return VAPI.Cluster.lift.ClusterGlobalConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "configuration"));
        }
        get runtime() {
            return VAPI.AT1130.Cluster.lift.ClusterGlobalRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "runtime"));
        }
    }
    Cluster.ClusterGlobal = ClusterGlobal;
    class ClusterGlobalRuntime {
        raw;
        type_identifier = "Cluster::Data::ClusterGlobalRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get connected_to_myself() {
            return new VScript.rKeyword(this, "connected_to_myself", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get nodes() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "nodes"), (raw, _) => VAPI.ClusterNodes.lift.ClusterNodeGlobalRuntime(raw));
        }
        get sources() {
            return VAPI.AT1130.ClusterSources.lift.ClusterSourcesGlobalRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "sources"));
        }
        get outputs() {
            return VAPI.ClusterOutputs.lift.ClusterOutputsGlobalRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "outputs"));
        }
        get monitoring_objects() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "monitoring_objects"), (raw, _) => VAPI.AT1130.ClusterMonitoringObjects.lift.ClusterMonitoringObjectGlobalRuntime(raw));
        }
    }
    Cluster.ClusterGlobalRuntime = ClusterGlobalRuntime;
    class ClusterLocal {
        raw;
        type_identifier = "Cluster::Data::ClusterLocal";
        constructor(raw) {
            this.raw = raw;
        }
        get runtime() {
            return VAPI.AT1130.Cluster.lift.ClusterLocalRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "runtime"));
        }
    }
    Cluster.ClusterLocal = ClusterLocal;
    class ClusterLocalRuntime {
        raw;
        type_identifier = "Cluster::Data::ClusterLocalRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get processors() {
            return VAPI.AT1130.ClusterProcessors.lift.ClusterProcessorsLocalRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "processors"));
        }
        get statistics() {
            return VAPI.Cluster.lift.ClusterStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "statistics"));
        }
    }
    Cluster.ClusterLocalRuntime = ClusterLocalRuntime;
})(Cluster || (Cluster = {}));
export var ClusterMonitoringObjects;
(function (ClusterMonitoringObjects) {
    ClusterMonitoringObjects.lift = {
        ClusterAudioMonitoringObjectRuntime: (_raw) => (new ClusterAudioMonitoringObjectRuntime(_raw)),
        ClusterMetadataMonitoringObjectRuntime: (_raw) => (new ClusterMetadataMonitoringObjectRuntime(_raw)),
        ClusterMonitoringObjectGlobalRuntime: (_raw) => (new ClusterMonitoringObjectGlobalRuntime(_raw)),
        ClusterVideoMonitoringObjectRuntime: (_raw) => (new ClusterVideoMonitoringObjectRuntime(_raw)),
    };
    ClusterMonitoringObjects.lower = {
        ClusterAudioMonitoringObjectRuntime: (_x) => _x.raw.kwl,
        ClusterMetadataMonitoringObjectRuntime: (_x) => _x.raw.kwl,
        ClusterMonitoringObjectGlobalRuntime: (_x) => _x.raw.kwl,
        ClusterVideoMonitoringObjectRuntime: (_x) => _x.raw.kwl,
    };
    class ClusterAudioMonitoringObjectRuntime {
        raw;
        type_identifier = "ClusterMonitoringObjects::Data::ClusterAudioMonitoringObjectRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get source() {
            return new VScript.rKeyword(this, "source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.ClusterSources.ClusterAudioSourceRuntime(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get alarms() {
            return new VScript.rKeyword(this, "alarms", {
                lift: VAPI.ClusterMonitoringObjects.lift.ClusterAudioMonitoringObjectRuntimeAlarms,
                lower: VAPI.ClusterMonitoringObjects.lower.ClusterAudioMonitoringObjectRuntimeAlarms
            });
        }
    }
    ClusterMonitoringObjects.ClusterAudioMonitoringObjectRuntime = ClusterAudioMonitoringObjectRuntime;
    class ClusterMetadataMonitoringObjectRuntime {
        raw;
        type_identifier = "ClusterMonitoringObjects::Data::ClusterMetadataMonitoringObjectRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get source() {
            return new VScript.rKeyword(this, "source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.ClusterSources.ClusterMetadataSourceRuntime(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get alarms() {
            return new VScript.rKeyword(this, "alarms", {
                lift: VAPI.ClusterMonitoringObjects.lift.ClusterMetadataMonitoringObjectRuntimeAlarms,
                lower: VAPI.ClusterMonitoringObjects.lower.ClusterMetadataMonitoringObjectRuntimeAlarms
            });
        }
    }
    ClusterMonitoringObjects.ClusterMetadataMonitoringObjectRuntime = ClusterMetadataMonitoringObjectRuntime;
    class ClusterMonitoringObjectGlobalRuntime {
        raw;
        type_identifier = "ClusterMonitoringObjects::Data::ClusterMonitoringObjectGlobalRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get alarm() {
            return new VScript.rKeyword(this, "alarm", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get alarm_severity_level() {
            return new VScript.rKeyword(this, "alarm_severity_level", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get video() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 2, "video"), (st, _) => VAPI.AT1130.ClusterMonitoringObjects.lift.ClusterVideoMonitoringObjectRuntime(st));
        }
        get audio() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 3, "audio"), (st, _) => VAPI.AT1130.ClusterMonitoringObjects.lift.ClusterAudioMonitoringObjectRuntime(st));
        }
        get metadata() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 4, "metadata"), (st, _) => VAPI.AT1130.ClusterMonitoringObjects.lift.ClusterMetadataMonitoringObjectRuntime(st));
        }
        get user_labels() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 5, "user_labels"), (st, _) => VAPI.ClusterSources.lift.ClusterSourceLabelDual(st));
        }
        get configuration() {
            return new VScript.rKeyword(this, "configuration", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.ClusterMonitoringObjects.ClusterMonitoringObjectGlobalConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    ClusterMonitoringObjects.ClusterMonitoringObjectGlobalRuntime = ClusterMonitoringObjectGlobalRuntime;
    class ClusterVideoMonitoringObjectRuntime {
        raw;
        type_identifier = "ClusterMonitoringObjects::Data::ClusterVideoMonitoringObjectRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get source() {
            return new VScript.rKeyword(this, "source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.ClusterSources.ClusterVideoSourceRuntime(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get alarms() {
            return new VScript.rKeyword(this, "alarms", {
                lift: VAPI.ClusterMonitoringObjects.lift.ClusterVideoMonitoringObjectRuntimeAlarms,
                lower: VAPI.ClusterMonitoringObjects.lower.ClusterVideoMonitoringObjectRuntimeAlarms
            });
        }
        get tally_mask() {
            return new VScript.rwKeyword(this, "tally_mask", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get label() {
            return VAPI.ClusterSources.lift.ClusterSourceLabelDual(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "label"));
        }
    }
    ClusterMonitoringObjects.ClusterVideoMonitoringObjectRuntime = ClusterVideoMonitoringObjectRuntime;
})(ClusterMonitoringObjects || (ClusterMonitoringObjects = {}));
export var ClusterProcessors;
(function (ClusterProcessors) {
    ClusterProcessors.lift = {
        ClusterProcessorMipMapsDualOutputRuntime: (_raw) => (new ClusterProcessorMipMapsDualOutputRuntime(_raw)),
        ClusterProcessorMipMapsDualOutputRuntimeSource: (_raw) => (new ClusterProcessorMipMapsDualOutputRuntimeSource(_raw)),
        ClusterProcessorsLocalRuntime: (_raw) => (new ClusterProcessorsLocalRuntime(_raw)),
        ClusterProcessorsMetadataRuntime: (_raw) => (new ClusterProcessorsMetadataRuntime(_raw)),
        ClusterProcessorsMipMapsRuntime: (_raw) => (new ClusterProcessorsMipMapsRuntime(_raw)),
    };
    ClusterProcessors.lower = {
        ClusterProcessorMipMapsDualOutputRuntime: (_x) => _x.raw.kwl,
        ClusterProcessorMipMapsDualOutputRuntimeSource: (_x) => _x.raw.kwl,
        ClusterProcessorsLocalRuntime: (_x) => _x.raw.kwl,
        ClusterProcessorsMetadataRuntime: (_x) => _x.raw.kwl,
        ClusterProcessorsMipMapsRuntime: (_x) => _x.raw.kwl,
    };
    class ClusterProcessorMipMapsDualOutputRuntime {
        raw;
        type_identifier = "ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get local_sources() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 0, "local_sources"), (st, _) => VAPI.AT1130.ClusterProcessors.lift.ClusterProcessorMipMapsDualOutputRuntimeSource(st));
        }
    }
    ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntime = ClusterProcessorMipMapsDualOutputRuntime;
    class ClusterProcessorMipMapsDualOutputRuntimeSource {
        raw;
        type_identifier = "ClusterProcessors::Data::ClusterProcessorMipMapsDualOutputRuntimeSource";
        constructor(raw) {
            this.raw = raw;
        }
        get full_size() {
            return new VScript.rKeyword(this, "full_size", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get source() {
            return new VScript.rKeyword(this, "source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.ClusterSources.ClusterVideoSourceRuntime(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get source_sdp() {
            return new VScript.rKeyword(this, "source_sdp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get input_primary_port() {
            return new VScript.rKeyword(this, "input_primary_port", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get input_secondary_port() {
            return new VScript.rKeyword(this, "input_secondary_port", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get output_primary_port() {
            return new VScript.rKeyword(this, "output_primary_port", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get output_secondary_port() {
            return new VScript.rKeyword(this, "output_secondary_port", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          IP address of the mipmap RTP stream
        */
        get output_src_ip_address() {
            return new VScript.rKeyword(this, "output_src_ip_address", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          IP address of the secondary mipmap RTP stream
        */
        get output_secondary_src_ip_address() {
            return new VScript.rKeyword(this, "output_secondary_src_ip_address", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get crossbar_select() {
            return new VScript.rKeyword(this, "crossbar_select", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    ClusterProcessors.ClusterProcessorMipMapsDualOutputRuntimeSource = ClusterProcessorMipMapsDualOutputRuntimeSource;
    class ClusterProcessorsLocalRuntime {
        raw;
        type_identifier = "ClusterProcessors::Data::ClusterProcessorsLocalRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get mipmaps() {
            return VAPI.AT1130.ClusterProcessors.lift.ClusterProcessorsMipMapsRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "mipmaps"));
        }
        get metadata() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "metadata"), (raw, _) => VAPI.AT1130.ClusterProcessors.lift.ClusterProcessorsMetadataRuntime(raw));
        }
        get ppms() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "ppms"), (raw, _) => VAPI.ClusterProcessors.lift.ClusterProcessorsPPMSRuntime(raw));
        }
    }
    ClusterProcessors.ClusterProcessorsLocalRuntime = ClusterProcessorsLocalRuntime;
    class ClusterProcessorsMetadataRuntime {
        raw;
        type_identifier = "ClusterProcessors::Data::ClusterProcessorsMetadataRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get source() {
            return new VScript.rKeyword(this, "source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.ClusterSources.ClusterMetadataSourceRuntime(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    ClusterProcessors.ClusterProcessorsMetadataRuntime = ClusterProcessorsMetadataRuntime;
    class ClusterProcessorsMipMapsRuntime {
        raw;
        type_identifier = "ClusterProcessors::Data::ClusterProcessorsMipMapsRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get outputs() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "outputs"), (raw, _) => VAPI.AT1130.ClusterProcessors.lift.ClusterProcessorMipMapsDualOutputRuntime(raw));
        }
        get inputs() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "inputs"), (raw, _) => VAPI.ClusterProcessors.lift.ClusterProcessorMipMapsInputRuntime(raw));
        }
    }
    ClusterProcessors.ClusterProcessorsMipMapsRuntime = ClusterProcessorsMipMapsRuntime;
})(ClusterProcessors || (ClusterProcessors = {}));
export var ClusterSources;
(function (ClusterSources) {
    ClusterSources.lift = {
        ClusterAudioSourceRuntime: (_raw) => (new ClusterAudioSourceRuntime(_raw)),
        ClusterAudioSourceRuntimeLocal: (_raw) => (new ClusterAudioSourceRuntimeLocal(_raw)),
        ClusterMetadataSourceLocalRuntime: (_raw) => (new ClusterMetadataSourceLocalRuntime(_raw)),
        ClusterMetadataSourceRuntime: (_raw) => (new ClusterMetadataSourceRuntime(_raw)),
        ClusterSourcesGlobalRuntime: (_raw) => (new ClusterSourcesGlobalRuntime(_raw)),
        ClusterVideoSourceRuntime: (_raw) => (new ClusterVideoSourceRuntime(_raw)),
        ClusterVideoSourceRuntimeLocal: (_raw) => (new ClusterVideoSourceRuntimeLocal(_raw)),
    };
    ClusterSources.lower = {
        ClusterAudioSourceRuntime: (_x) => _x.raw.kwl,
        ClusterAudioSourceRuntimeLocal: (_x) => _x.raw.kwl,
        ClusterMetadataSourceLocalRuntime: (_x) => _x.raw.kwl,
        ClusterMetadataSourceRuntime: (_x) => _x.raw.kwl,
        ClusterSourcesGlobalRuntime: (_x) => _x.raw.kwl,
        ClusterVideoSourceRuntime: (_x) => _x.raw.kwl,
        ClusterVideoSourceRuntimeLocal: (_x) => _x.raw.kwl,
    };
    class ClusterAudioSourceRuntime {
        raw;
        type_identifier = "ClusterSources::Data::ClusterAudioSourceRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get transport_format() {
            return new VScript.rKeyword(this, "transport_format", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get num_channels() {
            return new VScript.rKeyword(this, "num_channels", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get peak_meters() {
            return new VScript.rKeyword(this, "peak_meters", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get ip_configuration() {
            return new VScript.rKeyword(this, "ip_configuration", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.ClusterSources.ClusterIPSourceConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get local() {
            return VAPI.AT1130.ClusterSources.lift.ClusterAudioSourceRuntimeLocal(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "local"));
        }
        get tally_mask() {
            return new VScript.rwKeyword(this, "tally_mask", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get label() {
            return VAPI.ClusterSources.lift.ClusterSourceLabelDual(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "label"));
        }
        get lifeness_count() {
            return new VScript.rKeyword(this, "lifeness_count", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get bytes_per_second() {
            return new VScript.rKeyword(this, "bytes_per_second", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    ClusterSources.ClusterAudioSourceRuntime = ClusterAudioSourceRuntime;
    class ClusterAudioSourceRuntimeLocal {
        raw;
        type_identifier = "ClusterSources::Data::ClusterAudioSourceRuntimeLocal";
        constructor(raw) {
            this.raw = raw;
        }
        get audio_essence() {
            return new VScript.rKeyword(this, "audio_essence", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get bad_sdp() {
            return new VScript.rKeyword(this, "bad_sdp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get used_channel_id_start() {
            return new VScript.rKeyword(this, "used_channel_id_start", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get used_channels_num() {
            return new VScript.rKeyword(this, "used_channels_num", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    ClusterSources.ClusterAudioSourceRuntimeLocal = ClusterAudioSourceRuntimeLocal;
    class ClusterMetadataSourceLocalRuntime {
        raw;
        type_identifier = "ClusterSources::Data::ClusterMetadataSourceLocalRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get bad_sdp() {
            return new VScript.rKeyword(this, "bad_sdp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get time_source() {
            return new VScript.rKeyword(this, "time_source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get closed_caption() {
            return new VScript.rKeyword(this, "closed_caption", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.Video.ClosedCaption(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    ClusterSources.ClusterMetadataSourceLocalRuntime = ClusterMetadataSourceLocalRuntime;
    class ClusterMetadataSourceRuntime {
        raw;
        type_identifier = "ClusterSources::Data::ClusterMetadataSourceRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get global_source_id() {
            return new VScript.rKeyword(this, "global_source_id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get transport_format() {
            return new VScript.rKeyword(this, "transport_format", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Source IP address of the metadata RTP stream
        */
        get src_ip_address() {
            return new VScript.rKeyword(this, "src_ip_address", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Source IP address of the metadata RTP stream
        */
        get secondary_src_ip_address() {
            return new VScript.rKeyword(this, "secondary_src_ip_address", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Destination IP address of the metadata RTP stream
        */
        get dest_ip_address() {
            return new VScript.rKeyword(this, "dest_ip_address", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Destination IP address of the metadata RTP stream
        */
        get secondary_dest_ip_address() {
            return new VScript.rKeyword(this, "secondary_dest_ip_address", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get ip_configuration() {
            return new VScript.rKeyword(this, "ip_configuration", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.ClusterSources.ClusterIPSourceConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get local() {
            return VAPI.AT1130.ClusterSources.lift.ClusterMetadataSourceLocalRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "local"));
        }
        get lifeness_count() {
            return new VScript.rKeyword(this, "lifeness_count", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get time_code() {
            return new VScript.rKeyword(this, "time_code", {
                lift: VAPI.ClusterSources.lift.TimestampedTimecode,
                lower: VAPI.ClusterSources.lower.TimestampedTimecode
            });
        }
        get closed_caption() {
            return VAPI.ClusterSources.lift.ClusterMetadataSourceCC(VScript.VAPIHelpers.subtree_child_checked(this.raw, 11, "closed_caption"));
        }
    }
    ClusterSources.ClusterMetadataSourceRuntime = ClusterMetadataSourceRuntime;
    class ClusterSourcesGlobalRuntime {
        raw;
        type_identifier = "ClusterSources::Data::ClusterSourcesGlobalRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get video() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "video"), (raw, _) => VAPI.AT1130.ClusterSources.lift.ClusterVideoSourceRuntime(raw));
        }
        get audio() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "audio"), (raw, _) => VAPI.AT1130.ClusterSources.lift.ClusterAudioSourceRuntime(raw));
        }
        get metadata() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "metadata"), (raw, _) => VAPI.AT1130.ClusterSources.lift.ClusterMetadataSourceRuntime(raw));
        }
    }
    ClusterSources.ClusterSourcesGlobalRuntime = ClusterSourcesGlobalRuntime;
    class ClusterVideoSourceRuntime {
        raw;
        type_identifier = "ClusterSources::Data::ClusterVideoSourceRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get global_source_id() {
            return new VScript.rKeyword(this, "global_source_id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get transport_format() {
            return new VScript.rKeyword(this, "transport_format", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get video_standard() {
            return new VScript.rKeyword(this, "video_standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get ip_configuration() {
            return new VScript.rKeyword(this, "ip_configuration", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.ClusterSources.ClusterIPSourceConfiguration(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        /**
          Source IP address of the mipmap RTP stream
        */
        get resolution_levels_src_ip_address() {
            return new VScript.rKeyword(this, "resolution_levels_src_ip_address", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Source IP address of the mipmap RTP stream
        */
        get secondary_resolution_levels_src_ip_address() {
            return new VScript.rKeyword(this, "secondary_resolution_levels_src_ip_address", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get resolution_levels() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 7, "resolution_levels"), (st, _) => VAPI.ClusterSources.lift.ClusterVideoSourceRuntimeResolutionLevel(st));
        }
        get local() {
            return VAPI.AT1130.ClusterSources.lift.ClusterVideoSourceRuntimeLocal(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "local"));
        }
        get tally_mask() {
            return new VScript.rwKeyword(this, "tally_mask", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get label() {
            return VAPI.ClusterSources.lift.ClusterSourceLabelDual(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "label"));
        }
        get lifeness_count() {
            return new VScript.rKeyword(this, "lifeness_count", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    ClusterSources.ClusterVideoSourceRuntime = ClusterVideoSourceRuntime;
    class ClusterVideoSourceRuntimeLocal {
        raw;
        type_identifier = "ClusterSources::Data::ClusterVideoSourceRuntimeLocal";
        constructor(raw) {
            this.raw = raw;
        }
        get video_essence() {
            return new VScript.rKeyword(this, "video_essence", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get bad_sdp() {
            return new VScript.rKeyword(this, "bad_sdp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    ClusterSources.ClusterVideoSourceRuntimeLocal = ClusterVideoSourceRuntimeLocal;
})(ClusterSources || (ClusterSources = {}));
export var ColorCorrection;
(function (ColorCorrection) {
    ColorCorrection.lift = {
        All: (_raw) => (new All(_raw)),
        CC1D: (_raw) => (new CC1D(_raw)),
        CC3D: (_raw) => (new CC3D(_raw)),
    };
    ColorCorrection.lower = {
        All: (_x) => _x.raw.kwl,
        CC1D: (_x) => _x.raw.kwl,
        CC3D: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "ColorCorrection::Data::All";
        get runtime_constants() {
            return {
                num_color_correction: this.raw.backing_store.get_runtime_constant("ColorCorrection::num_color_correction"),
                num_3d_color_correction: this.raw.backing_store.get_runtime_constant("ColorCorrection::num_3d_color_correction")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get cc1d() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "cc1d"), (raw) => new VAPI.AT1130.ColorCorrection.CC1DAsNamedTableRow(raw));
        }
        get cc3d() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "cc3d"), (raw) => new VAPI.AT1130.ColorCorrection.CC3DAsNamedTableRow(raw));
        }
    }
    ColorCorrection.All = All;
    class CC1D {
        raw;
        type_identifier = "ColorCorrection::Data::CC1D";
        constructor(raw) {
            this.raw = raw;
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1130.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "output"));
        }
        get reserve_uhd_resources() {
            return new VScript.dKeyword(this, "reserve_uhd_resources", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Selects which parameter sets are used to control this color correction
        */
        get color_schema() {
            return new VScript.rwKeyword(this, "color_schema", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          When set changes the output color space to the specified one
        */
        get output_cs() {
            return new VScript.rwKeyword(this, "output_cs", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get yuv() {
            return VAPI.ColorCorrection.lift.YUV(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "yuv"));
        }
        get rgb() {
            return VAPI.ColorCorrection.lift.CC1DRgb(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "rgb"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    missing_input_mapper: (x & 1) !== 0,
                    no_hw_resources_available: (x & 2) !== 0,
                    no_uhd_resources_allocated: (x & 4) !== 0
                }),
                lower: (x, _) => ((x.missing_input_mapper ? 1 : 0) |
                    (x.no_hw_resources_available ? 2 : 0) |
                    (x.no_uhd_resources_allocated ? 4 : 0))
            });
        }
    }
    ColorCorrection.CC1D = CC1D;
    class CC1DAsNamedTableRow extends CC1D {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    ColorCorrection.CC1DAsNamedTableRow = CC1DAsNamedTableRow;
    class CC3D {
        raw;
        type_identifier = "ColorCorrection::Data::CC3D";
        constructor(raw) {
            this.raw = raw;
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1130.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "output"));
        }
        get reserve_uhd_resources() {
            return new VScript.dKeyword(this, "reserve_uhd_resources", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Selects which parameter sets are used to control this color correction
        */
        get color_schema() {
            return new VScript.rwKeyword(this, "color_schema", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get yuv() {
            return VAPI.ColorCorrection.lift.YUV(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "yuv"));
        }
        get lut_name() {
            return new VScript.dKeyword(this, "lut_name", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get lut_info() {
            return VAPI.ColorCorrection.lift.CC3DLutInfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "lut_info"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    missing_input_mapper: (x & 1) !== 0,
                    no_hw_resources_available: (x & 2) !== 0,
                    no_uhd_resources_allocated: (x & 4) !== 0
                }),
                lower: (x, _) => ((x.missing_input_mapper ? 1 : 0) |
                    (x.no_hw_resources_available ? 2 : 0) |
                    (x.no_uhd_resources_allocated ? 4 : 0))
            });
        }
    }
    ColorCorrection.CC3D = CC3D;
    class CC3DAsNamedTableRow extends CC3D {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    ColorCorrection.CC3DAsNamedTableRow = CC3DAsNamedTableRow;
})(ColorCorrection || (ColorCorrection = {}));
export var Definitions;
(function (Definitions) {
    Definitions.lift = {
        AudioControl: (_raw) => (new AudioControl(_raw)),
        TimecodeInserterBlank: (_raw, _socket) => {
            return {};
        },
        TimecodeInserterFreerun: (_raw, _socket) => {
            return {
                enable: VAPI.AT1130.Definitions.lift.TimecodeInserterFreerunEnable(_raw[0], _socket),
                initial_timecode: VAPI.AT1130.Definitions.lift.TimecodeInserterFreerunInitialTimecode(_raw[1], _socket)
            };
        },
        TimecodeInserterGenerator: (_raw, _socket) => {
            return {
                enable: VAPI.AT1130.Definitions.lift.TimecodeInserterGeneratorEnable(_raw[0], _socket),
                t_src: _raw[1] === null ? null : new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, _raw[1]))
            };
        },
        TimecodeInserterPassthrough: (_raw, _socket) => {
            return {};
        },
        TimecodeInserter: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "Passthrough", value: VAPI.AT1130.Definitions.lift.TimecodeInserterPassthrough(_raw[1], _socket) };
                case 1: return { variant: "Blank", value: VAPI.AT1130.Definitions.lift.TimecodeInserterBlank(_raw[1], _socket) };
                case 2: return { variant: "Freerun", value: VAPI.AT1130.Definitions.lift.TimecodeInserterFreerun(_raw[1], _socket) };
                case 3: return { variant: "Generator", value: VAPI.AT1130.Definitions.lift.TimecodeInserterGenerator(_raw[1], _socket) };
            }
            ;
        },
        VancControl: (_raw) => (new VancControl(_raw)),
        TimecodeInserterFreerunEnable: (_raw, _socket) => {
            return {
                ltc: _raw[0],
                vitc: _raw[1]
            };
        },
        TimecodeInserterGeneratorEnable: (_raw, _socket) => {
            return {
                ltc: _raw[0],
                vitc: _raw[1]
            };
        },
        TimecodeInserterFreerunInitialTimecode: (_raw, _socket) => {
            return {
                hours: _raw[0],
                minutes: _raw[1],
                seconds: _raw[2],
                frames: _raw[3]
            };
        },
    };
    Definitions.lower = {
        AudioControl: (_x) => _x.raw.kwl,
        TimecodeInserterBlank: (_x, _socket) => [],
        TimecodeInserterFreerun: (_x, _socket) => [
            VAPI.AT1130.Definitions.lower.TimecodeInserterFreerunEnable(_x.enable, _socket),
            VAPI.AT1130.Definitions.lower.TimecodeInserterFreerunInitialTimecode(_x.initial_timecode, _socket)
        ],
        TimecodeInserterGenerator: (_x, _socket) => [
            VAPI.AT1130.Definitions.lower.TimecodeInserterGeneratorEnable(_x.enable, _socket),
            _x.t_src === null ? null : _x.t_src.raw.kwl
        ],
        TimecodeInserterPassthrough: (_x, _socket) => [],
        TimecodeInserter: (_x, _socket) => {
            switch (_x.variant) {
                case "Passthrough": return [0, VAPI.AT1130.Definitions.lower.TimecodeInserterPassthrough(_x.value, _socket)];
                case "Blank": return [1, VAPI.AT1130.Definitions.lower.TimecodeInserterBlank(_x.value, _socket)];
                case "Freerun": return [2, VAPI.AT1130.Definitions.lower.TimecodeInserterFreerun(_x.value, _socket)];
                case "Generator": return [3, VAPI.AT1130.Definitions.lower.TimecodeInserterGenerator(_x.value, _socket)];
            }
        },
        VancControl: (_x) => _x.raw.kwl,
        TimecodeInserterFreerunEnable: (_x, _socket) => [
            _x.ltc,
            _x.vitc
        ],
        TimecodeInserterGeneratorEnable: (_x, _socket) => [
            _x.ltc,
            _x.vitc
        ],
        TimecodeInserterFreerunInitialTimecode: (_x, _socket) => [
            _x.hours,
            _x.minutes,
            _x.seconds,
            _x.frames
        ],
    };
    class AudioControl {
        raw;
        type_identifier = "Definitions::Data::AudioControl";
        constructor(raw) {
            this.raw = raw;
        }
        get group_enable() {
            return new VScript.dKeyword(this, "group_enable", {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get source() {
            return new VScript.dKeyword(this, "source", {
                lift: VAPI.AT1130.Audio.lift.TimedSource,
                lower: VAPI.AT1130.Audio.lower.TimedSource
            }, {
                lift: VAPI.AT1130.Audio.lift.TimedSource,
                lower: VAPI.AT1130.Audio.lower.TimedSource
            }, null);
        }
    }
    Definitions.AudioControl = AudioControl;
    class VancControl {
        raw;
        type_identifier = "Definitions::Data::VancControl";
        constructor(raw) {
            this.raw = raw;
        }
        get passthrough_c_y_0() {
            return new VScript.dKeyword(this, "passthrough_c_y_0", {
                lift: VAPI.Definitions.lift.BypassReplaceFlags,
                lower: VAPI.Definitions.lower.BypassReplaceFlags
            }, {
                lift: VAPI.Definitions.lift.BypassReplaceFlags,
                lower: VAPI.Definitions.lower.BypassReplaceFlags
            }, null);
        }
        get timecode_inserter() {
            return new VScript.dKeyword(this, "timecode_inserter", {
                lift: VAPI.AT1130.Definitions.lift.TimecodeInserter,
                lower: VAPI.AT1130.Definitions.lower.TimecodeInserter
            }, {
                lift: VAPI.AT1130.Definitions.lift.TimecodeInserter,
                lower: VAPI.AT1130.Definitions.lower.TimecodeInserter
            }, null);
        }
        get afd_inserter() {
            return new VScript.rwKeyword(this, "afd_inserter", {
                lift: VAPI.Definitions.lift.VANCAfdInserter,
                lower: VAPI.Definitions.lower.VANCAfdInserter
            }, {
                lift: VAPI.Definitions.lift.VANCAfdInserter,
                lower: VAPI.Definitions.lower.VANCAfdInserter
            }, null);
        }
        get override_smpte_352_payload() {
            return new VScript.rwKeyword(this, "override_smpte_352_payload", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    Definitions.VancControl = VancControl;
})(Definitions || (Definitions = {}));
export var EthernetStats;
(function (EthernetStats) {
    EthernetStats.lift = {
        PortStatistics: (_raw) => (new PortStatistics(_raw)),
    };
    EthernetStats.lower = {
        PortStatistics: (_x) => _x.raw.kwl,
    };
    class PortStatistics {
        raw;
        type_identifier = "EthernetStats::Data::PortStatistics";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          Number of received frames less than 64 bytes and reporting a CRC error
        */
        get rx_fragments() {
            return new VScript.rKeyword(this, "rx_fragments", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of received oversized frames reporting a CRC error
        */
        get rx_jabbers() {
            return new VScript.rKeyword(this, "rx_jabbers", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of received packets with FCS errors
        */
        get rx_fcserr() {
            return new VScript.rKeyword(this, "rx_fcserr", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of received frames with a frame of length at least 64, with CRC
          error
        */
        get rx_crcerr_okpkt() {
            return new VScript.rKeyword(this, "rx_crcerr_okpkt", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of errored multicast frames received, excluding control frames
        */
        get rx_mcast_data_err() {
            return new VScript.rKeyword(this, "rx_mcast_data_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of errored broadcast frames received, excluding control frames
        */
        get rx_bcast_data_err() {
            return new VScript.rKeyword(this, "rx_bcast_data_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of errored unicast frames received, excluding control frames
        */
        get rx_ucast_data_err() {
            return new VScript.rKeyword(this, "rx_ucast_data_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of errored multicast control frames received
        */
        get rx_mcast_ctrl_err() {
            return new VScript.rKeyword(this, "rx_mcast_ctrl_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of errored broadcast control frames received
        */
        get rx_bcast_ctrl_err() {
            return new VScript.rKeyword(this, "rx_bcast_ctrl_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of errored unicast control frames received
        */
        get rx_ucast_ctrl_err() {
            return new VScript.rKeyword(this, "rx_ucast_ctrl_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of errored pause frames received
        */
        get rx_pause_err() {
            return new VScript.rKeyword(this, "rx_pause_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of 64-byte received frames, including the CRC field but excluding
          the preamble and SFD bytes
        */
        get rx_64b() {
            return new VScript.rKeyword(this, "rx_64b", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of received frames between 65-127 bytes
        */
        get rx_65to127b() {
            return new VScript.rKeyword(this, "rx_65to127b", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of received frames between 128-255 bytes
        */
        get rx_128to255b() {
            return new VScript.rKeyword(this, "rx_128to255b", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of received frames between 256-511 bytes
        */
        get rx_256to511b() {
            return new VScript.rKeyword(this, "rx_256to511b", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of received frames between 512 –1023 bytes
        */
        get rx_512to1023b() {
            return new VScript.rKeyword(this, "rx_512to1023b", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of received frames between 1024–1518 bytes
        */
        get rx_1024to1518b() {
            return new VScript.rKeyword(this, "rx_1024to1518b", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of received frames between 1519-1536 bytes
        */
        get rx_1519to1536b() {
            return new VScript.rKeyword(this, "rx_1519to1536b", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of oversized frames received
        */
        get rx_oversize() {
            return new VScript.rKeyword(this, "rx_oversize", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of valid multicast frames received, excluding control frames
        */
        get rx_mcast_data_ok() {
            return new VScript.rKeyword(this, "rx_mcast_data_ok", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of valid broadcast frames received, excluding control frames
        */
        get rx_bcast_data_ok() {
            return new VScript.rKeyword(this, "rx_bcast_data_ok", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of valid unicast frames received, excluding control frames
        */
        get rx_ucast_data_ok() {
            return new VScript.rKeyword(this, "rx_ucast_data_ok", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of valid multicast frames received, excluding data frames
        */
        get rx_mcast_ctrl_ok() {
            return new VScript.rKeyword(this, "rx_mcast_ctrl_ok", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of valid broadcast frames received, excluding data frames
        */
        get rx_bcast_ctrl_ok() {
            return new VScript.rKeyword(this, "rx_bcast_ctrl_ok", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of valid unicast frames received, excluding data frames
        */
        get rx_ucast_ctrl_ok() {
            return new VScript.rKeyword(this, "rx_ucast_ctrl_ok", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of received pause frames, with or without error
        */
        get rx_pause() {
            return new VScript.rKeyword(this, "rx_pause", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of received runt packets
        */
        get rx_runt() {
            return new VScript.rKeyword(this, "rx_runt", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of RX frame starts
        */
        get rx_st() {
            return new VScript.rKeyword(this, "rx_st", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of RX length errors
        */
        get rx_lenerr() {
            return new VScript.rKeyword(this, "rx_lenerr", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of RX PFC frame with CRC error
        */
        get rx_pfc_err() {
            return new VScript.rKeyword(this, "rx_pfc_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of RX PFC frames without error
        */
        get rx_pfc() {
            return new VScript.rKeyword(this, "rx_pfc", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of received payload bytes in frames with no FCS, undersized,
          oversized, or payload length errors, VLAN/SVLAN header bytes are removed
          from the count
        */
        get rx_payload_octetsok() {
            return new VScript.rKeyword(this, "rx_payload_octetsok", {
                lift: VAPI.EthernetStats.lift.BytesCounter,
                lower: VAPI.EthernetStats.lower.BytesCounter
            });
        }
        /**
          Number of received bytes in frames with no FCS, undersized, oversized, or
          payload length errors
        */
        get rx_frame_octetsok() {
            return new VScript.rKeyword(this, "rx_frame_octetsok", {
                lift: VAPI.EthernetStats.lift.BytesCounter,
                lower: VAPI.EthernetStats.lower.BytesCounter
            });
        }
        /**
          Number of corrected FEC errors
        */
        get rx_rsfec_corr() {
            return new VScript.rKeyword(this, "rx_rsfec_corr", {
                lift: VAPI.EthernetStats.lift.EventsCounter,
                lower: VAPI.EthernetStats.lower.EventsCounter
            });
        }
        /**
          Number of uncorrected FEC errors
        */
        get rx_rsfec_uncorr() {
            return new VScript.rKeyword(this, "rx_rsfec_uncorr", {
                lift: VAPI.EthernetStats.lift.EventsCounter,
                lower: VAPI.EthernetStats.lower.EventsCounter
            });
        }
        /**
          Number of IP frames received with errors in the IP header
        */
        get rx_ip_hdr_err() {
            return new VScript.rKeyword(this, "rx_ip_hdr_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of IPv4 frames received with wrong header checksum
        */
        get rx_ipv4_chksum_err() {
            return new VScript.rKeyword(this, "rx_ipv4_chksum_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of fragmented IP received
        */
        get rx_fragmented() {
            return new VScript.rKeyword(this, "rx_fragmented", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of IP frames received with wrong total length
        */
        get rx_ip_totlen_err() {
            return new VScript.rKeyword(this, "rx_ip_totlen_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of UDP frames received with wrong total length
        */
        get rx_udp_totlen_err() {
            return new VScript.rKeyword(this, "rx_udp_totlen_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of UDP frames received with wrong checksum
        */
        get rx_udp_chksum_err() {
            return new VScript.rKeyword(this, "rx_udp_chksum_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of truncated UDP frames received
        */
        get rx_udp_length_err() {
            return new VScript.rKeyword(this, "rx_udp_length_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of transmitted frames less than 64 bytes and reporting a CRC error
        */
        get tx_fragments() {
            return new VScript.rKeyword(this, "tx_fragments", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of transmitted oversized frames reporting a CRC error
        */
        get tx_jabbers() {
            return new VScript.rKeyword(this, "tx_jabbers", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of transmitted packets with FCS errors
        */
        get tx_fcserr() {
            return new VScript.rKeyword(this, "tx_fcserr", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of transmitted frames with a frame of length at least 64, with CRC
          error
        */
        get tx_crcerr_okpkt() {
            return new VScript.rKeyword(this, "tx_crcerr_okpkt", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of errored multicast frames transmitted, excluding control frames
        */
        get tx_mcast_data_err() {
            return new VScript.rKeyword(this, "tx_mcast_data_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of errored broadcast frames transmitted, excluding control frames
        */
        get tx_bcast_data_err() {
            return new VScript.rKeyword(this, "tx_bcast_data_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of errored unicast frames transmitted, excluding control frames
        */
        get tx_ucast_data_err() {
            return new VScript.rKeyword(this, "tx_ucast_data_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of errored multicast control frames transmitted
        */
        get tx_mcast_ctrl_err() {
            return new VScript.rKeyword(this, "tx_mcast_ctrl_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of errored broadcast control frames transmitted
        */
        get tx_bcast_ctrl_err() {
            return new VScript.rKeyword(this, "tx_bcast_ctrl_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of errored unicast control frames transmitted
        */
        get tx_ucast_ctrl_err() {
            return new VScript.rKeyword(this, "tx_ucast_ctrl_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of errored pause frames transmitted
        */
        get tx_pause_err() {
            return new VScript.rKeyword(this, "tx_pause_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of 64-byte transmitted frames, including the CRC field but
          excluding the preamble and SFD bytes
        */
        get tx_64b() {
            return new VScript.rKeyword(this, "tx_64b", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of transmitted frames between 65-127 bytes
        */
        get tx_65to127b() {
            return new VScript.rKeyword(this, "tx_65to127b", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of transmitted frames between 128-255 bytes
        */
        get tx_128to255b() {
            return new VScript.rKeyword(this, "tx_128to255b", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of transmitted frames between 256-511 bytes
        */
        get tx_256to511b() {
            return new VScript.rKeyword(this, "tx_256to511b", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of transmitted frames between 512 –1023 bytes
        */
        get tx_512to1023b() {
            return new VScript.rKeyword(this, "tx_512to1023b", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of transmitted frames between 1024–1518 bytes
        */
        get tx_1024to1518b() {
            return new VScript.rKeyword(this, "tx_1024to1518b", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of transmitted frames between 1519-1536 bytes
        */
        get tx_1519to1536b() {
            return new VScript.rKeyword(this, "tx_1519to1536b", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of oversized frames transmitted
        */
        get tx_oversize() {
            return new VScript.rKeyword(this, "tx_oversize", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of valid multicast frames transmitted, excluding control frames
        */
        get tx_mcast_data_ok() {
            return new VScript.rKeyword(this, "tx_mcast_data_ok", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of valid broadcast frames transmitted, excluding control frames
        */
        get tx_bcast_data_ok() {
            return new VScript.rKeyword(this, "tx_bcast_data_ok", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of valid unicast frames transmitted, excluding control frames
        */
        get tx_ucast_data_ok() {
            return new VScript.rKeyword(this, "tx_ucast_data_ok", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of valid multicast frames transmitted, excluding data frames
        */
        get tx_mcast_ctrl_ok() {
            return new VScript.rKeyword(this, "tx_mcast_ctrl_ok", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of valid broadcast frames transmitted, excluding data frames
        */
        get tx_bcast_ctrl_ok() {
            return new VScript.rKeyword(this, "tx_bcast_ctrl_ok", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of valid unicast frames transmitted, excluding data frames
        */
        get tx_ucast_ctrl_ok() {
            return new VScript.rKeyword(this, "tx_ucast_ctrl_ok", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of transmitted pause frames, with or without error
        */
        get tx_pause() {
            return new VScript.rKeyword(this, "tx_pause", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of transmitted runt packets
        */
        get tx_runt() {
            return new VScript.rKeyword(this, "tx_runt", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of TX frame starts
        */
        get tx_st() {
            return new VScript.rKeyword(this, "tx_st", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of TX length errors
        */
        get tx_lenerr() {
            return new VScript.rKeyword(this, "tx_lenerr", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of TX PFC frame with CRC error
        */
        get tx_pfc_err() {
            return new VScript.rKeyword(this, "tx_pfc_err", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of TX PFC frames without error
        */
        get tx_pfc() {
            return new VScript.rKeyword(this, "tx_pfc", {
                lift: VAPI.EthernetStats.lift.PacketsCounter,
                lower: VAPI.EthernetStats.lower.PacketsCounter
            });
        }
        /**
          Number of transmitted payload bytes in frames with no FCS, undersized,
          oversized, or payload length errors, VLAN/SVLAN header bytes are removed
          from the count
        */
        get tx_payload_octetsok() {
            return new VScript.rKeyword(this, "tx_payload_octetsok", {
                lift: VAPI.EthernetStats.lift.BytesCounter,
                lower: VAPI.EthernetStats.lower.BytesCounter
            });
        }
        /**
          Number of transmitted bytes in frames with no FCS, undersized, oversized,
          or payload length errors
        */
        get tx_frame_octetsok() {
            return new VScript.rKeyword(this, "tx_frame_octetsok", {
                lift: VAPI.EthernetStats.lift.BytesCounter,
                lower: VAPI.EthernetStats.lower.BytesCounter
            });
        }
    }
    EthernetStats.PortStatistics = PortStatistics;
})(EthernetStats || (EthernetStats = {}));
export var Genlock;
(function (Genlock) {
    Genlock.lift = {
        AT1130Genlock: (_raw) => (new AT1130Genlock(_raw)),
        AT1130GenlockBackend: (_raw) => (new AT1130GenlockBackend(_raw)),
        All: (_raw) => (new All(_raw)),
        SingleGenlockState: (_raw, _socket) => {
            return {
                state: _raw[0],
                counters: VAPI.Servos.lift.Counters(_raw[1], _socket),
                anchor: _raw[2] === null ? null : VAPI.Genlock.lift.Anchor(_raw[2], _socket),
                position: _raw[3] === null ? null : VAPI.Genlock.lift.GenlockPosition(_raw[3], _socket),
                slew_rate: _raw[4]
            };
        },
        AT1130GenlockBackendDtNodes: (_raw) => (new AT1130GenlockBackendDtNodes(_raw)),
        AT1130GenlockBackendLanes: (_raw) => (new AT1130GenlockBackendLanes(_raw)),
        AT1130GenlockSettings: (_raw) => (new AT1130GenlockSettings(_raw)),
    };
    Genlock.lower = {
        AT1130Genlock: (_x) => _x.raw.kwl,
        AT1130GenlockBackend: (_x) => _x.raw.kwl,
        All: (_x) => _x.raw.kwl,
        SingleGenlockState: (_x, _socket) => [
            _x.state,
            VAPI.Servos.lower.Counters(_x.counters, _socket),
            _x.anchor === null ? null : VAPI.Genlock.lower.Anchor(_x.anchor, _socket),
            _x.position === null ? null : VAPI.Genlock.lower.GenlockPosition(_x.position, _socket),
            _x.slew_rate
        ],
        AT1130GenlockBackendDtNodes: (_x) => _x.raw.kwl,
        AT1130GenlockBackendLanes: (_x) => _x.raw.kwl,
        AT1130GenlockSettings: (_x) => _x.raw.kwl,
    };
    class AT1130Genlock {
        raw;
        type_identifier = "Genlock::Data::AT1130Genlock";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get settings() {
            return VAPI.AT1130.Genlock.lift.AT1130GenlockSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "settings"));
        }
        get backend() {
            return VAPI.AT1130.Genlock.lift.AT1130GenlockBackend(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "backend"));
        }
    }
    Genlock.AT1130Genlock = AT1130Genlock;
    class AT1130GenlockBackend {
        raw;
        type_identifier = "Genlock::Data::AT1130GenlockBackend";
        constructor(raw) {
            this.raw = raw;
        }
        get lanes() {
            return VAPI.AT1130.Genlock.lift.AT1130GenlockBackendLanes(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "lanes"));
        }
        get dt_nodes() {
            return VAPI.AT1130.Genlock.lift.AT1130GenlockBackendDtNodes(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "dt_nodes"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "ptp_traits"));
        }
        /**
          Most clock control units continuously adjust their target's operating
          frequency until the time and/or frequency offset between source and
          target matches a user-defined value. These units require no data beyond
          frame rate, source type, frequency offset and offset.
          
          However, other clock operations implicitly guarantee synchronicity by
          rigidly linking their target's operating frequency to the source
          frequency. This implicit link may be broken when the timing source
          changes discontinuously. For example, an uncalibrated PTP clock may
          perform arbitrarily large offset and/or frequency jumps, yet after
          reachieving calibration will again report its offset to the internal PTP
          reference frame as 0.0 ± 0.0. To signal such 'timing shocks' to
          consumers, every timing source performing discontinuous changes in a way
          that breaks implicit synchronicity has to increase its continuity_index
          (with wraparound behaviour in the unlikely case of overflow).
        */
        get continuity_index() {
            return new VScript.rKeyword(this, "continuity_index", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get output() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "output"));
        }
    }
    Genlock.AT1130GenlockBackend = AT1130GenlockBackend;
    class All {
        raw;
        type_identifier = "Genlock::Data::All";
        get runtime_constants() {
            return {
                num_physical_audio_genlocks: this.raw.backing_store.get_runtime_constant("Genlock::num_physical_audio_genlocks"),
                num_physical_video_genlocks: this.raw.backing_store.get_runtime_constant("Genlock::num_physical_video_genlocks"),
                num_video_genlocks: this.raw.backing_store.get_runtime_constant("Genlock::num_video_genlocks"),
                num_audio_genlocks: this.raw.backing_store.get_runtime_constant("Genlock::num_audio_genlocks"),
                num_genlocks: this.raw.backing_store.get_runtime_constant("Genlock::num_genlocks")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get instances() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 0, "instances"), (st, _) => VAPI.AT1130.Genlock.lift.AT1130Genlock(st));
        }
        get analog_ref_mgmt() {
            return VAPI.AT1130.Time.lift.AnalogReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "analog_ref_mgmt"));
        }
    }
    Genlock.All = All;
    class AT1130GenlockBackendDtNodes {
        raw;
        type_identifier = "Genlock::Data::AT1130GenlockBackend::DtNodes";
        constructor(raw) {
            this.raw = raw;
        }
        get audio() {
            return new VScript.rKeyword(this, "audio", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get video() {
            return new VScript.rKeyword(this, "video", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
    }
    Genlock.AT1130GenlockBackendDtNodes = AT1130GenlockBackendDtNodes;
    class AT1130GenlockBackendLanes {
        raw;
        type_identifier = "Genlock::Data::AT1130GenlockBackend::Lanes";
        constructor(raw) {
            this.raw = raw;
        }
        get audio() {
            return new VScript.rKeyword(this, "audio", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.Genlock.lift.SingleGenlockState),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.Genlock.lower.SingleGenlockState)
            });
        }
        get video_f50_ish() {
            return new VScript.rKeyword(this, "video_f50_ish", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.Genlock.lift.SingleGenlockState),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.Genlock.lower.SingleGenlockState)
            });
        }
        get video_f59_ish() {
            return new VScript.rKeyword(this, "video_f59_ish", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.Genlock.lift.SingleGenlockState),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.Genlock.lower.SingleGenlockState)
            });
        }
    }
    Genlock.AT1130GenlockBackendLanes = AT1130GenlockBackendLanes;
    class AT1130GenlockSettings {
        raw;
        type_identifier = "Genlock::Data::AT1130Genlock::Settings";
        constructor(raw) {
            this.raw = raw;
        }
        get audio() {
            return VAPI.Genlock.lift.SingleGenlockSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "audio"));
        }
        get video() {
            return VAPI.Genlock.lift.SingleGenlockSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "video"));
        }
    }
    Genlock.AT1130GenlockSettings = AT1130GenlockSettings;
})(Genlock || (Genlock = {}));
export var IOModule;
(function (IOModule) {
    IOModule.lift = {
        All: (_raw) => (new All(_raw)),
        TimingAsynchronous: (_raw, _socket) => {
            return { frequency: _raw[0] };
        },
        HwStatus: (_raw) => (new HwStatus(_raw)),
        MADIInput: (_raw) => (new MADIInput(_raw)),
        SDIPayload: (_raw) => (new SDIPayload(_raw)),
        SDITxPll: (_raw) => (new SDITxPll(_raw)),
        SDIInput: (_raw) => (new SDIInput(_raw)),
        SDIOutput: (_raw) => (new SDIOutput(_raw)),
        TimingSynchronousOrSyntonous: (_raw, _socket) => {
            return {
                genlock: _raw[0] === null ? null : new VAPI.AT1130.Genlock.AT1130Genlock(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                frequency: _raw[1]
            };
        },
        Timing: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "SynchronousOrSyntonous", value: VAPI.AT1130.IOModule.lift.TimingSynchronousOrSyntonous(_raw[1], _socket) };
                case 1: return { variant: "Asynchronous", value: VAPI.AT1130.IOModule.lift.TimingAsynchronous(_raw[1], _socket) };
            }
            ;
        },
        HwStatusEye: (_raw) => (new HwStatusEye(_raw)),
        Input: (_raw) => (new Input(_raw)),
        Merger: (_raw) => (new Merger(_raw)),
        Output: (_raw) => (new Output(_raw)),
        MergerOutput: (_raw) => (new MergerOutput(_raw)),
        SyncOutput: (_raw) => (new SyncOutput(_raw)),
        TxClock: (_raw, _socket) => {
            return {
                role: _raw[0],
                pll: _raw[1] === null ? null : new VAPI.AT1130.IOModule.SDITxPll(VScript.VAPIHelpers.get_subtree(_socket, _raw[1]))
            };
        },
        WclkOutput: (_raw) => (new WclkOutput(_raw)),
    };
    IOModule.lower = {
        All: (_x) => _x.raw.kwl,
        TimingAsynchronous: (_x, _socket) => [
            _x.frequency
        ],
        HwStatus: (_x) => _x.raw.kwl,
        MADIInput: (_x) => _x.raw.kwl,
        SDIPayload: (_x) => _x.raw.kwl,
        SDITxPll: (_x) => _x.raw.kwl,
        SDIInput: (_x) => _x.raw.kwl,
        SDIOutput: (_x) => _x.raw.kwl,
        TimingSynchronousOrSyntonous: (_x, _socket) => [
            _x.genlock === null ? null : _x.genlock.raw.kwl,
            _x.frequency
        ],
        Timing: (_x, _socket) => {
            switch (_x.variant) {
                case "SynchronousOrSyntonous": return [0, VAPI.AT1130.IOModule.lower.TimingSynchronousOrSyntonous(_x.value, _socket)];
                case "Asynchronous": return [1, VAPI.AT1130.IOModule.lower.TimingAsynchronous(_x.value, _socket)];
            }
        },
        HwStatusEye: (_x) => _x.raw.kwl,
        Input: (_x) => _x.raw.kwl,
        Merger: (_x) => _x.raw.kwl,
        Output: (_x) => _x.raw.kwl,
        MergerOutput: (_x) => _x.raw.kwl,
        SyncOutput: (_x) => _x.raw.kwl,
        TxClock: (_x, _socket) => [
            _x.role,
            _x.pll === null ? null : _x.pll.raw.kwl
        ],
        WclkOutput: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "IOModule::Data::All";
        get runtime_constants() {
            return {
                should_deembed_all_metadata: this.raw.backing_store.get_runtime_constant("IOModule::should_deembed_all_metadata"),
                num_sdi_tx_plls: this.raw.backing_store.get_runtime_constant("IOModule::num_sdi_tx_plls"),
                num_metadata_extractors_per_sdi_input: this.raw.backing_store.get_runtime_constant("IOModule::num_metadata_extractors_per_sdi_input")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get info() {
            return VAPI.IOModule.lift.BncMode(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "info"));
        }
        get analog_ref() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "analog_ref"), (raw, _) => VAPI.AT1130.Time.lift.Source(raw));
        }
        get analog_ref_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "analog_ref_traits"));
        }
        get configuration() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 3, "configuration"), (raw, _) => VAPI.IOModule.lift.Configuration(raw));
        }
        get merger() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "merger"), (raw, _) => VAPI.AT1130.IOModule.lift.Merger(raw));
        }
        get output() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 5, "output"), (raw, _) => VAPI.AT1130.IOModule.lift.Output(raw));
        }
        get input() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 6, "input"), (raw, _) => VAPI.AT1130.IOModule.lift.Input(raw));
        }
        get sync_output() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 7, "sync_output"), (raw, _) => VAPI.AT1130.IOModule.lift.SyncOutput(raw));
        }
        get wclk_output() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 8, "wclk_output"), (raw, _) => VAPI.AT1130.IOModule.lift.WclkOutput(raw));
        }
        get sdi_tx_plls() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 9, "sdi_tx_plls"), (st, _) => VAPI.AT1130.IOModule.lift.SDITxPll(st));
        }
    }
    IOModule.All = All;
    class HwStatus {
        raw;
        type_identifier = "IOModule::Data::HwStatus";
        constructor(raw) {
            this.raw = raw;
        }
        get timestamped_signature() {
            return new VScript.rKeyword(this, "timestamped_signature", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lift.TimestampedSignature),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lower.TimestampedSignature)
            });
        }
        get irq_index() {
            return new VScript.rKeyword(this, "irq_index", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get deemb_read_overflow() {
            return new VScript.rKeyword(this, "deemb_read_overflow", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get deemb_read_underflow() {
            return new VScript.rKeyword(this, "deemb_read_underflow", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get deemb_read_running() {
            return new VScript.rKeyword(this, "deemb_read_running", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get phy_rx_locked_status() {
            return new VScript.rKeyword(this, "phy_rx_locked_status", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get phy_rx_calibrate_busy() {
            return new VScript.rKeyword(this, "phy_rx_calibrate_busy", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get phy_rx_locked_status_changed() {
            return new VScript.rKeyword(this, "phy_rx_locked_status_changed", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get smpte_352_c() {
            return new VScript.rKeyword(this, "smpte_352_c", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get smpte_352_y() {
            return new VScript.rKeyword(this, "smpte_352_y", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get h_blank() {
            return new VScript.rKeyword(this, "h_blank", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get h_blank_changed() {
            return new VScript.rKeyword(this, "h_blank_changed", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get h_active() {
            return new VScript.rKeyword(this, "h_active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get h_active_changed() {
            return new VScript.rKeyword(this, "h_active_changed", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get f_period() {
            return new VScript.rKeyword(this, "f_period", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            });
        }
        get interlace() {
            return new VScript.rKeyword(this, "interlace", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get standard() {
            return new VScript.rKeyword(this, "standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get substream_2_s_i() {
            return new VScript.rKeyword(this, "substream_2_s_i", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get input_substream() {
            return new VScript.rKeyword(this, "input_substream", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get eye() {
            return VAPI.AT1130.IOModule.lift.HwStatusEye(VScript.VAPIHelpers.subtree_child_checked(this.raw, 19, "eye"));
        }
    }
    IOModule.HwStatus = HwStatus;
    class MADIInput {
        raw;
        type_identifier = "IOModule::Data::MADIInput";
        constructor(raw) {
            this.raw = raw;
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get fifo_underflow_counter() {
            return new VScript.rKeyword(this, "fifo_underflow_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get fifo_overflow_counter() {
            return new VScript.rKeyword(this, "fifo_overflow_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get clear_fifo_error_counters() {
            return new VScript.wKeyword(this, "clear_fifo_error_counters", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "output"));
        }
    }
    IOModule.MADIInput = MADIInput;
    class SDIPayload {
        raw;
        type_identifier = "IOModule::Data::SDIPayload";
        constructor(raw) {
            this.raw = raw;
        }
        get video() {
            return VAPI.AT1130.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "video"));
        }
        get audio() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "audio"));
        }
        get afd() {
            return new VScript.rKeyword(this, "afd", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lift.AFD),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lower.AFD)
            });
        }
        get cc() {
            return VAPI.Video.lift.ClosedCaption(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "cc"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "ptp_traits"));
        }
    }
    IOModule.SDIPayload = SDIPayload;
    class SDITxPll {
        raw;
        type_identifier = "IOModule::Data::SDITxPll";
        constructor(raw) {
            this.raw = raw;
        }
        get dt_node() {
            return new VScript.rKeyword(this, "dt_node", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get servo() {
            return new VScript.rKeyword(this, "servo", {
                lift: VAPI.Servos.lift.Metrics,
                lower: VAPI.Servos.lower.Metrics
            });
        }
        get num_resets() {
            return new VScript.rKeyword(this, "num_resets", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    IOModule.SDITxPll = SDITxPll;
    class SDIInput {
        raw;
        type_identifier = "IOModule::Data::SDIInput";
        constructor(raw) {
            this.raw = raw;
        }
        get override_pixel_format() {
            return new VScript.rwKeyword(this, "override_pixel_format", {
                lift: VAPI.Video.lift.OverridePixelFormat,
                lower: VAPI.Video.lower.OverridePixelFormat
            }, {
                lift: VAPI.Video.lift.OverridePixelFormat,
                lower: VAPI.Video.lower.OverridePixelFormat
            }, null);
        }
        get sub_stream() {
            return new VScript.dKeyword(this, "sub_stream", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          How to deembed audio from 12G SDI inputs
        */
        get audio_12g_mode() {
            return new VScript.rwKeyword(this, "audio_12g_mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Which closed caption format to decode on input
        */
        get cc_mode() {
            return new VScript.rwKeyword(this, "cc_mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Which line 21 field to decode in CEA708 mode
        */
        get cc_field() {
            return new VScript.rwKeyword(this, "cc_field", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get cc_channel() {
            return new VScript.rwKeyword(this, "cc_channel", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get hw_status() {
            return VAPI.AT1130.IOModule.lift.HwStatus(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "hw_status"));
        }
        get output() {
            return VAPI.AT1130.IOModule.lift.SDIPayload(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "output"));
        }
        get mode() {
            return new VScript.rKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get supports_12g() {
            return new VScript.rKeyword(this, "supports_12g", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          All audio groups which are part of the gang mode are started / stopped
          together. This ensures consistent audio phase for all these groups. All
          enabled groups must be present before de-embedding starts, and when one
          group encounters errors all are reset.
        */
        get deembedder_gang() {
            return new VScript.rwKeyword(this, "deembedder_gang", {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        /**
          @brief restart deembedder
          @desc Restart audio deembedder to synchronize the groups
        */
        get restart_deembedder() {
            return new VScript.wKeyword(this, "restart_deembedder", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get metadata_extractor() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 12, "metadata_extractor"), (raw, _) => VAPI.AT1130.MetadataProcessor.lift.MetadataExtractor(raw));
        }
    }
    IOModule.SDIInput = SDIInput;
    class SDIOutput {
        raw;
        type_identifier = "IOModule::Data::SDIOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get constraints() {
            return VAPI.IOModule.lift.Constraints(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "constraints"));
        }
        get sub_stream() {
            return new VScript.rKeyword(this, "sub_stream", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get standard() {
            return new VScript.rKeyword(this, "standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get supports_12g() {
            return new VScript.rKeyword(this, "supports_12g", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, (parent, command) => (void parent, void command, { criterion: "status", validator: (status) => command === null || VScript.same(command, status) }));
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VAPI.AT1130.Video.lift.TimedSource,
                lower: VAPI.AT1130.Video.lower.TimedSource
            }, {
                lift: VAPI.AT1130.Video.lift.TimedSource,
                lower: VAPI.AT1130.Video.lower.TimedSource
            }, null);
        }
        get phase_target() {
            return new VScript.dKeyword(this, "phase_target", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get in_phase() {
            return new VScript.rKeyword(this, "in_phase", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            });
        }
        get phase_rst_counter() {
            return new VScript.rKeyword(this, "phase_rst_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    different_genlocks: (x & 1) !== 0,
                    input_out_of_linephaser_range: (x & 2) !== 0,
                    missing_t_src: (x & 4) !== 0,
                    no_12g_support: (x & 8) !== 0,
                    std_mismatch: (x & 16) !== 0
                }),
                lower: (x, _) => ((x.different_genlocks ? 1 : 0) |
                    (x.input_out_of_linephaser_range ? 2 : 0) |
                    (x.missing_t_src ? 4 : 0) |
                    (x.no_12g_support ? 8 : 0) |
                    (x.std_mismatch ? 16 : 0))
            });
        }
        get vanc_control() {
            return VAPI.AT1130.Definitions.lift.VancControl(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "vanc_control"));
        }
        get embedded_audio() {
            return new VScript.dKeyword(this, "embedded_audio", {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        /**
          Time when the SDI output was last enabled. Changing the standards or
          disconnecting the video source counts as disabling.
        */
        get last_enable_time() {
            return new VScript.rKeyword(this, "last_enable_time", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftTimestamp),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerTimestamp)
            });
        }
        async set_video_source(x, pars) {
            const options = pars?.timeout !== undefined ? { timeout: pars.timeout } : {};
            let is_null = x === null;
            try {
                if (x === null || x instanceof VAPI.AT1130.Video.Essence) {
                    await this.v_src.command.write({
                        source: x, // FIXME: do we really need this cast?
                        switch_time: null,
                    }, options);
                }
                else {
                    is_null = x.source === null;
                    await this.v_src.command.write(x, options);
                }
                const maybe_essence = x === null ? null : x instanceof VAPI.AT1130.Video.Essence ? x : x.source;
                if (maybe_essence !== null) {
                    const essence_std = await maybe_essence.standard.read();
                    if (essence_std !== null) {
                        let invalidated = false;
                        const w = await maybe_essence.standard.watch((std) => {
                            if (std !== essence_std)
                                invalidated = true;
                        });
                        try {
                            const tx_pll = VScript.enforce_nonnull((await new VAPI.AT1130.IOModule.Output(this.raw.parent).tx_clock.wait_until((maybe_clock) => maybe_clock !== null, options))?.pll);
                            // FIXME: we'd really need to use a massive timeout for far-future
                            // switch_time's, or skip the servo.wait_until stage entirely?
                            await Promise.all([
                                tx_pll.servo.wait_until((servo) => servo.state === "Calibrated", options),
                                this.standard.wait_until((std) => std === essence_std),
                            ]);
                        }
                        catch (e) {
                            if (!invalidated)
                                throw e;
                        }
                        finally {
                            w.unwatch();
                        }
                    }
                }
            }
            catch (e) {
                const v_src_provides_genlock = async () => {
                    VScript.enforce(x !== null);
                    const essence = x instanceof VAPI.AT1130.Video.Essence ? x : x.source;
                    VScript.enforce(essence !== null);
                    return essence.media_clock.genlock.read() !== null;
                };
                if (!this) {
                    throw new Error(`Unable to set video source, as the supplied output instance is null. Please make sure the referenced output exists and, if this is a bidirectional IO module, configured to act as an output`);
                }
                else if (!is_null && (await this.t_src.status.read()) === null) {
                    throw new Error(`Unable to set video source of ${this.raw.kwl}: please set ${this.raw.kwl}.t_src to something non-null`);
                }
                else if (!is_null &&
                    (await new VAPI.AT1130.IOModule.Output(this.raw.parent).tx_clock.read()) === null &&
                    (await v_src_provides_genlock()) === false) {
                    throw new Error(`${this.raw.kwl} has not been assigned a tx_clock; please make sure ${this.raw.kwl}.t_src specifies a valid time source (i.e., one that references a calibrated genlock instance)`);
                }
                else {
                    throw e;
                }
            }
        }
    }
    IOModule.SDIOutput = SDIOutput;
    class HwStatusEye {
        raw;
        type_identifier = "IOModule::Data::HwStatus::Eye";
        constructor(raw) {
            this.raw = raw;
        }
        get eye_measure_time() {
            return new VScript.rwKeyword(this, "eye_measure_time", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        /**
          Generate eye diagram
        */
        get generate() {
            return new VScript.wKeyword(this, "generate", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get progress() {
            return new VScript.rKeyword(this, "progress", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          @brief URL of the eye diagram
          @desc An update to this keyword signals a new eye diagram has been
          generated
        */
        get url() {
            return new VScript.rKeyword(this, "url", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          @brief Measure eye opening only
          @desc Only measure horizontal eye opening (much faster than a full eye)
        */
        get measure_ui() {
            return new VScript.wKeyword(this, "measure_ui", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get ui_measure_time() {
            return new VScript.rwKeyword(this, "ui_measure_time", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get ui() {
            return new VScript.rKeyword(this, "ui", {
                lift: VAPI.IOModule.lift.EyeShape,
                lower: VAPI.IOModule.lower.EyeShape
            });
        }
    }
    IOModule.HwStatusEye = HwStatusEye;
    class Input {
        raw;
        type_identifier = "IOModule::Data::Input";
        constructor(raw) {
            this.raw = raw;
        }
        get mode() {
            return new VScript.dKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get audio_timing() {
            return new VScript.dKeyword(this, "audio_timing", {
                lift: VAPI.AT1130.IOModule.lift.Timing,
                lower: VAPI.AT1130.IOModule.lower.Timing
            }, {
                lift: VAPI.AT1130.IOModule.lift.Timing,
                lower: VAPI.AT1130.IOModule.lower.Timing
            }, (parent, command) => (void parent, void command, { criterion: "status", validator: (status) => (command === null && status === null) || ((command !== null && status !== null) && (command.value.frequency == status.value.frequency) && ((command.variant === 'SynchronousOrSyntonous' && status.variant === 'SynchronousOrSyntonous' && (command.value.genlock === null || VScript.same(command.value.genlock, status.value.genlock))) || (command.variant === 'Asynchronous' && status.variant === 'Asynchronous'))) }));
        }
        get sdi() {
            return VAPI.AT1130.IOModule.lift.SDIInput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "sdi"));
        }
        get madi() {
            return VAPI.AT1130.IOModule.lift.MADIInput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "madi"));
        }
        get audio_source_slices() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 4, "audio_source_slices"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
    }
    IOModule.Input = Input;
    class Merger {
        raw;
        type_identifier = "IOModule::Data::Merger";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          Merger: combines quad-link-2si signals to a single-link UHD signal. The
          corresponding SDI inputs are declared in `connected_to`. The order of the
          substream is adjusted by the information of the payload identifier. To
          set or reorder the substream, use the `sub_stream` parameter
        */
        get substream_2_s_i() {
            return new VScript.rwKeyword(this, "substream_2_s_i", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get connected_to() {
            return VAPI.IOModule.lift.MergerConnectedTo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "connected_to"));
        }
        get output() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "output"), (raw, _) => VAPI.AT1130.IOModule.lift.MergerOutput(raw));
        }
    }
    IOModule.Merger = Merger;
    class Output {
        raw;
        type_identifier = "IOModule::Data::Output";
        constructor(raw) {
            this.raw = raw;
        }
        get mode() {
            return new VScript.dKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Number of times since last enable the output FIFO had to resync (sampled
          only every 100ms)
        */
        get resync_counter() {
            return new VScript.rKeyword(this, "resync_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get sdi() {
            return VAPI.AT1130.IOModule.lift.SDIOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "sdi"));
        }
        get madi() {
            return VAPI.IOModule.lift.MADIOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "madi"));
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VAPI.AT1130.Audio.lift.TimedSource,
                lower: VAPI.AT1130.Audio.lower.TimedSource
            }, {
                lift: VAPI.AT1130.Audio.lift.TimedSource,
                lower: VAPI.AT1130.Audio.lower.TimedSource
            }, null);
        }
        get peak_meter() {
            return new VScript.rKeyword(this, "peak_meter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get tx_pll_group() {
            return new VScript.rKeyword(this, "tx_pll_group", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get tx_clock() {
            return new VScript.rKeyword(this, "tx_clock", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.IOModule.lift.TxClock),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.IOModule.lower.TxClock)
            });
        }
    }
    IOModule.Output = Output;
    class MergerOutput {
        raw;
        type_identifier = "IOModule::Data::Merger::Output";
        constructor(raw) {
            this.raw = raw;
        }
        get video() {
            return VAPI.AT1130.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "video"));
        }
        get audio() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 1, "audio"), (st, _) => VAPI.AT1130.Audio.lift.Essence(st));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "ptp_traits"));
        }
    }
    IOModule.MergerOutput = MergerOutput;
    class SyncOutput {
        raw;
        type_identifier = "IOModule::Data::SyncOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get standard() {
            return new VScript.rwKeyword(this, "standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get phase_rst_counter() {
            return new VScript.rKeyword(this, "phase_rst_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Number of times since last enable the output FIFO had to resync (sampled
          only every 100ms)
        */
        get resync_counter() {
            return new VScript.rKeyword(this, "resync_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    missing_t_src: (x & 1) !== 0
                }),
                lower: (x, _) => ((x.missing_t_src ? 1 : 0))
            });
        }
        get tx_pll_group() {
            return new VScript.rKeyword(this, "tx_pll_group", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get tx_clock() {
            return new VScript.rKeyword(this, "tx_clock", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.IOModule.lift.TxClock),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.IOModule.lower.TxClock)
            });
        }
    }
    IOModule.SyncOutput = SyncOutput;
    class WclkOutput {
        raw;
        type_identifier = "IOModule::Data::WclkOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get source() {
            return new VScript.dKeyword(this, "source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Genlock.AT1130Genlock(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Genlock.AT1130Genlock(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
    }
    IOModule.WclkOutput = WclkOutput;
})(IOModule || (IOModule = {}));
export var J2KDecoder;
(function (J2KDecoder) {
    J2KDecoder.lift = {
        All: (_raw) => (new All(_raw)),
        J2KDecoderChannel: (_raw) => (new J2KDecoderChannel(_raw)),
        J2KDecoderRuntime: (_raw) => (new J2KDecoderRuntime(_raw)),
        J2KDecoderVideoRuntime: (_raw) => (new J2KDecoderVideoRuntime(_raw)),
    };
    J2KDecoder.lower = {
        All: (_x) => _x.raw.kwl,
        J2KDecoderChannel: (_x) => _x.raw.kwl,
        J2KDecoderRuntime: (_x) => _x.raw.kwl,
        J2KDecoderVideoRuntime: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "J2KDecoder::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get decoders() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "decoders"), (raw) => new VAPI.AT1130.J2KDecoder.J2KDecoderChannelAsNamedTableRow(raw));
        }
        get statistics() {
            return VAPI.J2KDecoder.lift.J2KDecoderStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "statistics"));
        }
    }
    J2KDecoder.All = All;
    class J2KDecoderChannel {
        raw;
        type_identifier = "J2KDecoder::Data::J2KDecoderChannel";
        constructor(raw) {
            this.raw = raw;
        }
        get configuration() {
            return VAPI.J2KDecoder.lift.J2KDecoderConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "configuration"));
        }
        get runtime() {
            return VAPI.AT1130.J2KDecoder.lift.J2KDecoderRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "runtime"));
        }
    }
    J2KDecoder.J2KDecoderChannel = J2KDecoderChannel;
    class J2KDecoderChannelAsNamedTableRow extends J2KDecoderChannel {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    J2KDecoder.J2KDecoderChannelAsNamedTableRow = J2KDecoderChannelAsNamedTableRow;
    class J2KDecoderRuntime {
        raw;
        type_identifier = "J2KDecoder::Data::J2KDecoderRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get rtp() {
            return VAPI.J2KDecoder.lift.J2KDecoderRTPRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "rtp"));
        }
        get mpt2() {
            return VAPI.J2KDecoder.lift.J2KDecoderMPT2Runtime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "mpt2"));
        }
        get j2k() {
            return VAPI.J2KDecoder.lift.J2KDecoderJ2KRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "j2k"));
        }
        get video() {
            return VAPI.AT1130.J2KDecoder.lift.J2KDecoderVideoRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "video"));
        }
        get audio() {
            return VAPI.J2KDecoder.lift.J2KDecoderAudioRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "audio"));
        }
        get metadata() {
            return VAPI.J2KDecoder.lift.J2KDecoderMetadataRuntime(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "metadata"));
        }
    }
    J2KDecoder.J2KDecoderRuntime = J2KDecoderRuntime;
    class J2KDecoderVideoRuntime {
        raw;
        type_identifier = "J2KDecoder::Data::J2KDecoderVideoRuntime";
        constructor(raw) {
            this.raw = raw;
        }
        get video_standard() {
            return new VScript.rKeyword(this, "video_standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get signal() {
            return VAPI.AT1130.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "signal"));
        }
    }
    J2KDecoder.J2KDecoderVideoRuntime = J2KDecoderVideoRuntime;
})(J2KDecoder || (J2KDecoder = {}));
export var MasterClock;
(function (MasterClock) {
    MasterClock.lift = {
        All: (_raw) => (new All(_raw)),
        GPSReceiver: (_raw) => (new GPSReceiver(_raw)),
        LTCGenerator: (_raw) => (new LTCGenerator(_raw)),
    };
    MasterClock.lower = {
        All: (_x) => _x.raw.kwl,
        GPSReceiver: (_x) => _x.raw.kwl,
        LTCGenerator: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "MasterClock::Data::All";
        get runtime_constants() {
            return {
                num_ltc_slices: this.raw.backing_store.get_runtime_constant("MasterClock::num_ltc_slices"),
                num_ltc_generators: this.raw.backing_store.get_runtime_constant("MasterClock::num_ltc_generators")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get gps_receivers() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "gps_receivers"), (raw, _) => VAPI.AT1130.MasterClock.lift.GPSReceiver(raw));
        }
        get ltc_generators() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "ltc_generators"), (raw) => new VAPI.AT1130.MasterClock.LTCGeneratorAsNamedTableRow(raw));
        }
        get ltc_slice() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 2, "ltc_slice"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
    }
    MasterClock.All = All;
    class GPSReceiver {
        raw;
        type_identifier = "MasterClock::Data::GPSReceiver";
        constructor(raw) {
            this.raw = raw;
        }
        get date() {
            return new VScript.rKeyword(this, "date", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MasterClock.lift.GPSReceiverDate),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MasterClock.lower.GPSReceiverDate)
            });
        }
        get time_of_day() {
            return new VScript.rKeyword(this, "time_of_day", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MasterClock.lift.GPSReceiverTimeOfDay),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MasterClock.lower.GPSReceiverTimeOfDay)
            });
        }
        get num_satellites() {
            return new VScript.rKeyword(this, "num_satellites", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get used_satellites() {
            return new VScript.rKeyword(this, "used_satellites", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get removed_satellites() {
            return new VScript.rKeyword(this, "removed_satellites", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "ptp_traits"));
        }
        get output() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "output"));
        }
    }
    MasterClock.GPSReceiver = GPSReceiver;
    class LTCGenerator {
        raw;
        type_identifier = "MasterClock::Data::LTCGenerator";
        constructor(raw) {
            this.raw = raw;
        }
        get timezone() {
            return new VScript.dKeyword(this, "timezone", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get custom_timezone_offset() {
            return new VScript.dKeyword(this, "custom_timezone_offset", {
                lift: VAPI.MasterClock.lift.TimezoneOffset,
                lower: VAPI.MasterClock.lower.TimezoneOffset
            }, {
                lift: VAPI.MasterClock.lift.TimezoneOffset,
                lower: VAPI.MasterClock.lower.TimezoneOffset
            }, null);
        }
        get frame_rate() {
            return new VScript.dKeyword(this, "frame_rate", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          * `UTC` (Universal Time, Coordinated) is the standard for wall clock
          time. It is the standard that all timezones are based on. UTC has leap
          seconds to account for differences in the Earth's rotational speed. *When
          in doubt, always use `UTC`*
          
          * `TAI` (International Atomic Time) is the time standard used by PTP. It
          is a linear time standard that does not have leap seconds. TAI is
          currently ahead of UTC by 37 seconds.
        */
        get time_standard() {
            return new VScript.dKeyword(this, "time_standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get reset_counter() {
            return new VScript.rKeyword(this, "reset_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "output"));
        }
    }
    MasterClock.LTCGenerator = LTCGenerator;
    class LTCGeneratorAsNamedTableRow extends LTCGenerator {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    MasterClock.LTCGeneratorAsNamedTableRow = LTCGeneratorAsNamedTableRow;
})(MasterClock || (MasterClock = {}));
export var MetadataProcessor;
(function (MetadataProcessor) {
    MetadataProcessor.lift = {
        All: (_raw) => (new All(_raw)),
        MetadataExtractor: (_raw) => (new MetadataExtractor(_raw)),
        MetadataInserter: (_raw) => (new MetadataInserter(_raw)),
        Request: (_raw) => (new Request(_raw)),
        Response: (_raw) => (new Response(_raw)),
    };
    MetadataProcessor.lower = {
        All: (_x) => _x.raw.kwl,
        MetadataExtractor: (_x) => _x.raw.kwl,
        MetadataInserter: (_x) => _x.raw.kwl,
        Request: (_x) => _x.raw.kwl,
        Response: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "MetadataProcessor::Data::All";
        get runtime_constants() {
            return {
                num_metadata_inserters: this.raw.backing_store.get_runtime_constant("MetadataProcessor::num_metadata_inserters"),
                num_metadata_extractors: this.raw.backing_store.get_runtime_constant("MetadataProcessor::num_metadata_extractors")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get rtp_channel() {
            return new VScript.rKeyword(this, "rtp_channel", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get responses() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "responses"), (raw, _) => VAPI.AT1130.MetadataProcessor.lift.Response(raw));
        }
    }
    MetadataProcessor.All = All;
    class MetadataExtractor {
        raw;
        type_identifier = "MetadataProcessor::Data::MetadataExtractor";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get extractor_type() {
            return new VScript.rKeyword(this, "extractor_type", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get bnc_node() {
            return new VScript.rKeyword(this, "bnc_node", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get media_clock() {
            return new VScript.rKeyword(this, "media_clock", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get standard() {
            return new VScript.rKeyword(this, "standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get rtp_requested() {
            return new VScript.rKeyword(this, "rtp_requested", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get rtp_index() {
            return new VScript.rKeyword(this, "rtp_index", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    MetadataProcessor.MetadataExtractor = MetadataExtractor;
    class MetadataInserter {
        raw;
        type_identifier = "MetadataProcessor::Data::MetadataInserter";
        constructor(raw) {
            this.raw = raw;
        }
        get video_dt_node() {
            return new VScript.rKeyword(this, "video_dt_node", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        get media_clock() {
            return new VScript.rKeyword(this, "media_clock", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get src() {
            return new VScript.dKeyword(this, "src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.MetadataProcessor.MetadataExtractor(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.MetadataProcessor.MetadataExtractor(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get filter() {
            return new VScript.dKeyword(this, "filter", {
                lift: VAPI.MetadataProcessor.lift.Filter,
                lower: VAPI.MetadataProcessor.lower.Filter
            }, {
                lift: VAPI.MetadataProcessor.lift.Filter,
                lower: VAPI.MetadataProcessor.lower.Filter
            }, null);
        }
        get vanc_locations() {
            return new VScript.dKeyword(this, "vanc_locations", {
                lift: VAPI.MetadataProcessor.lift.VANCEmbedderLocations,
                lower: VAPI.MetadataProcessor.lower.VANCEmbedderLocations
            }, {
                lift: VAPI.MetadataProcessor.lift.VANCEmbedderLocations,
                lower: VAPI.MetadataProcessor.lower.VANCEmbedderLocations
            }, null);
        }
        get fine_print() {
            return new VScript.dKeyword(this, "fine_print", {
                lift: VAPI.MetadataProcessor.lift.FinePrint,
                lower: VAPI.MetadataProcessor.lower.FinePrint
            }, {
                lift: VAPI.MetadataProcessor.lift.FinePrint,
                lower: VAPI.MetadataProcessor.lower.FinePrint
            }, null);
        }
    }
    MetadataProcessor.MetadataInserter = MetadataInserter;
    class Request {
        raw;
        type_identifier = "MetadataProcessor::Data::Request";
        constructor(raw) {
            this.raw = raw;
        }
        get inserter_standard() {
            return new VScript.rKeyword(this, "inserter_standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get src() {
            return new VScript.rKeyword(this, "src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.MetadataProcessor.MetadataExtractor(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get dst() {
            return new VScript.rKeyword(this, "dst", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.MetadataProcessor.MetadataInserter(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get filter() {
            return new VScript.rKeyword(this, "filter", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lift.Filter),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lower.Filter)
            });
        }
        get vanc_locations() {
            return new VScript.rKeyword(this, "vanc_locations", {
                lift: VAPI.MetadataProcessor.lift.VANCEmbedderLocations,
                lower: VAPI.MetadataProcessor.lower.VANCEmbedderLocations
            });
        }
        get fine_print() {
            return new VScript.rKeyword(this, "fine_print", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lift.FinePrint),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lower.FinePrint)
            });
        }
    }
    MetadataProcessor.Request = Request;
    class Response {
        raw;
        type_identifier = "MetadataProcessor::Data::Response";
        constructor(raw) {
            this.raw = raw;
        }
        get extractor_standard() {
            return new VScript.rKeyword(this, "extractor_standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get inserter_standard() {
            return new VScript.rKeyword(this, "inserter_standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get src() {
            return new VScript.rKeyword(this, "src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.MetadataProcessor.MetadataExtractor(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get dst() {
            return new VScript.rKeyword(this, "dst", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.MetadataProcessor.MetadataInserter(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get filter() {
            return new VScript.rKeyword(this, "filter", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lift.Filter),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lower.Filter)
            });
        }
        get vanc_locations() {
            return new VScript.rKeyword(this, "vanc_locations", {
                lift: VAPI.MetadataProcessor.lift.VANCEmbedderLocations,
                lower: VAPI.MetadataProcessor.lower.VANCEmbedderLocations
            });
        }
        get fine_print() {
            return new VScript.rKeyword(this, "fine_print", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lift.FinePrint),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.MetadataProcessor.lower.FinePrint)
            });
        }
        get statistics() {
            return new VScript.rKeyword(this, "statistics", {
                lift: VAPI.MetadataProcessor.lift.ResponseStatistics,
                lower: VAPI.MetadataProcessor.lower.ResponseStatistics
            });
        }
        /**
          Metadata inserters generally attempt to match their video stream's
          underlying media clock by delaying the supplied ANC streams accordingly.
          If the desired media clock offset cannot be met because, e.g., the ANC
          stream is already coming in too late, or Timecode/AFD continuity
          requirements force the inserter to soften its mediaclock criterion,
          packets may either be discarded or embedded out-of-phase. In the latter
          case, the mismatch between the embedded ANC stream's de-facto mediaclock
          and its target value is represented by `phase_mismatch`, with negative
          values corresponding to late ANC streams.
        */
        get phase_mismatch() {
            return new VScript.rKeyword(this, "phase_mismatch", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lift.TimestampedOffset),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lower.TimestampedOffset)
            });
        }
    }
    MetadataProcessor.Response = Response;
})(MetadataProcessor || (MetadataProcessor = {}));
export var Monitoring;
(function (Monitoring) {
    Monitoring.lift = {
        All: (_raw) => (new All(_raw)),
        AudioLoudness: (_raw) => (new AudioLoudness(_raw)),
        AudioPhaseCorrelation: (_raw) => (new AudioPhaseCorrelation(_raw)),
        LiveView: (_raw) => (new LiveView(_raw)),
    };
    Monitoring.lower = {
        All: (_x) => _x.raw.kwl,
        AudioLoudness: (_x) => _x.raw.kwl,
        AudioPhaseCorrelation: (_x) => _x.raw.kwl,
        LiveView: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "Monitoring::Data::All";
        get runtime_constants() {
            return {
                num_audio_phase_correlation: this.raw.backing_store.get_runtime_constant("Monitoring::num_audio_phase_correlation"),
                num_audio_loudness_instances: this.raw.backing_store.get_runtime_constant("Monitoring::num_audio_loudness_instances")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get audio() {
            return VAPI.Monitoring.lift.Audio(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "audio"));
        }
        get video() {
            return VAPI.Monitoring.lift.Video(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "video"));
        }
        get live_view() {
            return VAPI.AT1130.Monitoring.lift.LiveView(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "live_view"));
        }
        get correlation() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 3, "correlation"), (raw) => new VAPI.AT1130.Monitoring.AudioPhaseCorrelationAsNamedTableRow(raw));
        }
        get loudness() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 4, "loudness"), (raw) => new VAPI.AT1130.Monitoring.AudioLoudnessAsNamedTableRow(raw));
        }
    }
    Monitoring.All = All;
    class AudioLoudness {
        raw;
        type_identifier = "Monitoring::Data::AudioLoudness";
        constructor(raw) {
            this.raw = raw;
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get channels() {
            return VAPI.Monitoring.lift.AudioLoudnessChannels(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "channels"));
        }
        get mode() {
            return new VScript.dKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Set to false to pause gated_loudness measurement and back to true to
          resume
        */
        get active() {
            return new VScript.dKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          True peak meters
          
          Order: left, right, center, surround_left, surround_right,
          rear_surround_left, rear_surround_right
        */
        get true_peak_meter() {
            return new VScript.rKeyword(this, "true_peak_meter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Measured over the last 400 ms
        */
        get momentary_loudness() {
            return new VScript.rKeyword(this, "momentary_loudness", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Measured over the last 3 s
        */
        get short_term_loudness() {
            return new VScript.rKeyword(this, "short_term_loudness", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get gated_loudness() {
            return new VScript.rKeyword(this, "gated_loudness", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          How much data has been recorded for the gated loudness measurement so far
        */
        get gated_loudness_recorded() {
            return new VScript.rKeyword(this, "gated_loudness_recorded", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            });
        }
        /**
          Reset
        */
        get reset() {
            return new VScript.wKeyword(this, "reset", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    Monitoring.AudioLoudness = AudioLoudness;
    class AudioLoudnessAsNamedTableRow extends AudioLoudness {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    Monitoring.AudioLoudnessAsNamedTableRow = AudioLoudnessAsNamedTableRow;
    class AudioPhaseCorrelation {
        raw;
        type_identifier = "Monitoring::Data::AudioPhaseCorrelation";
        constructor(raw) {
            this.raw = raw;
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get pairs() {
            return new VScript.dKeyword(this, "pairs", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get peak_meter() {
            return new VScript.rKeyword(this, "peak_meter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get correlation() {
            return new VScript.rKeyword(this, "correlation", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    Monitoring.AudioPhaseCorrelation = AudioPhaseCorrelation;
    class AudioPhaseCorrelationAsNamedTableRow extends AudioPhaseCorrelation {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    Monitoring.AudioPhaseCorrelationAsNamedTableRow = AudioPhaseCorrelationAsNamedTableRow;
    class LiveView {
        raw;
        type_identifier = "Monitoring::Data::LiveView";
        constructor(raw) {
            this.raw = raw;
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get timestamped_signature() {
            return new VScript.rKeyword(this, "timestamped_signature", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lift.TimestampedSignature),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lower.TimestampedSignature)
            });
        }
    }
    Monitoring.LiveView = LiveView;
})(Monitoring || (Monitoring = {}));
export var MultiviewerIO;
(function (MultiviewerIO) {
    MultiviewerIO.lift = {
        All: (_raw) => (new All(_raw)),
    };
    MultiviewerIO.lower = { All: (_x) => _x.raw.kwl, };
    class All {
        raw;
        type_identifier = "MultiviewerIO::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get distributed() {
            return VAPI.MultiviewerIO.lift.DistributedMultiviewer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "distributed"));
        }
        get cores() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 1, "cores"), (st, _) => VAPI.MultiviewerIO.lift.ManifoldCore(st));
        }
        get outputs() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 2, "outputs"), (st, _) => VAPI.AT1130.Video.lift.Essence(st));
        }
    }
    MultiviewerIO.All = All;
})(MultiviewerIO || (MultiviewerIO = {}));
export var NetworkInterfaces;
(function (NetworkInterfaces) {
    NetworkInterfaces.lift = {
        PMASettingsManualRxAdaptive: (_raw, _socket) => {
            return {
                profile: _raw[0],
                effort: _raw[1],
                continuous: _raw[2]
            };
        },
        All: (_raw) => (new All(_raw)),
        PMASettingsDisabled: (_raw, _socket) => {
            return {};
        },
        PMASettingsManualRxDisabled: (_raw, _socket) => {
            return {};
        },
        LaneStatistics: (_raw) => (new LaneStatistics(_raw)),
        PMASettingsManual: (_raw, _socket) => {
            return {
                rx: VAPI.AT1130.NetworkInterfaces.lift.PMASettingsManualRx(_raw[0], _socket),
                tx: VAPI.AT1130.NetworkInterfaces.lift.PMASettingsManualTx(_raw[1], _socket)
            };
        },
        PMASettings: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "Disabled", value: VAPI.AT1130.NetworkInterfaces.lift.PMASettingsDisabled(_raw[1], _socket) };
                case 1: return { variant: "RecommendedOptical", value: VAPI.AT1130.NetworkInterfaces.lift.PMASettingsRecommendedOptical(_raw[1], _socket) };
                case 2: return { variant: "RecommendedCopper", value: VAPI.AT1130.NetworkInterfaces.lift.PMASettingsRecommendedCopper(_raw[1], _socket) };
                case 3: return { variant: "Manual", value: VAPI.AT1130.NetworkInterfaces.lift.PMASettingsManual(_raw[1], _socket) };
            }
            ;
        },
        PTPCalibration: (_raw, _socket) => {
            return {
                rx: _raw[0],
                tx: _raw[1],
                rx_ppm: _raw[2],
                tx_ppm: _raw[3]
            };
        },
        Port: (_raw) => (new Port(_raw)),
        RXPMAStatus: (_raw, _socket) => {
            return {
                state: _raw[0],
                lanes: _raw[1].map(el => VAPI.AT1130.NetworkInterfaces.lift.RXPMAStatusLanes(el, _socket))
            };
        },
        PMASettingsRecommendedCopper: (_raw, _socket) => {
            return {};
        },
        PMASettingsRecommendedOptical: (_raw, _socket) => {
            return {};
        },
        RXPMAStatusLanesAdaptationTimes: (_raw, _socket) => {
            return {
                initial: VScript.VAPIHelpers.liftNanoseconds(_raw[0], _socket),
                external: VScript.VAPIHelpers.liftNanoseconds(_raw[1], _socket)
            };
        },
        RXPMAStatusLanes: (_raw, _socket) => {
            return {
                adaptation_times: _raw[0] === null ? null : VAPI.AT1130.NetworkInterfaces.lift.RXPMAStatusLanesAdaptationTimes(_raw[0], _socket),
                freq_locked: _raw[1],
                eye_opening: _raw[2],
                rx_eq: _raw[3] === null ? null : VAPI.AT1130.NetworkInterfaces.lift.RXPMAStatusLanesRxEq(_raw[3], _socket)
            };
        },
        PMASettingsManualRx: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "Disabled", value: VAPI.AT1130.NetworkInterfaces.lift.PMASettingsManualRxDisabled(_raw[1], _socket) };
                case 1: return { variant: "Adaptive", value: VAPI.AT1130.NetworkInterfaces.lift.PMASettingsManualRxAdaptive(_raw[1], _socket) };
            }
            ;
        },
        RXPMAStatusLanesRxEq: (_raw, _socket) => {
            return {
                gain_lf: _raw[0],
                gain_hf: _raw[1],
                rf_b0: _raw[2],
                rf_b1: _raw[3],
                rf_p1: _raw[4],
                rf_p2: _raw[5]
            };
        },
        PMASettingsManualTx: (_raw, _socket) => {
            return {
                pre3: _raw[0],
                pre2: _raw[1],
                pre1: _raw[2],
                main: _raw[3],
                post: _raw[4]
            };
        },
    };
    NetworkInterfaces.lower = {
        PMASettingsManualRxAdaptive: (_x, _socket) => [
            _x.profile,
            _x.effort,
            _x.continuous
        ],
        All: (_x) => _x.raw.kwl,
        PMASettingsDisabled: (_x, _socket) => [],
        PMASettingsManualRxDisabled: (_x, _socket) => [],
        LaneStatistics: (_x) => _x.raw.kwl,
        PMASettingsManual: (_x, _socket) => [
            VAPI.AT1130.NetworkInterfaces.lower.PMASettingsManualRx(_x.rx, _socket),
            VAPI.AT1130.NetworkInterfaces.lower.PMASettingsManualTx(_x.tx, _socket)
        ],
        PMASettings: (_x, _socket) => {
            switch (_x.variant) {
                case "Disabled": return [0, VAPI.AT1130.NetworkInterfaces.lower.PMASettingsDisabled(_x.value, _socket)];
                case "RecommendedOptical": return [1, VAPI.AT1130.NetworkInterfaces.lower.PMASettingsRecommendedOptical(_x.value, _socket)];
                case "RecommendedCopper": return [2, VAPI.AT1130.NetworkInterfaces.lower.PMASettingsRecommendedCopper(_x.value, _socket)];
                case "Manual": return [3, VAPI.AT1130.NetworkInterfaces.lower.PMASettingsManual(_x.value, _socket)];
            }
        },
        PTPCalibration: (_x, _socket) => [
            _x.rx,
            _x.tx,
            _x.rx_ppm,
            _x.tx_ppm
        ],
        Port: (_x) => _x.raw.kwl,
        RXPMAStatus: (_x, _socket) => [
            _x.state,
            _x.lanes.map(el => VAPI.AT1130.NetworkInterfaces.lower.RXPMAStatusLanes(el, _socket))
        ],
        PMASettingsRecommendedCopper: (_x, _socket) => [],
        PMASettingsRecommendedOptical: (_x, _socket) => [],
        RXPMAStatusLanesAdaptationTimes: (_x, _socket) => [
            VScript.VAPIHelpers.lowerNanoseconds(_x.initial, _socket),
            VScript.VAPIHelpers.lowerNanoseconds(_x.external, _socket)
        ],
        RXPMAStatusLanes: (_x, _socket) => [
            _x.adaptation_times === null ? null : VAPI.AT1130.NetworkInterfaces.lower.RXPMAStatusLanesAdaptationTimes(_x.adaptation_times, _socket),
            _x.freq_locked,
            _x.eye_opening,
            _x.rx_eq === null ? null : VAPI.AT1130.NetworkInterfaces.lower.RXPMAStatusLanesRxEq(_x.rx_eq, _socket)
        ],
        PMASettingsManualRx: (_x, _socket) => {
            switch (_x.variant) {
                case "Disabled": return [0, VAPI.AT1130.NetworkInterfaces.lower.PMASettingsManualRxDisabled(_x.value, _socket)];
                case "Adaptive": return [1, VAPI.AT1130.NetworkInterfaces.lower.PMASettingsManualRxAdaptive(_x.value, _socket)];
            }
        },
        RXPMAStatusLanesRxEq: (_x, _socket) => [
            _x.gain_lf,
            _x.gain_hf,
            _x.rf_b0,
            _x.rf_b1,
            _x.rf_p1,
            _x.rf_p2
        ],
        PMASettingsManualTx: (_x, _socket) => [
            _x.pre3,
            _x.pre2,
            _x.pre1,
            _x.main,
            _x.post
        ],
    };
    class All {
        raw;
        type_identifier = "NetworkInterfaces::Data::All";
        get runtime_constants() {
            return {
                max_rx_streams: this.raw.backing_store.get_runtime_constant("NetworkInterfaces::max_rx_streams")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        /**
          Save all interfaces
        */
        get save_config() {
            return new VScript.wKeyword(this, "save_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Revert all interfaces
        */
        get revert_config() {
            return new VScript.wKeyword(this, "revert_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Save all syslog settings
        */
        get save_syslog_config() {
            return new VScript.wKeyword(this, "save_syslog_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Revert all syslog settings
        */
        get revert_syslog_config() {
            return new VScript.wKeyword(this, "revert_syslog_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get ports() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "ports"), (raw, _) => VAPI.AT1130.NetworkInterfaces.lift.Port(raw));
        }
        get hostname() {
            return VAPI.NetworkInterfaces.lift.HostnameConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "hostname"));
        }
        get current_veth_configuration() {
            return VAPI.NetworkInterfaces.lift.CurrentVirtualEthernetConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "current_veth_configuration"));
        }
        get desired_veth_configuration() {
            return VAPI.NetworkInterfaces.lift.DesiredVirtualEthernetConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "desired_veth_configuration"));
        }
        async download_config() {
            return await assemble_config_record(this);
        }
        async upload_config(nc) {
            return await do_upload_config(this.raw.backing_store, nc);
        }
    }
    NetworkInterfaces.All = All;
    class LaneStatistics {
        raw;
        type_identifier = "NetworkInterfaces::Data::LaneStatistics";
        constructor(raw) {
            this.raw = raw;
        }
        get lane() {
            return new VScript.rKeyword(this, "lane", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          maximum throughput (per direction)
        */
        get max_throughput() {
            return new VScript.rKeyword(this, "max_throughput", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get tx_streams() {
            return new VScript.rKeywordReferenceable(this, "tx_streams", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            }, {
                lift: VScript.VAPIHelpers.liftArray(VAPI.EthernetStats.lift.Counter),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.EthernetStats.lower.Counter)
            });
        }
        get tx_all_streams() {
            return new VScript.rKeyword(this, "tx_all_streams", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            });
        }
    }
    NetworkInterfaces.LaneStatistics = LaneStatistics;
    class Port {
        raw;
        type_identifier = "NetworkInterfaces::Data::Port";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get port_id() {
            return new VScript.rKeyword(this, "port_id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get device_name() {
            return new VScript.rKeyword(this, "device_name", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          maximum throughput (per direction)
        */
        get max_throughput() {
            return new VScript.rKeyword(this, "max_throughput", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get port_mode() {
            return new VScript.dKeyword(this, "port_mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get fault_status() {
            return new VScript.rKeyword(this, "fault_status", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get health() {
            return VAPI.NetworkInterfaces.lift.Health(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "health"));
        }
        get phy_link_up() {
            return new VScript.rKeyword(this, "phy_link_up", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get link_up() {
            return new VScript.rKeyword(this, "link_up", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          System runtime since boot
        */
        get link_up_last_changed() {
            return new VScript.rKeyword(this, "link_up_last_changed", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            });
        }
        /**
          How often link_up has changed since boot
        */
        get link_up_changed_count() {
            return new VScript.rKeyword(this, "link_up_changed_count", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          MAC address, stored in big-endian order.
        */
        get mac_address() {
            return new VScript.rKeyword(this, "mac_address", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get supports_ptp() {
            return new VScript.rKeyword(this, "supports_ptp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get supports_rtp() {
            return new VScript.rKeyword(this, "supports_rtp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get ptp_status() {
            return new VScript.rKeyword(this, "ptp_status", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.NetworkInterfaces.lift.PTPCalibration),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.NetworkInterfaces.lower.PTPCalibration)
            });
        }
        /**
          How often PTP calibration had to be restarted
        */
        get ptp_watchdog_count() {
            return new VScript.rKeyword(this, "ptp_watchdog_count", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          @brief Reset ethernet interface
          @desc Enter /eio_sys_rst/ to reset interface and start adaption again
        */
        get eio_sys_rst() {
            return new VScript.rwKeyword(this, "eio_sys_rst", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    pma_settings_change_require_port_reset: (x & 1) !== 0,
                    use_adaptive_pma_settings: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.pma_settings_change_require_port_reset ? 1 : 0) |
                    (x.use_adaptive_pma_settings ? 2 : 0))
            });
        }
        get pma_settings() {
            return new VScript.rwKeyword(this, "pma_settings", {
                lift: VAPI.AT1130.NetworkInterfaces.lift.PMASettings,
                lower: VAPI.AT1130.NetworkInterfaces.lower.PMASettings
            }, {
                lift: VAPI.AT1130.NetworkInterfaces.lift.PMASettings,
                lower: VAPI.AT1130.NetworkInterfaces.lower.PMASettings
            }, null);
        }
        get rx_pma_status() {
            return new VScript.rKeyword(this, "rx_pma_status", {
                lift: VAPI.AT1130.NetworkInterfaces.lift.RXPMAStatus,
                lower: VAPI.AT1130.NetworkInterfaces.lower.RXPMAStatus
            });
        }
        /**
          To execute shell commands on this interface, you will first need to enter
          its hosting network namespace. E.g., if `network_namespace` reads
          `ns_eth0.2`, the following command lists its IP addresses: `ip netns exec
          ns_eth0.2 ip addr show`
        */
        get network_namespace() {
            return new VScript.rKeyword(this, "network_namespace", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get current_configuration() {
            return VAPI.NetworkInterfaces.lift.CurrentPortConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 21, "current_configuration"));
        }
        /**
          Save interface
        */
        get save_config() {
            return new VScript.wKeyword(this, "save_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Revert interface
        */
        get revert_config() {
            return new VScript.wKeyword(this, "revert_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get desired_configuration() {
            return VAPI.NetworkInterfaces.lift.DesiredPortConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 24, "desired_configuration"));
        }
        /**
          Save syslog settings
        */
        get save_syslog_config() {
            return new VScript.wKeyword(this, "save_syslog_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Revert syslog settings
        */
        get revert_syslog_config() {
            return new VScript.wKeyword(this, "revert_syslog_config", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get current_syslog_configuration() {
            return VAPI.NetworkInterfaces.lift.CurrentSyslogConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 27, "current_syslog_configuration"));
        }
        get desired_syslog_configuration() {
            return VAPI.NetworkInterfaces.lift.DesiredSyslogConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 28, "desired_syslog_configuration"));
        }
        get virtual_interfaces() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 29, "virtual_interfaces"), (raw, _) => VAPI.NetworkInterfaces.lift.VirtualInterface(raw));
        }
        /**
          Updated every time a virtual interface is added, removed, or has its list
          of ip addresses changed (not necessarily monotonic, since PTP-derived).
        */
        get last_vifc_change() {
            return new VScript.rKeyword(this, "last_vifc_change", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftTimestamp),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerTimestamp)
            });
        }
        get fpga_lane_statistics() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 31, "fpga_lane_statistics"), (raw, _) => VAPI.AT1130.NetworkInterfaces.lift.LaneStatistics(raw));
        }
        /**
          aggregate statistics as obtained by summing over all of a
          (FPGA-connected) port's internal lanes. Note that management ports never
          report traffic statistics, regardless of their actual activity
        */
        get aggregate_traffic_statistics() {
            return VAPI.AT1130.EthernetStats.lift.PortStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 32, "aggregate_traffic_statistics"));
        }
        get lldp_neighbors() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 33, "lldp_neighbors"), (raw, _) => VAPI.NetworkInterfaces.lift.LLDPNeighbor(raw));
        }
    }
    NetworkInterfaces.Port = Port;
    NetworkInterfaces.Enums = {
        PortMode: ["eth1g", "eth100g", "eth100g_nofec", "eth100g_aui2"],
        PTPCalibrationStatus: ["COLLECTING_INITIAL_HW_PARAMETERS", "INITIAL_CALIBRATION_DONE", "STARTING_PTP_UI_TRACKING", "PTP_UI_TRACKING_ACTIVE", "NO_CALIBRATION_NEEDED"],
        Lane: ["P0", "P1"]
    };
})(NetworkInterfaces || (NetworkInterfaces = {}));
export var PCap;
(function (PCap) {
    PCap.lift = {
        All: (_raw) => (new All(_raw)),
        InternalStateAwaitingReplayStartTime: (_raw, _socket) => {
            return {};
        },
        Instance: (_raw) => (new Instance(_raw)),
        InternalState: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "Established", value: VAPI.AT1130.PCap.lift.Mode(_raw[1], _socket) };
                case 1: return { variant: "AwaitingReplayStartTime", value: VAPI.AT1130.PCap.lift.InternalStateAwaitingReplayStartTime(_raw[1], _socket) };
            }
            ;
        },
        Mode: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "Store", value: VAPI.AT1130.PCap.lift.ModeStore(_raw[1], _socket) };
                case 1: return { variant: "StoreAndForward", value: VAPI.AT1130.PCap.lift.ModeStoreAndForward(_raw[1], _socket) };
                case 2: return { variant: "Replay", value: VAPI.AT1130.PCap.lift.ModeReplay(_raw[1], _socket) };
            }
            ;
        },
        ModeReplay: (_raw, _socket) => {
            return {
                pause_between_loops: _raw[0] === null ? null : VScript.VAPIHelpers.liftNanoseconds(_raw[0], _socket),
                start_time: _raw[1] === null ? null : VScript.VAPIHelpers.liftTimestamp(_raw[1], _socket)
            };
        },
        ModeStore: (_raw, _socket) => {
            return {};
        },
        ModeStoreAndForward: (_raw, _socket) => {
            return {
                min_delay: VScript.VAPIHelpers.liftNanoseconds(_raw[0], _socket),
                jitter: VScript.VAPIHelpers.liftNanoseconds(_raw[1], _socket),
                packet_loss_rate: _raw[2]
            };
        },
    };
    PCap.lower = {
        All: (_x) => _x.raw.kwl,
        InternalStateAwaitingReplayStartTime: (_x, _socket) => [],
        Instance: (_x) => _x.raw.kwl,
        InternalState: (_x, _socket) => {
            switch (_x.variant) {
                case "Established": return [0, VAPI.AT1130.PCap.lower.Mode(_x.value, _socket)];
                case "AwaitingReplayStartTime": return [1, VAPI.AT1130.PCap.lower.InternalStateAwaitingReplayStartTime(_x.value, _socket)];
            }
        },
        Mode: (_x, _socket) => {
            switch (_x.variant) {
                case "Store": return [0, VAPI.AT1130.PCap.lower.ModeStore(_x.value, _socket)];
                case "StoreAndForward": return [1, VAPI.AT1130.PCap.lower.ModeStoreAndForward(_x.value, _socket)];
                case "Replay": return [2, VAPI.AT1130.PCap.lower.ModeReplay(_x.value, _socket)];
            }
        },
        ModeReplay: (_x, _socket) => [
            _x.pause_between_loops === null ? null : VScript.VAPIHelpers.lowerNanoseconds(_x.pause_between_loops, _socket),
            _x.start_time === null ? null : VScript.VAPIHelpers.lowerTimestamp(_x.start_time, _socket)
        ],
        ModeStore: (_x, _socket) => [],
        ModeStoreAndForward: (_x, _socket) => [
            VScript.VAPIHelpers.lowerNanoseconds(_x.min_delay, _socket),
            VScript.VAPIHelpers.lowerNanoseconds(_x.jitter, _socket),
            _x.packet_loss_rate
        ],
    };
    class All {
        raw;
        type_identifier = "PCap::Data::All";
        get runtime_constants() {
            return {
                num_instances: this.raw.backing_store.get_runtime_constant("PCap::num_instances")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get instances() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 0, "instances"), (st, _) => VAPI.AT1130.PCap.lift.Instance(st));
        }
    }
    PCap.All = All;
    class Instance {
        raw;
        type_identifier = "PCap::Data::Instance";
        constructor(raw) {
            this.raw = raw;
        }
        get ingress() {
            return new VScript.rKeyword(this, "ingress", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.NetworkInterfaces.Port(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get egress() {
            return new VScript.rKeyword(this, "egress", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.NetworkInterfaces.Port(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get mode() {
            return new VScript.dKeyword(this, "mode", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.PCap.lift.Mode),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.PCap.lower.Mode)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.PCap.lift.Mode),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.PCap.lower.Mode)
            }, null);
        }
        /**
          Memory area currently holding valid pcap data
        */
        get cur_range() {
            return new VScript.rKeyword(this, "cur_range", {
                lift: VAPI.PCap.lift.MemoryRange,
                lower: VAPI.PCap.lower.MemoryRange
            });
        }
        get pending_dma_transfers() {
            return new VScript.rKeyword(this, "pending_dma_transfers", {
                lift: VAPI.PCap.lift.InstancePendingDmaTransfers,
                lower: VAPI.PCap.lower.InstancePendingDmaTransfers
            });
        }
        get capacity_at_cur_rate() {
            return new VScript.rKeyword(this, "capacity_at_cur_rate", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            });
        }
        get uploaded_file() {
            return VAPI.PCap.lift.FileInfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "uploaded_file"));
        }
        get igmp_memberships() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 7, "igmp_memberships"), (raw) => new VAPI.PCap.IGMPMembershipAsNamedTableRow(raw));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    missing_pcap_file: (x & 1) !== 0,
                    pending_dma_requests: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.missing_pcap_file ? 1 : 0) |
                    (x.pending_dma_requests ? 2 : 0))
            });
        }
    }
    PCap.Instance = Instance;
})(PCap || (PCap = {}));
export var PTPClock;
(function (PTPClock) {
    PTPClock.lift = {
        All: (_raw) => (new All(_raw)),
    };
    PTPClock.lower = { All: (_x) => _x.raw.kwl, };
    class All {
        raw;
        type_identifier = "PTPClock::Data::All";
        get runtime_constants() {
            return {
                allows_clock_randomization: this.raw.backing_store.get_runtime_constant("PTPClock::allows_clock_randomization")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get state() {
            return new VScript.rKeyword(this, "state", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          when `mode` is set to `LockToInput`, the PTP clock will attempt to
          synchronize with the external time source designated by `input`. This is
          the default setting and typically the only option suitable for production
          use.
          
          When `mode` is set to `UseInternalOscillator`, the PTP clock will first
          reset its speed to the nominal clock rate generated by its internal
          oscillator, and in the following suspend all clock control operations.
          Likewise, `Disconnect` suspends all clock control operations but in
          contrast to `UseInternalOscillator` continues to run at the current value
          of `relative_clock_speed`
        */
        get mode() {
            return new VScript.rwKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get statistics() {
            return VAPI.PTPClock.lift.AllStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "statistics"));
        }
        get relative_clock_speed() {
            return new VScript.rKeyword(this, "relative_clock_speed", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get parameters() {
            return VAPI.PTPClock.lift.AllParameters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "parameters"));
        }
        get micro_epochs() {
            return new VScript.rKeyword(this, "micro_epochs", {
                lift: VAPI.PTPClock.lift.MicroEpochs,
                lower: VAPI.PTPClock.lower.MicroEpochs
            });
        }
        get output() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "ptp_traits"));
        }
        /**
          @brief Randomize clock
          @desc Do not push this button
        */
        get randomize_clock() {
            return new VScript.rwKeyword(this, "randomize_clock", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    PTPClock.All = All;
})(PTPClock || (PTPClock = {}));
export var PTPFlows;
(function (PTPFlows) {
    PTPFlows.lift = {
        Agent: (_raw) => (new Agent(_raw)),
        All: (_raw) => (new All(_raw)),
        Master: (_raw) => (new Master(_raw)),
        MasterSettings: (_raw) => (new MasterSettings(_raw)),
        Port: (_raw) => (new Port(_raw)),
        PortBestMasters: (_raw) => (new PortBestMasters(_raw)),
        AgentLatchedVifc: (_raw, _socket) => {
            return {
                vlan_id: _raw[0],
                lane: _raw[1]
            };
        },
        MasterVisibleVia: (_raw) => (new MasterVisibleVia(_raw)),
    };
    PTPFlows.lower = {
        Agent: (_x) => _x.raw.kwl,
        All: (_x) => _x.raw.kwl,
        Master: (_x) => _x.raw.kwl,
        MasterSettings: (_x) => _x.raw.kwl,
        Port: (_x) => _x.raw.kwl,
        PortBestMasters: (_x) => _x.raw.kwl,
        AgentLatchedVifc: (_x, _socket) => [
            _x.vlan_id,
            _x.lane
        ],
        MasterVisibleVia: (_x) => _x.raw.kwl,
    };
    class Agent {
        raw;
        type_identifier = "PTPFlows::Data::Agent";
        constructor(raw) {
            this.raw = raw;
        }
        get mode() {
            return new VScript.rwKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get state() {
            return new VScript.rKeyword(this, "state", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get domain() {
            return new VScript.dKeyword(this, "domain", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get hosting_port() {
            return new VScript.dKeyword(this, "hosting_port", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.PTPFlows.Port(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.PTPFlows.Port(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        /**
          Because port references may be invalidated on changes to the network
          configuration, PTP agents store their lane and VLAN ids instead, and use
          those to either recover hosting port information on startup, or reject
          their configuration as invalid if the previously selected PTP port is no
          longer available
        */
        get latched_vifc() {
            return new VScript.rKeyword(this, "latched_vifc", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.PTPFlows.lift.AgentLatchedVifc),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.PTPFlows.lower.AgentLatchedVifc)
            });
        }
        /**
          best (as defined by the Best Master Clock algorithm) PTP master visible
          on this interface and within this PTP domain, excluding this agent
          itself.
        */
        get best_foreign_master() {
            return new VScript.rKeyword(this, "best_foreign_master", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.PTPFlows.Master(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get slave_settings() {
            return VAPI.PTPFlows.lift.SlaveSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "slave_settings"));
        }
        get master_settings() {
            return VAPI.AT1130.PTPFlows.lift.MasterSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "master_settings"));
        }
        get slave_statistics() {
            return VAPI.PTPFlows.lift.AgentSlaveStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "slave_statistics"));
        }
        get master_statistics() {
            return VAPI.PTPFlows.lift.AgentMasterStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 9, "master_statistics"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    no_delays: (x & 1) !== 0,
                    no_syncs: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.no_delays ? 1 : 0) |
                    (x.no_syncs ? 2 : 0))
            });
        }
        get output() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 11, "output"));
        }
    }
    PTPFlows.Agent = Agent;
    class AgentAsNamedTableRow extends Agent {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    PTPFlows.AgentAsNamedTableRow = AgentAsNamedTableRow;
    class All {
        raw;
        type_identifier = "PTPFlows::Data::All";
        get runtime_constants() {
            return {
                supports_delayresp_in_hardware: this.raw.backing_store.get_runtime_constant("PTPFlows::supports_delayresp_in_hardware")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get general_settings() {
            return VAPI.PTPFlows.lift.AllGeneralSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "general_settings"));
        }
        get agents() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "agents"), (raw) => new VAPI.AT1130.PTPFlows.AgentAsNamedTableRow(raw));
        }
        get ports() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "ports"), (raw, _) => VAPI.AT1130.PTPFlows.lift.Port(raw));
        }
        get visible_masters() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 3, "visible_masters"), (raw, _) => VAPI.AT1130.PTPFlows.lift.Master(raw));
        }
    }
    PTPFlows.All = All;
    class Master {
        raw;
        type_identifier = "PTPFlows::Data::Master";
        constructor(raw) {
            this.raw = raw;
        }
        get gen_address() {
            return new VScript.rKeyword(this, "gen_address", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get evt_address() {
            return new VScript.rKeyword(this, "evt_address", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get visible_via() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "visible_via"), (raw, _) => VAPI.AT1130.PTPFlows.lift.MasterVisibleVia(raw));
        }
        /**
          PTP traits as extracted from the most recently received announce message
        */
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "ptp_traits"));
        }
    }
    PTPFlows.Master = Master;
    class MasterSettings {
        raw;
        type_identifier = "PTPFlows::Data::MasterSettings";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          base-2 logarithm of the announce interval in seconds. E.g., a setting of
          -2 will cause this agent to emit announce messages 4 times a second; 2
          times a second if this is set to -1.
        */
        get log2_announce_interval() {
            return new VScript.dKeyword(this, "log2_announce_interval", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          base-2 logarithm of the sync interval in seconds. E.g., a setting of -3
          will cause this agent to emit sync and followup messages 8 times a
          second; 4 times a second if this is set to -2.
        */
        get log2_sync_interval() {
            return new VScript.dKeyword(this, "log2_sync_interval", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get delay_decimation_factor() {
            return new VScript.rKeyword(this, "delay_decimation_factor", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get grandmaster() {
            return VAPI.PTPFlows.lift.MasterSettingsGrandmaster(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "grandmaster"));
        }
        /**
          unlike sync and follow-up messages, which contain no client-dependent
          information and are thus useful to all clients within their PTP domain,
          delay request/response messages are useful only to the inquiring client
          (and perhaps to the master if it wishes to monitor its clients' timing
          properties). Exchanging these messages via unicast reduces both network
          traffic and local workload but yields otherwise identical results (this
          mode may also be called `Hybrid` on other products). If
          `delay_resp_routing` is set to `Multicast`, all delay responses emitted
          by this agent will be sent to the PTP multicast address `224.0.1.129`
        */
        get delay_resp_routing() {
            return new VScript.dKeyword(this, "delay_resp_routing", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
    }
    PTPFlows.MasterSettings = MasterSettings;
    class Port {
        raw;
        type_identifier = "PTPFlows::Data::Port";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get hosting_interface() {
            return new VScript.rKeyword(this, "hosting_interface", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.VirtualInterface(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get lane() {
            return new VScript.rKeyword(this, "lane", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get port_identity() {
            return new VScript.rKeyword(this, "port_identity", {
                lift: VAPI.PTP.lift.PortIdentity,
                lower: VAPI.PTP.lower.PortIdentity
            });
        }
        get best_masters() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 5, "best_masters"), (st, _) => VAPI.AT1130.PTPFlows.lift.PortBestMasters(st));
        }
        /**
          use this TTL value for all multicast event messages (UDP port 319) sent
          out from this PTP port
        */
        get multicast_event_ttl() {
            return new VScript.dKeyword(this, "multicast_event_ttl", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          use this DSCP for all event messages (UDP port 319) sent out from this
          PTP port
        */
        get event_dscp() {
            return new VScript.dKeyword(this, "event_dscp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          use this TTL value for all general multicast messages (UDP port 320) sent
          out from this PTP port
        */
        get multicast_general_ttl() {
            return new VScript.dKeyword(this, "multicast_general_ttl", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          use this DSCP for all general messages (UDP port 320) sent out from this
          PTP port
        */
        get general_dscp() {
            return new VScript.dKeyword(this, "general_dscp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    denied_general_dscp_request: (x & 1) !== 0,
                    denied_general_ttl_request: (x & 2) !== 0,
                    unresolved_dscp_request: (x & 4) !== 0,
                    unresolved_ttl_request: (x & 8) !== 0,
                    waiting_for_rx_calibration: (x & 16) !== 0,
                    waiting_for_tx_calibration: (x & 32) !== 0
                }),
                lower: (x, _) => ((x.denied_general_dscp_request ? 1 : 0) |
                    (x.denied_general_ttl_request ? 2 : 0) |
                    (x.unresolved_dscp_request ? 4 : 0) |
                    (x.unresolved_ttl_request ? 8 : 0) |
                    (x.waiting_for_rx_calibration ? 16 : 0) |
                    (x.waiting_for_tx_calibration ? 32 : 0))
            });
        }
    }
    PTPFlows.Port = Port;
    class PortBestMasters {
        raw;
        type_identifier = "PTPFlows::Data::Port::BestMasters";
        constructor(raw) {
            this.raw = raw;
        }
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.PTPFlows.Master(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    PTPFlows.PortBestMasters = PortBestMasters;
    class MasterVisibleVia {
        raw;
        type_identifier = "PTPFlows::Data::Master::VisibleVia";
        constructor(raw) {
            this.raw = raw;
        }
        get port() {
            return new VScript.rKeyword(this, "port", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.PTPFlows.Port(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        /**
          time at which an announce message from this master had last been received
          via the referenced port, measured relative to process initialization time
        */
        get announced_at() {
            return new VScript.rKeyword(this, "announced_at", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            });
        }
    }
    PTPFlows.MasterVisibleVia = MasterVisibleVia;
})(PTPFlows || (PTPFlows = {}));
export var Primitives;
(function (Primitives) {
    Primitives.Enums = {
        StreamNetworkPortID: ["PORT0", "PORT1"],
        NetworkPortID: ["FRONT_MANAGEMENT", "REAR_MANAGEMENT", "PORT0", "PORT1"]
    };
})(Primitives || (Primitives = {}));
export var RTPReceiver;
(function (RTPReceiver) {
    RTPReceiver.lift = {
        ReadSpeedAdaptive: (_raw, _socket) => {
            return {};
        },
        AffineNetworkSource: (_raw, _socket) => {
            return {
                source: _raw[0] === null ? null : new VAPI.AT1130.RTPReceiver.NetworkSource(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                seqnr_offset: _raw[1]
            };
        },
        All: (_raw) => (new All(_raw)),
        AncBurstReceiver: (_raw) => (new AncBurstReceiver(_raw)),
        AssociatedStream: (_raw, _socket) => {
            return {
                stream: _raw[0] === null ? null : new VAPI.AT1130.RTPReceiver.PacketStream(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                subflow_index: _raw[1],
                read_delay: _raw[2] === null ? null : VAPI.Time.lift.TimestampedOffset(_raw[2], _socket)
            };
        },
        AudioBackend: (_raw, _socket) => {
            return {
                group: _raw[0],
                instance: _raw[1],
                servo: _raw[2] === null ? null : new VAPI.RTPReceiver.AudioServo(VScript.VAPIHelpers.get_subtree(_socket, _raw[2])),
                slices: _raw[3],
                channel: _raw[4],
                read_indices: VAPI.AT1130.RTPReceiver.lift.AudioReadIndices(_raw[5], _socket),
                fifo_blocks: _raw[6]
            };
        },
        AudioCapabilities: (_raw, _socket) => {
            return {
                channel_capacity: _raw[0],
                payload_limit: _raw[1],
                supports_clean_switching: _raw[2],
                read_speed: VAPI.AT1130.RTPReceiver.lift.ReadSpeed(_raw[3], _socket)
            };
        },
        AudioFlowPartition: (_raw) => (new AudioFlowPartition(_raw)),
        AudioReadIndices: (_raw, _socket) => {
            return {
                primary: _raw[0],
                secondary: _raw[1]
            };
        },
        AudioReceiver: (_raw) => (new AudioReceiver(_raw)),
        TimingTargetBufferMidpoint: (_raw, _socket) => {
            return {};
        },
        BufferProfile: (_raw, _socket) => {
            return {
                channel: _raw[0],
                pseudo_channel: _raw[1],
                blockcount: _raw[2]
            };
        },
        BufferSizes: (_raw, _socket) => {
            return {
                for_audio: _raw[0],
                for_2022_6: _raw[1],
                for_2110_20_uhd_singlelink: _raw[2],
                for_2110_20_other: _raw[3],
                for_2042_2: _raw[4],
                for_jpeg_xs: _raw[5],
                for_passthrough: _raw[6]
            };
        },
        TimingTargetEgressPlusX: (_raw, _socket) => {
            return {
                read_delay: VScript.VAPIHelpers.liftSeconds(_raw[0], _socket)
            };
        },
        TimingTargetForeignMediaClock: (_raw, _socket) => {
            return {
                foreign_receiver: _raw[0] === null ? null : new VAPI.AT1130.RTPReceiver.MediaReceiver(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                extra_delay: VScript.VAPIHelpers.liftSeconds(_raw[1], _socket),
                on_backpressure: _raw[2]
            };
        },
        TimingTargetForeignReadDelay: (_raw, _socket) => {
            return {
                foreign_receiver: _raw[0] === null ? null : new VAPI.AT1130.RTPReceiver.MediaReceiver(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                extra_delay: VScript.VAPIHelpers.liftSeconds(_raw[1], _socket),
                on_backpressure: _raw[2]
            };
        },
        TimingTargetIngressPlusX: (_raw, _socket) => {
            return {
                read_delay: VScript.VAPIHelpers.liftSeconds(_raw[0], _socket)
            };
        },
        JpegXsVideoBackend: (_raw, _socket) => {
            return {
                group: _raw[0],
                instances: _raw[1],
                channel: _raw[2],
                metadata: _raw[3] === null ? null : VAPI.AT1130.RTPReceiver.lift.MetadataBackend(_raw[3], _socket)
            };
        },
        ReadSpeedLockToGenlock: (_raw, _socket) => {
            return {
                genlock: _raw[0] === null ? null : new VAPI.AT1130.Genlock.AT1130Genlock(VScript.VAPIHelpers.get_subtree(_socket, _raw[0]))
            };
        },
        MediaReceiver: (_raw) => (new MediaReceiver(_raw)),
        MemoryChannelInfo: (_raw, _socket) => {
            return {
                channel: _raw[0],
                pseudo_channel: _raw[1],
                connected_to: VAPI.AT1130.RTPReceiver.lift.MemoryChannelInfoConnectedTo(_raw[2], _socket),
                blocks_left: _raw[3]
            };
        },
        MetadataBackend: (_raw, _socket) => {
            return {
                group: _raw[0],
                instance: _raw[1],
                stats_id: VAPI.RTPReceiver.lift.StatsID(_raw[2], _socket),
                read_id: _raw[3],
                channel: _raw[4]
            };
        },
        NativeVideoBackend: (_raw, _socket) => {
            return {
                group: _raw[0],
                instances: _raw[1],
                channel: _raw[2],
                metadata: _raw[3] === null ? null : VAPI.AT1130.RTPReceiver.lift.MetadataBackend(_raw[3], _socket)
            };
        },
        NetworkSource: (_raw) => (new NetworkSource(_raw)),
        PacketStream: (_raw) => (new PacketStream(_raw)),
        PacketTracer: (_raw) => (new PacketTracer(_raw)),
        PassthroughEssence: (_raw) => (new PassthroughEssence(_raw)),
        PassthroughFlowPartition: (_raw) => (new PassthroughFlowPartition(_raw)),
        PassthroughReceiver: (_raw) => (new PassthroughReceiver(_raw)),
        ReadSpeed: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "LockToGenlock", value: VAPI.AT1130.RTPReceiver.lift.ReadSpeedLockToGenlock(_raw[1], _socket) };
                case 1: return { variant: "Adaptive", value: VAPI.AT1130.RTPReceiver.lift.ReadSpeedAdaptive(_raw[1], _socket) };
            }
            ;
        },
        ReserveAudioBackend: (_raw, _socket) => {
            return {
                group: _raw[0],
                instance: _raw[1],
                slices: _raw[2],
                channel: _raw[3],
                read_indices: VAPI.AT1130.RTPReceiver.lift.AudioReadIndices(_raw[4], _socket),
                fifo_blocks: _raw[5],
                fence: _raw[6]
            };
        },
        Session: (_raw) => (new Session(_raw)),
        TimingTargetTimeSource: (_raw, _socket) => {
            return {
                t_src: _raw[0] === null ? null : new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                use_rtp_timestamp: _raw[1]
            };
        },
        Timing: (_raw) => (new Timing(_raw)),
        TimingTarget: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "IngressPlusX", value: VAPI.AT1130.RTPReceiver.lift.TimingTargetIngressPlusX(_raw[1], _socket) };
                case 1: return { variant: "EgressPlusX", value: VAPI.AT1130.RTPReceiver.lift.TimingTargetEgressPlusX(_raw[1], _socket) };
                case 2: return { variant: "TimeSource", value: VAPI.AT1130.RTPReceiver.lift.TimingTargetTimeSource(_raw[1], _socket) };
                case 3: return { variant: "BufferMidpoint", value: VAPI.AT1130.RTPReceiver.lift.TimingTargetBufferMidpoint(_raw[1], _socket) };
                case 4: return { variant: "ForeignReadDelay", value: VAPI.AT1130.RTPReceiver.lift.TimingTargetForeignReadDelay(_raw[1], _socket) };
                case 5: return { variant: "ForeignMediaClock", value: VAPI.AT1130.RTPReceiver.lift.TimingTargetForeignMediaClock(_raw[1], _socket) };
            }
            ;
        },
        VideoBackend: (_raw, _socket) => {
            return {
                native: _raw[0] === null ? null : VAPI.AT1130.RTPReceiver.lift.NativeVideoBackend(_raw[0], _socket),
                jpeg_xs: _raw[1] === null ? null : VAPI.AT1130.RTPReceiver.lift.JpegXsVideoBackend(_raw[1], _socket),
                servo: _raw[2] === null ? null : new VAPI.RTPReceiver.VideoServo(VScript.VAPIHelpers.get_subtree(_socket, _raw[2]))
            };
        },
        VideoCapabilities: (_raw, _socket) => {
            return {
                supports_2022_6: _raw[0],
                supports_uhd_sample_interleaved: _raw[1],
                st2110_20_caliber: _raw[2],
                st2042_2_caliber: _raw[3],
                jpeg_xs_caliber: _raw[4],
                supports_2110_40: _raw[5],
                supports_clean_switching: _raw[6],
                read_speed: VAPI.AT1130.RTPReceiver.lift.ReadSpeed(_raw[7], _socket)
            };
        },
        VideoFlowPartition: (_raw) => (new VideoFlowPartition(_raw)),
        VideoReceiver: (_raw) => (new VideoReceiver(_raw)),
        MemoryChannelInfoConnectedToAudio: (_raw, _socket) => {
            return {
                block: _raw[0],
                fifo_blocks_left: _raw[1]
            };
        },
        MemoryChannelInfoConnectedTo: (_raw, _socket) => {
            return {
                video_native: _raw[0],
                video_jpegxs: _raw[1],
                audio: _raw[2].map(el => el === null ? null : VAPI.AT1130.RTPReceiver.lift.MemoryChannelInfoConnectedToAudio(el, _socket))
            };
        },
        AllDiagnostics: (_raw) => (new AllDiagnostics(_raw)),
        AllDiagnosticsRtpInputFillLevel: (_raw, _socket) => {
            return {
                min: _raw[0],
                max: _raw[1]
            };
        },
        PassthroughReceiverFlowPartitions: (_raw, _socket) => {
            return {
                sdp_a: _raw[0] === null ? null : new VAPI.AT1130.RTPReceiver.PassthroughFlowPartition(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                sdp_b: _raw[1] === null ? null : new VAPI.AT1130.RTPReceiver.PassthroughFlowPartition(VScript.VAPIHelpers.get_subtree(_socket, _raw[1]))
            };
        },
        AudioReceiverMediaSpecificFlowPartitions: (_raw, _socket) => {
            return {
                sdp_a: _raw[0] === null ? null : new VAPI.AT1130.RTPReceiver.AudioFlowPartition(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                sdp_b: _raw[1] === null ? null : new VAPI.AT1130.RTPReceiver.AudioFlowPartition(VScript.VAPIHelpers.get_subtree(_socket, _raw[1]))
            };
        },
        VideoReceiverMediaSpecificFlowPartitions: (_raw, _socket) => {
            return {
                sdp_a: _raw[0] === null ? null : new VAPI.AT1130.RTPReceiver.VideoFlowPartition(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                sdp_b: _raw[1] === null ? null : new VAPI.AT1130.RTPReceiver.VideoFlowPartition(VScript.VAPIHelpers.get_subtree(_socket, _raw[1]))
            };
        },
        AllDiagnosticsIgmpPerformanceMetricsIgmpLatency: (_raw, _socket) => {
            return {
                port: _raw[0],
                src: _raw[1],
                dst: _raw[2],
                time_to_first_mpacket: _raw[3] === null ? null : VScript.VAPIHelpers.liftSeconds(_raw[3], _socket),
                first_rtp_timestamp: _raw[4],
                first_rtp_seqnr: _raw[5],
                mpacket_interval: _raw[6] === null ? null : VScript.VAPIHelpers.liftSeconds(_raw[6], _socket)
            };
        },
        AllDiagnosticsIgmpPerformanceMetrics: (_raw) => (new AllDiagnosticsIgmpPerformanceMetrics(_raw)),
        AncBurstReceiverMediaClock: (_raw) => (new AncBurstReceiverMediaClock(_raw)),
        AudioReceiverMediaSpecific: (_raw) => (new AudioReceiverMediaSpecific(_raw)),
        VideoReceiverMediaSpecific: (_raw) => (new VideoReceiverMediaSpecific(_raw)),
        PassthroughEssenceMemoryBlocks: (_raw, _socket) => {
            return {
                channel: _raw[0],
                blocks: _raw[1]
            };
        },
        AudioReceiverMediaSpecificOutput: (_raw) => (new AudioReceiverMediaSpecificOutput(_raw)),
        VideoReceiverMediaSpecificOutput: (_raw) => (new VideoReceiverMediaSpecificOutput(_raw)),
        MediaReceiverPacketStreams: (_raw) => (new MediaReceiverPacketStreams(_raw)),
        AllDiagnosticsRtpInputPacketsDiscarded: (_raw, _socket) => {
            return {
                input_errors: _raw[0],
                oversized: _raw[1],
                data_fifo_full: _raw[2],
                info_fifo_full: _raw[3]
            };
        },
        AllDiagnosticsRtpInput: (_raw, _socket) => {
            return {
                packets_written: _raw[0],
                packets_discarded: VAPI.AT1130.RTPReceiver.lift.AllDiagnosticsRtpInputPacketsDiscarded(_raw[1], _socket),
                fill_level: VAPI.AT1130.RTPReceiver.lift.AllDiagnosticsRtpInputFillLevel(_raw[2], _socket)
            };
        },
        AllSettings: (_raw) => (new AllSettings(_raw)),
        PacketStreamStreamParameters: (_raw, _socket) => {
            return {
                seqnr_offset: _raw[0],
                src_address: _raw[1],
                dst_address: _raw[2],
                interface: _raw[3] === null ? null : new VAPI.NetworkInterfaces.VirtualInterface(VScript.VAPIHelpers.get_subtree(_socket, _raw[3])),
                type: _raw[4],
                pseudo_channel: _raw[5],
                irq_rate: _raw[6]
            };
        },
    };
    RTPReceiver.lower = {
        ReadSpeedAdaptive: (_x, _socket) => [],
        AffineNetworkSource: (_x, _socket) => [
            _x.source === null ? null : _x.source.raw.kwl,
            _x.seqnr_offset
        ],
        All: (_x) => _x.raw.kwl,
        AncBurstReceiver: (_x) => _x.raw.kwl,
        AssociatedStream: (_x, _socket) => [
            _x.stream === null ? null : _x.stream.raw.kwl,
            _x.subflow_index,
            _x.read_delay === null ? null : VAPI.Time.lower.TimestampedOffset(_x.read_delay, _socket)
        ],
        AudioBackend: (_x, _socket) => [
            _x.group,
            _x.instance,
            _x.servo === null ? null : _x.servo.raw.kwl,
            _x.slices,
            _x.channel,
            VAPI.AT1130.RTPReceiver.lower.AudioReadIndices(_x.read_indices, _socket),
            _x.fifo_blocks
        ],
        AudioCapabilities: (_x, _socket) => [
            _x.channel_capacity,
            _x.payload_limit,
            _x.supports_clean_switching,
            VAPI.AT1130.RTPReceiver.lower.ReadSpeed(_x.read_speed, _socket)
        ],
        AudioFlowPartition: (_x) => _x.raw.kwl,
        AudioReadIndices: (_x, _socket) => [
            _x.primary,
            _x.secondary
        ],
        AudioReceiver: (_x) => _x.raw.kwl,
        TimingTargetBufferMidpoint: (_x, _socket) => [],
        BufferProfile: (_x, _socket) => [
            _x.channel,
            _x.pseudo_channel,
            _x.blockcount
        ],
        BufferSizes: (_x, _socket) => [
            _x.for_audio,
            _x.for_2022_6,
            _x.for_2110_20_uhd_singlelink,
            _x.for_2110_20_other,
            _x.for_2042_2,
            _x.for_jpeg_xs,
            _x.for_passthrough
        ],
        TimingTargetEgressPlusX: (_x, _socket) => [
            VScript.VAPIHelpers.lowerSeconds(_x.read_delay, _socket)
        ],
        TimingTargetForeignMediaClock: (_x, _socket) => [
            _x.foreign_receiver === null ? null : _x.foreign_receiver.raw.kwl,
            VScript.VAPIHelpers.lowerSeconds(_x.extra_delay, _socket),
            _x.on_backpressure
        ],
        TimingTargetForeignReadDelay: (_x, _socket) => [
            _x.foreign_receiver === null ? null : _x.foreign_receiver.raw.kwl,
            VScript.VAPIHelpers.lowerSeconds(_x.extra_delay, _socket),
            _x.on_backpressure
        ],
        TimingTargetIngressPlusX: (_x, _socket) => [
            VScript.VAPIHelpers.lowerSeconds(_x.read_delay, _socket)
        ],
        JpegXsVideoBackend: (_x, _socket) => [
            _x.group,
            _x.instances,
            _x.channel,
            _x.metadata === null ? null : VAPI.AT1130.RTPReceiver.lower.MetadataBackend(_x.metadata, _socket)
        ],
        ReadSpeedLockToGenlock: (_x, _socket) => [
            _x.genlock === null ? null : _x.genlock.raw.kwl
        ],
        MediaReceiver: (_x) => _x.raw.kwl,
        MemoryChannelInfo: (_x, _socket) => [
            _x.channel,
            _x.pseudo_channel,
            VAPI.AT1130.RTPReceiver.lower.MemoryChannelInfoConnectedTo(_x.connected_to, _socket),
            _x.blocks_left
        ],
        MetadataBackend: (_x, _socket) => [
            _x.group,
            _x.instance,
            VAPI.RTPReceiver.lower.StatsID(_x.stats_id, _socket),
            _x.read_id,
            _x.channel
        ],
        NativeVideoBackend: (_x, _socket) => [
            _x.group,
            _x.instances,
            _x.channel,
            _x.metadata === null ? null : VAPI.AT1130.RTPReceiver.lower.MetadataBackend(_x.metadata, _socket)
        ],
        NetworkSource: (_x) => _x.raw.kwl,
        PacketStream: (_x) => _x.raw.kwl,
        PacketTracer: (_x) => _x.raw.kwl,
        PassthroughEssence: (_x) => _x.raw.kwl,
        PassthroughFlowPartition: (_x) => _x.raw.kwl,
        PassthroughReceiver: (_x) => _x.raw.kwl,
        ReadSpeed: (_x, _socket) => {
            switch (_x.variant) {
                case "LockToGenlock": return [0, VAPI.AT1130.RTPReceiver.lower.ReadSpeedLockToGenlock(_x.value, _socket)];
                case "Adaptive": return [1, VAPI.AT1130.RTPReceiver.lower.ReadSpeedAdaptive(_x.value, _socket)];
            }
        },
        ReserveAudioBackend: (_x, _socket) => [
            _x.group,
            _x.instance,
            _x.slices,
            _x.channel,
            VAPI.AT1130.RTPReceiver.lower.AudioReadIndices(_x.read_indices, _socket),
            _x.fifo_blocks,
            _x.fence
        ],
        Session: (_x) => _x.raw.kwl,
        TimingTargetTimeSource: (_x, _socket) => [
            _x.t_src === null ? null : _x.t_src.raw.kwl,
            _x.use_rtp_timestamp
        ],
        Timing: (_x) => _x.raw.kwl,
        TimingTarget: (_x, _socket) => {
            switch (_x.variant) {
                case "IngressPlusX": return [0, VAPI.AT1130.RTPReceiver.lower.TimingTargetIngressPlusX(_x.value, _socket)];
                case "EgressPlusX": return [1, VAPI.AT1130.RTPReceiver.lower.TimingTargetEgressPlusX(_x.value, _socket)];
                case "TimeSource": return [2, VAPI.AT1130.RTPReceiver.lower.TimingTargetTimeSource(_x.value, _socket)];
                case "BufferMidpoint": return [3, VAPI.AT1130.RTPReceiver.lower.TimingTargetBufferMidpoint(_x.value, _socket)];
                case "ForeignReadDelay": return [4, VAPI.AT1130.RTPReceiver.lower.TimingTargetForeignReadDelay(_x.value, _socket)];
                case "ForeignMediaClock": return [5, VAPI.AT1130.RTPReceiver.lower.TimingTargetForeignMediaClock(_x.value, _socket)];
            }
        },
        VideoBackend: (_x, _socket) => [
            _x.native === null ? null : VAPI.AT1130.RTPReceiver.lower.NativeVideoBackend(_x.native, _socket),
            _x.jpeg_xs === null ? null : VAPI.AT1130.RTPReceiver.lower.JpegXsVideoBackend(_x.jpeg_xs, _socket),
            _x.servo === null ? null : _x.servo.raw.kwl
        ],
        VideoCapabilities: (_x, _socket) => [
            _x.supports_2022_6,
            _x.supports_uhd_sample_interleaved,
            _x.st2110_20_caliber,
            _x.st2042_2_caliber,
            _x.jpeg_xs_caliber,
            _x.supports_2110_40,
            _x.supports_clean_switching,
            VAPI.AT1130.RTPReceiver.lower.ReadSpeed(_x.read_speed, _socket)
        ],
        VideoFlowPartition: (_x) => _x.raw.kwl,
        VideoReceiver: (_x) => _x.raw.kwl,
        MemoryChannelInfoConnectedToAudio: (_x, _socket) => [
            _x.block,
            _x.fifo_blocks_left
        ],
        MemoryChannelInfoConnectedTo: (_x, _socket) => [
            _x.video_native,
            _x.video_jpegxs,
            _x.audio.map(el => el === null ? null : VAPI.AT1130.RTPReceiver.lower.MemoryChannelInfoConnectedToAudio(el, _socket))
        ],
        AllDiagnostics: (_x) => _x.raw.kwl,
        AllDiagnosticsRtpInputFillLevel: (_x, _socket) => [
            _x.min,
            _x.max
        ],
        PassthroughReceiverFlowPartitions: (_x, _socket) => [
            _x.sdp_a === null ? null : _x.sdp_a.raw.kwl,
            _x.sdp_b === null ? null : _x.sdp_b.raw.kwl
        ],
        AudioReceiverMediaSpecificFlowPartitions: (_x, _socket) => [
            _x.sdp_a === null ? null : _x.sdp_a.raw.kwl,
            _x.sdp_b === null ? null : _x.sdp_b.raw.kwl
        ],
        VideoReceiverMediaSpecificFlowPartitions: (_x, _socket) => [
            _x.sdp_a === null ? null : _x.sdp_a.raw.kwl,
            _x.sdp_b === null ? null : _x.sdp_b.raw.kwl
        ],
        AllDiagnosticsIgmpPerformanceMetricsIgmpLatency: (_x, _socket) => [
            _x.port,
            _x.src,
            _x.dst,
            _x.time_to_first_mpacket === null ? null : VScript.VAPIHelpers.lowerSeconds(_x.time_to_first_mpacket, _socket),
            _x.first_rtp_timestamp,
            _x.first_rtp_seqnr,
            _x.mpacket_interval === null ? null : VScript.VAPIHelpers.lowerSeconds(_x.mpacket_interval, _socket)
        ],
        AllDiagnosticsIgmpPerformanceMetrics: (_x) => _x.raw.kwl,
        AncBurstReceiverMediaClock: (_x) => _x.raw.kwl,
        AudioReceiverMediaSpecific: (_x) => _x.raw.kwl,
        VideoReceiverMediaSpecific: (_x) => _x.raw.kwl,
        PassthroughEssenceMemoryBlocks: (_x, _socket) => [
            _x.channel,
            _x.blocks
        ],
        AudioReceiverMediaSpecificOutput: (_x) => _x.raw.kwl,
        VideoReceiverMediaSpecificOutput: (_x) => _x.raw.kwl,
        MediaReceiverPacketStreams: (_x) => _x.raw.kwl,
        AllDiagnosticsRtpInputPacketsDiscarded: (_x, _socket) => [
            _x.input_errors,
            _x.oversized,
            _x.data_fifo_full,
            _x.info_fifo_full
        ],
        AllDiagnosticsRtpInput: (_x, _socket) => [
            _x.packets_written,
            VAPI.AT1130.RTPReceiver.lower.AllDiagnosticsRtpInputPacketsDiscarded(_x.packets_discarded, _socket),
            VAPI.AT1130.RTPReceiver.lower.AllDiagnosticsRtpInputFillLevel(_x.fill_level, _socket)
        ],
        AllSettings: (_x) => _x.raw.kwl,
        PacketStreamStreamParameters: (_x, _socket) => [
            _x.seqnr_offset,
            _x.src_address,
            _x.dst_address,
            _x.interface === null ? null : _x.interface.raw.kwl,
            _x.type,
            _x.pseudo_channel,
            _x.irq_rate
        ],
    };
    class All {
        raw;
        type_identifier = "RTPReceiver::Data::All";
        get runtime_constants() {
            return {
                total_2022_6_audio_slices: this.raw.backing_store.get_runtime_constant("RTPReceiver::total_2022_6_audio_slices"),
                supports_2110_40_in_software: this.raw.backing_store.get_runtime_constant("RTPReceiver::supports_2110_40_in_software"),
                max_audio_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_audio_receivers"),
                uhd_packsize_2042_2: this.raw.backing_store.get_runtime_constant("RTPReceiver::uhd_packsize_2042_2"),
                uhd_packsize_2110_20: this.raw.backing_store.get_runtime_constant("RTPReceiver::uhd_packsize_2110_20"),
                supports_2110_40_in_hardware: this.raw.backing_store.get_runtime_constant("RTPReceiver::supports_2110_40_in_hardware"),
                max_metadata_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_metadata_receivers"),
                video_memory_channels: this.raw.backing_store.get_runtime_constant("RTPReceiver::video_memory_channels"),
                num_native_video_receiver_blocks: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_native_video_receiver_blocks"),
                audio_memory_channels: this.raw.backing_store.get_runtime_constant("RTPReceiver::audio_memory_channels"),
                total_2110_30_audio_slices: this.raw.backing_store.get_runtime_constant("RTPReceiver::total_2110_30_audio_slices"),
                max_audio_flow_partitions: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_audio_flow_partitions"),
                max_network_sources: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_network_sources"),
                num_metadata_extractors_per_video_receiver: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_metadata_extractors_per_video_receiver"),
                blocks_per_memory_channel: this.raw.backing_store.get_runtime_constant("RTPReceiver::blocks_per_memory_channel"),
                audio_fifo_blocks_per_memory_channel: this.raw.backing_store.get_runtime_constant("RTPReceiver::audio_fifo_blocks_per_memory_channel"),
                max_st2042_2_uhd_video_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_st2042_2_uhd_video_receivers"),
                max_sessions: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_sessions"),
                num_jpeg_xs_video_receiver_blocks: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_jpeg_xs_video_receiver_blocks"),
                max_passthrough_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_passthrough_receivers"),
                max_video_buffers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_video_buffers"),
                num_packet_tracers: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_packet_tracers"),
                audio_fifo_blocks_per_memory_interface: this.raw.backing_store.get_runtime_constant("RTPReceiver::audio_fifo_blocks_per_memory_interface"),
                max_anc_burst_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_anc_burst_receivers"),
                max_metadata_streams: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_metadata_streams"),
                max_video_flow_partitions: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_video_flow_partitions"),
                max_st2110_20_uhd_video_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_st2110_20_uhd_video_receivers"),
                max_passthrough_flow_partitions: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_passthrough_flow_partitions"),
                has_fixed_audio_pseudo_channel: this.raw.backing_store.get_runtime_constant("RTPReceiver::has_fixed_audio_pseudo_channel"),
                max_native_video_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_native_video_receivers"),
                num_audio_receiver_blocks: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_audio_receiver_blocks"),
                max_video_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_video_receivers"),
                max_metadata_buffers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_metadata_buffers"),
                max_jpeg_xs_video_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_jpeg_xs_video_receivers"),
                num_metadata_receiver_blocks: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_metadata_receiver_blocks"),
                num_audio_servos: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_audio_servos"),
                num_video_servos: this.raw.backing_store.get_runtime_constant("RTPReceiver::num_video_servos"),
                max_st2042_2_video_receivers: this.raw.backing_store.get_runtime_constant("RTPReceiver::max_st2042_2_video_receivers"),
                uhd_packsize_2si: this.raw.backing_store.get_runtime_constant("RTPReceiver::uhd_packsize_2si")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get license_information() {
            return VAPI.RTPReceiver.lift.AllLicenseInformation(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "license_information"));
        }
        get diagnostics() {
            return VAPI.AT1130.RTPReceiver.lift.AllDiagnostics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "diagnostics"));
        }
        get settings() {
            return VAPI.AT1130.RTPReceiver.lift.AllSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "settings"));
        }
        get latest_allocation_id() {
            return new VScript.rKeyword(this, "latest_allocation_id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get sessions() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 4, "sessions"), (raw) => new VAPI.AT1130.RTPReceiver.SessionAsNamedTableRow(raw));
        }
        get audio_receivers() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 5, "audio_receivers"), (raw) => new VAPI.AT1130.RTPReceiver.AudioReceiverAsNamedTableRow(raw));
        }
        get passthrough_receivers() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 6, "passthrough_receivers"), (raw) => new VAPI.AT1130.RTPReceiver.PassthroughReceiverAsNamedTableRow(raw));
        }
        get video_receivers() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 7, "video_receivers"), (raw) => new VAPI.AT1130.RTPReceiver.VideoReceiverAsNamedTableRow(raw));
        }
        get anc_burst_receivers() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 8, "anc_burst_receivers"), (raw) => new VAPI.AT1130.RTPReceiver.AncBurstReceiverAsNamedTableRow(raw));
        }
        get signal_slices_2110_30() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 9, "signal_slices_2110_30"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
        get signal_slices_2022_6() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 10, "signal_slices_2022_6"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
        get packet_streams() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 11, "packet_streams"), (raw, _) => VAPI.AT1130.RTPReceiver.lift.PacketStream(raw));
        }
        get network_sources() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 12, "network_sources"), (raw, _) => VAPI.AT1130.RTPReceiver.lift.NetworkSource(raw));
        }
        get audio_flow_partitions() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 13, "audio_flow_partitions"), (raw, _) => VAPI.AT1130.RTPReceiver.lift.AudioFlowPartition(raw));
        }
        get passthrough_flow_partitions() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 14, "passthrough_flow_partitions"), (raw, _) => VAPI.AT1130.RTPReceiver.lift.PassthroughFlowPartition(raw));
        }
        get video_flow_partitions() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 15, "video_flow_partitions"), (raw, _) => VAPI.AT1130.RTPReceiver.lift.VideoFlowPartition(raw));
        }
        get derived_ptp_traits() {
            return VAPI.RTPReceiver.lift.AllDerivedPtpTraits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 16, "derived_ptp_traits"));
        }
        get audio_servos() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 17, "audio_servos"), (st, _) => VAPI.RTPReceiver.lift.AudioServo(st));
        }
        get video_servos() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 18, "video_servos"), (st, _) => VAPI.RTPReceiver.lift.VideoServo(st));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    out_of_bandwidth: (x & 1) !== 0,
                    required_port_down: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.out_of_bandwidth ? 1 : 0) |
                    (x.required_port_down ? 2 : 0))
            });
        }
    }
    RTPReceiver.All = All;
    class AncBurstReceiver {
        raw;
        type_identifier = "RTPReceiver::Data::AncBurstReceiver";
        constructor(raw) {
            this.raw = raw;
        }
        get generic() {
            return VAPI.AT1130.RTPReceiver.lift.MediaReceiver(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "generic"));
        }
        get media_clock() {
            return VAPI.AT1130.RTPReceiver.lift.AncBurstReceiverMediaClock(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "media_clock"));
        }
    }
    RTPReceiver.AncBurstReceiver = AncBurstReceiver;
    class AncBurstReceiverAsNamedTableRow extends AncBurstReceiver {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPReceiver.AncBurstReceiverAsNamedTableRow = AncBurstReceiverAsNamedTableRow;
    class AudioFlowPartition {
        raw;
        type_identifier = "RTPReceiver::Data::AudioFlowPartition";
        constructor(raw) {
            this.raw = raw;
        }
        get id() {
            return new VScript.rKeyword(this, "id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get format() {
            return new VScript.rKeyword(this, "format", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get frequency() {
            return new VScript.rKeyword(this, "frequency", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get channelcount() {
            return new VScript.rKeyword(this, "channelcount", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get samplecount() {
            return new VScript.rKeyword(this, "samplecount", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Network sources feeding this flow partition; if more than 8 sources feed
          into a single partition, surplus sources will not be published via the
          web interface
        */
        get sources() {
            return new VScript.rKeyword(this, "sources", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AT1130.RTPReceiver.lift.AffineNetworkSource),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AT1130.RTPReceiver.lower.AffineNetworkSource)
            });
        }
    }
    RTPReceiver.AudioFlowPartition = AudioFlowPartition;
    class AudioReceiver {
        raw;
        type_identifier = "RTPReceiver::Data::AudioReceiver";
        constructor(raw) {
            this.raw = raw;
        }
        get generic() {
            return VAPI.AT1130.RTPReceiver.lift.MediaReceiver(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "generic"));
        }
        get media_specific() {
            return VAPI.AT1130.RTPReceiver.lift.AudioReceiverMediaSpecific(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "media_specific"));
        }
    }
    RTPReceiver.AudioReceiver = AudioReceiver;
    class AudioReceiverAsNamedTableRow extends AudioReceiver {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPReceiver.AudioReceiverAsNamedTableRow = AudioReceiverAsNamedTableRow;
    class MediaReceiver {
        raw;
        type_identifier = "RTPReceiver::Data::MediaReceiver";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get tracks() {
            return new VScript.rKeyword(this, "tracks", {
                lift: VAPI.RTPReceiver.lift.UsedReceiverTracks,
                lower: VAPI.RTPReceiver.lower.UsedReceiverTracks
            });
        }
        get main_region_holds() {
            return new VScript.rKeyword(this, "main_region_holds", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get hosting_session() {
            return new VScript.dKeyword(this, "hosting_session", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPReceiver.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPReceiver.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get ingress() {
            return new VScript.rKeyword(this, "ingress", {
                lift: VAPI.RTPReceiver.lift.Ingress,
                lower: VAPI.RTPReceiver.lower.Ingress
            });
        }
        get egress() {
            return new VScript.rKeyword(this, "egress", {
                lift: VAPI.RTPReceiver.lift.Egress,
                lower: VAPI.RTPReceiver.lower.Egress
            });
        }
        get expecting() {
            return new VScript.rKeyword(this, "expecting", {
                lift: VAPI.RTPReceiver.lift.Expectations,
                lower: VAPI.RTPReceiver.lower.Expectations
            });
        }
        /**
          Clear error counters
        */
        get clear_error_counters() {
            return new VScript.wKeyword(this, "clear_error_counters", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Clear event counters
        */
        get clear_event_counters() {
            return new VScript.wKeyword(this, "clear_event_counters", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    impossible_clean_switch_request: (x & 1) !== 0,
                    missing_or_uncalibrated_t_src: (x & 2) !== 0,
                    missing_streams: (x & 4) !== 0,
                    phase_mismatch: (x & 8) !== 0,
                    uncalibrated_genlock: (x & 16) !== 0,
                    undersized_timing_window: (x & 32) !== 0,
                    unsatisfied_capability_request: (x & 64) !== 0,
                    useless_capability_assignment: (x & 128) !== 0
                }),
                lower: (x, _) => ((x.impossible_clean_switch_request ? 1 : 0) |
                    (x.missing_or_uncalibrated_t_src ? 2 : 0) |
                    (x.missing_streams ? 4 : 0) |
                    (x.phase_mismatch ? 8 : 0) |
                    (x.uncalibrated_genlock ? 16 : 0) |
                    (x.undersized_timing_window ? 32 : 0) |
                    (x.unsatisfied_capability_request ? 64 : 0) |
                    (x.useless_capability_assignment ? 128 : 0))
            });
        }
        /**
          Ideally, this keyword shouldn't exist. In practice however, capability
          requests are currently processed eagerly, s.t. the outcome of a
          capability allocation attempt may depend on the order in which individual
          receivers are serviced. To ensure full state recovery across reboots, we
          thus store this ordering explicitly
        */
        get capability_request() {
            return new VScript.rKeyword(this, "capability_request", {
                lift: VAPI.RTPReceiver.lift.CapabilityRequestIDs,
                lower: VAPI.RTPReceiver.lower.CapabilityRequestIDs
            });
        }
        get flight_permit() {
            return VAPI.RTPReceiver.lift.MediaReceiverFlightPermit(VScript.VAPIHelpers.subtree_child_checked(this.raw, 11, "flight_permit"));
        }
        get error_counters() {
            return VAPI.RTPReceiver.lift.MediaReceiverErrorCounters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 12, "error_counters"));
        }
        get event_counters() {
            return VAPI.RTPReceiver.lift.MediaReceiverEventCounters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 13, "event_counters"));
        }
        get preparation_time() {
            return new VScript.dKeyword(this, "preparation_time", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get cooldown_time() {
            return new VScript.dKeyword(this, "cooldown_time", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get timing() {
            return VAPI.AT1130.RTPReceiver.lift.Timing(VScript.VAPIHelpers.subtree_child_checked(this.raw, 16, "timing"));
        }
        get packet_streams() {
            return VAPI.AT1130.RTPReceiver.lift.MediaReceiverPacketStreams(VScript.VAPIHelpers.subtree_child_checked(this.raw, 17, "packet_streams"));
        }
        get required_redundancy_level() {
            return new VScript.rKeyword(this, "required_redundancy_level", {
                lift: VAPI.RTPReceiver.lift.MediaReceiverRequiredRedundancyLevel,
                lower: VAPI.RTPReceiver.lower.MediaReceiverRequiredRedundancyLevel
            });
        }
        get redundancy_levels() {
            return VAPI.RTPReceiver.lift.MediaReceiverRedundancyLevels(VScript.VAPIHelpers.subtree_child_checked(this.raw, 19, "redundancy_levels"));
        }
        get latency_spread() {
            return VAPI.RTPReceiver.lift.MediaReceiverLatencySpread(VScript.VAPIHelpers.subtree_child_checked(this.raw, 20, "latency_spread"));
        }
        /**
          when set to `FirstStreamPresent`, the first packet stream to provide this
          receiver with valid format and timing characteristics will be used as the
          basis for the ensuing readout attempt. When set to `AllStreamsPresent`,
          the receiver will stall until all packet streams have been registered at
          their respective network interfaces. Whereas `FirstStreamPresent` may
          slightly reduce the time to readout, `AllStreamsPresent` is safer as it
          ensures immediate SPS protection (if so configured), and allows the
          receiver to correctly pick a rearguard stream if different network paths
          exhibit different transmission delays. In both cases, the set of packet
          streams considered encompasses only those flows directly referenced by
          this receiver's media description, not the auxiliary flows that may be
          routed to the receiver through stream sharing.
        */
        get initiate_readout_on() {
            return new VScript.dKeyword(this, "initiate_readout_on", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    RTPReceiver.MediaReceiver = MediaReceiver;
    class NetworkSource {
        raw;
        type_identifier = "RTPReceiver::Data::NetworkSource";
        constructor(raw) {
            this.raw = raw;
        }
        get packet_stream() {
            return new VScript.rKeyword(this, "packet_stream", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPReceiver.PacketStream(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPReceiver.NetworkSource = NetworkSource;
    class PacketStream {
        raw;
        type_identifier = "RTPReceiver::Data::PacketStream";
        constructor(raw) {
            this.raw = raw;
        }
        get stream_parameters() {
            return new VScript.rKeyword(this, "stream_parameters", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lift.PacketStreamStreamParameters),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lower.PacketStreamStreamParameters)
            });
        }
        /**
          no. of m-packets received since the last stream start (for audio streams,
          this refers to virtual m-packets). Note that for interlaced video
          streams, this number only includes lower field m-packets, i.e., a 50i
          2110 stream should report 25 m-packets per second.
        */
        get mpackets_received() {
            return new VScript.rKeyword(this, "mpackets_received", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get traffic_stats() {
            return new VScript.rKeyword(this, "traffic_stats", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            });
        }
        get media_clock() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "media_clock"));
        }
    }
    RTPReceiver.PacketStream = PacketStream;
    class PacketTracer {
        raw;
        type_identifier = "RTPReceiver::Data::PacketTracer";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          Set to true to enable realtime packet tracing in one of various modes.
          Note that packet tracing is CPU-intensive, and hence will always come up
          disabled after reboots.
        */
        get active() {
            return new VScript.dKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get mode() {
            return new VScript.dKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Set this to `Store` to have the packet tracer store packet details (up to
          some limited maximum log file size) that can later be downloaded via
          HTTP.
        */
        get packet_details() {
            return new VScript.dKeyword(this, "packet_details", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get filters() {
            return VAPI.RTPReceiver.lift.PacketTracerFilters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "filters"));
        }
        /**
          Reorder up to this many consecutive RTP packets before trying to check
          for missing sequence numbers
        */
        get reordering_depth() {
            return new VScript.dKeyword(this, "reordering_depth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get port() {
            return new VScript.dKeyword(this, "port", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.NetworkInterfaces.Port(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.NetworkInterfaces.Port(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cannot_activate_while_downloading: (x & 1) !== 0,
                    cannot_reconfigure_while_active: (x & 2) !== 0,
                    invalid_port_assignment: (x & 4) !== 0,
                    missing_port_assignment: (x & 8) !== 0,
                    non_ipv4_dst_address: (x & 16) !== 0,
                    non_multicast_dst_address: (x & 32) !== 0,
                    unordered_port_range: (x & 64) !== 0
                }),
                lower: (x, _) => ((x.cannot_activate_while_downloading ? 1 : 0) |
                    (x.cannot_reconfigure_while_active ? 2 : 0) |
                    (x.invalid_port_assignment ? 4 : 0) |
                    (x.missing_port_assignment ? 8 : 0) |
                    (x.non_ipv4_dst_address ? 16 : 0) |
                    (x.non_multicast_dst_address ? 32 : 0) |
                    (x.unordered_port_range ? 64 : 0))
            });
        }
        get cur_run() {
            return new VScript.rKeyword(this, "cur_run", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lift.PacketTracerRun),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lower.PacketTracerRun)
            });
        }
        get prev_run() {
            return new VScript.rKeyword(this, "prev_run", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lift.PacketTracerRun),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lower.PacketTracerRun)
            });
        }
        get num_pending_downloads() {
            return new VScript.rKeyword(this, "num_pending_downloads", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    RTPReceiver.PacketTracer = PacketTracer;
    class PassthroughEssence {
        raw;
        type_identifier = "RTPReceiver::Data::PassthroughEssence";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get stream_id() {
            return new VScript.rKeyword(this, "stream_id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get memory_blocks() {
            return new VScript.rKeyword(this, "memory_blocks", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lift.PassthroughEssenceMemoryBlocks),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lower.PassthroughEssenceMemoryBlocks)
            });
        }
        get sdp() {
            return new VScript.rKeyword(this, "sdp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    RTPReceiver.PassthroughEssence = PassthroughEssence;
    class PassthroughFlowPartition {
        raw;
        type_identifier = "RTPReceiver::Data::PassthroughFlowPartition";
        constructor(raw) {
            this.raw = raw;
        }
        get id() {
            return new VScript.rKeyword(this, "id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Network sources feeding this flow partition; if more than 8 sources feed
          into a single partition, surplus sources will not be published via the
          web interface
        */
        get sources() {
            return new VScript.rKeyword(this, "sources", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AT1130.RTPReceiver.lift.AffineNetworkSource),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AT1130.RTPReceiver.lower.AffineNetworkSource)
            });
        }
    }
    RTPReceiver.PassthroughFlowPartition = PassthroughFlowPartition;
    class PassthroughReceiver {
        raw;
        type_identifier = "RTPReceiver::Data::PassthroughReceiver";
        constructor(raw) {
            this.raw = raw;
        }
        get tracks() {
            return new VScript.rKeyword(this, "tracks", {
                lift: VAPI.RTPReceiver.lift.UsedReceiverTracks,
                lower: VAPI.RTPReceiver.lower.UsedReceiverTracks
            });
        }
        get hosting_session() {
            return new VScript.dKeyword(this, "hosting_session", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPReceiver.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPReceiver.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get ingress() {
            return new VScript.rKeyword(this, "ingress", {
                lift: VAPI.RTPReceiver.lift.Ingress,
                lower: VAPI.RTPReceiver.lower.Ingress
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    subscription_failed: (x & 1) !== 0
                }),
                lower: (x, _) => ((x.subscription_failed ? 1 : 0))
            });
        }
        get output() {
            return VAPI.AT1130.RTPReceiver.lift.PassthroughEssence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "output"));
        }
        get reserved_buffer_id() {
            return new VScript.rKeyword(this, "reserved_buffer_id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Ideally, this keyword shouldn't exist. In practice however, capability
          requests are currently processed eagerly, s.t. the outcome of a
          capability allocation attempt may depend on the order in which individual
          receivers are serviced. To ensure full state recovery across reboots, we
          thus store this ordering explicitly
        */
        get capability_request() {
            return new VScript.rKeyword(this, "capability_request", {
                lift: VAPI.RTPReceiver.lift.CapabilityRequestIDs,
                lower: VAPI.RTPReceiver.lower.CapabilityRequestIDs
            });
        }
        get flow_partitions() {
            return new VScript.rKeyword(this, "flow_partitions", {
                lift: VAPI.AT1130.RTPReceiver.lift.PassthroughReceiverFlowPartitions,
                lower: VAPI.AT1130.RTPReceiver.lower.PassthroughReceiverFlowPartitions
            });
        }
    }
    RTPReceiver.PassthroughReceiver = PassthroughReceiver;
    class PassthroughReceiverAsNamedTableRow extends PassthroughReceiver {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPReceiver.PassthroughReceiverAsNamedTableRow = PassthroughReceiverAsNamedTableRow;
    class Session {
        raw;
        type_identifier = "RTPReceiver::Data::Session";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          A session only supports clean switching if all of its media receivers do
          (see
          `{audio,video}_receivers[*].media_specific.capabilities.supports_clean_switching`)
        */
        get supports_clean_switching() {
            return new VScript.rKeyword(this, "supports_clean_switching", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get switch_type() {
            return new VScript.dKeyword(this, "switch_type", {
                lift: VAPI.RTPReceiver.lift.SwitchType,
                lower: VAPI.RTPReceiver.lower.SwitchType
            }, {
                lift: VAPI.RTPReceiver.lift.SwitchType,
                lower: VAPI.RTPReceiver.lower.SwitchType
            }, null);
        }
        get video_receivers() {
            return new VScript.rKeyword(this, "video_receivers", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPReceiver.VideoReceiver(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get audio_receivers() {
            return new VScript.rKeyword(this, "audio_receivers", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPReceiver.AudioReceiver(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get anc_burst_receivers() {
            return new VScript.rKeyword(this, "anc_burst_receivers", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPReceiver.AncBurstReceiver(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get passthrough_receivers() {
            return new VScript.rKeyword(this, "passthrough_receivers", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPReceiver.PassthroughReceiver(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get active() {
            return new VScript.dKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get sdp_a() {
            return new VScript.dKeyword(this, "sdp_a", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get sdp_b() {
            return new VScript.dKeyword(this, "sdp_b", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get interfaces() {
            return new VScript.dKeyword(this, "interfaces", {
                lift: VAPI.RTPReceiver.lift.SessionInterfaces,
                lower: VAPI.RTPReceiver.lower.SessionInterfaces
            }, {
                lift: VAPI.RTPReceiver.lift.SessionInterfaces,
                lower: VAPI.RTPReceiver.lower.SessionInterfaces
            }, null);
        }
        get used_tracks() {
            return new VScript.rKeyword(this, "used_tracks", {
                lift: VAPI.RTPReceiver.lift.UsedSessionTracks,
                lower: VAPI.RTPReceiver.lower.UsedSessionTracks
            });
        }
        get last_accepted_track() {
            return new VScript.rKeyword(this, "last_accepted_track", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lift.SessionLastAcceptedTrack),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lower.SessionLastAcceptedTrack)
            });
        }
        get event_counters() {
            return VAPI.RTPReceiver.lift.SessionEventCounters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 12, "event_counters"));
        }
        get version_window() {
            return VAPI.RTPReceiver.lift.SessionVersionWindow(VScript.VAPIHelpers.subtree_child_checked(this.raw, 13, "version_window"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    switch_type_request_blocked: (x & 1) !== 0
                }),
                lower: (x, _) => ((x.switch_type_request_blocked ? 1 : 0))
            });
        }
        async set_sdp(track, sdp, pars) {
            // set to something != 0, so sending an unversioned request to a freshly
            // initialized session won't inadvertently come back with the correct
            // response version
            const INIT_VERSION = 10;
            const target_version = ((await this.last_accepted_track.read())?.controller_version ??
                INIT_VERSION) + 1;
            let resolved = false;
            // FIXME: should have another write variant that allows event-driven external resolution, so we
            // could explicitly have watcher's callback declare success on the ensuing write call. The current
            // implementation of set_sdp will perform one unneeded write/check cycle instead
            const watcher = await this.last_accepted_track.watch((new_lat) => {
                if (new_lat?.controller_version === target_version)
                    resolved = true;
            });
            const transformed_sdp = (() => {
                const trimmed = (sdp ?? "").trim();
                if (trimmed.length === 0)
                    return `v=0\no=- 0 0 IN IP4 0.0.0.0\ns=empty\nt=0 0\na=controller-version:${target_version}`;
                const split = split_sdp(trimmed);
                return (split.header +
                    `\na=controller-version:${target_version}\n` +
                    split.media_descriptions.map((md) => md.text).join("\n"));
            })();
            try {
                // FIXME: apparently the RTPReceiverDriver doesn't like trailing newlines??
                await (track === "A" ? this.sdp_a : this.sdp_b).command.write(transformed_sdp.trim(), {
                    retry_until: {
                        criterion: "custom",
                        validator: async () => resolved,
                    },
                    ...(pars ?? {}),
                });
            }
            finally {
                watcher.unwatch();
            }
        }
    }
    RTPReceiver.Session = Session;
    class SessionAsNamedTableRow extends Session {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPReceiver.SessionAsNamedTableRow = SessionAsNamedTableRow;
    class Timing {
        raw;
        type_identifier = "RTPReceiver::Data::Timing";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          If possible, maintain at least this much distance from both buffer ends.
          Note that, to ensure a safe readout, the driver may decide to
          unilaterally increase the minimum safety margin, e.g., to at least 1.5ms
          when running in JPEG-XS mode
        */
        get safety_margin() {
            return new VScript.dKeyword(this, "safety_margin", {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, null);
        }
        /**
          Capacity of the receive buffer, as dictated by buffer settings, packet
          rates and limitations of the statistics engine
        */
        get buffer_capacity() {
            return new VScript.rKeyword(this, "buffer_capacity", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
            });
        }
        get target() {
            return new VScript.dKeyword(this, "target", {
                lift: VAPI.AT1130.RTPReceiver.lift.TimingTarget,
                lower: VAPI.AT1130.RTPReceiver.lower.TimingTarget
            }, {
                lift: VAPI.AT1130.RTPReceiver.lift.TimingTarget,
                lower: VAPI.AT1130.RTPReceiver.lower.TimingTarget
            }, null);
        }
        /**
          estimated time until |distance to buffer boundary| < 0.5 *
          `safety_margin`
        */
        get expected_time_to_collision() {
            return new VScript.rKeyword(this, "expected_time_to_collision", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
            });
        }
        get read_delay() {
            return VAPI.RTPReceiver.lift.TimingReadDelay(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "read_delay"));
        }
        get read_delay_bounds() {
            return new VScript.dKeyword(this, "read_delay_bounds", {
                lift: VAPI.RTPReceiver.lift.TimingReadDelayBounds,
                lower: VAPI.RTPReceiver.lower.TimingReadDelayBounds
            }, {
                lift: VAPI.RTPReceiver.lift.TimingReadDelayBounds,
                lower: VAPI.RTPReceiver.lower.TimingReadDelayBounds
            }, null);
        }
        get current_phase() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "current_phase"));
        }
        get safety_mismatch() {
            return new VScript.rKeyword(this, "safety_mismatch", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftSeconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerSeconds)
            });
        }
        get phase_control() {
            return VAPI.RTPReceiver.lift.TimingPhaseControl(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "phase_control"));
        }
        /**
          delay readout of newly incoming streams until at least this many mpackets
          have been received. While this increases readout latency, this may also
          improve robustness if there is reason to believe that stream setup may
          sometimes be 'dirty' (e.g., with gaps within the first few received video
          frames)
        */
        get mpackets_warmup() {
            return new VScript.rwKeyword(this, "mpackets_warmup", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    RTPReceiver.Timing = Timing;
    class VideoFlowPartition {
        raw;
        type_identifier = "RTPReceiver::Data::VideoFlowPartition";
        constructor(raw) {
            this.raw = raw;
        }
        get id() {
            return new VScript.rKeyword(this, "id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get sdp_standard() {
            return new VScript.rKeyword(this, "sdp_standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get fmt_standard() {
            return new VScript.rKeyword(this, "fmt_standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get transport_format() {
            return new VScript.rKeyword(this, "transport_format", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Network sources feeding this flow partition; if more than 8 sources feed
          into a single partition, surplus sources will not be published via the
          web interface
        */
        get sources() {
            return new VScript.rKeyword(this, "sources", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AT1130.RTPReceiver.lift.AffineNetworkSource),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AT1130.RTPReceiver.lower.AffineNetworkSource)
            });
        }
    }
    RTPReceiver.VideoFlowPartition = VideoFlowPartition;
    class VideoReceiver {
        raw;
        type_identifier = "RTPReceiver::Data::VideoReceiver";
        constructor(raw) {
            this.raw = raw;
        }
        get generic() {
            return VAPI.AT1130.RTPReceiver.lift.MediaReceiver(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "generic"));
        }
        get media_specific() {
            return VAPI.AT1130.RTPReceiver.lift.VideoReceiverMediaSpecific(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "media_specific"));
        }
    }
    RTPReceiver.VideoReceiver = VideoReceiver;
    class VideoReceiverAsNamedTableRow extends VideoReceiver {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPReceiver.VideoReceiverAsNamedTableRow = VideoReceiverAsNamedTableRow;
    class AllDiagnostics {
        raw;
        type_identifier = "RTPReceiver::Data::All::Diagnostics";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          Clear traffic statistics
        */
        get clear_traffic_stats() {
            return new VScript.wKeyword(this, "clear_traffic_stats", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Clear input stage statistics
        */
        get clear_input_statistics() {
            return new VScript.wKeyword(this, "clear_input_statistics", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get aggregate_traffic_stats() {
            return new VScript.rKeyword(this, "aggregate_traffic_stats", {
                lift: VAPI.EthernetStats.lift.Counter,
                lower: VAPI.EthernetStats.lower.Counter
            });
        }
        get memory_channels() {
            return new VScript.rKeyword(this, "memory_channels", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AT1130.RTPReceiver.lift.MemoryChannelInfo),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AT1130.RTPReceiver.lower.MemoryChannelInfo)
            });
        }
        get rtp_input() {
            return new VScript.rKeyword(this, "rtp_input", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lift.AllDiagnosticsRtpInput))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lower.AllDiagnosticsRtpInput)))
            });
        }
        get mpacket_tracer() {
            return VAPI.RTPReceiver.lift.AllDiagnosticsMpacketTracer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "mpacket_tracer"));
        }
        get packet_tracers() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 6, "packet_tracers"), (st, _) => VAPI.AT1130.RTPReceiver.lift.PacketTracer(st));
        }
        get igmp_performance_metrics() {
            return VAPI.AT1130.RTPReceiver.lift.AllDiagnosticsIgmpPerformanceMetrics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "igmp_performance_metrics"));
        }
        /**
          Enable this option to have the receiver log every readout attempt to
          syslog. Potentially useful for debugging but very verbose, so you'll
          probably want to keep this disabled in production.
        */
        get log_readout_requests() {
            return new VScript.rwKeyword(this, "log_readout_requests", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Enable this option to have the receiver log every IGMP join/leave request
          to syslog. Potentially useful for debugging but very verbose, so you'll
          probably want to keep this disabled in production.
        */
        get log_igmp_requests() {
            return new VScript.rwKeyword(this, "log_igmp_requests", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    RTPReceiver.AllDiagnostics = AllDiagnostics;
    class AllDiagnosticsIgmpPerformanceMetrics {
        raw;
        type_identifier = "RTPReceiver::Data::All::Diagnostics::IgmpPerformanceMetrics";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          emit warning message if the time elapsed between an outgoing IGMP join
          request and the arrival of the first corresponding packet (estimated
          conservatively as `time_to_first_mpacket - mpacket_interval`) exceeds
          `warning_threshold`. Note that for interlaced 2110/2042 streams,
          upper-field mpackets are not considered.
        */
        get warning_threshold() {
            return new VScript.rwKeyword(this, "warning_threshold", {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, null);
        }
        get igmp_latency() {
            return new VScript.rKeyword(this, "igmp_latency", {
                lift: VAPI.AT1130.RTPReceiver.lift.AllDiagnosticsIgmpPerformanceMetricsIgmpLatency,
                lower: VAPI.AT1130.RTPReceiver.lower.AllDiagnosticsIgmpPerformanceMetricsIgmpLatency
            });
        }
    }
    RTPReceiver.AllDiagnosticsIgmpPerformanceMetrics = AllDiagnosticsIgmpPerformanceMetrics;
    class AncBurstReceiverMediaClock {
        raw;
        type_identifier = "RTPReceiver::Data::AncBurstReceiver::MediaClock";
        constructor(raw) {
            this.raw = raw;
        }
        get ingress() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "ingress"));
        }
        get egress() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "egress"));
        }
    }
    RTPReceiver.AncBurstReceiverMediaClock = AncBurstReceiverMediaClock;
    class AudioReceiverMediaSpecific {
        raw;
        type_identifier = "RTPReceiver::Data::AudioReceiver::MediaSpecific";
        constructor(raw) {
            this.raw = raw;
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lift.AudioCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lower.AudioCapabilities)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lift.AudioCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lower.AudioCapabilities)
            }, null);
        }
        get backend() {
            return new VScript.rKeyword(this, "backend", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lift.AudioBackend),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lower.AudioBackend)
            });
        }
        get flow_partitions() {
            return new VScript.rKeyword(this, "flow_partitions", {
                lift: VAPI.AT1130.RTPReceiver.lift.AudioReceiverMediaSpecificFlowPartitions,
                lower: VAPI.AT1130.RTPReceiver.lower.AudioReceiverMediaSpecificFlowPartitions
            });
        }
        get output() {
            return VAPI.AT1130.RTPReceiver.lift.AudioReceiverMediaSpecificOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "output"));
        }
    }
    RTPReceiver.AudioReceiverMediaSpecific = AudioReceiverMediaSpecific;
    class VideoReceiverMediaSpecific {
        raw;
        type_identifier = "RTPReceiver::Data::VideoReceiver::MediaSpecific";
        constructor(raw) {
            this.raw = raw;
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lift.VideoCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lower.VideoCapabilities)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lift.VideoCapabilities),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lower.VideoCapabilities)
            }, null);
        }
        get backend() {
            return new VScript.rKeyword(this, "backend", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lift.VideoBackend),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.AT1130.RTPReceiver.lower.VideoBackend)
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    audio_deembedder_errors: (x & 1) !== 0,
                    drop_repeat_frames: (x & 2) !== 0,
                    misaligned_anc_data: (x & 4) !== 0,
                    no_bbm_capabilities: (x & 8) !== 0,
                    video_decoding_errors: (x & 16) !== 0
                }),
                lower: (x, _) => ((x.audio_deembedder_errors ? 1 : 0) |
                    (x.drop_repeat_frames ? 2 : 0) |
                    (x.misaligned_anc_data ? 4 : 0) |
                    (x.no_bbm_capabilities ? 8 : 0) |
                    (x.video_decoding_errors ? 16 : 0))
            });
        }
        get error_counters() {
            return VAPI.RTPReceiver.lift.VideoReceiverMediaSpecificErrorCounters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "error_counters"));
        }
        get event_counters() {
            return VAPI.RTPReceiver.lift.VideoReceiverMediaSpecificEventCounters(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "event_counters"));
        }
        /**
          Reset 2022-6 audio deembedder
        */
        get reset_audio_deembedder() {
            return new VScript.wKeyword(this, "reset_audio_deembedder", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get flow_partitions() {
            return new VScript.rKeyword(this, "flow_partitions", {
                lift: VAPI.AT1130.RTPReceiver.lift.VideoReceiverMediaSpecificFlowPartitions,
                lower: VAPI.AT1130.RTPReceiver.lower.VideoReceiverMediaSpecificFlowPartitions
            });
        }
        get output() {
            return VAPI.AT1130.RTPReceiver.lift.VideoReceiverMediaSpecificOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "output"));
        }
        /**
          when this is set to true, a timestamped CRC32 signature of every emitted
          video frame will be published via `signature`
        */
        get publish_signature() {
            return new VScript.rwKeyword(this, "publish_signature", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get timestamped_signature() {
            return new VScript.rKeyword(this, "timestamped_signature", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lift.TimestampedSignature),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lower.TimestampedSignature)
            });
        }
        get hard_metadata_decoder() {
            return VAPI.RTPReceiver.lift.VideoReceiverMediaSpecificHardMetadataDecoder(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "hard_metadata_decoder"));
        }
        get soft_metadata_decoder() {
            return VAPI.RTPReceiver.lift.VideoReceiverMediaSpecificSoftMetadataDecoder(VScript.VAPIHelpers.subtree_child_checked(this.raw, 11, "soft_metadata_decoder"));
        }
        get soft_metadata_extractor() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 12, "soft_metadata_extractor"), (raw, _) => VAPI.AT1130.MetadataProcessor.lift.MetadataExtractor(raw));
        }
        /**
          Single video substreams pertaining to a quadlink UHD flow may be
          subscribed to independently, and used as separate 3G streams instead. By
          default, the resulting 3G video essences will be stripped of their
          substream attributes, which affects SDPs generated on retransmission, as
          well as 352 payloads. If you wish to retain original substream
          attributes, set this setting to `PropagateSubstreamAttribute` (but note
          that this setting only takes effect on readout).
        */
        get on_isolated_substream() {
            return new VScript.dKeyword(this, "on_isolated_substream", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          When non-null, this keyword holds decoder state as inferred from
          currently received streams, or as obtained from the underlying hardware
          decoder at runtime.
        */
        get cur_decoder_ws() {
            return new VScript.rKeyword(this, "cur_decoder_ws", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lift.SingleVideoDecoderWorkingSet),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.RTPReceiver.lower.SingleVideoDecoderWorkingSet)
            });
        }
    }
    RTPReceiver.VideoReceiverMediaSpecific = VideoReceiverMediaSpecific;
    class AudioReceiverMediaSpecificOutput {
        raw;
        type_identifier = "RTPReceiver::Data::AudioReceiver::MediaSpecific::Output";
        constructor(raw) {
            this.raw = raw;
        }
        get audio() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "audio"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "ptp_traits"));
        }
    }
    RTPReceiver.AudioReceiverMediaSpecificOutput = AudioReceiverMediaSpecificOutput;
    class VideoReceiverMediaSpecificOutput {
        raw;
        type_identifier = "RTPReceiver::Data::VideoReceiver::MediaSpecific::Output";
        constructor(raw) {
            this.raw = raw;
        }
        get cc_channel() {
            return new VScript.dKeyword(this, "cc_channel", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get video() {
            return VAPI.AT1130.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "video"));
        }
        get start_of_frame() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "start_of_frame"));
        }
        get cc() {
            return VAPI.Video.lift.ClosedCaption(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "cc"));
        }
        get deembedded_audio() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "deembedded_audio"), (raw, _) => VAPI.AT1130.Audio.lift.Essence(raw));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "ptp_traits"));
        }
    }
    RTPReceiver.VideoReceiverMediaSpecificOutput = VideoReceiverMediaSpecificOutput;
    class MediaReceiverPacketStreams {
        raw;
        type_identifier = "RTPReceiver::Data::MediaReceiver::PacketStreams";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          for every subflow index, the first entry to appear in this list
          represents its rear guard
        */
        get sdp_a() {
            return new VScript.rKeyword(this, "sdp_a", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AT1130.RTPReceiver.lift.AssociatedStream),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AT1130.RTPReceiver.lower.AssociatedStream)
            });
        }
        /**
          for every subflow index, the first entry to appear in this list
          represents its rear guard
        */
        get sdp_b() {
            return new VScript.rKeyword(this, "sdp_b", {
                lift: VScript.VAPIHelpers.liftArray(VAPI.AT1130.RTPReceiver.lift.AssociatedStream),
                lower: VScript.VAPIHelpers.lowerArray(VAPI.AT1130.RTPReceiver.lower.AssociatedStream)
            });
        }
    }
    RTPReceiver.MediaReceiverPacketStreams = MediaReceiverPacketStreams;
    class AllSettings {
        raw;
        type_identifier = "RTPReceiver::Data::All::Settings";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          if `clean_switching_policy` is set to `Tolerant`, packet rates and ST2042
          compression ratios may change across switching boundaries. This ensures
          interoperability between a wider range of transmitters but comes at a
          slight performance penalty, as the receiver first has to determine the
          current packet rate before a switch can be effected. When set to
          `Whatever`, impossible clean switching requests will silently be
          converted into patching operations. Please only use this option as a
          measure of last resort, if at all.
        */
        get clean_switching_policy() {
            return new VScript.rwKeyword(this, "clean_switching_policy", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          limits IGMP stream subscriptions such that there remains an esimated
          `reserved_bandwidth` % of headroom on every RTP port (non-media traffic
          such as PTP or JSON/WS is not taken into account)
        */
        get reserved_bandwidth() {
            return new VScript.rwKeyword(this, "reserved_bandwidth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get max_concurrent_mpacket_irq_boosts() {
            return new VScript.rwKeyword(this, "max_concurrent_mpacket_irq_boosts", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get concurrent_mpacket_irq_boosts() {
            return new VScript.rKeyword(this, "concurrent_mpacket_irq_boosts", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          set this to modern to have generated 2042-raw/2022-6 streams state their
          respective rtp clock rates
        */
        get sdp_format() {
            return new VScript.rwKeyword(this, "sdp_format", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          determines how SDP files entered into `sdp_a_command` or `sdp_b_command`
          translate into their respective `status` counterparts. If
          `sdp_generation` is set to `Verbatim`, accepted SDP files are copied to
          `status` unmodified, even if some or all of the media descriptions within
          could not be serviced due to resource exhaustion. If `sdp_generation` is
          set to `Semantic`, only operationally effective parts of the SDP will be
          emitted.
        */
        get sdp_generation() {
            return new VScript.rwKeyword(this, "sdp_generation", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get num_audio_reserve_receivers() {
            return new VScript.dKeyword(this, "num_audio_reserve_receivers", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get rx_error() {
            return VAPI.RTPReceiver.lift.CountableErrorHandler(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "rx_error"));
        }
        get mpacket_error() {
            return VAPI.RTPReceiver.lift.CountableErrorHandler(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "mpacket_error"));
        }
        get offset_2110_error() {
            return VAPI.RTPReceiver.lift.CountableErrorHandler(VScript.VAPIHelpers.subtree_child_checked(this.raw, 9, "offset_2110_error"));
        }
        get linenr_2110_error() {
            return VAPI.RTPReceiver.lift.CountableErrorHandler(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "linenr_2110_error"));
        }
        /**
          time after which countable error events (such as RX errors or m-packet
          errors) are automatically cleared. Error accumulators are left unchanged
          until cleared explicitly by the user
        */
        get error_signalling_timeout() {
            return new VScript.dKeyword(this, "error_signalling_timeout", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get flight_permit_timeout() {
            return new VScript.dKeyword(this, "flight_permit_timeout", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        /**
          when in clean-switching mode (i.e., if `switch_time` is neither 0 nor 1),
          SDP writes to `current_target` are rejected, followed by an informational
          error message. Set `on_sdp_collision` to `RejectSilently` to suppress
          this error message.
        */
        get on_sdp_collision() {
            return new VScript.rwKeyword(this, "on_sdp_collision", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          some configuration attempts cannot be executed completely. For example, a
          session containing 3 audio receivers will not be able to service a
          connection request if the corresponding SDP contains 4 or more audio
          essences. In these cases, the receiver may either set up as many
          connections as possible and discard the rest (`BestEffort`), or refuse
          the configuration attempt and raise an error message instead (`Refuse`).
        */
        get exhaustion_policy() {
            return new VScript.rwKeyword(this, "exhaustion_policy", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get backend_liveness() {
            return VAPI.RTPReceiver.lift.CountableErrorHandler(VScript.VAPIHelpers.subtree_child_checked(this.raw, 15, "backend_liveness"));
        }
        get premature_read() {
            return VAPI.RTPReceiver.lift.CountableErrorHandler(VScript.VAPIHelpers.subtree_child_checked(this.raw, 16, "premature_read"));
        }
        /**
          Single video substreams pertaining to a quadlink UHD flow may be
          subscribed to independently, and used as separate 3G streams instead. By
          default, the resulting 3G video essences will be stripped of their
          substream attributes, which affects SDPs generated on retransmission, as
          well as 352 payloads. If you wish to retain original substream
          attributes, set this setting to `PropagateSubstreamAttribute` (but note
          that this setting only takes effect on readout).
        */
        get on_isolated_substream() {
            return new VScript.dKeyword(this, "on_isolated_substream", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get buffer_sizes() {
            return new VScript.dKeyword(this, "buffer_sizes", {
                lift: VAPI.AT1130.RTPReceiver.lift.BufferSizes,
                lower: VAPI.AT1130.RTPReceiver.lower.BufferSizes
            }, {
                lift: VAPI.AT1130.RTPReceiver.lift.BufferSizes,
                lower: VAPI.AT1130.RTPReceiver.lower.BufferSizes
            }, null);
        }
        /**
          enable this to have panicking 2110-20 receivers freeze all flow of data
          into their respective HBM channels. While this feature can be very useful
          for a post-mortem analysis in case of network-related errors, please keep
          in mind that other receivers sharing the same HBM channel will be
          affected as well. Also, this option should best be used with disabled
          backend liveness error handlers as liveness timeouts may otherwise fire
          too soon for you to retrieve the previously frozen memory contents
        */
        get freeze_memory_on_2110_20_panic() {
            return new VScript.rwKeyword(this, "freeze_memory_on_2110_20_panic", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    RTPReceiver.AllSettings = AllSettings;
    RTPReceiver.Enums = {
        BufferSize: ["UpTo4MB", "UpTo8MB", "UpTo12MB", "UpTo16MB", "UpTo24MB", "UpTo32MB", "UpTo48MB", "UpTo96MB"]
    };
})(RTPReceiver || (RTPReceiver = {}));
export var RTPTransmitter;
(function (RTPTransmitter) {
    RTPTransmitter.lift = {
        All: (_raw) => (new All(_raw)),
        AudioEncoder: (_raw) => (new AudioEncoder(_raw)),
        AudioFlowReference: (_raw) => (new AudioFlowReference(_raw)),
        AudioStreamHardware: (_raw) => (new AudioStreamHardware(_raw)),
        AudioStreamer: (_raw) => (new AudioStreamer(_raw)),
        EncoderHWDataEncoderClassic: (_raw, _socket) => {
            return {
                enabled: _raw[0],
                st2110: _raw[1],
                interlaced: _raw[2],
                vstart: _raw[3],
                vincrement: _raw[4],
                vend0: _raw[5],
                vend1: _raw[6],
                ts_sample_delay: _raw[7],
                ts_increment: _raw[8],
                h_active: _raw[9],
                pixels_per_packet: _raw[10]
            };
        },
        EncoderHWData: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "EncoderClassic", value: VAPI.AT1130.RTPTransmitter.lift.EncoderHWDataEncoderClassic(_raw[1], _socket) };
                case 1: return { variant: "EncoderVC2", value: VAPI.AT1130.RTPTransmitter.lift.EncoderHWDataEncoderVC2(_raw[1], _socket) };
                case 2: return { variant: "EncoderJxsCodec", value: VAPI.AT1130.RTPTransmitter.lift.EncoderHWDataEncoderJxsCodec(_raw[1], _socket) };
            }
            ;
        },
        EncoderHWDataEncoderJxsCodec: (_raw, _socket) => {
            return {
                width: _raw[0],
                height: _raw[1],
                mode: _raw[2],
                budget_per_frame: _raw[3],
                vld: _raw[4],
                number_of_images: _raw[5],
                video_depth: _raw[6],
                play_mode: _raw[7],
                level_weights: _raw[8],
                profile: _raw[9]
            };
        },
        EncoderHWDataEncoderVC2: (_raw, _socket) => {
            return {
                interlace: _raw[0],
                enabled: _raw[1],
                is_uhd: _raw[2],
                target_bytes_per_slice: _raw[3],
                last_slice: _raw[4]
            };
        },
        FlowReference: (_raw) => (new FlowReference(_raw)),
        HDRINSMUX: (_raw) => (new HDRINSMUX(_raw)),
        HDRAudio: (_raw) => (new HDRAudio(_raw)),
        HDRGeneral: (_raw) => (new HDRGeneral(_raw)),
        HDRMipmap: (_raw) => (new HDRMipmap(_raw)),
        HDRVideo: (_raw) => (new HDRVideo(_raw)),
        HardwareStatus: (_raw) => (new HardwareStatus(_raw)),
        HeaderReference: (_raw) => (new HeaderReference(_raw)),
        LaneHeader: (_raw) => (new LaneHeader(_raw)),
        LaneStatistic: (_raw, _socket) => {
            return {
                reserved_tdm_output_bandwidth: _raw[0],
                max_tdm_output_bandwidth: _raw[1],
                reserved_bus_bandwidth: _raw[2],
                maxbus_bandwidth: _raw[3],
                fpga_lane_statistic: _raw[4] === null ? null : new VAPI.AT1130.NetworkInterfaces.LaneStatistics(VScript.VAPIHelpers.get_subtree(_socket, _raw[4]))
            };
        },
        MediaClock: (_raw) => (new MediaClock(_raw)),
        MediaClockControl: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "Timesource", value: VAPI.AT1130.RTPTransmitter.lift.MediaClockControlTimesource(_raw[1], _socket) };
                case 1: return { variant: "Propagate", value: VAPI.AT1130.RTPTransmitter.lift.MediaClockControlPropagate(_raw[1], _socket) };
            }
            ;
        },
        MediaStreamer: (_raw) => (new MediaStreamer(_raw)),
        MediaStreamerVideo: (_raw) => (new MediaStreamerVideo(_raw)),
        MipMapStreamHardware: (_raw) => (new MipMapStreamHardware(_raw)),
        MipMapStreamer: (_raw) => (new MipMapStreamer(_raw)),
        MultiplexerScheduler: (_raw) => (new MultiplexerScheduler(_raw)),
        PortStatistic: (_raw) => (new PortStatistic(_raw)),
        MediaClockControlPropagate: (_raw, _socket) => {
            return {};
        },
        ReStreamer: (_raw) => (new ReStreamer(_raw)),
        RouterEncoder: (_raw) => (new RouterEncoder(_raw)),
        RouterOutput: (_raw) => (new RouterOutput(_raw)),
        ST2110Settings: (_raw, _socket) => {
            return {
                packing_mode: _raw[0],
                transmit_scheduler_uhd: _raw[1],
                add_st2110_40: _raw[2]
            };
        },
        Session: (_raw) => (new Session(_raw)),
        MediaClockControlTimesource: (_raw, _socket) => {
            return {
                t_src: _raw[0] === null ? null : new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, _raw[0]))
            };
        },
        VideoConfigurationContainer: (_raw) => (new VideoConfigurationContainer(_raw)),
        VideoFormat: (_raw, _socket) => {
            switch (_raw[0]) {
                case 0: return { variant: "ST2022_6", value: VAPI.RTPTransmitter.lift.ST20226Settings(_raw[1], _socket) };
                case 1: return { variant: "ST2110_20", value: VAPI.AT1130.RTPTransmitter.lift.ST2110Settings(_raw[1], _socket) };
                case 2: return { variant: "ST2042", value: VAPI.RTPTransmitter.lift.ST2042Settings(_raw[1], _socket) };
                case 3: return { variant: "JPEG_XS", value: VAPI.RTPTransmitter.lift.JpegXsSettings(_raw[1], _socket) };
            }
            ;
        },
        VideoStreamHardware: (_raw) => (new VideoStreamHardware(_raw)),
        VideoStreamer: (_raw) => (new VideoStreamer(_raw)),
        XbarEncoder: (_raw) => (new XbarEncoder(_raw)),
        HDRINSMUXFlowsAlternate: (_raw) => (new HDRINSMUXFlowsAlternate(_raw)),
        MultiplexerSchedulerFlowsAlternate: (_raw) => (new MultiplexerSchedulerFlowsAlternate(_raw)),
        AudioStreamHardwareAudioEncoder: (_raw) => (new AudioStreamHardwareAudioEncoder(_raw)),
        VideoStreamHardwareEncoderMux: (_raw) => (new VideoStreamHardwareEncoderMux(_raw)),
        AudioEncoderError: (_raw) => (new AudioEncoderError(_raw)),
        AudioEncoderFlows: (_raw) => (new AudioEncoderFlows(_raw)),
        HDRINSMUXFlows: (_raw) => (new HDRINSMUXFlows(_raw)),
        MultiplexerSchedulerFlows: (_raw) => (new MultiplexerSchedulerFlows(_raw)),
        RouterOutputHwCapability: (_raw) => (new RouterOutputHwCapability(_raw)),
        PortStatisticInterfaces: (_raw) => (new PortStatisticInterfaces(_raw)),
        HDRINSMUXFlowsMain: (_raw) => (new HDRINSMUXFlowsMain(_raw)),
        MultiplexerSchedulerFlowsMain: (_raw) => (new MultiplexerSchedulerFlowsMain(_raw)),
        VideoStreamHardwareMuxScheduler: (_raw) => (new VideoStreamHardwareMuxScheduler(_raw)),
        AudioEncoderRegData: (_raw, _socket) => {
            return {
                last_sample: _raw[0],
                mode: _raw[1],
                sequence_number: _raw[2]
            };
        },
        HDRINSMUXRegData: (_raw, _socket) => {
            return {
                enable_port: _raw[0],
                is_2022_6: _raw[1],
                sequence_eol: _raw[2],
                sample_2022_6: _raw[3],
                frame_2022_6: _raw[4],
                rate_2022_6: _raw[5],
                frame_number_2022_6: _raw[6],
                sequence_number: _raw[7],
                scheduler_subslot_2110: _raw[8],
                scheduler_slot_2110: _raw[9],
                scheduler_enable_2110: _raw[10]
            };
        },
        MultiplexerSchedulerRegData: (_raw, _socket) => {
            return {
                enable_port: _raw[0]
            };
        },
        MipMapStreamHardwareRouterEncoder: (_raw) => (new MipMapStreamHardwareRouterEncoder(_raw)),
        VideoStreamHardwareRouterEncoder: (_raw) => (new VideoStreamHardwareRouterEncoder(_raw)),
        VideoStreamHardwareXbarEncoder: (_raw) => (new VideoStreamHardwareXbarEncoder(_raw)),
    };
    RTPTransmitter.lower = {
        All: (_x) => _x.raw.kwl,
        AudioEncoder: (_x) => _x.raw.kwl,
        AudioFlowReference: (_x) => _x.raw.kwl,
        AudioStreamHardware: (_x) => _x.raw.kwl,
        AudioStreamer: (_x) => _x.raw.kwl,
        EncoderHWDataEncoderClassic: (_x, _socket) => [
            _x.enabled,
            _x.st2110,
            _x.interlaced,
            _x.vstart,
            _x.vincrement,
            _x.vend0,
            _x.vend1,
            _x.ts_sample_delay,
            _x.ts_increment,
            _x.h_active,
            _x.pixels_per_packet
        ],
        EncoderHWData: (_x, _socket) => {
            switch (_x.variant) {
                case "EncoderClassic": return [0, VAPI.AT1130.RTPTransmitter.lower.EncoderHWDataEncoderClassic(_x.value, _socket)];
                case "EncoderVC2": return [1, VAPI.AT1130.RTPTransmitter.lower.EncoderHWDataEncoderVC2(_x.value, _socket)];
                case "EncoderJxsCodec": return [2, VAPI.AT1130.RTPTransmitter.lower.EncoderHWDataEncoderJxsCodec(_x.value, _socket)];
            }
        },
        EncoderHWDataEncoderJxsCodec: (_x, _socket) => [
            _x.width,
            _x.height,
            _x.mode,
            _x.budget_per_frame,
            _x.vld,
            _x.number_of_images,
            _x.video_depth,
            _x.play_mode,
            _x.level_weights,
            _x.profile
        ],
        EncoderHWDataEncoderVC2: (_x, _socket) => [
            _x.interlace,
            _x.enabled,
            _x.is_uhd,
            _x.target_bytes_per_slice,
            _x.last_slice
        ],
        FlowReference: (_x) => _x.raw.kwl,
        HDRINSMUX: (_x) => _x.raw.kwl,
        HDRAudio: (_x) => _x.raw.kwl,
        HDRGeneral: (_x) => _x.raw.kwl,
        HDRMipmap: (_x) => _x.raw.kwl,
        HDRVideo: (_x) => _x.raw.kwl,
        HardwareStatus: (_x) => _x.raw.kwl,
        HeaderReference: (_x) => _x.raw.kwl,
        LaneHeader: (_x) => _x.raw.kwl,
        LaneStatistic: (_x, _socket) => [
            _x.reserved_tdm_output_bandwidth,
            _x.max_tdm_output_bandwidth,
            _x.reserved_bus_bandwidth,
            _x.maxbus_bandwidth,
            _x.fpga_lane_statistic === null ? null : _x.fpga_lane_statistic.raw.kwl
        ],
        MediaClock: (_x) => _x.raw.kwl,
        MediaClockControl: (_x, _socket) => {
            switch (_x.variant) {
                case "Timesource": return [0, VAPI.AT1130.RTPTransmitter.lower.MediaClockControlTimesource(_x.value, _socket)];
                case "Propagate": return [1, VAPI.AT1130.RTPTransmitter.lower.MediaClockControlPropagate(_x.value, _socket)];
            }
        },
        MediaStreamer: (_x) => _x.raw.kwl,
        MediaStreamerVideo: (_x) => _x.raw.kwl,
        MipMapStreamHardware: (_x) => _x.raw.kwl,
        MipMapStreamer: (_x) => _x.raw.kwl,
        MultiplexerScheduler: (_x) => _x.raw.kwl,
        PortStatistic: (_x) => _x.raw.kwl,
        MediaClockControlPropagate: (_x, _socket) => [],
        ReStreamer: (_x) => _x.raw.kwl,
        RouterEncoder: (_x) => _x.raw.kwl,
        RouterOutput: (_x) => _x.raw.kwl,
        ST2110Settings: (_x, _socket) => [
            _x.packing_mode,
            _x.transmit_scheduler_uhd,
            _x.add_st2110_40
        ],
        Session: (_x) => _x.raw.kwl,
        MediaClockControlTimesource: (_x, _socket) => [
            _x.t_src === null ? null : _x.t_src.raw.kwl
        ],
        VideoConfigurationContainer: (_x) => _x.raw.kwl,
        VideoFormat: (_x, _socket) => {
            switch (_x.variant) {
                case "ST2022_6": return [0, VAPI.RTPTransmitter.lower.ST20226Settings(_x.value, _socket)];
                case "ST2110_20": return [1, VAPI.AT1130.RTPTransmitter.lower.ST2110Settings(_x.value, _socket)];
                case "ST2042": return [2, VAPI.RTPTransmitter.lower.ST2042Settings(_x.value, _socket)];
                case "JPEG_XS": return [3, VAPI.RTPTransmitter.lower.JpegXsSettings(_x.value, _socket)];
            }
        },
        VideoStreamHardware: (_x) => _x.raw.kwl,
        VideoStreamer: (_x) => _x.raw.kwl,
        XbarEncoder: (_x) => _x.raw.kwl,
        HDRINSMUXFlowsAlternate: (_x) => _x.raw.kwl,
        MultiplexerSchedulerFlowsAlternate: (_x) => _x.raw.kwl,
        AudioStreamHardwareAudioEncoder: (_x) => _x.raw.kwl,
        VideoStreamHardwareEncoderMux: (_x) => _x.raw.kwl,
        AudioEncoderError: (_x) => _x.raw.kwl,
        AudioEncoderFlows: (_x) => _x.raw.kwl,
        HDRINSMUXFlows: (_x) => _x.raw.kwl,
        MultiplexerSchedulerFlows: (_x) => _x.raw.kwl,
        RouterOutputHwCapability: (_x) => _x.raw.kwl,
        PortStatisticInterfaces: (_x) => _x.raw.kwl,
        HDRINSMUXFlowsMain: (_x) => _x.raw.kwl,
        MultiplexerSchedulerFlowsMain: (_x) => _x.raw.kwl,
        VideoStreamHardwareMuxScheduler: (_x) => _x.raw.kwl,
        AudioEncoderRegData: (_x, _socket) => [
            _x.last_sample,
            _x.mode,
            _x.sequence_number
        ],
        HDRINSMUXRegData: (_x, _socket) => [
            _x.enable_port,
            _x.is_2022_6,
            _x.sequence_eol,
            _x.sample_2022_6,
            _x.frame_2022_6,
            _x.rate_2022_6,
            _x.frame_number_2022_6,
            _x.sequence_number,
            _x.scheduler_subslot_2110,
            _x.scheduler_slot_2110,
            _x.scheduler_enable_2110
        ],
        MultiplexerSchedulerRegData: (_x, _socket) => [
            _x.enable_port
        ],
        MipMapStreamHardwareRouterEncoder: (_x) => _x.raw.kwl,
        VideoStreamHardwareRouterEncoder: (_x) => _x.raw.kwl,
        VideoStreamHardwareXbarEncoder: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "RTPTransmitter::Data::All";
        get runtime_constants() {
            return {
                num_mipmaptransmitters: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_mipmaptransmitters"),
                num_transmitter_video_lane: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_transmitter_video_lane"),
                has_2042_uhd: this.raw.backing_store.get_runtime_constant("RTPTransmitter::has_2042_uhd"),
                num_hdr_flows: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_hdr_flows"),
                num_xbar_encoder: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_xbar_encoder"),
                num_ports: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_ports"),
                num_audio_group_control: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_audio_group_control"),
                max_st2110_20_uhd_transmitters: this.raw.backing_store.get_runtime_constant("RTPTransmitter::max_st2110_20_uhd_transmitters"),
                max_2042: this.raw.backing_store.get_runtime_constant("RTPTransmitter::max_2042"),
                has_2042: this.raw.backing_store.get_runtime_constant("RTPTransmitter::has_2042"),
                num_encoder_mux: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_encoder_mux"),
                num_videotransmitters: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_videotransmitters"),
                num_audiotransmitters: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_audiotransmitters"),
                max_2042_uhd: this.raw.backing_store.get_runtime_constant("RTPTransmitter::max_2042_uhd"),
                num_jpegxs: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_jpegxs"),
                num_transmitter_mipmap_lane: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_transmitter_mipmap_lane"),
                num_transmitter_audio_lane: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_transmitter_audio_lane"),
                num_hdr_flows_port: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_hdr_flows_port"),
                num_transmitters: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_transmitters"),
                num_passthroughtransmitters: this.raw.backing_store.get_runtime_constant("RTPTransmitter::num_passthroughtransmitters")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get license_information() {
            return VAPI.RTPTransmitter.lift.AllLicenseInformation(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "license_information"));
        }
        get hardware_status() {
            return VAPI.AT1130.RTPTransmitter.lift.HardwareStatus(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "hardware_status"));
        }
        get settings() {
            return VAPI.RTPTransmitter.lift.AllSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "settings"));
        }
        get sessions() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 3, "sessions"), (raw) => new VAPI.AT1130.RTPTransmitter.SessionAsNamedTableRow(raw));
        }
        get video_transmitters() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 4, "video_transmitters"), (raw) => new VAPI.AT1130.RTPTransmitter.VideoStreamerAsNamedTableRow(raw));
        }
        get audio_transmitters() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 5, "audio_transmitters"), (raw) => new VAPI.AT1130.RTPTransmitter.AudioStreamerAsNamedTableRow(raw));
        }
        get passthrough_transmitters() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 6, "passthrough_transmitters"), (raw) => new VAPI.AT1130.RTPTransmitter.ReStreamerAsNamedTableRow(raw));
        }
        get mipmap_transmitters() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 7, "mipmap_transmitters"), (raw, _) => VAPI.AT1130.RTPTransmitter.lift.MipMapStreamer(raw));
        }
    }
    RTPTransmitter.All = All;
    class AudioEncoder {
        raw;
        type_identifier = "RTPTransmitter::Data::AudioEncoder";
        constructor(raw) {
            this.raw = raw;
        }
        get reg_data() {
            return new VScript.rKeyword(this, "reg_data", {
                lift: VAPI.AT1130.RTPTransmitter.lift.AudioEncoderRegData,
                lower: VAPI.AT1130.RTPTransmitter.lower.AudioEncoderRegData
            });
        }
        get flows() {
            return VAPI.AT1130.RTPTransmitter.lift.AudioEncoderFlows(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "flows"));
        }
        get error() {
            return VAPI.AT1130.RTPTransmitter.lift.AudioEncoderError(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "error"));
        }
    }
    RTPTransmitter.AudioEncoder = AudioEncoder;
    class AudioFlowReference {
        raw;
        type_identifier = "RTPTransmitter::Data::AudioFlowReference";
        constructor(raw) {
            this.raw = raw;
        }
        get hdr_ref() {
            return new VScript.rKeyword(this, "hdr_ref", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.HDRAudio(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get hdr_index() {
            return new VScript.rKeyword(this, "hdr_index", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get hdr_port() {
            return new VScript.rKeyword(this, "hdr_port", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    RTPTransmitter.AudioFlowReference = AudioFlowReference;
    class AudioStreamHardware {
        raw;
        type_identifier = "RTPTransmitter::Data::AudioStreamHardware";
        constructor(raw) {
            this.raw = raw;
        }
        get audio_encoder() {
            return VAPI.AT1130.RTPTransmitter.lift.AudioStreamHardwareAudioEncoder(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "audio_encoder"));
        }
    }
    RTPTransmitter.AudioStreamHardware = AudioStreamHardware;
    class AudioStreamer {
        raw;
        type_identifier = "RTPTransmitter::Data::AudioStreamer";
        constructor(raw) {
            this.raw = raw;
        }
        get generic() {
            return VAPI.AT1130.RTPTransmitter.lift.MediaStreamer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "generic"));
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VAPI.AT1130.Audio.lift.TimedSource,
                lower: VAPI.AT1130.Audio.lower.TimedSource
            }, {
                lift: VAPI.AT1130.Audio.lift.TimedSource,
                lower: VAPI.AT1130.Audio.lower.TimedSource
            }, null);
        }
        get configuration() {
            return VAPI.RTPTransmitter.lift.AudioConfigurationContainer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "configuration"));
        }
        get stream_name() {
            return VAPI.Definitions.lift.NAME(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "stream_name"));
        }
        get connected_hardware() {
            return VAPI.AT1130.RTPTransmitter.lift.AudioStreamHardware(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "connected_hardware"));
        }
    }
    RTPTransmitter.AudioStreamer = AudioStreamer;
    class AudioStreamerAsNamedTableRow extends AudioStreamer {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPTransmitter.AudioStreamerAsNamedTableRow = AudioStreamerAsNamedTableRow;
    class FlowReference {
        raw;
        type_identifier = "RTPTransmitter::Data::FlowReference";
        constructor(raw) {
            this.raw = raw;
        }
        get hdr_ref() {
            return new VScript.rKeyword(this, "hdr_ref", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.HDRVideo(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get hdr_index() {
            return new VScript.rKeyword(this, "hdr_index", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    RTPTransmitter.FlowReference = FlowReference;
    class HDRINSMUX {
        raw;
        type_identifier = "RTPTransmitter::Data::HDRINSMUX";
        constructor(raw) {
            this.raw = raw;
        }
        get flows() {
            return VAPI.AT1130.RTPTransmitter.lift.HDRINSMUXFlows(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "flows"));
        }
        get reg_data() {
            return new VScript.rKeyword(this, "reg_data", {
                lift: VAPI.AT1130.RTPTransmitter.lift.HDRINSMUXRegData,
                lower: VAPI.AT1130.RTPTransmitter.lower.HDRINSMUXRegData
            });
        }
    }
    RTPTransmitter.HDRINSMUX = HDRINSMUX;
    class HDRAudio {
        raw;
        type_identifier = "RTPTransmitter::Data::HDRAudio";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_port_bandwidth() {
            return new VScript.rKeyword(this, "reserved_port_bandwidth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get related_references() {
            return VAPI.AT1130.RTPTransmitter.lift.HeaderReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "related_references"));
        }
        /**
          reference to encoder mux
        */
        get audio_encoder_hw() {
            return new VScript.rKeyword(this, "audio_encoder_hw", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.AudioEncoder(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPTransmitter.HDRAudio = HDRAudio;
    class HDRGeneral {
        raw;
        type_identifier = "RTPTransmitter::Data::HDRGeneral";
        constructor(raw) {
            this.raw = raw;
        }
        get audio() {
            return VAPI.AT1130.RTPTransmitter.lift.HDRAudio(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "audio"));
        }
        get video() {
            return VAPI.AT1130.RTPTransmitter.lift.HDRVideo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "video"));
        }
        get mipmap() {
            return VAPI.AT1130.RTPTransmitter.lift.HDRMipmap(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "mipmap"));
        }
    }
    RTPTransmitter.HDRGeneral = HDRGeneral;
    class HDRMipmap {
        raw;
        type_identifier = "RTPTransmitter::Data::HDRMipmap";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_port_bandwidth() {
            return new VScript.rKeyword(this, "reserved_port_bandwidth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get related_references() {
            return VAPI.AT1130.RTPTransmitter.lift.HeaderReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "related_references"));
        }
        get mipmap_encoder_hw() {
            return VAPI.RTPTransmitter.lift.MipMapEncoder(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "mipmap_encoder_hw"));
        }
    }
    RTPTransmitter.HDRMipmap = HDRMipmap;
    class HDRVideo {
        raw;
        type_identifier = "RTPTransmitter::Data::HDRVideo";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_bandwidth() {
            return new VScript.rKeyword(this, "reserved_bandwidth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_port_bandwidth() {
            return new VScript.rKeyword(this, "reserved_port_bandwidth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get related_references() {
            return VAPI.AT1130.RTPTransmitter.lift.HeaderReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "related_references"));
        }
        /**
          reference to encoder mux
        */
        get router_encoder_hw() {
            return new VScript.rKeyword(this, "router_encoder_hw", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.RouterEncoder(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPTransmitter.HDRVideo = HDRVideo;
    class HardwareStatus {
        raw;
        type_identifier = "RTPTransmitter::Data::HardwareStatus";
        constructor(raw) {
            this.raw = raw;
        }
        get ports() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "ports"), (raw, _) => VAPI.AT1130.RTPTransmitter.lift.PortStatistic(raw));
        }
        get xbar_encoder() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "xbar_encoder"), (raw, _) => VAPI.AT1130.RTPTransmitter.lift.XbarEncoder(raw));
        }
        get encoder_mux() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "encoder_mux"), (raw, _) => VAPI.AT1130.RTPTransmitter.lift.RouterOutput(raw));
        }
        get mux_scheduler() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 3, "mux_scheduler"), (raw, _) => VAPI.AT1130.RTPTransmitter.lift.MultiplexerScheduler(raw));
        }
        get audio_encoder() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "audio_encoder"), (raw, _) => VAPI.AT1130.RTPTransmitter.lift.AudioEncoder(raw));
        }
        get mux_statistics() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 5, "mux_statistics"), (st, _) => VAPI.RTPTransmitter.lift.MuxStatistics(st));
        }
        get audio_tx_group_control() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 6, "audio_tx_group_control"), (raw, _) => VAPI.RTPTransmitter.lift.AudioGroupControl(raw));
        }
    }
    RTPTransmitter.HardwareStatus = HardwareStatus;
    class HeaderReference {
        raw;
        type_identifier = "RTPTransmitter::Data::HeaderReference";
        constructor(raw) {
            this.raw = raw;
        }
        get tx_stream_counter() {
            return new VScript.rKeyword(this, "tx_stream_counter", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftRefinedIndexedNonmutatingReference((kwl, _socket) => new VAPI.AT1130.NetworkInterfaces.LaneStatistics(VScript.VAPIHelpers.get_subtree(_socket, kwl)), "tx_streams", {
                    lift: VAPI.EthernetStats.lift.Counter,
                    lower: VAPI.EthernetStats.lower.Counter
                })),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerRefinedIndexedReference())
            });
        }
    }
    RTPTransmitter.HeaderReference = HeaderReference;
    class LaneHeader {
        raw;
        type_identifier = "RTPTransmitter::Data::LaneHeader";
        constructor(raw) {
            this.raw = raw;
        }
        get statistic() {
            return new VScript.rKeyword(this, "statistic", {
                lift: VAPI.AT1130.RTPTransmitter.lift.LaneStatistic,
                lower: VAPI.AT1130.RTPTransmitter.lower.LaneStatistic
            });
        }
        get video() {
            return VAPI.AT1130.RTPTransmitter.lift.RouterOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "video"));
        }
    }
    RTPTransmitter.LaneHeader = LaneHeader;
    class MediaClock {
        raw;
        type_identifier = "RTPTransmitter::Data::MediaClock";
        constructor(raw) {
            this.raw = raw;
        }
        get clock_mode() {
            return new VScript.dKeyword(this, "clock_mode", {
                lift: VAPI.AT1130.RTPTransmitter.lift.MediaClockControl,
                lower: VAPI.AT1130.RTPTransmitter.lower.MediaClockControl
            }, {
                lift: VAPI.AT1130.RTPTransmitter.lift.MediaClockControl,
                lower: VAPI.AT1130.RTPTransmitter.lower.MediaClockControl
            }, null);
        }
        get offset() {
            return new VScript.dKeyword(this, "offset", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get latch_control() {
            return VAPI.Definitions.lift.LatchControl(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "latch_control"));
        }
        get latched_timestamp() {
            return new VScript.rKeyword(this, "latched_timestamp", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            });
        }
        get hw_latched_timestamp() {
            return new VScript.rKeyword(this, "hw_latched_timestamp", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    RTPTransmitter.MediaClock = MediaClock;
    class MediaStreamer {
        raw;
        type_identifier = "RTPTransmitter::Data::MediaStreamer";
        constructor(raw) {
            this.raw = raw;
        }
        get hosting_session() {
            return new VScript.dKeyword(this, "hosting_session", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get mediaclock() {
            return VAPI.AT1130.RTPTransmitter.lift.MediaClock(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "mediaclock"));
        }
        get ip_configuration() {
            return VAPI.RTPTransmitter.lift.MediaStreamerIpConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "ip_configuration"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    missing_dst_ip: (x & 1) !== 0,
                    missing_src_ip4: (x & 2) !== 0,
                    missing_src_ip6: (x & 4) !== 0
                }),
                lower: (x, _) => ((x.missing_dst_ip ? 1 : 0) |
                    (x.missing_src_ip4 ? 2 : 0) |
                    (x.missing_src_ip6 ? 4 : 0))
            });
        }
    }
    RTPTransmitter.MediaStreamer = MediaStreamer;
    class MediaStreamerVideo {
        raw;
        type_identifier = "RTPTransmitter::Data::MediaStreamerVideo";
        constructor(raw) {
            this.raw = raw;
        }
        get hosting_session() {
            return new VScript.dKeyword(this, "hosting_session", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.Session(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get mediaclock() {
            return VAPI.AT1130.RTPTransmitter.lift.MediaClock(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "mediaclock"));
        }
        get ip_configuration() {
            return VAPI.RTPTransmitter.lift.MediaStreamerVideoIpConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "ip_configuration"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    missing_dst_ip: (x & 1) !== 0,
                    missing_input_dt_node: (x & 2) !== 0,
                    missing_src_ip4: (x & 4) !== 0,
                    missing_src_ip6: (x & 8) !== 0
                }),
                lower: (x, _) => ((x.missing_dst_ip ? 1 : 0) |
                    (x.missing_input_dt_node ? 2 : 0) |
                    (x.missing_src_ip4 ? 4 : 0) |
                    (x.missing_src_ip6 ? 8 : 0))
            });
        }
    }
    RTPTransmitter.MediaStreamerVideo = MediaStreamerVideo;
    class MipMapStreamHardware {
        raw;
        type_identifier = "RTPTransmitter::Data::MipMapStreamHardware";
        constructor(raw) {
            this.raw = raw;
        }
        get router_encoder() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "router_encoder"), (raw, _) => VAPI.AT1130.RTPTransmitter.lift.MipMapStreamHardwareRouterEncoder(raw));
        }
    }
    RTPTransmitter.MipMapStreamHardware = MipMapStreamHardware;
    class MipMapStreamer {
        raw;
        type_identifier = "RTPTransmitter::Data::MipMapStreamer";
        constructor(raw) {
            this.raw = raw;
        }
        get ip_configuration() {
            return VAPI.RTPTransmitter.lift.MipMapStreamerIpConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "ip_configuration"));
        }
        get stream_name() {
            return VAPI.Definitions.lift.NAME(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "stream_name"));
        }
        get connected_hardware() {
            return VAPI.AT1130.RTPTransmitter.lift.MipMapStreamHardware(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "connected_hardware"));
        }
    }
    RTPTransmitter.MipMapStreamer = MipMapStreamer;
    class MultiplexerScheduler {
        raw;
        type_identifier = "RTPTransmitter::Data::MultiplexerScheduler";
        constructor(raw) {
            this.raw = raw;
        }
        get flows() {
            return VAPI.AT1130.RTPTransmitter.lift.MultiplexerSchedulerFlows(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "flows"));
        }
        get reg_data() {
            return new VScript.rKeyword(this, "reg_data", {
                lift: VAPI.AT1130.RTPTransmitter.lift.MultiplexerSchedulerRegData,
                lower: VAPI.AT1130.RTPTransmitter.lower.MultiplexerSchedulerRegData
            });
        }
    }
    RTPTransmitter.MultiplexerScheduler = MultiplexerScheduler;
    class PortStatistic {
        raw;
        type_identifier = "RTPTransmitter::Data::PortStatistic";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_output_bandwidth() {
            return new VScript.rKeyword(this, "reserved_output_bandwidth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          maximum throughput (per direction), measured in bits/second
        */
        get max_throughput() {
            return new VScript.rKeyword(this, "max_throughput", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get interfaces() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "interfaces"), (raw, _) => VAPI.AT1130.RTPTransmitter.lift.PortStatisticInterfaces(raw));
        }
        get hdr_general() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 3, "hdr_general"), (raw, _) => VAPI.AT1130.RTPTransmitter.lift.HDRGeneral(raw));
        }
    }
    RTPTransmitter.PortStatistic = PortStatistic;
    class ReStreamer {
        raw;
        type_identifier = "RTPTransmitter::Data::ReStreamer";
        constructor(raw) {
            this.raw = raw;
        }
        get fill_it_up() {
            return new VScript.rKeyword(this, "fill_it_up", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get generic() {
            return VAPI.AT1130.RTPTransmitter.lift.MediaStreamer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "generic"));
        }
    }
    RTPTransmitter.ReStreamer = ReStreamer;
    class ReStreamerAsNamedTableRow extends ReStreamer {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPTransmitter.ReStreamerAsNamedTableRow = ReStreamerAsNamedTableRow;
    class RouterEncoder {
        raw;
        type_identifier = "RTPTransmitter::Data::RouterEncoder";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_bandwidth() {
            return new VScript.rKeyword(this, "reserved_bandwidth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          maximum throughput, measured in bits/second
        */
        get reserved_port_bandwidth() {
            return new VScript.rKeyword(this, "reserved_port_bandwidth", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          reference to scheduler. The scheduler serializes the packets to ensure
          that the outgoing sequence numbers are in continuous ascending order.
        */
        get scheduler_hw() {
            return new VScript.rKeyword(this, "scheduler_hw", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.MultiplexerScheduler(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get meta_hdr_ins_mux() {
            return VAPI.AT1130.RTPTransmitter.lift.HDRINSMUX(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "meta_hdr_ins_mux"));
        }
        get video_hdr_ins_mux() {
            return VAPI.AT1130.RTPTransmitter.lift.HDRINSMUX(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "video_hdr_ins_mux"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    missing_video_multiplex_resource: (x & 1) !== 0
                }),
                lower: (x, _) => ((x.missing_video_multiplex_resource ? 1 : 0))
            });
        }
    }
    RTPTransmitter.RouterEncoder = RouterEncoder;
    class RouterOutput {
        raw;
        type_identifier = "RTPTransmitter::Data::RouterOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get hw_capability() {
            return VAPI.AT1130.RTPTransmitter.lift.RouterOutputHwCapability(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "hw_capability"));
        }
        get router_encoder_hw() {
            return VAPI.AT1130.RTPTransmitter.lift.RouterEncoder(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "router_encoder_hw"));
        }
    }
    RTPTransmitter.RouterOutput = RouterOutput;
    class Session {
        raw;
        type_identifier = "RTPTransmitter::Data::Session";
        constructor(raw) {
            this.raw = raw;
        }
        get active() {
            return new VScript.dKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get reserve_resources() {
            return new VScript.dKeyword(this, "reserve_resources", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get sdp_a() {
            return new VScript.rKeyword(this, "sdp_a", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get session_name() {
            return VAPI.Definitions.lift.NAME(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "session_name"));
        }
        get video_transmitters() {
            return new VScript.rKeyword(this, "video_transmitters", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.VideoStreamer(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get audio_transmitters() {
            return new VScript.rKeyword(this, "audio_transmitters", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.AudioStreamer(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get passthrough_transmitters() {
            return new VScript.rKeyword(this, "passthrough_transmitters", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.ReStreamer(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get mipmap_transmitters() {
            return new VScript.rKeyword(this, "mipmap_transmitters", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.MipMapStreamer(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
        get interfaces() {
            return new VScript.dKeyword(this, "interfaces", {
                lift: VAPI.RTPTransmitter.lift.SessionInterfaces,
                lower: VAPI.RTPTransmitter.lower.SessionInterfaces
            }, {
                lift: VAPI.RTPTransmitter.lift.SessionInterfaces,
                lower: VAPI.RTPTransmitter.lower.SessionInterfaces
            }, null);
        }
    }
    RTPTransmitter.Session = Session;
    class SessionAsNamedTableRow extends Session {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPTransmitter.SessionAsNamedTableRow = SessionAsNamedTableRow;
    class VideoConfigurationContainer {
        raw;
        type_identifier = "RTPTransmitter::Data::VideoConfigurationContainer";
        constructor(raw) {
            this.raw = raw;
        }
        get transport_format() {
            return new VScript.dKeyword(this, "transport_format", {
                lift: VAPI.AT1130.RTPTransmitter.lift.VideoFormat,
                lower: VAPI.AT1130.RTPTransmitter.lower.VideoFormat
            }, {
                lift: VAPI.AT1130.RTPTransmitter.lift.VideoFormat,
                lower: VAPI.AT1130.RTPTransmitter.lower.VideoFormat
            }, null);
        }
        get vanc() {
            return VAPI.AT1130.Definitions.lift.VancControl(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "vanc"));
        }
        get embedded_audio() {
            return new VScript.dKeyword(this, "embedded_audio", {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => ((x /* FIXME */, _) => x)(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VAPI.AT1130.Audio.lift.TimedSource,
                lower: VAPI.AT1130.Audio.lower.TimedSource
            }, {
                lift: VAPI.AT1130.Audio.lift.TimedSource,
                lower: VAPI.AT1130.Audio.lower.TimedSource
            }, null);
        }
    }
    RTPTransmitter.VideoConfigurationContainer = VideoConfigurationContainer;
    class VideoStreamHardware {
        raw;
        type_identifier = "RTPTransmitter::Data::VideoStreamHardware";
        constructor(raw) {
            this.raw = raw;
        }
        get xbar_encoder() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "xbar_encoder"), (raw, _) => VAPI.AT1130.RTPTransmitter.lift.VideoStreamHardwareXbarEncoder(raw));
        }
        get encoder_mux() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "encoder_mux"), (raw, _) => VAPI.AT1130.RTPTransmitter.lift.VideoStreamHardwareEncoderMux(raw));
        }
        get mux_scheduler() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "mux_scheduler"), (raw, _) => VAPI.AT1130.RTPTransmitter.lift.VideoStreamHardwareMuxScheduler(raw));
        }
        get router_encoder() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 3, "router_encoder"), (raw, _) => VAPI.AT1130.RTPTransmitter.lift.VideoStreamHardwareRouterEncoder(raw));
        }
    }
    RTPTransmitter.VideoStreamHardware = VideoStreamHardware;
    class VideoStreamer {
        raw;
        type_identifier = "RTPTransmitter::Data::VideoStreamer";
        constructor(raw) {
            this.raw = raw;
        }
        get generic() {
            return VAPI.AT1130.RTPTransmitter.lift.MediaStreamerVideo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "generic"));
        }
        get constraints() {
            return VAPI.RTPTransmitter.lift.Constraints(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "constraints"));
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VAPI.AT1130.Video.lift.TimedSource,
                lower: VAPI.AT1130.Video.lower.TimedSource
            }, {
                lift: VAPI.AT1130.Video.lift.TimedSource,
                lower: VAPI.AT1130.Video.lower.TimedSource
            }, null);
        }
        get configuration() {
            return VAPI.AT1130.RTPTransmitter.lift.VideoConfigurationContainer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "configuration"));
        }
        get stream_name() {
            return VAPI.Definitions.lift.NAME(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "stream_name"));
        }
        get connected_hardware() {
            return VAPI.AT1130.RTPTransmitter.lift.VideoStreamHardware(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "connected_hardware"));
        }
    }
    RTPTransmitter.VideoStreamer = VideoStreamer;
    class VideoStreamerAsNamedTableRow extends VideoStreamer {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    RTPTransmitter.VideoStreamerAsNamedTableRow = VideoStreamerAsNamedTableRow;
    class XbarEncoder {
        raw;
        type_identifier = "RTPTransmitter::Data::XbarEncoder";
        constructor(raw) {
            this.raw = raw;
        }
        get debug() {
            return new VScript.rKeyword(this, "debug", {
                lift: VAPI.AT1130.RTPTransmitter.lift.EncoderHWData,
                lower: VAPI.AT1130.RTPTransmitter.lower.EncoderHWData
            });
        }
    }
    RTPTransmitter.XbarEncoder = XbarEncoder;
    class HDRINSMUXFlowsAlternate {
        raw;
        type_identifier = "RTPTransmitter::Data::HDRINSMUX::Flows::Alternate";
        constructor(raw) {
            this.raw = raw;
        }
        get primary() {
            return VAPI.AT1130.RTPTransmitter.lift.FlowReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "primary"));
        }
        get secondary() {
            return VAPI.AT1130.RTPTransmitter.lift.FlowReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "secondary"));
        }
    }
    RTPTransmitter.HDRINSMUXFlowsAlternate = HDRINSMUXFlowsAlternate;
    class MultiplexerSchedulerFlowsAlternate {
        raw;
        type_identifier = "RTPTransmitter::Data::MultiplexerScheduler::Flows::Alternate";
        constructor(raw) {
            this.raw = raw;
        }
        get primary() {
            return VAPI.AT1130.RTPTransmitter.lift.FlowReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "primary"));
        }
        get secondary() {
            return VAPI.AT1130.RTPTransmitter.lift.FlowReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "secondary"));
        }
    }
    RTPTransmitter.MultiplexerSchedulerFlowsAlternate = MultiplexerSchedulerFlowsAlternate;
    class AudioStreamHardwareAudioEncoder {
        raw;
        type_identifier = "RTPTransmitter::Data::AudioStreamHardware::AudioEncoder";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          reference to router encoder hardware
        */
        get wrapped_reference_encoder() {
            return new VScript.rKeyword(this, "wrapped_reference_encoder", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.AudioEncoder(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPTransmitter.AudioStreamHardwareAudioEncoder = AudioStreamHardwareAudioEncoder;
    class VideoStreamHardwareEncoderMux {
        raw;
        type_identifier = "RTPTransmitter::Data::VideoStreamHardware::EncoderMux";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          reference to xbar encoder hardware
        */
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.RouterEncoder(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPTransmitter.VideoStreamHardwareEncoderMux = VideoStreamHardwareEncoderMux;
    class AudioEncoderError {
        raw;
        type_identifier = "RTPTransmitter::Data::AudioEncoder::Error";
        constructor(raw) {
            this.raw = raw;
        }
        get queue_overflow() {
            return new VScript.rKeyword(this, "queue_overflow", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get queue_full() {
            return new VScript.rKeyword(this, "queue_full", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    RTPTransmitter.AudioEncoderError = AudioEncoderError;
    class AudioEncoderFlows {
        raw;
        type_identifier = "RTPTransmitter::Data::AudioEncoder::Flows";
        constructor(raw) {
            this.raw = raw;
        }
        get primary() {
            return VAPI.AT1130.RTPTransmitter.lift.AudioFlowReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "primary"));
        }
        get secondary() {
            return VAPI.AT1130.RTPTransmitter.lift.AudioFlowReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "secondary"));
        }
    }
    RTPTransmitter.AudioEncoderFlows = AudioEncoderFlows;
    class HDRINSMUXFlows {
        raw;
        type_identifier = "RTPTransmitter::Data::HDRINSMUX::Flows";
        constructor(raw) {
            this.raw = raw;
        }
        get main() {
            return VAPI.AT1130.RTPTransmitter.lift.HDRINSMUXFlowsMain(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "main"));
        }
        get alternate() {
            return VAPI.AT1130.RTPTransmitter.lift.HDRINSMUXFlowsAlternate(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "alternate"));
        }
    }
    RTPTransmitter.HDRINSMUXFlows = HDRINSMUXFlows;
    class MultiplexerSchedulerFlows {
        raw;
        type_identifier = "RTPTransmitter::Data::MultiplexerScheduler::Flows";
        constructor(raw) {
            this.raw = raw;
        }
        get main() {
            return VAPI.AT1130.RTPTransmitter.lift.MultiplexerSchedulerFlowsMain(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "main"));
        }
        get alternate() {
            return VAPI.AT1130.RTPTransmitter.lift.MultiplexerSchedulerFlowsAlternate(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "alternate"));
        }
    }
    RTPTransmitter.MultiplexerSchedulerFlows = MultiplexerSchedulerFlows;
    class RouterOutputHwCapability {
        raw;
        type_identifier = "RTPTransmitter::Data::RouterOutput::HwCapability";
        constructor(raw) {
            this.raw = raw;
        }
        get num_encoder() {
            return new VScript.rKeyword(this, "num_encoder", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    RTPTransmitter.RouterOutputHwCapability = RouterOutputHwCapability;
    class PortStatisticInterfaces {
        raw;
        type_identifier = "RTPTransmitter::Data::PortStatistic::Interfaces";
        constructor(raw) {
            this.raw = raw;
        }
        get interface() {
            return new VScript.rKeyword(this, "interface", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.VirtualInterface(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPTransmitter.PortStatisticInterfaces = PortStatisticInterfaces;
    class HDRINSMUXFlowsMain {
        raw;
        type_identifier = "RTPTransmitter::Data::HDRINSMUX::Flows::Main";
        constructor(raw) {
            this.raw = raw;
        }
        get primary() {
            return VAPI.AT1130.RTPTransmitter.lift.FlowReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "primary"));
        }
        get secondary() {
            return VAPI.AT1130.RTPTransmitter.lift.FlowReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "secondary"));
        }
    }
    RTPTransmitter.HDRINSMUXFlowsMain = HDRINSMUXFlowsMain;
    class MultiplexerSchedulerFlowsMain {
        raw;
        type_identifier = "RTPTransmitter::Data::MultiplexerScheduler::Flows::Main";
        constructor(raw) {
            this.raw = raw;
        }
        get primary() {
            return VAPI.AT1130.RTPTransmitter.lift.FlowReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "primary"));
        }
        get secondary() {
            return VAPI.AT1130.RTPTransmitter.lift.FlowReference(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "secondary"));
        }
    }
    RTPTransmitter.MultiplexerSchedulerFlowsMain = MultiplexerSchedulerFlowsMain;
    class VideoStreamHardwareMuxScheduler {
        raw;
        type_identifier = "RTPTransmitter::Data::VideoStreamHardware::MuxScheduler";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          reference to scheduler. The scheduler serializes the packets to ensure
          that the outgoing sequence numbers are in continuous ascending order.
        */
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.MultiplexerScheduler(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPTransmitter.VideoStreamHardwareMuxScheduler = VideoStreamHardwareMuxScheduler;
    class MipMapStreamHardwareRouterEncoder {
        raw;
        type_identifier = "RTPTransmitter::Data::MipMapStreamHardware::RouterEncoder";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          reference to router encoder hardware
        */
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.HDRMipmap(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPTransmitter.MipMapStreamHardwareRouterEncoder = MipMapStreamHardwareRouterEncoder;
    class VideoStreamHardwareRouterEncoder {
        raw;
        type_identifier = "RTPTransmitter::Data::VideoStreamHardware::RouterEncoder";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          reference to router encoder hardware
        */
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.HDRVideo(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPTransmitter.VideoStreamHardwareRouterEncoder = VideoStreamHardwareRouterEncoder;
    class VideoStreamHardwareXbarEncoder {
        raw;
        type_identifier = "RTPTransmitter::Data::VideoStreamHardware::XbarEncoder";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          reference to xbar encoder hardware
        */
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.RTPTransmitter.XbarEncoder(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    RTPTransmitter.VideoStreamHardwareXbarEncoder = VideoStreamHardwareXbarEncoder;
})(RTPTransmitter || (RTPTransmitter = {}));
export var RePlay;
(function (RePlay) {
    RePlay.lift = {
        All: (_raw) => (new All(_raw)),
    };
    RePlay.lower = { All: (_x) => _x.raw.kwl, };
    class All {
        raw;
        type_identifier = "RePlay::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get video() {
            return VAPI.AT1130.VideoRePlay.lift.Video(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "video"));
        }
        get audio() {
            return VAPI.AT1130.AudioRePlay.lift.Audio(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "audio"));
        }
    }
    RePlay.All = All;
})(RePlay || (RePlay = {}));
export var SampleRateConverter;
(function (SampleRateConverter) {
    SampleRateConverter.lift = {
        AUDIOSRCSTATUS: (_raw) => (new AUDIOSRCSTATUS(_raw)),
        All: (_raw) => (new All(_raw)),
        INPUTSTATUS: (_raw) => (new INPUTSTATUS(_raw)),
        RESOURCE: (_raw) => (new RESOURCE(_raw)),
        RESOURCES: (_raw) => (new RESOURCES(_raw)),
        SRC: (_raw) => (new SRC(_raw)),
        SRCHardware: (_raw) => (new SRCHardware(_raw)),
        Time: (_raw) => (new Time(_raw)),
        AUDIOSRCSTATUSHwSettings: (_raw) => (new AUDIOSRCSTATUSHwSettings(_raw)),
        SRCSettings: (_raw) => (new SRCSettings(_raw)),
    };
    SampleRateConverter.lower = {
        AUDIOSRCSTATUS: (_x) => _x.raw.kwl,
        All: (_x) => _x.raw.kwl,
        INPUTSTATUS: (_x) => _x.raw.kwl,
        RESOURCE: (_x) => _x.raw.kwl,
        RESOURCES: (_x) => _x.raw.kwl,
        SRC: (_x) => _x.raw.kwl,
        SRCHardware: (_x) => _x.raw.kwl,
        Time: (_x) => _x.raw.kwl,
        AUDIOSRCSTATUSHwSettings: (_x) => _x.raw.kwl,
        SRCSettings: (_x) => _x.raw.kwl,
    };
    class AUDIOSRCSTATUS {
        raw;
        type_identifier = "SampleRateConverter::Data::AUDIOSRCSTATUS";
        constructor(raw) {
            this.raw = raw;
        }
        get hw_settings() {
            return VAPI.AT1130.SampleRateConverter.lift.AUDIOSRCSTATUSHwSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "hw_settings"));
        }
        get t_src() {
            return new VScript.rKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get hw_resource_mux() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "hw_resource_mux"), (raw, _) => VAPI.AT1130.SampleRateConverter.lift.RESOURCE(raw));
        }
    }
    SampleRateConverter.AUDIOSRCSTATUS = AUDIOSRCSTATUS;
    class All {
        raw;
        type_identifier = "SampleRateConverter::Data::All";
        get runtime_constants() {
            return {
                num_srcs: this.raw.backing_store.get_runtime_constant("SampleRateConverter::num_srcs"),
                num_src_inputs: this.raw.backing_store.get_runtime_constant("SampleRateConverter::num_src_inputs"),
                num_srcs_x24: this.raw.backing_store.get_runtime_constant("SampleRateConverter::num_srcs_x24")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get instances() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "instances"), (raw) => new VAPI.AT1130.SampleRateConverter.SRCAsNamedTableRow(raw));
        }
        get hardware_resources() {
            return VAPI.AT1130.SampleRateConverter.lift.RESOURCES(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "hardware_resources"));
        }
    }
    SampleRateConverter.All = All;
    class INPUTSTATUS {
        raw;
        type_identifier = "SampleRateConverter::Data::INPUTSTATUS";
        constructor(raw) {
            this.raw = raw;
        }
        get hw_value() {
            return new VScript.rKeyword(this, "hw_value", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get audio_src() {
            return new VScript.rKeyword(this, "audio_src", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get sop_src() {
            return new VScript.rKeyword(this, "sop_src", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get input_bus_selection() {
            return new VScript.rKeyword(this, "input_bus_selection", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get mpx_bus() {
            return new VScript.rKeyword(this, "mpx_bus", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get enable() {
            return new VScript.rKeyword(this, "enable", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    SampleRateConverter.INPUTSTATUS = INPUTSTATUS;
    class RESOURCE {
        raw;
        type_identifier = "SampleRateConverter::Data::RESOURCE";
        constructor(raw) {
            this.raw = raw;
        }
        get mux() {
            return VAPI.AT1130.SampleRateConverter.lift.INPUTSTATUS(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "mux"));
        }
        get read_status() {
            return VAPI.SampleRateConverter.lift.READSTATUS(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "read_status"));
        }
        get audio_source_slices() {
            return VAPI.Audio.lift.SignalSourceSlice(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "audio_source_slices"));
        }
        get related_mux() {
            return new VScript.rKeyword(this, "related_mux", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.SampleRateConverter.RESOURCE(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
    }
    SampleRateConverter.RESOURCE = RESOURCE;
    class RESOURCES {
        raw;
        type_identifier = "SampleRateConverter::Data::RESOURCES";
        constructor(raw) {
            this.raw = raw;
        }
        get hw_resource_x24() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "hw_resource_x24"), (raw, _) => VAPI.AT1130.SampleRateConverter.lift.AUDIOSRCSTATUS(raw));
        }
    }
    SampleRateConverter.RESOURCES = RESOURCES;
    class SRC {
        raw;
        type_identifier = "SampleRateConverter::Data::SRC";
        constructor(raw) {
            this.raw = raw;
        }
        get active() {
            return new VScript.dKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get settings() {
            return VAPI.AT1130.SampleRateConverter.lift.SRCSettings(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "settings"));
        }
        get a_src() {
            return new VScript.dKeyword(this, "a_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Audio.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "output"));
        }
        get connected_hardware() {
            return VAPI.AT1130.SampleRateConverter.lift.SRCHardware(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "connected_hardware"));
        }
    }
    SampleRateConverter.SRC = SRC;
    class SRCAsNamedTableRow extends SRC {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    SampleRateConverter.SRCAsNamedTableRow = SRCAsNamedTableRow;
    class SRCHardware {
        raw;
        type_identifier = "SampleRateConverter::Data::SRCHardware";
        constructor(raw) {
            this.raw = raw;
        }
        get hw() {
            return new VScript.rKeyword(this, "hw", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.SampleRateConverter.AUDIOSRCSTATUS(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get hw_mux() {
            return new VScript.rKeyword(this, "hw_mux", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.SampleRateConverter.INPUTSTATUS(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))
            });
        }
    }
    SampleRateConverter.SRCHardware = SRCHardware;
    class Time {
        raw;
        type_identifier = "SampleRateConverter::Data::Time";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
    }
    SampleRateConverter.Time = Time;
    class AUDIOSRCSTATUSHwSettings {
        raw;
        type_identifier = "SampleRateConverter::Data::AUDIOSRCSTATUS::HwSettings";
        constructor(raw) {
            this.raw = raw;
        }
        get hw_value() {
            return new VScript.rKeyword(this, "hw_value", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          index of the selected genlock 1...6, 0 = disabled
        */
        get genlock_sel() {
            return new VScript.rKeyword(this, "genlock_sel", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          0 = no reset; 1 = reset
        */
        get reset() {
            return new VScript.rKeyword(this, "reset", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    SampleRateConverter.AUDIOSRCSTATUSHwSettings = AUDIOSRCSTATUSHwSettings;
    class SRCSettings {
        raw;
        type_identifier = "SampleRateConverter::Data::SRC::Settings";
        constructor(raw) {
            this.raw = raw;
        }
        get channel_capacity() {
            return new VScript.dKeyword(this, "channel_capacity", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
    }
    SampleRateConverter.SRCSettings = SRCSettings;
})(SampleRateConverter || (SampleRateConverter = {}));
export var Splitter;
(function (Splitter) {
    Splitter.lift = {
        All: (_raw) => (new All(_raw)),
        SP: (_raw) => (new SP(_raw)),
        SPOutputs: (_raw) => (new SPOutputs(_raw)),
    };
    Splitter.lower = {
        All: (_x) => _x.raw.kwl,
        SP: (_x) => _x.raw.kwl,
        SPOutputs: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "Splitter::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get instances() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "instances"), (raw) => new VAPI.AT1130.Splitter.SPAsNamedTableRow(raw));
        }
    }
    Splitter.All = All;
    class SP {
        raw;
        type_identifier = "Splitter::Data::SP";
        constructor(raw) {
            this.raw = raw;
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get outputs() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "outputs"), (raw, _) => VAPI.AT1130.Splitter.lift.SPOutputs(raw));
        }
    }
    Splitter.SP = SP;
    class SPAsNamedTableRow extends SP {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    Splitter.SPAsNamedTableRow = SPAsNamedTableRow;
    class SPOutputs {
        raw;
        type_identifier = "Splitter::Data::SP::Outputs";
        constructor(raw) {
            this.raw = raw;
        }
        get output() {
            return VAPI.AT1130.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "output"));
        }
    }
    Splitter.SPOutputs = SPOutputs;
})(Splitter || (Splitter = {}));
export var System;
(function (System) {
    System.lift = {
        All: (_raw) => (new All(_raw)),
        InternalHW: (_raw) => (new InternalHW(_raw)),
        MEMORY: (_raw) => (new MEMORY(_raw)),
        Partitions: (_raw) => (new Partitions(_raw)),
        Power: (_raw) => (new Power(_raw)),
        Temperature: (_raw) => (new Temperature(_raw)),
        PartitionsEmmc: (_raw) => (new PartitionsEmmc(_raw)),
        AllSysinfo: (_raw) => (new AllSysinfo(_raw)),
        InternalHWXfi: (_raw) => (new InternalHWXfi(_raw)),
    };
    System.lower = {
        All: (_x) => _x.raw.kwl,
        InternalHW: (_x) => _x.raw.kwl,
        MEMORY: (_x) => _x.raw.kwl,
        Partitions: (_x) => _x.raw.kwl,
        Power: (_x) => _x.raw.kwl,
        Temperature: (_x) => _x.raw.kwl,
        PartitionsEmmc: (_x) => _x.raw.kwl,
        AllSysinfo: (_x) => _x.raw.kwl,
        InternalHWXfi: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "System::Data::All";
        get runtime_constants() {
            return {
                is_udx: this.raw.backing_store.get_runtime_constant("System::is_udx"),
                is_no_pcap: this.raw.backing_store.get_runtime_constant("System::is_no_pcap"),
                is_multiviewer: this.raw.backing_store.get_runtime_constant("System::is_multiviewer"),
                is_j2kdecoder: this.raw.backing_store.get_runtime_constant("System::is_j2kdecoder"),
                has_replay: this.raw.backing_store.get_runtime_constant("System::has_replay"),
                has_audio_mixer: this.raw.backing_store.get_runtime_constant("System::has_audio_mixer"),
                has_color_correction: this.raw.backing_store.get_runtime_constant("System::has_color_correction"),
                has_video_mixer: this.raw.backing_store.get_runtime_constant("System::has_video_mixer"),
                has_audio_gain: this.raw.backing_store.get_runtime_constant("System::has_audio_gain"),
                supports_metadata_extraction: this.raw.backing_store.get_runtime_constant("System::supports_metadata_extraction"),
                is_pcap: this.raw.backing_store.get_runtime_constant("System::is_pcap"),
                has_passthrough_transmitters: this.raw.backing_store.get_runtime_constant("System::has_passthrough_transmitters"),
                is_jpegxs: this.raw.backing_store.get_runtime_constant("System::is_jpegxs"),
                has_audio_engine: this.raw.backing_store.get_runtime_constant("System::has_audio_engine")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get temperature() {
            return VAPI.AT1130.System.lift.Temperature(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "temperature"));
        }
        get power() {
            return VAPI.AT1130.System.lift.Power(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "power"));
        }
        get fan_speed() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 2, "fan_speed"), (raw, _) => VAPI.System.lift.FanSpeed(raw));
        }
        get barebox_version() {
            return new VScript.rKeyword(this, "barebox_version", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get barebox_state() {
            return new VScript.rKeyword(this, "barebox_state", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get booted_partition() {
            return new VScript.rKeyword(this, "booted_partition", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get partitions() {
            return VAPI.AT1130.System.lift.Partitions(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "partitions"));
        }
        get watchdog_version() {
            return new VScript.rKeyword(this, "watchdog_version", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.System.lift.Revision),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.System.lower.Revision)
            });
        }
        get sysinfo() {
            return VAPI.AT1130.System.lift.AllSysinfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "sysinfo"));
        }
        get usrinfo() {
            return VAPI.System.lift.AllUsrinfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 9, "usrinfo"));
        }
        get neighborhood_watch() {
            return VAPI.System.lift.NeighborhoodWatch(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "neighborhood_watch"));
        }
        get psu() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 11, "psu"), (raw, _) => VAPI.System.lift.PSU(raw));
        }
        get qsfp() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 12, "qsfp"), (raw, _) => VAPI.System.lift.QSFP(raw));
        }
        get ecc() {
            return VAPI.System.lift.AllEcc(VScript.VAPIHelpers.subtree_child_checked(this.raw, 13, "ecc"));
        }
        get unique_id() {
            return new VScript.rKeyword(this, "unique_id", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get fpga() {
            return VAPI.System.lift.CompileInfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 15, "fpga"));
        }
        get device() {
            return VAPI.System.lift.Device(VScript.VAPIHelpers.subtree_child_checked(this.raw, 16, "device"));
        }
        get io_board() {
            return VAPI.System.lift.AllIoBoard(VScript.VAPIHelpers.subtree_child_checked(this.raw, 17, "io_board"));
        }
        get fan_board() {
            return VAPI.System.lift.Device(VScript.VAPIHelpers.subtree_child_checked(this.raw, 18, "fan_board"));
        }
        get frame() {
            return VAPI.System.lift.Device(VScript.VAPIHelpers.subtree_child_checked(this.raw, 19, "frame"));
        }
        get memory() {
            return VAPI.AT1130.System.lift.MEMORY(VScript.VAPIHelpers.subtree_child_checked(this.raw, 20, "memory"));
        }
        get internal_hw() {
            return VAPI.AT1130.System.lift.InternalHW(VScript.VAPIHelpers.subtree_child_checked(this.raw, 21, "internal_hw"));
        }
        /**
          FPGA debug bus at last reboot
        */
        get previous_dbg_bus() {
            return new VScript.rKeyword(this, "previous_dbg_bus", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Watchdog event log - contains boot reason and times
        */
        get watchdog_event_log() {
            return new VScript.rKeyword(this, "watchdog_event_log", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get board_location() {
            return new VScript.rKeyword(this, "board_location", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get frontpanel_led_brightness() {
            return new VScript.rwKeyword(this, "frontpanel_led_brightness", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Blink the front panel LED in blue to help locating this blade
        */
        get frontpanel_blink_blue() {
            return new VScript.rwKeyword(this, "frontpanel_blink_blue", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get slots() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 27, "slots"), (raw, _) => VAPI.System.lift.SlotInformation(raw));
        }
        get services() {
            return VAPI.System.lift.AllServices(VScript.VAPIHelpers.subtree_child_checked(this.raw, 28, "services"));
        }
        /**
          Currently loaded FPGA
        */
        get selected_fpga() {
            return new VScript.rKeyword(this, "selected_fpga", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Change which FPGA to load on next reboot
        */
        get select_fpga() {
            return new VScript.dKeyword(this, "select_fpga", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          @brief Perform a reboot of the blade
          @desc Type in `reboot` to reboot the current partition. Type in `system0`
          or `system1` to reboot to the respective partition.
        */
        get reboot() {
            return new VScript.rwKeyword(this, "reboot", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          @brief Perform a power cycle
          @desc Enter `powercycle` to interrupt blade power for 3 seconds
        */
        get powercycle() {
            return new VScript.rwKeyword(this, "powercycle", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          @brief Reset NVRAM
          @desc Enter `reset` to clear all settings and reboot
        */
        get reset() {
            return new VScript.rwKeyword(this, "reset", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get command_logging() {
            return VAPI.System.lift.AllCommandLogging(VScript.VAPIHelpers.subtree_child_checked(this.raw, 34, "command_logging"));
        }
        get nmos() {
            return VAPI.System.lift.AllNmos(VScript.VAPIHelpers.subtree_child_checked(this.raw, 35, "nmos"));
        }
    }
    System.All = All;
    class InternalHW {
        raw;
        type_identifier = "System::Data::InternalHW";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          Active PCIe lanes - should be 4
        */
        get pcie_lanes() {
            return new VScript.rKeyword(this, "pcie_lanes", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Active PCIe speed - should be GT_8_0
        */
        get pcie_speed() {
            return new VScript.rKeyword(this, "pcie_speed", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get xfi() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 2, "xfi"), (st, _) => VAPI.AT1130.System.lift.InternalHWXfi(st));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    wrong_pcie_speed_or_lanecount: (x & 1) !== 0
                }),
                lower: (x, _) => ((x.wrong_pcie_speed_or_lanecount ? 1 : 0))
            });
        }
    }
    System.InternalHW = InternalHW;
    class MEMORY {
        raw;
        type_identifier = "System::Data::MEMORY";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          if RAM calibration failed and rebooting does not fix the issue, please
          contact customer support
        */
        get ram_sodimm() {
            return new VScript.rKeyword(this, "ram_sodimm", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          J20
        */
        get spd_sodimm() {
            return VAPI.System.lift.SPD(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "spd_sodimm"));
        }
    }
    System.MEMORY = MEMORY;
    class Partitions {
        raw;
        type_identifier = "System::Data::Partitions";
        constructor(raw) {
            this.raw = raw;
        }
        get booted() {
            return new VScript.rKeyword(this, "booted", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.System.SWVersion(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get recovery() {
            return VAPI.System.lift.SWVersion(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "recovery"));
        }
        get system0() {
            return VAPI.System.lift.SWVersion(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "system0"));
        }
        get system1() {
            return VAPI.System.lift.SWVersion(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "system1"));
        }
        get emmc() {
            return VAPI.AT1130.System.lift.PartitionsEmmc(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "emmc"));
        }
    }
    System.Partitions = Partitions;
    class Power {
        raw;
        type_identifier = "System::Data::Power";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          Power usage for P0V9_B
        */
        get p0v9_b() {
            return new VScript.rKeyword(this, "p0v9_b", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Power usage for P1V2 (HBM)
        */
        get p1v2_hbm() {
            return new VScript.rKeyword(this, "p1v2_hbm", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Power usage for P1V8
        */
        get p1v8() {
            return new VScript.rKeyword(this, "p1v8", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Power usage for P1V8
        */
        get p5v0() {
            return new VScript.rKeyword(this, "p5v0", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    System.Power = Power;
    class Temperature {
        raw;
        type_identifier = "System::Data::Temperature";
        constructor(raw) {
            this.raw = raw;
        }
        get fpga_ext_core() {
            return new VScript.rKeyword(this, "fpga_ext_core", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get fpga_ext_htile() {
            return new VScript.rKeyword(this, "fpga_ext_htile", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get fpga_ext_etile() {
            return new VScript.rKeyword(this, "fpga_ext_etile", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get fpga_int_core() {
            return new VScript.rKeyword(this, "fpga_int_core", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get fpga_int_htile() {
            return new VScript.rKeyword(this, "fpga_int_htile", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get fpga_int_etile() {
            return new VScript.rKeyword(this, "fpga_int_etile", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get fpga_int_hbm_top() {
            return new VScript.rKeyword(this, "fpga_int_hbm_top", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get fpga_int_hbm_bot() {
            return new VScript.rKeyword(this, "fpga_int_hbm_bot", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get cpu() {
            return new VScript.rKeyword(this, "cpu", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get cpu_module() {
            return new VScript.rKeyword(this, "cpu_module", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Temperature of IO-Board
        */
        get ioboard() {
            return new VScript.rKeyword(this, "ioboard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Temperature of FPGA-SODIMM (J20)
        */
        get fpga_sodimm() {
            return new VScript.rKeyword(this, "fpga_sodimm", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Air intake temperature (frontview right)
        */
        get fan1_in() {
            return new VScript.rKeyword(this, "fan1_in", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Air intake temperature (frontview left)
        */
        get fan2_in() {
            return new VScript.rKeyword(this, "fan2_in", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Temperature of U15
        */
        get u15() {
            return new VScript.rKeyword(this, "u15", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Temperature of U18
        */
        get u18() {
            return new VScript.rKeyword(this, "u18", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Temperature of U21
        */
        get u21() {
            return new VScript.rKeyword(this, "u21", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Temperature of U23
        */
        get u23() {
            return new VScript.rKeyword(this, "u23", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Total minutes spent at overtemperature, where overtemperature is defined
          as follows:
          
          TBD
        */
        get accumulated_overtemperature_time() {
            return new VScript.rKeyword(this, "accumulated_overtemperature_time", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get current_fanspeed_profile() {
            return new VScript.rKeyword(this, "current_fanspeed_profile", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cpu_temperature_above_critical: (x & 1) !== 0,
                    cpu_temperature_high: (x & 2) !== 0,
                    fpga_ext_core_temperature_above_critical: (x & 4) !== 0,
                    fpga_ext_core_temperature_high: (x & 8) !== 0,
                    fpga_ext_etile_temperature_above_critical: (x & 16) !== 0,
                    fpga_ext_etile_temperature_high: (x & 32) !== 0,
                    fpga_ext_htile_temperature_above_critical: (x & 64) !== 0,
                    fpga_ext_htile_temperature_high: (x & 128) !== 0,
                    fpga_int_core_temperature_above_critical: (x & 256) !== 0,
                    fpga_int_core_temperature_high: (x & 512) !== 0,
                    fpga_int_etile_temperature_above_critical: (x & 1024) !== 0,
                    fpga_int_etile_temperature_high: (x & 2048) !== 0,
                    fpga_int_hbm_bot_temperature_above_critical: (x & 4096) !== 0,
                    fpga_int_hbm_bot_temperature_high: (x & 8192) !== 0,
                    fpga_int_hbm_top_temperature_above_critical: (x & 16384) !== 0,
                    fpga_int_hbm_top_temperature_high: (x & 32768) !== 0,
                    fpga_int_htile_temperature_above_critical: (x & 65536) !== 0,
                    fpga_int_htile_temperature_high: (x & 131072) !== 0,
                    fpga_sodimm_temperature_above_critical: (x & 262144) !== 0,
                    fpga_sodimm_temperature_high: (x & 524288) !== 0,
                    ioboard_temperature_above_critical: (x & 1048576) !== 0,
                    ioboard_temperature_high: (x & 2097152) !== 0,
                    missing_data: (x & 4194304) !== 0
                }),
                lower: (x, _) => ((x.cpu_temperature_above_critical ? 1 : 0) |
                    (x.cpu_temperature_high ? 2 : 0) |
                    (x.fpga_ext_core_temperature_above_critical ? 4 : 0) |
                    (x.fpga_ext_core_temperature_high ? 8 : 0) |
                    (x.fpga_ext_etile_temperature_above_critical ? 16 : 0) |
                    (x.fpga_ext_etile_temperature_high ? 32 : 0) |
                    (x.fpga_ext_htile_temperature_above_critical ? 64 : 0) |
                    (x.fpga_ext_htile_temperature_high ? 128 : 0) |
                    (x.fpga_int_core_temperature_above_critical ? 256 : 0) |
                    (x.fpga_int_core_temperature_high ? 512 : 0) |
                    (x.fpga_int_etile_temperature_above_critical ? 1024 : 0) |
                    (x.fpga_int_etile_temperature_high ? 2048 : 0) |
                    (x.fpga_int_hbm_bot_temperature_above_critical ? 4096 : 0) |
                    (x.fpga_int_hbm_bot_temperature_high ? 8192 : 0) |
                    (x.fpga_int_hbm_top_temperature_above_critical ? 16384 : 0) |
                    (x.fpga_int_hbm_top_temperature_high ? 32768 : 0) |
                    (x.fpga_int_htile_temperature_above_critical ? 65536 : 0) |
                    (x.fpga_int_htile_temperature_high ? 131072 : 0) |
                    (x.fpga_sodimm_temperature_above_critical ? 262144 : 0) |
                    (x.fpga_sodimm_temperature_high ? 524288 : 0) |
                    (x.ioboard_temperature_above_critical ? 1048576 : 0) |
                    (x.ioboard_temperature_high ? 2097152 : 0) |
                    (x.missing_data ? 4194304 : 0))
            });
        }
    }
    System.Temperature = Temperature;
    class PartitionsEmmc {
        raw;
        type_identifier = "System::Data::Partitions::Emmc";
        constructor(raw) {
            this.raw = raw;
        }
        get firmware_version() {
            return new VScript.rKeyword(this, "firmware_version", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get life_time_estimation() {
            return new VScript.rKeyword(this, "life_time_estimation", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get pre_eol_information() {
            return new VScript.rKeyword(this, "pre_eol_information", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    System.PartitionsEmmc = PartitionsEmmc;
    class AllSysinfo {
        raw;
        type_identifier = "System::Data::All::Sysinfo";
        constructor(raw) {
            this.raw = raw;
        }
        /**
          System runtime since boot
        */
        get uptime() {
            return new VScript.rKeyword(this, "uptime", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            });
        }
        /**
          Load average for 1, 5 and 15 minutes
        */
        get load_avg() {
            return new VScript.rKeyword(this, "load_avg", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Free memory
        */
        get freeram() {
            return new VScript.rKeyword(this, "freeram", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Number of running processes
        */
        get procs() {
            return new VScript.rKeyword(this, "procs", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        /**
          Number of currently active CPU cores
        */
        get num_cores() {
            return new VScript.rKeyword(this, "num_cores", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get services() {
            return VAPI.ServicesList.lift.ServicesList(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "services"));
        }
    }
    System.AllSysinfo = AllSysinfo;
    class InternalHWXfi {
        raw;
        type_identifier = "System::Data::InternalHW::Xfi";
        constructor(raw) {
            this.raw = raw;
        }
        get link_up() {
            return new VScript.rKeyword(this, "link_up", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get fault_status() {
            return new VScript.rKeyword(this, "fault_status", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get crc_errors() {
            return new VScript.rKeyword(this, "crc_errors", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get oversize_errors() {
            return new VScript.rKeyword(this, "oversize_errors", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get runt_errors() {
            return new VScript.rKeyword(this, "runt_errors", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
    }
    System.InternalHWXfi = InternalHWXfi;
    System.Enums = {
        FaultStatus: ["LINK_UP", "LOCAL_FAULT", "REMOTE_FAULT"],
        FPGASelection: ["AUDIO_100GbE", "AVP_100GbE", "JPEGXS_RX_100GbE", "JPEGXS_TX_100GbE", "PCAP_100GbE"],
        FPGA: ["AVP_100GbE", "DMV_100GbE", "JPEGXS_RX_100GbE", "JPEGXS_TX_100GbE", "PCAP_100GbE", "AUDIO_100GbE"]
    };
})(System || (System = {}));
export var SystemClock;
(function (SystemClock) {
    SystemClock.lift = {
        All: (_raw) => (new All(_raw)),
    };
    SystemClock.lower = { All: (_x) => _x.raw.kwl, };
    class All {
        raw;
        type_identifier = "SystemClock::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.rwKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        /**
          Determines the time standard the SystemClock will be set to.
          
          * `UTC` (Universal Time, Coordinated) is the standard for wall clock
          time. It is the standard that all timezones are based on. UTC has leap
          seconds to account for differences in the Earth's rotational speed. *When
          in doubt, always use `UTC`*
          
          * `TAI` (International Atomic Time) is the time standard used by PTP. It
          is a linear time standard that does not have leap seconds. TAI is
          currently ahead of UTC by 37 seconds.
        */
        get time_standard() {
            return new VScript.dKeyword(this, "time_standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    inaccurate_input: (x & 1) !== 0,
                    missing_offset: (x & 2) !== 0,
                    missing_utc_offset: (x & 4) !== 0,
                    out_of_bounds: (x & 8) !== 0,
                    unable_to_read_system_time: (x & 16) !== 0,
                    unable_to_set_system_time: (x & 32) !== 0
                }),
                lower: (x, _) => ((x.inaccurate_input ? 1 : 0) |
                    (x.missing_offset ? 2 : 0) |
                    (x.missing_utc_offset ? 4 : 0) |
                    (x.out_of_bounds ? 8 : 0) |
                    (x.unable_to_read_system_time ? 16 : 0) |
                    (x.unable_to_set_system_time ? 32 : 0))
            });
        }
        get system_time_updates() {
            return new VScript.rKeyword(this, "system_time_updates", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get system_time() {
            return new VScript.rKeyword(this, "system_time", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftTimestamp),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerTimestamp)
            });
        }
        /**
          use this to override `output.characteristics.offset_type`; may be useful
          to, e.g., redistribute BlackBurst-derived local time as (absolute) PTP
          time
        */
        get offset_type_override() {
            return new VScript.rwKeyword(this, "offset_type_override", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get output() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "ptp_traits"));
        }
    }
    SystemClock.All = All;
})(SystemClock || (SystemClock = {}));
export var Time;
(function (Time) {
    Time.lift = {
        AnalogReference: (_raw) => (new AnalogReference(_raw)),
        Source: (_raw) => (new Source(_raw)),
    };
    Time.lower = {
        AnalogReference: (_x) => _x.raw.kwl,
        Source: (_x) => _x.raw.kwl,
    };
    class AnalogReference {
        raw;
        type_identifier = "Time::Data::AnalogReference";
        constructor(raw) {
            this.raw = raw;
        }
        get output() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "ptp_traits"));
        }
    }
    Time.AnalogReference = AnalogReference;
    class Source {
        raw;
        type_identifier = "Time::Data::Source";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get characteristics() {
            return new VScript.rKeyword(this, "characteristics", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lift.SourceCharacteristics),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lower.SourceCharacteristics)
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    cycle_detected: (x & 1) !== 0
                }),
                lower: (x, _) => ((x.cycle_detected ? 1 : 0))
            });
        }
        get drift() {
            return new VScript.rKeyword(this, "drift", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lift.TimestampedDrift),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lower.TimestampedDrift)
            });
        }
        get offset() {
            return new VScript.rKeyword(this, "offset", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lift.TimestampedOffset),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lower.TimestampedOffset)
            });
        }
        get time_code() {
            return new VScript.rKeyword(this, "time_code", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lift.TimestampedTimecode),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Time.lower.TimestampedTimecode)
            });
        }
        get ptp_traits() {
            return new VScript.rKeyword(this, "ptp_traits", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.PTP.Traits(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
        get genlock() {
            return new VScript.rKeyword(this, "genlock", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Genlock.AT1130GenlockBackend(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    Time.Source = Source;
})(Time || (Time = {}));
export var TimeFlows;
(function (TimeFlows) {
    TimeFlows.lift = {
        Aligner: (_raw) => (new Aligner(_raw)),
        All: (_raw) => (new All(_raw)),
        Combinator: (_raw) => (new Combinator(_raw)),
        Detonator: (_raw) => (new Detonator(_raw)),
        DriftConverter: (_raw) => (new DriftConverter(_raw)),
        Impostor: (_raw) => (new Impostor(_raw)),
        Selector: (_raw) => (new Selector(_raw)),
        Shifter: (_raw) => (new Shifter(_raw)),
        Stretcher: (_raw) => (new Stretcher(_raw)),
    };
    TimeFlows.lower = {
        Aligner: (_x) => _x.raw.kwl,
        All: (_x) => _x.raw.kwl,
        Combinator: (_x) => _x.raw.kwl,
        Detonator: (_x) => _x.raw.kwl,
        DriftConverter: (_x) => _x.raw.kwl,
        Impostor: (_x) => _x.raw.kwl,
        Selector: (_x) => _x.raw.kwl,
        Shifter: (_x) => _x.raw.kwl,
        Stretcher: (_x) => _x.raw.kwl,
    };
    class Aligner {
        raw;
        type_identifier = "TimeFlows::Data::Aligner";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src_absolute() {
            return new VScript.dKeyword(this, "t_src_absolute", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get t_src_grain_accurate() {
            return new VScript.dKeyword(this, "t_src_grain_accurate", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get warning_threshold() {
            return new VScript.dKeyword(this, "warning_threshold", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get holdover_grains() {
            return new VScript.dKeyword(this, "holdover_grains", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get output() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "ptp_traits"));
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    above_warning_threshold: (x & 1) !== 0,
                    holdover_due_to_frequency_change: (x & 2) !== 0,
                    holdover_due_to_input_jump: (x & 4) !== 0
                }),
                lower: (x, _) => ((x.above_warning_threshold ? 1 : 0) |
                    (x.holdover_due_to_frequency_change ? 2 : 0) |
                    (x.holdover_due_to_input_jump ? 4 : 0))
            });
        }
    }
    TimeFlows.Aligner = Aligner;
    class AlignerAsNamedTableRow extends Aligner {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.AlignerAsNamedTableRow = AlignerAsNamedTableRow;
    class All {
        raw;
        type_identifier = "TimeFlows::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get aligners() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "aligners"), (raw) => new VAPI.AT1130.TimeFlows.AlignerAsNamedTableRow(raw));
        }
        get combinators() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "combinators"), (raw) => new VAPI.AT1130.TimeFlows.CombinatorAsNamedTableRow(raw));
        }
        get detonators() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 2, "detonators"), (raw) => new VAPI.AT1130.TimeFlows.DetonatorAsNamedTableRow(raw));
        }
        get drift_converters() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 3, "drift_converters"), (raw) => new VAPI.AT1130.TimeFlows.DriftConverterAsNamedTableRow(raw));
        }
        get impostors() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 4, "impostors"), (raw) => new VAPI.AT1130.TimeFlows.ImpostorAsNamedTableRow(raw));
        }
        get selectors() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 5, "selectors"), (raw) => new VAPI.AT1130.TimeFlows.SelectorAsNamedTableRow(raw));
        }
        get shifters() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 6, "shifters"), (raw) => new VAPI.AT1130.TimeFlows.ShifterAsNamedTableRow(raw));
        }
        /**
          stretchers shift their input source's measured drift by a user-defined
          amount (note that this demotes `Absolute` and `GrainAccurate` time
          sources to class `FrequencyOnly`). Stretchers are probably useless in a
          production setting, but can be helpful in simulating failure scenarios.
        */
        get stretchers() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 7, "stretchers"), (raw) => new VAPI.AT1130.TimeFlows.StretcherAsNamedTableRow(raw));
        }
    }
    TimeFlows.All = All;
    class Combinator {
        raw;
        type_identifier = "TimeFlows::Data::Combinator";
        constructor(raw) {
            this.raw = raw;
        }
        get required_offset_type() {
            return new VScript.rwKeyword(this, "required_offset_type", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get required_ptp_source_type() {
            return new VScript.rwKeyword(this, "required_ptp_source_type", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get drift_reference() {
            return new VScript.rwKeyword(this, "drift_reference", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get min_drift_tolerance() {
            return new VScript.rwKeyword(this, "min_drift_tolerance", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get min_offset_tolerance() {
            return new VScript.rwKeyword(this, "min_offset_tolerance", {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, null);
        }
        get quorum() {
            return new VScript.dKeyword(this, "quorum", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get session_length() {
            return new VScript.dKeyword(this, "session_length", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get selected() {
            return new VScript.rKeyword(this, "selected", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get output() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 9, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "ptp_traits"));
        }
    }
    TimeFlows.Combinator = Combinator;
    class CombinatorAsNamedTableRow extends Combinator {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.CombinatorAsNamedTableRow = CombinatorAsNamedTableRow;
    class Detonator {
        raw;
        type_identifier = "TimeFlows::Data::Detonator";
        constructor(raw) {
            this.raw = raw;
        }
        get max_drift_blast() {
            return new VScript.rwKeyword(this, "max_drift_blast", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get max_offset_blast() {
            return new VScript.rwKeyword(this, "max_offset_blast", {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, {
                lift: VScript.VAPIHelpers.liftSeconds,
                lower: VScript.VAPIHelpers.lowerSeconds
            }, null);
        }
        /**
          Discharge
        */
        get discharge() {
            return new VScript.wKeyword(this, "discharge", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Realign
        */
        get realign() {
            return new VScript.wKeyword(this, "realign", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get friction() {
            return new VScript.rwKeyword(this, "friction", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get stiffness() {
            return new VScript.rwKeyword(this, "stiffness", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "ptp_traits"));
        }
    }
    TimeFlows.Detonator = Detonator;
    class DetonatorAsNamedTableRow extends Detonator {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.DetonatorAsNamedTableRow = DetonatorAsNamedTableRow;
    class DriftConverter {
        raw;
        type_identifier = "TimeFlows::Data::DriftConverter";
        constructor(raw) {
            this.raw = raw;
        }
        get drift_reference() {
            return new VScript.rwKeyword(this, "drift_reference", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          ideally, all inputs to a clock combinator should use the same reference
          frame as the clock combinator itself. If this is not the case,
          mismatching inputs will be discarded by default. By setting
          `on_reference_frame_mismatch` to `Convert`, inputs can also be converted
          to the combinator's own reference frame. Note, however, that this
          generally incurs a loss in precision
        */
        get on_drift_reference_mismatch() {
            return new VScript.rwKeyword(this, "on_drift_reference_mismatch", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "ptp_traits"));
        }
    }
    TimeFlows.DriftConverter = DriftConverter;
    class DriftConverterAsNamedTableRow extends DriftConverter {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.DriftConverterAsNamedTableRow = DriftConverterAsNamedTableRow;
    class Impostor {
        raw;
        type_identifier = "TimeFlows::Data::Impostor";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        /**
          Insert specified `grain_rate`, or upgrade input to absolute time source
          if null
        */
        get grain_rate() {
            return new VScript.rwKeyword(this, "grain_rate", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get output() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "output"));
        }
    }
    TimeFlows.Impostor = Impostor;
    class ImpostorAsNamedTableRow extends Impostor {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.ImpostorAsNamedTableRow = ImpostorAsNamedTableRow;
    class Selector {
        raw;
        type_identifier = "TimeFlows::Data::Selector";
        constructor(raw) {
            this.raw = raw;
        }
        get selected() {
            return new VScript.rKeyword(this, "selected", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl)))),
                lower: (elems, socket) => VScript.VAPIHelpers.mapMaybeSparseArray(elems, (el) => (VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl))(el, socket)) /* FIXME: we're currently casting to any because we don't distinguish between read payloads, as sent by the backend, and lowered write payloads */
            }, null);
        }
        get required_offset_type() {
            return new VScript.rwKeyword(this, "required_offset_type", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get required_drift_reference() {
            return new VScript.rwKeyword(this, "required_drift_reference", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get required_ptp_source_type() {
            return new VScript.rwKeyword(this, "required_ptp_source_type", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get output() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "ptp_traits"));
        }
    }
    TimeFlows.Selector = Selector;
    class SelectorAsNamedTableRow extends Selector {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.SelectorAsNamedTableRow = SelectorAsNamedTableRow;
    class Shifter {
        raw;
        type_identifier = "TimeFlows::Data::Shifter";
        constructor(raw) {
            this.raw = raw;
        }
        get shift() {
            return new VScript.rwKeyword(this, "shift", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "ptp_traits"));
        }
    }
    TimeFlows.Shifter = Shifter;
    class ShifterAsNamedTableRow extends Shifter {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.ShifterAsNamedTableRow = ShifterAsNamedTableRow;
    class Stretcher {
        raw;
        type_identifier = "TimeFlows::Data::Stretcher";
        constructor(raw) {
            this.raw = raw;
        }
        get frequency_shift() {
            return new VScript.rwKeyword(this, "frequency_shift", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get output() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "output"));
        }
        get ptp_traits() {
            return VAPI.PTP.lift.Traits(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "ptp_traits"));
        }
    }
    TimeFlows.Stretcher = Stretcher;
    class StretcherAsNamedTableRow extends Stretcher {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    TimeFlows.StretcherAsNamedTableRow = StretcherAsNamedTableRow;
})(TimeFlows || (TimeFlows = {}));
export var UDX;
(function (UDX) {
    UDX.lift = {
        All: (_raw) => (new All(_raw)),
        UDXOutput: (_raw) => (new UDXOutput(_raw)),
    };
    UDX.lower = {
        All: (_x) => _x.raw.kwl,
        UDXOutput: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "UDX::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get outputs() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "outputs"), (raw, _) => VAPI.AT1130.UDX.lift.UDXOutput(raw));
        }
        get statistics() {
            return VAPI.UDX.lift.UDXStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "statistics"));
        }
    }
    UDX.All = All;
    class UDXOutput {
        raw;
        type_identifier = "UDX::Data::UDXOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get video_source() {
            return new VScript.rwKeyword(this, "video_source", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get video_standard() {
            return new VScript.rwKeyword(this, "video_standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get aspect_ratio() {
            return new VScript.dKeyword(this, "aspect_ratio", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get sd_active_pixels() {
            return new VScript.rwKeyword(this, "sd_active_pixels", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get video_full_range() {
            return new VScript.rwKeyword(this, "video_full_range", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get on_video_source_lost() {
            return new VScript.rwKeyword(this, "on_video_source_lost", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get crop() {
            return VAPI.UDX.lift.UDXVideoCrop(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "crop"));
        }
        get transform() {
            return VAPI.UDX.lift.UDXTransform(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "transform"));
        }
        get filter() {
            return VAPI.UDX.lift.UDXFilter(VScript.VAPIHelpers.subtree_child_checked(this.raw, 8, "filter"));
        }
        get signal() {
            return VAPI.AT1130.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 9, "signal"));
        }
        get metadata_inserter() {
            return VAPI.AT1130.MetadataProcessor.lift.MetadataInserter(VScript.VAPIHelpers.subtree_child_checked(this.raw, 10, "metadata_inserter"));
        }
    }
    UDX.UDXOutput = UDXOutput;
})(UDX || (UDX = {}));
export var UDXMetadataRequests;
(function (UDXMetadataRequests) {
    UDXMetadataRequests.lift = {
        All: (_raw) => (new All(_raw)),
    };
    UDXMetadataRequests.lower = { All: (_x) => _x.raw.kwl, };
    class All {
        raw;
        type_identifier = "UDXMetadataRequests::Data::All";
        constructor(raw) {
            this.raw = raw;
        }
        get requests() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "requests"), (raw, _) => VAPI.AT1130.MetadataProcessor.lift.Request(raw));
        }
    }
    UDXMetadataRequests.All = All;
})(UDXMetadataRequests || (UDXMetadataRequests = {}));
export var Video;
(function (Video) {
    Video.lift = {
        Essence: (_raw) => (new Essence(_raw)),
        TimedSource: (_raw, _socket) => {
            return {
                source: _raw[0] === null ? null : new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, _raw[0])),
                switch_time: _raw[1] === null ? null : VScript.VAPIHelpers.liftTimestamp(_raw[1], _socket)
            };
        },
    };
    Video.lower = {
        Essence: (_x) => _x.raw.kwl,
        TimedSource: (_x, _socket) => [
            _x.source === null ? null : _x.source.raw.kwl,
            _x.switch_time === null ? null : VScript.VAPIHelpers.lowerTimestamp(_x.switch_time, _socket)
        ],
    };
    class Essence {
        raw;
        type_identifier = "Video::Data::Essence";
        constructor(raw) {
            this.raw = raw;
        }
        get brief() {
            return new VScript.rKeyword(this, "brief", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get standard() {
            return new VScript.rKeyword(this, "standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get pixel_format() {
            return new VScript.rKeyword(this, "pixel_format", {
                lift: VAPI.Video.lift.PixelFormat,
                lower: VAPI.Video.lower.PixelFormat
            });
        }
        get substream() {
            return new VScript.rKeyword(this, "substream", {
                lift: VAPI.Video.lift.EssenceSubstream,
                lower: VAPI.Video.lower.EssenceSubstream
            });
        }
        get frozen() {
            return new VScript.rKeyword(this, "frozen", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get black() {
            return new VScript.rKeyword(this, "black", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get dt_node() {
            return new VScript.rKeyword(this, "dt_node", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x /* FIXME */, _) => x)
            });
        }
        /**
          some signal sources, such as RTP audio/video streams, include a
          well-defined offset to the PTP epoch (as seen by the sender). During
          processing, these 'media clocks' may shift (e.g., as signals pass through
          delay elements) or broaden into finite intervals (e.g., as audio channels
          at different offsets to the PTP epoch are combined into a single audio
          essence). Using the `media_clock` keyword, such changes are tracked
          explicitly and forwarded to audio/video transmitters.
        */
        get media_clock() {
            return VAPI.AT1130.Time.lift.Source(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "media_clock"));
        }
        get afd() {
            return new VScript.rKeyword(this, "afd", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lift.AFD),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VAPI.Video.lower.AFD)
            });
        }
        get cc() {
            return new VScript.rKeyword(this, "cc", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.Video.ClosedCaption(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    Video.Essence = Essence;
})(Video || (Video = {}));
export var VideoMixer;
(function (VideoMixer) {
    VideoMixer.lift = {
        All: (_raw) => (new All(_raw)),
        BSLK: (_raw) => (new BSLK(_raw)),
        BSLKLumaKeyer: (_raw) => (new BSLKLumaKeyer(_raw)),
    };
    VideoMixer.lower = {
        All: (_x) => _x.raw.kwl,
        BSLK: (_x) => _x.raw.kwl,
        BSLKLumaKeyer: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "VideoMixer::Data::All";
        get runtime_constants() {
            return {
                num_instances: this.raw.backing_store.get_runtime_constant("VideoMixer::num_instances")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get instances() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "instances"), (raw) => new VAPI.AT1130.VideoMixer.BSLKAsNamedTableRow(raw));
        }
    }
    VideoMixer.All = All;
    class BSLK {
        raw;
        type_identifier = "VideoMixer::Data::BSLK";
        constructor(raw) {
            this.raw = raw;
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    luma_keyer_v_src_out_of_range: (x & 1) !== 0,
                    mismatching_standards: (x & 2) !== 0,
                    missing_input: (x & 4) !== 0,
                    no_background: (x & 8) !== 0,
                    no_hw_resources: (x & 16) !== 0,
                    uhd_resources_required: (x & 32) !== 0,
                    v_src0_out_of_range: (x & 64) !== 0,
                    v_src1_out_of_range: (x & 128) !== 0
                }),
                lower: (x, _) => ((x.luma_keyer_v_src_out_of_range ? 1 : 0) |
                    (x.mismatching_standards ? 2 : 0) |
                    (x.missing_input ? 4 : 0) |
                    (x.no_background ? 8 : 0) |
                    (x.no_hw_resources ? 16 : 0) |
                    (x.uhd_resources_required ? 32 : 0) |
                    (x.v_src0_out_of_range ? 64 : 0) |
                    (x.v_src1_out_of_range ? 128 : 0))
            });
        }
        get v_src0() {
            return new VScript.dKeyword(this, "v_src0", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get v_src1() {
            return new VScript.dKeyword(this, "v_src1", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get phase_target() {
            return new VScript.dKeyword(this, "phase_target", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get in_phase() {
            return new VScript.rKeyword(this, "in_phase", {
                lift: VScript.VAPIHelpers.liftArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds)),
                lower: VScript.VAPIHelpers.lowerArray(VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds))
            });
        }
        get phase_rst_counter() {
            return new VScript.rKeyword(this, "phase_rst_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get output() {
            return VAPI.AT1130.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "output"));
        }
        get reserve_uhd_resources() {
            return new VScript.dKeyword(this, "reserve_uhd_resources", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get hw_resources() {
            return new VScript.rKeyword(this, "hw_resources", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get mode() {
            return new VScript.rwKeyword(this, "mode", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get luma_keyer() {
            return VAPI.AT1130.VideoMixer.lift.BSLKLumaKeyer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 11, "luma_keyer"));
        }
        get mixer() {
            return VAPI.VideoMixer.lift.BSLKMixer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 12, "mixer"));
        }
    }
    VideoMixer.BSLK = BSLK;
    class BSLKAsNamedTableRow extends BSLK {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    VideoMixer.BSLKAsNamedTableRow = BSLKAsNamedTableRow;
    class BSLKLumaKeyer {
        raw;
        type_identifier = "VideoMixer::Data::BSLK::LumaKeyer";
        constructor(raw) {
            this.raw = raw;
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        /**
          Luminance level at and below which everything is transparent
        */
        get clip() {
            return new VScript.rwKeyword(this, "clip", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        /**
          Luminance range above clip to reach full opacity
        */
        get gain() {
            return new VScript.rwKeyword(this, "gain", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get opacity() {
            return VAPI.VideoMixer.lift.AutoFader(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "opacity"));
        }
        /**
          Invert the transparent / opaque ends of the output range
        */
        get invert() {
            return new VScript.rwKeyword(this, "invert", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    VideoMixer.BSLKLumaKeyer = BSLKLumaKeyer;
})(VideoMixer || (VideoMixer = {}));
export var VideoPlayer;
(function (VideoPlayer) {
    VideoPlayer.lift = {
        Player: (_raw) => (new Player(_raw)),
        PlayerOutput: (_raw) => (new PlayerOutput(_raw)),
        RelationAudio: (_raw) => (new RelationAudio(_raw)),
        RelationVideo: (_raw) => (new RelationVideo(_raw)),
        Relations: (_raw) => (new Relations(_raw)),
        Time: (_raw) => (new Time(_raw)),
        RelationAudioFollowers: (_raw) => (new RelationAudioFollowers(_raw)),
        RelationVideoFollowers: (_raw) => (new RelationVideoFollowers(_raw)),
    };
    VideoPlayer.lower = {
        Player: (_x) => _x.raw.kwl,
        PlayerOutput: (_x) => _x.raw.kwl,
        RelationAudio: (_x) => _x.raw.kwl,
        RelationVideo: (_x) => _x.raw.kwl,
        Relations: (_x) => _x.raw.kwl,
        Time: (_x) => _x.raw.kwl,
        RelationAudioFollowers: (_x) => _x.raw.kwl,
        RelationVideoFollowers: (_x) => _x.raw.kwl,
    };
    class Player {
        raw;
        type_identifier = "VideoPlayer::Data::Player";
        constructor(raw) {
            this.raw = raw;
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    load_failed_bad_header: (x & 1) !== 0,
                    load_failed_no_header: (x & 2) !== 0,
                    load_failed_read_error: (x & 4) !== 0,
                    load_pending: (x & 8) !== 0,
                    missing_latched_standard: (x & 16) !== 0,
                    missing_timesource: (x & 32) !== 0,
                    out_of_memory: (x & 64) !== 0,
                    out_of_readers: (x & 128) !== 0,
                    out_of_writers: (x & 256) !== 0,
                    upload_error: (x & 512) !== 0
                }),
                lower: (x, _) => ((x.load_failed_bad_header ? 1 : 0) |
                    (x.load_failed_no_header ? 2 : 0) |
                    (x.load_failed_read_error ? 4 : 0) |
                    (x.load_pending ? 8 : 0) |
                    (x.missing_latched_standard ? 16 : 0) |
                    (x.missing_timesource ? 32 : 0) |
                    (x.out_of_memory ? 64 : 0) |
                    (x.out_of_readers ? 128 : 0) |
                    (x.out_of_writers ? 256 : 0) |
                    (x.upload_error ? 512 : 0))
            });
        }
        get upload() {
            return VAPI.VideoPlayer.lift.Upload(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "upload"));
        }
        get memory_usage() {
            return new VScript.rKeyword(this, "memory_usage", {
                lift: VAPI.VideoPlayer.lift.MemoryCapacity,
                lower: VAPI.VideoPlayer.lower.MemoryCapacity
            });
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VAPI.VideoPlayer.lift.Capabilities,
                lower: VAPI.VideoPlayer.lower.Capabilities
            }, {
                lift: VAPI.VideoPlayer.lift.Capabilities,
                lower: VAPI.VideoPlayer.lower.Capabilities
            }, null);
        }
        get gang() {
            return VAPI.AT1130.VideoPlayer.lift.Relations(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "gang"));
        }
        /**
          Restart writer and reader
        */
        get restart() {
            return new VScript.wKeyword(this, "restart", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get output() {
            return VAPI.AT1130.VideoPlayer.lift.PlayerOutput(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "output"));
        }
    }
    VideoPlayer.Player = Player;
    class PlayerAsNamedTableRow extends Player {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    VideoPlayer.PlayerAsNamedTableRow = PlayerAsNamedTableRow;
    class PlayerOutput {
        raw;
        type_identifier = "VideoPlayer::Data::PlayerOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get time() {
            return VAPI.AT1130.VideoPlayer.lift.Time(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "time"));
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get control() {
            return VAPI.VideoPlayer.lift.Control(VScript.VAPIHelpers.subtree_child_checked(this.raw, 2, "control"));
        }
        get deembedded_audio() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 3, "deembedded_audio"), (st, _) => VAPI.VideoPlayer.lift.GroupSelections(st));
        }
        get reader() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 4, "reader"), (raw, _) => VAPI.VideoPlayer.lift.Reader(raw));
        }
        get video() {
            return VAPI.AT1130.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 5, "video"));
        }
        get audio() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "audio"));
        }
    }
    VideoPlayer.PlayerOutput = PlayerOutput;
    class RelationAudio {
        raw;
        type_identifier = "VideoPlayer::Data::RelationAudio";
        constructor(raw) {
            this.raw = raw;
        }
        get leader() {
            return new VScript.dKeyword(this, "leader", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.AudioRePlay.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.AudioRePlay.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get followers() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "followers"), (raw, _) => VAPI.AT1130.VideoPlayer.lift.RelationAudioFollowers(raw));
        }
    }
    VideoPlayer.RelationAudio = RelationAudio;
    class RelationVideo {
        raw;
        type_identifier = "VideoPlayer::Data::RelationVideo";
        constructor(raw) {
            this.raw = raw;
        }
        get leader() {
            return new VScript.dKeyword(this, "leader", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.VideoPlayer.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.VideoPlayer.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get followers() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 1, "followers"), (raw, _) => VAPI.AT1130.VideoPlayer.lift.RelationVideoFollowers(raw));
        }
    }
    VideoPlayer.RelationVideo = RelationVideo;
    class Relations {
        raw;
        type_identifier = "VideoPlayer::Data::Relations";
        constructor(raw) {
            this.raw = raw;
        }
        get video() {
            return VAPI.AT1130.VideoPlayer.lift.RelationVideo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "video"));
        }
        get audio() {
            return VAPI.AT1130.VideoPlayer.lift.RelationAudio(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "audio"));
        }
    }
    VideoPlayer.Relations = Relations;
    class Time {
        raw;
        type_identifier = "VideoPlayer::Data::Time";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get phaser_range() {
            return new VScript.rwKeyword(this, "phaser_range", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get restart_phaser() {
            return new VScript.rwKeyword(this, "restart_phaser", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    VideoPlayer.Time = Time;
    class RelationAudioFollowers {
        raw;
        type_identifier = "VideoPlayer::Data::RelationAudio::Followers";
        constructor(raw) {
            this.raw = raw;
        }
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.AudioRePlay.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    VideoPlayer.RelationAudioFollowers = RelationAudioFollowers;
    class RelationVideoFollowers {
        raw;
        type_identifier = "VideoPlayer::Data::RelationVideo::Followers";
        constructor(raw) {
            this.raw = raw;
        }
        get wrapped_reference() {
            return new VScript.rKeyword(this, "wrapped_reference", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.VideoPlayer.Player(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            });
        }
    }
    VideoPlayer.RelationVideoFollowers = RelationVideoFollowers;
})(VideoPlayer || (VideoPlayer = {}));
export var VideoRePlay;
(function (VideoRePlay) {
    VideoRePlay.lift = {
        Delay: (_raw) => (new Delay(_raw)),
        DelayOutput: (_raw) => (new DelayOutput(_raw)),
        Time: (_raw) => (new Time(_raw)),
        Video: (_raw) => (new Video(_raw)),
        DelayInputs: (_raw) => (new DelayInputs(_raw)),
    };
    VideoRePlay.lower = {
        Delay: (_x) => _x.raw.kwl,
        DelayOutput: (_x) => _x.raw.kwl,
        Time: (_x) => _x.raw.kwl,
        Video: (_x) => _x.raw.kwl,
        DelayInputs: (_x) => _x.raw.kwl,
    };
    class Delay {
        raw;
        type_identifier = "VideoRePlay::Data::Delay";
        constructor(raw) {
            this.raw = raw;
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    missing_input_standard: (x & 1) !== 0,
                    missing_latched_standard: (x & 2) !== 0,
                    missing_timesource: (x & 4) !== 0,
                    out_of_memory: (x & 8) !== 0,
                    out_of_readers: (x & 16) !== 0,
                    out_of_writers: (x & 32) !== 0
                }),
                lower: (x, _) => ((x.missing_input_standard ? 1 : 0) |
                    (x.missing_latched_standard ? 2 : 0) |
                    (x.missing_timesource ? 4 : 0) |
                    (x.out_of_memory ? 8 : 0) |
                    (x.out_of_readers ? 16 : 0) |
                    (x.out_of_writers ? 32 : 0))
            });
        }
        get memory_usage() {
            return new VScript.rKeyword(this, "memory_usage", {
                lift: VAPI.VideoRePlay.lift.MemoryCapacity,
                lower: VAPI.VideoRePlay.lower.MemoryCapacity
            });
        }
        get capabilities() {
            return new VScript.dKeyword(this, "capabilities", {
                lift: VAPI.VideoRePlay.lift.Capabilities,
                lower: VAPI.VideoRePlay.lower.Capabilities
            }, {
                lift: VAPI.VideoRePlay.lift.Capabilities,
                lower: VAPI.VideoRePlay.lower.Capabilities
            }, null);
        }
        /**
          Restart writer and reader
        */
        get restart() {
            return new VScript.wKeyword(this, "restart", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get dma() {
            return VAPI.VideoRePlay.lift.DMA(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "dma"));
        }
        get inputs() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 5, "inputs"), (raw, _) => VAPI.AT1130.VideoRePlay.lift.DelayInputs(raw));
        }
        get outputs() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 6, "outputs"), (raw) => new VAPI.AT1130.VideoRePlay.DelayOutputAsNamedTableRow(raw));
        }
        async stop_and_download(pars) {
            const url = this.url(pars);
            await this.dma.http.setup_handler.write("Stop");
            const rsp = await fetch(url);
            if (!rsp.ok)
                throw new Error(`Unable to download ${url}: ${rsp.statusText}`);
            return rsp.arrayBuffer();
        }
        url(pars) {
            const vm = this.raw.backing_store;
            const store = pars?.frame_index !== undefined ? `frame&frame_index=${pars.frame_index}` : "clip_single_file";
            return `${vm.protocol === "ws" ? "http" : "https"}://${this.raw.backing_store.ip}/replay/video?action=read&handler=${VScript.enforce_nonnull(VScript.path_index(this.raw.kwl))}&store=${store}`;
        }
    }
    VideoRePlay.Delay = Delay;
    class DelayAsNamedTableRow extends Delay {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    VideoRePlay.DelayAsNamedTableRow = DelayAsNamedTableRow;
    class DelayOutput {
        raw;
        type_identifier = "VideoRePlay::Data::DelayOutput";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get time() {
            return VAPI.AT1130.VideoRePlay.lift.Time(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "time"));
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get delay() {
            return VAPI.VideoRePlay.lift.Buffer(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "delay"));
        }
        get deembedded_audio() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 4, "deembedded_audio"), (st, _) => VAPI.VideoRePlay.lift.GroupSelections(st));
        }
        get reader() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 5, "reader"), (raw, _) => VAPI.VideoRePlay.lift.Reader(raw));
        }
        get video() {
            return VAPI.AT1130.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 6, "video"));
        }
        get audio() {
            return VAPI.AT1130.Audio.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 7, "audio"));
        }
    }
    VideoRePlay.DelayOutput = DelayOutput;
    class DelayOutputAsNamedTableRow extends DelayOutput {
        raw;
        index;
        constructor(raw) {
            super(raw);
            this.raw = raw;
            this.index = raw.index;
        }
        async rename(name, opts) { await this.raw.rename(name, opts); }
        async row_name(opts) { return await this.raw.row_name(opts); }
        async delete(opts) { await this.raw.delete(opts); }
    }
    VideoRePlay.DelayOutputAsNamedTableRow = DelayOutputAsNamedTableRow;
    class Time {
        raw;
        type_identifier = "VideoRePlay::Data::Time";
        constructor(raw) {
            this.raw = raw;
        }
        get phaser_range() {
            return new VScript.rwKeyword(this, "phaser_range", {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, {
                lift: VScript.VAPIHelpers.liftNanoseconds,
                lower: VScript.VAPIHelpers.lowerNanoseconds
            }, null);
        }
        get restart_phaser() {
            return new VScript.rwKeyword(this, "restart_phaser", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
    }
    VideoRePlay.Time = Time;
    class Video {
        raw;
        type_identifier = "VideoRePlay::Data::Video";
        constructor(raw) {
            this.raw = raw;
        }
        get info() {
            return VAPI.DataRePlay.lift.MemoryInfo(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "info"));
        }
        get players() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 1, "players"), (raw) => new VAPI.AT1130.VideoPlayer.PlayerAsNamedTableRow(raw));
        }
        get delays() {
            return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 2, "delays"), (raw) => new VAPI.AT1130.VideoRePlay.DelayAsNamedTableRow(raw));
        }
        get statistic() {
            return VAPI.DataRePlay.lift.Statistic(VScript.VAPIHelpers.subtree_child_checked(this.raw, 3, "statistic"));
        }
        get ecc() {
            return VAPI.Memory.lift.ECCMuxStatistics(VScript.VAPIHelpers.subtree_child_checked(this.raw, 4, "ecc"));
        }
        get audio_source_slices() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 5, "audio_source_slices"), (st, _) => VAPI.Audio.lift.SignalSourceSlice(st));
        }
    }
    VideoRePlay.Video = Video;
    class DelayInputs {
        raw;
        type_identifier = "VideoRePlay::Data::Delay::Inputs";
        constructor(raw) {
            this.raw = raw;
        }
        get active() {
            return new VScript.rKeyword(this, "active", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get latest_running_standard() {
            return new VScript.rKeyword(this, "latest_running_standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get v_src() {
            return new VScript.dKeyword(this, "v_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Video.Essence(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, null);
        }
        get writer() {
            return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 3, "writer"), (raw, _) => VAPI.VideoRePlay.lift.Writer(raw));
        }
    }
    VideoRePlay.DelayInputs = DelayInputs;
})(VideoRePlay || (VideoRePlay = {}));
export var VideoSignalGenerator;
(function (VideoSignalGenerator) {
    VideoSignalGenerator.lift = {
        All: (_raw) => (new All(_raw)),
        VSG: (_raw) => (new VSG(_raw)),
    };
    VideoSignalGenerator.lower = {
        All: (_x) => _x.raw.kwl,
        VSG: (_x) => _x.raw.kwl,
    };
    class All {
        raw;
        type_identifier = "VideoSignalGenerator::Data::All";
        get runtime_constants() {
            return {
                num_video_signal_generators: this.raw.backing_store.get_runtime_constant("VideoSignalGenerator::num_video_signal_generators")
            };
        }
        constructor(raw) {
            this.raw = raw;
        }
        get instances() {
            return new VScript.StronglyTypedArray(VScript.VAPIHelpers.subtree_array_child_checked(this.raw, 0, "instances"), (st, _) => VAPI.AT1130.VideoSignalGenerator.lift.VSG(st));
        }
    }
    VideoSignalGenerator.All = All;
    class VSG {
        raw;
        type_identifier = "VideoSignalGenerator::Data::VSG";
        constructor(raw) {
            this.raw = raw;
        }
        get t_src() {
            return new VScript.dKeyword(this, "t_src", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, {
                lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.AT1130.Time.Source(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
                lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
            }, (parent, command) => (void parent, void command, { criterion: "status", validator: (status) => command === null || VScript.same(command, status) }));
        }
        get output() {
            return VAPI.AT1130.Video.lift.Essence(VScript.VAPIHelpers.subtree_child_checked(this.raw, 1, "output"));
        }
        get standard() {
            return new VScript.dKeyword(this, "standard", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get pattern() {
            return new VScript.rwKeyword(this, "pattern", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get cnt0_full() {
            return new VScript.rwKeyword(this, "cnt0_full", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get cnt1_full() {
            return new VScript.rwKeyword(this, "cnt1_full", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get cnt0_horz() {
            return new VScript.rwKeyword(this, "cnt0_horz", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get cnt1_horz() {
            return new VScript.rwKeyword(this, "cnt1_horz", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            }, null);
        }
        get phase() {
            return new VScript.rKeyword(this, "phase", {
                lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
                lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
            });
        }
        get phase_rst_counter() {
            return new VScript.rKeyword(this, "phase_rst_counter", {
                lift: (x /* FIXME */, _) => x,
                lower: (x /* FIXME */, _) => x
            });
        }
        get issues() {
            return new VScript.rKeyword(this, "issues", {
                lift: (x, _) => ({
                    genlock_not_locked: (x & 1) !== 0,
                    missing_t_src: (x & 2) !== 0
                }),
                lower: (x, _) => ((x.genlock_not_locked ? 1 : 0) |
                    (x.missing_t_src ? 2 : 0))
            });
        }
    }
    VideoSignalGenerator.VSG = VSG;
})(VideoSignalGenerator || (VideoSignalGenerator = {}));
export class Root {
    raw;
    audio_engine;
    audio_gain;
    audio_mixer;
    audio_shuffler;
    audio_signal_generator;
    clos_x_bar;
    cluster;
    color_correction;
    genlock;
    i_o_module;
    j2_k_decoder;
    master_clock;
    metadata_processor;
    monitoring;
    multiviewer;
    multiviewer_i_o;
    network_interfaces;
    p_cap;
    p_t_p_clock;
    p_t_p_flows;
    r_t_p_metadata_channel;
    r_t_p_receiver;
    r_t_p_transmitter;
    re_play;
    sample_rate_converter;
    software_update;
    splitter;
    system;
    system_clock;
    time_flows;
    u_d_x;
    u_d_x_metadata_requests;
    video_mixer;
    video_signal_generator;
    constructor(raw) {
        this.raw = raw;
        const maybe_audio_engine = VScript.VAPIHelpers.component_checked(this.raw, "audio_engine");
        if (maybe_audio_engine)
            this.audio_engine = new VAPI.AT1130.AudioEngine.All(maybe_audio_engine);
        const maybe_audio_gain = VScript.VAPIHelpers.component_checked(this.raw, "audio_gain");
        if (maybe_audio_gain)
            this.audio_gain = new VAPI.AT1130.AudioGain.All(maybe_audio_gain);
        const maybe_audio_mixer = VScript.VAPIHelpers.component_checked(this.raw, "audio_mixer");
        if (maybe_audio_mixer)
            this.audio_mixer = new VAPI.AT1130.AudioMixer.All(maybe_audio_mixer);
        const maybe_audio_shuffler = VScript.VAPIHelpers.component_checked(this.raw, "audio_shuffler");
        if (maybe_audio_shuffler)
            this.audio_shuffler = new VAPI.AT1130.AudioShuffler.All(maybe_audio_shuffler);
        const maybe_audio_signal_generator = VScript.VAPIHelpers.component_checked(this.raw, "audio_signal_generator");
        if (maybe_audio_signal_generator)
            this.audio_signal_generator = new VAPI.AT1130.AudioSignalGenerator.All(maybe_audio_signal_generator);
        const maybe_clos_x_bar = VScript.VAPIHelpers.component_checked(this.raw, "clos_x_bar");
        if (maybe_clos_x_bar)
            this.clos_x_bar = new VAPI.ClosXBar.All(maybe_clos_x_bar);
        const maybe_cluster = VScript.VAPIHelpers.component_checked(this.raw, "cluster");
        if (maybe_cluster)
            this.cluster = new VAPI.AT1130.Cluster.All(maybe_cluster);
        const maybe_color_correction = VScript.VAPIHelpers.component_checked(this.raw, "color_correction");
        if (maybe_color_correction)
            this.color_correction = new VAPI.AT1130.ColorCorrection.All(maybe_color_correction);
        const maybe_genlock = VScript.VAPIHelpers.component_checked(this.raw, "genlock");
        if (maybe_genlock)
            this.genlock = new VAPI.AT1130.Genlock.All(maybe_genlock);
        const maybe_i_o_module = VScript.VAPIHelpers.component_checked(this.raw, "i_o_module");
        if (maybe_i_o_module)
            this.i_o_module = new VAPI.AT1130.IOModule.All(maybe_i_o_module);
        const maybe_j2_k_decoder = VScript.VAPIHelpers.component_checked(this.raw, "j2_k_decoder");
        if (maybe_j2_k_decoder)
            this.j2_k_decoder = new VAPI.AT1130.J2KDecoder.All(maybe_j2_k_decoder);
        this.master_clock = new VAPI.AT1130.MasterClock.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "master_clock")));
        const maybe_metadata_processor = VScript.VAPIHelpers.component_checked(this.raw, "metadata_processor");
        if (maybe_metadata_processor)
            this.metadata_processor = new VAPI.AT1130.MetadataProcessor.All(maybe_metadata_processor);
        const maybe_monitoring = VScript.VAPIHelpers.component_checked(this.raw, "monitoring");
        if (maybe_monitoring)
            this.monitoring = new VAPI.AT1130.Monitoring.All(maybe_monitoring);
        const maybe_multiviewer = VScript.VAPIHelpers.component_checked(this.raw, "multiviewer");
        if (maybe_multiviewer)
            this.multiviewer = new VAPI.Multiviewer.All(maybe_multiviewer);
        const maybe_multiviewer_i_o = VScript.VAPIHelpers.component_checked(this.raw, "multiviewer_i_o");
        if (maybe_multiviewer_i_o)
            this.multiviewer_i_o = new VAPI.AT1130.MultiviewerIO.All(maybe_multiviewer_i_o);
        this.network_interfaces = new VAPI.AT1130.NetworkInterfaces.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "network_interfaces")));
        const maybe_p_cap = VScript.VAPIHelpers.component_checked(this.raw, "p_cap");
        if (maybe_p_cap)
            this.p_cap = new VAPI.AT1130.PCap.All(maybe_p_cap);
        this.p_t_p_clock = new VAPI.AT1130.PTPClock.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "p_t_p_clock")));
        this.p_t_p_flows = new VAPI.AT1130.PTPFlows.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "p_t_p_flows")));
        const maybe_r_t_p_metadata_channel = VScript.VAPIHelpers.component_checked(this.raw, "r_t_p_metadata_channel");
        if (maybe_r_t_p_metadata_channel)
            this.r_t_p_metadata_channel = new VAPI.RTPMetadataChannel.All(maybe_r_t_p_metadata_channel);
        const maybe_r_t_p_receiver = VScript.VAPIHelpers.component_checked(this.raw, "r_t_p_receiver");
        if (maybe_r_t_p_receiver)
            this.r_t_p_receiver = new VAPI.AT1130.RTPReceiver.All(maybe_r_t_p_receiver);
        const maybe_r_t_p_transmitter = VScript.VAPIHelpers.component_checked(this.raw, "r_t_p_transmitter");
        if (maybe_r_t_p_transmitter)
            this.r_t_p_transmitter = new VAPI.AT1130.RTPTransmitter.All(maybe_r_t_p_transmitter);
        const maybe_re_play = VScript.VAPIHelpers.component_checked(this.raw, "re_play");
        if (maybe_re_play)
            this.re_play = new VAPI.AT1130.RePlay.All(maybe_re_play);
        const maybe_sample_rate_converter = VScript.VAPIHelpers.component_checked(this.raw, "sample_rate_converter");
        if (maybe_sample_rate_converter)
            this.sample_rate_converter = new VAPI.AT1130.SampleRateConverter.All(maybe_sample_rate_converter);
        this.software_update = new VAPI.SoftwareUpdate.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "software_update")));
        const maybe_splitter = VScript.VAPIHelpers.component_checked(this.raw, "splitter");
        if (maybe_splitter)
            this.splitter = new VAPI.AT1130.Splitter.All(maybe_splitter);
        this.system = new VAPI.AT1130.System.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "system")));
        this.system_clock = new VAPI.AT1130.SystemClock.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "system_clock")));
        this.time_flows = new VAPI.AT1130.TimeFlows.All(VScript.enforce_nonnull(VScript.VAPIHelpers.component_checked(this.raw, "time_flows")));
        const maybe_u_d_x = VScript.VAPIHelpers.component_checked(this.raw, "u_d_x");
        if (maybe_u_d_x)
            this.u_d_x = new VAPI.AT1130.UDX.All(maybe_u_d_x);
        const maybe_u_d_x_metadata_requests = VScript.VAPIHelpers.component_checked(this.raw, "u_d_x_metadata_requests");
        if (maybe_u_d_x_metadata_requests)
            this.u_d_x_metadata_requests = new VAPI.AT1130.UDXMetadataRequests.All(maybe_u_d_x_metadata_requests);
        const maybe_video_mixer = VScript.VAPIHelpers.component_checked(this.raw, "video_mixer");
        if (maybe_video_mixer)
            this.video_mixer = new VAPI.AT1130.VideoMixer.All(maybe_video_mixer);
        const maybe_video_signal_generator = VScript.VAPIHelpers.component_checked(this.raw, "video_signal_generator");
        if (maybe_video_signal_generator)
            this.video_signal_generator = new VAPI.AT1130.VideoSignalGenerator.All(maybe_video_signal_generator);
    }
    static adopt(socket) { return new Root(socket); }
    async close() { await this.raw.close(); }
}
