import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly Channel: (_raw: [null | string, number, boolean, [number, number, number, number, number]], _socket: VScript.VSocket) => Channel;
    readonly FadeRequest: (_raw: [number, number, number, number, number], _socket: VScript.VSocket) => FadeRequest;
    readonly SignalSourceSlice: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.Audio.SignalSourceSlice;
};
export declare const lower: {
    readonly Channel: (_x: {
        signal: null | VScript.RefinedIndexedMutatingReference<VScript.VSocket, "signal_status", "Audio::Data::SignalSourceSlice", VScript.Referenceable<"Audio::Data::SignalSourceSlice"> & VAPI.Audio.SignalSourceSlice, VAPI.Audio.SignalStatus, VAPI.Audio.SignalStatus>;
        gain: number;
        phase_invert: boolean;
        /**
          if `start` < `downto` ≤ `upfrom` < `end`, this corresponds to a
          V-fade request fading down from `start` to `downto` and back up from
          `upfrom` to `end`. If `start` = `downto` = `upfrom` < `end`, the
          essence should be initially set up with zero amplitude and fade to
          full amplitude between `upfrom` and `end`; likewise, `start` <
          `downto` = `upfrom` = `end` should be initialized with full
          amplitude, fade down to zero amplitude between `start` and `downto`
          and remain there indefinitely.
          
          All free-running counter values are measured with respect to micro
          epoch #`micro_epoch_index`.
        */
        fade_request: VAPI.Audio.FadeRequest;
    }, _socket: VScript.VSocket) => [null | string, number, boolean, [number, number, number, number, number]];
    readonly FadeRequest: (_x: {
        start: VAPI.Time.FreeRunningCounter;
        downto: VAPI.Time.FreeRunningCounter;
        upfrom: VAPI.Time.FreeRunningCounter;
        end: VAPI.Time.FreeRunningCounter;
        micro_epoch_index: VAPI.Time.MicroEpochIndex;
    }, _socket: VScript.VSocket) => [number, number, number, number, number];
    readonly SignalSourceSlice: (_x: SignalSourceSlice) => string;
};
export interface Channel {
    signal: null | VScript.RefinedIndexedMutatingReference<VScript.VSocket, "signal_status", "Audio::Data::SignalSourceSlice", VScript.Referenceable<"Audio::Data::SignalSourceSlice"> & VAPI.Audio.SignalSourceSlice, VAPI.Audio.SignalStatus, VAPI.Audio.SignalStatus>;
    gain: number;
    phase_invert: boolean;
    /**
      if `start` < `downto` ≤ `upfrom` < `end`, this corresponds to a V-fade
      request fading down from `start` to `downto` and back up from `upfrom` to
      `end`. If `start` = `downto` = `upfrom` < `end`, the essence should be
      initially set up with zero amplitude and fade to full amplitude between
      `upfrom` and `end`; likewise, `start` < `downto` = `upfrom` = `end`
      should be initialized with full amplitude, fade down to zero amplitude
      between `start` and `downto` and remain there indefinitely.
      
      All free-running counter values are measured with respect to micro epoch
      #`micro_epoch_index`.
    */
    fade_request: VAPI.Audio.FadeRequest;
}
export type ChannelIndex = number;
export type Channelcount = number;
/**
  if `start` < `downto` ≤ `upfrom` < `end`, this corresponds to a V-fade
  request fading down from `start` to `downto` and back up from `upfrom` to
  `end`. If `start` = `downto` = `upfrom` < `end`, the essence should be
  initially set up with zero amplitude and fade to full amplitude between
  `upfrom` and `end`; likewise, `start` < `downto` = `upfrom` = `end` should
  be initialized with full amplitude, fade down to zero amplitude between
  `start` and `downto` and remain there indefinitely.
  
  All free-running counter values are measured with respect to micro epoch
  #`micro_epoch_index`.
*/
export interface FadeRequest {
    start: VAPI.Time.FreeRunningCounter;
    downto: VAPI.Time.FreeRunningCounter;
    upfrom: VAPI.Time.FreeRunningCounter;
    end: VAPI.Time.FreeRunningCounter;
    micro_epoch_index: VAPI.Time.MicroEpochIndex;
}
export type Format = "AM824" | "L24" | "L16";
export type Frequency = "F48000" | "F96000";
export type Level = "set_6dbfs" | "set_18dbfs" | "set_20dbfs";
export type PacketTime = "p1" | "p0_666" | "p0_500" | "p0_333" | "p0_250" | "p0_125";
export type PeakMeter = number;
export type Samplecount = number;
export declare class SignalSourceSlice implements VScript.Referenceable<"Audio::Data::SignalSourceSlice"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "Audio::Data::SignalSourceSlice";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get frequency(): VScript.rKeyword<VScript.VSocket, null | VAPI.Audio.Frequency, null | VAPI.Audio.Frequency, VAPI.Audio.SignalSourceSlice>;
    get peak_meter(): VScript.rKeyword<VScript.VSocket, Array<number>, Array<VAPI.Audio.PeakMeter>, VAPI.Audio.SignalSourceSlice>;
    get signal_status(): VScript.rKeywordReferenceable<VScript.VSocket, "signal_status", VAPI.Audio.SignalStatus, VAPI.Audio.SignalStatus, Array<VAPI.Audio.SignalStatus>, Array<VAPI.Audio.SignalStatus>, "Audio::Data::SignalSourceSlice", VAPI.Audio.SignalSourceSlice>;
    get dt_node(): VScript.rKeyword<VScript.VSocket, null | VScript.DeviceTreeNodePayload, null | VScript.DeviceTreeNodePayload, VAPI.Audio.SignalSourceSlice>;
}
export type SignalStatus = "NoSignal" | "Silence" | "Signal";
export declare const Enums: {
    readonly SignalStatus: SignalStatus[];
    readonly PacketTime: PacketTime[];
    readonly Level: Level[];
    readonly Frequency: Frequency[];
    readonly Format: Format[];
};
