import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly CompressorCurveAutoGain: (_raw: [number, number, number, number], _socket: VScript.VSocket) => CompressorCurveAutoGain;
    readonly StereoPanBalanceBalanceCenterLinear: (_raw: [number], _socket: VScript.VSocket) => StereoPanBalanceBalanceCenterLinear;
    readonly CompressorARTime: (_raw: ([0, [number]] | [1, [number]]), _socket: VScript.VSocket) => CompressorARTime;
    readonly CompressorCapabilities: (_raw: [number, ([0, [boolean]] | [1, []]), boolean], _socket: VScript.VSocket) => CompressorCapabilities;
    readonly CompressorCurve: (_raw: ([0, [number, number, number]] | [1, [number, number]] | [2, [number, number, number]] | [3, [number, number]] | [4, [number, number, number, number]]), _socket: VScript.VSocket) => CompressorCurve;
    readonly CompressorCurvePoint: (_raw: [number, number, null | number], _socket: VScript.VSocket) => CompressorCurvePoint;
    readonly CompressorParameter: (_raw: [([0, [number]] | [1, [number]]), ([0, [number]] | [1, [number]]), ([0, [number]] | [1, [number]]), number], _socket: VScript.VSocket) => CompressorParameter;
    readonly CompressorSource: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioEngine.CompressorSource;
    readonly DelayCapabilities: (_raw: [number, number], _socket: VScript.VSocket) => DelayCapabilities;
    readonly DelayParameter: (_raw: ([0, [number]] | [1, [number]]), _socket: VScript.VSocket) => DelayParameter;
    readonly DownMixCapabilities: (_raw: [VAPI.AudioEngine.DownMixCapabilitiesChannels], _socket: VScript.VSocket) => DownMixCapabilities;
    readonly CompressorCurveDucking: (_raw: [number, number, number], _socket: VScript.VSocket) => CompressorCurveDucking;
    readonly Fader: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioEngine.Fader;
    readonly FilterCapabilities: (_raw: [number, number], _socket: VScript.VSocket) => FilterCapabilities;
    readonly FilterCoeffs: (_raw: [number, number, number, number, number], _socket: VScript.VSocket) => FilterCoeffs;
    readonly FilterHighPass: (_raw: [number, number], _socket: VScript.VSocket) => FilterHighPass;
    readonly FilterHighShelf: (_raw: [number, number], _socket: VScript.VSocket) => FilterHighShelf;
    readonly FilterLowPass: (_raw: [number, number], _socket: VScript.VSocket) => FilterLowPass;
    readonly FilterLowShelf: (_raw: [number, number], _socket: VScript.VSocket) => FilterLowShelf;
    readonly FilterParameter: (_raw: ([0, [number, number]] | [1, [number, number]] | [2, [number, number, number]] | [3, [number, number]] | [4, [number, number]]), _socket: VScript.VSocket) => FilterParameter;
    readonly FilterPeak: (_raw: [number, number, number], _socket: VScript.VSocket) => FilterPeak;
    readonly CompressorCurveGate: (_raw: [number, number], _socket: VScript.VSocket) => CompressorCurveGate;
    readonly Group: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioEngine.Group;
    readonly HWInputAssignment: (_raw: [number], _socket: VScript.VSocket) => HWInputAssignment;
    readonly CompressorCurveHardKnee: (_raw: [number, number], _socket: VScript.VSocket) => CompressorCurveHardKnee;
    readonly Info: (_raw: [number, number, [number, number], [number, number], [number, number], [number, number], null | [[number, number], [number, number]], [null | [number, number], null | [number, number], null | [number, number]], null | [[number, number], [number, number], [number, number]]], _socket: VScript.VSocket) => Info;
    readonly CompressorCapabilitiesControlInput: (_raw: [boolean], _socket: VScript.VSocket) => CompressorCapabilitiesControlInput;
    readonly InputTrimCapabilities: (_raw: [number], _socket: VScript.VSocket) => InputTrimCapabilities;
    readonly LoudnessCapabilities: (_raw: [number, number, boolean], _socket: VScript.VSocket) => LoudnessCapabilities;
    readonly LoudnessMeasurement: (_raw: [null | number, null | number, null | number, number], _socket: VScript.VSocket) => LoudnessMeasurement;
    readonly MSFader: (_raw: [number, boolean], _socket: VScript.VSocket) => MSFader;
    readonly MidSideCapabilities: (_raw: [VAPI.AudioEngine.MidSideCapabilitiesInputMode], _socket: VScript.VSocket) => MidSideCapabilities;
    readonly MonoMixCapabilities: (_raw: [number, boolean], _socket: VScript.VSocket) => MonoMixCapabilities;
    readonly NMinus1Capabilities: (_raw: [number], _socket: VScript.VSocket) => NMinus1Capabilities;
    readonly StereoPanBalancePanCenterLinear: (_raw: [number], _socket: VScript.VSocket) => StereoPanBalancePanCenterLinear;
    readonly StereoPanBalancePanConstantPower: (_raw: [number], _socket: VScript.VSocket) => StereoPanBalancePanConstantPower;
    readonly StereoPanBalancePanFullLinear: (_raw: [number], _socket: VScript.VSocket) => StereoPanBalancePanFullLinear;
    readonly Resource: (_raw: [number, number], _socket: VScript.VSocket) => Resource;
    readonly CompressorARTimeSamples: (_raw: [number], _socket: VScript.VSocket) => CompressorARTimeSamples;
    readonly DelayParameterSamples: (_raw: [number], _socket: VScript.VSocket) => DelayParameterSamples;
    readonly CompressorCapabilitiesControlSidechainOnly: (_raw: [], _socket: VScript.VSocket) => CompressorCapabilitiesControlSidechainOnly;
    readonly CompressorCurveSoftKnee: (_raw: [number, number, number], _socket: VScript.VSocket) => CompressorCurveSoftKnee;
    readonly StereoMixCapabilities: (_raw: [number, boolean], _socket: VScript.VSocket) => StereoMixCapabilities;
    readonly StereoPanBalance: (_raw: ([0, [number]] | [1, [number]] | [2, [number]] | [3, [number]]), _socket: VScript.VSocket) => StereoPanBalance;
    readonly CompressorARTimeTime: (_raw: [number], _socket: VScript.VSocket) => CompressorARTimeTime;
    readonly DelayParameterTime: (_raw: [number], _socket: VScript.VSocket) => DelayParameterTime;
    readonly TruePeakCapabilities: (_raw: [number], _socket: VScript.VSocket) => TruePeakCapabilities;
    readonly CompressorBandpass: (_raw: [boolean, [number, number], [number, number]], _socket: VScript.VSocket) => CompressorBandpass;
    readonly FilterBands: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioEngine.FilterBands;
    readonly InfoCompressor: (_raw: [[number, number], [number, number], [number, number]], _socket: VScript.VSocket) => InfoCompressor;
    readonly CompressorCapabilitiesControl: (_raw: ([0, [boolean]] | [1, []]), _socket: VScript.VSocket) => CompressorCapabilitiesControl;
    readonly InfoDelays: (_raw: [[number, number], [number, number]], _socket: VScript.VSocket) => InfoDelays;
    readonly DownMixLevels: (_raw: [number, number, number, number, number, number, number, number], _socket: VScript.VSocket) => DownMixLevels;
    readonly CompressorLookahead: (_raw: [boolean, ([0, [number]] | [1, [number]])], _socket: VScript.VSocket) => CompressorLookahead;
    readonly InfoMeasurement: (_raw: [null | [number, number], null | [number, number], null | [number, number]], _socket: VScript.VSocket) => InfoMeasurement;
    readonly MidSideParams: (_raw: [number, number, number], _socket: VScript.VSocket) => MidSideParams;
};
export declare const lower: {
    readonly CompressorCurveAutoGain: (_x: {
        cutoff: VAPI.AudioEngine.CompressorGain;
        target: VAPI.AudioEngine.CompressorGain;
        width: number;
        ratio: VAPI.AudioEngine.CompressorRatio;
    }, _socket: VScript.VSocket) => [number, number, number, number];
    readonly StereoPanBalanceBalanceCenterLinear: (_x: {
        balance: VAPI.AudioEngine.PanValue;
    }, _socket: VScript.VSocket) => [number];
    readonly CompressorARTime: (_x: ({
        variant: "Samples";
        value: VAPI.AudioEngine.CompressorARTimeSamples;
    } | {
        variant: "Time";
        value: VAPI.AudioEngine.CompressorARTimeTime;
    }), _socket: VScript.VSocket) => ([0, [number]] | [1, [number]]);
    readonly CompressorCapabilities: (_x: {
        channels: number;
        control: VAPI.AudioEngine.CompressorCapabilitiesControl;
        lookahead: boolean;
    }, _socket: VScript.VSocket) => [number, ([0, [boolean]] | [1, []]), boolean];
    readonly CompressorCurve: (_x: ({
        variant: "SoftKnee";
        value: VAPI.AudioEngine.CompressorCurveSoftKnee;
    } | {
        variant: "HardKnee";
        value: VAPI.AudioEngine.CompressorCurveHardKnee;
    } | {
        variant: "Ducking";
        value: VAPI.AudioEngine.CompressorCurveDucking;
    } | {
        variant: "Gate";
        value: VAPI.AudioEngine.CompressorCurveGate;
    } | {
        variant: "AutoGain";
        value: VAPI.AudioEngine.CompressorCurveAutoGain;
    }), _socket: VScript.VSocket) => ([0, [number, number, number]] | [1, [number, number]] | [2, [number, number, number]] | [3, [number, number]] | [4, [number, number, number, number]]);
    readonly CompressorCurvePoint: (_x: {
        i: VAPI.AudioEngine.CompressorCurveValue;
        o: VAPI.AudioEngine.CompressorCurveValue;
        c: null | VAPI.AudioEngine.CompressorCurveValue;
    }, _socket: VScript.VSocket) => [number, number, null | number];
    readonly CompressorParameter: (_x: {
        attack: VAPI.AudioEngine.CompressorARTime;
        release: VAPI.AudioEngine.CompressorARTime;
        hold: VAPI.AudioEngine.CompressorARTime;
        gain: VAPI.AudioEngine.CompressorGain;
    }, _socket: VScript.VSocket) => [([0, [number]] | [1, [number]]), ([0, [number]] | [1, [number]]), ([0, [number]] | [1, [number]]), number];
    readonly CompressorSource: (_x: CompressorSource) => string;
    readonly DelayCapabilities: (_x: {
        channels: number;
        taps: number;
    }, _socket: VScript.VSocket) => [number, number];
    readonly DelayParameter: (_x: ({
        variant: "Samples";
        value: VAPI.AudioEngine.DelayParameterSamples;
    } | {
        variant: "Time";
        value: VAPI.AudioEngine.DelayParameterTime;
    }), _socket: VScript.VSocket) => ([0, [number]] | [1, [number]]);
    readonly DownMixCapabilities: (_x: {
        /**
          SURROUND_5_1 supports the first 6 inputs
          
          SURROUND_7_1 supports the first 8 inputs
          
          FULL supports all 12 inputs
        */
        channels: VAPI.AudioEngine.DownMixCapabilitiesChannels;
    }, _socket: VScript.VSocket) => [VAPI.AudioEngine.DownMixCapabilitiesChannels];
    readonly CompressorCurveDucking: (_x: {
        threshold: VAPI.AudioEngine.CompressorGain;
        width: number;
        gain: VAPI.AudioEngine.CompressorGain;
    }, _socket: VScript.VSocket) => [number, number, number];
    readonly Fader: (_x: Fader) => string;
    readonly FilterCapabilities: (_x: {
        channels: number;
        bands: number;
    }, _socket: VScript.VSocket) => [number, number];
    readonly FilterCoeffs: (_x: {
        a0: VAPI.Primitives.Float32;
        a1: VAPI.Primitives.Float32;
        a2: VAPI.Primitives.Float32;
        b1: VAPI.Primitives.Float32;
        b2: VAPI.Primitives.Float32;
    }, _socket: VScript.VSocket) => [number, number, number, number, number];
    readonly FilterHighPass: (_x: {
        fc: VAPI.AudioEngine.FilterFrequency;
        q: VAPI.AudioEngine.FilterQ;
    }, _socket: VScript.VSocket) => [number, number];
    readonly FilterHighShelf: (_x: {
        fc: VAPI.AudioEngine.FilterFrequency;
        gain: VAPI.AudioEngine.FilterGain;
    }, _socket: VScript.VSocket) => [number, number];
    readonly FilterLowPass: (_x: {
        fc: VAPI.AudioEngine.FilterFrequency;
        q: VAPI.AudioEngine.FilterQ;
    }, _socket: VScript.VSocket) => [number, number];
    readonly FilterLowShelf: (_x: {
        fc: VAPI.AudioEngine.FilterFrequency;
        gain: VAPI.AudioEngine.FilterGain;
    }, _socket: VScript.VSocket) => [number, number];
    readonly FilterParameter: (_x: ({
        variant: "LowPass";
        value: VAPI.AudioEngine.FilterLowPass;
    } | {
        variant: "HighPass";
        value: VAPI.AudioEngine.FilterHighPass;
    } | {
        variant: "Peak";
        value: VAPI.AudioEngine.FilterPeak;
    } | {
        variant: "LowShelf";
        value: VAPI.AudioEngine.FilterLowShelf;
    } | {
        variant: "HighShelf";
        value: VAPI.AudioEngine.FilterHighShelf;
    }), _socket: VScript.VSocket) => ([0, [number, number]] | [1, [number, number]] | [2, [number, number, number]] | [3, [number, number]] | [4, [number, number]]);
    readonly FilterPeak: (_x: {
        fc: VAPI.AudioEngine.FilterFrequency;
        q: VAPI.AudioEngine.FilterQ;
        gain: VAPI.AudioEngine.FilterGain;
    }, _socket: VScript.VSocket) => [number, number, number];
    readonly CompressorCurveGate: (_x: {
        threshold: VAPI.AudioEngine.CompressorGain;
        width: number;
    }, _socket: VScript.VSocket) => [number, number];
    readonly Group: (_x: Group) => string;
    readonly HWInputAssignment: (_x: {
        value: VAPI.Primitives.Unsigned16;
    }, _socket: VScript.VSocket) => [number];
    readonly CompressorCurveHardKnee: (_x: {
        threshold: VAPI.AudioEngine.CompressorGain;
        ratio: VAPI.AudioEngine.CompressorRatio;
    }, _socket: VScript.VSocket) => [number, number];
    readonly Info: (_x: {
        engine_load: VAPI.Primitives.Normalized;
        planning_time: VScript.Duration;
        inputs: VAPI.AudioEngine.Resource;
        outputs: VAPI.AudioEngine.Resource;
        faders: VAPI.AudioEngine.Resource;
        biquads: VAPI.AudioEngine.Resource;
        delays: null | VAPI.AudioEngine.InfoDelays;
        measurement: VAPI.AudioEngine.InfoMeasurement;
        compressor: null | VAPI.AudioEngine.InfoCompressor;
    }, _socket: VScript.VSocket) => [number, number, [number, number], [number, number], [number, number], [number, number], null | [[number, number], [number, number]], [null | [number, number], null | [number, number], null | [number, number]], null | [[number, number], [number, number], [number, number]]];
    readonly CompressorCapabilitiesControlInput: (_x: {
        bandpass: boolean;
    }, _socket: VScript.VSocket) => [boolean];
    readonly InputTrimCapabilities: (_x: {
        channels: number;
    }, _socket: VScript.VSocket) => [number];
    readonly LoudnessCapabilities: (_x: {
        front_channels: number;
        surround_channels: number;
        /**
          Disable k-weighting only when using this element to control a
          compressor, the resulting Loudness measurements will then NOT
          match the ITU-R BS.1170-4
        */
        k_weighting: boolean;
    }, _socket: VScript.VSocket) => [number, number, boolean];
    readonly LoudnessMeasurement: (_x: {
        /**
          Measured over the last 400 ms
        */
        momentary: null | number;
        /**
          Measured over the last 3 s
        */
        short_term: null | number;
        gated: null | number;
        /**
          How much data has been recorded for the gated loudness
          measurement so far
        */
        gated_recorded: VScript.Duration;
    }, _socket: VScript.VSocket) => [null | number, null | number, null | number, number];
    readonly MSFader: (_x: {
        gain: VAPI.AudioEngine.FaderGain;
        mute: boolean;
    }, _socket: VScript.VSocket) => [number, boolean];
    readonly MidSideCapabilities: (_x: {
        input_mode: VAPI.AudioEngine.MidSideCapabilitiesInputMode;
    }, _socket: VScript.VSocket) => [VAPI.AudioEngine.MidSideCapabilitiesInputMode];
    readonly MonoMixCapabilities: (_x: {
        channels: number;
        master_fader: boolean;
    }, _socket: VScript.VSocket) => [number, boolean];
    readonly NMinus1Capabilities: (_x: {
        channels: number;
    }, _socket: VScript.VSocket) => [number];
    readonly StereoPanBalancePanCenterLinear: (_x: {
        pan: VAPI.AudioEngine.PanValue;
    }, _socket: VScript.VSocket) => [number];
    readonly StereoPanBalancePanConstantPower: (_x: {
        pan: VAPI.AudioEngine.PanValue;
    }, _socket: VScript.VSocket) => [number];
    readonly StereoPanBalancePanFullLinear: (_x: {
        pan: VAPI.AudioEngine.PanValue;
    }, _socket: VScript.VSocket) => [number];
    readonly Resource: (_x: {
        used: VAPI.Primitives.Unsigned16;
        available: VAPI.Primitives.Unsigned16;
    }, _socket: VScript.VSocket) => [number, number];
    readonly CompressorARTimeSamples: (_x: {
        samples: number;
    }, _socket: VScript.VSocket) => [number];
    readonly DelayParameterSamples: (_x: {
        samples: number;
    }, _socket: VScript.VSocket) => [number];
    readonly CompressorCapabilitiesControlSidechainOnly: (_x: {}, _socket: VScript.VSocket) => [];
    readonly CompressorCurveSoftKnee: (_x: {
        threshold: VAPI.AudioEngine.CompressorGain;
        width: number;
        ratio: VAPI.AudioEngine.CompressorRatio;
    }, _socket: VScript.VSocket) => [number, number, number];
    readonly StereoMixCapabilities: (_x: {
        channels: number;
        master_fader: boolean;
    }, _socket: VScript.VSocket) => [number, boolean];
    readonly StereoPanBalance: (_x: ({
        variant: "PanCenterLinear";
        value: VAPI.AudioEngine.StereoPanBalancePanCenterLinear;
    } | {
        variant: "PanFullLinear";
        value: VAPI.AudioEngine.StereoPanBalancePanFullLinear;
    } | {
        variant: "PanConstantPower";
        value: VAPI.AudioEngine.StereoPanBalancePanConstantPower;
    } | {
        variant: "BalanceCenterLinear";
        value: VAPI.AudioEngine.StereoPanBalanceBalanceCenterLinear;
    }), _socket: VScript.VSocket) => ([0, [number]] | [1, [number]] | [2, [number]] | [3, [number]]);
    readonly CompressorARTimeTime: (_x: {
        time: VScript.Duration;
    }, _socket: VScript.VSocket) => [number];
    readonly DelayParameterTime: (_x: {
        time: VScript.Duration;
    }, _socket: VScript.VSocket) => [number];
    readonly TruePeakCapabilities: (_x: {
        channels: number;
    }, _socket: VScript.VSocket) => [number];
    readonly CompressorBandpass: (_x: {
        enabled: boolean;
        lowcut: VAPI.AudioEngine.FilterHighPass;
        highcut: VAPI.AudioEngine.FilterLowPass;
    }, _socket: VScript.VSocket) => [boolean, [number, number], [number, number]];
    readonly FilterBands: (_x: FilterBands) => string;
    readonly InfoCompressor: (_x: {
        curve_ram: VAPI.AudioEngine.Resource;
        engines: VAPI.AudioEngine.Resource;
        channels: VAPI.AudioEngine.Resource;
    }, _socket: VScript.VSocket) => [[number, number], [number, number], [number, number]];
    readonly CompressorCapabilitiesControl: (_x: ({
        variant: "Input";
        value: VAPI.AudioEngine.CompressorCapabilitiesControlInput;
    } | {
        variant: "SidechainOnly";
        value: VAPI.AudioEngine.CompressorCapabilitiesControlSidechainOnly;
    }), _socket: VScript.VSocket) => ([0, [boolean]] | [1, []]);
    readonly InfoDelays: (_x: {
        writer: VAPI.AudioEngine.Resource;
        reader: VAPI.AudioEngine.Resource;
    }, _socket: VScript.VSocket) => [[number, number], [number, number]];
    readonly DownMixLevels: (_x: {
        /**
          Master gain applied to all inputs channels
        */
        master: VAPI.AudioEngine.FaderGain;
        /**
          Gain for left (0) and right (1) inputs
        */
        l_r: VAPI.AudioEngine.FaderGain;
        /**
          Gain for center (2) input
        */
        center: VAPI.AudioEngine.FaderGain;
        /**
          Gain for LFE (Low Frequency Effects, 3) input
        */
        lfe: VAPI.AudioEngine.FaderGain;
        /**
          Gain for surround left (4) and right (5) inputs
        */
        sl_sr: VAPI.AudioEngine.FaderGain;
        /**
          Gain for surround back left (6) and right (7) inputs
        */
        sbl_sbr: VAPI.AudioEngine.FaderGain;
        /**
          Gain for top left (8) and right (9) inputs
        */
        tl_tr: VAPI.AudioEngine.FaderGain;
        /**
          Gain for top back left (10) and right (11) inputs
        */
        tbl_tbr: VAPI.AudioEngine.FaderGain;
    }, _socket: VScript.VSocket) => [number, number, number, number, number, number, number, number];
    readonly CompressorLookahead: (_x: {
        enabled: boolean;
        delay: VAPI.AudioEngine.DelayParameter;
    }, _socket: VScript.VSocket) => [boolean, ([0, [number]] | [1, [number]])];
    readonly InfoMeasurement: (_x: {
        truepeak: null | VAPI.AudioEngine.Resource;
        rms_meter: null | VAPI.AudioEngine.Resource;
        kfilter: null | VAPI.AudioEngine.Resource;
    }, _socket: VScript.VSocket) => [null | [number, number], null | [number, number], null | [number, number]];
    readonly MidSideParams: (_x: {
        gain: VAPI.AudioEngine.FaderGain;
        width: number;
        rotation: VAPI.AudioEngine.PanValue;
    }, _socket: VScript.VSocket) => [number, number, number];
};
export interface CompressorCurveAutoGain {
    cutoff: VAPI.AudioEngine.CompressorGain;
    target: VAPI.AudioEngine.CompressorGain;
    width: number;
    ratio: VAPI.AudioEngine.CompressorRatio;
}
export interface StereoPanBalanceBalanceCenterLinear {
    balance: VAPI.AudioEngine.PanValue;
}
export type CompressorARTime = ({
    variant: "Samples";
    value: VAPI.AudioEngine.CompressorARTimeSamples;
} | {
    variant: "Time";
    value: VAPI.AudioEngine.CompressorARTimeTime;
});
export interface CompressorCapabilities {
    channels: number;
    control: VAPI.AudioEngine.CompressorCapabilitiesControl;
    lookahead: boolean;
}
export type CompressorCurve = ({
    variant: "SoftKnee";
    value: VAPI.AudioEngine.CompressorCurveSoftKnee;
} | {
    variant: "HardKnee";
    value: VAPI.AudioEngine.CompressorCurveHardKnee;
} | {
    variant: "Ducking";
    value: VAPI.AudioEngine.CompressorCurveDucking;
} | {
    variant: "Gate";
    value: VAPI.AudioEngine.CompressorCurveGate;
} | {
    variant: "AutoGain";
    value: VAPI.AudioEngine.CompressorCurveAutoGain;
});
export interface CompressorCurvePoint {
    i: VAPI.AudioEngine.CompressorCurveValue;
    o: VAPI.AudioEngine.CompressorCurveValue;
    c: null | VAPI.AudioEngine.CompressorCurveValue;
}
export type CompressorCurveValue = number;
export type CompressorGain = number;
export interface CompressorParameter {
    attack: VAPI.AudioEngine.CompressorARTime;
    release: VAPI.AudioEngine.CompressorARTime;
    hold: VAPI.AudioEngine.CompressorARTime;
    gain: VAPI.AudioEngine.CompressorGain;
}
export type CompressorRatio = number;
export declare class CompressorSource implements VScript.Referenceable<"AudioEngine::Data::CompressorSource"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioEngine::Data::CompressorSource";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get brief(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.AudioEngine.CompressorSource>;
}
export interface DelayCapabilities {
    channels: number;
    taps: number;
}
export type DelayParameter = ({
    variant: "Samples";
    value: VAPI.AudioEngine.DelayParameterSamples;
} | {
    variant: "Time";
    value: VAPI.AudioEngine.DelayParameterTime;
});
export interface DownMixCapabilities {
    /**
      SURROUND_5_1 supports the first 6 inputs
      
      SURROUND_7_1 supports the first 8 inputs
      
      FULL supports all 12 inputs
    */
    channels: VAPI.AudioEngine.DownMixCapabilitiesChannels;
}
export interface CompressorCurveDucking {
    threshold: VAPI.AudioEngine.CompressorGain;
    width: number;
    gain: VAPI.AudioEngine.CompressorGain;
}
export declare class Fader implements VScript.Referenceable<"AudioEngine::Data::Fader"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioEngine::Data::Fader";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get label(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.AudioEngine.Fader>;
    /**
      A value of -128 is interpreted as -Infinity, the range is reduced to
      allow easier automatic mapping to encoders / sliders
    */
    get gain(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.AudioEngine.FaderGain, VAPI.AudioEngine.FaderGain, VAPI.AudioEngine.Fader>;
    get mute(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AudioEngine.Fader>;
    get solo(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AudioEngine.Fader>;
}
export type FaderGain = number;
export interface FilterCapabilities {
    channels: number;
    bands: number;
}
export interface FilterCoeffs {
    a0: VAPI.Primitives.Float32;
    a1: VAPI.Primitives.Float32;
    a2: VAPI.Primitives.Float32;
    b1: VAPI.Primitives.Float32;
    b2: VAPI.Primitives.Float32;
}
export type FilterFrequency = number;
export type FilterGain = number;
export interface FilterHighPass {
    fc: VAPI.AudioEngine.FilterFrequency;
    q: VAPI.AudioEngine.FilterQ;
}
export interface FilterHighShelf {
    fc: VAPI.AudioEngine.FilterFrequency;
    gain: VAPI.AudioEngine.FilterGain;
}
export interface FilterLowPass {
    fc: VAPI.AudioEngine.FilterFrequency;
    q: VAPI.AudioEngine.FilterQ;
}
export interface FilterLowShelf {
    fc: VAPI.AudioEngine.FilterFrequency;
    gain: VAPI.AudioEngine.FilterGain;
}
export type FilterParameter = ({
    variant: "LowPass";
    value: VAPI.AudioEngine.FilterLowPass;
} | {
    variant: "HighPass";
    value: VAPI.AudioEngine.FilterHighPass;
} | {
    variant: "Peak";
    value: VAPI.AudioEngine.FilterPeak;
} | {
    variant: "LowShelf";
    value: VAPI.AudioEngine.FilterLowShelf;
} | {
    variant: "HighShelf";
    value: VAPI.AudioEngine.FilterHighShelf;
});
export interface FilterPeak {
    fc: VAPI.AudioEngine.FilterFrequency;
    q: VAPI.AudioEngine.FilterQ;
    gain: VAPI.AudioEngine.FilterGain;
}
export type FilterQ = number;
export interface CompressorCurveGate {
    threshold: VAPI.AudioEngine.CompressorGain;
    width: number;
}
export declare class Group implements VScript.Referenceable<"AudioEngine::Data::Group"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioEngine::Data::Group";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get desc(): VScript.rwKeyword<VScript.VSocket, string, string, string, string, VAPI.AudioEngine.Group>;
    get parent_group(): VScript.rwKeyword<VScript.VSocket, null | string, null | string, null | VAPI.AudioEngine.Group, null | VScript.Referenceable<"AudioEngine::Data::Group"> & VScript.StronglyTypedSubtree<VScript.VSocket>, VAPI.AudioEngine.Group>;
}
export declare class GroupAsNamedTableRow extends Group {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export interface HWInputAssignment {
    value: VAPI.Primitives.Unsigned16;
}
export interface CompressorCurveHardKnee {
    threshold: VAPI.AudioEngine.CompressorGain;
    ratio: VAPI.AudioEngine.CompressorRatio;
}
export interface Info {
    engine_load: VAPI.Primitives.Normalized;
    planning_time: VScript.Duration;
    inputs: VAPI.AudioEngine.Resource;
    outputs: VAPI.AudioEngine.Resource;
    faders: VAPI.AudioEngine.Resource;
    biquads: VAPI.AudioEngine.Resource;
    delays: null | VAPI.AudioEngine.InfoDelays;
    measurement: VAPI.AudioEngine.InfoMeasurement;
    compressor: null | VAPI.AudioEngine.InfoCompressor;
}
export interface CompressorCapabilitiesControlInput {
    bandpass: boolean;
}
export interface InputTrimCapabilities {
    channels: number;
}
export interface LoudnessCapabilities {
    front_channels: number;
    surround_channels: number;
    /**
      Disable k-weighting only when using this element to control a compressor,
      the resulting Loudness measurements will then NOT match the ITU-R
      BS.1170-4
    */
    k_weighting: boolean;
}
export interface LoudnessMeasurement {
    /**
      Measured over the last 400 ms
    */
    momentary: null | number;
    /**
      Measured over the last 3 s
    */
    short_term: null | number;
    gated: null | number;
    /**
      How much data has been recorded for the gated loudness measurement so far
    */
    gated_recorded: VScript.Duration;
}
export interface MSFader {
    gain: VAPI.AudioEngine.FaderGain;
    mute: boolean;
}
export interface MidSideCapabilities {
    input_mode: VAPI.AudioEngine.MidSideCapabilitiesInputMode;
}
export interface MonoMixCapabilities {
    channels: number;
    master_fader: boolean;
}
export interface NMinus1Capabilities {
    channels: number;
}
export interface StereoPanBalancePanCenterLinear {
    pan: VAPI.AudioEngine.PanValue;
}
export interface StereoPanBalancePanConstantPower {
    pan: VAPI.AudioEngine.PanValue;
}
export interface StereoPanBalancePanFullLinear {
    pan: VAPI.AudioEngine.PanValue;
}
export type PanValue = number;
export interface Resource {
    used: VAPI.Primitives.Unsigned16;
    available: VAPI.Primitives.Unsigned16;
}
export interface CompressorARTimeSamples {
    samples: number;
}
export interface DelayParameterSamples {
    samples: number;
}
export interface CompressorCapabilitiesControlSidechainOnly {
}
export interface CompressorCurveSoftKnee {
    threshold: VAPI.AudioEngine.CompressorGain;
    width: number;
    ratio: VAPI.AudioEngine.CompressorRatio;
}
export interface StereoMixCapabilities {
    channels: number;
    master_fader: boolean;
}
export type StereoPanBalance = ({
    variant: "PanCenterLinear";
    value: VAPI.AudioEngine.StereoPanBalancePanCenterLinear;
} | {
    variant: "PanFullLinear";
    value: VAPI.AudioEngine.StereoPanBalancePanFullLinear;
} | {
    variant: "PanConstantPower";
    value: VAPI.AudioEngine.StereoPanBalancePanConstantPower;
} | {
    variant: "BalanceCenterLinear";
    value: VAPI.AudioEngine.StereoPanBalanceBalanceCenterLinear;
});
export interface CompressorARTimeTime {
    time: VScript.Duration;
}
export interface DelayParameterTime {
    time: VScript.Duration;
}
export interface TruePeakCapabilities {
    channels: number;
}
export interface CompressorBandpass {
    enabled: boolean;
    lowcut: VAPI.AudioEngine.FilterHighPass;
    highcut: VAPI.AudioEngine.FilterLowPass;
}
export declare class FilterBands implements VScript.Referenceable<"AudioEngine::Data::Filter::Bands"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioEngine::Data::Filter::Bands";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get param(): VScript.rwKeyword<VScript.VSocket, ([
        0,
        [
            number,
            number
        ]
    ] | [
        1,
        [
            number,
            number
        ]
    ] | [
        2,
        [
            number,
            number,
            number
        ]
    ] | [
        3,
        [
            number,
            number
        ]
    ] | [
        4,
        [
            number,
            number
        ]
    ]), ([
        0,
        [
            number,
            number
        ]
    ] | [
        1,
        [
            number,
            number
        ]
    ] | [
        2,
        [
            number,
            number,
            number
        ]
    ] | [
        3,
        [
            number,
            number
        ]
    ] | [
        4,
        [
            number,
            number
        ]
    ]), VAPI.AudioEngine.FilterParameter, VAPI.AudioEngine.FilterParameter, VAPI.AudioEngine.FilterBands>;
    get coeffs(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        number,
        number,
        number,
        number
    ], null | VAPI.AudioEngine.FilterCoeffs, VAPI.AudioEngine.FilterBands>;
}
/**
  SURROUND_5_1 supports the first 6 inputs
  
  SURROUND_7_1 supports the first 8 inputs
  
  FULL supports all 12 inputs
*/
export type DownMixCapabilitiesChannels = "SURROUND_5_1" | "SURROUND_7_1" | "FULL";
export interface InfoCompressor {
    curve_ram: VAPI.AudioEngine.Resource;
    engines: VAPI.AudioEngine.Resource;
    channels: VAPI.AudioEngine.Resource;
}
export type CompressorCapabilitiesControl = ({
    variant: "Input";
    value: VAPI.AudioEngine.CompressorCapabilitiesControlInput;
} | {
    variant: "SidechainOnly";
    value: VAPI.AudioEngine.CompressorCapabilitiesControlSidechainOnly;
});
export interface InfoDelays {
    writer: VAPI.AudioEngine.Resource;
    reader: VAPI.AudioEngine.Resource;
}
export type MidSideCapabilitiesInputMode = "Stereo" | "Mid_Side";
export type CompressorIssues = {
    bandpass_unavailable_capabilities: boolean;
    bandpass_unavailable_sidechain: boolean;
    control_missing: boolean;
    curve_update_delayed: boolean;
    cycle_detected: boolean;
    invalid_input_channel: boolean;
    lookahead_not_available: boolean;
};
export type DelayIssues = {
    cycle_detected: boolean;
    invalid_input_channel: boolean;
};
export type DownMixIssues = {
    cycle_detected: boolean;
    invalid_input_channel: boolean;
};
export type FilterIssues = {
    cycle_detected: boolean;
    invalid_input_channel: boolean;
};
export type InputTrimIssues = {
    cycle_detected: boolean;
    invalid_input_channel: boolean;
};
export type LoudnessIssues = {
    cant_disable_k_weighting: boolean;
    cycle_detected: boolean;
    invalid_input_channel: boolean;
};
export type MidSideIssues = {
    cycle_detected: boolean;
    invalid_input_channel: boolean;
};
export type MonoMixIssues = {
    cycle_detected: boolean;
    invalid_input_channel: boolean;
};
export type NMinus1Issues = {
    cycle_detected: boolean;
    invalid_input_channel: boolean;
};
export type StereoMixIssues = {
    cycle_detected: boolean;
    invalid_input_channel: boolean;
};
export type TruePeakIssues = {
    cycle_detected: boolean;
    invalid_input_channel: boolean;
};
export interface DownMixLevels {
    /**
      Master gain applied to all inputs channels
    */
    master: VAPI.AudioEngine.FaderGain;
    /**
      Gain for left (0) and right (1) inputs
    */
    l_r: VAPI.AudioEngine.FaderGain;
    /**
      Gain for center (2) input
    */
    center: VAPI.AudioEngine.FaderGain;
    /**
      Gain for LFE (Low Frequency Effects, 3) input
    */
    lfe: VAPI.AudioEngine.FaderGain;
    /**
      Gain for surround left (4) and right (5) inputs
    */
    sl_sr: VAPI.AudioEngine.FaderGain;
    /**
      Gain for surround back left (6) and right (7) inputs
    */
    sbl_sbr: VAPI.AudioEngine.FaderGain;
    /**
      Gain for top left (8) and right (9) inputs
    */
    tl_tr: VAPI.AudioEngine.FaderGain;
    /**
      Gain for top back left (10) and right (11) inputs
    */
    tbl_tbr: VAPI.AudioEngine.FaderGain;
}
export interface CompressorLookahead {
    enabled: boolean;
    delay: VAPI.AudioEngine.DelayParameter;
}
export interface InfoMeasurement {
    truepeak: null | VAPI.AudioEngine.Resource;
    rms_meter: null | VAPI.AudioEngine.Resource;
    kfilter: null | VAPI.AudioEngine.Resource;
}
export interface MidSideParams {
    gain: VAPI.AudioEngine.FaderGain;
    width: number;
    rotation: VAPI.AudioEngine.PanValue;
}
export type InputTrimSrc = "A" | "B";
