import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly AFVRef: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioRePlay.AFVRef;
    readonly AllocationMode: (_raw: ([0, [number]] | [1, [number]]), _socket: VScript.VSocket) => AllocationMode;
    readonly BufferInput: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioRePlay.BufferInput;
    readonly Control: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioRePlay.Control;
    readonly DolbyE: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioRePlay.DolbyE;
    readonly DolbyEDebug: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioRePlay.DolbyEDebug;
    readonly DolbyERef: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioRePlay.DolbyERef;
    readonly DolbyEWriter: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioRePlay.DolbyEWriter;
    readonly DolbyLine: (_raw: [null | number, null | number, null | number, null | number, null | number, null | number], _socket: VScript.VSocket) => DolbyLine;
    readonly InputDebug: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioRePlay.InputDebug;
    readonly OutputDebug: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioRePlay.OutputDebug;
    readonly Reader: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioRePlay.Reader;
    readonly SampleTime: (_raw: [number, number], _socket: VScript.VSocket) => SampleTime;
    readonly SamplesSettings: (_raw: [number], _socket: VScript.VSocket) => SamplesSettings;
    readonly TimeSettings: (_raw: [number], _socket: VScript.VSocket) => TimeSettings;
    readonly UploadHeader: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioRePlay.UploadHeader;
    readonly Writer: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.AudioRePlay.Writer;
    readonly BufferCurrentDelay: (_raw: [number, number, number, number, number], _socket: VScript.VSocket) => BufferCurrentDelay;
    readonly UploadHeaderDate: (_raw: [number, number, number], _socket: VScript.VSocket) => UploadHeaderDate;
    readonly UploadHeaderTimeOfDay: (_raw: [number, number, number], _socket: VScript.VSocket) => UploadHeaderTimeOfDay;
};
export declare const lower: {
    readonly AFVRef: (_x: AFVRef) => string;
    readonly AllocationMode: (_x: ({
        variant: "Samples";
        value: VAPI.AudioRePlay.SamplesSettings;
    } | {
        variant: "Time";
        value: VAPI.AudioRePlay.TimeSettings;
    }), _socket: VScript.VSocket) => ([0, [number]] | [1, [number]]);
    readonly BufferInput: (_x: BufferInput) => string;
    readonly Control: (_x: Control) => string;
    readonly DolbyE: (_x: DolbyE) => string;
    readonly DolbyEDebug: (_x: DolbyEDebug) => string;
    readonly DolbyERef: (_x: DolbyERef) => string;
    readonly DolbyEWriter: (_x: DolbyEWriter) => string;
    readonly DolbyLine: (_x: {
        earliest: null | VAPI.Primitives.Unsigned8;
        earliest_ideal: null | VAPI.Primitives.Unsigned8;
        ideal: null | VAPI.Primitives.Unsigned8;
        latest_ideal: null | VAPI.Primitives.Unsigned8;
        latest: null | VAPI.Primitives.Unsigned8;
        calculated: null | VAPI.Primitives.Unsigned16;
    }, _socket: VScript.VSocket) => [null | number, null | number, null | number, null | number, null | number, null | number];
    readonly InputDebug: (_x: InputDebug) => string;
    readonly OutputDebug: (_x: OutputDebug) => string;
    readonly Reader: (_x: Reader) => string;
    readonly SampleTime: (_x: {
        samples: number;
        time: VScript.Duration;
    }, _socket: VScript.VSocket) => [number, number];
    readonly SamplesSettings: (_x: {
        samples: number;
    }, _socket: VScript.VSocket) => [number];
    readonly TimeSettings: (_x: {
        time: VScript.Duration;
    }, _socket: VScript.VSocket) => [number];
    readonly UploadHeader: (_x: UploadHeader) => string;
    readonly Writer: (_x: Writer) => string;
    readonly BufferCurrentDelay: (_x: {
        manual_fraction: VScript.Duration;
        afv_fraction: VScript.Duration;
        dolby_e_fraction: VScript.Duration;
        as_samples: number;
        as_time: VScript.Duration;
    }, _socket: VScript.VSocket) => [number, number, number, number, number];
    readonly UploadHeaderDate: (_x: {
        year: number;
        month: number;
        day: number;
    }, _socket: VScript.VSocket) => [number, number, number];
    readonly UploadHeaderTimeOfDay: (_x: {
        hours: number;
        minutes: number;
        seconds: number;
    }, _socket: VScript.VSocket) => [number, number, number];
};
export declare class AFVRef implements VScript.Referenceable<"AudioRePlay::Data::AFVRef"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioRePlay::Data::AFVRef";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get transition_mode(): VScript.rwKeyword<VScript.VSocket, VAPI.AudioRePlay.TransitionMode, VAPI.AudioRePlay.TransitionMode, VAPI.AudioRePlay.TransitionMode, VAPI.AudioRePlay.TransitionMode, VAPI.AudioRePlay.AFVRef>;
    get audio_late(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AudioRePlay.AFVRef>;
    get audio_early(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AudioRePlay.AFVRef>;
}
export type AllocationMode = ({
    variant: "Samples";
    value: VAPI.AudioRePlay.SamplesSettings;
} | {
    variant: "Time";
    value: VAPI.AudioRePlay.TimeSettings;
});
export declare class BufferInput implements VScript.Referenceable<"AudioRePlay::Data::BufferInput"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioRePlay::Data::BufferInput";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get memory_usage(): VScript.rKeyword<VScript.VSocket, [
        number,
        number
    ], VAPI.DataRePlay.MemoryCapacity, VAPI.AudioRePlay.BufferInput>;
    get capacity(): VScript.dKeyword<VScript.VSocket, null | ([0, [number]] | [
        1,
        [number]
    ]), null | ([0, [number]] | [
        1,
        [number]
    ]), null | VAPI.AudioRePlay.AllocationMode, null | VAPI.AudioRePlay.AllocationMode, VAPI.AudioRePlay.BufferInput>;
    get setting(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        number
    ], null | VAPI.AudioRePlay.SampleTime, VAPI.AudioRePlay.BufferInput>;
    get frequency(): VScript.dKeyword<VScript.VSocket, VAPI.Audio.Frequency, VAPI.Audio.Frequency, VAPI.Audio.Frequency, VAPI.Audio.Frequency, VAPI.AudioRePlay.BufferInput>;
    get num_channels(): VScript.dKeyword<VScript.VSocket, number, number, VAPI.Audio.Channelcount, VAPI.Audio.Channelcount, VAPI.AudioRePlay.BufferInput>;
}
export type BufferMode = "Samples" | "Time";
export declare class Control implements VScript.Referenceable<"AudioRePlay::Data::Control"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioRePlay::Data::Control";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Stop
    */
    get stop(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AudioRePlay.Control>;
    /**
      @brief Play
      @desc Depending on the status of play mode. This command starts a Loop or
      Play
    */
    get play(): VScript.wKeyword<VScript.VSocket, VAPI.Primitives.Button, VAPI.Primitives.Button, VAPI.AudioRePlay.Control>;
    /**
      @brief PlayMode
      @desc Play: Plays once from start_sample till end_sample Loop: start
      playing from start_sample. Reaching the end_sample rewinds the clip and
      plays from now on in a loop from clip_start to end_sample
    */
    get play_mode(): VScript.dKeyword<VScript.VSocket, VAPI.AudioRePlay.Motion, VAPI.AudioRePlay.Motion, VAPI.AudioRePlay.Motion, VAPI.AudioRePlay.Motion, VAPI.AudioRePlay.Control>;
    get start_sample(): VScript.dKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.AudioRePlay.Control>;
    get end_sample(): VScript.dKeyword<VScript.VSocket, null | number, null | number, null | number, null | number, VAPI.AudioRePlay.Control>;
    get time(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AudioRePlay.Control>;
    get motion_status(): VScript.rKeyword<VScript.VSocket, VAPI.AudioRePlay.MotionStatus, VAPI.AudioRePlay.MotionStatus, VAPI.AudioRePlay.Control>;
}
export declare class DolbyE implements VScript.Referenceable<"AudioRePlay::Data::DolbyE"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioRePlay::Data::DolbyE";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get run_dolby_e_detector(): VScript.rwKeyword<VScript.VSocket, boolean, boolean, boolean, boolean, VAPI.AudioRePlay.DolbyE>;
    get measurement_duration(): VScript.rwKeyword<VScript.VSocket, number, number, VScript.Duration, VScript.Duration, VAPI.AudioRePlay.DolbyE>;
}
export declare class DolbyEDebug implements VScript.Referenceable<"AudioRePlay::Data::DolbyEDebug"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioRePlay::Data::DolbyEDebug";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get zero_samples_before_header(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.DolbyEDebug>;
    get free_running_counter_header_detected(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.DolbyEDebug>;
}
export declare class DolbyERef implements VScript.Referenceable<"AudioRePlay::Data::DolbyERef"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioRePlay::Data::DolbyERef";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get channel_pair(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.Primitives.Unsigned32, VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.DolbyERef>;
    get samples(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AudioRePlay.DolbyERef>;
    get time(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AudioRePlay.DolbyERef>;
    get dolby_e_line(): VScript.rKeyword<VScript.VSocket, [
        null | number,
        null | number,
        null | number,
        null | number,
        null | number,
        null | number
    ], VAPI.AudioRePlay.DolbyLine, VAPI.AudioRePlay.DolbyERef>;
}
export declare class DolbyEWriter implements VScript.Referenceable<"AudioRePlay::Data::DolbyEWriter"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioRePlay::Data::DolbyEWriter";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get free_running_counter_irq(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.DolbyEWriter>;
    get bits_irq(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.DolbyEWriter>;
    get debug(): VScript.StronglyTypedArray<VScript.VSocket, "AudioRePlay::Data::DolbyEDebug", VAPI.AudioRePlay.DolbyEDebug>;
}
export interface DolbyLine {
    earliest: null | VAPI.Primitives.Unsigned8;
    earliest_ideal: null | VAPI.Primitives.Unsigned8;
    ideal: null | VAPI.Primitives.Unsigned8;
    latest_ideal: null | VAPI.Primitives.Unsigned8;
    latest: null | VAPI.Primitives.Unsigned8;
    calculated: null | VAPI.Primitives.Unsigned16;
}
export declare class InputDebug implements VScript.Referenceable<"AudioRePlay::Data::InputDebug"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioRePlay::Data::InputDebug";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get writer_id(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.InputDebug>;
    get writer_v_idx(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.InputDebug>;
    get start_address(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.InputDebug>;
    get end_address(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.InputDebug>;
    get enable(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.InputDebug>;
}
export type Motion = "Play" | "Loop";
export type MotionStatus = "Stop" | "Play" | "Loop";
export declare class OutputDebug implements VScript.Referenceable<"AudioRePlay::Data::OutputDebug"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioRePlay::Data::OutputDebug";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get reader_id(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.OutputDebug>;
    get reader_v_idx(): VScript.rKeyword<VScript.VSocket, null | number, null | VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.OutputDebug>;
    get loop_start_address(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.OutputDebug>;
    get loop_end_address(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.OutputDebug>;
    get enable(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.OutputDebug>;
    get start_address(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.OutputDebug>;
    get start_timestamp(): VScript.rKeyword<VScript.VSocket, number, VAPI.Primitives.Unsigned32, VAPI.AudioRePlay.OutputDebug>;
}
export declare class Reader implements VScript.Referenceable<"AudioRePlay::Data::Reader"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioRePlay::Data::Reader";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AudioRePlay.Reader>;
    get debug(): VAPI.AudioRePlay.OutputDebug;
}
export interface SampleTime {
    samples: number;
    time: VScript.Duration;
}
export interface SamplesSettings {
    samples: number;
}
export interface TimeSettings {
    time: VScript.Duration;
}
export type TransitionMode = "Jump" | "V_Fade";
export declare class UploadHeader implements VScript.Referenceable<"AudioRePlay::Data::UploadHeader"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioRePlay::Data::UploadHeader";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get date(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        number,
        number
    ], null | VAPI.AudioRePlay.UploadHeaderDate, VAPI.AudioRePlay.UploadHeader>;
    get time_of_day(): VScript.rKeyword<VScript.VSocket, null | [
        number,
        number,
        number
    ], null | VAPI.AudioRePlay.UploadHeaderTimeOfDay, VAPI.AudioRePlay.UploadHeader>;
    get channels(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AudioRePlay.UploadHeader>;
    get sample_rate(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AudioRePlay.UploadHeader>;
    get bits_per_sample(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AudioRePlay.UploadHeader>;
    get samples(): VScript.rKeyword<VScript.VSocket, null | number, null | number, VAPI.AudioRePlay.UploadHeader>;
    get time(): VScript.rKeyword<VScript.VSocket, null | number, null | VScript.Duration, VAPI.AudioRePlay.UploadHeader>;
}
export declare class Writer implements VScript.Referenceable<"AudioRePlay::Data::Writer"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "AudioRePlay::Data::Writer";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get active(): VScript.rKeyword<VScript.VSocket, boolean, boolean, VAPI.AudioRePlay.Writer>;
    get debug(): VAPI.AudioRePlay.InputDebug;
    get dolby_e_debug(): VAPI.AudioRePlay.DolbyEWriter;
}
export interface BufferCurrentDelay {
    manual_fraction: VScript.Duration;
    afv_fraction: VScript.Duration;
    dolby_e_fraction: VScript.Duration;
    as_samples: number;
    as_time: VScript.Duration;
}
export interface UploadHeaderDate {
    year: number;
    month: number;
    day: number;
}
export type DelayIssues = {
    missing_buffer_allocation: boolean;
    missing_sample_setting: boolean;
    missing_time_setting: boolean;
    missing_timesource: boolean;
    out_of_bounds: boolean;
    out_of_memory: boolean;
    out_of_readers: boolean;
    out_of_writers: boolean;
    too_small_for_dolby_e_alignment: boolean;
};
export type PlayerIssues = {
    missing_timesource: boolean;
    out_of_memory: boolean;
    out_of_readers: boolean;
};
export interface UploadHeaderTimeOfDay {
    hours: number;
    minutes: number;
    seconds: number;
}
export declare const Enums: {
    readonly TransitionMode: TransitionMode[];
    readonly MotionStatus: MotionStatus[];
    readonly Motion: Motion[];
    readonly BufferMode: BufferMode[];
};
