import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    All: (_raw) => (new All(_raw)),
    Generator: (_raw) => (new Generator(_raw)),
};
export const lower = {
    All: (_x) => _x.raw.kwl,
    Generator: (_x) => _x.raw.kwl,
};
export class All {
    raw;
    type_identifier = "ClosXBar::Data::All";
    constructor(raw) {
        this.raw = raw;
    }
    get start_generator() {
        return new VScript.StronglyTypedTable(VScript.VAPIHelpers.subtree_table_child_checked(this.raw, 0, "start_generator"), (raw, _) => VAPI.ClosXBar.lift.Generator(raw));
    }
}
export class Generator {
    raw;
    type_identifier = "ClosXBar::Data::Generator";
    constructor(raw) {
        this.raw = raw;
    }
    get used_config() {
        return new VScript.rKeyword(this, "used_config", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      time to write into the hardware. At this pointer the hardware gets
      informed to perform the switch
    */
    get write_hw() {
        return new VScript.rKeyword(this, "write_hw", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
        });
    }
    /**
      switching time
    */
    get calculated_sw_time() {
        return new VScript.rKeyword(this, "calculated_sw_time", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
        });
    }
    /**
      switching time
    */
    get interrupt_sw_time() {
        return new VScript.rKeyword(this, "interrupt_sw_time", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
        });
    }
    /**
      difference between calculated and interrupt time
    */
    get delta_calc_irq() {
        return new VScript.rKeyword(this, "delta_calc_irq", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
        });
    }
    /**
      difference between write hardware and interrupt time
    */
    get delta_write_hw_irq() {
        return new VScript.rKeyword(this, "delta_write_hw_irq", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.liftNanoseconds),
            lower: VScript.VAPIHelpers.liftOrLowerNullable(VScript.VAPIHelpers.lowerNanoseconds)
        });
    }
}
