import * as VScript from "vscript";
import * as VAPI from "./index.js";
export declare const lift: {
    readonly ClusterMultiviewerHeadReference: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterProcessors.ClusterMultiviewerHeadReference;
    readonly ClusterMultiviewerLocalConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterProcessors.ClusterMultiviewerLocalConfiguration;
    readonly ClusterProcessorMipMapsInputRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterProcessors.ClusterProcessorMipMapsInputRuntime;
    readonly ClusterProcessorsLocalConfiguration: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterProcessors.ClusterProcessorsLocalConfiguration;
    readonly ClusterProcessorsPPMSRuntime: (_raw: VScript.DataViews.Subtree<VScript.VSocket>) => VAPI.ClusterProcessors.ClusterProcessorsPPMSRuntime;
};
export declare const lower: {
    readonly ClusterMultiviewerHeadReference: (_x: ClusterMultiviewerHeadReference) => string;
    readonly ClusterMultiviewerLocalConfiguration: (_x: ClusterMultiviewerLocalConfiguration) => string;
    readonly ClusterProcessorMipMapsInputRuntime: (_x: ClusterProcessorMipMapsInputRuntime) => string;
    readonly ClusterProcessorsLocalConfiguration: (_x: ClusterProcessorsLocalConfiguration) => string;
    readonly ClusterProcessorsPPMSRuntime: (_x: ClusterProcessorsPPMSRuntime) => string;
};
export declare class ClusterMultiviewerHeadReference implements VScript.Referenceable<"ClusterProcessors::Data::ClusterMultiviewerHeadReference"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterProcessors::Data::ClusterMultiviewerHeadReference";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get head_id(): VScript.rwKeyword<VScript.VSocket, number, number, VAPI.ClusterProcessors.MultiviewerHeadID, VAPI.ClusterProcessors.MultiviewerHeadID, VAPI.ClusterProcessors.ClusterMultiviewerHeadReference>;
}
export declare class ClusterMultiviewerHeadReferenceAsNamedTableRow extends ClusterMultiviewerHeadReference {
    readonly raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>;
    readonly index: number;
    constructor(raw: VScript.DataViews.SubtreeNamedTableRow<VScript.VSocket>);
    rename(name: string, opts?: VScript.CommonWriteOptions): Promise<void>;
    row_name(opts?: VScript.CommonCommandOptions): Promise<string>;
    delete(opts?: VScript.CommonWriteOptions): Promise<void>;
}
export declare class ClusterMultiviewerLocalConfiguration implements VScript.Referenceable<"ClusterProcessors::Data::ClusterMultiviewerLocalConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterProcessors::Data::ClusterMultiviewerLocalConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get heads(): VScript.StronglyTypedNamedTable<VScript.VSocket, "ClusterProcessors::Data::ClusterMultiviewerHeadReference", VAPI.ClusterProcessors.ClusterMultiviewerHeadReferenceAsNamedTableRow>;
}
export declare class ClusterProcessorMipMapsInputRuntime implements VScript.Referenceable<"ClusterProcessors::Data::ClusterProcessorMipMapsInputRuntime"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterProcessors::Data::ClusterProcessorMipMapsInputRuntime";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    /**
      Source IP address of the mipmap RTP stream
    */
    get src_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.ClusterProcessors.ClusterProcessorMipMapsInputRuntime>;
    /**
      Destination IP address of the mipmap RTP stream
    */
    get dest_ip_address(): VScript.rKeyword<VScript.VSocket, null | string, null | string, VAPI.ClusterProcessors.ClusterProcessorMipMapsInputRuntime>;
    get interface(): VScript.rKeyword<VScript.VSocket, null | string, null | VAPI.NetworkInterfaces.VirtualInterface, VAPI.ClusterProcessors.ClusterProcessorMipMapsInputRuntime>;
    get metadata(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.ClusterProcessors.ClusterProcessorMipMapsInputRuntime>;
}
export declare class ClusterProcessorsLocalConfiguration implements VScript.Referenceable<"ClusterProcessors::Data::ClusterProcessorsLocalConfiguration"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterProcessors::Data::ClusterProcessorsLocalConfiguration";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get multiviewer(): VAPI.ClusterProcessors.ClusterMultiviewerLocalConfiguration;
}
export declare class ClusterProcessorsPPMSRuntime implements VScript.Referenceable<"ClusterProcessors::Data::ClusterProcessorsPPMSRuntime"> {
    readonly raw: VScript.DataViews.Subtree<VScript.VSocket>;
    readonly type_identifier: "ClusterProcessors::Data::ClusterProcessorsPPMSRuntime";
    constructor(raw: VScript.DataViews.Subtree<VScript.VSocket>);
    get source_sdp(): VScript.rKeyword<VScript.VSocket, string, string, VAPI.ClusterProcessors.ClusterProcessorsPPMSRuntime>;
    get source_channels_num(): VScript.rKeyword<VScript.VSocket, number, number, VAPI.ClusterProcessors.ClusterProcessorsPPMSRuntime>;
}
export type MultiviewerHeadID = number;
export type VideoStandard = "HD1080p50" | "HD1080p59_94" | "HD1080p60" | "HD2160p50" | "HD2160p59_94" | "HD2160p60";
export declare const Enums: {
    readonly VideoStandard: VideoStandard[];
};
