import * as VScript from "vscript";
import * as VAPI from "./index.js";
export const lift = {
    ClusterMultiviewerHeadReference: (_raw) => (new ClusterMultiviewerHeadReference(_raw)),
    ClusterMultiviewerLocalConfiguration: (_raw) => (new ClusterMultiviewerLocalConfiguration(_raw)),
    ClusterProcessorMipMapsInputRuntime: (_raw) => (new ClusterProcessorMipMapsInputRuntime(_raw)),
    ClusterProcessorsLocalConfiguration: (_raw) => (new ClusterProcessorsLocalConfiguration(_raw)),
    ClusterProcessorsPPMSRuntime: (_raw) => (new ClusterProcessorsPPMSRuntime(_raw)),
};
export const lower = {
    ClusterMultiviewerHeadReference: (_x) => _x.raw.kwl,
    ClusterMultiviewerLocalConfiguration: (_x) => _x.raw.kwl,
    ClusterProcessorMipMapsInputRuntime: (_x) => _x.raw.kwl,
    ClusterProcessorsLocalConfiguration: (_x) => _x.raw.kwl,
    ClusterProcessorsPPMSRuntime: (_x) => _x.raw.kwl,
};
export class ClusterMultiviewerHeadReference {
    raw;
    type_identifier = "ClusterProcessors::Data::ClusterMultiviewerHeadReference";
    constructor(raw) {
        this.raw = raw;
    }
    get head_id() {
        return new VScript.rwKeyword(this, "head_id", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        }, null);
    }
}
export class ClusterMultiviewerHeadReferenceAsNamedTableRow extends ClusterMultiviewerHeadReference {
    raw;
    index;
    constructor(raw) {
        super(raw);
        this.raw = raw;
        this.index = raw.index;
    }
    async rename(name, opts) { await this.raw.rename(name, opts); }
    async row_name(opts) { return await this.raw.row_name(opts); }
    async delete(opts) { await this.raw.delete(opts); }
}
export class ClusterMultiviewerLocalConfiguration {
    raw;
    type_identifier = "ClusterProcessors::Data::ClusterMultiviewerLocalConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get heads() {
        return new VScript.StronglyTypedNamedTable(VScript.VAPIHelpers.subtree_named_table_child_checked(this.raw, 0, "heads"), (raw) => new VAPI.ClusterProcessors.ClusterMultiviewerHeadReferenceAsNamedTableRow(raw));
    }
}
export class ClusterProcessorMipMapsInputRuntime {
    raw;
    type_identifier = "ClusterProcessors::Data::ClusterProcessorMipMapsInputRuntime";
    constructor(raw) {
        this.raw = raw;
    }
    /**
      Source IP address of the mipmap RTP stream
    */
    get src_ip_address() {
        return new VScript.rKeyword(this, "src_ip_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    /**
      Destination IP address of the mipmap RTP stream
    */
    get dest_ip_address() {
        return new VScript.rKeyword(this, "dest_ip_address", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get interface() {
        return new VScript.rKeyword(this, "interface", {
            lift: VScript.VAPIHelpers.liftOrLowerNullable((raw_kwl, _socket) => new VAPI.NetworkInterfaces.VirtualInterface(VScript.VAPIHelpers.get_subtree(_socket, raw_kwl))),
            lower: VScript.VAPIHelpers.liftOrLowerNullable((x, _) => x.raw.kwl)
        });
    }
    get metadata() {
        return new VScript.rKeyword(this, "metadata", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export class ClusterProcessorsLocalConfiguration {
    raw;
    type_identifier = "ClusterProcessors::Data::ClusterProcessorsLocalConfiguration";
    constructor(raw) {
        this.raw = raw;
    }
    get multiviewer() {
        return VAPI.ClusterProcessors.lift.ClusterMultiviewerLocalConfiguration(VScript.VAPIHelpers.subtree_child_checked(this.raw, 0, "multiviewer"));
    }
}
export class ClusterProcessorsPPMSRuntime {
    raw;
    type_identifier = "ClusterProcessors::Data::ClusterProcessorsPPMSRuntime";
    constructor(raw) {
        this.raw = raw;
    }
    get source_sdp() {
        return new VScript.rKeyword(this, "source_sdp", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
    get source_channels_num() {
        return new VScript.rKeyword(this, "source_channels_num", {
            lift: (x /* FIXME */, _) => x,
            lower: (x /* FIXME */, _) => x
        });
    }
}
export const Enums = {
    VideoStandard: ["HD1080p50", "HD1080p59_94", "HD1080p60", "HD2160p50", "HD2160p59_94", "HD2160p60"]
};
